/*
 *
 *  $Id: icomando.h 3849 2011-05-16 13:26:20Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once
#include <list>
#include "icontroladorprogreso.h"
#include "iproxynotificadorprogreso.h"

//---------------------------------------------------------------------------------------
//region Forward declarations
namespace GNC {
	class LanzadorComandos;
	class INotificadorProgreso;

	namespace GCS {
		class IComando;

		class ControladorComandos;
	}
}
//endregion

namespace GNC {
	namespace GCS {

		//---------------------------------------------------------------------------------------
		class EXTAPI IComandoParams {
		public:
			IComandoParams() {}
			virtual ~IComandoParams() {}
		};

		//---------------------------------------------------------------------------------------
		class EXTAPI IComandoResult {
		public:
			IComandoResult() { }
			virtual ~IComandoResult() { }
		};

		class EXTAPI TipoListaIdComandos : public std::list< int, std::allocator<int> > {};

		//---------------------------------------------------------------------------------------
		class EXTAPI IComando : public GNC::IProxyNotificadorProgreso {
		public:


			//---------------------------------------------------------------------------------------
			//region Constructor y destructor

		public:

			IComando(IComandoParams* pParams, const std::string& name = "Comando", void* pOwner = NULL) {
				m_pParams = pParams;
				m_pResult = NULL;
				m_pNotificadorProgreso = NULL;
				m_Abortado = false;
				m_Nombre = name;
				m_pOwner = pOwner;
				if (m_Nombre.size() == 0)
				{
						m_Nombre = "Comando";
				}
				NotificarProgreso(0.0f, m_Nombre);
			}

			virtual ~IComando() {
				if (m_pResult != 0) {
						delete m_pResult;
						m_pResult = 0;
				}
				if (m_pParams != 0) {
						delete m_pParams;
						m_pParams = 0;
				}
				OnDestroy();
			}

			//endregion

			//---------------------------------------------------------------------------------------
			//region Interfaz especifica
		protected:

			virtual void Execute() = 0;

			virtual void Update() = 0;

		public:

			/** Notifica el progreso. Si devuelve true, el ejecutor dejara de procesarse **/
			virtual bool NotificarProgreso(float progresoNormalizado, const std::string& texto)
			{
				if (m_Abortado) {
						return false;
				}

				if (m_pNotificadorProgreso != NULL) {
						return m_pNotificadorProgreso->NotificarProgreso(progresoNormalizado, texto);
				}

				return true;
			}

		protected:

			/** Callback que puede ser sobrecargado por el sujeto para incluir acciones especificas cuando se aborta el comando **/
			virtual void OnAbort() {}

			/** Callback que puede ser sobrecargado por el sujeto para incluir acciones especificas cuando se destruye el comando **/
			virtual void OnDestroy() {}

			//endregion

			//---------------------------------------------------------------------------------------
			//region Getters y helpers
		public:

			inline int GetId() const {
				return m_Id;
			}

			inline void SetId(int id) {
				m_Id = id;
			}

			inline void SetOwner(void* pOwner)
			{
				m_pOwner = pOwner;
			}

			inline void* GetOwner() const
			{
				return m_pOwner;
			}

			inline const std::string& GetName() const
			{
				return m_Nombre;
			}

			inline void Abort() {
				m_Abortado = true;
				OnAbort();
			}

			inline bool EstaAbortado() const {
				return m_Abortado;
			}

			//endregion

			//---------------------------------------------------------------------------------------
			//region Notificacion

		private:
			// Este metodo debe ser invocado solo por el lanzador de comandos.
			inline void SetNotificadorProgreso(GNC::INotificadorProgreso* pNotificador)
			{
				m_pNotificadorProgreso = pNotificador;
			}
			//endregion

			//---------------------------------------------------------------------------------------
			//region "Gestion de Dependencias"

		protected:

			inline void EsperaA(int idDep)
			{
				m_Dependencias.push_back(idDep);
			}

			inline void AbortaSi(int idConflicto)
			{
				m_Conflictos.push_back(idConflicto);
			}

			inline void CancelaA(int idReemplazo) {
				m_Reemplazos.push_back(idReemplazo);
			}

			TipoListaIdComandos   m_Dependencias;
			TipoListaIdComandos   m_Conflictos;
			TipoListaIdComandos   m_Reemplazos;
			//endregion


			//---------------------------------------------------------------------------------------
			//region "Atributos"

		protected:
			IComandoParams*            m_pParams;
			IComandoResult*            m_pResult;

		private:
			int                        m_Id;
			std::string                m_Nombre;
			bool                       m_Abortado;
			GNC::INotificadorProgreso* m_pNotificadorProgreso;
			void*                      m_pOwner;

			friend class GNC::LanzadorComandos;
			friend class GNC::GCS::ControladorComandos;

			//endregion
		};
	}
}
