/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  toolbarsignals.cc - Gtk::Toolbar virtual signal handlers.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "toolbar.hh"
#include "toolbarsignals.hh"
#include "private/toolbarclass.hh"

using namespace GFC;

/*  Gtk::ToolbarSignals
 */

Gtk::ToolbarSignals::ToolbarSignals(Toolbar *toolbar)
: ContainerSignals(toolbar)
{
	Gtk::ToolbarClass::init(GTK_TOOLBAR_GET_CLASS(toolbar->gtk_toolbar()));
}

Gtk::ToolbarSignals::~ToolbarSignals()
{
}
	
void
Gtk::ToolbarSignals::on_orientation_changed(Orientation orientation)
{
	GtkToolbarClass *g_class = ToolbarClass::get_parent_class(instance_);
	if (g_class->orientation_changed)
		g_class->orientation_changed((GtkToolbar*)instance_, (GtkOrientation)orientation);
}

void
Gtk::ToolbarSignals::on_style_changed(ToolbarStyle style)
{
	GtkToolbarClass *g_class = ToolbarClass::get_parent_class(instance_);
	if (g_class->style_changed)
		g_class->style_changed((GtkToolbar*)instance_, (GtkToolbarStyle)style);
}

bool
Gtk::ToolbarSignals::on_popup_context_menu(int x, int y, int button_number)
{
	bool result = false;
	GtkToolbarClass *g_class = ToolbarClass::get_parent_class(instance_);
	if (g_class->popup_context_menu)
		result = g_class->popup_context_menu((GtkToolbar*)instance_, x, y, button_number);
	return result;
}

/*  Gtk::ToolbarClass
 */

void
Gtk::ToolbarClass::init(GtkToolbarClass *g_class)
{
	g_class->orientation_changed = &orientation_changed_proxy;
	g_class->style_changed = &style_changed_proxy;
	g_class->popup_context_menu = &popup_context_menu_proxy;
}

GtkToolbarClass*
Gtk::ToolbarClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_TOOLBAR_GET_CLASS(instance));
	return static_cast<GtkToolbarClass*>(ptr);
}

GType
Gtk::ToolbarClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_TOOLBAR);
	}
	return type;
}

void*
Gtk::ToolbarClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::ToolbarClass::orientation_changed_proxy(GtkToolbar *toolbar, GtkOrientation orientation)
{
	void *ptr = g_object_get_qdata((GObject*)toolbar, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ToolbarSignals*>(ptr)->on_orientation_changed((Orientation)orientation);
	else
	{
		GtkToolbarClass *g_class = ToolbarClass::get_parent_class(toolbar);
		if (g_class->orientation_changed)
			g_class->orientation_changed(toolbar, orientation);
	}
}

void
Gtk::ToolbarClass::style_changed_proxy(GtkToolbar *toolbar, GtkToolbarStyle style)
{
	void *ptr = g_object_get_qdata((GObject*)toolbar, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ToolbarSignals*>(ptr)->on_style_changed((ToolbarStyle)style);
	else
	{
		GtkToolbarClass *g_class = ToolbarClass::get_parent_class(toolbar);
		if (g_class->style_changed)
			g_class->style_changed(toolbar, style);
	}
}

gboolean
Gtk::ToolbarClass::popup_context_menu_proxy(GtkToolbar *toolbar, gint x, gint y, gint button_number)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)toolbar, G::ObjectSignals::quark());
	if (ptr)
		result = static_cast<ToolbarSignals*>(ptr)->on_popup_context_menu(x, y, button_number);
	else
	{
		GtkToolbarClass *g_class = ToolbarClass::get_parent_class(toolbar);
		if (g_class->popup_context_menu)
			result = g_class->popup_context_menu(toolbar, x, y, button_number);
	}
	return result;
}

