/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
/// @file gfc/gtk/editablesignals.hh
/// @brief Gtk::Editable virtual signal handlers.
///
/// Provides Gtk::EditableSignals, an abstract base class that implements
/// the overridable virtual signal handlers for Gtk::Editable objects.

#ifndef GFC_GTK_EDITABLE_SIGNALS_HH
#define GFC_GTK_EDITABLE_SIGNALS_HH

#ifndef GFC_G_TYPE_HH
#include <gfc/glib/type.hh>
#endif

namespace GFC {

namespace Gtk {

/// @class EditableSignals editable.hh gfc/gtk/impl/editable.hh
/// @brief Abstract base class that implements the virtual signal handlers for Gtk::Editable.

class EditableSignals : public virtual G::TypeInterface
{
protected:
/// @name Constructors
/// @{

	EditableSignals(Editable *editable);
	///< Construct a new EditableSignals object.
	///< @param editable A Editable inheriting the EditableSignals implementation.
	
	virtual ~EditableSignals() = 0;
	///< Destructor.

/// @}

public:
/// @name Signal Handlers
/// @{

	virtual void on_insert_text(const String& text, int *position);
	///< Called when text is inserted into the widget by the user.
	///< @param text The new text to insert.
	///< @param position The position at which to insert the new text.
	///<
	///< <BR>Position is an in-out paramter. After the signal emission is finished, it should
	///< point after the newly inserted text. The default handler for this signal will normally
	///< be responsible for inserting the text, so by overriding this method and either calling
	///< or not calling the parent class method, it is possible to modify the inserted text,
	///< or prevent it from being inserted entirely.

	virtual void on_delete_text(int start_pos, int end_pos);
	///< Called when text is deleted from the widget by the user.
	///< @param start_pos The starting position.
	///< @param end_pos The end position.
	///<
	///< <BR>The default handler for this signal will normally be responsible for deleting
	///< the text, so by overriding this method and either calling or not calling the parent
	///< class method, it is possible to modify the deleted text, or prevent it from being
	///< deleted entirely. The start_pos and end_pos parameters are interpreted as for
	///< delete_text()

	virtual void on_changed();
	///< Called when the user changes the contents of the widget.

/// @}
};

} // namespace Gtk

} // namespace GFC

#endif // GFC_GTK_EDITABLE_SIGNALS_HH

