/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  bitmap.cc - GdkBitmap C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "bitmap.hh"
#include "window.hh"

using namespace GFC;

Gdk::Bitmap::Bitmap(GdkBitmap *bitmap, bool owns_reference)
: Pixmap((GdkPixmap*)bitmap, owns_reference)
{
}
	
Gdk::Bitmap::Bitmap(const char *data, int width, int height)
: Pixmap((GdkPixmap*)gdk_bitmap_create_from_data(0, data, width, height))
{
}

Gdk::Bitmap::Bitmap(const Window& window, const char *data, int width, int height)
: Pixmap((GdkPixmap*)gdk_bitmap_create_from_data(window.gdk_window(), data, width, height))
{
}

Gdk::Bitmap::~Bitmap() 
{
}

