/*
  TO DO:
  Remove Timer
  Remove Subspace option and maybe add an option for restricting to an arbitrary polyhedral cone instead.
  Remove Minkowski code
 */

#include "parser.h"
#include "printer.h"
#include "polynomial.h"
#include "division.h"
#include "buchberger.h"
#include "wallideal.h"
#include "lp.h"
#include "reversesearch.h"
#include "breadthfirstsearch.h"
#include "termorder.h"
#include "ep_standard.h"
#include "ep_xfig.h"
#include "gfanapplication.h"
#include "timer.h"
#include "log.h"

static Timer globalTimer("Global-timer",1);

class GCats : public GFanApplication
{
  SimpleOption optionInputIsGroebnerBasis;
  SimpleOption optionSymmetry;
  SimpleOption optionEchoSymmetry;
  SimpleOption optionSubspace;
  //  SimpleOption optionPerformanceTimer;
  SimpleOption optionDisableSymmetryTest;
public:
  const char *helpText()
  {
    return "This is a program for computing all reduced Groebner bases of a polynomial ideal. It takes a generating set for the ideal as input. By default the enumeration is done by an almost memoryless reverse search. If the ideal is symmetric the symmetry option is useful and enumeration will be done up to symmetry using a breadth first search. The program needs a starting Groebner basis to do its computations. If the -g option is not specified it will compute one using Buchberger's algorithm.\n";
  }
  GCats():
    //    optionPerformanceTimer("-T",
    // 			   "Enable performance timer.\n"),
    optionInputIsGroebnerBasis("-g",
			       "Tells the program that the input is already a Groebner basis (with the initial term of each polynomial being "
			       "the first ones listed). Use this option if it takes too much time to compute "
			       "the starting (standard degree lexicographic) Groebner basis and the input is already a Groebner basis.\n"),
    optionSymmetry("--symmetry",
		   "Tells the program to read in generators for a group of symmetries (subgroup of $S_n$) after having read in the ideal. The program checks that the ideal stays fixed when permuting the variables with respect to elements in the group. The program uses breadth first search to compute the set of reduced Groebner bases up to symmetry with respect to the specified subgroup.\n"),
    optionEchoSymmetry("-e","Echo. Output the generators for the symmetry group.\n"),
    optionSubspace("--subspace",
		   "Only do breadth first search on cones with their interior intersecting a specified subspace. The subspace is given by a list of hyperplane normals at the end of the input. The intersection of the hyperplanes is the subspace being specified. Note that the set of Groebner cones intersecting the subspace could be disconnected and that only one connected component is computed. Works only together with --symmetry.\n"),
    optionDisableSymmetryTest("--disableSymmetryTest","When using --symmetry this option will disable the check that the group read off from the input actually is a symmetry group with respect to the input ideal.\n")
  {
    registerOptions();
  }    

  char *name()
  {
    return "";
  }

  int main()
  {
    bool minkowski=false;//Does the Minkowski sum trick work?
    //    Field::printList(Stderr);

    //    LpSolver::printList(Stderr);
    //    lpSetSolver("cddgmp");
     
    /*    FieldElement a(2);
    FieldElement b(3);
    b*=a;
    AsciiPrinter(Stdout).printFieldElement(a+b);

    return 1;
    */
    LexicographicTermOrder myOrder;
    
    PolynomialSet g=FileParser(Stdin).parsePolynomialSetWithRing();
    
    log3 AsciiPrinter(Stderr).printPolynomialSet(g);
    AsciiPrinter(Stdout).printPolynomialRing(g.getRing());

    printf("\n");

    EnumerationFilePrinter *ep;

    {
      ep=new StandardEnumerationPrinter();
    }


    bool outputLatex=true;
    
    Printer *P;
    LatexPrinter *Q;
    FILE *latexFile;    

    globalTimer.on();
    if(!minkowski)
    {
      if(optionInputIsGroebnerBasis.getValue())
	{
	  log1 fprintf(Stderr,"Minimizing and autoreducing input...\n");
	  minimize(&g);
	  autoReduce(&g, LexicographicTermOrder());
	}
      else
	{
	  log1 fprintf(Stderr,"Computing Groebner Basis...\n");
	  buchberger(&g,StandardGradedLexicographicTermOrder());
	  log2 AsciiPrinter(Stderr).printPolynomialSet(g);
	}
      log1 fprintf(Stderr,"A reduced Groebner basis has been computed\n");
    }
      
    SymmetryGroup s(g.numberOfVariablesInRing());

    {
      EnumerationAlgorithm *rs;
      if(optionSymmetry.getValue())
	{
	  IntegerVectorList generators=FileParser(Stdin).parseIntegerVectorList();
	  if(!minkowski)
	    if(!optionDisableSymmetryTest.getValue())
	      {
		for(IntegerVectorList::iterator i=generators.begin();i!=generators.end();i++)
		  {
		    //      fprintf(Stderr,"testing\n");
		    assert(areIdealsEqual(g,SymmetryGroup::permutePolynomialSet(g,*i)));
		  }
	      }

	  s.computeClosure(generators);
	  log1 s.print(Stderr);
	  BreadthFirstSearch *bs=new BreadthFirstSearch(s,minkowski);
	  if(optionSubspace.getValue())
	    bs->setSubspace(FileParser(Stdin).parseIntegerVectorList());
	  rs=bs;

	  if(optionEchoSymmetry.getValue())
	    AsciiPrinter(Stdout).printVectorList(generators);
	}
      else
	rs=new ReverseSearch(myOrder);

      //      rs->setProgressPrinting(true);
      ep->open(Stdout);
      rs->setEnumerationTarget(ep);
      log1
	{
	  fprintf(Stderr,"Enumerating...\n");
	}
      rs->enumerate(g);
      delete rs;
    }      

    ep->close();
    delete ep;

    printf("\n");
    globalTimer.off();
	//    if(optionPerformanceTimer.getValue())Timer::printList();
 
    return 0;
  }
};

static GCats theApplication;

