#include "printer.h"
#include "parser.h"
#include "gfanapplication.h"
#include "division.h"
#include "log.h"

class DoesIdealContainApplication : public GFanApplication
{
public:
  const char *helpText()
  {
    return "This program takes a marked Groebner basis of an ideal I and a set of polynomials on its input and tests if the polynomial set is contained in I by applying the division algorithm for each element. The output is 1 for true and 0 for false.\n";
  }
  DoesIdealContainApplication()
  {
    registerOptions();
  }
  char *name()
  {
    return "_doesidealcontain";
  }
  int main()
  {
    FileParser P(Stdin);
    PolynomialSet a=P.parsePolynomialSetWithRing();
    PolynomialSet b=P.parsePolynomialSet(a.getRing());

    bool c=true;
    for(PolynomialSet::const_iterator i=b.begin();i!=b.end();i++)
      {
	Polynomial remainder=division(*i,a,LexicographicTermOrder());
	log2 AsciiPrinter(Stderr).printString("Remainder: ");
	log2 AsciiPrinter(Stderr).printPolynomial(remainder);
	log2 AsciiPrinter(Stderr).printNewLine();
	if(!remainder.isZero())
	  {
	    log1 AsciiPrinter(Stderr).printString("Polynomial not in ideal: ");
	    log1 AsciiPrinter(Stderr).printPolynomial(*i);
	    log1 AsciiPrinter(Stderr).printNewLine();
	    c=false;
	    break;
	  }
      }
    AsciiPrinter(Stdout).printInteger(c);
    AsciiPrinter(Stdout).printNewLine();

    return 0;
  }
};

static DoesIdealContainApplication theApplication;
