#include "parser.h"
#include "printer.h"
#include "polynomial.h"
#include "division.h"
#include "buchberger.h"
#include "wallideal.h"
#include "lp.h"
#include "reversesearch.h"
#include "termorder.h"
#include "gfanapplication.h"
#include "wallideal.h"

class AddApplication : public GFanApplication
{
public:
  bool includeInDefaultInstallation()
  {
    return false;
  }
  const char *helpText()
  {
    return "This program adds two polynomials.\n";
  }
  AddApplication()
  {
    registerOptions();
  }
  
  char *name()
  {
    return "_add";
  }

  int main()
  {
    LpSolver::printList(Stderr);
    lpSetSolver("cddgmp");
    
    FileParser P(Stdin);

    PolynomialRing R=P.parsePolynomialRing();
    PolynomialSet s=P.parsePolynomialSet(R);

    Polynomial sum(R);
    for(PolynomialSet::const_iterator i=s.begin();i!=s.end();i++)
      sum+=*i;
    
    AsciiPrinter(Stdout).printPolynomial(sum);
    
    return 0;
  }
};

static AddApplication theApplication;
