.\" @(#)$RCSfile: gfal_lseek_python.man,v $ $Revision: 1.1 $ $Date: 2008/12/18 13:19:12 $ CERN Remi Mollon
.\" Copyright (C) 2009 by CERN
.\" All rights reserved
.\"
.TH GFAL_LSEEK 3 "$Date: 2008/12/18 13:19:12 $" GFAL "Library Functions"

.SH NAME
gfal_lseek \- position a file

.SH SYNOPSIS
\fBimport gfal\fR
.sp
.BI "off_t gfal_lseek (int " fd ,
.BI "long " offset ,
.BI "int " whence );
.sp
.BI "off64_t gfal_lseek64 (int " fd ,
.BI "long " offset ,
.BI "int " whence );

.SH DESCRIPTION
.B gfal_lseek
positions/repositions to
.I offset
the file associated with the descriptor
.I fd
generated by a previous
.BR gfal_open .
.I whence
indicates how to interpret the
.I offset
value:
.RS
.TP 1.3i
.B gfal.SEEK_SET
The offset is set from beginning of file.
.TP
.B gfal.SEEK_CUR
The offset is added to current position.
.TP
.B gfal.SEEK_END
The offset is added to current file size.
.RE
.sp
.B gfal_lseek64
performs the same function on large files using off64_t rather than off_t.

.SH RETURN VALUE
This routine returns the actual offset from the beginning of the file if the
operation was successful or -1 if the operation failed. In the latter case,
.B errno
is set appropriately.

.SH ERRORS
.TP 1.3i
.B EBADF
.I fd
is not a valid file descriptor.
.TP
.B EINVAL
incorrect value for
.IR whence .
.TP
.B EFBIG
Resulting offset is too big to fit in off_t.
.TP
.B ECOMM
Communication error.
.TP
.B EPROTONOSUPPORT
Access method not supported.

.SH SEE ALSO
.BR gfal_python (3) ,
.BR gfal_init_python (3) ,
.BR gfal_internal_free_python (3) ,
.BR gfal_deletesurls_python (3) ,
.BR gfal_removedir_python (3) ,
.BR gfal_get_python (3) ,
.BR gfal_getstatus_python (3) ,
.BR gfal_ls_python (3) ,
.BR gfal_pin_python (3) ,
.BR gfal_prestage_python (3) ,
.BR gfal_prestagestatus_python (3) ,
.BR gfal_release_python (3) ,
.BR gfal_abortrequest_python (3) ,
.BR gfal_abortfiles_python (3) ,
.BR gfal_set_xfer_done_python (3) ,
.BR gfal_set_xfer_running_python (3) ,
.BR gfal_turlsfromsurls_python (3) ,
.BR gfal_get_ids_python (3) ,
.BR gfal_set_ids_python (3) ,
.BR gfal_get_results_python (3) ,
.BR gfal_access_python (3) ,
.BR gfal_chmod_python (3) ,
.BR gfal_close_python (3) ,
.BR gfal_closedir_python (3) ,
.BR gfal_creat_python (3) ,
.BR gfal_get_timeout_connect_python (3) ,
.BR gfal_get_timeout_sendreceive_python (3) ,
.BR gfal_get_timeout_bdii_python (3) ,
.BR gfal_get_timeout_srm_python (3) ,
.BR gfal_set_timeout_connect_python (3) ,
.BR gfal_set_timeout_sendreceive_python (3) ,
.BR gfal_set_timeout_bdii_python (3) ,
.BR gfal_set_timeout_srm_python (3) ,
.BR gfal_lseek_python (3) ,
.BR gfal_mkdir_python (3) ,
.BR gfal_open_python (3) ,
.BR gfal_opendir_python (3) ,
.BR gfal_read_python (3) ,
.BR gfal_rename_python (3) ,
.BR gfal_rmdir_python (3) ,
.BR gfal_stat_python (3) ,
.BR gfal_unlink_python (3) ,
.BR gfal_write_python (3) ,
.BR gfal_set_verbose_python (3) ,
.BR gfal_get_errno_python (3) ,
