/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.geronimo.javamail.transport.smtp;

/**
 * Exception for when a SMTP reply string has a problem
 * 
 * @version $Rev: 437941 $ $Date: 2006-08-29 03:56:02 +0000 (mar 29 aoû 2006) $
 */
class MalformedSMTPReplyException extends Exception {
    MalformedSMTPReplyException() {
        super();
    }

    MalformedSMTPReplyException(String msg) {
        super(msg);
    }

    MalformedSMTPReplyException(String msg, Exception t) {
        super(msg, t);
    }
}
