/*
 * testFrame.java
 *
 * Created on April 2, 2001, 4:28 PM
 */

package geotrans.gui;


import geotrans.enumerations.ConversionState;
import geotrans.enumerations.SourceOrTarget;
import geotrans.gui.MasterPanel;
import geotrans.jni.*;
import geotrans.utility.Center;
import geotrans.utility.DATFileFilter;
import geotrans.utility.Directory;
import geotrans.utility.StartBrowser;


/**
 *
 * @author  amyc
 * @version 
 */
public class FileDlg extends javax.swing.JDialog {

    private Directory currentDir;
    private MasterPanel lowerFilePanel;
    private JNIFiomeths jniFiomeths;
    private javax.swing.JFrame parentFrame;
    private jOptions options;
 
    /** Creates new form FileDlg */
    public FileDlg(javax.swing.JFrame parent, boolean modal, Directory dir, jOptions joptions, JNIFiomeths jni_Fiomeths) {
        super (parent, modal);
        initComponents ();
        parentFrame = parent;
        currentDir = dir;
        jniFiomeths = jni_Fiomeths;
        options = joptions;
        MasterPanel upperFilePanel = new MasterPanel(ConversionState.FILE, SourceOrTarget.SOURCE, joptions);
        lowerFilePanel = new MasterPanel(ConversionState.FILE, SourceOrTarget.TARGET, joptions);
        
        inputFilePanel.add(upperFilePanel, java.awt.BorderLayout.CENTER);
        outputFilePanel.add(lowerFilePanel, java.awt.BorderLayout.CENTER);
        pack ();
        new Center(parent, this);        
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        inputFilePanel = new javax.swing.JPanel();
        inputLabel = new javax.swing.JLabel();
        outputFilePanel = new javax.swing.JPanel();
        outputLabel = new javax.swing.JLabel();
        buttonsPanel = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        helpButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("GEOTRANS File Processing");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        inputFilePanel.setLayout(new java.awt.BorderLayout(1, 1));

        inputFilePanel.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(0, 0, 0)));
        inputFilePanel.setMinimumSize(new java.awt.Dimension(467, 197));
        inputFilePanel.setPreferredSize(new java.awt.Dimension(467, 197));
        inputLabel.setText("INPUT");
        inputFilePanel.add(inputLabel, java.awt.BorderLayout.NORTH);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(inputFilePanel, gridBagConstraints);

        outputFilePanel.setLayout(new java.awt.BorderLayout(1, 1));

        outputFilePanel.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(0, 0, 0)));
        outputFilePanel.setAlignmentY(1.5F);
        outputFilePanel.setMinimumSize(new java.awt.Dimension(467, 197));
        outputFilePanel.setPreferredSize(new java.awt.Dimension(467, 197));
        outputLabel.setText("OUTPUT");
        outputFilePanel.add(outputLabel, java.awt.BorderLayout.NORTH);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipady = 8;
        gridBagConstraints.insets = new java.awt.Insets(3, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        getContentPane().add(outputFilePanel, gridBagConstraints);

        buttonsPanel.setLayout(new java.awt.GridBagLayout());

        buttonsPanel.setMinimumSize(new java.awt.Dimension(330, 50));
        buttonsPanel.setPreferredSize(new java.awt.Dimension(330, 50));
        okButton.setPreferredSize(new java.awt.Dimension(80, 21));
        okButton.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        okButton.setMnemonic(java.awt.event.KeyEvent.VK_O);
        okButton.setMaximumSize(new java.awt.Dimension(80, 21));
        okButton.setText("OK");
        okButton.setMinimumSize(new java.awt.Dimension(80, 21));
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 45);
        buttonsPanel.add(okButton, gridBagConstraints);

        helpButton.setMnemonic(java.awt.event.KeyEvent.VK_H);
        helpButton.setText("Help");
        helpButton.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        helpButton.setMaximumSize(new java.awt.Dimension(80, 21));
        helpButton.setMinimumSize(new java.awt.Dimension(80, 21));
        helpButton.setPreferredSize(new java.awt.Dimension(80, 21));
        helpButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                helpActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 45);
        buttonsPanel.add(helpButton, gridBagConstraints);

        cancelButton.setPreferredSize(new java.awt.Dimension(80, 21));
        cancelButton.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        cancelButton.setMnemonic(java.awt.event.KeyEvent.VK_C);
        cancelButton.setMaximumSize(new java.awt.Dimension(80, 21));
        cancelButton.setText("Cancel");
        cancelButton.setMinimumSize(new java.awt.Dimension(80, 21));
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 0);
        buttonsPanel.add(cancelButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        getContentPane().add(buttonsPanel, gridBagConstraints);

    }//GEN-END:initComponents

  private void cancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelActionPerformed
    setVisible( false );
    jniFiomeths.JNICloseInputFile();
    dispose();      
  }//GEN-LAST:event_cancelActionPerformed

  private void helpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_helpActionPerformed
   java.io.File helpFile = new java.io.File ("..");
   try
   {
       if (StartBrowser.isWindowsPlatform())
           StartBrowser.displayURL(this, "file:" + helpFile.getCanonicalPath() + "\\help\\fileproc.htm");
       else
           StartBrowser.displayURL(this, "file:" + helpFile.getCanonicalPath() + "/help/fileproc.htm");
   }
   catch(Exception e) 
   {
        new JNIStrtoval().displayErrorMsg(this, "Could not invoke browser");
   }   
  }//GEN-LAST:event_helpActionPerformed

  private void okActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okActionPerformed
   JNIStrtoval jniStrtoval = new JNIStrtoval();
   
   // if engine is set & no Jni errors
    lowerFilePanel.setEngine();
    if (!lowerFilePanel.JNIError())
    {
        // if no engine errors
        if(!lowerFilePanel.engineError())
        {
            setVisible( false );
            javax.swing.JFileChooser jChooser1 = new javax.swing.JFileChooser(currentDir.getDirectory());
            jChooser1.setDialogTitle("Save As");
            jChooser1.addChoosableFileFilter(new DATFileFilter()); 
            jChooser1.setSelectedFile(new java.io.File("*.dat"));
            int state = jChooser1.showSaveDialog(parentFrame);   
            if( state == javax.swing.JFileChooser.APPROVE_OPTION )
            {
                java.io.File file = jChooser1.getSelectedFile();
                currentDir.setDirectory(file.getAbsolutePath());
                if( file != null )
                {
                    try
                    {
                        // Set Formats
                        jniFiomeths.JNIUseNSEW(options.getUseNSEW());
                        jniFiomeths.JNIUseMinutes(options.getUseMinutes());
                        jniFiomeths.JNIUseSeconds(options.getUseSeconds());
                
                        jniFiomeths.JNISetOutputFilename(file.getPath());    
                        new ProgressDlg(this, true, jniFiomeths).show ();
                    }
                    catch(GeotransError e)
                    {
                        jniStrtoval.displayErrorMsg(this, e.getMessage());
                        jniFiomeths.JNICloseInputFile();
                    }
                    catch(JNIException e)
                    {
                        jniStrtoval.displayErrorMsg(this, e.getMessage());
                        jniFiomeths.JNICloseInputFile();
                    }                   
                }
                dispose();     
            }
            else
            {
                jniFiomeths.JNICloseInputFile();
                dispose();  
            }
        }
        else
            lowerFilePanel.showErrors(this);
    }
    else
    {
        lowerFilePanel.showErrors(this);
        jniFiomeths.JNICloseInputFile();
        dispose();     
    }
        
  }//GEN-LAST:event_okActionPerformed

  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible (false);
        jniFiomeths.JNICloseInputFile();
        dispose ();
  }//GEN-LAST:event_closeDialog

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel buttonsPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton helpButton;
    private javax.swing.JPanel inputFilePanel;
    private javax.swing.JLabel inputLabel;
    private javax.swing.JButton okButton;
    private javax.swing.JPanel outputFilePanel;
    private javax.swing.JLabel outputLabel;
    // End of variables declaration//GEN-END:variables

}
