/*
 * Decompiled with CFR 0.152.
 */
package geotrans.gui;

import geotrans.enumerations.CoordinateTypes;
import geotrans.gui.CoordPanel;
import geotrans.gui.FillList;
import geotrans.gui.Geotrans;
import geotrans.gui.jOptions;
import geotrans.jni.GeotransError;
import geotrans.jni.GeotransWarning;
import geotrans.jni.JNIEngine;
import geotrans.jni.JNIException;
import geotrans.jni.JNIStrtoval;
import geotrans.parameters.CoordinateSystemParameters;
import geotrans.parameters.EquidistantCylindricalParameters;
import geotrans.parameters.GeodeticParameters;
import geotrans.parameters.LocalCartesianParameters;
import geotrans.parameters.MapProjection3Parameters;
import geotrans.parameters.MapProjection4Parameters;
import geotrans.parameters.MapProjection5Parameters;
import geotrans.parameters.MapProjection6Parameters;
import geotrans.parameters.MercatorParameters;
import geotrans.parameters.NeysParameters;
import geotrans.parameters.ObliqueMercatorParameters;
import geotrans.parameters.PolarStereographicParameters;
import geotrans.parameters.UTMParameters;
import geotrans.projections.AlbersEqualAreaConic;
import geotrans.projections.AzimuthalEquidistant;
import geotrans.projections.Bonne;
import geotrans.projections.Cassini;
import geotrans.projections.CylindricalEqualArea;
import geotrans.projections.Eckert4;
import geotrans.projections.Eckert6;
import geotrans.projections.EquidistantCylindrical;
import geotrans.projections.Geodetic;
import geotrans.projections.Gnomonic;
import geotrans.projections.LambertConformalConic1;
import geotrans.projections.LambertConformalConic2;
import geotrans.projections.LocalCartesian;
import geotrans.projections.Mercator;
import geotrans.projections.MillerCylindrical;
import geotrans.projections.Mollweide;
import geotrans.projections.Neys;
import geotrans.projections.ObliqueMercator;
import geotrans.projections.Orthographic;
import geotrans.projections.PolarStereographic;
import geotrans.projections.Polyconic;
import geotrans.projections.Sinusoidal;
import geotrans.projections.Stereographic;
import geotrans.projections.TransverseCylindricalEqualArea;
import geotrans.projections.TransverseMercator;
import geotrans.projections.UTM;
import geotrans.projections.VanDerGrinten;
import geotrans.utility.Platform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class MasterPanel
extends JPanel {
    private FillList datumList;
    private Geotrans parent;
    private JNIEngine jniEngine = new JNIEngine();
    private JNIStrtoval jniStrtoval = new JNIStrtoval();
    private int projectionType = 0;
    private int datumIndex = 0;
    private int direction;
    private int state;
    private CoordPanel coordPanel;
    private int heightType;
    private long override;
    private jOptions formatOptions;
    private boolean createHeader;
    private boolean useNSEW;
    private boolean useMinutes;
    private boolean useSeconds;
    private String currLookAndFeel = "Java";
    private double _180OverPI = 180.0 / Math.PI;
    private JLabel _3ParamFieldsRow1LabelA;
    private JLabel _3ParamFieldsRow1LabelB;
    private JLabel _3ParamFieldsRow1LabelC;
    private JPanel _3ParamFieldsRow1Panel;
    private JTextField _3ParamFieldsRow1TextFieldA;
    private JTextField _3ParamFieldsRow1TextFieldB;
    private JTextField _3ParamFieldsRow1TextFieldC;
    private JLabel _3ParamFieldsRow2LabelA;
    private JLabel _3ParamFieldsRow2LabelB;
    private JLabel _3ParamFieldsRow2LabelC;
    private JPanel _3ParamFieldsRow2Panel;
    private JTextField _3ParamFieldsRow2TextFieldA;
    private JTextField _3ParamFieldsRow2TextFieldB;
    private JTextField _3ParamFieldsRow2TextFieldC;
    private JLabel _4ParamFieldsRow1LabelA;
    private JLabel _4ParamFieldsRow1LabelB;
    private JLabel _4ParamFieldsRow1LabelC;
    private JLabel _4ParamFieldsRow1LabelD;
    private JPanel _4ParamFieldsRow1Panel;
    private JTextField _4ParamFieldsRow1TextFieldA;
    private JTextField _4ParamFieldsRow1TextFieldB;
    private JTextField _4ParamFieldsRow1TextFieldC;
    private JTextField _4ParamFieldsRow1TextFieldD;
    private JLabel _4ParamFieldsRow2LabelA;
    private JLabel _4ParamFieldsRow2LabelB;
    private JLabel _4ParamFieldsRow2LabelC;
    private JLabel _4ParamFieldsRow2LabelD;
    private JPanel _4ParamFieldsRow2Panel;
    private JTextField _4ParamFieldsRow2TextFieldA;
    private JTextField _4ParamFieldsRow2TextFieldB;
    private JTextField _4ParamFieldsRow2TextFieldC;
    private JTextField _4ParamFieldsRow2TextFieldD;
    private JLabel centralMeridianNeysParamsLabel;
    private JPanel centralMeridianNeysParamsPanel;
    private JTextField centralMeridianNeysParamsTextField;
    private JComboBox datumComboBox;
    private JLabel datumLabel;
    private JPanel datumPanel;
    private JLayeredPane datumSelectLayeredPane;
    private JTextField datumTextField;
    private JLabel ellipsoidLabel;
    private JTextField ellipsoidTextField;
    private JComboBox heightComboBox;
    private JLabel heightLabel;
    private JPanel heightLabelPanel;
    private JPanel heightPanel;
    private JPanel hemiBoxPanel;
    private JLabel inputProjectionLabel;
    private JRadioButton nHemiRadioButton;
    private JRadioButton neys71RadioButton;
    private JRadioButton neys74RadioButton;
    private JPanel neysParamsRow1Panel;
    private JLabel originLatitudeNeysParamsLabel;
    private JPanel originLatitudeNeysParamsPanel;
    private JTextField originLatitudeNeysParamsTextField;
    private JLayeredPane paramFieldsRow1LayeredPane;
    private JLayeredPane paramFieldsRow2LayeredPane;
    private JComboBox projectionComboBox;
    private JPanel projectionPanel;
    private JRadioButton sHemiRadioButton;
    private JPanel stdParallel1NeysParamsPanel;
    private JLabel stdParallel2NeysParamsLabel;
    private JPanel stdParallel2NeysParamsPanel;
    private JTextField stdParallel2NeysParamsTextField;
    private JLabel tempZoneBoxLabel;
    private JPanel zoneBoxPanel;
    private JPanel zoneHemiPanel;
    private JLabel zoneLabel;
    private JRadioButton zoneRadioButton;
    private JLabel zoneRangeLabel;
    private JTextField zoneTextField;

    public MasterPanel(int stat, int dir, jOptions options) {
        if (stat == 2) {
            this.createHeader = true;
            this.state = 0;
        } else {
            this.createHeader = false;
            this.state = stat;
        }
        this.direction = dir;
        this.formatOptions = options;
        if (this.state == 0) {
            this.init();
        } else {
            this.coordPanel = new CoordPanel(options, this.jniStrtoval);
            this.init();
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 4;
            this.coordPanel.setPreferredSize(new Dimension(469, 78));
            this.coordPanel.setMinimumSize(new Dimension(469, 78));
            this.add((Component)this.coordPanel, gridBagConstraints7);
        }
    }

    private void init() {
        this.initComponents();
        this.setFormat();
        if (this.direction == 0 && this.state == 0) {
            this.initFileInputPanel();
        } else {
            this.initMasterPanel();
        }
        if (Platform.isJavaV1_3) {
            this.datumLabel.setForeground(Color.black);
            this.ellipsoidLabel.setForeground(Color.black);
            this.inputProjectionLabel.setForeground(Color.black);
            this.centralMeridianNeysParamsLabel.setForeground(Color.black);
            this.originLatitudeNeysParamsLabel.setForeground(Color.black);
            this.stdParallel2NeysParamsLabel.setForeground(Color.black);
            this.heightLabel.setForeground(Color.black);
            this.hemiBoxPanel.setForeground(Color.black);
            this._3ParamFieldsRow1LabelA.setForeground(Color.black);
            this._3ParamFieldsRow1LabelB.setForeground(Color.black);
            this._3ParamFieldsRow1LabelC.setForeground(Color.black);
            this._3ParamFieldsRow2LabelA.setForeground(Color.black);
            this._3ParamFieldsRow2LabelB.setForeground(Color.black);
            this._3ParamFieldsRow2LabelC.setForeground(Color.black);
            this._4ParamFieldsRow1LabelA.setForeground(Color.black);
            this._4ParamFieldsRow1LabelB.setForeground(Color.black);
            this._4ParamFieldsRow1LabelC.setForeground(Color.black);
            this._4ParamFieldsRow1LabelD.setForeground(Color.black);
            this._4ParamFieldsRow2LabelA.setForeground(Color.black);
            this._4ParamFieldsRow2LabelB.setForeground(Color.black);
            this._4ParamFieldsRow2LabelC.setForeground(Color.black);
            this._4ParamFieldsRow2LabelD.setForeground(Color.black);
            this.zoneLabel.setForeground(Color.black);
            this.zoneRangeLabel.setForeground(Color.black);
        }
        if (Platform.isUnix) {
            this.datumLabel.setFont(new Font("Dialog", 1, 10));
            this.ellipsoidLabel.setFont(new Font("Dialog", 1, 10));
            this.inputProjectionLabel.setFont(new Font("Dialog", 1, 10));
            this.centralMeridianNeysParamsLabel.setFont(new Font("Dialog", 1, 10));
            this.originLatitudeNeysParamsLabel.setFont(new Font("Dialog", 1, 10));
            this.stdParallel2NeysParamsLabel.setFont(new Font("Dialog", 1, 10));
            this.heightLabel.setFont(new Font("Dialog", 1, 10));
            this.hemiBoxPanel.setFont(new Font("Dialog", 1, 10));
            this._3ParamFieldsRow1LabelA.setFont(new Font("Dialog", 1, 10));
            this._3ParamFieldsRow1LabelB.setFont(new Font("Dialog", 1, 10));
            this._3ParamFieldsRow1LabelC.setFont(new Font("Dialog", 1, 10));
            this._3ParamFieldsRow2LabelA.setFont(new Font("Dialog", 1, 10));
            this._3ParamFieldsRow2LabelB.setFont(new Font("Dialog", 1, 10));
            this._3ParamFieldsRow2LabelC.setFont(new Font("Dialog", 1, 10));
            this._4ParamFieldsRow1LabelA.setFont(new Font("Dialog", 1, 10));
            this._4ParamFieldsRow1LabelB.setFont(new Font("Dialog", 1, 10));
            this._4ParamFieldsRow1LabelC.setFont(new Font("Dialog", 1, 10));
            this._4ParamFieldsRow1LabelD.setFont(new Font("Dialog", 1, 10));
            this._4ParamFieldsRow2LabelA.setFont(new Font("Dialog", 1, 10));
            this._4ParamFieldsRow2LabelB.setFont(new Font("Dialog", 1, 10));
            this._4ParamFieldsRow2LabelC.setFont(new Font("Dialog", 1, 10));
            this._4ParamFieldsRow2LabelD.setFont(new Font("Dialog", 1, 10));
            this.zoneLabel.setFont(new Font("Dialog", 1, 10));
            this.zoneRangeLabel.setFont(new Font("Dialog", 1, 10));
            this.zoneRadioButton.setFont(new Font("Dialog", 1, 10));
            this.nHemiRadioButton.setFont(new Font("Dialog", 1, 10));
            this.sHemiRadioButton.setFont(new Font("Dialog", 1, 10));
            this.neys71RadioButton.setFont(new Font("Dialog", 1, 10));
            this.neys74RadioButton.setFont(new Font("Dialog", 1, 10));
            this.datumComboBox.setFont(new Font("Dialog", 1, 10));
            this.projectionComboBox.setFont(new Font("Dialog", 1, 10));
            this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 1, 10), Color.black));
            this.stdParallel1NeysParamsPanel.setBorder(new TitledBorder(null, "Std. Parallel 1:", 2, 0, new Font("Dialog", 1, 10), Color.black));
        }
    }

    private void initComponents() {
        this.datumPanel = new JPanel();
        this.datumLabel = new JLabel();
        this.ellipsoidLabel = new JLabel();
        this.datumSelectLayeredPane = new JLayeredPane();
        this.datumTextField = new JTextField();
        this.datumComboBox = new JComboBox();
        this.ellipsoidTextField = new JTextField();
        this.projectionPanel = new JPanel();
        this.inputProjectionLabel = new JLabel();
        this.projectionComboBox = new JComboBox();
        this.paramFieldsRow1LayeredPane = new JLayeredPane();
        this._3ParamFieldsRow1Panel = new JPanel();
        this._3ParamFieldsRow1LabelA = new JLabel();
        this._3ParamFieldsRow1LabelB = new JLabel();
        this._3ParamFieldsRow1LabelC = new JLabel();
        this._3ParamFieldsRow1TextFieldA = new JTextField();
        this._3ParamFieldsRow1TextFieldB = new JTextField();
        this._3ParamFieldsRow1TextFieldC = new JTextField();
        this._4ParamFieldsRow1Panel = new JPanel();
        this._4ParamFieldsRow1LabelA = new JLabel();
        this._4ParamFieldsRow1LabelB = new JLabel();
        this._4ParamFieldsRow1LabelC = new JLabel();
        this._4ParamFieldsRow1LabelD = new JLabel();
        this._4ParamFieldsRow1TextFieldA = new JTextField();
        this._4ParamFieldsRow1TextFieldB = new JTextField();
        this._4ParamFieldsRow1TextFieldC = new JTextField();
        this._4ParamFieldsRow1TextFieldD = new JTextField();
        this.neysParamsRow1Panel = new JPanel();
        this.centralMeridianNeysParamsPanel = new JPanel();
        this.centralMeridianNeysParamsLabel = new JLabel();
        this.centralMeridianNeysParamsTextField = new JTextField();
        this.originLatitudeNeysParamsPanel = new JPanel();
        this.originLatitudeNeysParamsLabel = new JLabel();
        this.originLatitudeNeysParamsTextField = new JTextField();
        this.stdParallel1NeysParamsPanel = new JPanel();
        this.neys71RadioButton = new JRadioButton();
        this.neys74RadioButton = new JRadioButton();
        this.stdParallel2NeysParamsPanel = new JPanel();
        this.stdParallel2NeysParamsLabel = new JLabel();
        this.stdParallel2NeysParamsTextField = new JTextField();
        this.heightLabelPanel = new JPanel();
        this.heightLabel = new JLabel();
        this.heightPanel = new JPanel();
        this.heightComboBox = new JComboBox();
        this.paramFieldsRow2LayeredPane = new JLayeredPane();
        this._3ParamFieldsRow2Panel = new JPanel();
        this._3ParamFieldsRow2LabelA = new JLabel();
        this._3ParamFieldsRow2LabelB = new JLabel();
        this._3ParamFieldsRow2LabelC = new JLabel();
        this._3ParamFieldsRow2TextFieldA = new JTextField();
        this._3ParamFieldsRow2TextFieldB = new JTextField();
        this._3ParamFieldsRow2TextFieldC = new JTextField();
        this._4ParamFieldsRow2Panel = new JPanel();
        this._4ParamFieldsRow2LabelA = new JLabel();
        this._4ParamFieldsRow2LabelB = new JLabel();
        this._4ParamFieldsRow2LabelC = new JLabel();
        this._4ParamFieldsRow2LabelD = new JLabel();
        this._4ParamFieldsRow2TextFieldA = new JTextField();
        this._4ParamFieldsRow2TextFieldB = new JTextField();
        this._4ParamFieldsRow2TextFieldC = new JTextField();
        this._4ParamFieldsRow2TextFieldD = new JTextField();
        this.zoneHemiPanel = new JPanel();
        this.zoneBoxPanel = new JPanel();
        this.zoneRadioButton = new JRadioButton();
        this.zoneLabel = new JLabel();
        this.zoneTextField = new JTextField();
        this.tempZoneBoxLabel = new JLabel();
        this.zoneRangeLabel = new JLabel();
        this.hemiBoxPanel = new JPanel();
        this.nHemiRadioButton = new JRadioButton();
        this.sHemiRadioButton = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.setAlignmentX(1.0f);
        this.setAlignmentY(1.0f);
        this.setMinimumSize(new Dimension(463, 268));
        this.setPreferredSize(new Dimension(463, 268));
        this.datumPanel.setLayout(new GridBagLayout());
        this.datumPanel.setMinimumSize(new Dimension(460, 40));
        this.datumPanel.setPreferredSize(new Dimension(460, 40));
        this.datumLabel.setText("Datum:");
        this.datumLabel.setMaximumSize(new Dimension(270, 16));
        this.datumLabel.setMinimumSize(new Dimension(270, 16));
        this.datumLabel.setPreferredSize(new Dimension(270, 16));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 9);
        this.datumPanel.add((Component)this.datumLabel, gridBagConstraints);
        this.ellipsoidLabel.setText("Ellipsoid:");
        this.ellipsoidLabel.setMaximumSize(new Dimension(172, 16));
        this.ellipsoidLabel.setMinimumSize(new Dimension(172, 16));
        this.ellipsoidLabel.setPreferredSize(new Dimension(172, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        this.datumPanel.add((Component)this.ellipsoidLabel, gridBagConstraints);
        this.datumSelectLayeredPane.setMinimumSize(new Dimension(270, 20));
        this.datumTextField.setEditable(false);
        this.datumTextField.setText("jTextField1");
        this.datumTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.datumTextField.setMinimumSize(new Dimension(320, 20));
        this.datumTextField.setPreferredSize(new Dimension(320, 20));
        this.datumTextField.setBounds(0, 0, 270, 20);
        this.datumSelectLayeredPane.add((Component)this.datumTextField, JLayeredPane.DEFAULT_LAYER);
        this.datumComboBox.setMinimumSize(new Dimension(320, 20));
        this.datumComboBox.setPreferredSize(new Dimension(320, 20));
        this.datumComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MasterPanel.this.datumComboBoxActionPerformed(evt);
            }
        });
        this.datumComboBox.setBounds(0, 0, 270, 20);
        this.datumSelectLayeredPane.add((Component)this.datumComboBox, JLayeredPane.DEFAULT_LAYER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 0, 9);
        this.datumPanel.add((Component)this.datumSelectLayeredPane, gridBagConstraints);
        this.ellipsoidTextField.setEditable(false);
        this.ellipsoidTextField.setText("jTextField2");
        this.ellipsoidTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.ellipsoidTextField.setMinimumSize(new Dimension(172, 20));
        this.ellipsoidTextField.setPreferredSize(new Dimension(172, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        this.datumPanel.add((Component)this.ellipsoidTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        this.add((Component)this.datumPanel, gridBagConstraints);
        this.projectionPanel.setLayout(new GridBagLayout());
        this.projectionPanel.setMinimumSize(new Dimension(460, 31));
        this.projectionPanel.setPreferredSize(new Dimension(460, 31));
        this.inputProjectionLabel.setHorizontalAlignment(0);
        this.inputProjectionLabel.setText("jLabel7");
        this.projectionPanel.add((Component)this.inputProjectionLabel, new GridBagConstraints());
        this.projectionComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MasterPanel.this.projectionComboBoxActionPerformed(evt);
            }
        });
        this.projectionPanel.add((Component)this.projectionComboBox, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 1, 2);
        this.add((Component)this.projectionPanel, gridBagConstraints);
        this.paramFieldsRow1LayeredPane.setMaximumSize(new Dimension(460, 40));
        this.paramFieldsRow1LayeredPane.setMinimumSize(new Dimension(460, 40));
        this._3ParamFieldsRow1Panel.setLayout(new GridLayout(2, 3, 12, 0));
        this._3ParamFieldsRow1Panel.setMaximumSize(new Dimension(460, 40));
        this._3ParamFieldsRow1Panel.setMinimumSize(new Dimension(460, 40));
        this._3ParamFieldsRow1Panel.setOpaque(false);
        this._3ParamFieldsRow1Panel.setPreferredSize(new Dimension(460, 40));
        this._3ParamFieldsRow1LabelA.setText("Longitude");
        this._3ParamFieldsRow1LabelA.setMaximumSize(new Dimension(105, 16));
        this._3ParamFieldsRow1LabelA.setMinimumSize(new Dimension(105, 16));
        this._3ParamFieldsRow1LabelA.setPreferredSize(new Dimension(105, 16));
        this._3ParamFieldsRow1LabelA.setOpaque(true);
        this._3ParamFieldsRow1Panel.add(this._3ParamFieldsRow1LabelA);
        this._3ParamFieldsRow1LabelB.setText("Latitude");
        this._3ParamFieldsRow1LabelB.setMaximumSize(new Dimension(105, 16));
        this._3ParamFieldsRow1LabelB.setMinimumSize(new Dimension(105, 16));
        this._3ParamFieldsRow1LabelB.setPreferredSize(new Dimension(105, 16));
        this._3ParamFieldsRow1LabelB.setOpaque(true);
        this._3ParamFieldsRow1Panel.add(this._3ParamFieldsRow1LabelB);
        this._3ParamFieldsRow1LabelC.setText("Scale Factor");
        this._3ParamFieldsRow1LabelC.setMaximumSize(new Dimension(105, 16));
        this._3ParamFieldsRow1LabelC.setMinimumSize(new Dimension(105, 16));
        this._3ParamFieldsRow1LabelC.setPreferredSize(new Dimension(105, 16));
        this._3ParamFieldsRow1LabelC.setOpaque(true);
        this._3ParamFieldsRow1Panel.add(this._3ParamFieldsRow1LabelC);
        this._3ParamFieldsRow1TextFieldA.setText("0 0 0.00E");
        this._3ParamFieldsRow1TextFieldA.setBorder(BorderFactory.createBevelBorder(1));
        this._3ParamFieldsRow1TextFieldA.setMinimumSize(new Dimension(138, 20));
        this._3ParamFieldsRow1TextFieldA.setPreferredSize(new Dimension(138, 20));
        this._3ParamFieldsRow1Panel.add(this._3ParamFieldsRow1TextFieldA);
        this._3ParamFieldsRow1TextFieldB.setText("0 0 0.0N");
        this._3ParamFieldsRow1TextFieldB.setBorder(BorderFactory.createBevelBorder(1));
        this._3ParamFieldsRow1TextFieldB.setMinimumSize(new Dimension(138, 20));
        this._3ParamFieldsRow1TextFieldB.setPreferredSize(new Dimension(138, 20));
        this._3ParamFieldsRow1Panel.add(this._3ParamFieldsRow1TextFieldB);
        this._3ParamFieldsRow1TextFieldC.setText("1.00000");
        this._3ParamFieldsRow1TextFieldC.setBorder(BorderFactory.createBevelBorder(1));
        this._3ParamFieldsRow1TextFieldC.setMinimumSize(new Dimension(138, 20));
        this._3ParamFieldsRow1TextFieldC.setPreferredSize(new Dimension(138, 20));
        this._3ParamFieldsRow1Panel.add(this._3ParamFieldsRow1TextFieldC);
        this._3ParamFieldsRow1Panel.setBounds(4, 2, 460, 40);
        this.paramFieldsRow1LayeredPane.add((Component)this._3ParamFieldsRow1Panel, JLayeredPane.DEFAULT_LAYER);
        this._4ParamFieldsRow1Panel.setLayout(new GridLayout(2, 4, 12, 0));
        this._4ParamFieldsRow1Panel.setMinimumSize(new Dimension(1, 1));
        this._4ParamFieldsRow1Panel.setPreferredSize(new Dimension(466, 40));
        this._4ParamFieldsRow1LabelA.setText("Latitude");
        this._4ParamFieldsRow1LabelA.setMinimumSize(new Dimension(4, 10));
        this._4ParamFieldsRow1Panel.add(this._4ParamFieldsRow1LabelA);
        this._4ParamFieldsRow1LabelB.setText("Longitude");
        this._4ParamFieldsRow1LabelB.setMinimumSize(new Dimension(4, 10));
        this._4ParamFieldsRow1Panel.add(this._4ParamFieldsRow1LabelB);
        this._4ParamFieldsRow1LabelC.setText("False Easting");
        this._4ParamFieldsRow1LabelC.setMinimumSize(new Dimension(4, 10));
        this._4ParamFieldsRow1LabelC.setPreferredSize(new Dimension(66, 16));
        this._4ParamFieldsRow1Panel.add(this._4ParamFieldsRow1LabelC);
        this._4ParamFieldsRow1LabelD.setText("False Northing");
        this._4ParamFieldsRow1LabelD.setMinimumSize(new Dimension(4, 10));
        this._4ParamFieldsRow1Panel.add(this._4ParamFieldsRow1LabelD);
        this._4ParamFieldsRow1TextFieldA.setText("0 0 0.00N");
        this._4ParamFieldsRow1TextFieldA.setBorder(BorderFactory.createBevelBorder(1));
        this._4ParamFieldsRow1Panel.add(this._4ParamFieldsRow1TextFieldA);
        this._4ParamFieldsRow1TextFieldB.setText("0 0 0.00W");
        this._4ParamFieldsRow1TextFieldB.setBorder(BorderFactory.createBevelBorder(1));
        this._4ParamFieldsRow1TextFieldB.setMinimumSize(new Dimension(4, 10));
        this._4ParamFieldsRow1Panel.add(this._4ParamFieldsRow1TextFieldB);
        this._4ParamFieldsRow1TextFieldC.setText("200000");
        this._4ParamFieldsRow1TextFieldC.setBorder(BorderFactory.createBevelBorder(1));
        this._4ParamFieldsRow1TextFieldC.setMinimumSize(new Dimension(4, 10));
        this._4ParamFieldsRow1TextFieldC.setPreferredSize(new Dimension(40, 20));
        this._4ParamFieldsRow1Panel.add(this._4ParamFieldsRow1TextFieldC);
        this._4ParamFieldsRow1TextFieldD.setText("400000");
        this._4ParamFieldsRow1TextFieldD.setBorder(BorderFactory.createBevelBorder(1));
        this._4ParamFieldsRow1TextFieldD.setMinimumSize(new Dimension(4, 10));
        this._4ParamFieldsRow1Panel.add(this._4ParamFieldsRow1TextFieldD);
        this._4ParamFieldsRow1Panel.setBounds(4, 2, 460, 40);
        this.paramFieldsRow1LayeredPane.add((Component)this._4ParamFieldsRow1Panel, JLayeredPane.DEFAULT_LAYER);
        this.neysParamsRow1Panel.setLayout(new GridBagLayout());
        this.neysParamsRow1Panel.setMinimumSize(new Dimension(461, 55));
        this.neysParamsRow1Panel.setPreferredSize(new Dimension(461, 55));
        this.centralMeridianNeysParamsPanel.setLayout(new GridLayout(2, 1, 12, 0));
        this.centralMeridianNeysParamsPanel.setMinimumSize(new Dimension(106, 36));
        this.centralMeridianNeysParamsPanel.setPreferredSize(new Dimension(106, 36));
        this.centralMeridianNeysParamsLabel.setText("Central Meridian:");
        this.centralMeridianNeysParamsLabel.setMinimumSize(new Dimension(4, 10));
        this.centralMeridianNeysParamsPanel.add(this.centralMeridianNeysParamsLabel);
        this.centralMeridianNeysParamsTextField.setText("0 0 0.00E");
        this.centralMeridianNeysParamsTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.centralMeridianNeysParamsTextField.setMinimumSize(new Dimension(4, 10));
        this.centralMeridianNeysParamsPanel.add(this.centralMeridianNeysParamsTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.neysParamsRow1Panel.add((Component)this.centralMeridianNeysParamsPanel, gridBagConstraints);
        this.originLatitudeNeysParamsPanel.setLayout(new GridLayout(2, 1, 12, 0));
        this.originLatitudeNeysParamsPanel.setMinimumSize(new Dimension(106, 36));
        this.originLatitudeNeysParamsPanel.setPreferredSize(new Dimension(106, 36));
        this.originLatitudeNeysParamsLabel.setText("Origin Latitude:");
        this.originLatitudeNeysParamsLabel.setMinimumSize(new Dimension(4, 10));
        this.originLatitudeNeysParamsPanel.add(this.originLatitudeNeysParamsLabel);
        this.originLatitudeNeysParamsTextField.setText("0 0 0.00N");
        this.originLatitudeNeysParamsTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.originLatitudeNeysParamsTextField.setMinimumSize(new Dimension(4, 10));
        this.originLatitudeNeysParamsPanel.add(this.originLatitudeNeysParamsTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.neysParamsRow1Panel.add((Component)this.originLatitudeNeysParamsPanel, gridBagConstraints);
        this.stdParallel1NeysParamsPanel.setLayout(new GridBagLayout());
        this.stdParallel1NeysParamsPanel.setBorder(BorderFactory.createTitledBorder(null, "Std. Parallel 1:", 2, 0));
        this.stdParallel1NeysParamsPanel.setAlignmentX(0.0f);
        this.stdParallel1NeysParamsPanel.setAlignmentY(0.0f);
        this.stdParallel1NeysParamsPanel.setMaximumSize(new Dimension(107, 39));
        this.stdParallel1NeysParamsPanel.setMinimumSize(new Dimension(107, 39));
        this.stdParallel1NeysParamsPanel.setPreferredSize(new Dimension(107, 39));
        this.neys71RadioButton.setText("71");
        this.neys71RadioButton.setAlignmentY(0.0f);
        this.neys71RadioButton.setHorizontalTextPosition(4);
        this.neys71RadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.neys71RadioButton.setMaximumSize(new Dimension(30, 17));
        this.neys71RadioButton.setMinimumSize(new Dimension(30, 17));
        this.neys71RadioButton.setModel(this.nHemiRadioButton.getModel());
        this.neys71RadioButton.setPreferredSize(new Dimension(40, 17));
        this.neys71RadioButton.setVerticalAlignment(1);
        this.neys71RadioButton.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.stdParallel1NeysParamsPanel.add((Component)this.neys71RadioButton, gridBagConstraints);
        this.neys74RadioButton.setText("74");
        this.neys74RadioButton.setAlignmentY(0.0f);
        this.neys74RadioButton.setHorizontalTextPosition(4);
        this.neys74RadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.neys74RadioButton.setMaximumSize(new Dimension(30, 17));
        this.neys74RadioButton.setMinimumSize(new Dimension(30, 17));
        this.neys74RadioButton.setModel(this.sHemiRadioButton.getModel());
        this.neys74RadioButton.setPreferredSize(new Dimension(40, 17));
        this.neys74RadioButton.setVerticalAlignment(1);
        this.neys74RadioButton.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 2, 5, 0);
        this.stdParallel1NeysParamsPanel.add((Component)this.neys74RadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.neysParamsRow1Panel.add((Component)this.stdParallel1NeysParamsPanel, gridBagConstraints);
        this.stdParallel2NeysParamsPanel.setLayout(new GridLayout(2, 1, 12, 0));
        this.stdParallel2NeysParamsPanel.setMinimumSize(new Dimension(106, 36));
        this.stdParallel2NeysParamsPanel.setPreferredSize(new Dimension(106, 36));
        this.stdParallel2NeysParamsLabel.setText("Std. Parallel 2:");
        this.stdParallel2NeysParamsLabel.setMinimumSize(new Dimension(4, 10));
        this.stdParallel2NeysParamsPanel.add(this.stdParallel2NeysParamsLabel);
        this.stdParallel2NeysParamsTextField.setEditable(false);
        this.stdParallel2NeysParamsTextField.setText("89 59 59.0");
        this.stdParallel2NeysParamsTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.stdParallel2NeysParamsTextField.setMinimumSize(new Dimension(4, 10));
        this.stdParallel2NeysParamsPanel.add(this.stdParallel2NeysParamsTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.neysParamsRow1Panel.add((Component)this.stdParallel2NeysParamsPanel, gridBagConstraints);
        this.neysParamsRow1Panel.setBounds(0, 2, 460, 40);
        this.paramFieldsRow1LayeredPane.add((Component)this.neysParamsRow1Panel, JLayeredPane.DEFAULT_LAYER);
        this.heightLabelPanel.setLayout(new GridBagLayout());
        this.heightLabelPanel.setMinimumSize(new Dimension(213, 20));
        this.heightLabelPanel.setPreferredSize(new Dimension(213, 20));
        this.heightLabel.setHorizontalAlignment(0);
        this.heightLabel.setText("jLabel3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        this.heightLabelPanel.add((Component)this.heightLabel, gridBagConstraints);
        this.heightLabelPanel.setBounds(4, 2, 460, 40);
        this.paramFieldsRow1LayeredPane.add((Component)this.heightLabelPanel, JLayeredPane.DEFAULT_LAYER);
        this.heightPanel.setLayout(new GridBagLayout());
        this.heightPanel.setAlignmentX(0.0f);
        this.heightPanel.setAlignmentY(0.0f);
        this.heightPanel.setMinimumSize(new Dimension(469, 50));
        this.heightPanel.setOpaque(false);
        this.heightPanel.setPreferredSize(new Dimension(469, 50));
        this.heightComboBox.setMinimumSize(new Dimension(276, 21));
        this.heightComboBox.setPreferredSize(new Dimension(276, 21));
        this.heightComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MasterPanel.this.heightComboBoxActionPerformed(evt);
            }
        });
        this.heightPanel.add((Component)this.heightComboBox, new GridBagConstraints());
        this.heightPanel.setBounds(0, 0, 462, 45);
        this.paramFieldsRow1LayeredPane.add((Component)this.heightPanel, JLayeredPane.DEFAULT_LAYER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 2, 1, 2);
        this.add((Component)this.paramFieldsRow1LayeredPane, gridBagConstraints);
        this.paramFieldsRow2LayeredPane.setMinimumSize(new Dimension(460, 55));
        this._3ParamFieldsRow2Panel.setLayout(new GridLayout(2, 3, 12, 0));
        this._3ParamFieldsRow2Panel.setOpaque(false);
        this._3ParamFieldsRow2LabelA.setText("Latitude");
        this._3ParamFieldsRow2LabelA.setOpaque(true);
        this._3ParamFieldsRow2Panel.add(this._3ParamFieldsRow2LabelA);
        this._3ParamFieldsRow2LabelB.setText("Longitude");
        this._3ParamFieldsRow2LabelB.setOpaque(true);
        this._3ParamFieldsRow2Panel.add(this._3ParamFieldsRow2LabelB);
        this._3ParamFieldsRow2LabelC.setText("Scale Factor");
        this._3ParamFieldsRow2LabelC.setOpaque(true);
        this._3ParamFieldsRow2Panel.add(this._3ParamFieldsRow2LabelC);
        this._3ParamFieldsRow2TextFieldA.setText("0 0 0.00S");
        this._3ParamFieldsRow2TextFieldA.setBorder(BorderFactory.createBevelBorder(1));
        this._3ParamFieldsRow2Panel.add(this._3ParamFieldsRow2TextFieldA);
        this._3ParamFieldsRow2TextFieldB.setText("0 0 0.0E");
        this._3ParamFieldsRow2TextFieldB.setBorder(BorderFactory.createBevelBorder(1));
        this._3ParamFieldsRow2Panel.add(this._3ParamFieldsRow2TextFieldB);
        this._3ParamFieldsRow2TextFieldC.setText("4500");
        this._3ParamFieldsRow2TextFieldC.setBorder(BorderFactory.createBevelBorder(1));
        this._3ParamFieldsRow2Panel.add(this._3ParamFieldsRow2TextFieldC);
        this._3ParamFieldsRow2Panel.setBounds(0, 0, 462, 38);
        this.paramFieldsRow2LayeredPane.add((Component)this._3ParamFieldsRow2Panel, JLayeredPane.DEFAULT_LAYER);
        this._4ParamFieldsRow2Panel.setLayout(new GridLayout(2, 4, 12, 0));
        this._4ParamFieldsRow2Panel.setMinimumSize(new Dimension(460, 40));
        this._4ParamFieldsRow2Panel.setPreferredSize(new Dimension(460, 40));
        this._4ParamFieldsRow2LabelA.setText("Latitude");
        this._4ParamFieldsRow2LabelA.setMaximumSize(new Dimension(100, 16));
        this._4ParamFieldsRow2LabelA.setMinimumSize(new Dimension(100, 16));
        this._4ParamFieldsRow2LabelA.setPreferredSize(new Dimension(100, 16));
        this._4ParamFieldsRow2Panel.add(this._4ParamFieldsRow2LabelA);
        this._4ParamFieldsRow2LabelB.setText("Longitude");
        this._4ParamFieldsRow2LabelB.setMaximumSize(new Dimension(100, 16));
        this._4ParamFieldsRow2LabelB.setMinimumSize(new Dimension(100, 16));
        this._4ParamFieldsRow2LabelB.setPreferredSize(new Dimension(100, 16));
        this._4ParamFieldsRow2Panel.add(this._4ParamFieldsRow2LabelB);
        this._4ParamFieldsRow2LabelC.setText("False Easting");
        this._4ParamFieldsRow2LabelC.setMaximumSize(new Dimension(100, 16));
        this._4ParamFieldsRow2LabelC.setMinimumSize(new Dimension(100, 16));
        this._4ParamFieldsRow2LabelC.setPreferredSize(new Dimension(100, 16));
        this._4ParamFieldsRow2Panel.add(this._4ParamFieldsRow2LabelC);
        this._4ParamFieldsRow2LabelD.setText("False Northing");
        this._4ParamFieldsRow2LabelD.setMaximumSize(new Dimension(100, 16));
        this._4ParamFieldsRow2LabelD.setMinimumSize(new Dimension(100, 16));
        this._4ParamFieldsRow2LabelD.setPreferredSize(new Dimension(100, 16));
        this._4ParamFieldsRow2Panel.add(this._4ParamFieldsRow2LabelD);
        this._4ParamFieldsRow2TextFieldA.setText("0 0 0.00N");
        this._4ParamFieldsRow2TextFieldA.setBorder(BorderFactory.createBevelBorder(1));
        this._4ParamFieldsRow2TextFieldA.setMinimumSize(new Dimension(100, 20));
        this._4ParamFieldsRow2TextFieldA.setPreferredSize(new Dimension(100, 20));
        this._4ParamFieldsRow2Panel.add(this._4ParamFieldsRow2TextFieldA);
        this._4ParamFieldsRow2TextFieldB.setText("0 0 0.00W");
        this._4ParamFieldsRow2TextFieldB.setBorder(BorderFactory.createBevelBorder(1));
        this._4ParamFieldsRow2TextFieldB.setMinimumSize(new Dimension(100, 20));
        this._4ParamFieldsRow2TextFieldB.setPreferredSize(new Dimension(100, 20));
        this._4ParamFieldsRow2Panel.add(this._4ParamFieldsRow2TextFieldB);
        this._4ParamFieldsRow2TextFieldC.setText("200000");
        this._4ParamFieldsRow2TextFieldC.setBorder(BorderFactory.createBevelBorder(1));
        this._4ParamFieldsRow2TextFieldC.setMinimumSize(new Dimension(100, 20));
        this._4ParamFieldsRow2TextFieldC.setPreferredSize(new Dimension(100, 20));
        this._4ParamFieldsRow2Panel.add(this._4ParamFieldsRow2TextFieldC);
        this._4ParamFieldsRow2TextFieldD.setText("400000");
        this._4ParamFieldsRow2TextFieldD.setBorder(BorderFactory.createBevelBorder(1));
        this._4ParamFieldsRow2TextFieldD.setMinimumSize(new Dimension(100, 20));
        this._4ParamFieldsRow2TextFieldD.setPreferredSize(new Dimension(100, 20));
        this._4ParamFieldsRow2Panel.add(this._4ParamFieldsRow2TextFieldD);
        this._4ParamFieldsRow2Panel.setBounds(4, 2, 460, 40);
        this.paramFieldsRow2LayeredPane.add((Component)this._4ParamFieldsRow2Panel, JLayeredPane.DEFAULT_LAYER);
        this.zoneHemiPanel.setLayout(new GridBagLayout());
        this.zoneHemiPanel.setMinimumSize(new Dimension(220, 60));
        this.zoneHemiPanel.setPreferredSize(new Dimension(220, 60));
        this.zoneHemiPanel.setOpaque(false);
        this.zoneBoxPanel.setLayout(new GridBagLayout());
        this.zoneBoxPanel.setMinimumSize(new Dimension(175, 58));
        this.zoneBoxPanel.setPreferredSize(new Dimension(175, 58));
        this.zoneRadioButton.setText("Override:");
        this.zoneRadioButton.setActionCommand("( set )");
        this.zoneRadioButton.setHorizontalTextPosition(2);
        this.zoneRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.zoneRadioButton.setVerticalAlignment(1);
        this.zoneRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MasterPanel.this.zoneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        this.zoneBoxPanel.add((Component)this.zoneRadioButton, gridBagConstraints);
        this.zoneLabel.setText("Zone");
        this.zoneLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.zoneBoxPanel.add((Component)this.zoneLabel, gridBagConstraints);
        this.zoneTextField.setHorizontalAlignment(2);
        this.zoneTextField.setText("0");
        this.zoneTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.zoneTextField.setMinimumSize(new Dimension(35, 19));
        this.zoneTextField.setPreferredSize(new Dimension(41, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.zoneBoxPanel.add((Component)this.zoneTextField, gridBagConstraints);
        this.tempZoneBoxLabel.setOpaque(true);
        this.zoneBoxPanel.add((Component)this.tempZoneBoxLabel, new GridBagConstraints());
        this.zoneRangeLabel.setText("(1-60):");
        this.zoneRangeLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.zoneBoxPanel.add((Component)this.zoneRangeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.zoneHemiPanel.add((Component)this.zoneBoxPanel, gridBagConstraints);
        this.hemiBoxPanel.setLayout(new GridBagLayout());
        this.hemiBoxPanel.setBorder(BorderFactory.createTitledBorder(null, "Hemisphere:", 2, 0));
        this.hemiBoxPanel.setMaximumSize(new Dimension(101, 45));
        this.hemiBoxPanel.setMinimumSize(new Dimension(101, 45));
        this.hemiBoxPanel.setPreferredSize(new Dimension(101, 45));
        this.nHemiRadioButton.setText("N");
        this.nHemiRadioButton.setHorizontalTextPosition(4);
        this.nHemiRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.nHemiRadioButton.setMaximumSize(new Dimension(28, 20));
        this.nHemiRadioButton.setModel(this.nHemiRadioButton.getModel());
        this.nHemiRadioButton.setPreferredSize(new Dimension(28, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 0, 5, 7);
        this.hemiBoxPanel.add((Component)this.nHemiRadioButton, gridBagConstraints);
        this.sHemiRadioButton.setText("S");
        this.sHemiRadioButton.setHorizontalTextPosition(4);
        this.sHemiRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.sHemiRadioButton.setMaximumSize(new Dimension(28, 20));
        this.sHemiRadioButton.setModel(this.sHemiRadioButton.getModel());
        this.sHemiRadioButton.setPreferredSize(new Dimension(28, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 7, 5, 0);
        this.hemiBoxPanel.add((Component)this.sHemiRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(14, 0, 4, 55);
        this.zoneHemiPanel.add((Component)this.hemiBoxPanel, gridBagConstraints);
        this.zoneHemiPanel.setBounds(0, 0, 462, 55);
        this.paramFieldsRow2LayeredPane.add((Component)this.zoneHemiPanel, JLayeredPane.DEFAULT_LAYER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        this.add((Component)this.paramFieldsRow2LayeredPane, gridBagConstraints);
    }

    private void heightComboBoxActionPerformed(ActionEvent evt) {
        this.heightType = this.heightComboBox.getSelectedIndex();
        if (this.state != 0) {
            if (this.heightComboBox.getSelectedIndex() == 0) {
                this.setHeightFieldEditable(false);
            } else {
                this.setHeightFieldEditable(true);
            }
        }
    }

    private void zoneActionPerformed(ActionEvent evt) {
        if (this.zoneRadioButton.isSelected()) {
            this.override = 1L;
        } else if (!this.zoneRadioButton.isSelected()) {
            this.override = 0L;
        }
    }

    private void projectionComboBoxActionPerformed(ActionEvent evt) {
        this.projectionType = CoordinateTypes.index((String)this.projectionComboBox.getSelectedItem());
        this.createMasterPanel();
        if (this.state != 0) {
            this.coordPanel.createCoordPanel(this.projectionType);
            if (this.parent != null) {
                this.parent.checkValidConversion();
            }
        }
        if (this.parent != null) {
            this.parent.check3DConversion();
        }
    }

    private void datumComboBoxActionPerformed(ActionEvent evt) {
        try {
            this.datumIndex = this.datumComboBox.getSelectedIndex() + 1;
            if (this.datumIndex == 0) {
                this.datumIndex = 1;
            }
            String datumEllipsoidCode = this.jniEngine.JNIGetDatumEllipsoidCode(this.datumIndex);
            long inputEllipsoidIndex = this.jniEngine.JNIGetEllipsoidIndex(datumEllipsoidCode);
            String inputEllipsoidName = this.jniEngine.JNIGetEllipsoidName(inputEllipsoidIndex);
            this.ellipsoidTextField.setText(datumEllipsoidCode + ":  " + inputEllipsoidName);
            this.ellipsoidTextField.setCaretPosition(0);
            if (this.parent != null) {
                this.parent.checkValidConversion();
            }
        }
        catch (GeotransError e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        catch (JNIException e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
    }

    private void initFileInputPanel() {
        String[] msg = new String[12];
        this.datumComboBox.setVisible(false);
        this.projectionComboBox.setVisible(false);
        try {
            int inputFileType = this.jniEngine.JNIGetCoordinateSystem(this.state, this.direction);
            long inputDatumIndex = this.jniEngine.JNIGetDatum(this.state, this.direction);
            String inputDatumCode = this.jniEngine.JNIGetDatumCode(inputDatumIndex);
            String inputDatumName = this.jniEngine.JNIGetDatumName(inputDatumIndex);
            this.datumTextField.setText(inputDatumCode + ":  " + inputDatumName);
            String datumEllipsoidCode = this.jniEngine.JNIGetDatumEllipsoidCode(inputDatumIndex);
            long inputEllipsoidIndex = this.jniEngine.JNIGetEllipsoidIndex(datumEllipsoidCode);
            String inputEllipsoidName = this.jniEngine.JNIGetEllipsoidName(inputEllipsoidIndex);
            this.ellipsoidTextField.setText(datumEllipsoidCode + ":  " + inputEllipsoidName);
            switch (inputFileType) {
                case 9: {
                    this.inputProjectionLabel.setText("Albers Equal Area Conic Projection");
                    AlbersEqualAreaConic albersParams = this.jniEngine.JNIGetAlbersEqualAreaConicParams(this.state, this.direction);
                    this.setSixParams();
                    this.setSixParamsUnedit();
                    this._4ParamFieldsRow1TextFieldA.setText(this.jniStrtoval.JNILongitudeToString(albersParams.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILatitudeToString(albersParams.getOriginLatitude() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(albersParams.getStdParallel1() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldD.setText(this.jniStrtoval.JNILatitudeToString(albersParams.getStdParallel2() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(albersParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(albersParams.getFalseNorthing()));
                    break;
                }
                case 10: {
                    this.inputProjectionLabel.setText("Azimuthal Equidistant Projection");
                    AzimuthalEquidistant azeqParams = this.jniEngine.JNIGetAzimuthalEquidistantParams(this.state, this.direction);
                    this.setFourParams();
                    this.setFourParamsUnedit();
                    this._4ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(azeqParams.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(azeqParams.getOriginLatitude() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(azeqParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(azeqParams.getFalseNorthing()));
                    break;
                }
                case 11: {
                    this.inputProjectionLabel.setText("British National Grid Coordinates");
                    this.hideParams();
                    break;
                }
                case 12: {
                    this.inputProjectionLabel.setText("Bonne Projection");
                    Bonne bonneParams = this.jniEngine.JNIGetBonneParams(this.state, this.direction);
                    this.setFourParams();
                    this.setFourParamsUnedit();
                    this._4ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(bonneParams.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(bonneParams.getOriginLatitude() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(bonneParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(bonneParams.getFalseNorthing()));
                    break;
                }
                case 13: {
                    this.inputProjectionLabel.setText("Cassini Projection");
                    Cassini cassiniParams = this.jniEngine.JNIGetCassiniParams(this.state, this.direction);
                    this.setFourParams();
                    this.setFourParamsUnedit();
                    this._4ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(cassiniParams.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(cassiniParams.getOriginLatitude() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(cassiniParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(cassiniParams.getFalseNorthing()));
                    break;
                }
                case 14: {
                    this.inputProjectionLabel.setText("Cylindrical Equal Area Projection");
                    CylindricalEqualArea cyleqaParams = this.jniEngine.JNIGetCylindricalEqualAreaParams(this.state, this.direction);
                    this.setFourParams();
                    this.setFourParamsUnedit();
                    this._4ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(cyleqaParams.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(cyleqaParams.getOriginLatitude() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(cyleqaParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(cyleqaParams.getFalseNorthing()));
                    break;
                }
                case 15: {
                    this.inputProjectionLabel.setText("Eckert IV Projection");
                    Eckert4 eckert4Params = this.jniEngine.JNIGetEckert4Params(this.state, this.direction);
                    this.setThreeParams();
                    this.setThreeParamsUnedit();
                    this._3ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(eckert4Params.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(eckert4Params.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(eckert4Params.getFalseNorthing()));
                    break;
                }
                case 16: {
                    this.inputProjectionLabel.setText("Eckert VI Projection");
                    Eckert6 eckert6Params = this.jniEngine.JNIGetEckert6Params(this.state, this.direction);
                    this.setThreeParams();
                    this.setThreeParamsUnedit();
                    this._3ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(eckert6Params.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(eckert6Params.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(eckert6Params.getFalseNorthing()));
                    break;
                }
                case 17: {
                    this.inputProjectionLabel.setText("Equidistant Cylindrical");
                    EquidistantCylindrical eqdcylParams = this.jniEngine.JNIGetEquidistantCylindricalParams(this.state, this.direction);
                    this.setFourParams();
                    this._4ParamFieldsRow1LabelC.setText("Standard Parallel:");
                    this.setFourParamsUnedit();
                    this._4ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(eqdcylParams.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(eqdcylParams.getStdParallel() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(eqdcylParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(eqdcylParams.getFalseNorthing()));
                    break;
                }
                case 2: {
                    this.inputProjectionLabel.setText("GARS Coordinates");
                    this.hideParams();
                    break;
                }
                case 3: {
                    this.inputProjectionLabel.setText("Geocentric Coordinates");
                    this.hideParams();
                    break;
                }
                case 0: {
                    this.inputProjectionLabel.setText("Geodetic Coordinates");
                    Geodetic geodeticParams = this.jniEngine.JNIGetGeodeticParams(this.state, this.direction);
                    this.hideParams();
                    this.heightLabelPanel.setVisible(true);
                    this.paramFieldsRow1LayeredPane.moveToFront(this.heightLabelPanel);
                    int height_Type = geodeticParams.getHeightType();
                    if (height_Type == 2) {
                        this.heightLabel.setText("MSL-EGM96-15M-BL Height");
                        break;
                    }
                    if (height_Type == 3) {
                        this.heightLabel.setText("MSL-EGM96-VG-NS Height");
                        break;
                    }
                    if (height_Type == 4) {
                        this.heightLabel.setText("MSL-EGM84-10D-BL Height");
                        break;
                    }
                    if (height_Type == 5) {
                        this.heightLabel.setText("MSL-EGM84-10D-NS Height");
                        break;
                    }
                    if (height_Type == 0) {
                        this.heightLabel.setText("No Height");
                        break;
                    }
                    this.heightLabel.setText("Ellipsoid Height");
                    break;
                }
                case 1: {
                    this.inputProjectionLabel.setText("GEOREF Coordinates");
                    this.hideParams();
                    break;
                }
                case 18: {
                    this.inputProjectionLabel.setText("Gnomonic Projection");
                    Gnomonic gnomonicParams = this.jniEngine.JNIGetGnomonicParams(this.state, this.direction);
                    this.setFourParams();
                    this.setFourParamsUnedit();
                    this._4ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(gnomonicParams.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(gnomonicParams.getOriginLatitude() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(gnomonicParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(gnomonicParams.getFalseNorthing()));
                    break;
                }
                case 19: {
                    this.inputProjectionLabel.setText("Lambert Conformal Conic (1 parallel) Projection");
                    LambertConformalConic1 lambert1Params = this.jniEngine.JNIGetLambertConformalConic1Params(this.state, this.direction);
                    this.setFiveParams();
                    this.setFiveParamsUnedit();
                    this._3ParamFieldsRow1TextFieldA.setText(this.jniStrtoval.JNILongitudeToString(lambert1Params.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILatitudeToString(lambert1Params.getOriginLatitude() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this.jniStrtoval.setNumberFormat(this._3ParamFieldsRow1TextFieldC, lambert1Params.getScaleFactor(), 5);
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(lambert1Params.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(lambert1Params.getFalseNorthing()));
                    break;
                }
                case 20: {
                    this.inputProjectionLabel.setText("Lambert Conformal Conic (2 parallel) Projection");
                    LambertConformalConic2 lambert2Params = this.jniEngine.JNIGetLambertConformalConic2Params(this.state, this.direction);
                    this.setSixParams();
                    this.setSixParamsUnedit();
                    this._4ParamFieldsRow1TextFieldA.setText(this.jniStrtoval.JNILongitudeToString(lambert2Params.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILatitudeToString(lambert2Params.getOriginLatitude() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(lambert2Params.getStdParallel1() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldD.setText(this.jniStrtoval.JNILatitudeToString(lambert2Params.getStdParallel2() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(lambert2Params.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(lambert2Params.getFalseNorthing()));
                    break;
                }
                case 4: {
                    this.inputProjectionLabel.setText("Local Cartesian Coordinates");
                    LocalCartesian loccartParams = this.jniEngine.JNIGetLocalCartesianParams(this.state, this.direction);
                    this.setLCFourParams();
                    this.setLCFourParamsUnedit();
                    this._3ParamFieldsRow1TextFieldA.setText(this.jniStrtoval.JNILongitudeToString(loccartParams.getOriginLongitude() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILatitudeToString(loccartParams.getOriginLatitude() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNIMeterToString(loccartParams.getOriginHeight()));
                    this._3ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(loccartParams.getOrientation() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    break;
                }
                case 21: {
                    this.inputProjectionLabel.setText("Mercator Projection");
                    this.jniEngine.JNIConvert(0);
                    Mercator mercatorParams = this.jniEngine.JNIGetMercatorParams(this.state, this.direction);
                    this.setFiveParams();
                    this.setFiveParamsUnedit();
                    this._3ParamFieldsRow1TextFieldA.setText(this.jniStrtoval.JNILongitudeToString(mercatorParams.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILatitudeToString(mercatorParams.getLatitudeOfTrueScale() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3ParamFieldsRow1LabelB.setText("Lat. of True Scale");
                    this.jniStrtoval.setNumberFormat(this._3ParamFieldsRow1TextFieldC, mercatorParams.getScaleFactor(), 5);
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(mercatorParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(mercatorParams.getFalseNorthing()));
                    break;
                }
                case 5: {
                    this.inputProjectionLabel.setText("MGRS Coordinates");
                    this.hideParams();
                    break;
                }
                case 22: {
                    this.inputProjectionLabel.setText("Miller Cylindrical Projection");
                    MillerCylindrical millerParams = this.jniEngine.JNIGetMillerCylindricalParams(this.state, this.direction);
                    this.setThreeParams();
                    this.setThreeParamsUnedit();
                    this._3ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(millerParams.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(millerParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(millerParams.getFalseNorthing()));
                    break;
                }
                case 23: {
                    this.inputProjectionLabel.setText("Mollweide Projection");
                    Mollweide mollweidParams = this.jniEngine.JNIGetMollweideParams(this.state, this.direction);
                    this.setThreeParams();
                    this.setThreeParamsUnedit();
                    this._3ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(mollweidParams.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(mollweidParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(mollweidParams.getFalseNorthing()));
                    break;
                }
                case 24: {
                    boolean northHemi = true;
                    this.inputProjectionLabel.setText("Ney's (Modified Lambert Conformal Conic) Projection");
                    Neys neysParams = this.jniEngine.JNIGetNeysParams(this.state, this.direction);
                    this.setSixParams();
                    this.setSixParamsUnedit();
                    double olat = neysParams.getOriginLatitude();
                    if (olat < 0.0) {
                        northHemi = false;
                    }
                    this._4ParamFieldsRow1TextFieldA.setText(this.jniStrtoval.JNILongitudeToString(neysParams.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILatitudeToString(olat * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    if (northHemi) {
                        this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(neysParams.getStdParallel1() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    } else {
                        this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(neysParams.getStdParallel1() * -180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    }
                    if (northHemi) {
                        this._4ParamFieldsRow1TextFieldD.setText(this.jniStrtoval.JNILatitudeToString(89.99944444444444, this.useNSEW, this.useMinutes, this.useSeconds));
                    } else {
                        this._4ParamFieldsRow1TextFieldD.setText(this.jniStrtoval.JNILatitudeToString(-89.99944444444444, this.useNSEW, this.useMinutes, this.useSeconds));
                    }
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(neysParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(neysParams.getFalseNorthing()));
                    break;
                }
                case 25: {
                    this.inputProjectionLabel.setText("New Zealand Map Grid Projection");
                    this.hideParams();
                    break;
                }
                case 26: {
                    this.inputProjectionLabel.setText("Oblique Mercator Projection");
                    ObliqueMercator omercParams = this.jniEngine.JNIGetObliqueMercatorParams(this.state, this.direction);
                    this.setEightParams();
                    this.setEightParamsUnedit();
                    this._4ParamFieldsRow1TextFieldA.setText(this.jniStrtoval.JNILatitudeToString(omercParams.getOriginLatitude() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this.jniStrtoval.setNumberFormat(this._4ParamFieldsRow1TextFieldB, omercParams.getScaleFactor(), 5);
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILongitudeToString(omercParams.getLongitude1() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldD.setText(this.jniStrtoval.JNILatitudeToString(omercParams.getLatitude1() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldA.setText(this.jniStrtoval.JNILongitudeToString(omercParams.getLongitude2() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNILatitudeToString(omercParams.getLatitude2() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(omercParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldD.setText(this.jniStrtoval.JNIMeterToString(omercParams.getFalseNorthing()));
                    break;
                }
                case 27: {
                    this.inputProjectionLabel.setText("Orthographic Projection");
                    Orthographic orthogrParams = this.jniEngine.JNIGetOrthographicParams(this.state, this.direction);
                    this.setFourParams();
                    this.setFourParamsUnedit();
                    this._4ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(orthogrParams.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(orthogrParams.getOriginLatitude() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(orthogrParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(orthogrParams.getFalseNorthing()));
                    break;
                }
                case 28: {
                    this.inputProjectionLabel.setText("Polar Stereographic Projection");
                    PolarStereographic polarstParams = this.jniEngine.JNIGetPolarStereographicParams(this.state, this.direction);
                    this.setFourParams();
                    this._4ParamFieldsRow1LabelB.setText("Long. Down");
                    this._4ParamFieldsRow1LabelC.setText("Lat. of True Scale");
                    this.setFourParamsUnedit();
                    this._4ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(polarstParams.getLongitudeDownFromPole() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(polarstParams.getLatitudeOfTrueScale() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(polarstParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(polarstParams.getFalseNorthing()));
                    break;
                }
                case 29: {
                    this.inputProjectionLabel.setText("Polyconic Projection");
                    Polyconic polyconParams = this.jniEngine.JNIGetPolyconicParams(this.state, this.direction);
                    this.setFourParams();
                    this.setFourParamsUnedit();
                    this._4ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(polyconParams.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(polyconParams.getOriginLatitude() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(polyconParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(polyconParams.getFalseNorthing()));
                    break;
                }
                case 30: {
                    this.inputProjectionLabel.setText("Sinusoidal Projection");
                    Sinusoidal sinusoidParams = this.jniEngine.JNIGetSinusoidalParams(this.state, this.direction);
                    this.setThreeParams();
                    this.setThreeParamsUnedit();
                    this._3ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(sinusoidParams.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(sinusoidParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(sinusoidParams.getFalseNorthing()));
                    break;
                }
                case 31: {
                    this.inputProjectionLabel.setText("Stereographic Projection");
                    Stereographic stereogrParams = this.jniEngine.JNIGetStereographicParams(this.state, this.direction);
                    this.setFourParams();
                    this.setFourParamsUnedit();
                    this._4ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(stereogrParams.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(stereogrParams.getOriginLatitude() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(stereogrParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(stereogrParams.getFalseNorthing()));
                    break;
                }
                case 32: {
                    this.inputProjectionLabel.setText("Transverse Cylindrical Equal Area Projection");
                    TransverseCylindricalEqualArea trcyleqaParams = this.jniEngine.JNIGetTransverseCylindricalEqualAreaParams(this.state, this.direction);
                    this.setFiveParams();
                    this.setFiveParamsUnedit();
                    this._3ParamFieldsRow1TextFieldA.setText(this.jniStrtoval.JNILongitudeToString(trcyleqaParams.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILatitudeToString(trcyleqaParams.getOriginLatitude() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this.jniStrtoval.setNumberFormat(this._3ParamFieldsRow1TextFieldC, trcyleqaParams.getScaleFactor(), 5);
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(trcyleqaParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(trcyleqaParams.getFalseNorthing()));
                    break;
                }
                case 33: {
                    this.inputProjectionLabel.setText("Transverse Mercator Projection");
                    TransverseMercator tranmercParams = this.jniEngine.JNIGetTransverseMercatorParams(this.state, this.direction);
                    this.setFiveParams();
                    this.setFiveParamsUnedit();
                    this._3ParamFieldsRow1TextFieldA.setText(this.jniStrtoval.JNILongitudeToString(tranmercParams.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILatitudeToString(tranmercParams.getOriginLatitude() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this.jniStrtoval.setNumberFormat(this._3ParamFieldsRow1TextFieldC, tranmercParams.getScaleFactor(), 5);
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(tranmercParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(tranmercParams.getFalseNorthing()));
                    break;
                }
                case 34: {
                    this.inputProjectionLabel.setText("Van der Grinten Projection");
                    VanDerGrinten grintenParams = this.jniEngine.JNIGetVanDerGrintenParams(this.state, this.direction);
                    this.setThreeParams();
                    this.setThreeParamsUnedit();
                    this._3ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(grintenParams.getCentralMeridian() * 180.0 / Math.PI, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(grintenParams.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(grintenParams.getFalseNorthing()));
                    break;
                }
                case 8: {
                    this.inputProjectionLabel.setText("Universal Polar Stereographic (UPS) Projection");
                    this.hideParams();
                    break;
                }
                case 6: {
                    this.inputProjectionLabel.setText("USNG Coordinates");
                    this.hideParams();
                    break;
                }
                case 7: {
                    this.inputProjectionLabel.setText("Universal Transverse Mercator (UTM) Projection");
                    this.hideParams();
                    break;
                }
            }
        }
        catch (GeotransError e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        catch (GeotransWarning e) {
            this.jniStrtoval.displayWarningMsg(this, e.getMessage());
        }
        catch (JNIException e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
    }

    private void initMasterPanel() {
        try {
            this.datumTextField.setVisible(false);
            this.inputProjectionLabel.setVisible(false);
            this.fillHeightList();
            this.datumList = new FillList(this.datumComboBox, 0);
            this.fillProjectionList();
            this.projectionType = this.direction == 1 && this.state == 1 ? 7 : 0;
            this.jniEngine.JNISetCoordinateSystem(this.state, this.direction, this.projectionType);
            this.projectionComboBox.setSelectedItem(CoordinateTypes.name(this.projectionType));
            if (this.state == 1) {
                this.coordPanel.createCoordPanel(this.projectionType);
            }
            this.createButtonGroups();
            this.createMasterPanel();
        }
        catch (GeotransError e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
    }

    private void createMasterPanel() {
        this.setFormat();
        switch (this.projectionType) {
            case 0: {
                this.hideParams();
                this.setHeight();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 25: 
            case 35: {
                this.hideParams();
                break;
            }
            case 8: {
                if (this.state == 1) {
                    this.setZone_Hemi();
                    this.zoneHemiPanel.setBounds(90, 0, 462, 55);
                    this.zoneBoxPanel.setVisible(false);
                } else {
                    this.hideParams();
                }
                if (Platform.isJavaV1_3) break;
                if (Platform.isUnix) {
                    if (this.currLookAndFeel.equals("Java")) {
                        this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 1, 10), Color.black));
                        break;
                    }
                    this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 0, 10), Color.black));
                    break;
                }
                if (this.currLookAndFeel.equals("Java")) {
                    this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 1, 12)));
                    break;
                }
                this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 0, 12)));
                break;
            }
            case 7: {
                this.setZone_Hemi();
                this.zoneHemiPanel.setBounds(0, 0, 462, 55);
                if (this.state == 1) {
                    this.hemiBoxPanel.setVisible(true);
                } else {
                    this.hemiBoxPanel.setVisible(false);
                }
                this.zoneBoxPanel.setVisible(true);
                if (Platform.isJavaV1_3) break;
                if (Platform.isUnix) {
                    if (this.currLookAndFeel.equals("Java")) {
                        this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 1, 10), Color.black));
                        break;
                    }
                    this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 0, 10), Color.black));
                    break;
                }
                if (this.currLookAndFeel.equals("Java")) {
                    this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 1, 12)));
                    break;
                }
                this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 0, 12)));
                break;
            }
            case 4: {
                this.setLCFourParams();
                this._3ParamFieldsRow1TextFieldC.setEditable(true);
                break;
            }
            case 26: {
                this.setEightParams();
                break;
            }
            case 9: 
            case 20: {
                this.setSixParams();
                break;
            }
            case 24: {
                this.setSixParams();
                this._4ParamFieldsRow1Panel.setVisible(false);
                this.neysParamsRow1Panel.setVisible(true);
                this.neys71RadioButton.setSelected(true);
                try {
                    this.centralMeridianNeysParamsTextField.setText(this.jniStrtoval.JNILongitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
                    this.originLatitudeNeysParamsTextField.setText(this.jniStrtoval.JNILatitudeToString(80.0, this.useNSEW, this.useMinutes, this.useSeconds));
                    this.stdParallel2NeysParamsTextField.setText(this.jniStrtoval.JNILatitudeToString(89.99944444444444, false, this.useMinutes, this.useSeconds));
                }
                catch (GeotransError e) {
                    this.jniStrtoval.displayErrorMsg(this, e.getMessage());
                }
                catch (JNIException e) {
                    this.jniStrtoval.displayErrorMsg(this, e.getMessage());
                }
                if (Platform.isJavaV1_3) break;
                if (Platform.isUnix) {
                    if (this.currLookAndFeel.equals("Java")) {
                        this.stdParallel1NeysParamsPanel.setBorder(new TitledBorder(null, "Std. Parallel 1:", 2, 0, new Font("Dialog", 1, 10), Color.black));
                        break;
                    }
                    this.stdParallel1NeysParamsPanel.setBorder(new TitledBorder(null, "Std. Parallel 1:", 2, 0, new Font("Dialog", 0, 10), Color.black));
                    break;
                }
                if (this.currLookAndFeel.equals("Java")) {
                    this.stdParallel1NeysParamsPanel.setBorder(new TitledBorder(null, "Std. Parallel 1:", 2, 0, new Font("Dialog", 1, 12)));
                    break;
                }
                this.stdParallel1NeysParamsPanel.setBorder(new TitledBorder(null, "Std. Parallel 1:", 2, 0, new Font("Dialog", 0, 12)));
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 27: 
            case 29: 
            case 31: {
                this.setFourParams();
                break;
            }
            case 12: {
                this.setFourParams();
                try {
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(45.0, this.useNSEW, this.useMinutes, this.useSeconds));
                }
                catch (GeotransError e) {
                    this.jniStrtoval.displayErrorMsg(this, e.getMessage());
                }
                catch (JNIException e) {
                    this.jniStrtoval.displayErrorMsg(this, e.getMessage());
                }
                break;
            }
            case 17: {
                this.setFourParams();
                this._4ParamFieldsRow1LabelC.setText("Standard Parallel:");
                break;
            }
            case 28: {
                this.setFourParams();
                try {
                    this._4ParamFieldsRow1LabelB.setText("Long. Down:");
                    this._4ParamFieldsRow1LabelC.setText("Lat. of True Scale:");
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(90.0, this.useNSEW, this.useMinutes, this.useSeconds));
                }
                catch (GeotransError e) {
                    this.jniStrtoval.displayErrorMsg(this, e.getMessage());
                }
                catch (JNIException e) {
                    this.jniStrtoval.displayErrorMsg(this, e.getMessage());
                }
                break;
            }
            case 15: 
            case 16: 
            case 22: 
            case 23: 
            case 30: 
            case 34: {
                this.setThreeParams();
                break;
            }
            case 21: {
                this.setFiveParams();
                this._3ParamFieldsRow1LabelB.setText("Lat. of True Scale:");
                this._3ParamFieldsRow1TextFieldC.setEditable(false);
                break;
            }
            case 19: {
                this.setFiveParams();
                this._3ParamFieldsRow1TextFieldC.setEditable(true);
                try {
                    this._3ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILatitudeToString(45.0, this.useNSEW, this.useMinutes, this.useSeconds));
                }
                catch (GeotransError e) {
                    this.jniStrtoval.displayErrorMsg(this, e.getMessage());
                }
                catch (JNIException e) {
                    this.jniStrtoval.displayErrorMsg(this, e.getMessage());
                }
                break;
            }
            case 32: 
            case 33: {
                this.setFiveParams();
                this._3ParamFieldsRow1TextFieldC.setEditable(true);
                break;
            }
        }
    }

    public void setEngine() {
        try {
            this.jniEngine.JNISetDatum(this.state, this.direction, this.datumComboBox.getSelectedIndex());
            if (this.projectionType == 35) {
                this.jniEngine.JNISetCoordinateSystem(this.state, this.direction, 5);
            } else {
                this.jniEngine.JNISetCoordinateSystem(this.state, this.direction, this.projectionType);
            }
            switch (this.projectionType) {
                case 9: {
                    AlbersEqualAreaConic albersParams = new AlbersEqualAreaConic(this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Origin Latitude"), this.jniStrtoval.stringToLongitude(this._4ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid 1st Standard Parallel"), this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldD.getText().trim(), "Invalid 2nd Standard Parallel"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetAlbersEqualAreaConicParams(this.state, this.direction, albersParams);
                    break;
                }
                case 10: {
                    AzimuthalEquidistant azeqParams = new AzimuthalEquidistant(this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Origin Latitude"), this.jniStrtoval.stringToLongitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetAzimuthalEquidistantParams(this.state, this.direction, azeqParams);
                    break;
                }
                case 12: {
                    Bonne bonneParams = new Bonne(this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Origin Latitude"), this.jniStrtoval.stringToLongitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetBonneParams(this.state, this.direction, bonneParams);
                    break;
                }
                case 13: {
                    Cassini cassiniParams = new Cassini(this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Origin Latitude"), this.jniStrtoval.stringToLongitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetCassiniParams(this.state, this.direction, cassiniParams);
                    break;
                }
                case 14: {
                    CylindricalEqualArea cyleqaParams = new CylindricalEqualArea(this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Origin Latitude"), this.jniStrtoval.stringToLongitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetCylindricalEqualAreaParams(this.state, this.direction, cyleqaParams);
                    break;
                }
                case 15: {
                    Eckert4 eckert4Params = new Eckert4(this.jniStrtoval.stringToLongitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetEckert4Params(this.state, this.direction, eckert4Params);
                    break;
                }
                case 16: {
                    Eckert6 eckert6Params = new Eckert6(this.jniStrtoval.stringToLongitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetEckert6Params(this.state, this.direction, eckert6Params);
                    break;
                }
                case 17: {
                    EquidistantCylindrical eqdcylParams = new EquidistantCylindrical(this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Standard Parallel"), this.jniStrtoval.stringToLongitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetEquidistantCylindricalParams(this.state, this.direction, eqdcylParams);
                    break;
                }
                case 0: {
                    Geodetic geodeticParams = new Geodetic(this.heightType);
                    this.jniEngine.JNISetGeodeticParams(this.state, this.direction, geodeticParams);
                    break;
                }
                case 18: {
                    Gnomonic gnomonicParams = new Gnomonic(this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Origin Latitude"), this.jniStrtoval.stringToLongitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetGnomonicParams(this.state, this.direction, gnomonicParams);
                    break;
                }
                case 19: {
                    LambertConformalConic1 lambert1Params = new LambertConformalConic1(this.jniStrtoval.stringToLatitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Origin Latitude"), this.jniStrtoval.stringToLongitude(this._3ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToDouble(this._3ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Scale Factor"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetLambertConformalConic1Params(this.state, this.direction, lambert1Params);
                    break;
                }
                case 20: {
                    LambertConformalConic2 lambert2Params = new LambertConformalConic2(this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Origin Latitude"), this.jniStrtoval.stringToLongitude(this._4ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid 1st Standard Parallel"), this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldD.getText().trim(), "Invalid 2nd Standard Parallel"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetLambertConformalConic2Params(this.state, this.direction, lambert2Params);
                    break;
                }
                case 4: {
                    LocalCartesian loccartParams = new LocalCartesian(this.jniStrtoval.stringToLatitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Origin Latitude"), this.jniStrtoval.stringToLongitude(this._3ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Origin Longitude"), this.jniStrtoval.stringToDouble(this._3ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Origin Height"), this.jniStrtoval.stringToLongitude(this._3ParamFieldsRow2TextFieldB.getText().trim(), "Invalid Orientation"));
                    this.jniEngine.JNISetLocalCartesianParams(this.state, this.direction, loccartParams);
                    break;
                }
                case 21: {
                    Mercator mercatorParams = new Mercator(this.jniStrtoval.stringToLatitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Latitude of True Scale"), this.jniStrtoval.stringToLongitude(this._3ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToDouble(this._3ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Scale Factor"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetMercatorParams(this.state, this.direction, mercatorParams);
                    break;
                }
                case 22: {
                    MillerCylindrical millerParams = new MillerCylindrical(this.jniStrtoval.stringToLongitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetMillerCylindricalParams(this.state, this.direction, millerParams);
                    break;
                }
                case 23: {
                    Mollweide mollweidParams = new Mollweide(this.jniStrtoval.stringToLongitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetMollweideParams(this.state, this.direction, mollweidParams);
                    break;
                }
                case 24: {
                    int std_par_1 = 71;
                    if (this.neys71RadioButton.isSelected()) {
                        std_par_1 = 71;
                    } else if (this.neys74RadioButton.isSelected()) {
                        std_par_1 = 74;
                    }
                    Neys neysParams = new Neys(this.jniStrtoval.stringToLatitude(this.originLatitudeNeysParamsTextField.getText().trim(), "Invalid Origin Latitude"), this.jniStrtoval.stringToLongitude(this.centralMeridianNeysParamsTextField.getText().trim(), "Invalid Central Meridian"), (double)std_par_1 * Math.PI / 180.0, this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetNeysParams(this.state, this.direction, neysParams);
                    break;
                }
                case 26: {
                    ObliqueMercator omercParams = new ObliqueMercator(this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Origin Latitude"), this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldD.getText().trim(), "Invalid Latitude 1"), this.jniStrtoval.stringToLongitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Longitude 1"), this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid Latitude 2"), this.jniStrtoval.stringToLongitude(this._4ParamFieldsRow2TextFieldA.getText().trim(), "Invalid Longitude 2"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Scale Factor"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldD.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetObliqueMercatorParams(this.state, this.direction, omercParams);
                    break;
                }
                case 27: {
                    Orthographic orthogrParams = new Orthographic(this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Origin Latitude"), this.jniStrtoval.stringToLongitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetOrthographicParams(this.state, this.direction, orthogrParams);
                    break;
                }
                case 28: {
                    PolarStereographic polarstParams = new PolarStereographic(this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid latitude of true scale"), this.jniStrtoval.stringToLongitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid longitude down from pole"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetPolarStereographicParams(this.state, this.direction, polarstParams);
                    break;
                }
                case 29: {
                    Polyconic polyconParams = new Polyconic(this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Origin Latitude"), this.jniStrtoval.stringToLongitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetPolyconicParams(this.state, this.direction, polyconParams);
                    break;
                }
                case 30: {
                    Sinusoidal sinusoidParams = new Sinusoidal(this.jniStrtoval.stringToLongitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetSinusoidalParams(this.state, this.direction, sinusoidParams);
                    break;
                }
                case 31: {
                    Stereographic stereogrParams = new Stereographic(this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Origin Latitude"), this.jniStrtoval.stringToLongitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetStereographicParams(this.state, this.direction, stereogrParams);
                    break;
                }
                case 32: {
                    TransverseCylindricalEqualArea trcyleqaParams = new TransverseCylindricalEqualArea(this.jniStrtoval.stringToLatitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Origin Latitude"), this.jniStrtoval.stringToLongitude(this._3ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToDouble(this._3ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Scale Factor"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetTransverseCylindricalEqualAreaParams(this.state, this.direction, trcyleqaParams);
                    break;
                }
                case 33: {
                    TransverseMercator tranmercParams = new TransverseMercator(this.jniStrtoval.stringToLatitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Origin Latitude"), this.jniStrtoval.stringToLongitude(this._3ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToDouble(this._3ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Scale Factor"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetTransverseMercatorParams(this.state, this.direction, tranmercParams);
                    break;
                }
                case 34: {
                    VanDerGrinten grintenParams = new VanDerGrinten(this.jniStrtoval.stringToLongitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
                    this.jniEngine.JNISetVanDerGrintenParams(this.state, this.direction, grintenParams);
                    break;
                }
                case 7: {
                    UTM UTMParams;
                    if (this.zoneRadioButton.isSelected()) {
                        long zone = this.jniStrtoval.stringToLong(this.zoneTextField.getText().trim(), "Invalid zone");
                        if (zone < 1L || zone > 60L) {
                            throw new GeotransError("Zone out of range (1-60)");
                        }
                        UTMParams = new UTM(this.jniStrtoval.stringToLong(this.zoneTextField.getText().trim(), "Invalid zone"), this.override);
                    } else {
                        UTMParams = new UTM(0L, this.override);
                    }
                    this.jniEngine.JNISetUTMParams(this.state, this.direction, UTMParams);
                    break;
                }
            }
            if (this.state != 0 && this.direction != 1) {
                if (this.projectionType == 7) {
                    this.coordPanel.setZone((int)this.jniStrtoval.stringToLong(this.zoneTextField.getText().trim(), "Invalid zone"));
                    if (this.nHemiRadioButton.isSelected()) {
                        this.coordPanel.setHemisphere('N');
                    } else {
                        this.coordPanel.setHemisphere('S');
                    }
                } else if (this.projectionType == 8) {
                    if (this.nHemiRadioButton.isSelected()) {
                        this.coordPanel.setHemisphere('N');
                    } else {
                        this.coordPanel.setHemisphere('S');
                    }
                }
                this.coordPanel.setCoords(this.state, this.direction, this.projectionType);
                this.coordPanel.setAccuracy();
            }
        }
        catch (GeotransError e) {
            this.jniStrtoval.setEngineError(true, e.getMessage());
        }
        catch (JNIException e) {
            this.jniStrtoval.setJNIError(true, e.getMessage());
        }
    }

    private void createButtonGroups() {
        ButtonGroup hemi_group = new ButtonGroup();
        ButtonGroup neys_group = new ButtonGroup();
        hemi_group.add(this.nHemiRadioButton);
        hemi_group.add(this.sHemiRadioButton);
        neys_group.add(this.neys71RadioButton);
        neys_group.add(this.neys74RadioButton);
    }

    private void hideParams() {
        this.paramFieldsRow1LayeredPane.setMinimumSize(new Dimension(460, 55));
        this.paramFieldsRow1LayeredPane.setMaximumSize(new Dimension(460, 55));
        this.paramFieldsRow1LayeredPane.setPreferredSize(new Dimension(460, 55));
        this.paramFieldsRow2LayeredPane.setMinimumSize(new Dimension(460, 55));
        this.paramFieldsRow2LayeredPane.setMaximumSize(new Dimension(460, 55));
        this.paramFieldsRow2LayeredPane.setPreferredSize(new Dimension(460, 55));
        this._3ParamFieldsRow1Panel.setBounds(0, 0, 462, 38);
        this._3ParamFieldsRow2Panel.setBounds(0, 0, 462, 38);
        this._3ParamFieldsRow1Panel.setVisible(false);
        this._4ParamFieldsRow1Panel.setVisible(false);
        this._3ParamFieldsRow2Panel.setVisible(false);
        this._4ParamFieldsRow2Panel.setVisible(false);
        this.neysParamsRow1Panel.setVisible(false);
        this.zoneHemiPanel.setVisible(false);
        this.heightPanel.setVisible(false);
        this.heightLabelPanel.setVisible(false);
    }

    private void setHeight() {
        this.hideParams();
        this.heightPanel.setVisible(true);
        this.paramFieldsRow2LayeredPane.moveToFront(this.heightPanel);
        try {
            int inputFileType = this.jniEngine.JNIGetCoordinateSystem(this.state, 0);
            if (this.state == 0 && !this.createHeader && inputFileType != 0 && inputFileType != 3 && inputFileType != 4) {
                this.selectNoHeightButton();
            } else {
                this.heightType = 1;
                this.heightComboBox.setSelectedIndex(this.heightType);
            }
        }
        catch (GeotransError e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
    }

    private void setZone_Hemi() {
        this.hideParams();
        this.zoneHemiPanel.setVisible(true);
        this.paramFieldsRow2LayeredPane.moveToFront(this.zoneHemiPanel);
        this.nHemiRadioButton.setSelected(true);
        this.zoneTextField.setText("0");
        this.zoneRadioButton.setSelected(false);
        this.override = 0L;
    }

    private void setThreeParams() {
        this.setFormat();
        this.hideParams();
        this._3ParamFieldsRow1Panel.setVisible(true);
        this._4ParamFieldsRow2Panel.setVisible(true);
        this.paramFieldsRow1LayeredPane.setMinimumSize(new Dimension(439, 55));
        this.paramFieldsRow1LayeredPane.setMaximumSize(new Dimension(439, 55));
        this.paramFieldsRow1LayeredPane.setPreferredSize(new Dimension(439, 55));
        this._3ParamFieldsRow1Panel.setBounds(2, 2, 439, 37);
        this._3ParamFieldsRow1LabelA.setVisible(false);
        this._3ParamFieldsRow1LabelC.setVisible(false);
        this._4ParamFieldsRow2LabelA.setVisible(false);
        this._4ParamFieldsRow2LabelD.setVisible(false);
        this._3ParamFieldsRow1TextFieldA.setVisible(false);
        this._3ParamFieldsRow1TextFieldC.setVisible(false);
        this._4ParamFieldsRow2TextFieldA.setVisible(false);
        this._4ParamFieldsRow2TextFieldD.setVisible(false);
        this._3ParamFieldsRow1LabelB.setText("Central Meridian:");
        this._4ParamFieldsRow2LabelB.setText("False Easting (m):");
        this._4ParamFieldsRow2LabelC.setText("False Northing (m):");
        try {
            this._3ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
        }
        catch (GeotransError e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        catch (JNIException e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        this._4ParamFieldsRow2TextFieldB.setText("0");
        this._4ParamFieldsRow2TextFieldC.setText("0");
    }

    private void setThreeParamsUnedit() {
        this._3ParamFieldsRow1TextFieldB.setEditable(false);
        this._4ParamFieldsRow2TextFieldB.setEditable(false);
        this._4ParamFieldsRow2TextFieldC.setEditable(false);
    }

    private void setFourParams() {
        this.setFormat();
        this.hideParams();
        this._4ParamFieldsRow1Panel.setVisible(true);
        this._4ParamFieldsRow2Panel.setVisible(true);
        this._4ParamFieldsRow1LabelA.setVisible(false);
        this._4ParamFieldsRow1LabelD.setVisible(false);
        this._4ParamFieldsRow2LabelA.setVisible(false);
        this._4ParamFieldsRow2LabelD.setVisible(false);
        this._4ParamFieldsRow1TextFieldA.setVisible(false);
        this._4ParamFieldsRow1TextFieldD.setVisible(false);
        this._4ParamFieldsRow2TextFieldA.setVisible(false);
        this._4ParamFieldsRow2TextFieldD.setVisible(false);
        this._4ParamFieldsRow1LabelB.setText("Central Meridian:");
        this._4ParamFieldsRow1LabelC.setText("Origin Latitude:");
        this._4ParamFieldsRow2LabelB.setText("False Easting (m):");
        this._4ParamFieldsRow2LabelC.setText("False Northing (m):");
        try {
            this._4ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
        }
        catch (GeotransError e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        catch (JNIException e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        this._4ParamFieldsRow2TextFieldB.setText("0");
        this._4ParamFieldsRow2TextFieldC.setText("0");
    }

    private void setFourParamsUnedit() {
        this._4ParamFieldsRow1TextFieldB.setEditable(false);
        this._4ParamFieldsRow1TextFieldC.setEditable(false);
        this._4ParamFieldsRow2TextFieldB.setEditable(false);
        this._4ParamFieldsRow2TextFieldC.setEditable(false);
    }

    private void setLCFourParams() {
        this.setFormat();
        this.hideParams();
        this._3ParamFieldsRow1Panel.setVisible(true);
        this._3ParamFieldsRow2Panel.setVisible(true);
        this.paramFieldsRow1LayeredPane.setMinimumSize(new Dimension(439, 55));
        this.paramFieldsRow1LayeredPane.setMaximumSize(new Dimension(439, 55));
        this.paramFieldsRow1LayeredPane.setPreferredSize(new Dimension(439, 55));
        this.paramFieldsRow2LayeredPane.setMinimumSize(new Dimension(439, 55));
        this.paramFieldsRow2LayeredPane.setMaximumSize(new Dimension(439, 55));
        this.paramFieldsRow2LayeredPane.setPreferredSize(new Dimension(439, 55));
        this._3ParamFieldsRow1Panel.setBounds(2, 2, 439, 37);
        this._3ParamFieldsRow2Panel.setBounds(2, 2, 439, 37);
        this._3ParamFieldsRow1LabelA.setVisible(true);
        this._3ParamFieldsRow1LabelC.setVisible(true);
        this._3ParamFieldsRow1TextFieldA.setVisible(true);
        this._3ParamFieldsRow1TextFieldC.setVisible(true);
        this._3ParamFieldsRow2LabelA.setVisible(false);
        this._3ParamFieldsRow2LabelC.setVisible(false);
        this._3ParamFieldsRow2TextFieldA.setVisible(false);
        this._3ParamFieldsRow2TextFieldC.setVisible(false);
        this._3ParamFieldsRow1LabelA.setText("Origin Longitude:");
        this._3ParamFieldsRow1LabelB.setText("Origin Latitude:");
        this._3ParamFieldsRow1LabelC.setText("Origin Height (m):");
        this._3ParamFieldsRow2LabelB.setText("Orientation:");
        try {
            this._3ParamFieldsRow1TextFieldA.setText(this.jniStrtoval.JNILongitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._3ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILatitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._3ParamFieldsRow1TextFieldC.setText("0");
            this._3ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
        }
        catch (GeotransError e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        catch (JNIException e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
    }

    private void setLCFourParamsUnedit() {
        this._3ParamFieldsRow1TextFieldA.setEditable(false);
        this._3ParamFieldsRow1TextFieldB.setEditable(false);
        this._3ParamFieldsRow1TextFieldC.setEditable(false);
        this._3ParamFieldsRow2TextFieldB.setEditable(false);
    }

    private void setFiveParams() {
        this.setFormat();
        this.hideParams();
        this._3ParamFieldsRow1Panel.setVisible(true);
        this._4ParamFieldsRow2Panel.setVisible(true);
        this.paramFieldsRow1LayeredPane.setMinimumSize(new Dimension(439, 55));
        this.paramFieldsRow1LayeredPane.setMaximumSize(new Dimension(439, 55));
        this.paramFieldsRow1LayeredPane.setPreferredSize(new Dimension(439, 55));
        this._3ParamFieldsRow1Panel.setBounds(2, 2, 439, 37);
        this._3ParamFieldsRow1LabelA.setVisible(true);
        this._3ParamFieldsRow1LabelC.setVisible(true);
        this._3ParamFieldsRow1TextFieldA.setVisible(true);
        this._3ParamFieldsRow1TextFieldC.setVisible(true);
        this._4ParamFieldsRow2LabelA.setVisible(false);
        this._4ParamFieldsRow2LabelD.setVisible(false);
        this._4ParamFieldsRow2TextFieldA.setVisible(false);
        this._4ParamFieldsRow2TextFieldD.setVisible(false);
        this._3ParamFieldsRow1LabelA.setText("Central Meridian:");
        this._3ParamFieldsRow1LabelB.setText("Origin Latitude:");
        this._3ParamFieldsRow1LabelC.setText("Scale Factor:");
        this._4ParamFieldsRow2LabelB.setText("False Easting (m):");
        this._4ParamFieldsRow2LabelC.setText("False Northing (m):");
        try {
            this._3ParamFieldsRow1TextFieldA.setText(this.jniStrtoval.JNILongitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._3ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILatitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
        }
        catch (GeotransError e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        catch (JNIException e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        this._3ParamFieldsRow1TextFieldC.setText("1.00000");
        this._4ParamFieldsRow2TextFieldB.setText("0");
        this._4ParamFieldsRow2TextFieldC.setText("0");
    }

    private void setFiveParamsUnedit() {
        this._3ParamFieldsRow1TextFieldA.setEditable(false);
        this._3ParamFieldsRow1TextFieldB.setEditable(false);
        this._3ParamFieldsRow1TextFieldC.setEditable(false);
        this._4ParamFieldsRow2TextFieldB.setEditable(false);
        this._4ParamFieldsRow2TextFieldC.setEditable(false);
    }

    private void setSixParams() {
        this.setFormat();
        this.hideParams();
        this._4ParamFieldsRow1Panel.setVisible(true);
        this._4ParamFieldsRow2Panel.setVisible(true);
        this._4ParamFieldsRow1LabelA.setVisible(true);
        this._4ParamFieldsRow1LabelD.setVisible(true);
        this._4ParamFieldsRow2LabelA.setVisible(false);
        this._4ParamFieldsRow2LabelD.setVisible(false);
        this._4ParamFieldsRow1TextFieldA.setVisible(true);
        this._4ParamFieldsRow1TextFieldD.setVisible(true);
        this._4ParamFieldsRow2TextFieldA.setVisible(false);
        this._4ParamFieldsRow2TextFieldD.setVisible(false);
        this._4ParamFieldsRow1LabelA.setText("Central Meridian:");
        this._4ParamFieldsRow1LabelB.setText("Origin Latitude:");
        this._4ParamFieldsRow1LabelC.setText("Std. Parallel 1:");
        this._4ParamFieldsRow1LabelD.setText("Std. Parallel 2:");
        this._4ParamFieldsRow2LabelB.setText("False Easting (m):");
        this._4ParamFieldsRow2LabelC.setText("False Northing (m):");
        try {
            this._4ParamFieldsRow1TextFieldA.setText(this.jniStrtoval.JNILongitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._4ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILatitudeToString(45.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(40.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._4ParamFieldsRow1TextFieldD.setText(this.jniStrtoval.JNILatitudeToString(50.0, this.useNSEW, this.useMinutes, this.useSeconds));
        }
        catch (GeotransError e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        catch (JNIException e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        this._4ParamFieldsRow2TextFieldB.setText("0");
        this._4ParamFieldsRow2TextFieldC.setText("0");
    }

    private void setSixParamsUnedit() {
        this._4ParamFieldsRow1TextFieldA.setEditable(false);
        this._4ParamFieldsRow1TextFieldB.setEditable(false);
        this._4ParamFieldsRow1TextFieldC.setEditable(false);
        this._4ParamFieldsRow1TextFieldD.setEditable(false);
        this._4ParamFieldsRow2TextFieldB.setEditable(false);
        this._4ParamFieldsRow2TextFieldC.setEditable(false);
    }

    private void setEightParams() {
        this.setFormat();
        this.hideParams();
        this._4ParamFieldsRow1Panel.setVisible(true);
        this._4ParamFieldsRow2Panel.setVisible(true);
        this._4ParamFieldsRow1LabelA.setVisible(true);
        this._4ParamFieldsRow1LabelD.setVisible(true);
        this._4ParamFieldsRow2LabelA.setVisible(true);
        this._4ParamFieldsRow2LabelD.setVisible(true);
        this._4ParamFieldsRow1TextFieldA.setVisible(true);
        this._4ParamFieldsRow1TextFieldD.setVisible(true);
        this._4ParamFieldsRow2TextFieldA.setVisible(true);
        this._4ParamFieldsRow2TextFieldD.setVisible(true);
        this._4ParamFieldsRow1LabelA.setText("Origin Latitude:");
        this._4ParamFieldsRow1LabelB.setText("Scale Factor:");
        this._4ParamFieldsRow1LabelC.setText("Longitude 1:");
        this._4ParamFieldsRow1LabelD.setText("Latitude 1:");
        this._4ParamFieldsRow2LabelA.setText("Longitude 2:");
        this._4ParamFieldsRow2LabelB.setText("Latitude 2:");
        this._4ParamFieldsRow2LabelC.setText("False Easting (m):");
        this._4ParamFieldsRow2LabelD.setText("False Northing (m):");
        try {
            this._4ParamFieldsRow1TextFieldA.setText(this.jniStrtoval.JNILatitudeToString(45.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._4ParamFieldsRow1TextFieldB.setText("1.00000");
            this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILongitudeToString(-5.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._4ParamFieldsRow1TextFieldD.setText(this.jniStrtoval.JNILatitudeToString(40.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._4ParamFieldsRow2TextFieldA.setText(this.jniStrtoval.JNILongitudeToString(5.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNILatitudeToString(50.0, this.useNSEW, this.useMinutes, this.useSeconds));
        }
        catch (GeotransError e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        catch (JNIException e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        this._4ParamFieldsRow2TextFieldC.setText("0");
        this._4ParamFieldsRow2TextFieldD.setText("0");
    }

    private void setEightParamsUnedit() {
        this._4ParamFieldsRow1TextFieldA.setEditable(false);
        this._4ParamFieldsRow1TextFieldB.setEditable(false);
        this._4ParamFieldsRow1TextFieldC.setEditable(false);
        this._4ParamFieldsRow1TextFieldD.setEditable(false);
        this._4ParamFieldsRow2TextFieldA.setEditable(false);
        this._4ParamFieldsRow2TextFieldB.setEditable(false);
        this._4ParamFieldsRow2TextFieldC.setEditable(false);
        this._4ParamFieldsRow2TextFieldD.setEditable(false);
    }

    private void fillHeightList() {
        this.heightComboBox.addItem("No Height");
        this.heightComboBox.addItem("Ellipsoid Height");
        this.heightComboBox.addItem("MSL-EGM96-15M-BL Height (recommended)");
        this.heightComboBox.addItem("MSL-EGM96-VG-NS Height");
        this.heightComboBox.addItem("MSL-EGM84-10D-BL Height");
        this.heightComboBox.addItem("MSL-EGM84-10D-NS Height");
    }

    private void fillProjectionList() {
        this.projectionComboBox.addItem("Geodetic");
        this.projectionComboBox.addItem("GEOREF");
        this.projectionComboBox.addItem("Global Area Reference System (GARS)");
        this.projectionComboBox.addItem("Geocentric");
        this.projectionComboBox.addItem("Local Cartesian");
        this.projectionComboBox.addItem("Military Grid Reference System (MGRS)");
        this.projectionComboBox.addItem("United States National Grid (USNG)");
        this.projectionComboBox.addItem("Universal Transverse Mercator (UTM)");
        this.projectionComboBox.addItem("Universal Polar Stereographic (UPS)");
        this.projectionComboBox.addItem("Albers Equal Area Conic");
        this.projectionComboBox.addItem("Azimuthal Equidistant (S)");
        this.projectionComboBox.addItem("British National Grid");
        this.projectionComboBox.addItem("Bonne");
        this.projectionComboBox.addItem("Cassini");
        this.projectionComboBox.addItem("Cylindrical Equal Area");
        this.projectionComboBox.addItem("Eckert IV (S)");
        this.projectionComboBox.addItem("Eckert VI (S)");
        this.projectionComboBox.addItem("Equidistant Cylindrical (S)");
        this.projectionComboBox.addItem("Gnomonic (S)");
        this.projectionComboBox.addItem("Lambert Conformal Conic (1 parallel)");
        this.projectionComboBox.addItem("Lambert Conformal Conic (2 parallel)");
        this.projectionComboBox.addItem("Mercator");
        this.projectionComboBox.addItem("Miller Cylindrical (S)");
        this.projectionComboBox.addItem("Mollweide (S)");
        this.projectionComboBox.addItem("Ney's (Modified Lambert Conformal Conic)");
        this.projectionComboBox.addItem("New Zealand Map Grid");
        this.projectionComboBox.addItem("Oblique Mercator");
        this.projectionComboBox.addItem("Orthographic (S)");
        this.projectionComboBox.addItem("Polar Stereographic");
        this.projectionComboBox.addItem("Polyconic");
        this.projectionComboBox.addItem("Sinusoidal");
        this.projectionComboBox.addItem("Stereographic (S)");
        this.projectionComboBox.addItem("Transverse Cylindrical Equal Area");
        this.projectionComboBox.addItem("Transverse Mercator");
        this.projectionComboBox.addItem("Van der Grinten");
        if (this.state != 0) {
            this.projectionComboBox.addItem("F-16 Grid Reference System");
        }
        this.projectionComboBox.updateUI();
    }

    private void setFormat() {
        this.useNSEW = this.formatOptions.getUseNSEW();
        this.useMinutes = this.formatOptions.getUseMinutes();
        this.useSeconds = this.formatOptions.getUseSeconds();
    }

    public static void main(String[] args) {
    }

    public void addDatumToList() {
        int currentListIndex = this.datumIndex - 1;
        this.datumList = new FillList(this.datumComboBox, 0);
        this.datumComboBox.setSelectedIndex(currentListIndex);
    }

    public void deleteDatumFromList(int index) {
        int currentListIndex = this.datumIndex - 1;
        this.datumList = new FillList(this.datumComboBox, 0);
        this.datumComboBox.setSelectedIndex(currentListIndex);
    }

    public void getCoords(int dir) {
        if (this.coordPanel.getCoords(this.state, dir, this.projectionType)) {
            if (this.projectionType == 21) {
                try {
                    Mercator mercatorParams = this.jniEngine.JNIGetMercatorParams(this.state, dir);
                    this.jniStrtoval.setNumberFormat(this._3ParamFieldsRow1TextFieldC, mercatorParams.getScaleFactor(), 5);
                }
                catch (GeotransError e) {
                    this.jniStrtoval.displayErrorMsg(this, e.getMessage());
                }
                catch (JNIException e) {
                    this.jniStrtoval.displayErrorMsg(this, e.getMessage());
                }
            } else if (this.projectionType == 7) {
                this.zoneTextField.setText(String.valueOf(this.coordPanel.getZone()));
                if (this.coordPanel.getHemisphere() == 'N') {
                    this.nHemiRadioButton.setSelected(true);
                } else {
                    this.sHemiRadioButton.setSelected(true);
                }
            } else if (this.projectionType == 8) {
                if (this.coordPanel.getHemisphere() == 'N') {
                    this.nHemiRadioButton.setSelected(true);
                } else {
                    this.sHemiRadioButton.setSelected(true);
                }
            }
        }
    }

    public void showErrors(Component parent) {
        this.jniStrtoval.displayErrorMsg(parent, this.direction, this.projectionType);
    }

    public boolean engineError() {
        return this.jniStrtoval.getEngineError();
    }

    public boolean JNIError() {
        return this.jniStrtoval.getJNIError();
    }

    public void setHeightFieldEditable(boolean editable) {
        this.coordPanel.setHeightFieldEditable(editable);
    }

    public void setHeightText(String height) {
        this.coordPanel.setHeightText(height);
    }

    public void selectNoHeightButton() {
        this.heightType = 0;
        this.heightComboBox.setSelectedIndex(this.heightType);
    }

    public void selectEllipsoidHeightButton() {
        this.heightType = 1;
        this.heightComboBox.setSelectedIndex(this.heightType);
    }

    public void enableHeightComboBox(boolean enable) {
        this.heightComboBox.setEnabled(enable);
    }

    public int getProjectionType() {
        return this.projectionType;
    }

    public String getProjectionCode() {
        try {
            return this.jniEngine.JNIGetCoordinateSystemCode(this.projectionType + 1);
        }
        catch (Exception e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
            return "";
        }
    }

    public int getDatumIndex() {
        return this.datumIndex;
    }

    public String getDatumCode() {
        try {
            return this.jniEngine.JNIGetDatumCode(this.datumIndex);
        }
        catch (Exception e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
            return "";
        }
    }

    public void reportAccuracy() {
        this.coordPanel.reportOutputErrors(this.state);
    }

    public void resetAccuracy() {
        this.coordPanel.resetOutputErrors();
    }

    public void updateSrcErrors(boolean _3dConversion) {
        this.coordPanel.updateSrcErrors(_3dConversion);
    }

    public void setParent(Geotrans par) {
        this.parent = par;
    }

    public void setProjectionDir(int dir) {
        this.direction = dir;
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.currLookAndFeel = lookAndFeel;
        if (!Platform.isJavaV1_3) {
            switch (this.projectionType) {
                case 7: 
                case 8: {
                    if (Platform.isUnix) {
                        if (this.currLookAndFeel.equals("Java")) {
                            this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 1, 10), Color.black));
                            break;
                        }
                        this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 0, 10), Color.black));
                        break;
                    }
                    if (this.currLookAndFeel.equals("Java")) {
                        this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 1, 12)));
                        break;
                    }
                    this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 0, 12)));
                    break;
                }
                case 24: {
                    if (Platform.isUnix) {
                        if (this.currLookAndFeel.equals("Java")) {
                            this.stdParallel1NeysParamsPanel.setBorder(new TitledBorder(null, "Std. Parallel 1:", 2, 0, new Font("Dialog", 1, 10), Color.black));
                            break;
                        }
                        this.stdParallel1NeysParamsPanel.setBorder(new TitledBorder(null, "Std. Parallel 1:", 2, 0, new Font("Dialog", 0, 10), Color.black));
                        break;
                    }
                    if (this.currLookAndFeel.equals("Java")) {
                        this.stdParallel1NeysParamsPanel.setBorder(new TitledBorder(null, "Std. Parallel 1:", 2, 0, new Font("Dialog", 1, 12)));
                        break;
                    }
                    this.stdParallel1NeysParamsPanel.setBorder(new TitledBorder(null, "Std. Parallel 1:", 2, 0, new Font("Dialog", 0, 12)));
                }
            }
        }
    }

    public int getGeodeticHeight() {
        return this.heightType;
    }

    public long getZone() {
        if (this.zoneRadioButton.isSelected()) {
            long zone = this.jniStrtoval.stringToLong(this.zoneTextField.getText().trim(), "Invalid zone");
            if (zone < 1L || zone > 60L) {
                return 0L;
            }
            return zone;
        }
        return 0L;
    }

    public long getOverride() {
        return this.override;
    }

    public double get3ParamCentralMeridian() {
        return this.jniStrtoval.stringToLongitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian") * this._180OverPI;
    }

    public double getFalseEasting() {
        return this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting");
    }

    public double getFalseNorthing() {
        return this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing");
    }

    public double get4ParamCentralMeridian() {
        return this.jniStrtoval.stringToLongitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian") * this._180OverPI;
    }

    public double get4ParamOriginLatitude() {
        return this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Origin Latitude") * this._180OverPI;
    }

    public double get5ParamCentralMeridian() {
        return this.jniStrtoval.stringToLongitude(this._3ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Central Meridian") * this._180OverPI;
    }

    public double get5ParamOriginLatitude() {
        return this.jniStrtoval.stringToLatitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Origin Latitude") * this._180OverPI;
    }

    public double get5ParamScaleFactor() {
        return Double.parseDouble(this._3ParamFieldsRow1TextFieldC.getText().trim());
    }

    public double get6ParamCentralMeridian() {
        return this.jniStrtoval.stringToLongitude(this._4ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Central Meridian") * this._180OverPI;
    }

    public double get6ParamOriginLatitude() {
        return this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Origin Latitude") * this._180OverPI;
    }

    public double get6ParamStandardParallel1() {
        return this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid 1st Standard Parallel") * this._180OverPI;
    }

    public double get6ParamStandardParallel2() {
        return this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldD.getText().trim(), "Invalid 2nd Standard Parallel") * this._180OverPI;
    }

    public double getOriginLongitude() {
        return this.jniStrtoval.stringToLongitude(this._3ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Origin Longitude") * this._180OverPI;
    }

    public double getOriginLatitude() {
        return this.jniStrtoval.stringToLatitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Origin Latitude") * this._180OverPI;
    }

    public double getOriginHeight() {
        return this.jniStrtoval.stringToDouble(this._3ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Origin Height");
    }

    public double getOrientation() {
        return this.jniStrtoval.stringToLongitude(this._3ParamFieldsRow2TextFieldB.getText().trim(), "Invalid Orientation") * this._180OverPI;
    }

    public double getNeysCentralMeridian() {
        return this.jniStrtoval.stringToLongitude(this.centralMeridianNeysParamsTextField.getText().trim(), "Invalid Central Meridian") * this._180OverPI;
    }

    public double getNeysOriginLatitude() {
        return this.jniStrtoval.stringToLatitude(this.originLatitudeNeysParamsTextField.getText().trim(), "Invalid Origin Latitude") * this._180OverPI;
    }

    public double getNeysStandardParallel1() {
        double std_par_1 = 71.0;
        if (this.neys74RadioButton.isSelected()) {
            std_par_1 = 74.0;
        }
        return std_par_1;
    }

    public double getOmercOriginLatitude() {
        return this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Origin Latitude") * this._180OverPI;
    }

    public double getOmercLongitude1() {
        return this.jniStrtoval.stringToLongitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Longitude 1") * this._180OverPI;
    }

    public double getOmercLatitude1() {
        return this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow1TextFieldD.getText().trim(), "Invalid Latitude 1") * this._180OverPI;
    }

    public double getOmercLongitude2() {
        return this.jniStrtoval.stringToLongitude(this._4ParamFieldsRow2TextFieldA.getText().trim(), "Invalid Longitude 2") * this._180OverPI;
    }

    public double getOmercLatitude2() {
        return this.jniStrtoval.stringToLatitude(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid Latitude 2") * this._180OverPI;
    }

    public double getOmercFalseEasting() {
        return this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Easting");
    }

    public double getOmercFalseNorthing() {
        return this.jniStrtoval.stringToDouble(this._4ParamFieldsRow2TextFieldD.getText().trim(), "Invalid False Northing");
    }

    public double getOmercScaleFactor() {
        return this.jniStrtoval.stringToDouble(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Scale Factor");
    }

    public void setDefaults(int _datumIndex, int _projectionType, CoordinateSystemParameters _parameters) {
        this.datumIndex = _datumIndex;
        this.projectionType = _projectionType;
        this.datumComboBox.setSelectedIndex(this.datumIndex);
        this.projectionComboBox.setSelectedItem(CoordinateTypes.name(this.projectionType));
        this.createMasterPanel();
        try {
            switch (this.projectionType) {
                case 15: 
                case 16: 
                case 22: 
                case 23: 
                case 30: 
                case 34: {
                    MapProjection3Parameters parameters = (MapProjection3Parameters)_parameters;
                    this._3ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(parameters.getCentralMeridian(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(parameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(parameters.getFalseNorthing()));
                    break;
                }
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 18: 
                case 27: 
                case 29: 
                case 31: {
                    MapProjection4Parameters parameters = (MapProjection4Parameters)_parameters;
                    this._4ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(parameters.getCentralMeridian(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(parameters.getOriginLatitude(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(parameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(parameters.getFalseNorthing()));
                    break;
                }
                case 17: {
                    EquidistantCylindricalParameters parameters = (EquidistantCylindricalParameters)_parameters;
                    this._4ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(parameters.getCentralMeridian(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(parameters.getStandardParallel(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(parameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(parameters.getFalseNorthing()));
                    break;
                }
                case 19: 
                case 32: 
                case 33: {
                    MapProjection5Parameters parameters = (MapProjection5Parameters)_parameters;
                    this._3ParamFieldsRow1TextFieldA.setText(this.jniStrtoval.JNILongitudeToString(parameters.getCentralMeridian(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILatitudeToString(parameters.getOriginLatitude(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this.jniStrtoval.setNumberFormat(this._3ParamFieldsRow1TextFieldC, parameters.getScaleFactor(), 5);
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(parameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(parameters.getFalseNorthing()));
                    break;
                }
                case 21: {
                    MercatorParameters parameters = (MercatorParameters)_parameters;
                    this._3ParamFieldsRow1TextFieldA.setText(this.jniStrtoval.JNILongitudeToString(parameters.getCentralMeridian(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILatitudeToString(parameters.getLatitudeOfTrueScale(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this.jniStrtoval.setNumberFormat(this._3ParamFieldsRow1TextFieldC, parameters.getScaleFactor(), 5);
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(parameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(parameters.getFalseNorthing()));
                    break;
                }
                case 9: 
                case 20: {
                    MapProjection6Parameters parameters = (MapProjection6Parameters)_parameters;
                    this._4ParamFieldsRow1TextFieldA.setText(this.jniStrtoval.JNILongitudeToString(parameters.getCentralMeridian(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILatitudeToString(parameters.getOriginLatitude(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(parameters.getStandardParallel1(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldD.setText(this.jniStrtoval.JNILatitudeToString(parameters.getStandardParallel2(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(parameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(parameters.getFalseNorthing()));
                    break;
                }
                case 4: {
                    LocalCartesianParameters parameters = (LocalCartesianParameters)_parameters;
                    this._3ParamFieldsRow1TextFieldA.setText(this.jniStrtoval.JNILongitudeToString(parameters.getLongitude(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILatitudeToString(parameters.getLatitude(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNIMeterToString(parameters.getHeight()));
                    this._3ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(parameters.getOrientation(), this.useNSEW, this.useMinutes, this.useSeconds));
                    break;
                }
                case 24: {
                    NeysParameters parameters = (NeysParameters)_parameters;
                    boolean northHemi = true;
                    double olat = parameters.getOriginLatitude();
                    if (olat < 0.0) {
                        northHemi = false;
                    }
                    this.centralMeridianNeysParamsTextField.setText(this.jniStrtoval.JNILongitudeToString(parameters.getCentralMeridian(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this.originLatitudeNeysParamsTextField.setText(this.jniStrtoval.JNILatitudeToString(olat, this.useNSEW, this.useMinutes, this.useSeconds));
                    double standardParallel1 = parameters.getStandardParallel1();
                    if (standardParallel1 == 71.0) {
                        this.neys71RadioButton.setSelected(true);
                        this.neys74RadioButton.setSelected(false);
                    } else {
                        this.neys71RadioButton.setSelected(false);
                        this.neys74RadioButton.setSelected(true);
                    }
                    this.stdParallel2NeysParamsTextField.setText(this.jniStrtoval.JNILatitudeToString(89.99944444444444, false, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(parameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(parameters.getFalseNorthing()));
                    break;
                }
                case 26: {
                    ObliqueMercatorParameters parameters = (ObliqueMercatorParameters)_parameters;
                    this._4ParamFieldsRow1TextFieldA.setText(this.jniStrtoval.JNILatitudeToString(parameters.getOriginLatitude(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this.jniStrtoval.setNumberFormat(this._4ParamFieldsRow1TextFieldB, parameters.getScaleFactor(), 5);
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILongitudeToString(parameters.getLongitude1(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldD.setText(this.jniStrtoval.JNILatitudeToString(parameters.getLatitude1(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldA.setText(this.jniStrtoval.JNILongitudeToString(parameters.getLongitude2(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNILatitudeToString(parameters.getLatitude2(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(parameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldD.setText(this.jniStrtoval.JNIMeterToString(parameters.getFalseNorthing()));
                    break;
                }
                case 28: {
                    PolarStereographicParameters parameters = (PolarStereographicParameters)_parameters;
                    this._4ParamFieldsRow1TextFieldB.setText(this.jniStrtoval.JNILongitudeToString(parameters.getLongitudeDownFromPole(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.jniStrtoval.JNILatitudeToString(parameters.getLatitudeOfTrueScale(), this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.jniStrtoval.JNIMeterToString(parameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.jniStrtoval.JNIMeterToString(parameters.getFalseNorthing()));
                    break;
                }
                case 0: {
                    GeodeticParameters parameters = (GeodeticParameters)_parameters;
                    this.heightComboBox.setSelectedIndex(parameters.getHeightType());
                    break;
                }
                case 7: {
                    UTMParameters parameters = (UTMParameters)_parameters;
                    if (parameters.getOverride() != 0L) {
                        this.zoneRadioButton.setSelected(true);
                    } else {
                        this.zoneRadioButton.setSelected(false);
                    }
                    this.zoneTextField.setText(String.valueOf(parameters.getZone()));
                    break;
                }
            }
        }
        catch (GeotransError e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
        catch (JNIException e) {
            this.jniStrtoval.displayErrorMsg(this, e.getMessage());
        }
    }
}

