// GENPO - the GENeral Purpose Organ
// Copyright (C) 2003,2004 - Steve Merrony 

// This program is free software; you may redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free 
// Software Foundation; either version 2 of the License, or (at your option) 
// any later version.

// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details.

// You should have received a copy of the GNU General Public License along with 
// this program; if not, write to the Free Software Foundation, Inc., 59 Temple 
// Place, Suite 330, Boston, MA 02111-1307 USA

#include "midiConfigForm.h"

#include <qlayout.h>
#include <qpushbutton.h>

MidiConfigForm::MidiConfigForm( QWidget* parent, const char* name, bool modal )
  : QDialog( parent, name, modal )
{
  setCaption( "MIDI Configuration" );
  resize( 320, 320 );

  optionsFormLayout = new QVBoxLayout( this, 11, 6 );

  buttonsLayout = new QHBoxLayout( 0, 0, 6 );
  //spacer = new QSpacerItem( 0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum );
  //buttonsLayout->addItem( spacer );
  
  okPushButton = new QPushButton( "OK", this );
  okPushButton->setDefault( TRUE );
  buttonsLayout->addWidget( okPushButton );

  cancelPushButton = new QPushButton( "Cancel", this );
  buttonsLayout->addWidget( cancelPushButton );
  optionsFormLayout->addLayout( buttonsLayout );

  connect( okPushButton, SIGNAL( clicked() ), this, SLOT( accept() ) );
  connect( cancelPushButton, SIGNAL( clicked() ), this, SLOT( reject() ) );

}
