/****************************************************************************
** userinfo.cc
**
** Michael S. Borella <mike@borella.net>
**
** Methods for the user information class
**
****************************************************************************/

#include <algorithm>
#include <unistd.h>
#include <sys/types.h>
#include <sys/param.h>
#include <pwd.h>
#include "userinfo.h"

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 256
#endif

//---------------------------------------------------------------------------
//
// Userinfo::Userinfo()
//
// Constructor method.  Does most of the work
//
//---------------------------------------------------------------------------

Userinfo::Userinfo() throw (EH_system)
{
  struct passwd *pw;
  char host[MAXHOSTNAMELEN];
  char domain[MAXHOSTNAMELEN];

  // Get userid and name
  pw = getpwuid(getuid());
  if (pw == NULL)
    {
      EH_system e("cannot get user info");
      throw e;
    }

  // Store locally
  _userid = pw->pw_name;
  _username = pw->pw_gecos;
  
  // Get rid of annoying ,,, if its in the name
  string::iterator iter; 
  iter = find (_username.begin(), _username.end(), ',');
  if (iter)
    _username.erase(iter, _username.end());

  // Get host name
  if (gethostname(host, MAXHOSTNAMELEN) < 0)
    {
      EH_system e("cannot get host name");
      throw e;
    }
  _hostname = host;

  // Get the domain name
  _domainname = "";

  /*
   * The getdomainame() call is not supported on many systems, so we make
   * sure to check for it.  In particular, since autoconf is broken under
   * cygwin and getdomainname() is not present, we specifically check for 
   * __CYGWIN__
   */

#if defined(HAVE_GETDOMAINNAME) && !defined(__CYGWIN__)
  if (getdomainname(domain, MAXHOSTNAMELEN) == -1)
    {
      EH_system e("cannot get domain name");
      throw e;
    }
  _domainname = domain;
  if (_domainname == "(none)")
    _domainname = "";
  else
    _domainname = "." + _domainname;
#endif
}











