#  gconf.rb - 
#  Copyright (C) 2004-2006 Laurent Sansonetti
#              Modified by Frdric Logier        
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

require 'gconf2'
require 'singleton'

module Geekast
  module Model
    
    class Preferences
      include Singleton

      APP_DIR = "/apps/geekast/"


      def initialize
        puts "GCONF engaged !" if $DEBUG
        @client = GConf::Client.default
      end


      ### code from Alexandria (http://alexandria.rubyforge.org/) ###
      def method_missing(id, *args)
        method = id.id2name

        if match = /(.*)=$/.match(method)
          if args.length != 1
            raise "Set method #{method} should be called with " +
              "only one argument (was called with #{args.length})"
          end
          @client[APP_DIR + match[1]] = args.first
        else
          unless args.empty?
            raise "Get method #{method} should be called " +
              "without argument (was called with #{args.length})"
          end
          p method  if $DEBUG
          @client[APP_DIR + method]
        end                
      end
      
    end


  end
end
