#  bookmark.rb - 
#  Copyright (C) 2004-2006 Frdric Logier

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

# Sig
require 'geekast/lib/signal'

module Geekast
  module Model


    class Bookmark
      attr_reader :tree

      
      def initialize
        @sig = Sig.instance
      end
      
      
      
      def load(signal)
        book = open("r")
        YAML::load_documents(book) {|data|
          @sig.emit(signal, data)
        }
        book.close
      end



      def add(flux)
        book = open("a+")
        book << flux.to_yaml
        book << "\n"
        #        YAML.dump(flux,@book)
        book.fsync
        book.close
      end


      def del
        book = open("w")
        book.fsync
        book.close
      end


      #######
      private
      ######

      def open(mode)
        unless File.exist?(Geekast::Config::HOME_USER + "/.geekast/" + "bookmark.yaml")
          File.makedirs Geekast::Config::HOME_USER + '/.geekast'
          book = File.open(Geekast::Config::HOME_USER + "/.geekast/" + "bookmark.yaml", "w+")
        else
          book = File.open(Geekast::Config::HOME_USER + "/.geekast/" + "bookmark.yaml", mode)
        end
        return book
      end

    end

  end
end
