/*
 *      printing.h - this file is part of Geany, a fast and lightweight IDE
 *
 *      Copyright 2007-2010 Enrico Tröger <enrico(dot)troeger(at)uvena(dot)de>
 *      Copyright 2007-2010 Nick Treleaven <nick(dot)treleaven(at)btinternet(dot)com>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $Id: printing.h 4518 2010-01-01 22:55:18Z eht16 $
 */


#ifndef GEANY_PRINTING_H
#define GEANY_PRINTING_H 1


/* General printing preferences. */
typedef struct PrintingPrefs
{
	gboolean use_gtk_printing;
	gboolean print_line_numbers;
	gboolean print_page_numbers;
	gboolean print_page_header;
	gboolean page_header_basename;
	gchar *page_header_datefmt;
	gchar *external_print_cmd;
} PrintingPrefs;

extern PrintingPrefs printing_prefs;


#if GTK_CHECK_VERSION(2, 10, 0)
void printing_page_setup_gtk(void);
#endif

void printing_print_doc(GeanyDocument *doc);

#endif
