﻿package GCPlugins::GCgames::GCJeuxVideoCom;

###################################################
#
#  Copyright 2005-2009 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use utf8;

use GCPlugins::GCgames::GCgamesCommon;

{
    package GCPlugins::GCgames::GCPluginJeuxVideoCom;

    use base 'GCPlugins::GCgames::GCgamesPluginsBase';

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
        $self->{inside}->{$tagname}++;
        return if $self->{parsingEnded};
        if ($self->{parsingList})
        {
            if ($tagname eq 'ul')
            {
                    if ( $attr->{class} eq 'liste_liens' )
                    {
                        $self->{isGame} = 1 ;
                    }
            }
            elsif ($tagname eq 'img')
            {
                    if ( $attr->{alt}  )
                    {
                        $self->{SavePlatform} = $attr->{alt} ;
                    }
                    if ($attr->{src} =~ /t_jeux_populaires/)
                    {
                        $self->{parsingEnded} = 1;
                    }
            }
            elsif ($self->{isGame})
            {
                if ($tagname eq 'a')
                {
                    $self->{itemIdx}++;
                    $self->{itemsList}[$self->{itemIdx}]->{url} = $attr->{href};
                    $self->{itemsList}[$self->{itemIdx}]->{platform} = $self->{SavePlatform};
                    $self->{itemsList}[$self->{itemIdx}]->{platform} =~ s/Playstation Portable/PSP/;
                    $self->{isName} = 1 ;
                }
            }
        }
        elsif ($self->{parsingTips})
        {
            if (($tagname eq 'h3') && ($self->{isTip} ne 3))
            {
                $self->{isTip} = 2;
            }
            elsif ( (($tagname eq 'p') || ($tagname eq 'h5') || ($tagname eq 'h4') ) && ($self->{isTip} ne 3))
            {
                $self->{isTip} = 1;
            }
            elsif (($tagname eq 'div') && ($attr->{id} eq 'barre_outils'))
            {
                $self->{isTip} = 3;
            }
            elsif ($tagname eq 'head')
            {
                $self->{isTip} = 0;
                $self->{urlTips} = '';
            }

        }
        else
        {

            if ($tagname eq 'h2')
            {
                    $self->{is} = 'name';
            }
            elsif ( ($tagname eq 'img') && ($self->{curInfo}->{name}) && ($self->{curInfo}->{platform} eq '') )
            {
                    $self->{curInfo}->{platform} = $attr->{alt};
                    $self->{curInfo}->{platform} =~ s/Playstation Portable/PSP/;
            }
            elsif ($tagname eq 'strong')
            {
                   $self->{isStrong} = 1;
            }
            elsif ( ($tagname eq 'a') && ($self->{isEditor}) )
            {
                    $self->{is} = 'editor';
                    $self->{isEditor} = 0;
            }
            elsif ($self->{isDeveloper})
            {
                    $self->{is} = 'developer';
                    $self->{isDeveloper} = 0;
            }
            elsif (!$self->{bigPics} && ($tagname eq 'li') && ($attr->{class} eq 'jaquette') )
            {
                    $self->{isBox} = 1;
            }
            elsif ( ($tagname eq 'img') && ($self->{isBox}) )
            {
                    if (( $attr->{src} ne "http://image.jeuxvideo.com/pics/pasdimage2.gif" ) && ($attr->{src} ne "http://image.jeuxvideo.com/pics/pasdimage.gif") && ($attr->{src} ne "http://image.jeuxvideo.com/pics/pasjaquette.gif"))
                    {
                        $self->{curInfo}->{boxpic} = $attr->{src};
                        $self->{curInfo}->{boxpic} =~ s/20ft.jpg/20f.jpg/;
                    }
                    $self->{isBox} = 0;
            }
            elsif ( ($tagname eq 'div') && ($attr->{class} eq 'series_images') )
            {
                    $self->{isScreen} = 1;
            }
            elsif ( ($tagname eq 'img') && ($self->{isScreen}) )
            {
                if ($self->{curInfo}->{screenshot1} eq '')
                {
                    $self->{curInfo}->{screenshot1} = $attr->{src};
                    $self->{curInfo}->{screenshot1} =~ s/.gif/.jpg/;
                }
                elsif ($self->{curInfo}->{screenshot2} eq '')
                {
                    $self->{curInfo}->{screenshot2} = $attr->{src};
                    $self->{curInfo}->{screenshot2} =~ s/.gif/.jpg/;
                    $self->{isScreen} = 0;
                }
            }
            elsif ($tagname eq 'a')
            {
                if ($self->{bigPics} && ($attr->{href} =~ m|/affpic.htm\?(.*)$|))
                {
                    if (!$self->{curInfo}->{boxpic})
                    {
                        $self->{curInfo}->{boxpic} = 'http://image.jeuxvideo.com/'.$1
                    }
                    elsif (!$self->{curInfo}->{backpic})
                    {
                        $self->{curInfo}->{backpic} = 'http://image.jeuxvideo.com/'.$1
                    }
                }
                elsif (!$self->{bigPics} && ($attr->{href} =~ m|/affpic.htm\?(.*)$|))
                {
                    if ($self->{NbrImage} eq 0)
                    {
                        $self->{NbrImage} = 1;
                    }
                    elsif ((!$self->{curInfo}->{backpic}) && ($self->{NbrImage} eq 1))
                    {
                        $self->{curInfo}->{backpic} = 'http://image.jeuxvideo.com/'.$1 ;
                        $self->{NbrImage} = 0;
                    }
                }
                elsif (($attr->{href} =~ m^/(etajvhtm|cheats)/^) && ! ($self->{urlTips}))
                {
                    $self->{urlTips} = $attr->{href};
                }
                elsif (!$self->{curInfo}->{description} && ($attr->{href} =~ /[-_]test\.htm$/) && (!$self->{testLoaded}))
                {
                    my $html = $self->loadPage($attr->{href}, 0, 1);
                    my $found = index($html,"<p id=\"chapo\">");
                    if ( $found >= 0 )
                    {
                        my $html_Desc = substr($html, $found +length('<p id="chapo">'),length($html)- $found -length('<p id="chapo">'));
                        $html_Desc = substr($html_Desc,index($html_Desc,"<strong>") + length("<strong>"),index($html_Desc,"</strong>")-index($html_Desc,"<strong>")-length("<strong>") );
                        $html_Desc =~ s|\x{92}|'|gi;
                        #'
                        $self->{curInfo}->{description} = $html_Desc;
                    }
                    $self->{testLoaded} = 1;
                }
            }

        }
    }

    sub end
    {
        my ($self, $tagname) = @_;
		
        $self->{inside}->{$tagname}--;
        return if $self->{parsingEnded};
        if ($self->{parsingList})
        {
            if ($tagname eq 'ul')
            {
              $self->{isGame} = 0;
            }
        }
    }

    sub text
    {
        my ($self, $origtext) = @_;

        return if $self->{parsingEnded};
        if ($self->{parsingList})
        {
            if ($self->{isName})
            {
                $self->{itemsList}[$self->{itemIdx}]->{name} = $origtext;
                $self->{isName} = 0;
            }
            elsif ($self->{isDate})
            {
                $self->{itemsList}[$self->{itemIdx}]->{released} = $origtext;
                $self->{isDate} = 0;
            }
            elsif ($self->{isGenre})
            {
                $self->{itemsList}[$self->{itemIdx}]->{genre} = $origtext;
                $self->{isGenre} = 0;
            }
        }
        elsif ($self->{parsingTips})
        {
            $origtext =~ s/^\s*//;
            if ($self->{isTip} eq 2)
            {
                $self->{curInfo}->{secrets} .= "\n\n" if $self->{curInfo}->{secrets};
                $self->{curInfo}->{secrets} .= $origtext;
                $self->{isTip} = 0;
            }
            elsif ($self->{isTip} eq 1)
            {
                chomp($origtext);
                if ( ($self->{curInfo}->{secrets}) && ($origtext ne "") )
                {
                   $self->{curInfo}->{secrets} .= "\n"
                }
                $self->{curInfo}->{secrets} .= $origtext;
                $self->{isTip} = 0;
            }
        }
        else
        {
            if ($self->{isStrong})
            {
                $self->{is} = 'released' if ($origtext =~ /Sortie :/) || ($origtext =~ /Sortie France :/);
                $self->{is} = 'genre' if $origtext =~ /Type :/;
                $self->{is} = 'description' if $origtext =~ /Descriptif :/;
                $self->{isEditor} = 1 if $origtext =~ /Editeur :/;
                #$self->{is} = 'developer' if $origtext =~ /D.*?veloppeur :/;
                $self->{isDeveloper} = 'developer' if $origtext =~ /D.*?veloppeur :/;
                $self->{is} = 'players' if $origtext =~ /Multijoueurs :/;
                $self->{isStrong} = 0;
            }
            elsif ($self->{is})
            {
                $origtext =~ s/^\s*//;
                $origtext =~ s/\n$//;
                
                if ($self->{is} eq 'players')
                {
                    $origtext =~ s/-/1/;
                    $origtext =~ s/non/1/i;
                    $origtext =~ s/oui/Multijoueurs/i;
                }
                
                $self->{curInfo}->{$self->{is}} = $origtext;
                $self->{is} = '';
            }
        }
    } 

    sub getTipsUrl
    {
        my $self = shift;
        print "RETURNING ",$self->{urlTips},"\n";
        return $self->{urlTips};
        #my $html = $self->loadPage($self->{urlTips}, 0, 1);
        #$html =~ m|<div id="col1">(.*?)<div id="barre_outils">|ms;
        #$self->{curInfo}->{secrets} = $1;
        #return '';
    }

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            name => 1,
            platform => 1
        };

        $self->{isName} = 0;
        $self->{isGame} = 0;
        $self->{isEditor} = 0;
        $self->{isDeveloper} = 0;
        $self->{isDate} = 0;
        $self->{isGenre} = 0;
        $self->{isBox} = 0;
        $self->{isScreen} = 0;
        $self->{isTip} = 0;
        $self->{SavePlatform} = "";
        $self->{is} = '';
        $self->{isStrong} = '';
        $self->{urlTips} = "";
        $self->{NbrImage} = 0;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;
        $self->{parsingEnded} = 0;
        if ($self->{parsingTips})
        {
            $html =~ s|<br />|<p>|gi;
            $html =~ s|</kbd>||gi;
            $html =~ s|<b>||gi;
            $html =~ s|</b>||gi;
            $html =~ s|<img src="../pics/psx/cercle.gif"\s*(alt="CERCLE")?\s*/>|Cercle|gi;
            $html =~ s|<img src="../pics/psx/croix.gif"\s*(alt="CROIX")?\s*/>|Croix|gi;
            $html =~ s|<img src="../pics/psx/carre.gif"\s*(alt="CARRE")?\s*/>|Carré|gi;
            $html =~ s|<img src="../pics/psx/triangle.gif"\s*(alt="TRIANGLE")?\s*/>|Triangle|gi;
            $html =~ s|\x{92}|'|gi;
            $html =~ s|&#146;|'|gi;
            $html =~ s|&#149;|*|gi;
            $html =~ s|&#156;|oe|gi;
            $html =~ s|&#133;|...|gi;
            $html =~ s|\x{85}|...|gi;
            $html =~ s|\x{8C}|OE|gi;
            $html =~ s|\x{9C}|oe|gi;
            #'
        }
        $self->{testLoaded} = 0;
        return $html;
    }
    
    sub getSearchUrl
    {
        my ($self, $word) = @_;
        return 'http://www.jeuxvideo.com/recherche/0-'.$word.'.htm';
    }
    
    sub getItemUrl
    {
        my ($self, $url) = @_;
		
        return $url if $url;
        return 'http://www.jeuxvideo.com/';
    }

    sub getName
    {
        return 'jeuxvideo.com';
    }
    
    sub getAuthor
    {
        return 'TPF';
    }
    
    sub getLang
    {
        return 'FR';
    }

    sub getCharset
    {
        my $self = shift;
    
        return "ISO-8859-1";
    }
}

1;
