/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef GATOS_M64REGS_H
#define GATOS_M64REGS_H 1

#ifdef __cplusplus
extern "C" {
#endif

#ifdef GATOS_GATOS_C
#define WHERE       
#else
#define WHERE	extern
#endif

/* Accelerator CRTC Registers */
#define CRTC_H_TOTAL_DISP	(*(MEM_0+0x00))
#define CRTC_H_SYNC_STRT_WID	(*(MEM_0+0x01))
#define CRTC_V_TOTAL_DISP	(*(MEM_0+0x02))
#define CRTC_V_SYNC_STRT_WID	(*(MEM_0+0x03))
#define CRTC_OFF_PITCH		(*(MEM_0+0x05))
#define CRTC_INT_CNTL		(*(MEM_0+0x06))
#define CRTC_GEN_CNTL		(*(MEM_0+0x07))

/* I2C Registers (Rage PRO only) */
#define I2C_CNTL_0		(*(MEM_0+0x0F))
#define I2C_CNTL_0_PTR		  (MEM_0+0x0F)
#define I2C_CNTL_1		(*(MEM_0+0x2F))

/* General I/O Register */
#define GP_IO			(*(MEM_0+0x1E))
#define GP_IO_PTR		  (MEM_0+0x1E)
#define GP_IO_DATA		(*( ((volatile u16*)MEM_0) + 0x3C ))
#define GP_IO_CTRL		(*( ((volatile u16*)MEM_0) + 0x3D ))

/* PLL Clock Registers */
#define CLOCK_CNTL		(*(MEM_0+0x24))
#define CLOCK_CNTL0		(*(((volatile u8*)(MEM_0+0x24))+0))
#define CLOCK_CNTL1		(*(((volatile u8*)(MEM_0+0x24))+1))
#define CLOCK_CNTL2		(*(((volatile u8*)(MEM_0+0x24))+2))

/* Registers reused for I2C Interface and All-In-Wonder TV Sound Enable */
#define DAC_CNTL		(*(MEM_0+0x31))
#define DAC_CNTL_PTR		  (MEM_0+0x31)
#define EXT_DAC_REGS		(*(MEM_0+0x32))
#define GEN_TEST_CNTL		(*(MEM_0+0x34))
#define GEN_TEST_CNTL_PTR	  (MEM_0+0x34)

/* Config and Device ID Registers */
#define MEM_CNTL		(*(MEM_0+0x2C))
#define CONFIG_CNTL		(*(MEM_0+0x37))
#define CONFIG_CHIP_ID		(*(MEM_0+0x38))

/* Overlay Scaler Registers */
#define OVERLAY_Y_X_START	(*(MEM_1+0x00))
#define OVERLAY_Y_X_END		(*(MEM_1+0x01))
#define OVERLAY_VIDEO_CLR	(*(MEM_1+0x02))
#define OVERLAY_VIDEO_MSK	(*(MEM_1+0x03))
#define OVERLAY_GRAPHICS_CLR	(*(MEM_1+0x04))
#define OVERLAY_GRAPHICS_MSK	(*(MEM_1+0x05))
#define OVERLAY_KEY_CNTL	(*(MEM_1+0x06))
#define OVERLAY_SCALE_INC	(*(MEM_1+0x08))
#define OVERLAY_SCALE_CNTL	(*(MEM_1+0x09))
#define SCALER_HEIGHT_WIDTH	(*(MEM_1+0x0A))
#define SCALER_BUF0_OFFSET	(*(MEM_1+0x0D))
#define SCALER_BUF1_OFFSET	(*(MEM_1+0x0E))
#define SCALER_BUF_PITCH	(*(MEM_1+0x0F))
#define OVERLAY_EXCLUSIVE_HORZ	(*(MEM_1+0x16))
#define OVERLAY_EXCLUSIVE_VERT	(*(MEM_1+0x17))
#define SCALER_COLOR_CNTL	(*(MEM_1+0x54))
#define SCALER_H_COEFF0		(*(MEM_1+0x55))
#define SCALER_H_COEFF1		(*(MEM_1+0x56))
#define SCALER_H_COEFF2		(*(MEM_1+0x57))
#define SCALER_H_COEFF3		(*(MEM_1+0x58))
#define SCALER_H_COEFF4		(*(MEM_1+0x59))
#define SCALER_BUF0_OFFSET_U	(*(MEM_1+0x75))
#define SCALER_BUF0_OFFSET_V	(*(MEM_1+0x76))
#define SCALER_BUF1_OFFSET_U	(*(MEM_1+0x77))
#define SCALER_BUF1_OFFSET_V	(*(MEM_1+0x78))

/* Video Capture Registers */
#define CAPTURE_START_END	(*(MEM_1+0x10))
#define CAPTURE_X_WIDTH		(*(MEM_1+0x11))
#define VIDEO_FORMAT		(*(MEM_1+0x12))
#define VBI_START_END		(*(MEM_1+0x13))
#define CAPTURE_CONFIG		(*(MEM_1+0x14))
#define TRIG_CNTL		(*(MEM_1+0x15))
#define VBI_WIDTH		(*(MEM_1+0x18))
#define CAPTURE_BUF0_OFFSET	(*(MEM_1+0x20))
#define CAPTURE_BUF1_OFFSET	(*(MEM_1+0x21))
#define ONESHOT_BUF_OFFSET	(*(MEM_1+0x22))

/* Multimedia Peripheral Port (MPP) Registers */
#define MPP_CONFIG		(*(MEM_1+0x30))
#define MPP_CONFIG3		(*(((volatile u8*)(MEM_1+0x30))+3))
#define MPP_STROBE_SEQ		(*(MEM_1+0x31))
#define MPP_ADDR		(*(MEM_1+0x32))
#define MPP_ADDR0		(*(((volatile u8*)(MEM_1+0x32))+0))
#define MPP_DATA		(*(MEM_1+0x33))
#define MPP_DATA0		(*(((volatile u8*)(MEM_1+0x33))+0))

/* TV Out Feature Registers */
#define TVO_CNTL		(*(MEM_1+0x40))

#ifdef __cplusplus
}
#endif

#undef WHERE
#endif
