/**
 * @file filter.h Message filter utility functions
 *
 * Copyright (C) 2004-2006 Christian Hammond.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#ifndef _GALAGOD_FILTER_H_
#define _GALAGOD_FILTER_H_

#include "galagod.h"
#include "coco.h"

typedef DBusHandlerResult (*GalagodCommandFunc)(DBusConnection *dbus_conn,
												DBusMessage *message,
												GalagodCoCo *coco,
												void *data);

#define GALAGOD_COMMAND(cmd, func) { cmd, (GalagodCommandFunc)(func) }
#define GALAGOD_COMMAND_LAST       { NULL, NULL }

typedef struct
{
	const char *name;
	GalagodCommandFunc func;

} GalagodCommand;

typedef struct
{
	GalagodCoCo *coco;
	GalagoContext *context;
	const GalagodCommand *commands;
	char *iface;

	union
	{
		GalagoAccount  *account;
		GalagoImage    *image;
		GalagoPerson   *person;
		GalagoPresence *presence;
		GalagoService  *service;
		GalagoStatus   *status;
		void           *object;

	} u;

} GalagodStateData;

void galagod_filters_add(void *obj, const GalagodCommand *commands,
						 const char *iface);
void galagod_filters_remove(void *obj);

DBusHandlerResult galagod_cmd_table_execute(const GalagodCommand *cmd_table,
											DBusConnection *dbus_conn,
											DBusMessage *message,
											GalagodCoCo *coco, void *data,
											const char *iface);


void galagod_core_add_filter(void);

char *galagod_service_generate_path(GalagoService *service);
void galagod_service_add_filter(GalagoService *service);
void galagod_service_remove_filter(GalagoService *service);

char *galagod_account_generate_path(GalagoAccount *account);
void galagod_account_add_filter(GalagoAccount *account);
void galagod_account_remove_filter(GalagoAccount *account);

char *galagod_person_generate_path(GalagoPerson *person);
void galagod_person_add_filter(GalagoPerson *person);
void galagod_person_remove_filter(GalagoPerson *person);

char *galagod_presence_generate_path(GalagoPresence *presence);
void galagod_presence_add_filter(GalagoPresence *presence);
void galagod_presence_remove_filter(GalagoPresence *presence);

#endif /* _GALAGOD_FILTER_H_ */
