/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn server.
 * Copyright (C) 2008 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "allocate.h"
#include "widgets.h"
#include <dirent.h>
#include "chars_are_digits.h"
#include "commands.h"
#include "status_update.h"
#include "show_info.h"

extern int activated;
extern int MAX_READ_POPEN;



char * get_process_pid(char *process, char *extmatch)
{
    FILE *fp;
    long num, max_file_size = 4000;
    char *line, *sub_proc_path, *pid;
    int x=0;
    struct dirent **namelist;
    char buf[2];
    int num_bytes = 0;

    pid = allocate(1024);
    strcpy(pid, "0");

    sub_proc_path = allocate(1024);

    num = scandir(PROC_PATH, &namelist, 0, alphasort);
    if( num < 0 )
    {
        perror("scandir");
        free(sub_proc_path);
        return pid;
    }
    else
    {
        /* List all directories in PROC_PATH */
        for(x=0; x<num; x++)
        {
	    /* Now list PROC_PATH/24207/cmdline */
	    snprintf(sub_proc_path, 1000, "%s/%s/cmdline", PROC_PATH, namelist[x]->d_name);

	    if((fp=fopen(sub_proc_path, "r"))==NULL)
	    {
        	free(namelist[x]);
	        continue;
	    }
	    line = allocate(max_file_size+1);
	
	    num_bytes = 0;
	    while( fread(buf, 1, 1, fp) > 0)
	    {
		/* Assemble command and its arguments */
		num_bytes++;
		buf[1]='\0';
		
		/* The arguments can be null terminated, use spaces instead */
		if( buf[0]=='\0' )
		  buf[0]=' ';

		if( num_bytes < max_file_size )
		  strcat(line, buf);
	    }
	    if( num_bytes > 10 && num_bytes < max_file_size )
	    {
		/* If the following strings are detected in this file its running */
		if( strstr(line, process) && strstr(line, extmatch) )
		{
		    snprintf(pid, 1000, "%s", namelist[x]->d_name);
		}
	    
	    }
	    
	    fclose(fp);
	    free(line);
            free(namelist[x]);
	}
    }
    free(namelist);
    free(sub_proc_path);

    return pid;
}


int status_update(struct w *widgets)
{
    gchar *info, *utf8=NULL;
    char *pid;
    GdkColor color;

    pid = get_process_pid("openvpn", "gadmin-openvpn-server.conf");

    if( ! strcmp(pid, "0") )
    {
	activated = 0;
	info = g_strdup_printf(_("Status: Deactivated"));
	utf8 = g_locale_to_utf8(info, strlen(info), NULL, NULL, NULL);
	gtk_label_set_text(GTK_LABEL(widgets->status_label), utf8);
	g_free(info);

	/* Set status color */
	gdk_color_parse("red", &color);
	gtk_widget_modify_fg(widgets->status_label, GTK_STATE_NORMAL, &color);

	return (TRUE);
    }
    else
      {
	  activated = 1;
	  /* printf("OpenVPN is running as pid: %s\n", pid); */
	  info = g_strdup_printf(_("Status: Activated"));
    	  utf8 = g_locale_to_utf8(info, strlen(info), NULL, NULL, NULL);
    	  gtk_label_set_text(GTK_LABEL(widgets->status_label), utf8);
	  g_free(info);

	  /* Set status color */
	  gdk_color_parse("dark green", &color);
	  gtk_widget_modify_fg(widgets->status_label, GTK_STATE_NORMAL, &color);
      }

    free(pid);

    if( utf8!=NULL )
      g_free(utf8);

    return(TRUE);
}
