/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn server.
 * Copyright (C) 2008 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include <gtk/gtk.h>
#include "../config.h"
#include "support.h"
#include "gettext.h"
#include "widgets.h"



void show_help()
{
  gchar *help_text; 
  GtkWidget *help_window, *vbox15, *scrolledwindow16;
  GtkWidget *help_textview, *close_help_button;
  GtkWidget *alignment19, *hbox52, *image19, *label109;

  help_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name(help_window, "help_window");
  gtk_widget_set_size_request(help_window, 650, 350);
  gtk_window_set_title(GTK_WINDOW (help_window), _("GADMIN-OpenVPN-Server help"));
  gtk_window_set_position(GTK_WINDOW (help_window), GTK_WIN_POS_CENTER);

  vbox15 = gtk_vbox_new(FALSE, 0);
  gtk_widget_set_name(vbox15, "vbox15");
  gtk_widget_show(vbox15);
  gtk_container_add(GTK_CONTAINER(help_window), vbox15);

  scrolledwindow16 = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_set_name(scrolledwindow16, "scrolledwindow16");
  gtk_widget_show(scrolledwindow16);
  gtk_box_pack_start(GTK_BOX(vbox15), scrolledwindow16, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow16), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  help_textview = gtk_text_view_new();
  gtk_widget_set_name(help_textview, "help_textview");
  gtk_widget_show(help_textview);
  gtk_container_add(GTK_CONTAINER(scrolledwindow16), help_textview);
  gtk_text_view_set_editable(GTK_TEXT_VIEW(help_textview), FALSE);
  gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW(help_textview), FALSE);
  gtk_text_view_set_left_margin(GTK_TEXT_VIEW(help_textview), 30);
  gtk_text_view_set_right_margin(GTK_TEXT_VIEW(help_textview), 10);

  help_text = g_strconcat(

  _("\n\nGAdmin-OpenVPN-Server:\n"),

  _("\n\nServer settings.\n\n"),
  _("1. Set options according to your network and server requirements.\n"),
  _("   (Read the important notes section about network setup)\n"),
  _("2. Generate new certificates.\n"),
  _("3. Activate the server.\n"),

  _("\n\nUser settings:\n\n"),
  _("Additional but recommended username and password authentication can be\n"),
  _("used if require authentication is selected in the server settings.\n"),
  _("These system users can be added in the user accounts tab.\n"),
  _("GAdmin-OpenVPN-Client can add an account and then connect automatically.\n"),
  _("The clients authentication file can be kept on the computer or on an\n"),
  _("USB stick or even an encrypted USB stick to further increase security.\n"),
  _("A login script can be run for each user that logs in.\n"),
  _("These settings and commands can be changed in the user accounts tab.\n"),

  _("\n\nCertificates and client configuration:\n\n"),
  _("When the server has been set up correctly and can be activated the export button\n"),
  _("can be used to export a complete client setup package that can be imported\n"),
  _("and used directly by the GAdmin-OpenVPN-Clients import button.\n"),

  _("\n\nImportant notes:\n\n"),
  _("The server is set to use the 10.8.0 network by default.\n"),
  _("This is because the servers LAN must be a network that is different from what\n"),
  _("connecting clients usually have as their LAN. IE: 192.168.0 or 10.0.0.\n\n"),

  _("If firestarter is used the internal interface should be set to\n"),
  _("br0 instead of what is normally used, for example: eth1.\n\n"),

  _("If the server is activated it will also start when the system starts.\n"),
  _("After a successful start the activation status will switch to \"activated\" and\n"),
  _("the server log will show \"Initialization sequence completed\" as one of the last lines.\n"),
  _("This may take a bit of time so click the update button to see more of the log.\n"),

  _("\n\nFor more detailed information about the server, visit:\n"),
  _("http://www.openvpn.net\n"), NULL);
  gtk_text_buffer_set_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(help_textview)), help_text, -1);

  if( help_text!=NULL )
    g_free(help_text);

  close_help_button = gtk_button_new();
  gtk_widget_set_name(close_help_button, "close_help_button");
  gtk_widget_show(close_help_button);
  gtk_box_pack_start(GTK_BOX(vbox15), close_help_button, FALSE, FALSE, 0);

  alignment19 = gtk_alignment_new(0.5, 0.5, 0, 0);
  gtk_widget_set_name(alignment19, "alignment19");
  gtk_widget_show(alignment19);
  gtk_container_add(GTK_CONTAINER(close_help_button), alignment19);

  hbox52 = gtk_hbox_new(FALSE, 2);
  gtk_widget_set_name(hbox52, "hbox52");
  gtk_widget_show(hbox52);
  gtk_container_add(GTK_CONTAINER(alignment19), hbox52);

  image19 = gtk_image_new_from_stock("gtk-close", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name(image19, "image19");
  gtk_widget_show(image19);
  gtk_box_pack_start(GTK_BOX(hbox52), image19, FALSE, FALSE, 0);

  label109 = gtk_label_new_with_mnemonic(_("Close"));
  gtk_widget_set_name(label109, "label109");
  gtk_widget_show(label109);
  gtk_box_pack_start(GTK_BOX (hbox52), label109, FALSE, FALSE, 0);
  gtk_label_set_justify(GTK_LABEL(label109), GTK_JUSTIFY_LEFT);

  g_signal_connect_swapped(close_help_button, "clicked",
                           G_CALLBACK(gtk_widget_destroy),
                           GTK_OBJECT(help_window));

  gtk_widget_show_all(help_window);
}
