#!/usr/bin/perl
#
#  Convert SQL user database to LDIF format (for SourceForge LDAP schema)
#  by pfalcon@users.sourceforge.net 2000-10-17
#
#  ./sql2ldif.pl	: Dump only top-level ou map
#  ./sql2ldif.pl --full : Dump full database (ouch!)
#

use DBI;

# Run as gforge
#my($name,$passwd,$uid,$gid,$quota,$comment,$gcos,$dir,$shell) = getpwnam("gforge");
#$> = $uid;

#require("base64.pl");  # Include all the predefined functions
require("/usr/lib/gforge/lib/include.pl");  # Include all the predefined functions
$chroot="/var/lib/gforge/chroot";
#CB#&db_connect;
if ( "$sys_dbname" ne "gforge" || "$sys_dbuser" ne "gforge" ) {
$dbh ||= DBI->connect("DBI:Pg:dbname=$sys_dbname","$sys_dbuser","$sys_dbpasswd");
} else {
$dbh ||= DBI->connect("DBI:Pg:dbname=$sys_dbname","$sys_dbuser","$sys_dbpasswd");
}
die "Cannot connect to database: $!" if ( ! $dbh );

#
#  Dump user entries (ou=People)
#

# We give user maximum of privileges assigned to one by groups ;-(
my $query = "
SELECT nss_passwd.login,gecos,shell,nss_shadow.passwd,uid,gid,email
FROM nss_passwd,nss_shadow,mta_users
WHERE nss_passwd.login=mta_users.login AND nss_passwd.login=nss_shadow.login
GROUP BY nss_passwd.login,gecos,shell,nss_shadow.passwd,uid,gid,email
";
my $rel = $dbh->prepare($query);
$rel->execute();

print "$sys_ldap_host\n";
print "$sys_ldap_base_dn\n";
my $sys_ldap_base_dn="dc=fb14srv1,dc=hpi,dc=uni-potsdam,dc=de";


while(my ($username, $realname, $shell, $pw, $uid, $gid, $email) = $rel->fetchrow()) {
	print "dn: uid=$username,ou=People,$sys_ldap_base_dn\n";
	#CB# To have the same id than generated by new_parse
	print "uid: $username\n";
	if (!$realname) { $realname='?'; }
	$realname=~tr#\x80-\xff#?#;  # it should be UTF-8 encoded, we just drop non-ascii chars
	print "cn: $realname
objectClass: account
objectClass: posixAccount
objectClass: top
objectClass: shadowAccount
objectClass: debGforgeAccount
";
	print "userPassword: {crypt}$pw
shadowLastChange: 10879
shadowMax: 99999
shadowWarning: 7
loginShell: $shell
uidNumber: $uid
gidNumber: $gid
homeDirectory: $chroot/home/users/$username
gecos: $realname
debGforgeForwardEmail: $email

";
}

#
#  Dump group entries (ou=Group)
#

my $query = "
SELECT gid,name
FROM nss_groups
";
my $rel = $dbh->prepare($query);
$rel->execute();

while(my ($gid, $groupname) = $rel->fetchrow()) {
	my $query = "
SELECT user_name
FROM nss_usergroups
WHERE gid=$gid
";
	my $rel = $dbh->prepare($query);
	$rel->execute();

	#CB# To have the same id than generated by new_parse
	print "dn: cn=$groupname,ou=Group,$sys_ldap_base_dn
objectClass: posixGroup
objectClass: top
cn: $groupname
userPassword: {crypt}x
gidNumber: $gid
";

	while(my ($username) = $rel->fetchrow()) {
		print "memberUid: $username\n";
	}
	print "\n";
}

#
#  Dump mailing-lists entries (ou=mailingList)
#

$query = "SELECT list_name,
		post_address,
		owner_address,
		request_address,
		admin_address,
		bounces_address,
		confirm_address,
		join_address,
		leave_address,
		subscribe_address,
		unsubscribe_address
          FROM mta_lists" ;
$rel = $dbh->prepare($query);
$rel->execute();

while(my ($listname, $post, $owner, $request, $admin, $bounces, $confirm, $join, $leave, $subscribe, $unsubscribe) = $rel->fetchrow()) {
	print "dn: cn=$listname,ou=mailingList,$sys_ldap_base_dn
objectClass: debGforgeMailingListMM21
objectClass: top
objectClass: organizationalUnit
cn: $listname
ou: mailingList
debGforgeListPostAddress: \"$post\"
debGforgeListOwnerAddress: \"$owner\"
debGforgeListRequestAddress: \"$request\"
debGforgeListAdminAddress: \"$admin\"
debGforgeListBouncesAddress: \"$bounces\"
debGforgeListConfirmAddress: \"$confirm\"
debGforgeListJoinAddress: \"$join\"
debGforgeListLeaveAddress: \"$leave\"
debGforgeListSubscribeAddress: \"$subscribe\"
debGforgeListUnsubscribeAddress: \"$unsubscribe\"

";
}


#
#  Auxilary functions
#

sub dump_header {
        my $dc=$sys_ldap_base_dn;
        $dc =~ s/,.*// ;
        $dc =~ s/.*=// ;
	print "dn: ou=Hosts,$sys_ldap_base_dn
ou: Hosts
objectClass: top
objectClass: organizationalUnit
objectClass: domainRelatedObject
associatedDomain: $sys_default_domain

dn: ou=People,$sys_ldap_base_dn
ou: People
objectClass: top
objectClass: organizationalUnit
objectClass: domainRelatedObject
associatedDomain: $sys_default_domain

dn: ou=Aliases,$sys_ldap_base_dn
ou: Aliases
objectClass: top
objectClass: organizationalUnit
objectClass: domainRelatedObject
associatedDomain: $sys_default_domain

dn: ou=Group,$sys_ldap_base_dn
ou: Group
objectClass: top
objectClass: organizationalUnit
objectClass: domainRelatedObject
associatedDomain: $sys_default_domain

dn: ou=cvsGroup,$sys_ldap_base_dn
ou: cvsGroup
objectClass: top
objectClass: organizationalUnit
objectClass: domainRelatedObject
associatedDomain: $sys_default_domain

dn: ou=mailingList,$sys_ldap_base_dn
ou: mailingList
objectClass: top
objectClass: organizationalUnit
objectClass: domainRelatedObject
associatedDomain: $sys_lists_host

dn: uid=dummy,ou=People,$sys_ldap_base_dn
uid: dummy
cn: Dummy User
objectClass: account
objectClass: posixAccount
objectClass: top
objectClass: shadowAccount
objectClass: debGforgeAccount
userPassword: {crypt}x
shadowLastChange: 10879
shadowMax: 99999
shadowWarning: 7
loginShell: /bin/false
debGforgeCvsShell: /bin/false
uidNumber: $dummy_uid
gidNumber: $dummy_uid
homeDirectory: $chroot/home/users/dummy
gecos: Dummy User

";
}
