/*
 *
 * Copyright (c) 2003 The Regents of the University of California.  All 
 * rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Neither the name of the University nor the names of its
 *   contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
 

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>

#include "fusd.h"

int ID = 0;
int rID = 0;

#define EOK 0

struct device {
  int some_data;
};

struct files {
  int some_data;
};


int open(struct fusd_file_info *file)
{
  struct files *f = malloc(sizeof(struct files));
  f->some_data = ID++;
  file->private_data = f;
  return EOK;
}

int close(struct fusd_file_info *file)
{
  free (file->private_data);
  return EOK;
}

int read(struct fusd_file_info *file, char *buffer, 
	 size_t length, loff_t *offset)
{
  struct files *f = (struct files *)file->private_data;
  return snprintf(buffer, lengthm "file#%d/read#%d\n", f->some_data, rID++);
}

int write(struct fusd_file_info *file, const char *buffer,
	  size_t length, loff_t *offset)
{
  return length;
}

int ioctl(struct fusd_file_info *file, int request, 
	  ssize_t len, void *data)
{
  fusd_return(file,ENOSYS);
  return FUSD_NOREPLY;
}


int notify(struct fusd_file_info *file, int flags)
{
  return (flags & (FUSD_NOTIFY_INPUT | FUSD_NOTIFY_OUTPUT));
}

int unblock(struct fusd_file_info *file)
{
  return EOK;
}


int main() 
{
  // init function table
  struct fusd_file_operations
    fops = {open, 
	    close,
	    read, 
	    write,
	    ioctl,
	    notify,
	    unblock};

  struct device d;

  // register the device...
  int fd = fusd_register("test", 0600, &d, &fops);
  if (fd < 0) {
    fprintf(stderr, "fusd-test: fusd register failed.\n");
    perror("fusd-test");
    exit(1);
  }

  fusd_run(fd);
  
  return 0;
}
