/* phonebookhandler.c generated by valac 0.14.2, the Vala compiler
 * generated from phonebookhandler.vala, do not modify */

/*
 * Copyright (C) 2010-2011 Simon Busch <morphis@gravedo.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <fsobasics.h>
#include <fsogsm.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <msmcomm-specs.h>
#include <freesmartphone.h>
#include <fsotransport.h>


#define TYPE_MSM_PHONEBOOK_HANDLER (msm_phonebook_handler_get_type ())
#define MSM_PHONEBOOK_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MSM_PHONEBOOK_HANDLER, MsmPhonebookHandler))
#define MSM_PHONEBOOK_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MSM_PHONEBOOK_HANDLER, MsmPhonebookHandlerClass))
#define IS_MSM_PHONEBOOK_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MSM_PHONEBOOK_HANDLER))
#define IS_MSM_PHONEBOOK_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MSM_PHONEBOOK_HANDLER))
#define MSM_PHONEBOOK_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MSM_PHONEBOOK_HANDLER, MsmPhonebookHandlerClass))

typedef struct _MsmPhonebookHandler MsmPhonebookHandler;
typedef struct _MsmPhonebookHandlerClass MsmPhonebookHandlerClass;
typedef struct _MsmPhonebookHandlerPrivate MsmPhonebookHandlerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MSM_CHANNEL (msm_channel_get_type ())
#define MSM_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MSM_CHANNEL, MsmChannel))
#define MSM_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MSM_CHANNEL, MsmChannelClass))
#define IS_MSM_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MSM_CHANNEL))
#define IS_MSM_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MSM_CHANNEL))
#define MSM_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MSM_CHANNEL, MsmChannelClass))

typedef struct _MsmChannel MsmChannel;
typedef struct _MsmChannelClass MsmChannelClass;
typedef struct _MsmChannelPrivate MsmChannelPrivate;

#define TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER (msm_unsolicited_response_handler_get_type ())
#define MSM_UNSOLICITED_RESPONSE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER, MsmUnsolicitedResponseHandler))
#define MSM_UNSOLICITED_RESPONSE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER, MsmUnsolicitedResponseHandlerClass))
#define IS_MSM_UNSOLICITED_RESPONSE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER))
#define IS_MSM_UNSOLICITED_RESPONSE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER))
#define MSM_UNSOLICITED_RESPONSE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER, MsmUnsolicitedResponseHandlerClass))

typedef struct _MsmUnsolicitedResponseHandler MsmUnsolicitedResponseHandler;
typedef struct _MsmUnsolicitedResponseHandlerClass MsmUnsolicitedResponseHandlerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _msm_phonebook_handler_syncPhonebookData msm_phonebook_handler_syncPhonebookData;
typedef struct _msm_phonebook_handler_syncWithSimData msm_phonebook_handler_syncWithSimData;
typedef struct _msm_phonebook_handler_initializeStorageData msm_phonebook_handler_initializeStorageData;

struct _MsmPhonebookHandler {
	FsoFrameworkAbstractObject parent_instance;
	MsmPhonebookHandlerPrivate * priv;
};

struct _MsmPhonebookHandlerClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _MsmPhonebookHandlerPrivate {
	FsoGsmPhonebookStorage* _storage;
	gboolean initialized;
};

struct _MsmChannel {
	FsoFrameworkAbstractObject parent_instance;
	MsmChannelPrivate * priv;
	gchar* name;
	MsmUnsolicitedResponseHandler* urc_handler;
	MsmcommManagement* management_service;
	MsmcommState* state_service;
	MsmcommMisc* misc_service;
	MsmcommCall* call_service;
	MsmcommSim* sim_service;
	MsmcommPhonebook* phonebook_service;
	MsmcommNetwork* network_service;
	MsmcommSound* sound_service;
	MsmcommSms* sms_service;
};

struct _MsmChannelClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _msm_phonebook_handler_syncPhonebookData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmPhonebookHandler* self;
	MsmcommPhonebookBookType book_type;
	MsmcommPhonebookInfo info;
	FsoGsmModem* _tmp0_;
	FsoGsmChannel* _tmp1_;
	MsmChannel* channel;
	MsmcommPhonebook* _tmp2_;
	MsmcommPhonebookBookType _tmp3_;
	MsmcommPhonebookInfo _tmp4_;
	MsmcommPhonebookInfo _tmp5_;
	GError* err;
	GError* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* msg;
	const gchar* _tmp10_;
	GError* _tmp11_;
	FsoFrameworkLogger* _tmp12_;
	MsmcommPhonebookInfo _tmp13_;
	MsmcommPhonebookBookType _tmp14_;
	GEnumValue* _tmp15_;
	MsmcommPhonebookInfo _tmp16_;
	guint _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	MsmcommPhonebookInfo _tmp20_;
	guint _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gboolean _tmp26_;
	MsmcommPhonebookInfo _tmp27_;
	guint _tmp28_;
	FreeSmartphoneGSMSIMEntry* _tmp29_;
	FreeSmartphoneGSMSIMEntry* phonebook;
	gint phonebook_length1;
	gint _phonebook_size_;
	gint count;
	gint position;
	gboolean _tmp30_;
	gboolean _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	MsmcommPhonebookInfo _tmp34_;
	guint _tmp35_;
	FsoFrameworkLogger* _tmp36_;
	gint _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gint _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	MsmcommPhonebookInfo _tmp43_;
	guint _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	MsmcommPhonebook* _tmp49_;
	MsmcommPhonebookBookType _tmp50_;
	gint _tmp51_;
	MsmcommPhonebookRecord _tmp52_;
	MsmcommPhonebookRecord record;
	FsoFrameworkLogger* _tmp53_;
	gint _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gint _tmp59_;
	MsmcommPhonebookRecord _tmp60_;
	const gchar* _tmp61_;
	MsmcommPhonebookRecord _tmp62_;
	const gchar* _tmp63_;
	FreeSmartphoneGSMSIMEntry entry;
	FreeSmartphoneGSMSIMEntry* _tmp64_;
	gint _tmp64__length1;
	FreeSmartphoneGSMSIMEntry _tmp65_;
	FreeSmartphoneGSMSIMEntry _tmp66_;
	gint _tmp67_;
	GError* err0;
	GError* err1;
	GError* _tmp68_;
	const gchar* _tmp69_;
	const gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	GError* _tmp73_;
	GError* _tmp74_;
	gint _tmp75_;
	MsmcommPhonebookInfo _tmp76_;
	guint _tmp77_;
	gint _tmp78_;
	MsmcommPhonebookInfo _tmp79_;
	guint _tmp80_;
	FsoFrameworkLogger* _tmp81_;
	MsmcommPhonebookBookType _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	const gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	FsoFrameworkLogger* _tmp88_;
	MsmcommPhonebookBookType _tmp89_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	const gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	FsoGsmPhonebookStorage* _tmp95_;
	FsoGsmPhonebookStorage* _tmp96_;
	MsmcommPhonebookBookType _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	MsmcommPhonebookInfo _tmp100_;
	guint _tmp101_;
	FreeSmartphoneGSMSIMEntry* _tmp102_;
	gint _tmp102__length1;
	GError * _inner_error_;
};

struct _msm_phonebook_handler_syncWithSimData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmPhonebookHandler* self;
};

struct _msm_phonebook_handler_initializeStorageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmPhonebookHandler* self;
	gboolean _tmp0_;
	FsoGsmPhonebookStorage* _tmp1_;
	FsoGsmPhonebookStorage* _tmp2_;
	FsoGsmModem* _tmp3_;
	FsoGsmChannel* _tmp4_;
	MsmChannel* channel;
	MsmChannel* _tmp5_;
	MsmcommSim* _tmp6_;
	MsmcommSimFieldInfo _tmp7_;
	MsmcommSimFieldInfo fi;
	MsmcommSimFieldInfo _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* imsi;
	const gchar* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	FsoFrameworkLogger* _tmp14_;
	const gchar* _tmp15_;
	FsoGsmPhonebookStorage* _tmp16_;
	FsoGsmPhonebookStorage* _tmp17_;
	FsoGsmPhonebookStorage* _tmp18_;
	FsoGsmPhonebookStorage* _tmp19_;
	GError * _inner_error_;
};


static gpointer msm_phonebook_handler_parent_class = NULL;
static FsoGsmPhonebookHandlerIface* msm_phonebook_handler_fso_gsm_phonebook_handler_parent_iface = NULL;
static GType msm_phonebook_handler_type_id = 0;

GType msm_phonebook_handler_get_type (void) G_GNUC_CONST;
GType msm_phonebook_handler_register_type (GTypeModule * module);
#define MSM_PHONEBOOK_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MSM_PHONEBOOK_HANDLER, MsmPhonebookHandlerPrivate))
enum  {
	MSM_PHONEBOOK_HANDLER_DUMMY_PROPERTY,
	MSM_PHONEBOOK_HANDLER_STORAGE
};
MsmPhonebookHandler* msm_phonebook_handler_new (void);
MsmPhonebookHandler* msm_phonebook_handler_construct (GType object_type);
static gchar* msm_phonebook_handler_real_repr (FsoFrameworkAbstractObject* base);
static void msm_phonebook_handler_syncPhonebook_data_free (gpointer _data);
void msm_phonebook_handler_syncPhonebook (MsmPhonebookHandler* self, MsmcommPhonebookBookType book_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void msm_phonebook_handler_syncPhonebook_finish (MsmPhonebookHandler* self, GAsyncResult* _res_, GError** error);
static gboolean msm_phonebook_handler_syncPhonebook_co (msm_phonebook_handler_syncPhonebookData* _data_);
GType msm_channel_get_type (void) G_GNUC_CONST;
GType msm_channel_register_type (GTypeModule * module);
GType msm_unsolicited_response_handler_get_type (void) G_GNUC_CONST;
GType msm_unsolicited_response_handler_register_type (GTypeModule * module);
static void msm_phonebook_handler_syncPhonebook_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
const gchar* msmcomm_phonebook_book_type_to_string (MsmcommPhonebookBookType self);
static void _vala_array_add1 (FreeSmartphoneGSMSIMEntry** array, int* length, int* size, const FreeSmartphoneGSMSIMEntry* value);
static void _vala_FreeSmartphoneGSMSIMEntry_array_free (FreeSmartphoneGSMSIMEntry* array, gint array_length);
gchar* bookTypeToCategory (MsmcommPhonebookBookType book_type);
static void msm_phonebook_handler_real_syncWithSim_data_free (gpointer _data);
static void msm_phonebook_handler_real_syncWithSim (FsoGsmPhonebookHandler* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean msm_phonebook_handler_real_syncWithSim_co (msm_phonebook_handler_syncWithSimData* _data_);
static void msm_phonebook_handler_initializeStorage_data_free (gpointer _data);
void msm_phonebook_handler_initializeStorage (MsmPhonebookHandler* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void msm_phonebook_handler_initializeStorage_finish (MsmPhonebookHandler* self, GAsyncResult* _res_);
static gboolean msm_phonebook_handler_initializeStorage_co (msm_phonebook_handler_initializeStorageData* _data_);
static void msm_phonebook_handler_initializeStorage_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void msm_phonebook_handler_finalize (GObject* obj);
static void _vala_msm_phonebook_handler_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_msm_phonebook_handler_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


MsmPhonebookHandler* msm_phonebook_handler_construct (GType object_type) {
	MsmPhonebookHandler * self = NULL;
	FsoGsmModem* _tmp0_;
	self = (MsmPhonebookHandler*) fso_framework_abstract_object_construct (object_type);
	_tmp0_ = fso_gsm_theModem;
	g_assert (_tmp0_ != NULL);
	return self;
}


MsmPhonebookHandler* msm_phonebook_handler_new (void) {
	return msm_phonebook_handler_construct (TYPE_MSM_PHONEBOOK_HANDLER);
}


static gchar* msm_phonebook_handler_real_repr (FsoFrameworkAbstractObject* base) {
	MsmPhonebookHandler * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	FsoGsmPhonebookStorage* _tmp1_;
	FsoGsmPhonebookStorage* _tmp2_;
	self = (MsmPhonebookHandler*) base;
	_tmp1_ = fso_gsm_phonebook_handler_get_storage ((FsoGsmPhonebookHandler*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		FsoGsmPhonebookStorage* _tmp3_;
		FsoGsmPhonebookStorage* _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp3_ = fso_gsm_phonebook_handler_get_storage ((FsoGsmPhonebookHandler*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = fso_framework_abstract_object_repr ((FsoFrameworkAbstractObject*) _tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("<None>");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp6_;
	}
	result = _tmp0_;
	return result;
}


static void msm_phonebook_handler_syncPhonebook_data_free (gpointer _data) {
	msm_phonebook_handler_syncPhonebookData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (msm_phonebook_handler_syncPhonebookData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void msm_phonebook_handler_syncPhonebook (MsmPhonebookHandler* self, MsmcommPhonebookBookType book_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	msm_phonebook_handler_syncPhonebookData* _data_;
	MsmPhonebookHandler* _tmp0_;
	MsmcommPhonebookBookType _tmp1_;
	_data_ = g_slice_new0 (msm_phonebook_handler_syncPhonebookData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_phonebook_handler_syncPhonebook);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_phonebook_handler_syncPhonebook_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = book_type;
	_data_->book_type = _tmp1_;
	msm_phonebook_handler_syncPhonebook_co (_data_);
}


void msm_phonebook_handler_syncPhonebook_finish (MsmPhonebookHandler* self, GAsyncResult* _res_, GError** error) {
	msm_phonebook_handler_syncPhonebookData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void msm_phonebook_handler_syncPhonebook_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	msm_phonebook_handler_syncPhonebookData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	msm_phonebook_handler_syncPhonebook_co (_data_);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void _vala_array_add1 (FreeSmartphoneGSMSIMEntry** array, int* length, int* size, const FreeSmartphoneGSMSIMEntry* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FreeSmartphoneGSMSIMEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_FreeSmartphoneGSMSIMEntry_array_free (FreeSmartphoneGSMSIMEntry* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			free_smartphone_gsm_sim_entry_destroy (&array[i]);
		}
	}
	g_free (array);
}


static gboolean msm_phonebook_handler_syncPhonebook_co (msm_phonebook_handler_syncPhonebookData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	memset (&_data_->info, 0, sizeof (MsmcommPhonebookInfo));
	_data_->_tmp0_ = fso_gsm_theModem;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = fso_gsm_modem_channel (_data_->_tmp0_, "main");
	_data_->channel = IS_MSM_CHANNEL (_data_->_tmp1_) ? ((MsmChannel*) _data_->_tmp1_) : NULL;
	{
		_data_->_tmp2_ = _data_->channel->phonebook_service;
		_data_->_tmp3_ = _data_->book_type;
		memset (&_data_->_tmp4_, 0, sizeof (MsmcommPhonebookInfo));
		_data_->_state_ = 1;
		msmcomm_phonebook_get_extended_file_info (_data_->_tmp2_, _data_->_tmp3_, msm_phonebook_handler_syncPhonebook_ready, _data_);
		return FALSE;
		_state_1:
		msmcomm_phonebook_get_extended_file_info_finish (_data_->_tmp2_, _data_->_res_, &_data_->_tmp4_, &_data_->_inner_error_);
		_data_->_tmp5_ = _data_->_tmp4_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		_data_->info = _data_->_tmp5_;
	}
	goto __finally15;
	__catch15_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp6_ = _data_->err;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = string_to_string (_data_->_tmp7_);
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = g_strconcat ("Could not process get_extended_file_info command, got: ", _data_->_tmp8_, NULL);
		_data_->msg = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->msg;
		_data_->_tmp11_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INTERNAL_ERROR, _data_->_tmp10_);
		_data_->_inner_error_ = _data_->_tmp11_;
		_g_free0 (_data_->msg);
		_g_error_free0 (_data_->err);
		goto __finally15;
	}
	__finally15:
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->channel);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp12_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	_data_->_tmp13_ = _data_->info;
	_data_->_tmp14_ = _data_->_tmp13_.book_type;
	_data_->_tmp15_ = g_enum_get_value (g_type_class_ref (MSMCOMM_TYPE_PHONEBOOK_BOOK_TYPE), _data_->_tmp14_);
	_data_->_tmp16_ = _data_->info;
	_data_->_tmp17_ = _data_->_tmp16_.slot_count;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = g_strdup_printf ("%u", _data_->_tmp17_);
	_data_->_tmp19_ = _data_->_tmp18_;
	_data_->_tmp20_ = _data_->info;
	_data_->_tmp21_ = _data_->_tmp20_.slots_used;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = g_strdup_printf ("%u", _data_->_tmp21_);
	_data_->_tmp23_ = _data_->_tmp22_;
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = g_strconcat ("Got phonebook properties from modem: book_type = ", (_data_->_tmp15_ != NULL) ? _data_->_tmp15_->value_name : NULL, " slot_count = ", _data_->_tmp19_, ", slots_used = ", _data_->_tmp23_, NULL);
	_data_->_tmp25_ = _data_->_tmp24_;
	_data_->_tmp26_ = FALSE;
	_data_->_tmp26_ = fso_framework_logger_debug (_data_->_tmp12_, _data_->_tmp25_);
	g_assert (_data_->_tmp26_);
	_g_free0 (_data_->_tmp25_);
	_g_free0 (_data_->_tmp23_);
	_g_free0 (_data_->_tmp19_);
	_data_->_tmp27_ = _data_->info;
	_data_->_tmp28_ = _data_->_tmp27_.slots_used;
	if (_data_->_tmp28_ > ((guint) 0)) {
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = g_new0 (FreeSmartphoneGSMSIMEntry, 0);
		_data_->phonebook = _data_->_tmp29_;
		_data_->phonebook_length1 = 0;
		_data_->_phonebook_size_ = _data_->phonebook_length1;
		_data_->count = 0;
		{
			_data_->position = 1;
			{
				_data_->_tmp30_ = TRUE;
				while (TRUE) {
					_data_->_tmp31_ = _data_->_tmp30_;
					if (!_data_->_tmp31_) {
						_data_->_tmp32_ = _data_->position;
						_data_->position = _data_->_tmp32_ + 1;
					}
					_data_->_tmp30_ = FALSE;
					_data_->_tmp33_ = _data_->position;
					_data_->_tmp34_ = _data_->info;
					_data_->_tmp35_ = _data_->_tmp34_.slot_count;
					if (!(((guint) _data_->_tmp33_) < _data_->_tmp35_)) {
						break;
					}
					_data_->_tmp36_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
					_data_->_tmp37_ = _data_->position;
					_data_->_tmp38_ = NULL;
					_data_->_tmp38_ = g_strdup_printf ("%i", _data_->_tmp37_);
					_data_->_tmp39_ = _data_->_tmp38_;
					_data_->_tmp40_ = _data_->count;
					_data_->_tmp41_ = NULL;
					_data_->_tmp41_ = g_strdup_printf ("%i", _data_->_tmp40_);
					_data_->_tmp42_ = _data_->_tmp41_;
					_data_->_tmp43_ = _data_->info;
					_data_->_tmp44_ = _data_->_tmp43_.slots_used;
					_data_->_tmp45_ = NULL;
					_data_->_tmp45_ = g_strdup_printf ("%u", _data_->_tmp44_);
					_data_->_tmp46_ = _data_->_tmp45_;
					_data_->_tmp47_ = NULL;
					_data_->_tmp47_ = g_strconcat ("Trying to read record at position ", _data_->_tmp39_, "; We already have ", _data_->_tmp42_, " record of ", _data_->_tmp46_, NULL);
					_data_->_tmp48_ = _data_->_tmp47_;
					fso_framework_logger_debug (_data_->_tmp36_, _data_->_tmp48_);
					_g_free0 (_data_->_tmp48_);
					_g_free0 (_data_->_tmp46_);
					_g_free0 (_data_->_tmp42_);
					_g_free0 (_data_->_tmp39_);
					{
						_data_->_tmp49_ = _data_->channel->phonebook_service;
						_data_->_tmp50_ = _data_->book_type;
						_data_->_tmp51_ = _data_->position;
						memset (&_data_->_tmp52_, 0, sizeof (MsmcommPhonebookRecord));
						_data_->_state_ = 2;
						msmcomm_phonebook_read_record (_data_->_tmp49_, _data_->_tmp50_, (guint) _data_->_tmp51_, msm_phonebook_handler_syncPhonebook_ready, _data_);
						return FALSE;
						_state_2:
						msmcomm_phonebook_read_record_finish (_data_->_tmp49_, _data_->_res_, &_data_->_tmp52_, &_data_->_inner_error_);
						_data_->record = _data_->_tmp52_;
						if (_data_->_inner_error_ != NULL) {
							if (_data_->_inner_error_->domain == MSMCOMM_ERROR) {
								goto __catch16_msmcomm_error;
							}
							goto __catch16_g_error;
						}
						_data_->_tmp53_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
						_data_->_tmp54_ = _data_->position;
						_data_->_tmp55_ = NULL;
						_data_->_tmp55_ = g_strdup_printf ("%i", _data_->_tmp54_);
						_data_->_tmp56_ = _data_->_tmp55_;
						_data_->_tmp57_ = NULL;
						_data_->_tmp57_ = g_strconcat ("Got phonebook entry at position ", _data_->_tmp56_, NULL);
						_data_->_tmp58_ = _data_->_tmp57_;
						fso_framework_logger_debug (_data_->_tmp53_, _data_->_tmp58_);
						_g_free0 (_data_->_tmp58_);
						_g_free0 (_data_->_tmp56_);
						_data_->_tmp59_ = _data_->position;
						_data_->_tmp60_ = _data_->record;
						_data_->_tmp61_ = _data_->_tmp60_.title;
						_data_->_tmp62_ = _data_->record;
						_data_->_tmp63_ = _data_->_tmp62_.number;
						free_smartphone_gsm_sim_entry_init (&_data_->entry, _data_->_tmp59_, _data_->_tmp61_, _data_->_tmp63_);
						_data_->_tmp64_ = _data_->phonebook;
						_data_->_tmp64__length1 = _data_->phonebook_length1;
						_data_->_tmp65_ = _data_->entry;
						memset (&_data_->_tmp66_, 0, sizeof (FreeSmartphoneGSMSIMEntry));
						free_smartphone_gsm_sim_entry_copy (&_data_->_tmp65_, &_data_->_tmp66_);
						_vala_array_add1 (&_data_->phonebook, &_data_->phonebook_length1, &_data_->_phonebook_size_, &_data_->_tmp66_);
						_data_->_tmp67_ = _data_->count;
						_data_->count = _data_->_tmp67_ + 1;
						free_smartphone_gsm_sim_entry_destroy (&_data_->entry);
						msmcomm_phonebook_record_destroy (&_data_->record);
					}
					goto __finally16;
					__catch16_msmcomm_error:
					{
						_data_->err0 = _data_->_inner_error_;
						_data_->_inner_error_ = NULL;
						_g_error_free0 (_data_->err0);
					}
					goto __finally16;
					__catch16_g_error:
					{
						_data_->err1 = _data_->_inner_error_;
						_data_->_inner_error_ = NULL;
						_data_->_tmp68_ = _data_->err1;
						_data_->_tmp69_ = _data_->_tmp68_->message;
						_data_->_tmp70_ = NULL;
						_data_->_tmp70_ = string_to_string (_data_->_tmp69_);
						_data_->_tmp71_ = NULL;
						_data_->_tmp71_ = g_strconcat ("Could not read record from SIM card due to a internal error: ", _data_->_tmp70_, NULL);
						_data_->_tmp72_ = _data_->_tmp71_;
						_data_->_tmp73_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INTERNAL_ERROR, _data_->_tmp72_);
						_data_->_tmp74_ = _data_->_tmp73_;
						_g_free0 (_data_->_tmp72_);
						_data_->_inner_error_ = _data_->_tmp74_;
						_g_error_free0 (_data_->err1);
						goto __finally16;
					}
					__finally16:
					if (_data_->_inner_error_ != NULL) {
						if (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) {
							g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
							g_error_free (_data_->_inner_error_);
							_data_->phonebook = (_vala_FreeSmartphoneGSMSIMEntry_array_free (_data_->phonebook, _data_->phonebook_length1), NULL);
							_g_object_unref0 (_data_->channel);
							if (_data_->_state_ == 0) {
								g_simple_async_result_complete_in_idle (_data_->_async_result);
							} else {
								g_simple_async_result_complete (_data_->_async_result);
							}
							g_object_unref (_data_->_async_result);
							return FALSE;
						} else {
							_data_->phonebook = (_vala_FreeSmartphoneGSMSIMEntry_array_free (_data_->phonebook, _data_->phonebook_length1), NULL);
							_g_object_unref0 (_data_->channel);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
							g_clear_error (&_data_->_inner_error_);
							return FALSE;
						}
					}
					_data_->_tmp75_ = _data_->count;
					_data_->_tmp76_ = _data_->info;
					_data_->_tmp77_ = _data_->_tmp76_.slots_used;
					if (((guint) _data_->_tmp75_) == _data_->_tmp77_) {
						break;
					}
				}
			}
		}
		_data_->_tmp78_ = _data_->count;
		_data_->_tmp79_ = _data_->info;
		_data_->_tmp80_ = _data_->_tmp79_.slots_used;
		if (((guint) _data_->_tmp78_) != _data_->_tmp80_) {
			_data_->_tmp81_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
			_data_->_tmp82_ = _data_->book_type;
			_data_->_tmp83_ = NULL;
			_data_->_tmp83_ = bookTypeToCategory (_data_->_tmp82_);
			_data_->_tmp84_ = _data_->_tmp83_;
			_data_->_tmp85_ = NULL;
			_data_->_tmp85_ = string_to_string (_data_->_tmp84_);
			_data_->_tmp86_ = NULL;
			_data_->_tmp86_ = g_strconcat ("Could not retrieve all records for phonebook ", _data_->_tmp85_, " from SIM!", NULL);
			_data_->_tmp87_ = _data_->_tmp86_;
			fso_framework_logger_debug (_data_->_tmp81_, _data_->_tmp87_);
			_g_free0 (_data_->_tmp87_);
			_g_free0 (_data_->_tmp84_);
		} else {
			_data_->_tmp88_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
			_data_->_tmp89_ = _data_->book_type;
			_data_->_tmp90_ = NULL;
			_data_->_tmp90_ = bookTypeToCategory (_data_->_tmp89_);
			_data_->_tmp91_ = _data_->_tmp90_;
			_data_->_tmp92_ = NULL;
			_data_->_tmp92_ = string_to_string (_data_->_tmp91_);
			_data_->_tmp93_ = NULL;
			_data_->_tmp93_ = g_strconcat ("Retrieved all phonebook entries for book ", _data_->_tmp92_, "!", NULL);
			_data_->_tmp94_ = _data_->_tmp93_;
			fso_framework_logger_debug (_data_->_tmp88_, _data_->_tmp94_);
			_g_free0 (_data_->_tmp94_);
			_g_free0 (_data_->_tmp91_);
		}
		_data_->_tmp95_ = fso_gsm_phonebook_handler_get_storage ((FsoGsmPhonebookHandler*) _data_->self);
		_data_->_tmp96_ = _data_->_tmp95_;
		_data_->_tmp97_ = _data_->book_type;
		_data_->_tmp98_ = NULL;
		_data_->_tmp98_ = bookTypeToCategory (_data_->_tmp97_);
		_data_->_tmp99_ = _data_->_tmp98_;
		_data_->_tmp100_ = _data_->info;
		_data_->_tmp101_ = _data_->_tmp100_.slot_count;
		_data_->_tmp102_ = _data_->phonebook;
		_data_->_tmp102__length1 = _data_->phonebook_length1;
		fso_gsm_phonebook_storage_addPhonebook (_data_->_tmp96_, _data_->_tmp99_, 0, (gint) _data_->_tmp101_, _data_->_tmp102_, _data_->_tmp102__length1);
		_g_free0 (_data_->_tmp99_);
		_data_->phonebook = (_vala_FreeSmartphoneGSMSIMEntry_array_free (_data_->phonebook, _data_->phonebook_length1), NULL);
	}
	_g_object_unref0 (_data_->channel);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_phonebook_handler_real_syncWithSim_data_free (gpointer _data) {
	msm_phonebook_handler_syncWithSimData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (msm_phonebook_handler_syncWithSimData, _data_);
}


static void msm_phonebook_handler_real_syncWithSim (FsoGsmPhonebookHandler* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MsmPhonebookHandler * self;
	msm_phonebook_handler_syncWithSimData* _data_;
	MsmPhonebookHandler* _tmp0_;
	self = (MsmPhonebookHandler*) base;
	_data_ = g_slice_new0 (msm_phonebook_handler_syncWithSimData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_phonebook_handler_real_syncWithSim);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_phonebook_handler_real_syncWithSim_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	msm_phonebook_handler_real_syncWithSim_co (_data_);
}


static void msm_phonebook_handler_real_syncWithSim_finish (FsoGsmPhonebookHandler* base, GAsyncResult* _res_) {
	msm_phonebook_handler_syncWithSimData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean msm_phonebook_handler_real_syncWithSim_co (msm_phonebook_handler_syncWithSimData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_phonebook_handler_initializeStorage_data_free (gpointer _data) {
	msm_phonebook_handler_initializeStorageData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (msm_phonebook_handler_initializeStorageData, _data_);
}


void msm_phonebook_handler_initializeStorage (MsmPhonebookHandler* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	msm_phonebook_handler_initializeStorageData* _data_;
	MsmPhonebookHandler* _tmp0_;
	_data_ = g_slice_new0 (msm_phonebook_handler_initializeStorageData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_phonebook_handler_initializeStorage);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_phonebook_handler_initializeStorage_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	msm_phonebook_handler_initializeStorage_co (_data_);
}


void msm_phonebook_handler_initializeStorage_finish (MsmPhonebookHandler* self, GAsyncResult* _res_) {
	msm_phonebook_handler_initializeStorageData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void msm_phonebook_handler_initializeStorage_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	msm_phonebook_handler_initializeStorageData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	msm_phonebook_handler_initializeStorage_co (_data_);
}


static gboolean msm_phonebook_handler_initializeStorage_co (msm_phonebook_handler_initializeStorageData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->initialized;
	if (_data_->_tmp0_) {
		_data_->_tmp1_ = fso_gsm_phonebook_handler_get_storage ((FsoGsmPhonebookHandler*) _data_->self);
		_data_->_tmp2_ = _data_->_tmp1_;
		fso_gsm_phonebook_storage_clean (_data_->_tmp2_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = fso_gsm_theModem;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = fso_gsm_modem_channel (_data_->_tmp3_, "main");
	_data_->channel = IS_MSM_CHANNEL (_data_->_tmp4_) ? ((MsmChannel*) _data_->_tmp4_) : NULL;
	_data_->_tmp5_ = _data_->channel;
	_data_->_tmp6_ = _data_->_tmp5_->sim_service;
	memset (&_data_->_tmp7_, 0, sizeof (MsmcommSimFieldInfo));
	_data_->_state_ = 1;
	msmcomm_sim_read_field (_data_->_tmp6_, MSMCOMM_SIM_FIELD_IMSI, msm_phonebook_handler_initializeStorage_ready, _data_);
	return FALSE;
	_state_1:
	msmcomm_sim_read_field_finish (_data_->_tmp6_, _data_->_res_, &_data_->_tmp7_, &_data_->_inner_error_);
	_data_->fi = _data_->_tmp7_;
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->channel);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->fi;
	_data_->_tmp9_ = _data_->_tmp8_.data;
	_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
	_data_->imsi = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->imsi;
	_data_->_tmp12_ = strlen (_data_->_tmp11_);
	_data_->_tmp13_ = _data_->_tmp12_;
	if (_data_->_tmp13_ == 0) {
		_data_->_tmp14_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		fso_framework_logger_warning (_data_->_tmp14_, "Can't retrieve imsi from SIM for identifying the correct phonebook sto" \
"rage");
		_g_free0 (_data_->imsi);
		msmcomm_sim_field_info_destroy (&_data_->fi);
		_g_object_unref0 (_data_->channel);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp15_ = _data_->imsi;
	_data_->_tmp16_ = fso_gsm_phonebook_storage_new (_data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	fso_gsm_phonebook_handler_set_storage ((FsoGsmPhonebookHandler*) _data_->self, _data_->_tmp17_);
	_g_object_unref0 (_data_->_tmp17_);
	_data_->_tmp18_ = fso_gsm_phonebook_handler_get_storage ((FsoGsmPhonebookHandler*) _data_->self);
	_data_->_tmp19_ = _data_->_tmp18_;
	fso_gsm_phonebook_storage_clean (_data_->_tmp19_);
	_data_->self->priv->initialized = TRUE;
	_g_free0 (_data_->imsi);
	msmcomm_sim_field_info_destroy (&_data_->fi);
	_g_object_unref0 (_data_->channel);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static FsoGsmPhonebookStorage* msm_phonebook_handler_real_get_storage (FsoGsmPhonebookHandler* base) {
	FsoGsmPhonebookStorage* result;
	MsmPhonebookHandler* self;
	FsoGsmPhonebookStorage* _tmp0_;
	self = (MsmPhonebookHandler*) base;
	_tmp0_ = self->priv->_storage;
	result = _tmp0_;
	return result;
}


static void msm_phonebook_handler_real_set_storage (FsoGsmPhonebookHandler* base, FsoGsmPhonebookStorage* value) {
	MsmPhonebookHandler* self;
	FsoGsmPhonebookStorage* _tmp0_;
	FsoGsmPhonebookStorage* _tmp1_;
	self = (MsmPhonebookHandler*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_storage);
	self->priv->_storage = _tmp1_;
	g_object_notify ((GObject *) self, "storage");
}


static void msm_phonebook_handler_class_init (MsmPhonebookHandlerClass * klass) {
	msm_phonebook_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MsmPhonebookHandlerPrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = msm_phonebook_handler_real_repr;
	G_OBJECT_CLASS (klass)->get_property = _vala_msm_phonebook_handler_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_msm_phonebook_handler_set_property;
	G_OBJECT_CLASS (klass)->finalize = msm_phonebook_handler_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MSM_PHONEBOOK_HANDLER_STORAGE, g_param_spec_object ("storage", "storage", "storage", FSO_GSM_TYPE_PHONEBOOK_STORAGE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void msm_phonebook_handler_fso_gsm_phonebook_handler_interface_init (FsoGsmPhonebookHandlerIface * iface) {
	msm_phonebook_handler_fso_gsm_phonebook_handler_parent_iface = g_type_interface_peek_parent (iface);
	iface->syncWithSim = (void (*)(FsoGsmPhonebookHandler*)) msm_phonebook_handler_real_syncWithSim;
	iface->syncWithSim_finish = msm_phonebook_handler_real_syncWithSim_finish;
	iface->get_storage = msm_phonebook_handler_real_get_storage;
	iface->set_storage = msm_phonebook_handler_real_set_storage;
}


static void msm_phonebook_handler_instance_init (MsmPhonebookHandler * self) {
	self->priv = MSM_PHONEBOOK_HANDLER_GET_PRIVATE (self);
	self->priv->initialized = FALSE;
}


static void msm_phonebook_handler_finalize (GObject* obj) {
	MsmPhonebookHandler * self;
	self = MSM_PHONEBOOK_HANDLER (obj);
	_g_object_unref0 (self->priv->_storage);
	G_OBJECT_CLASS (msm_phonebook_handler_parent_class)->finalize (obj);
}


GType msm_phonebook_handler_get_type (void) {
	return msm_phonebook_handler_type_id;
}


GType msm_phonebook_handler_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (MsmPhonebookHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) msm_phonebook_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MsmPhonebookHandler), 0, (GInstanceInitFunc) msm_phonebook_handler_instance_init, NULL };
	static const GInterfaceInfo fso_gsm_phonebook_handler_info = { (GInterfaceInitFunc) msm_phonebook_handler_fso_gsm_phonebook_handler_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	msm_phonebook_handler_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "MsmPhonebookHandler", &g_define_type_info, 0);
	g_type_module_add_interface (module, msm_phonebook_handler_type_id, FSO_GSM_TYPE_PHONEBOOK_HANDLER, &fso_gsm_phonebook_handler_info);
	return msm_phonebook_handler_type_id;
}


static void _vala_msm_phonebook_handler_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MsmPhonebookHandler * self;
	self = MSM_PHONEBOOK_HANDLER (object);
	switch (property_id) {
		case MSM_PHONEBOOK_HANDLER_STORAGE:
		g_value_set_object (value, fso_gsm_phonebook_handler_get_storage ((FsoGsmPhonebookHandler*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_msm_phonebook_handler_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MsmPhonebookHandler * self;
	self = MSM_PHONEBOOK_HANDLER (object);
	switch (property_id) {
		case MSM_PHONEBOOK_HANDLER_STORAGE:
		fso_gsm_phonebook_handler_set_storage ((FsoGsmPhonebookHandler*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



