/* muxtransport.c generated by valac 0.14.2, the Vala compiler
 * generated from muxtransport.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <fsotransport.h>
#include <gsm0710mux.h>
#include <fsobasics.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <unistd.h>


#define FSO_GSM_TYPE_LIB_GSM0710MUX_TRANSPORT (fso_gsm_lib_gsm0710mux_transport_get_type ())
#define FSO_GSM_LIB_GSM0710MUX_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_GSM_TYPE_LIB_GSM0710MUX_TRANSPORT, FsoGsmLibGsm0710muxTransport))
#define FSO_GSM_LIB_GSM0710MUX_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_GSM_TYPE_LIB_GSM0710MUX_TRANSPORT, FsoGsmLibGsm0710muxTransportClass))
#define FSO_GSM_IS_LIB_GSM0710MUX_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_GSM_TYPE_LIB_GSM0710MUX_TRANSPORT))
#define FSO_GSM_IS_LIB_GSM0710MUX_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_GSM_TYPE_LIB_GSM0710MUX_TRANSPORT))
#define FSO_GSM_LIB_GSM0710MUX_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_GSM_TYPE_LIB_GSM0710MUX_TRANSPORT, FsoGsmLibGsm0710muxTransportClass))

typedef struct _FsoGsmLibGsm0710muxTransport FsoGsmLibGsm0710muxTransport;
typedef struct _FsoGsmLibGsm0710muxTransportClass FsoGsmLibGsm0710muxTransportClass;
typedef struct _FsoGsmLibGsm0710muxTransportPrivate FsoGsmLibGsm0710muxTransportPrivate;
#define _gsm0710mux_channel_info_unref0(var) ((var == NULL) ? NULL : (var = (gsm0710mux_channel_info_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _fso_gsm_lib_gsm0710mux_transport_openAsyncData fso_gsm_lib_gsm0710mux_transport_openAsyncData;

struct _FsoGsmLibGsm0710muxTransport {
	FsoFrameworkBaseTransport parent_instance;
	FsoGsmLibGsm0710muxTransportPrivate * priv;
};

struct _FsoGsmLibGsm0710muxTransportClass {
	FsoFrameworkBaseTransportClass parent_class;
};

struct _FsoGsmLibGsm0710muxTransportPrivate {
	Gsm0710muxChannelInfo* channelinfo;
	FsoFrameworkDelegateTransport* tdelegate;
	gchar* muxbuffer;
	gint muxbuffer_length1;
	gint _muxbuffer_size_;
	gint length;
	gboolean channelOpened;
	gint pppInFd;
	FsoFrameworkAsyncReactorChannel* pppOut;
};

struct _fso_gsm_lib_gsm0710mux_transport_openAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoGsmLibGsm0710muxTransport* self;
	gboolean result;
	Gsm0710muxManager* _tmp0_;
	Gsm0710muxChannelInfo* _tmp1_;
	GError* e;
	FsoFrameworkLogger* _tmp2_;
	Gsm0710muxChannelInfo* _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError * _inner_error_;
};


static gpointer fso_gsm_lib_gsm0710mux_transport_parent_class = NULL;
static Gsm0710muxManager* fso_gsm_lib_gsm0710mux_transport_manager;
static Gsm0710muxManager* fso_gsm_lib_gsm0710mux_transport_manager = NULL;

#define FSO_GSM_MUX_TRANSPORT_MAX_BUFFER 1024
GType fso_gsm_lib_gsm0710mux_transport_get_type (void) G_GNUC_CONST;
#define FSO_GSM_LIB_GSM0710MUX_TRANSPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_GSM_TYPE_LIB_GSM0710MUX_TRANSPORT, FsoGsmLibGsm0710muxTransportPrivate))
enum  {
	FSO_GSM_LIB_GSM0710MUX_TRANSPORT_DUMMY_PROPERTY
};
FsoGsmLibGsm0710muxTransport* fso_gsm_lib_gsm0710mux_transport_new (gint channel);
FsoGsmLibGsm0710muxTransport* fso_gsm_lib_gsm0710mux_transport_construct (GType object_type, gint channel);
gint fso_gsm_lib_gsm0710mux_transport_delegateWrite (FsoGsmLibGsm0710muxTransport* self, void* data, gint length, FsoFrameworkTransport* t);
static gint _fso_gsm_lib_gsm0710mux_transport_delegateWrite_fso_framework_transport_data_func (void* data, gint length, FsoFrameworkTransport* transport, gpointer self);
gint fso_gsm_lib_gsm0710mux_transport_delegateRead (FsoGsmLibGsm0710muxTransport* self, void* data, gint length, FsoFrameworkTransport* t);
static gint _fso_gsm_lib_gsm0710mux_transport_delegateRead_fso_framework_transport_data_func (void* data, gint length, FsoFrameworkTransport* transport, gpointer self);
void fso_gsm_lib_gsm0710mux_transport_delegateHup (FsoGsmLibGsm0710muxTransport* self, FsoFrameworkTransport* t);
static void _fso_gsm_lib_gsm0710mux_transport_delegateHup_fso_framework_transport_func (FsoFrameworkTransport* transport, gpointer self);
gboolean fso_gsm_lib_gsm0710mux_transport_delegateOpen (FsoGsmLibGsm0710muxTransport* self, FsoFrameworkTransport* t);
static gboolean _fso_gsm_lib_gsm0710mux_transport_delegateOpen_fso_framework_transport_bool_func (FsoFrameworkTransport* transport, gpointer self);
void fso_gsm_lib_gsm0710mux_transport_delegateClose (FsoGsmLibGsm0710muxTransport* self, FsoFrameworkTransport* t);
static void _fso_gsm_lib_gsm0710mux_transport_delegateClose_fso_framework_transport_func (FsoFrameworkTransport* transport, gpointer self);
gint fso_gsm_lib_gsm0710mux_transport_delegateFreeze (FsoGsmLibGsm0710muxTransport* self, FsoFrameworkTransport* t);
static gint _fso_gsm_lib_gsm0710mux_transport_delegateFreeze_fso_framework_transport_int_func (FsoFrameworkTransport* transport, gpointer self);
void fso_gsm_lib_gsm0710mux_transport_delegateThaw (FsoGsmLibGsm0710muxTransport* self, FsoFrameworkTransport* t);
static void _fso_gsm_lib_gsm0710mux_transport_delegateThaw_fso_framework_transport_func (FsoFrameworkTransport* transport, gpointer self);
static gchar* fso_gsm_lib_gsm0710mux_transport_real_repr (FsoFrameworkBaseTransport* base);
static gboolean fso_gsm_lib_gsm0710mux_transport_real_open (FsoFrameworkTransport* base);
static gboolean fso_gsm_lib_gsm0710mux_transport_real_isOpen (FsoFrameworkTransport* base);
static void fso_gsm_lib_gsm0710mux_transport_real_openAsync_data_free (gpointer _data);
static void fso_gsm_lib_gsm0710mux_transport_real_openAsync (FsoFrameworkTransport* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_gsm_lib_gsm0710mux_transport_real_openAsync_co (fso_gsm_lib_gsm0710mux_transport_openAsyncData* _data_);
static void fso_gsm_lib_gsm0710mux_transport_openAsync_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gint fso_gsm_lib_gsm0710mux_transport_real_read (FsoFrameworkTransport* base, void* data, gint length);
static gint fso_gsm_lib_gsm0710mux_transport_real_write (FsoFrameworkTransport* base, void* data, gint length);
static gint fso_gsm_lib_gsm0710mux_transport_real_freeze (FsoFrameworkTransport* base);
static void fso_gsm_lib_gsm0710mux_transport_real_thaw (FsoFrameworkTransport* base);
static void fso_gsm_lib_gsm0710mux_transport_real_close (FsoFrameworkTransport* base);
gboolean fso_gsm_lib_gsm0710mux_transport_isForwardingToPPP (FsoGsmLibGsm0710muxTransport* self);
void fso_gsm_lib_gsm0710mux_transport_startForwardingToPPP (FsoGsmLibGsm0710muxTransport* self, gint infd, gint outfd);
void fso_gsm_lib_gsm0710mux_transport_onDataFromPPP (FsoGsmLibGsm0710muxTransport* self, void* data, gssize length);
static void _fso_gsm_lib_gsm0710mux_transport_onDataFromPPP_fso_framework_async_reactor_channel_action_func (void* data, gssize length, gpointer self);
void fso_gsm_lib_gsm0710mux_transport_stopForwardingToPPP (FsoGsmLibGsm0710muxTransport* self);
static void fso_gsm_lib_gsm0710mux_transport_finalize (GObject* obj);


static gint _fso_gsm_lib_gsm0710mux_transport_delegateWrite_fso_framework_transport_data_func (void* data, gint length, FsoFrameworkTransport* transport, gpointer self) {
	gint result;
	result = fso_gsm_lib_gsm0710mux_transport_delegateWrite (self, data, length, transport);
	return result;
}


static gint _fso_gsm_lib_gsm0710mux_transport_delegateRead_fso_framework_transport_data_func (void* data, gint length, FsoFrameworkTransport* transport, gpointer self) {
	gint result;
	result = fso_gsm_lib_gsm0710mux_transport_delegateRead (self, data, length, transport);
	return result;
}


static void _fso_gsm_lib_gsm0710mux_transport_delegateHup_fso_framework_transport_func (FsoFrameworkTransport* transport, gpointer self) {
	fso_gsm_lib_gsm0710mux_transport_delegateHup (self, transport);
}


static gboolean _fso_gsm_lib_gsm0710mux_transport_delegateOpen_fso_framework_transport_bool_func (FsoFrameworkTransport* transport, gpointer self) {
	gboolean result;
	result = fso_gsm_lib_gsm0710mux_transport_delegateOpen (self, transport);
	return result;
}


static void _fso_gsm_lib_gsm0710mux_transport_delegateClose_fso_framework_transport_func (FsoFrameworkTransport* transport, gpointer self) {
	fso_gsm_lib_gsm0710mux_transport_delegateClose (self, transport);
}


static gint _fso_gsm_lib_gsm0710mux_transport_delegateFreeze_fso_framework_transport_int_func (FsoFrameworkTransport* transport, gpointer self) {
	gint result;
	result = fso_gsm_lib_gsm0710mux_transport_delegateFreeze (self, transport);
	return result;
}


static void _fso_gsm_lib_gsm0710mux_transport_delegateThaw_fso_framework_transport_func (FsoFrameworkTransport* transport, gpointer self) {
	fso_gsm_lib_gsm0710mux_transport_delegateThaw (self, transport);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


FsoGsmLibGsm0710muxTransport* fso_gsm_lib_gsm0710mux_transport_construct (GType object_type, gint channel) {
	FsoGsmLibGsm0710muxTransport * self = NULL;
	gchar* _tmp0_ = NULL;
	Gsm0710muxManager* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* version;
	Gsm0710muxManager* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean hasAutoSession;
	FsoFrameworkDelegateTransport* _tmp5_;
	FsoFrameworkDelegateTransport* _tmp6_;
	FsoFrameworkTransport* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	Gsm0710muxChannelInfo* _tmp13_ = NULL;
	FsoFrameworkLogger* _tmp14_;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	gboolean _tmp20_ = FALSE;
	self = (FsoGsmLibGsm0710muxTransport*) fso_framework_base_transport_construct (object_type, "LibGsm0710muxTransport", (guint) 0, TRUE, TRUE);
	_tmp0_ = g_new0 (gchar, 1024);
	self->priv->muxbuffer = (g_free (self->priv->muxbuffer), NULL);
	self->priv->muxbuffer = _tmp0_;
	self->priv->muxbuffer_length1 = 1024;
	self->priv->_muxbuffer_size_ = self->priv->muxbuffer_length1;
	self->priv->length = 0;
	_tmp1_ = fso_gsm_lib_gsm0710mux_transport_manager;
	_tmp2_ = gsm0710mux_manager_getVersion (_tmp1_);
	version = _tmp2_;
	_tmp3_ = fso_gsm_lib_gsm0710mux_transport_manager;
	_tmp4_ = gsm0710mux_manager_hasAutoSession (_tmp3_);
	hasAutoSession = _tmp4_;
	g_assert (hasAutoSession);
	_tmp5_ = fso_framework_delegate_transport_new (_fso_gsm_lib_gsm0710mux_transport_delegateWrite_fso_framework_transport_data_func, self, _fso_gsm_lib_gsm0710mux_transport_delegateRead_fso_framework_transport_data_func, self, _fso_gsm_lib_gsm0710mux_transport_delegateHup_fso_framework_transport_func, self, _fso_gsm_lib_gsm0710mux_transport_delegateOpen_fso_framework_transport_bool_func, self, _fso_gsm_lib_gsm0710mux_transport_delegateClose_fso_framework_transport_func, self, _fso_gsm_lib_gsm0710mux_transport_delegateFreeze_fso_framework_transport_int_func, self, _fso_gsm_lib_gsm0710mux_transport_delegateThaw_fso_framework_transport_func, self);
	_g_object_unref0 (self->priv->tdelegate);
	self->priv->tdelegate = _tmp5_;
	_tmp6_ = self->priv->tdelegate;
	_tmp7_ = _g_object_ref0 ((FsoFrameworkTransport*) _tmp6_);
	_tmp8_ = channel;
	_tmp9_ = channel;
	_tmp10_ = g_strdup_printf ("%i", _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat ("fsogsmd:", _tmp11_, NULL);
	_tmp13_ = gsm0710mux_channel_info_new ();
	_g_object_unref0 (_tmp13_->transport);
	_tmp13_->transport = _tmp7_;
	_tmp13_->number = _tmp8_;
	_g_free0 (_tmp13_->consumer);
	_tmp13_->consumer = _tmp12_;
	_gsm0710mux_channel_info_unref0 (self->priv->channelinfo);
	self->priv->channelinfo = _tmp13_;
	_g_free0 (_tmp11_);
	_tmp14_ = ((FsoFrameworkTransport*) self)->logger;
	_tmp15_ = string_to_string (version);
	_tmp16_ = bool_to_string (hasAutoSession);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat ("Created. Using libgsm0710mux version ", _tmp15_, "; autosession is ", _tmp17_, NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = fso_framework_logger_debug (_tmp14_, _tmp19_);
	g_assert (_tmp20_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	_g_free0 (version);
	return self;
}


FsoGsmLibGsm0710muxTransport* fso_gsm_lib_gsm0710mux_transport_new (gint channel) {
	return fso_gsm_lib_gsm0710mux_transport_construct (FSO_GSM_TYPE_LIB_GSM0710MUX_TRANSPORT, channel);
}


static gchar* fso_gsm_lib_gsm0710mux_transport_real_repr (FsoFrameworkBaseTransport* base) {
	FsoGsmLibGsm0710muxTransport * self;
	gchar* result = NULL;
	Gsm0710muxChannelInfo* _tmp0_;
	self = (FsoGsmLibGsm0710muxTransport*) base;
	_tmp0_ = self->priv->channelinfo;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("<0710:Unassigned>");
		result = _tmp1_;
		return result;
	} else {
		Gsm0710muxChannelInfo* _tmp2_;
		gint _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp2_ = self->priv->channelinfo;
		_tmp3_ = _tmp2_->number;
		_tmp4_ = g_strdup_printf ("%i", _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat ("<0710:", _tmp5_, ">", NULL);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		result = _tmp7_;
		return result;
	}
}


static gboolean fso_gsm_lib_gsm0710mux_transport_real_open (FsoFrameworkTransport* base) {
	FsoGsmLibGsm0710muxTransport * self;
	gboolean result = FALSE;
	self = (FsoGsmLibGsm0710muxTransport*) base;
	g_assert_not_reached ();
	return result;
}


static gboolean fso_gsm_lib_gsm0710mux_transport_real_isOpen (FsoFrameworkTransport* base) {
	FsoGsmLibGsm0710muxTransport * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (FsoGsmLibGsm0710muxTransport*) base;
	_tmp0_ = self->priv->channelOpened;
	result = _tmp0_;
	return result;
}


static void fso_gsm_lib_gsm0710mux_transport_real_openAsync_data_free (gpointer _data) {
	fso_gsm_lib_gsm0710mux_transport_openAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (fso_gsm_lib_gsm0710mux_transport_openAsyncData, _data_);
}


static void fso_gsm_lib_gsm0710mux_transport_real_openAsync (FsoFrameworkTransport* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoGsmLibGsm0710muxTransport * self;
	fso_gsm_lib_gsm0710mux_transport_openAsyncData* _data_;
	FsoGsmLibGsm0710muxTransport* _tmp0_;
	self = (FsoGsmLibGsm0710muxTransport*) base;
	_data_ = g_slice_new0 (fso_gsm_lib_gsm0710mux_transport_openAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_gsm_lib_gsm0710mux_transport_real_openAsync);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_gsm_lib_gsm0710mux_transport_real_openAsync_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	fso_gsm_lib_gsm0710mux_transport_real_openAsync_co (_data_);
}


static gboolean fso_gsm_lib_gsm0710mux_transport_real_openAsync_finish (FsoFrameworkTransport* base, GAsyncResult* _res_) {
	gboolean result;
	fso_gsm_lib_gsm0710mux_transport_openAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void fso_gsm_lib_gsm0710mux_transport_openAsync_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	fso_gsm_lib_gsm0710mux_transport_openAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	fso_gsm_lib_gsm0710mux_transport_real_openAsync_co (_data_);
}


static gboolean fso_gsm_lib_gsm0710mux_transport_real_openAsync_co (fso_gsm_lib_gsm0710mux_transport_openAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = fso_gsm_lib_gsm0710mux_transport_manager;
		_data_->_tmp1_ = _data_->self->priv->channelinfo;
		_data_->_state_ = 1;
		gsm0710mux_manager_allocChannel (_data_->_tmp0_, _data_->_tmp1_, fso_gsm_lib_gsm0710mux_transport_openAsync_ready, _data_);
		return FALSE;
		_state_1:
		gsm0710mux_manager_allocChannel_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
				goto __catch64_gsm0710mux_muxer_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	goto __finally64;
	__catch64_gsm0710mux_muxer_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp2_ = ((FsoFrameworkTransport*) _data_->self)->logger;
		_data_->_tmp3_ = _data_->self->priv->channelinfo;
		_data_->_tmp4_ = _data_->_tmp3_->number;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = g_strdup_printf ("%i", _data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = _data_->e;
		_data_->_tmp8_ = _data_->_tmp7_->message;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = string_to_string (_data_->_tmp8_);
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = g_strconcat ("Can't allocate channel #", _data_->_tmp6_, " from MUX: ", _data_->_tmp9_, NULL);
		_data_->_tmp11_ = _data_->_tmp10_;
		fso_framework_logger_error (_data_->_tmp2_, _data_->_tmp11_);
		_g_free0 (_data_->_tmp11_);
		_g_free0 (_data_->_tmp6_);
		_data_->result = FALSE;
		_g_error_free0 (_data_->e);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally64:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->self->priv->channelOpened = TRUE;
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gint fso_gsm_lib_gsm0710mux_transport_real_read (FsoFrameworkTransport* base, void* data, gint length) {
	FsoGsmLibGsm0710muxTransport * self;
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	void* _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gint l;
	self = (FsoGsmLibGsm0710muxTransport*) base;
	_tmp0_ = self->priv->length;
	g_assert (_tmp0_ > 0);
	_tmp1_ = self->priv->length;
	_tmp2_ = length;
	g_assert (_tmp1_ < _tmp2_);
	_tmp3_ = data;
	_tmp4_ = self->priv->muxbuffer;
	_tmp4__length1 = self->priv->muxbuffer_length1;
	_tmp5_ = self->priv->length;
	memcpy (_tmp3_, _tmp4_, (gsize) _tmp5_);
	_tmp6_ = self->priv->length;
	l = _tmp6_;
	self->priv->length = 0;
	result = l;
	return result;
}


static gint fso_gsm_lib_gsm0710mux_transport_real_write (FsoFrameworkTransport* base, void* data, gint length) {
	FsoGsmLibGsm0710muxTransport * self;
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gint _tmp3__length1;
	void* _tmp4_;
	gint _tmp5_;
	FsoFrameworkDelegateTransport* _tmp6_;
	FsoFrameworkTransportFunc _tmp7_;
	void* _tmp7__target;
	FsoFrameworkDelegateTransport* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	self = (FsoGsmLibGsm0710muxTransport*) base;
	_tmp0_ = self->priv->length;
	g_assert (_tmp0_ == 0);
	_tmp1_ = length;
	g_assert (_tmp1_ < FSO_GSM_MUX_TRANSPORT_MAX_BUFFER);
	_tmp2_ = length;
	self->priv->length = _tmp2_;
	_tmp3_ = self->priv->muxbuffer;
	_tmp3__length1 = self->priv->muxbuffer_length1;
	_tmp4_ = data;
	_tmp5_ = length;
	memcpy (_tmp3_, _tmp4_, (gsize) _tmp5_);
	_tmp6_ = self->priv->tdelegate;
	_tmp7_ = ((FsoFrameworkBaseTransport*) _tmp6_)->readfunc;
	_tmp7__target = ((FsoFrameworkBaseTransport*) _tmp6_)->readfunc_target;
	_tmp8_ = self->priv->tdelegate;
	_tmp7_ ((FsoFrameworkTransport*) _tmp8_, _tmp7__target);
	_tmp9_ = self->priv->length;
	g_assert (_tmp9_ == 0);
	_tmp10_ = length;
	result = _tmp10_;
	return result;
}


static gint fso_gsm_lib_gsm0710mux_transport_real_freeze (FsoFrameworkTransport* base) {
	FsoGsmLibGsm0710muxTransport * self;
	gint result = 0;
	self = (FsoGsmLibGsm0710muxTransport*) base;
	result = -1;
	return result;
}


static void fso_gsm_lib_gsm0710mux_transport_real_thaw (FsoFrameworkTransport* base) {
	FsoGsmLibGsm0710muxTransport * self;
	self = (FsoGsmLibGsm0710muxTransport*) base;
}


static void fso_gsm_lib_gsm0710mux_transport_real_close (FsoFrameworkTransport* base) {
	FsoGsmLibGsm0710muxTransport * self;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (FsoGsmLibGsm0710muxTransport*) base;
	_tmp0_ = fso_framework_transport_isOpen ((FsoFrameworkTransport*) self);
	if (_tmp0_) {
		{
			Gsm0710muxManager* _tmp1_;
			Gsm0710muxChannelInfo* _tmp2_;
			const gchar* _tmp3_;
			_tmp1_ = fso_gsm_lib_gsm0710mux_transport_manager;
			_tmp2_ = self->priv->channelinfo;
			_tmp3_ = _tmp2_->consumer;
			gsm0710mux_manager_releaseChannel (_tmp1_, _tmp3_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
					goto __catch65_gsm0710mux_muxer_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally65;
		__catch65_gsm0710mux_muxer_error:
		{
			GError* e = NULL;
			FsoFrameworkLogger* _tmp4_;
			Gsm0710muxChannelInfo* _tmp5_;
			gint _tmp6_;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			GError* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp4_ = ((FsoFrameworkTransport*) self)->logger;
			_tmp5_ = self->priv->channelinfo;
			_tmp6_ = _tmp5_->number;
			_tmp7_ = g_strdup_printf ("%i", _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			_tmp11_ = string_to_string (_tmp10_);
			_tmp12_ = g_strconcat ("Can't release channel #", _tmp8_, " from MUX: ", _tmp11_, NULL);
			_tmp13_ = _tmp12_;
			fso_framework_logger_warning (_tmp4_, _tmp13_);
			_g_free0 (_tmp13_);
			_g_free0 (_tmp8_);
			_g_error_free0 (e);
		}
		__finally65:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->channelOpened = FALSE;
	}
}


gboolean fso_gsm_lib_gsm0710mux_transport_delegateOpen (FsoGsmLibGsm0710muxTransport* self, FsoFrameworkTransport* t) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	result = TRUE;
	return result;
}


void fso_gsm_lib_gsm0710mux_transport_delegateClose (FsoGsmLibGsm0710muxTransport* self, FsoFrameworkTransport* t) {
	FsoFrameworkTransportFunc _tmp0_;
	void* _tmp0__target;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	_tmp0_ = ((FsoFrameworkBaseTransport*) self)->hupfunc;
	_tmp0__target = ((FsoFrameworkBaseTransport*) self)->hupfunc_target;
	if (_tmp0_ != NULL) {
		FsoFrameworkTransportFunc _tmp1_;
		void* _tmp1__target;
		_tmp1_ = ((FsoFrameworkBaseTransport*) self)->hupfunc;
		_tmp1__target = ((FsoFrameworkBaseTransport*) self)->hupfunc_target;
		_tmp1_ ((FsoFrameworkTransport*) self, _tmp1__target);
	} else {
		FsoFrameworkLogger* _tmp2_;
		_tmp2_ = ((FsoFrameworkTransport*) self)->logger;
		fso_framework_logger_error (_tmp2_, "Unexpected CLOSE Request from modem received with no HUP func in place" \
" to notify upper layers");
	}
}


gint fso_gsm_lib_gsm0710mux_transport_delegateWrite (FsoGsmLibGsm0710muxTransport* self, void* data, gint length, FsoFrameworkTransport* t) {
	gint result = 0;
	FsoFrameworkAsyncReactorChannel* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (t != NULL, 0);
	_tmp0_ = self->priv->pppOut;
	if (_tmp0_ == NULL) {
		gint _tmp1_;
		gint _tmp2_;
		gchar* _tmp3_;
		gint _tmp3__length1;
		void* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		FsoFrameworkTransportFunc _tmp7_;
		void* _tmp7__target;
		gint _tmp8_;
		gint _tmp9_;
		_tmp1_ = self->priv->length;
		g_assert (_tmp1_ == 0);
		_tmp2_ = length;
		g_assert (_tmp2_ < FSO_GSM_MUX_TRANSPORT_MAX_BUFFER);
		_tmp3_ = self->priv->muxbuffer;
		_tmp3__length1 = self->priv->muxbuffer_length1;
		_tmp4_ = data;
		_tmp5_ = length;
		memcpy (_tmp3_, _tmp4_, (gsize) _tmp5_);
		_tmp6_ = length;
		self->priv->length = _tmp6_;
		_tmp7_ = ((FsoFrameworkBaseTransport*) self)->readfunc;
		_tmp7__target = ((FsoFrameworkBaseTransport*) self)->readfunc_target;
		_tmp7_ ((FsoFrameworkTransport*) self, _tmp7__target);
		_tmp8_ = self->priv->length;
		g_assert (_tmp8_ == 0);
		_tmp9_ = length;
		result = _tmp9_;
		return result;
	} else {
		gint _tmp10_;
		void* _tmp11_;
		gint _tmp12_;
		gssize _tmp13_ = 0L;
		gssize bwritten;
		gssize _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp10_ = self->priv->pppInFd;
		_tmp11_ = data;
		_tmp12_ = length;
		_tmp13_ = write (_tmp10_, _tmp11_, (gsize) _tmp12_);
		bwritten = _tmp13_;
		_tmp14_ = bwritten;
		_tmp15_ = length;
		g_assert (_tmp14_ == ((gssize) _tmp15_));
		_tmp16_ = length;
		result = _tmp16_;
		return result;
	}
}


gint fso_gsm_lib_gsm0710mux_transport_delegateRead (FsoGsmLibGsm0710muxTransport* self, void* data, gint length, FsoFrameworkTransport* t) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	void* _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gint l;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (t != NULL, 0);
	_tmp0_ = self->priv->length;
	g_assert (_tmp0_ > 0);
	_tmp1_ = length;
	_tmp2_ = self->priv->length;
	g_assert (_tmp1_ > _tmp2_);
	_tmp3_ = data;
	_tmp4_ = self->priv->muxbuffer;
	_tmp4__length1 = self->priv->muxbuffer_length1;
	_tmp5_ = self->priv->length;
	memcpy (_tmp3_, _tmp4_, (gsize) _tmp5_);
	_tmp6_ = self->priv->length;
	l = _tmp6_;
	self->priv->length = 0;
	result = l;
	return result;
}


void fso_gsm_lib_gsm0710mux_transport_delegateHup (FsoGsmLibGsm0710muxTransport* self, FsoFrameworkTransport* t) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
}


gint fso_gsm_lib_gsm0710mux_transport_delegateFreeze (FsoGsmLibGsm0710muxTransport* self, FsoFrameworkTransport* t) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (t != NULL, 0);
	result = -1;
	return result;
}


void fso_gsm_lib_gsm0710mux_transport_delegateThaw (FsoGsmLibGsm0710muxTransport* self, FsoFrameworkTransport* t) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
}


gboolean fso_gsm_lib_gsm0710mux_transport_isForwardingToPPP (FsoGsmLibGsm0710muxTransport* self) {
	gboolean result = FALSE;
	FsoFrameworkAsyncReactorChannel* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pppOut;
	result = _tmp0_ != NULL;
	return result;
}


static void _fso_gsm_lib_gsm0710mux_transport_onDataFromPPP_fso_framework_async_reactor_channel_action_func (void* data, gssize length, gpointer self) {
	fso_gsm_lib_gsm0710mux_transport_onDataFromPPP (self, data, length);
}


void fso_gsm_lib_gsm0710mux_transport_startForwardingToPPP (FsoGsmLibGsm0710muxTransport* self, gint infd, gint outfd) {
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	FsoFrameworkAsyncReactorChannel* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	FsoFrameworkAsyncReactorChannel* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = infd;
	_tmp1_ = g_strdup_printf ("%i", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = outfd;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("START FORWARDING TO PPP VIA ", _tmp2_, " <--> ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	g_message ("muxtransport.vala:262: %s", _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	_tmp8_ = self->priv->pppOut;
	if (_tmp8_ != NULL) {
		return;
	}
	_tmp9_ = infd;
	self->priv->pppInFd = _tmp9_;
	_tmp10_ = outfd;
	_tmp11_ = fso_framework_async_reactor_channel_new (_tmp10_, _fso_gsm_lib_gsm0710mux_transport_onDataFromPPP_fso_framework_async_reactor_channel_action_func, g_object_ref (self), g_object_unref, (gsize) 512);
	_g_object_unref0 (self->priv->pppOut);
	self->priv->pppOut = _tmp11_;
}


void fso_gsm_lib_gsm0710mux_transport_stopForwardingToPPP (FsoGsmLibGsm0710muxTransport* self) {
	FsoFrameworkAsyncReactorChannel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_message ("muxtransport.vala:273: %s", "STOP FORWARDING TO PPP");
	_tmp0_ = self->priv->pppOut;
	if (_tmp0_ == NULL) {
		return;
	}
	_g_object_unref0 (self->priv->pppOut);
	self->priv->pppOut = NULL;
}


void fso_gsm_lib_gsm0710mux_transport_onDataFromPPP (FsoGsmLibGsm0710muxTransport* self, void* data, gssize length) {
	gboolean _tmp0_ = FALSE;
	void* _tmp1_;
	gboolean _tmp3_;
	void* _tmp4_;
	gssize _tmp5_;
	gint _tmp6_ = 0;
	gint bwritten;
	gint _tmp7_;
	gssize _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp1_ = data;
	if (_tmp1_ == NULL) {
		gssize _tmp2_;
		_tmp2_ = length;
		_tmp0_ = _tmp2_ == ((gssize) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		g_message ("muxtransport.vala:285: EOF FROM PPP");
		return;
	}
	g_message ("muxtransport.vala:288: ON DATA FROM PPP");
	_tmp4_ = data;
	_tmp5_ = length;
	_tmp6_ = fso_framework_transport_write ((FsoFrameworkTransport*) self, _tmp4_, (gint) _tmp5_);
	bwritten = _tmp6_;
	_tmp7_ = bwritten;
	_tmp8_ = length;
	g_assert (((gssize) _tmp7_) == _tmp8_);
}


static void fso_gsm_lib_gsm0710mux_transport_class_init (FsoGsmLibGsm0710muxTransportClass * klass) {
	Gsm0710muxManager* _tmp0_;
	fso_gsm_lib_gsm0710mux_transport_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoGsmLibGsm0710muxTransportPrivate));
	FSO_FRAMEWORK_BASE_TRANSPORT_CLASS (klass)->repr = fso_gsm_lib_gsm0710mux_transport_real_repr;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->open = fso_gsm_lib_gsm0710mux_transport_real_open;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->isOpen = fso_gsm_lib_gsm0710mux_transport_real_isOpen;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->openAsync = fso_gsm_lib_gsm0710mux_transport_real_openAsync;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->openAsync_finish = fso_gsm_lib_gsm0710mux_transport_real_openAsync_finish;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->read = fso_gsm_lib_gsm0710mux_transport_real_read;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->write = fso_gsm_lib_gsm0710mux_transport_real_write;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->freeze = fso_gsm_lib_gsm0710mux_transport_real_freeze;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->thaw = fso_gsm_lib_gsm0710mux_transport_real_thaw;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->close = fso_gsm_lib_gsm0710mux_transport_real_close;
	G_OBJECT_CLASS (klass)->finalize = fso_gsm_lib_gsm0710mux_transport_finalize;
	_tmp0_ = gsm0710mux_manager_new ();
	_g_object_unref0 (fso_gsm_lib_gsm0710mux_transport_manager);
	fso_gsm_lib_gsm0710mux_transport_manager = _tmp0_;
}


static void fso_gsm_lib_gsm0710mux_transport_instance_init (FsoGsmLibGsm0710muxTransport * self) {
	self->priv = FSO_GSM_LIB_GSM0710MUX_TRANSPORT_GET_PRIVATE (self);
}


static void fso_gsm_lib_gsm0710mux_transport_finalize (GObject* obj) {
	FsoGsmLibGsm0710muxTransport * self;
	self = FSO_GSM_LIB_GSM0710MUX_TRANSPORT (obj);
	_gsm0710mux_channel_info_unref0 (self->priv->channelinfo);
	_g_object_unref0 (self->priv->tdelegate);
	self->priv->muxbuffer = (g_free (self->priv->muxbuffer), NULL);
	_g_object_unref0 (self->priv->pppOut);
	G_OBJECT_CLASS (fso_gsm_lib_gsm0710mux_transport_parent_class)->finalize (obj);
}


GType fso_gsm_lib_gsm0710mux_transport_get_type (void) {
	static volatile gsize fso_gsm_lib_gsm0710mux_transport_type_id__volatile = 0;
	if (g_once_init_enter (&fso_gsm_lib_gsm0710mux_transport_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoGsmLibGsm0710muxTransportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_gsm_lib_gsm0710mux_transport_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoGsmLibGsm0710muxTransport), 0, (GInstanceInitFunc) fso_gsm_lib_gsm0710mux_transport_instance_init, NULL };
		GType fso_gsm_lib_gsm0710mux_transport_type_id;
		fso_gsm_lib_gsm0710mux_transport_type_id = g_type_register_static (FSO_FRAMEWORK_TYPE_BASE_TRANSPORT, "FsoGsmLibGsm0710muxTransport", &g_define_type_info, 0);
		g_once_init_leave (&fso_gsm_lib_gsm0710mux_transport_type_id__volatile, fso_gsm_lib_gsm0710mux_transport_type_id);
	}
	return fso_gsm_lib_gsm0710mux_transport_type_id__volatile;
}



