/***************************************************************************
 *  The FreeMedForms project is a set of free, open source medical         *
 *  applications.                                                          *
 *  (C) 2008-2012 by Eric MAEKER, MD (France) <eric.maeker@gmail.com>      *
 *  All rights reserved.                                                   *
 *                                                                         *
 *  This program is free software: you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation, either version 3 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program (COPYING.FREEMEDFORMS file).                   *
 *  If not, see <http://www.gnu.org/licenses/>.                            *
 ***************************************************************************/
/***************************************************************************
 *   Main Developper : Eric MAEKER, <eric.maeker@gmail.com>                *
 *   Contributors :                                                        *
 *       NAME <MAIL@ADDRESS.COM>                                           *
 ***************************************************************************/
#include "icd10dbplugin.h"
#include "icd10databasecreator.h"
#include "icdgrouplinker.h"

#include <coreplugin/dialogs/pluginaboutpage.h>

#include <extensionsystem/pluginmanager.h>
#include <utils/log.h>

#include <QtCore/QtPlugin>
#include <QDebug>

using namespace Icd10::Internal;

Icd10DbPlugin::Icd10DbPlugin()
{
    if (Utils::Log::warnPluginsCreation())
        qWarning() << "Creating Icd10DbPlugin";
}

Icd10DbPlugin::~Icd10DbPlugin()
{
    qWarning() << "Icd10DbPlugin::~Icd10DbPlugin()";
}

bool Icd10DbPlugin::initialize(const QStringList &/*arguments*/, QString */*errorMessage*/)
{
    if (Utils::Log::warnPluginsCreation())
        qWarning() << "Icd10DbPlugin::initialize";

    //    Core::ICore::instance()->translators()->addNewTranslator("freeicd-Icd10DbPlugin");

    addAutoReleasedObject(new Icd10DatabasePage(this));
    addAutoReleasedObject(new IcdGroupLinkerPage(this));

    // add plugin info page
    addAutoReleasedObject(new Core::PluginAboutPage(pluginSpec(), this));

    return true;
}

void Icd10DbPlugin::extensionsInitialized()
{
    if (Utils::Log::warnPluginsCreation())
        qWarning() << "Icd10DbPlugin::extensionsInitialized";
}


Q_EXPORT_PLUGIN(Icd10DbPlugin)
