/*  FreeJ example scripts
 *  (c) Copyright 2005 Christoph Rudorff aka MrGoil <goil@dyne.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 3 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
echo("this is pip.js");
function ptest() {
    p = new Pip_pos(320,240,320,240);
}
/* pip Picture in Picture helper
*/
// Defaults
Pip_pos.prototype = {
    edge_zoom: 0.4,
    pad: 6,
    edge_cam: null,
    front_cam: null,
//    get edge(): { return this.edge; };
//    set(e) edge: { this.edge=e },
    get armed() { return (((this.edge_cam) && (this.front_cam)) ? true : false); },
    //get sw() { return _sw(this); },
}

Pip_pos.prototype.nw getter = function() { 
    with(this) {return {
        get zoom() { return edge_zoom; },
        get x() { return pad; },
        get y() { return pad; }
    }};
};
Pip_pos.prototype.ne getter = function() {
    with(this) {return {
        get zoom() { return edge_zoom },
        get x() { return w - lw * edge_zoom - pad },
        get y() { return pad},
    }};
};
Pip_pos.prototype.sw getter = function() { 
    with(this) {return {
        get zoom() { return t.edge_zoom; },
        get x() { return pad; }, 
        get y() { return h - lh*edge_zoom - pad; }
    }};
};
Pip_pos.prototype.se getter = function() {
    with(this) {return {
        get zoom() { return edge_zoom; },
        get x() { return w - lw*edge_zoom - pad; },
        get y() { return h - lh*edge_zoom - pad; }
    }};
};
Pip_pos.prototype.front getter = function() {
    with(this) {return {
        get zoom() { return w/lw; },
        get x() { return 0; },
        get y() { return 0; },
    }};
};

// Constructor
// w, h = screen; lw, lh = sizes of layer
function Pip_pos(w, h, lw, lh) {
    this.w  = w;  this.h  = h;
    this.lw = lw; this.lh = lh;
    
    this.layers = new Array();
    this.add_layer = function(layer) {
        if (layer instanceof Layer) {
            this.layers.push(layer);
        } else {
            throw("this is not a layer: " + layer);
        }
    }

    // set up keyboard
    kbd = new KeyboardController();

    kbd.released_w = function() {
        echo("WWW");
    };
    // change front cam
    kbd.released_num_5 = function() {
        var tmp = this.edge_cam;
        this.edge_cam = this.front_cam;
        this.front_cam = tmp;
//        this.edge.pip = tmp.pip;
 //       this.front = tmp;
  //      this.front.pip = this.front;
        this.front_cam.layer.down();

        front_cam.layer.activate();
        if (!kbd.edge_active)
            edge_cam.layer.deactivate();
    };

    // put cam into the edge
    kbd.released_num_7 = function() {
        //logo.ne();
        edge_cam.pip = pip.nw;
    };
    kbd.released_num_9 = function() { 
        edge_cam.pip = pip.ne;
    };
    kbd.released_num_3 = function() { 
        edge_cam.pip = pip.se;
    };
    kbd.released_num_1 = function() { 
        edge_cam.pip = pip.sw;
    };

    // switch edge on/off
    kbd.edge_active=true;
    kbd.released_num_0 = function() { 
        if (kbd.edge_active) {
            edge_cam.layer.deactivate();
            kbd.edge_active=false;
        } else {
            edge_cam.layer.activate();
            kbd.edge_active=true;
        }
    };

    // set zoom for edge
    kbd.released_num_2 = function() { edge_zoom=Math.max(edge_zoom-0.1, 0.2); apply_paras(cams.edge);};
    kbd.released_num_8 = function() { edge_zoom=Math.min(edge_zoom+0.1, 0.5); apply_paras(cams.edge);};

    this.kbd = kbd;
}
