/********************************************
*                  UPDATE                  *
********************************************

* WARNING: this is a 600 lines function ! (21-11-2003)
*/
guint32 *goom_update (PluginInfo *goomInfo, gint16 data[2][512],
                      int forceMode, float fps, char *songTitle, char *message)
{
    Pixel *return_val;
    guint32 pointWidth;
    guint32 pointHeight;
    int     i;
    float   largfactor;	/* elargissement de l'intervalle d'volution des points */
    Pixel *tmp;
    
    ZoomFilterData *pzfd;
    
    /* test if the config has changed, update it if so */
    pointWidth = (goomInfo->screen.width * 2) / 5;
    pointHeight = ((goomInfo->screen.height) * 2) / 5;
    
    /* ! etude du signal ... */
    evaluate_sound (data, &(goomInfo->sound));
    
    /* goom_execute_main_script(goomInfo); */
    
    /* ! calcul du deplacement des petits points ... */
    largfactor = goomInfo->sound.speedvar / 150.0f + goomInfo->sound.volume / 1.5f;
    
    if (largfactor > 1.5f)
        largfactor = 1.5f;
    
    goomInfo->update.decay_ifs--;
    if (goomInfo->update.decay_ifs > 0)
        goomInfo->update.ifs_incr += 2;
    if (goomInfo->update.decay_ifs == 0)
        goomInfo->update.ifs_incr = 0;
    
    if (goomInfo->update.recay_ifs) {
        goomInfo->update.ifs_incr -= 2;
        goomInfo->update.recay_ifs--;
        if ((goomInfo->update.recay_ifs == 0)&&(goomInfo->update.ifs_incr<=0))
            goomInfo->update.ifs_incr = 1;
    }
    
    if (goomInfo->update.ifs_incr > 0)
        goomInfo->ifs_fx.apply(&goomInfo->ifs_fx, goomInfo->p2, goomInfo->p1, goomInfo);
    
    if (goomInfo->curGState->drawPoints) {
        for (i = 1; i * 15 <= goomInfo->sound.speedvar*80.0f + 15; i++) {
            goomInfo->update.loopvar += goomInfo->sound.speedvar*50 + 1;
            
            pointFilter (goomInfo, goomInfo->p1,
                         YELLOW,
                         ((pointWidth - 6.0f) * largfactor + 5.0f),
                         ((pointHeight - 6.0f) * largfactor + 5.0f),
                         i * 152.0f, 128.0f, goomInfo->update.loopvar + i * 2032);
            pointFilter (goomInfo, goomInfo->p1, ORANGE,
                         ((pointWidth / 2) * largfactor) / i + 10.0f * i,
                         ((pointHeight / 2) * largfactor) / i + 10.0f * i,
                         96.0f, i * 80.0f, goomInfo->update.loopvar / i);
            pointFilter (goomInfo, goomInfo->p1, VIOLET,
                         ((pointHeight / 3 + 5.0f) * largfactor) / i + 10.0f * i,
                         ((pointHeight / 3 + 5.0f) * largfactor) / i + 10.0f * i,
                         i + 122.0f, 134.0f, goomInfo->update.loopvar / i);
            pointFilter (goomInfo, goomInfo->p1, BLACK,
                         ((pointHeight / 3) * largfactor + 20.0f),
                         ((pointHeight / 3) * largfactor + 20.0f),
                         58.0f, i * 66.0f, goomInfo->update.loopvar / i);
            pointFilter (goomInfo, goomInfo->p1, WHITE,
                         (pointHeight * largfactor + 10.0f * i) / i,
                         (pointHeight * largfactor + 10.0f * i) / i,
                         66.0f, 74.0f, goomInfo->update.loopvar + i * 500);
        }
    }
    
    /* par dfaut pas de changement de zoom */
    pzfd = NULL;
    
    /* 
        * Test forceMode
     */
#ifdef VERBOSE
    if (forceMode != 0) {
        printf ("forcemode = %d\n", forceMode);
    }
#endif
    
    
    /* diminuer de 1 le temps de lockage */
    /* note pour ceux qui n'ont pas suivis : le lockvar permet d'empecher un */
    /* changement d'etat du plugin juste apres un autre changement d'etat. oki */
    if (--goomInfo->update.lockvar < 0)
        goomInfo->update.lockvar = 0;
    
    /* on verifie qu'il ne se pas un truc interressant avec le son. */
    if ((goomInfo->sound.timeSinceLastGoom == 0)
        || (forceMode > 0)
        || (goomInfo->update.cyclesSinceLastChange > TIME_BTW_CHG)) {
        
        // changement eventuel de mode
        if (goom_irand(goomInfo->gRandom,16) == 0)
            switch (goom_irand(goomInfo->gRandom,34)) {
                case 0:
                case 10:
                    goomInfo->update.zoomFilterData.hypercosEffect = goom_irand(goomInfo->gRandom,2);
                case 13:
                case 20:
                case 21:
                    goomInfo->update.zoomFilterData.mode = WAVE_MODE;
                    goomInfo->update.zoomFilterData.reverse = 0;
                    goomInfo->update.zoomFilterData.waveEffect = (goom_irand(goomInfo->gRandom,3) == 0);
                    if (goom_irand(goomInfo->gRandom,2))
                        goomInfo->update.zoomFilterData.vitesse = (goomInfo->update.zoomFilterData.vitesse + 127) >> 1;
                        break;
                case 1:
                case 11:
                    goomInfo->update.zoomFilterData.mode = CRYSTAL_BALL_MODE;
                    goomInfo->update.zoomFilterData.waveEffect = 0;
                    goomInfo->update.zoomFilterData.hypercosEffect = 0;
                    break;
                case 2:
                case 12:
                    goomInfo->update.zoomFilterData.mode = AMULETTE_MODE;
                    goomInfo->update.zoomFilterData.waveEffect = 0;
                    goomInfo->update.zoomFilterData.hypercosEffect = 0;
                    break;
                case 3:
                    goomInfo->update.zoomFilterData.mode = WATER_MODE;
                    goomInfo->update.zoomFilterData.waveEffect = 0;
                    goomInfo->update.zoomFilterData.hypercosEffect = 0;
                    break;
                case 4:
                case 14:
                    goomInfo->update.zoomFilterData.mode = SCRUNCH_MODE;
                    goomInfo->update.zoomFilterData.waveEffect = 0;
                    goomInfo->update.zoomFilterData.hypercosEffect = 0;
                    break;
                case 5:
                case 15:
                case 22:
                    goomInfo->update.zoomFilterData.mode = HYPERCOS1_MODE;
                    goomInfo->update.zoomFilterData.waveEffect = 0;
                    goomInfo->update.zoomFilterData.hypercosEffect = (goom_irand(goomInfo->gRandom,3) == 0);
                    break;
                case 6:
                case 16:
                    goomInfo->update.zoomFilterData.mode = HYPERCOS2_MODE;
                    goomInfo->update.zoomFilterData.waveEffect = 0;
                    goomInfo->update.zoomFilterData.hypercosEffect = 0;
                    break;
                case 7:
                case 17:
                    goomInfo->update.zoomFilterData.mode = CRYSTAL_BALL_MODE;
                    goomInfo->update.zoomFilterData.waveEffect = (goom_irand(goomInfo->gRandom,4) == 0);
                    goomInfo->update.zoomFilterData.hypercosEffect = goom_irand(goomInfo->gRandom,2);
                    break;
                case 8:
                case 18:
                case 19:
                    goomInfo->update.zoomFilterData.mode = SCRUNCH_MODE;
                    goomInfo->update.zoomFilterData.waveEffect = 1;
                    goomInfo->update.zoomFilterData.hypercosEffect = 1;
                    break;
                case 29:
                case 30:
                    goomInfo->update.zoomFilterData.mode = YONLY_MODE;
                    break;
                case 31:
                case 32:
                case 33:
                    goomInfo->update.zoomFilterData.mode = SPEEDWAY_MODE;
                    break;
	    default: break;
                    goomInfo->update.zoomFilterData.mode = NORMAL_MODE;
                    goomInfo->update.zoomFilterData.waveEffect = 0;
                    goomInfo->update.zoomFilterData.hypercosEffect = 0;
            }
    }

        /* tout ceci ne sera fait qu'en cas de non-blocage */
        if (goomInfo->update.lockvar == 0) {
            /* reperage de goom (acceleration forte de l'acceleration du volume) */
            /* -> coup de boost de la vitesse si besoin.. */
            if (goomInfo->sound.timeSinceLastGoom == 0) {
                
                int i;
                goomInfo->update.goomvar++;
                
                /* SELECTION OF THE GOOM STATE */
                if ((!goomInfo->update.stateSelectionBlocker)&&(goom_irand(goomInfo->gRandom,3))) {
                    goomInfo->update.stateSelectionRnd = goom_irand(goomInfo->gRandom,goomInfo->statesRangeMax);
                    goomInfo->update.stateSelectionBlocker = 3;
                }
                else if (goomInfo->update.stateSelectionBlocker) goomInfo->update.stateSelectionBlocker--;
                
                for (i=0;i<goomInfo->statesNumber;i++)
                    if ((goomInfo->update.stateSelectionRnd >= goomInfo->states[i].rangemin)
                        && (goomInfo->update.stateSelectionRnd <= goomInfo->states[i].rangemax))
                        goomInfo->curGState = &(goomInfo->states[i]);
                
                if ((goomInfo->curGState->drawIFS) && (goomInfo->update.ifs_incr<=0)) {
                    goomInfo->update.recay_ifs = 5;
                    goomInfo->update.ifs_incr = 11;
                }
                
                if ((!goomInfo->curGState->drawIFS) && (goomInfo->update.ifs_incr>0) && (goomInfo->update.decay_ifs<=0))
                    goomInfo->update.decay_ifs = 100;
                
                if (!goomInfo->curGState->drawScope)
                    goomInfo->update.stop_lines = 0xf000 & 5;
                
                if (!goomInfo->curGState->drawScope) {
                    goomInfo->update.stop_lines = 0;			
                    goomInfo->update.lineMode = goomInfo->update.drawLinesDuration;
                }
                
                /* if (goomInfo->update.goomvar % 1 == 0) */
                {
                    guint32 vtmp;
                    guint32 newvit;
                    
                    goomInfo->update.lockvar = 50;
                    newvit = STOP_SPEED + 1 - ((float)3.5f * log10(goomInfo->sound.speedvar * 60 + 1));
                    /* retablir le zoom avant.. */
                    if ((goomInfo->update.zoomFilterData.reverse) && (!(goomInfo->cycle % 13)) && (rand () % 5 == 0)) {
                        goomInfo->update.zoomFilterData.reverse = 0;
                        goomInfo->update.zoomFilterData.vitesse = STOP_SPEED - 2;
                        goomInfo->update.lockvar = 75;
                    }
                    if (goom_irand(goomInfo->gRandom,10) == 0) {
                        goomInfo->update.zoomFilterData.reverse = 1;
                        goomInfo->update.lockvar = 100;
                    }
                    
                    if (goom_irand(goomInfo->gRandom,10) == 0)
                        goomInfo->update.zoomFilterData.vitesse = STOP_SPEED - 1;
                    if (goom_irand(goomInfo->gRandom,12) == 0)
                        goomInfo->update.zoomFilterData.vitesse = STOP_SPEED + 1;
                    
                    /* changement de milieu.. */
                    switch (goom_irand(goomInfo->gRandom,25)) {
                        case 0:
                        case 3:
                        case 6:
                            goomInfo->update.zoomFilterData.middleY = goomInfo->screen.height - 1;
                            goomInfo->update.zoomFilterData.middleX = goomInfo->screen.width / 2;
                            break;
                        case 1:
                        case 4:
                            goomInfo->update.zoomFilterData.middleX = goomInfo->screen.width - 1;
                            break;
                        case 2:
                        case 5:
                            goomInfo->update.zoomFilterData.middleX = 1;
                            break;
                        default:
                            goomInfo->update.zoomFilterData.middleY = goomInfo->screen.height / 2;
                            goomInfo->update.zoomFilterData.middleX = goomInfo->screen.width / 2;
                    }
                    
                    if ((goomInfo->update.zoomFilterData.mode == WATER_MODE)
                        || (goomInfo->update.zoomFilterData.mode == YONLY_MODE)
                        || (goomInfo->update.zoomFilterData.mode == AMULETTE_MODE)) {
                        goomInfo->update.zoomFilterData.middleX = goomInfo->screen.width / 2;
                        goomInfo->update.zoomFilterData.middleY = goomInfo->screen.height / 2;
                    }
                    
                    switch (vtmp = (goom_irand(goomInfo->gRandom,15))) {
                        case 0:
                            goomInfo->update.zoomFilterData.vPlaneEffect = goom_irand(goomInfo->gRandom,3)
                            - goom_irand(goomInfo->gRandom,3);
                            goomInfo->update.zoomFilterData.hPlaneEffect = goom_irand(goomInfo->gRandom,3)
                                - goom_irand(goomInfo->gRandom,3);
                            break;
                        case 3:
                            goomInfo->update.zoomFilterData.vPlaneEffect = 0;
                            goomInfo->update.zoomFilterData.hPlaneEffect = goom_irand(goomInfo->gRandom,8)
                                - goom_irand(goomInfo->gRandom,8);
                            break;
                        case 4:
                        case 5:
                        case 6:
                        case 7:
                            goomInfo->update.zoomFilterData.vPlaneEffect = goom_irand(goomInfo->gRandom,5)
                            - goom_irand(goomInfo->gRandom,5);
                            goomInfo->update.zoomFilterData.hPlaneEffect = -goomInfo->update.zoomFilterData.vPlaneEffect;
                            break;
                        case 8:
                            goomInfo->update.zoomFilterData.hPlaneEffect = 5 + goom_irand(goomInfo->gRandom,8);
                            goomInfo->update.zoomFilterData.vPlaneEffect = -goomInfo->update.zoomFilterData.hPlaneEffect;
                            break;
                        case 9:
                            goomInfo->update.zoomFilterData.vPlaneEffect = 5 + goom_irand(goomInfo->gRandom,8);
                            goomInfo->update.zoomFilterData.hPlaneEffect = -goomInfo->update.zoomFilterData.hPlaneEffect;
                            break;
                        case 13:
                            goomInfo->update.zoomFilterData.hPlaneEffect = 0;
                            goomInfo->update.zoomFilterData.vPlaneEffect = goom_irand(goomInfo->gRandom,10)
                                - goom_irand(goomInfo->gRandom,10);
                            break;
                        case 14:
                            goomInfo->update.zoomFilterData.hPlaneEffect = goom_irand(goomInfo->gRandom,10)
                            - goom_irand(goomInfo->gRandom,10);
                            goomInfo->update.zoomFilterData.vPlaneEffect = goom_irand(goomInfo->gRandom,10)
                                - goom_irand(goomInfo->gRandom,10);
                            break;
                        default:
                            if (vtmp < 10) {
                                goomInfo->update.zoomFilterData.vPlaneEffect = 0;
                                goomInfo->update.zoomFilterData.hPlaneEffect = 0;
                            }
                    }
                    
                    if (goom_irand(goomInfo->gRandom,5) != 0)
                        goomInfo->update.zoomFilterData.noisify = 0;
                    else {
                        goomInfo->update.zoomFilterData.noisify = goom_irand(goomInfo->gRandom,2) + 1;
                        goomInfo->update.lockvar *= 2;
                    }
                    
                    if (goomInfo->update.zoomFilterData.mode == AMULETTE_MODE) {
                        goomInfo->update.zoomFilterData.vPlaneEffect = 0;
                        goomInfo->update.zoomFilterData.hPlaneEffect = 0;
                        goomInfo->update.zoomFilterData.noisify = 0;
                    }
                    
                    if ((goomInfo->update.zoomFilterData.middleX == 1) || (goomInfo->update.zoomFilterData.middleX == (signed int)goomInfo->screen.width - 1)) {
                        goomInfo->update.zoomFilterData.vPlaneEffect = 0;
                        if (goom_irand(goomInfo->gRandom,2))
                            goomInfo->update.zoomFilterData.hPlaneEffect = 0;
                    }
                    
                    if ((signed int)newvit < goomInfo->update.zoomFilterData.vitesse)	/* on accelere */
                    {
                        pzfd = &goomInfo->update.zoomFilterData;
                        if (((newvit < STOP_SPEED - 7) &&
                             (goomInfo->update.zoomFilterData.vitesse < STOP_SPEED - 6) &&
                             (goomInfo->cycle % 3 == 0)) || (goom_irand(goomInfo->gRandom,40) == 0)) {
                            goomInfo->update.zoomFilterData.vitesse = STOP_SPEED - goom_irand(goomInfo->gRandom,2)
                            + goom_irand(goomInfo->gRandom,2);
                            goomInfo->update.zoomFilterData.reverse = !goomInfo->update.zoomFilterData.reverse;
                        }
                        else {
                            goomInfo->update.zoomFilterData.vitesse = (newvit + goomInfo->update.zoomFilterData.vitesse * 7) / 8;
                        }
                        goomInfo->update.lockvar += 50;
                    }
                }
                
                if (goomInfo->update.lockvar > 150) {
                    goomInfo->update.switchIncr = goomInfo->update.switchIncrAmount;
                    goomInfo->update.switchMult = 1.0f;
                }
            }
            /* mode mega-lent */
            if (goom_irand(goomInfo->gRandom,700) == 0) {
                /* 
                * printf ("coup du sort...\n") ;
                 */
                pzfd = &goomInfo->update.zoomFilterData;
                goomInfo->update.zoomFilterData.vitesse = STOP_SPEED - 1;
                goomInfo->update.zoomFilterData.pertedec = 8;
                goomInfo->update.zoomFilterData.sqrtperte = 16;
                goomInfo->update.goomvar = 1;
                goomInfo->update.lockvar += 50;
                goomInfo->update.switchIncr = goomInfo->update.switchIncrAmount;
                goomInfo->update.switchMult = 1.0f;
            }
        }
        
        /*
         * gros frein si la musique est calme
         */
        if ((goomInfo->sound.speedvar < 0.01f)
            && (goomInfo->update.zoomFilterData.vitesse < STOP_SPEED - 4)
            && (goomInfo->cycle % 16 == 0)) {
            pzfd = &goomInfo->update.zoomFilterData;
            goomInfo->update.zoomFilterData.vitesse += 3;
            goomInfo->update.zoomFilterData.pertedec = 8;
            goomInfo->update.zoomFilterData.sqrtperte = 16;
            goomInfo->update.goomvar = 0;
        }
        
        /*
         * baisser regulierement la vitesse...
         */
        if ((goomInfo->cycle % 73 == 0) && (goomInfo->update.zoomFilterData.vitesse < STOP_SPEED - 5)) {
            pzfd = &goomInfo->update.zoomFilterData;
            goomInfo->update.zoomFilterData.vitesse++;
        }
        
        /*
         * arreter de decrmenter au bout d'un certain temps
         */
        if ((goomInfo->cycle % 101 == 0) && (goomInfo->update.zoomFilterData.pertedec == 7)) {
            pzfd = &goomInfo->update.zoomFilterData;
            goomInfo->update.zoomFilterData.pertedec = 8;
            goomInfo->update.zoomFilterData.sqrtperte = 16;
        }
        
        /*
         * Permet de forcer un effet.
         */
        if ((forceMode > 0) && (forceMode <= NB_FX)) {
            pzfd = &goomInfo->update.zoomFilterData;
            pzfd->mode = forceMode - 1;
        }
        
        if (forceMode == -1) {
            pzfd = NULL;
        }
        
        /*
         * Changement d'effet de zoom !
         */
        if (pzfd != NULL) {
            int        dif;
            
            goomInfo->update.cyclesSinceLastChange = 0;
            
            goomInfo->update.switchIncr = goomInfo->update.switchIncrAmount;
            
            dif = goomInfo->update.zoomFilterData.vitesse - goomInfo->update.previousZoomSpeed;
            if (dif < 0)
                dif = -dif;
            
            if (dif > 2) {
                goomInfo->update.switchIncr *= (dif + 2) / 2;
            }
            goomInfo->update.previousZoomSpeed = goomInfo->update.zoomFilterData.vitesse;
            goomInfo->update.switchMult = 1.0f;
            
            if (((goomInfo->sound.timeSinceLastGoom == 0)
                 && (goomInfo->sound.totalgoom < 2)) || (forceMode > 0)) {
                goomInfo->update.switchIncr = 0;
                goomInfo->update.switchMult = goomInfo->update.switchMultAmount;
            }
        }
        else {
            if (goomInfo->update.cyclesSinceLastChange > TIME_BTW_CHG) {
                pzfd = &goomInfo->update.zoomFilterData;
                goomInfo->update.cyclesSinceLastChange = 0;
            }
            else
                goomInfo->update.cyclesSinceLastChange++;
        }
        
#ifdef VERBOSE
        if (pzfd) {
            printf ("GOOM: pzfd->mode = %d\n", pzfd->mode);
        }
#endif
        
        /* Zoom here ! */
        zoomFilterFastRGB (goomInfo, goomInfo->p1, goomInfo->p2, pzfd, goomInfo->screen.width, goomInfo->screen.height,
                           goomInfo->update.switchIncr, goomInfo->update.switchMult);
        
        /*
         * Affichage tentacule
         */
        
        goomInfo->tentacles_fx.apply(&goomInfo->tentacles_fx, goomInfo->p1, goomInfo->p2, goomInfo);
        goomInfo->star_fx.apply (&goomInfo->star_fx,goomInfo->p2,goomInfo->p1,goomInfo);
        
        
        /*
         * Gestion du Scope
         */
        
        /*
         * arret demande
         */
        if ((goomInfo->update.stop_lines & 0xf000)||(!goomInfo->curGState->drawScope)) {
            float   param1, param2, amplitude;
            int     couleur;
            int     mode;
            
            choose_a_goom_line (goomInfo, &param1, &param2, &couleur, &mode, &amplitude,1);
            couleur = GML_BLACK;
            
            goom_lines_switch_to (goomInfo->gmline1, mode, param1, amplitude, couleur);
            goom_lines_switch_to (goomInfo->gmline2, mode, param2, amplitude, couleur);
            goomInfo->update.stop_lines &= 0x0fff;
        }
        
        /*
         * arret aleatore.. changement de mode de ligne..
         */
        if (goomInfo->update.lineMode != goomInfo->update.drawLinesDuration) {
            goomInfo->update.lineMode--;
            if (goomInfo->update.lineMode == -1)
                goomInfo->update.lineMode = 0;
        }
        else
            if ((goomInfo->cycle%80==0)&&(goom_irand(goomInfo->gRandom,5)==0)&&goomInfo->update.lineMode)
                goomInfo->update.lineMode--;
        
        if ((goomInfo->cycle % 120 == 0)
            && (goom_irand(goomInfo->gRandom,4) == 0)
            && (goomInfo->curGState->drawScope)) {
            if (goomInfo->update.lineMode == 0)
                goomInfo->update.lineMode = goomInfo->update.drawLinesDuration;
            else if (goomInfo->update.lineMode == goomInfo->update.drawLinesDuration) {
                float   param1, param2, amplitude;
                int     couleur1,couleur2;
                int     mode;
                
                goomInfo->update.lineMode--;
                choose_a_goom_line (goomInfo, &param1, &param2, &couleur1,
                                    &mode, &amplitude,goomInfo->update.stop_lines);
                
                couleur2 = 5-couleur1;
                if (goomInfo->update.stop_lines) {
                    goomInfo->update.stop_lines--;
                    if (goom_irand(goomInfo->gRandom,2))
                        couleur2=couleur1 = GML_BLACK;
                }
                
                goom_lines_switch_to (goomInfo->gmline1, mode, param1, amplitude, couleur1);
                goom_lines_switch_to (goomInfo->gmline2, mode, param2, amplitude, couleur2);
            }
        }
        
        /*
         * si on est dans un goom : afficher les lignes...
         */

        if ((goomInfo->update.lineMode != 0) || (goomInfo->sound.timeSinceLastGoom < 5)) {
            goomInfo->gmline2->power = goomInfo->gmline1->power;
            
            goom_lines_draw (goomInfo, goomInfo->gmline1, data[0], goomInfo->p2);
            goom_lines_draw (goomInfo, goomInfo->gmline2, data[1], goomInfo->p2);
            
            if (((goomInfo->cycle % 121) == 9) && (goom_irand(goomInfo->gRandom,3) == 1)
                && ((goomInfo->update.lineMode == 0) || (goomInfo->update.lineMode == goomInfo->update.drawLinesDuration))) {
                float   param1, param2, amplitude;
                int     couleur1,couleur2;
                int     mode;
                
                choose_a_goom_line (goomInfo, &param1, &param2, &couleur1,
                                    &mode, &amplitude, goomInfo->update.stop_lines);
                couleur2 = 5-couleur1;
                
                if (goomInfo->update.stop_lines) {
                    goomInfo->update.stop_lines--;
                    if (goom_irand(goomInfo->gRandom,2))
                        couleur2=couleur1 = GML_BLACK;
                }
                goom_lines_switch_to (goomInfo->gmline1, mode, param1, amplitude, couleur1);
                goom_lines_switch_to (goomInfo->gmline2, mode, param2, amplitude, couleur2);
            }
        }
        
        return_val = goomInfo->p1;
        tmp = goomInfo->p1;
        goomInfo->p1 = goomInfo->p2;
        goomInfo->p2 = tmp;
        
        /* affichage et swappage des buffers.. */
        goomInfo->cycle++;
        
        goomInfo->convolve_fx.apply(&goomInfo->convolve_fx,return_val,goomInfo->outputBuf,goomInfo);
        
        return (guint32*)goomInfo->outputBuf;
}
