//
// C++ Interface: pitchshiftrect
//
// Description: 
//
//
// Author: Predrag Viceic <viceic@net2000.ch>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef PITCHSHIFTRECT_H
#define PITCHSHIFTRECT_H

#include <qcanvas.h>
#include <qpainter.h>
#include "defs.h"
#include "pics/icons.h"

/**
@author Predrag Viceic
*/
class PitchShiftRect : public QCanvasRectangle
{
public:
    enum ps_controls{PS_TRANSP_DOWN,PS_TRANSP_UP, PS_NONE};

    PitchShiftRect(QCanvas* canvas);

    ~PitchShiftRect();
    int rtti() const;
    void mouseReleaseEvent(QMouseEvent * e);
    void mousePressEvent(QMouseEvent * e);
    QRect* getTranspDownRect() const;
    QRect* getTranspUpRect() const;
    void setY(double y);
    void setX(double x);
    int getTranspose() const;
	
	
	
protected:
    ps_controls control_active;
    int transpose;

protected:
    void drawShape(QPainter & p);
    QRect* transpDownRect;
    QRect* transpUpRect;
    QRect* counterRect;
    int maxTranspose;
};

#endif
