#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <plib/pu.h>
#include <plib/fnt.h>

/**
 * fonts.cxx generated by the genfonts utility by Pawel W. Olszta.
 * See its source file genfonts.c for copyright ownership.
 */


struct SFG_Font {
    const char*     Name;         /* The source font name             */
    int             Quantity;     /* Number of chars in font          */
    int             Height;       /* Height of the characters         */
    const GLubyte** Characters;   /* The characters mapping           */
    float           xorig, yorig; /* Relative origin of the character */
};


/**
 * Helvetica 14 (-Adobe-Helvetica-Medium-R-Normal--14-140-75-75-P-77-ISO8859-1)
 *
 *     Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved.
 *     Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
 *     Helvetica is a trademark of Linotype-Hell AG and/or its subsidiaries.
 */

static const GLubyte Helvetica14_Char_032[] = {  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_033[] = {  3,  0,  0,  0,128,128,  0,128,128,128,128,128,128,128,128,  0,  0,  0};
static const GLubyte Helvetica14_Char_034[] = {  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,160,160,160,  0,  0,  0};
static const GLubyte Helvetica14_Char_035[] = {  9,  0,  0,  0,  0,  0,  0, 80,  0, 80,  0, 80,  0,252,  0, 40,  0, 40,  0,126,  0, 20,  0, 20,  0, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_036[] = {  9,  0,  0, 16,  0, 16,  0,124,  0,146,  0,146,  0, 18,  0, 20,  0, 56,  0, 80,  0,146,  0,146,  0,124,  0, 16,  0, 16,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_037[] = { 13,  0,  0,  0,  0,  0,  0, 33,192, 18, 32, 18, 32,  9,192,  4,  0,  2,  0,114,  0,137,  0,137,  0,112,128,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_038[] = { 10,  0,  0,  0,  0,  0,  0,113,  0,138,  0,132,  0,138,  0, 82,  0, 32,  0, 48,  0, 72,  0, 72,  0, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_039[] = {  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,128,128,128,  0,  0,  0};
static const GLubyte Helvetica14_Char_040[] = {  5, 32, 64, 64,128,128,128,128,128,128,128,128, 64, 64, 32,  0,  0,  0};
static const GLubyte Helvetica14_Char_041[] = {  5,128, 64, 64, 32, 32, 32, 32, 32, 32, 32, 32, 64, 64,128,  0,  0,  0};
static const GLubyte Helvetica14_Char_042[] = {  7,  0,  0,  0,  0,  0,  0,  0,  0,  0, 80, 32,248, 32,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_043[] = {  9,  0,  0,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0, 16,  0,254,  0, 16,  0, 16,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_044[] = {  4,  0,128, 64, 64, 64,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_045[] = {  6,  0,  0,  0,  0,  0,  0,  0,240,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_046[] = {  3,  0,  0,  0,128,128,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_047[] = {  6,  0,  0,  0,128,128,128, 64, 64, 64, 32, 32, 32, 16, 16,  0,  0,  0};
static const GLubyte Helvetica14_Char_048[] = {  8,  0,  0,  0,120,132,132,132,132,132,132,132,132,120,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_049[] = {  5,  0,  0,  0, 32, 32, 32, 32, 32, 32, 32, 32,224, 32,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_050[] = {  8,  0,  0,  0,252,128,128, 64, 32, 16,  8,132,132,120,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_051[] = {  8,  0,  0,  0,120,132,132,  4,  4, 56,  4,132,132,120,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_052[] = {  9,  0,  0,  0,  0,  0,  0,  4,  0,  4,  0,  4,  0,254,  0,132,  0, 68,  0, 36,  0, 36,  0, 20,  0, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_053[] = {  8,  0,  0,  0,120,132,132,  4,  4,248,128,128,128,252,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_054[] = {  8,  0,  0,  0,120,132,132,132,196,184,128,128,132,120,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_055[] = {  8,  0,  0,  0, 64, 64, 32, 32, 16, 16,  8,  8,  4,252,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_056[] = {  8,  0,  0,  0,120,132,132,132,132,120,132,132,132,120,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_057[] = {  8,  0,  0,  0,120,132,132,  4,124,132,132,132,132,120,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_058[] = {  3,  0,  0,  0,128,128,  0,  0,  0,  0,128,128,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_059[] = {  4,  0,128, 64, 64, 64,  0,  0,  0,  0, 64, 64,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_060[] = {  8,  0,  0,  0,  0,  0, 12, 48,192, 48, 12,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_061[] = {  8,  0,  0,  0,  0,  0,  0,252,  0,252,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_062[] = {  8,  0,  0,  0,  0,  0,192, 48, 12, 48,192,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_063[] = {  8,  0,  0,  0, 32, 32,  0, 32, 16,  8,  4,132,132,204, 48,  0,  0,  0};
static const GLubyte Helvetica14_Char_064[] = { 13,  0,  0,  0,  0, 31,  0, 96,128, 64,  0,141,128,147, 64,145, 32,145, 32,137, 32, 70,160, 64, 32, 48,192, 15,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_065[] = { 11,  0,  0,  0,  0,  0,  0,128,128,128,128, 65,  0,127,  0, 65,  0, 34,  0, 34,  0, 20,  0, 20,  0,  8,  0,  8,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_066[] = {  9,  0,  0,  0,  0,  0,  0,252,  0,130,  0,130,  0,130,  0,130,  0,252,  0,130,  0,130,  0,130,  0,134,  0,252,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_067[] = { 10,  0,  0,  0,  0,  0,  0, 28,  0, 99,  0, 65,  0,128,  0,128,  0,128,  0,128,  0,128,  0, 65,  0, 99,  0, 28,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_068[] = { 10,  0,  0,  0,  0,  0,  0,248,  0,134,  0,130,  0,129,  0,129,  0,129,  0,129,  0,129,  0,130,  0,134,  0,248,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_069[] = {  9,  0,  0,  0,  0,  0,  0,254,  0,128,  0,128,  0,128,  0,128,  0,252,  0,128,  0,128,  0,128,  0,128,  0,254,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_070[] = {  9,  0,  0,  0,  0,  0,  0,128,  0,128,  0,128,  0,128,  0,128,  0,252,  0,128,  0,128,  0,128,  0,128,  0,254,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_071[] = { 11,  0,  0,  0,  0,  0,  0, 28,128, 99,128, 64,128,128,128,128,128,135,128,128,  0,128,  0, 64,128, 97,128, 30,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_072[] = { 10,  0,  0,  0,  0,  0,  0,129,  0,129,  0,129,  0,129,  0,129,  0,255,  0,129,  0,129,  0,129,  0,129,  0,129,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_073[] = {  3,  0,  0,  0,128,128,128,128,128,128,128,128,128,128,128,  0,  0,  0};
static const GLubyte Helvetica14_Char_074[] = {  8,  0,  0,  0,120,132,132,  4,  4,  4,  4,  4,  4,  4,  4,  0,  0,  0};
static const GLubyte Helvetica14_Char_075[] = { 10,  0,  0,  0,  0,  0,  0,129,  0,130,  0,132,  0,136,  0,144,  0,224,  0,160,  0,144,  0,136,  0,132,  0,130,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_076[] = {  8,  0,  0,  0,252,128,128,128,128,128,128,128,128,128,128,  0,  0,  0};
static const GLubyte Helvetica14_Char_077[] = { 13,  0,  0,  0,  0,  0,  0,132, 32,132, 32,138, 32,138, 32,145, 32,145, 32,160,160,160,160,192, 96,128, 32,128, 32,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_078[] = { 10,  0,  0,  0,  0,  0,  0,131,  0,131,  0,133,  0,133,  0,137,  0,137,  0,145,  0,145,  0,161,  0,193,  0,193,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_079[] = { 11,  0,  0,  0,  0,  0,  0, 28,  0, 99,  0, 65,  0,128,128,128,128,128,128,128,128,128,128, 65,  0, 99,  0, 28,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_080[] = {  9,  0,  0,  0,  0,  0,  0,128,  0,128,  0,128,  0,128,  0,128,  0,252,  0,134,  0,130,  0,130,  0,134,  0,252,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_081[] = { 11,  0,  0,  0,  0,  0,  0, 28,128, 99,  0, 67,  0,132,128,136,128,128,128,128,128,128,128, 65,  0, 99,  0, 28,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_082[] = {  9,  0,  0,  0,  0,  0,  0,130,  0,130,  0,130,  0,130,  0,132,  0,248,  0,132,  0,130,  0,130,  0,134,  0,252,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_083[] = {  9,  0,  0,  0,  0,  0,  0, 56,  0,198,  0,130,  0,  2,  0,  6,  0, 24,  0, 96,  0,128,  0,130,  0,198,  0, 56,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_084[] = { 11,  0,  0,  0,  0,  0,  0,  8,  0,  8,  0,  8,  0,  8,  0,  8,  0,  8,  0,  8,  0,  8,  0,  8,  0,  8,  0,255,128,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_085[] = { 10,  0,  0,  0,  0,  0,  0, 60,  0, 66,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_086[] = { 11,  0,  0,  0,  0,  0,  0,  8,  0,  8,  0, 20,  0, 20,  0, 34,  0, 34,  0, 34,  0, 65,  0, 65,  0,128,128,128,128,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_087[] = { 15,  0,  0,  0,  0,  0,  0, 16, 64, 16, 64, 40,160, 40,160, 40,160, 69, 16, 69, 16, 69, 16,133,  8,130,  8,130,  8,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_088[] = { 10,  0,  0,  0,  0,  0,  0,129,  0,129,  0, 66,  0, 66,  0, 36,  0, 24,  0, 24,  0, 36,  0, 66,  0,129,  0,129,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_089[] = { 11,  0,  0,  0,  0,  0,  0,  8,  0,  8,  0,  8,  0,  8,  0,  8,  0, 20,  0, 34,  0, 34,  0, 65,  0, 65,  0,128,128,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_090[] = {  9,  0,  0,  0,  0,  0,  0,254,  0,128,  0, 64,  0, 96,  0, 32,  0, 16,  0, 24,  0,  8,  0,  4,  0,  2,  0,254,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_091[] = {  5,224,128,128,128,128,128,128,128,128,128,128,128,128,224,  0,  0,  0};
static const GLubyte Helvetica14_Char_092[] = {  6,  0,  0,  0, 16, 16, 16, 32, 32, 32, 64, 64, 64,128,128,  0,  0,  0};
static const GLubyte Helvetica14_Char_093[] = {  5,224, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,224,  0,  0,  0};
static const GLubyte Helvetica14_Char_094[] = {  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,130,  0, 68,  0, 40,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_095[] = { 10,255,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_096[] = {  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 64,128,  0,  0,  0};
static const GLubyte Helvetica14_Char_097[] = {  9,  0,  0,  0,  0,  0,  0,118,  0,204,  0,132,  0,196,  0,124,  0,  4,  0,204,  0,120,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_098[] = {  8,  0,  0,  0,184,204,132,132,132,132,204,184,128,128,128,  0,  0,  0};
static const GLubyte Helvetica14_Char_099[] = {  8,  0,  0,  0,120,204,132,128,128,128,204,120,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_100[] = {  8,  0,  0,  0,116,204,132,132,132,132,204,116,  4,  4,  4,  0,  0,  0};
static const GLubyte Helvetica14_Char_101[] = {  8,  0,  0,  0,120,204,128,128,252,132,204,120,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_102[] = {  6,  0,  0,  0, 64, 64, 64, 64, 64, 64, 64,224, 64, 64, 48,  0,  0,  0};
static const GLubyte Helvetica14_Char_103[] = {  8,120,204,  4,116,204,132,132,132,132,204,116,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_104[] = {  8,  0,  0,  0,132,132,132,132,132,132,204,184,128,128,128,  0,  0,  0};
static const GLubyte Helvetica14_Char_105[] = {  3,  0,  0,  0,128,128,128,128,128,128,128,128,  0,128,128,  0,  0,  0};
static const GLubyte Helvetica14_Char_106[] = {  5,192, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,  0, 32, 32,  0,  0,  0};
static const GLubyte Helvetica14_Char_107[] = {  8,  0,  0,  0,132,136,144,160,192,160,144,136,128,128,128,  0,  0,  0};
static const GLubyte Helvetica14_Char_108[] = {  3,  0,  0,  0,128,128,128,128,128,128,128,128,128,128,128,  0,  0,  0};
static const GLubyte Helvetica14_Char_109[] = { 11,  0,  0,  0,  0,  0,  0,136,128,136,128,136,128,136,128,136,128,136,128,204,128,179,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_110[] = {  8,  0,  0,  0,132,132,132,132,132,132,204,184,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_111[] = {  8,  0,  0,  0,120,204,132,132,132,132,204,120,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_112[] = {  8,128,128,128,184,204,132,132,132,132,204,184,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_113[] = {  8,  4,  4,  4,116,204,132,132,132,132,204,116,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_114[] = {  6,  0,  0,  0,128,128,128,128,128,128,192,176,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_115[] = {  8,  0,  0,  0,120,132,  4, 12,120,128,132,120,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_116[] = {  6,  0,  0,  0, 48, 64, 64, 64, 64, 64, 64,240, 64, 64,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_117[] = {  8,  0,  0,  0,116,204,132,132,132,132,132,132,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_118[] = {  8,  0,  0,  0, 48, 48, 72, 72, 72,132,132,132,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_119[] = { 11,  0,  0,  0,  0,  0,  0, 34,  0, 34,  0, 85,  0, 73,  0, 73,  0,136,128,136,128,136,128,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_120[] = {  9,  0,  0,  0,  0,  0,  0,198,  0, 68,  0, 40,  0, 16,  0, 16,  0, 40,  0, 68,  0,198,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_121[] = {  9, 96,  0, 48,  0, 16,  0, 16,  0, 24,  0, 40,  0, 36,  0, 68,  0, 68,  0,130,  0,130,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_122[] = {  8,  0,  0,  0,252,128, 64, 32, 16,  8,  4,252,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_123[] = {  7, 24, 32, 32, 32, 32, 32, 64,128, 64, 32, 32, 32, 32, 24,  0,  0,  0};
static const GLubyte Helvetica14_Char_124[] = {  3,128,128,128,128,128,128,128,128,128,128,128,128,128,128,  0,  0,  0};
static const GLubyte Helvetica14_Char_125[] = {  7,192, 32, 32, 32, 32, 32, 16,  8, 16, 32, 32, 32, 32,192,  0,  0,  0};
static const GLubyte Helvetica14_Char_126[] = {  8,  0,  0,  0,  0,  0,  0,152,180,100,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_128[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_129[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_130[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_131[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_132[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_133[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_134[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_135[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_136[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_137[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_138[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_139[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_140[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_141[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_142[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_143[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_144[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_145[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_146[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_147[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_148[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_149[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_150[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_151[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_152[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_153[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_154[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_155[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_156[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_157[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_158[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_159[] = {  9,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,130,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_160[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,128,  0,  0,  0};
static const GLubyte Helvetica14_Char_161[] = {  3,128,128,128,128,128,128,128,128,  0,128,128,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_162[] = {  8,  0,  0,128,120,204,164,160,144,144,204,120,  4,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_163[] = {  9,  0,  0,  0,  0,  0,  0,220,  0, 98,  0, 64,  0, 32,  0,248,  0, 32,  0, 32,  0, 64,  0, 66,  0, 60,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_164[] = {  8,  0,  0,  0,  0,  0,132,120, 72, 72,120,132,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_165[] = {  9,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,254,  0, 16,  0,254,  0, 40,  0, 68,  0, 68,  0,130,  0,130,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_166[] = {  3,  0,128,128,128,128,128,  0,  0,  0,128,128,128,128,128,  0,  0,  0};
static const GLubyte Helvetica14_Char_167[] = {  7,112,216,136, 24,112,200,136,136,152,112,192,136,216,112,  0,  0,  0};
static const GLubyte Helvetica14_Char_168[] = {  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,216,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_169[] = { 12,  0,  0,  0,  0,  0,  0, 30,  0, 97,128, 76,128,146, 64,144, 64,144, 64,146, 64, 76,128, 97,128, 30,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_170[] = {  6,  0,  0,  0,  0,  0,  0,  0,240,  0,208,144,112, 16,224,  0,  0,  0};
static const GLubyte Helvetica14_Char_171[] = {  8,  0,  0,  0,  0,  0, 36, 72,144, 72, 36,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_172[] = {  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,  2,  0,  2,  0,254,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_173[] = {  6,  0,  0,  0,  0,  0,  0,  0,240,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_174[] = { 12,  0,  0,  0,  0,  0,  0, 30,  0, 97,128, 82,128,146, 64,156, 64,146, 64,146, 64, 92,128, 97,128, 30,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_175[] = {  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,240,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_176[] = {  6,  0,  0,  0,  0,  0,  0,  0,  0,  0, 96,144,144, 96,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_177[] = {  9,  0,  0,  0,  0,  0,  0,254,  0,  0,  0, 16,  0, 16,  0, 16,  0,254,  0, 16,  0, 16,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_178[] = {  6,  0,  0,  0,  0,  0,  0,  0,240, 64, 32, 16,144, 96,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_179[] = {  6,  0,  0,  0,  0,  0,  0,  0, 96,144, 16, 32,144, 96,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_180[] = {  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,128, 64,  0,  0,  0};
static const GLubyte Helvetica14_Char_181[] = {  8,128,128,128,180,204,132,132,132,132,132,132,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_182[] = {  9, 20,  0, 20,  0, 20,  0, 20,  0, 20,  0, 20,  0, 20,  0, 52,  0,116,  0,244,  0,244,  0,244,  0,116,  0, 62,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_183[] = {  4,  0,  0,  0,  0,  0,  0,  0,192,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_184[] = {  6, 96,144, 32,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_185[] = {  4,  0,  0,  0,  0,  0,  0,  0, 64, 64, 64, 64,192, 64,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_186[] = {  6,  0,  0,  0,  0,  0,  0,  0,240,  0, 96,144,144,144, 96,  0,  0,  0};
static const GLubyte Helvetica14_Char_187[] = {  8,  0,  0,  0,  0,  0,144, 72, 36, 72,144,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_188[] = { 12,  0,  0,  0,  0,  0,  0, 32,128, 39,192, 20,128, 18,128,  9,128, 72,128, 68,  0, 68,  0, 66,  0,194,  0, 65,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_189[] = { 11,  0,  0,  0,  0,  0,  0, 71,128, 66,  0, 33,  0, 32,128, 20,128, 83,  0, 72,  0, 72,  0, 68,  0,196,  0, 66,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_190[] = { 13,  0,  0,  0,  0,  0,  0, 16, 64, 19,224, 10, 64,  9, 64,  4,192,100, 64,146,  0, 18,  0, 33,  0,145,  0, 96,128,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_191[] = {  8, 48,204,132,132,128, 64, 32, 16,  0, 16, 16,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_192[] = { 11,  0,  0,  0,  0,  0,  0,128,128,128,128, 65,  0,127,  0, 65,  0, 34,  0, 34,  0, 20,  0, 20,  0,  8,  0,  8,  0,  0,  0,  8,  0, 16,  0};
static const GLubyte Helvetica14_Char_193[] = { 11,  0,  0,  0,  0,  0,  0,128,128,128,128, 65,  0,127,  0, 65,  0, 34,  0, 34,  0, 20,  0, 20,  0,  8,  0,  8,  0,  0,  0,  8,  0,  4,  0};
static const GLubyte Helvetica14_Char_194[] = { 11,  0,  0,  0,  0,  0,  0,128,128,128,128, 65,  0,127,  0, 65,  0, 34,  0, 34,  0, 20,  0, 20,  0,  8,  0,  8,  0,  0,  0, 20,  0,  8,  0};
static const GLubyte Helvetica14_Char_195[] = { 11,  0,  0,  0,  0,  0,  0,128,128,128,128, 65,  0,127,  0, 65,  0, 34,  0, 34,  0, 20,  0, 20,  0,  8,  0,  8,  0,  0,  0, 44,  0, 26,  0};
static const GLubyte Helvetica14_Char_196[] = { 11,  0,  0,  0,  0,  0,  0,128,128,128,128, 65,  0,127,  0, 65,  0, 34,  0, 34,  0, 20,  0, 20,  0,  8,  0,  8,  0,  0,  0, 54,  0,  0,  0};
static const GLubyte Helvetica14_Char_197[] = { 11,  0,  0,  0,  0,  0,  0,128,128,128,128, 65,  0,127,  0, 65,  0, 34,  0, 34,  0, 20,  0, 20,  0,  8,  0,  8,  0, 28,  0, 34,  0, 28,  0};
static const GLubyte Helvetica14_Char_198[] = { 14,  0,  0,  0,  0,  0,  0,135,240,132,  0, 68,  0,124,  0, 68,  0, 39,224, 36,  0, 20,  0, 20,  0, 28,  0, 15,240,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_199[] = { 10, 24,  0, 36,  0,  8,  0, 28,  0, 99,  0, 65,  0,128,  0,128,  0,128,  0,128,  0,128,  0, 65,  0, 99,  0, 28,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_200[] = {  9,  0,  0,  0,  0,  0,  0,254,  0,128,  0,128,  0,128,  0,128,  0,252,  0,128,  0,128,  0,128,  0,128,  0,254,  0,  0,  0, 16,  0, 32,  0};
static const GLubyte Helvetica14_Char_201[] = {  9,  0,  0,  0,  0,  0,  0,254,  0,128,  0,128,  0,128,  0,128,  0,252,  0,128,  0,128,  0,128,  0,128,  0,254,  0,  0,  0, 16,  0,  8,  0};
static const GLubyte Helvetica14_Char_202[] = {  9,  0,  0,  0,  0,  0,  0,254,  0,128,  0,128,  0,128,  0,128,  0,252,  0,128,  0,128,  0,128,  0,128,  0,254,  0,  0,  0, 40,  0, 16,  0};
static const GLubyte Helvetica14_Char_203[] = {  9,  0,  0,  0,  0,  0,  0,254,  0,128,  0,128,  0,128,  0,128,  0,252,  0,128,  0,128,  0,128,  0,128,  0,254,  0,  0,  0,108,  0,  0,  0};
static const GLubyte Helvetica14_Char_204[] = {  4,  0,  0,  0, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,  0, 64,128};
static const GLubyte Helvetica14_Char_205[] = {  4,  0,  0,  0,128,128,128,128,128,128,128,128,128,128,128,  0,128, 64};
static const GLubyte Helvetica14_Char_206[] = {  5,  0,  0,  0, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,  0,160, 64};
static const GLubyte Helvetica14_Char_207[] = {  7,  0,  0,  0, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,  0,216,  0};
static const GLubyte Helvetica14_Char_208[] = { 11,  0,  0,  0,  0,  0,  0,124,  0, 67,  0, 65,  0, 64,128, 64,128,240,128, 64,128, 64,128, 65,  0, 67,  0,124,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_209[] = { 10,  0,  0,  0,  0,  0,  0,131,  0,131,  0,133,  0,133,  0,137,  0,137,  0,145,  0,145,  0,161,  0,193,  0,193,  0,  0,  0, 44,  0, 26,  0};
static const GLubyte Helvetica14_Char_210[] = { 11,  0,  0,  0,  0,  0,  0, 28,  0, 99,  0, 65,  0,128,128,128,128,128,128,128,128,128,128, 65,  0, 99,  0, 28,  0,  0,  0,  8,  0, 16,  0};
static const GLubyte Helvetica14_Char_211[] = { 11,  0,  0,  0,  0,  0,  0, 28,  0, 99,  0, 65,  0,128,128,128,128,128,128,128,128,128,128, 65,  0, 99,  0, 28,  0,  0,  0,  8,  0,  4,  0};
static const GLubyte Helvetica14_Char_212[] = { 11,  0,  0,  0,  0,  0,  0, 28,  0, 99,  0, 65,  0,128,128,128,128,128,128,128,128,128,128, 65,  0, 99,  0, 28,  0,  0,  0, 20,  0,  8,  0};
static const GLubyte Helvetica14_Char_213[] = { 11,  0,  0,  0,  0,  0,  0, 28,  0, 99,  0, 65,  0,128,128,128,128,128,128,128,128,128,128, 65,  0, 99,  0, 28,  0,  0,  0, 44,  0, 26,  0};
static const GLubyte Helvetica14_Char_214[] = { 11,  0,  0,  0,  0,  0,  0, 28,  0, 99,  0, 65,  0,128,128,128,128,128,128,128,128,128,128, 65,  0, 99,  0, 28,  0,  0,  0, 54,  0,  0,  0};
static const GLubyte Helvetica14_Char_215[] = {  9,  0,  0,  0,  0,  0,  0,  0,  0,130,  0, 68,  0, 40,  0, 16,  0, 40,  0, 68,  0,130,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_216[] = { 13,  0,  0,  0,  0,  0,  0,142,  0,113,128, 32,128, 80, 64, 72, 64, 68, 64, 66, 64, 65, 64, 32,128, 49,192, 14, 32,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_217[] = { 10,  0,  0,  0,  0,  0,  0, 60,  0, 66,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,  0,  0,  8,  0, 16,  0};
static const GLubyte Helvetica14_Char_218[] = { 10,  0,  0,  0,  0,  0,  0, 60,  0, 66,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,  0,  0,  8,  0,  4,  0};
static const GLubyte Helvetica14_Char_219[] = { 10,  0,  0,  0,  0,  0,  0, 60,  0, 66,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,  0,  0, 20,  0,  8,  0};
static const GLubyte Helvetica14_Char_220[] = { 10,  0,  0,  0,  0,  0,  0, 60,  0, 66,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,129,  0,  0,  0,102,  0,  0,  0};
static const GLubyte Helvetica14_Char_221[] = { 11,  0,  0,  0,  0,  0,  0,  8,  0,  8,  0,  8,  0,  8,  0,  8,  0, 20,  0, 34,  0, 34,  0, 65,  0, 65,  0,128,128,  0,  0,  8,  0,  4,  0};
static const GLubyte Helvetica14_Char_222[] = {  9,  0,  0,  0,  0,  0,  0,128,  0,128,  0,128,  0,252,  0,134,  0,130,  0,130,  0,134,  0,252,  0,128,  0,128,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_223[] = {  7,  0,  0,  0,176,136,136,136,136,144,176,136,136,136,112,  0,  0,  0};
static const GLubyte Helvetica14_Char_224[] = {  9,  0,  0,  0,  0,  0,  0,118,  0,204,  0,132,  0,196,  0,124,  0,  4,  0,204,  0,120,  0,  0,  0, 16,  0, 32,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_225[] = {  9,  0,  0,  0,  0,  0,  0,118,  0,204,  0,132,  0,196,  0,124,  0,  4,  0,204,  0,120,  0,  0,  0, 16,  0,  8,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_226[] = {  9,  0,  0,  0,  0,  0,  0,118,  0,204,  0,132,  0,196,  0,124,  0,  4,  0,204,  0,120,  0,  0,  0, 40,  0, 16,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_227[] = {  9,  0,  0,  0,  0,  0,  0,118,  0,204,  0,132,  0,196,  0,124,  0,  4,  0,204,  0,120,  0,  0,  0, 88,  0, 52,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_228[] = {  9,  0,  0,  0,  0,  0,  0,118,  0,204,  0,132,  0,196,  0,124,  0,  4,  0,204,  0,120,  0,  0,  0,108,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_229[] = {  9,  0,  0,  0,  0,  0,  0,118,  0,204,  0,132,  0,196,  0,124,  0,  4,  0,204,  0,120,  0,  0,  0, 48,  0, 72,  0, 48,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_230[] = { 13,  0,  0,  0,  0,  0,  0,123,192,206, 96,132,  0,196,  0,127,224,  4, 32,198, 96,123,192,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_231[] = {  8, 48, 72, 16,120,204,132,128,128,128,204,120,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_232[] = {  8,  0,  0,  0,120,204,128,128,252,132,204,120,  0, 16, 32,  0,  0,  0};
static const GLubyte Helvetica14_Char_233[] = {  8,  0,  0,  0,120,204,128,128,252,132,204,120,  0, 32, 16,  0,  0,  0};
static const GLubyte Helvetica14_Char_234[] = {  8,  0,  0,  0,120,204,128,128,252,132,204,120,  0, 40, 16,  0,  0,  0};
static const GLubyte Helvetica14_Char_235[] = {  8,  0,  0,  0,120,204,128,128,252,132,204,120,  0,204,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_236[] = {  4,  0,  0,  0, 64, 64, 64, 64, 64, 64, 64, 64,  0, 64,128,  0,  0,  0};
static const GLubyte Helvetica14_Char_237[] = {  4,  0,  0,  0,128,128,128,128,128,128,128,128,  0,128, 64,  0,  0,  0};
static const GLubyte Helvetica14_Char_238[] = {  5,  0,  0,  0, 64, 64, 64, 64, 64, 64, 64, 64,  0,160, 64,  0,  0,  0};
static const GLubyte Helvetica14_Char_239[] = {  5,  0,  0,  0, 64, 64, 64, 64, 64, 64, 64, 64,  0,160,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_240[] = {  8,  0,  0,  0,120,204,132,132,132,132,124,  8,144,112,216,  0,  0,  0};
static const GLubyte Helvetica14_Char_241[] = {  8,  0,  0,  0,132,132,132,132,132,132,204,184,  0, 88, 52,  0,  0,  0};
static const GLubyte Helvetica14_Char_242[] = {  8,  0,  0,  0,120,204,132,132,132,132,204,120,  0, 16, 32,  0,  0,  0};
static const GLubyte Helvetica14_Char_243[] = {  8,  0,  0,  0,120,204,132,132,132,132,204,120,  0, 16,  8,  0,  0,  0};
static const GLubyte Helvetica14_Char_244[] = {  8,  0,  0,  0,120,204,132,132,132,132,204,120,  0, 72, 48,  0,  0,  0};
static const GLubyte Helvetica14_Char_245[] = {  8,  0,  0,  0,120,204,132,132,132,132,204,120,  0, 88, 52,  0,  0,  0};
static const GLubyte Helvetica14_Char_246[] = {  8,  0,  0,  0,120,204,132,132,132,132,204,120,  0,204,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_247[] = {  9,  0,  0,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,  0,  0,254,  0,  0,  0, 16,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_248[] = { 10,  0,  0,  0,  0,  0,  0,188,  0, 70,  0, 98,  0, 82,  0, 74,  0, 70,  0, 98,  0, 61,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_249[] = {  8,  0,  0,  0,116,204,132,132,132,132,132,132,  0, 16, 32,  0,  0,  0};
static const GLubyte Helvetica14_Char_250[] = {  8,  0,  0,  0,116,204,132,132,132,132,132,132,  0, 16,  8,  0,  0,  0};
static const GLubyte Helvetica14_Char_251[] = {  8,  0,  0,  0,116,204,132,132,132,132,132,132,  0, 72, 48,  0,  0,  0};
static const GLubyte Helvetica14_Char_252[] = {  8,  0,  0,  0,116,204,132,132,132,132,132,132,  0,204,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_253[] = {  9, 96,  0, 48,  0, 16,  0, 16,  0, 24,  0, 40,  0, 36,  0, 68,  0, 68,  0,194,  0,130,  0,  0,  0, 16,  0,  8,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Helvetica14_Char_254[] = {  8,128,128,128,184,204,132,132,132,132,204,184,128,128,128,  0,  0,  0};
static const GLubyte Helvetica14_Char_255[] = {  9, 96,  0, 48,  0, 16,  0, 16,  0, 24,  0, 40,  0, 36,  0, 68,  0, 68,  0,194,  0,130,  0,  0,  0,108,  0,  0,  0,  0,  0,  0,  0,  0,  0};

static const GLubyte *Helvetica14_Char_Map[] = {
	Helvetica14_Char_063, Helvetica14_Char_063, Helvetica14_Char_063, Helvetica14_Char_063,
	Helvetica14_Char_063, Helvetica14_Char_063, Helvetica14_Char_063, Helvetica14_Char_063,
	Helvetica14_Char_063, Helvetica14_Char_063, Helvetica14_Char_063, Helvetica14_Char_063,
	Helvetica14_Char_063, Helvetica14_Char_063, Helvetica14_Char_063, Helvetica14_Char_063,
	Helvetica14_Char_063, Helvetica14_Char_063, Helvetica14_Char_063, Helvetica14_Char_063,
	Helvetica14_Char_063, Helvetica14_Char_063, Helvetica14_Char_063, Helvetica14_Char_063,
	Helvetica14_Char_063, Helvetica14_Char_063, Helvetica14_Char_063, Helvetica14_Char_063,
	Helvetica14_Char_063, Helvetica14_Char_063, Helvetica14_Char_063, Helvetica14_Char_032,
	Helvetica14_Char_033, Helvetica14_Char_034, Helvetica14_Char_035, Helvetica14_Char_036,
	Helvetica14_Char_037, Helvetica14_Char_038, Helvetica14_Char_039, Helvetica14_Char_040,
	Helvetica14_Char_041, Helvetica14_Char_042, Helvetica14_Char_043, Helvetica14_Char_044,
	Helvetica14_Char_045, Helvetica14_Char_046, Helvetica14_Char_047, Helvetica14_Char_048,
	Helvetica14_Char_049, Helvetica14_Char_050, Helvetica14_Char_051, Helvetica14_Char_052,
	Helvetica14_Char_053, Helvetica14_Char_054, Helvetica14_Char_055, Helvetica14_Char_056,
	Helvetica14_Char_057, Helvetica14_Char_058, Helvetica14_Char_059, Helvetica14_Char_060,
	Helvetica14_Char_061, Helvetica14_Char_062, Helvetica14_Char_063, Helvetica14_Char_064,
	Helvetica14_Char_065, Helvetica14_Char_066, Helvetica14_Char_067, Helvetica14_Char_068,
	Helvetica14_Char_069, Helvetica14_Char_070, Helvetica14_Char_071, Helvetica14_Char_072,
	Helvetica14_Char_073, Helvetica14_Char_074, Helvetica14_Char_075, Helvetica14_Char_076,
	Helvetica14_Char_077, Helvetica14_Char_078, Helvetica14_Char_079, Helvetica14_Char_080,
	Helvetica14_Char_081, Helvetica14_Char_082, Helvetica14_Char_083, Helvetica14_Char_084,
	Helvetica14_Char_085, Helvetica14_Char_086, Helvetica14_Char_087, Helvetica14_Char_088,
	Helvetica14_Char_089, Helvetica14_Char_090, Helvetica14_Char_091, Helvetica14_Char_092,
	Helvetica14_Char_093, Helvetica14_Char_094, Helvetica14_Char_095, Helvetica14_Char_096,
	Helvetica14_Char_097, Helvetica14_Char_098, Helvetica14_Char_099, Helvetica14_Char_100,
	Helvetica14_Char_101, Helvetica14_Char_102, Helvetica14_Char_103, Helvetica14_Char_104,
	Helvetica14_Char_105, Helvetica14_Char_106, Helvetica14_Char_107, Helvetica14_Char_108,
	Helvetica14_Char_109, Helvetica14_Char_110, Helvetica14_Char_111, Helvetica14_Char_112,
	Helvetica14_Char_113, Helvetica14_Char_114, Helvetica14_Char_115, Helvetica14_Char_116,
	Helvetica14_Char_117, Helvetica14_Char_118, Helvetica14_Char_119, Helvetica14_Char_120,
	Helvetica14_Char_121, Helvetica14_Char_122, Helvetica14_Char_123, Helvetica14_Char_124,
	Helvetica14_Char_125, Helvetica14_Char_126, Helvetica14_Char_063, Helvetica14_Char_128,
	Helvetica14_Char_129, Helvetica14_Char_130, Helvetica14_Char_131, Helvetica14_Char_132,
	Helvetica14_Char_133, Helvetica14_Char_134, Helvetica14_Char_135, Helvetica14_Char_136,
	Helvetica14_Char_137, Helvetica14_Char_138, Helvetica14_Char_139, Helvetica14_Char_140,
	Helvetica14_Char_141, Helvetica14_Char_142, Helvetica14_Char_143, Helvetica14_Char_144,
	Helvetica14_Char_145, Helvetica14_Char_146, Helvetica14_Char_147, Helvetica14_Char_148,
	Helvetica14_Char_149, Helvetica14_Char_150, Helvetica14_Char_151, Helvetica14_Char_152,
	Helvetica14_Char_153, Helvetica14_Char_154, Helvetica14_Char_155, Helvetica14_Char_156,
	Helvetica14_Char_157, Helvetica14_Char_158, Helvetica14_Char_159, Helvetica14_Char_160,
	Helvetica14_Char_161, Helvetica14_Char_162, Helvetica14_Char_163, Helvetica14_Char_164,
	Helvetica14_Char_165, Helvetica14_Char_166, Helvetica14_Char_167, Helvetica14_Char_168,
	Helvetica14_Char_169, Helvetica14_Char_170, Helvetica14_Char_171, Helvetica14_Char_172,
	Helvetica14_Char_173, Helvetica14_Char_174, Helvetica14_Char_175, Helvetica14_Char_176,
	Helvetica14_Char_177, Helvetica14_Char_178, Helvetica14_Char_179, Helvetica14_Char_180,
	Helvetica14_Char_181, Helvetica14_Char_182, Helvetica14_Char_183, Helvetica14_Char_184,
	Helvetica14_Char_185, Helvetica14_Char_186, Helvetica14_Char_187, Helvetica14_Char_188,
	Helvetica14_Char_189, Helvetica14_Char_190, Helvetica14_Char_191, Helvetica14_Char_192,
	Helvetica14_Char_193, Helvetica14_Char_194, Helvetica14_Char_195, Helvetica14_Char_196,
	Helvetica14_Char_197, Helvetica14_Char_198, Helvetica14_Char_199, Helvetica14_Char_200,
	Helvetica14_Char_201, Helvetica14_Char_202, Helvetica14_Char_203, Helvetica14_Char_204,
	Helvetica14_Char_205, Helvetica14_Char_206, Helvetica14_Char_207, Helvetica14_Char_208,
	Helvetica14_Char_209, Helvetica14_Char_210, Helvetica14_Char_211, Helvetica14_Char_212,
	Helvetica14_Char_213, Helvetica14_Char_214, Helvetica14_Char_215, Helvetica14_Char_216,
	Helvetica14_Char_217, Helvetica14_Char_218, Helvetica14_Char_219, Helvetica14_Char_220,
	Helvetica14_Char_221, Helvetica14_Char_222, Helvetica14_Char_223, Helvetica14_Char_224,
	Helvetica14_Char_225, Helvetica14_Char_226, Helvetica14_Char_227, Helvetica14_Char_228,
	Helvetica14_Char_229, Helvetica14_Char_230, Helvetica14_Char_231, Helvetica14_Char_232,
	Helvetica14_Char_233, Helvetica14_Char_234, Helvetica14_Char_235, Helvetica14_Char_236,
	Helvetica14_Char_237, Helvetica14_Char_238, Helvetica14_Char_239, Helvetica14_Char_240,
	Helvetica14_Char_241, Helvetica14_Char_242, Helvetica14_Char_243, Helvetica14_Char_244,
	Helvetica14_Char_245, Helvetica14_Char_246, Helvetica14_Char_247, Helvetica14_Char_248,
	Helvetica14_Char_249, Helvetica14_Char_250, Helvetica14_Char_251, Helvetica14_Char_252,
	Helvetica14_Char_253, Helvetica14_Char_254, Helvetica14_Char_255, 0};

const SFG_Font fgFontHelvetica14 = {"-adobe-helvetica-medium-r-*-*-*-140-75-75-*-*-iso8859-1", 223, 17, Helvetica14_Char_Map, 0.0f, 0.0f};

static fntBitmapFont fntHelvetica14(fgFontHelvetica14.Characters, 1,
		fgFontHelvetica14.Height, fgFontHelvetica14.xorig, fgFontHelvetica14.yorig);


/**
 * SANS_12B (generated from "Bitstream Vera 12 Bold"):
 *
 * Copyright (c) 2003 by Bitstream, Inc. All Rights Reserved.
 * Bitstream Vera Sans Bold
 * Release 1.10
 * Bitstream Vera is a trademark of Bitstream, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the fonts accompanying this license ("Fonts") and associated documentation
 * files (the "Font Software"), to reproduce and distribute the Font Software,
 * including without limitation the rights to use, copy, merge, publish, distribute,
 * and/or sell copies of the Font Software, and to permit persons to whom the Font
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright and trademark notices and this permission notice shall be
 * included in all copies of one or more of the Font Software typefaces.

 * The Font Software may be modified, altered, or added to, and in particular the
 * designs of glyphs or characters in the Fonts may be modified and additional
 * glyphs or characters may be added to the Fonts, only if the fonts are renamed
 * to names not containing either the words "Bitstream" or the word "Vera".
 *
 * This License becomes null and void to the extent applicable to Fonts or Font
 * Software that has been modified and is distributed under the "Bitstream Vera" names.
 *
 * The Font Software may be sold as part of a larger software package but no
 * copy of one or more of the Font Software typefaces may be sold by itself.
 */

static const GLubyte Sans12B_Char_032[] = {  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_033[] = {  4,  0,  0,  0,192,192,  0,192,192,192,192,192,192,  0,  0,  0};
static const GLubyte Sans12B_Char_034[] = {  5,  0,  0,  0,  0,  0,  0,  0,  0,160,160,160,160,  0,  0,  0};
static const GLubyte Sans12B_Char_035[] = { 11,  0,  0,  0,  0,  0,  0,108,  0,108,  0, 36,  0,255,  0, 54,  0, 54,  0,127,128, 18,  0, 27,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_036[] = {  9,  0,  0, 16,  0, 16,  0,124,  0,150,  0, 22,  0,126,  0,248,  0,208,  0,212,  0,120,  0, 16,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_037[] = { 14,  0,  0,  0,  0,  0,  0, 16,224,  9,176,  9,176,  5,176,118,224,218,  0,217,  0,217,  0,112,128,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_038[] = { 12,  0,  0,  0,  0,  0,  0,126,192,231,128,199,  0,205,128,216,192,112,192, 96,  0,100,  0, 56,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_039[] = {  3,  0,  0,  0,  0,  0,  0,  0,  0,128,128,128,128,  0,  0,  0};
static const GLubyte Sans12B_Char_040[] = {  6,  0,112, 96, 96,192,192,192,192,192,192, 96, 96,112,  0,  0};
static const GLubyte Sans12B_Char_041[] = {  6,  0,192, 96, 96, 48, 48, 48, 48, 48, 48, 96, 96,224,  0,  0};
static const GLubyte Sans12B_Char_042[] = {  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 16,  0,214,  0,124,  0,124,  0,214,  0, 16,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_043[] = { 10,  0,  0,  0,  0,  0,  0, 24,  0, 24,  0, 24,  0,255,  0,255,  0, 24,  0, 24,  0, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_044[] = {  5,  0,128, 64, 96, 96,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_045[] = {  6,  0,  0,  0,  0,  0,  0,240,240,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_046[] = {  4,  0,  0,  0,192,192,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_047[] = {  7,  0,192,192, 64, 96, 96, 32, 48, 48, 16, 24, 24,  0,  0,  0};
static const GLubyte Sans12B_Char_048[] = {  9,  0,  0,  0,  0,  0,  0, 56,  0,108,  0,198,  0,198,  0,198,  0,198,  0,198,  0,108,  0, 56,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_049[] = {  8,  0,  0,  0,252, 48, 48, 48, 48, 48, 48, 48,240,  0,  0,  0};
static const GLubyte Sans12B_Char_050[] = { 10,  0,  0,  0,  0,  0,  0,255,  0, 96,  0, 56,  0, 12,  0,  6,  0,  3,  0,  3,  0,135,  0,124,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_051[] = {  9,  0,  0,  0,  0,  0,  0,124,  0,134,  0,  6,  0,  6,  0, 60,  0,  6,  0,  6,  0,134,  0,124,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_052[] = { 10,  0,  0,  0,  0,  0,  0,  6,  0,  6,  0,  6,  0,255,  0,134,  0, 70,  0, 38,  0, 22,  0, 14,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_053[] = {  9,  0,  0,  0,  0,  0,  0,124,  0,142,  0,  6,  0,  6,  0,142,  0,252,  0,192,  0,192,  0,252,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_054[] = {  9,  0,  0,  0,  0,  0,  0, 60,  0, 70,  0,198,  0,198,  0,198,  0,252,  0,192,  0,100,  0, 56,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_055[] = {  9,  0,  0,  0,  0,  0,  0, 96,  0, 48,  0, 48,  0, 24,  0, 24,  0, 12,  0, 12,  0,  6,  0,254,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_056[] = {  9,  0,  0,  0,  0,  0,  0,124,  0,198,  0,198,  0,198,  0, 56,  0,198,  0,198,  0,198,  0,124,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_057[] = {  9,  0,  0,  0,  0,  0,  0, 56,  0, 76,  0,  6,  0,126,  0,198,  0,198,  0,198,  0,196,  0,120,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_058[] = {  4,  0,  0,  0,192,192,  0,  0,  0,192,192,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_059[] = {  5,  0,128, 64, 96, 96,  0,  0,  0, 96, 96,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_060[] = { 10,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0, 15,  0,120,  0,192,  0,120,  0, 15,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_061[] = { 10,  0,  0,  0,  0,  0,  0,  0,  0,255,  0,255,  0,  0,  0,  0,  0,255,  0,255,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_062[] = { 10,  0,  0,  0,  0,  0,  0,  0,  0,128,  0,240,  0, 30,  0,  3,  0, 30,  0,240,  0,128,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_063[] = {  8,  0,  0,  0, 96, 96,  0, 96, 48, 24, 12,140,120,  0,  0,  0};
static const GLubyte Sans12B_Char_064[] = { 13,  0,  0, 31,  0, 32,128, 64,  0,143,192,145, 96,145, 32,145, 32,143, 32, 64, 64, 32,192, 31,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_065[] = { 12,  0,  0,  0,  0,  0,  0,192,192, 97,128,127,128, 97,128, 51,  0, 51,  0, 30,  0, 30,  0, 12,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_066[] = { 10,  0,  0,  0,  0,  0,  0,254,  0,195,  0,195,  0,195,  0,254,  0,195,  0,195,  0,195,  0,254,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_067[] = { 10,  0,  0,  0,  0,  0,  0, 63,  0, 97,  0,192,  0,192,  0,192,  0,192,  0,192,  0, 97,  0, 63,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_068[] = { 11,  0,  0,  0,  0,  0,  0,252,  0,199,  0,193,128,193,128,193,128,193,128,193,128,199,  0,252,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_069[] = {  9,  0,  0,  0,  0,  0,  0,254,  0,192,  0,192,  0,192,  0,254,  0,192,  0,192,  0,192,  0,254,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_070[] = {  9,  0,  0,  0,  0,  0,  0,192,  0,192,  0,192,  0,192,  0,254,  0,192,  0,192,  0,192,  0,254,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_071[] = { 11,  0,  0,  0,  0,  0,  0, 63,128, 97,128,193,128,193,128,195,128,192,  0,192,  0, 97,  0, 63,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_072[] = { 11,  0,  0,  0,  0,  0,  0,193,128,193,128,193,128,193,128,255,128,193,128,193,128,193,128,193,128,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_073[] = {  4,  0,  0,  0,192,192,192,192,192,192,192,192,192,  0,  0,  0};
static const GLubyte Sans12B_Char_074[] = {  6,224, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,  0,  0,  0};
static const GLubyte Sans12B_Char_075[] = { 10,  0,  0,  0,  0,  0,  0,195,  0,198,  0,204,  0,216,  0,240,  0,216,  0,204,  0,198,  0,195,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_076[] = {  9,  0,  0,  0,  0,  0,  0,254,  0,192,  0,192,  0,192,  0,192,  0,192,  0,192,  0,192,  0,192,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_077[] = { 13,  0,  0,  0,  0,  0,  0,192, 96,192, 96,206, 96,206, 96,219, 96,219, 96,241,224,241,224,224,224,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_078[] = { 11,  0,  0,  0,  0,  0,  0,195,128,195,128,199,128,205,128,201,128,217,128,241,128,225,128,225,128,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_079[] = { 11,  0,  0,  0,  0,  0,  0, 62,  0, 99,  0,193,128,193,128,193,128,193,128,193,128, 99,  0, 62,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_080[] = { 10,  0,  0,  0,  0,  0,  0,192,  0,192,  0,192,  0,254,  0,199,  0,195,  0,195,  0,199,  0,254,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_081[] = { 11,  0,  0,  3,  0,  6,  0, 62,  0, 99,  0,193,128,193,128,193,128,193,128,193,128, 99,  0, 62,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_082[] = { 10,  0,  0,  0,  0,  0,  0,195,  0,198,  0,204,  0,252,  0,198,  0,198,  0,198,  0,198,  0,252,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_083[] = {  9,  0,  0,  0,  0,  0,  0,252,  0,134,  0,  6,  0, 14,  0,124,  0,240,  0,192,  0,196,  0,124,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_084[] = { 10,  0,  0,  0,  0,  0,  0, 24,  0, 24,  0, 24,  0, 24,  0, 24,  0, 24,  0, 24,  0, 24,  0,255,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_085[] = { 10,  0,  0,  0,  0,  0,  0,126,  0,195,  0,195,  0,195,  0,195,  0,195,  0,195,  0,195,  0,195,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_086[] = { 12,  0,  0,  0,  0,  0,  0, 12,  0, 30,  0, 30,  0, 51,  0, 51,  0, 97,128, 97,128, 97,128,192,192,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_087[] = { 16,  0,  0,  0,  0,  0,  0, 56,112, 56,112, 60,240,108,216,100,152,103,152,103,152,195, 12,195, 12,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_088[] = { 12,  0,  0,  0,  0,  0,  0,225,192,115,128, 51,  0, 30,  0, 30,  0, 30,  0, 51,  0,115,128,225,192,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_089[] = { 12,  0,  0,  0,  0,  0,  0, 12,  0, 12,  0, 12,  0, 12,  0, 30,  0, 30,  0, 51,  0, 97,128,225,192,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_090[] = { 10,  0,  0,  0,  0,  0,  0,255,  0,192,  0, 96,  0, 48,  0, 24,  0, 12,  0,  6,  0,  3,  0,255,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_091[] = {  6,  0,240,192,192,192,192,192,192,192,192,192,192,240,  0,  0};
static const GLubyte Sans12B_Char_092[] = {  7,  0, 24, 24, 16, 48, 48, 32, 96, 96, 64,192,192,  0,  0,  0};
static const GLubyte Sans12B_Char_093[] = {  6,  0,240, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,240,  0,  0};
static const GLubyte Sans12B_Char_094[] = { 10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,195,  0,102,  0, 60,  0, 24,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_095[] = {  9,254,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_096[] = {  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 96,192,  0,  0};
static const GLubyte Sans12B_Char_097[] = {  9,  0,  0,  0,  0,  0,  0,126,  0,198,  0,198,  0,126,  0,  6,  0, 70,  0, 60,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_098[] = { 10,  0,  0,  0,  0,  0,  0,220,  0,230,  0,195,  0,195,  0,195,  0,230,  0,220,  0,192,  0,192,  0,192,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_099[] = {  8,  0,  0,  0, 56,100,192,192,192,100, 56,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_100[] = { 10,  0,  0,  0,  0,  0,  0, 59,  0,103,  0,195,  0,195,  0,195,  0,103,  0, 59,  0,  3,  0,  3,  0,  3,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_101[] = {  9,  0,  0,  0,  0,  0,  0, 60,  0, 98,  0,192,  0,254,  0,198,  0,100,  0, 60,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_102[] = {  7,  0,  0,  0, 96, 96, 96, 96, 96, 96,248, 96, 96, 56,  0,  0};
static const GLubyte Sans12B_Char_103[] = { 10, 60,  0, 70,  0,  3,  0, 59,  0,103,  0,195,  0,195,  0,195,  0,103,  0, 59,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_104[] = {  9,  0,  0,  0,  0,  0,  0,198,  0,198,  0,198,  0,198,  0,198,  0,230,  0,220,  0,192,  0,192,  0,192,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_105[] = {  4,  0,  0,  0,192,192,192,192,192,192,192,  0,192,192,  0,  0};
static const GLubyte Sans12B_Char_106[] = {  6,224, 48, 48, 48, 48, 48, 48, 48, 48, 48,  0, 48, 48,  0,  0};
static const GLubyte Sans12B_Char_107[] = {  9,  0,  0,  0,  0,  0,  0,198,  0,204,  0,216,  0,240,  0,216,  0,204,  0,198,  0,192,  0,192,  0,192,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_108[] = {  4,  0,  0,  0,192,192,192,192,192,192,192,192,192,192,  0,  0};
static const GLubyte Sans12B_Char_109[] = { 14,  0,  0,  0,  0,  0,  0,198, 48,198, 48,198, 48,198, 48,198, 48,231, 48,221,224,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_110[] = {  9,  0,  0,  0,  0,  0,  0,198,  0,198,  0,198,  0,198,  0,198,  0,230,  0,220,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_111[] = {  9,  0,  0,  0,  0,  0,  0,124,  0,198,  0,198,  0,198,  0,198,  0,198,  0,124,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_112[] = { 10,192,  0,192,  0,192,  0,220,  0,230,  0,195,  0,195,  0,195,  0,230,  0,220,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_113[] = { 10,  3,  0,  3,  0,  3,  0, 59,  0,103,  0,195,  0,195,  0,195,  0,103,  0, 59,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_114[] = {  7,  0,  0,  0,192,192,192,192,192,224,216,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_115[] = {  8,  0,  0,  0,120,140, 12,120,192,196,120,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_116[] = {  7,  0,  0,  0,120, 96, 96, 96, 96, 96,248, 96, 96,  0,  0,  0};
static const GLubyte Sans12B_Char_117[] = {  9,  0,  0,  0,  0,  0,  0,118,  0,206,  0,198,  0,198,  0,198,  0,198,  0,198,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_118[] = { 10,  0,  0,  0,  0,  0,  0, 24,  0, 60,  0, 60,  0,102,  0,102,  0,195,  0,195,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_119[] = { 13,  0,  0,  0,  0,  0,  0, 49,128, 49,128,123,192,106,192,110,192,206, 96,196, 96,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_120[] = { 10,  0,  0,  0,  0,  0,  0,195,  0,102,  0, 60,  0, 24,  0, 60,  0,102,  0,195,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_121[] = { 10,112,  0, 24,  0, 24,  0, 24,  0, 60,  0, 52,  0,102,  0,102,  0,195,  0,195,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_122[] = {  8,  0,  0,  0,252,192, 96, 48, 24, 12,252,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_123[] = {  8,  0, 28, 48, 48, 48, 48, 48,224, 48, 48, 48, 48, 28,  0,  0};
static const GLubyte Sans12B_Char_124[] = {  3,128,128,128,128,128,128,128,128,128,128,128,128,128,  0,  0};
static const GLubyte Sans12B_Char_125[] = {  8,  0,224, 48, 48, 48, 48, 48, 28, 48, 48, 48, 48,224,  0,  0};
static const GLubyte Sans12B_Char_126[] = { 10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,142,  0,255,  0,113,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_128[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_129[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_130[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_131[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_132[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_133[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_134[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_135[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_136[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_137[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_138[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_139[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_140[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_141[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_142[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_143[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_144[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_145[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_146[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_147[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_148[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_149[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_150[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_151[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_152[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_153[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_154[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_155[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_156[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_157[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_158[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_159[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_160[] = {  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_161[] = {  4,  0,  0,  0,192,192,192,192,192,192,  0,192,192,  0,  0,  0};
static const GLubyte Sans12B_Char_162[] = {  8,  0, 16, 16, 56,116,208,208,208,244,120, 16, 16,  0,  0,  0};
static const GLubyte Sans12B_Char_163[] = {  8,  0,  0,  0,252, 96, 96, 96,248, 96, 96, 96, 56,  0,  0,  0};
static const GLubyte Sans12B_Char_164[] = {  8,  0,  0,  0,  0,  0,248,136,136,136,248,  4,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_165[] = { 10,  0,  0,  0,  0,  0,  0, 24,  0, 24,  0, 24,  0,255,  0, 24,  0,255,  0, 36,  0,102,  0,195,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_166[] = {  3,  0,128,128,128,128,128,  0,128,128,128,128,128,  0,  0,  0};
static const GLubyte Sans12B_Char_167[] = {  8,  0,  0,112, 88, 24, 48,252,204,252, 48, 96,120,  0,  0,  0};
static const GLubyte Sans12B_Char_168[] = {  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,216,216,  0,  0};
static const GLubyte Sans12B_Char_169[] = { 11,  0,  0,  0,  0,  0,  0, 62,  0, 99,  0,221,128,160,128,160,128,160,128,221,128, 99,  0, 62,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_170[] = {  7,  0,  0,  0,  0,  0,248,  0,248,216,248, 24,240,  0,  0,  0};
static const GLubyte Sans12B_Char_171[] = {  8,  0,  0,  0,  0, 36,108,216,216,108, 36,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_172[] = { 10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  3,  0,255,  0,255,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_173[] = {  6,  0,  0,  0,  0,  0,  0,240,240,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_174[] = { 11,  0,  0,  0,  0,  0,  0, 62,  0, 99,  0,213,128,148,128,156,128,148,128,221,128, 99,  0, 62,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_175[] = {  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,240,  0,  0};
static const GLubyte Sans12B_Char_176[] = {  6,  0,  0,  0,  0,  0,  0,  0,  0,  0, 96,144,144, 96,  0,  0};
static const GLubyte Sans12B_Char_177[] = { 10,  0,  0,  0,  0,  0,  0,255,  0,255,  0, 24,  0, 24,  0,255,  0,255,  0, 24,  0, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_178[] = {  6,  0,  0,  0,  0,  0,  0,240, 96, 48, 16,144,224,  0,  0,  0};
static const GLubyte Sans12B_Char_179[] = {  6,  0,  0,  0,  0,  0,  0,224, 16, 16, 96, 16,240,  0,  0,  0};
static const GLubyte Sans12B_Char_180[] = {  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,192, 96,  0,  0};
static const GLubyte Sans12B_Char_181[] = { 10,192,  0,192,  0,192,  0,255,  0,198,  0,198,  0,198,  0,198,  0,198,  0,198,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_182[] = {  8,  0,  0, 20, 20, 20, 20, 20,116,244,244,244,124,  0,  0,  0};
static const GLubyte Sans12B_Char_183[] = {  4,  0,  0,  0,  0,  0,  0,  0,192,192,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_184[] = {  5,224, 32, 32,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_185[] = {  5,  0,  0,  0,  0,  0,  0,224, 64, 64, 64, 64,192,  0,  0,  0};
static const GLubyte Sans12B_Char_186[] = {  8,  0,  0,  0,  0,  0,252,  0,120,204,204,204,120,  0,  0,  0};
static const GLubyte Sans12B_Char_187[] = {  8,  0,  0,  0,  0,144,216,108,108,216,144,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_188[] = { 14,  0,  0,  0,  0,  0,  0, 16, 32, 25,240,  9, 32,228,160, 70,224, 66, 96, 65,  0, 64,128,192,192,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_189[] = { 14,  0,  0,  0,  0,  0,  0, 16,240, 24, 96,  8, 48,228, 16, 70,144, 66, 96, 65,  0, 64,128,192,128,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_190[] = { 14,  0,  0,  0,  0,  0,  0, 24, 32,  9,240,  5, 32,230,160, 18,224, 17, 96, 97,  0, 16,128,240, 64,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_191[] = {  8,  0,  0,  0,120,196,192, 96, 48, 24,  0, 24, 24,  0,  0,  0};
static const GLubyte Sans12B_Char_192[] = { 12,  0,  0,  0,  0,  0,  0,192,192, 97,128,127,128, 97,128, 51,  0, 51,  0, 30,  0, 30,  0, 12,  0,  0,  0, 12,  0, 24,  0};
static const GLubyte Sans12B_Char_193[] = { 12,  0,  0,  0,  0,  0,  0,192,192, 97,128,127,128, 97,128, 51,  0, 51,  0, 30,  0, 30,  0, 12,  0,  0,  0, 12,  0,  6,  0};
static const GLubyte Sans12B_Char_194[] = { 12,  0,  0,  0,  0,  0,  0,192,192, 97,128,127,128, 97,128, 51,  0, 51,  0, 30,  0, 30,  0, 12,  0,  0,  0, 27,  0, 14,  0};
static const GLubyte Sans12B_Char_195[] = { 12,  0,  0,  0,  0,  0,  0,192,192, 97,128,127,128, 97,128, 51,  0, 51,  0, 30,  0, 30,  0, 12,  0,  0,  0, 22,  0, 26,  0};
static const GLubyte Sans12B_Char_196[] = { 12,  0,  0,  0,  0,  0,  0,192,192, 97,128,127,128, 97,128, 51,  0, 51,  0, 30,  0, 30,  0, 12,  0,  0,  0, 27,  0, 27,  0};
static const GLubyte Sans12B_Char_197[] = { 12,  0,  0,  0,  0,  0,  0,192,192, 97,128,127,128, 97,128, 51,  0, 51,  0, 30,  0, 30,  0, 12,  0, 18,  0, 18,  0, 12,  0};
static const GLubyte Sans12B_Char_198[] = { 15,  0,  0,  0,  0,  0,  0,195,248, 99,  0, 99,  0,127,  0, 51,248, 51,  0, 27,  0, 27,  0, 31,248,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_199[] = { 10, 28,  0,  4,  0,  4,  0, 63,  0, 97,  0,192,  0,192,  0,192,  0,192,  0,192,  0, 97,  0, 63,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_200[] = {  9,  0,  0,  0,  0,  0,  0,254,  0,192,  0,192,  0,192,  0,254,  0,192,  0,192,  0,192,  0,254,  0,  0,  0, 48,  0, 96,  0};
static const GLubyte Sans12B_Char_201[] = {  9,  0,  0,  0,  0,  0,  0,254,  0,192,  0,192,  0,192,  0,254,  0,192,  0,192,  0,192,  0,254,  0,  0,  0, 48,  0, 24,  0};
static const GLubyte Sans12B_Char_202[] = {  9,  0,  0,  0,  0,  0,  0,254,  0,192,  0,192,  0,192,  0,254,  0,192,  0,192,  0,192,  0,254,  0,  0,  0,108,  0, 56,  0};
static const GLubyte Sans12B_Char_203[] = {  9,  0,  0,  0,  0,  0,  0,254,  0,192,  0,192,  0,192,  0,254,  0,192,  0,192,  0,192,  0,254,  0,  0,  0,108,  0,108,  0};
static const GLubyte Sans12B_Char_204[] = {  5,  0,  0,  0, 96, 96, 96, 96, 96, 96, 96, 96, 96,  0, 96,192};
static const GLubyte Sans12B_Char_205[] = {  5,  0,  0,  0,192,192,192,192,192,192,192,192,192,  0,192, 96};
static const GLubyte Sans12B_Char_206[] = {  7,  0,  0,  0, 96, 96, 96, 96, 96, 96, 96, 96, 96,  0,216,112};
static const GLubyte Sans12B_Char_207[] = {  7,  0,  0,  0, 96, 96, 96, 96, 96, 96, 96, 96, 96,  0,216,216};
static const GLubyte Sans12B_Char_208[] = { 12,  0,  0,  0,  0,  0,  0,126,  0, 99,128, 97,192, 96,192,240,192, 96,192, 97,192, 99,128,126,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_209[] = { 11,  0,  0,  0,  0,  0,  0,195,128,195,128,199,128,205,128,201,128,217,128,241,128,225,128,225,128,  0,  0, 44,  0, 52,  0};
static const GLubyte Sans12B_Char_210[] = { 11,  0,  0,  0,  0,  0,  0, 62,  0, 99,  0,193,128,193,128,193,128,193,128,193,128, 99,  0, 62,  0,  0,  0, 24,  0, 48,  0};
static const GLubyte Sans12B_Char_211[] = { 11,  0,  0,  0,  0,  0,  0, 62,  0, 99,  0,193,128,193,128,193,128,193,128,193,128, 99,  0, 62,  0,  0,  0, 24,  0, 12,  0};
static const GLubyte Sans12B_Char_212[] = { 11,  0,  0,  0,  0,  0,  0, 62,  0, 99,  0,193,128,193,128,193,128,193,128,193,128, 99,  0, 62,  0,  0,  0, 54,  0, 28,  0};
static const GLubyte Sans12B_Char_213[] = { 11,  0,  0,  0,  0,  0,  0, 62,  0, 99,  0,193,128,193,128,193,128,193,128,193,128, 99,  0, 62,  0,  0,  0, 44,  0, 52,  0};
static const GLubyte Sans12B_Char_214[] = { 11,  0,  0,  0,  0,  0,  0, 62,  0, 99,  0,193,128,193,128,193,128,193,128,193,128, 99,  0, 62,  0,  0,  0, 54,  0, 54,  0};
static const GLubyte Sans12B_Char_215[] = { 10,  0,  0,  0,  0,  0,  0, 66,  0,231,  0,126,  0, 60,  0, 60,  0,126,  0,231,  0, 66,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_216[] = { 11,  0,  0,  0,  0,  0,  0,190,  0, 99,  0,225,128,209,128,201,128,197,128,195,128, 99,  0, 62,128,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_217[] = { 10,  0,  0,  0,  0,  0,  0,126,  0,195,  0,195,  0,195,  0,195,  0,195,  0,195,  0,195,  0,195,  0,  0,  0, 24,  0, 48,  0};
static const GLubyte Sans12B_Char_218[] = { 10,  0,  0,  0,  0,  0,  0,126,  0,195,  0,195,  0,195,  0,195,  0,195,  0,195,  0,195,  0,195,  0,  0,  0, 24,  0, 12,  0};
static const GLubyte Sans12B_Char_219[] = { 10,  0,  0,  0,  0,  0,  0,126,  0,195,  0,195,  0,195,  0,195,  0,195,  0,195,  0,195,  0,195,  0,  0,  0, 54,  0, 28,  0};
static const GLubyte Sans12B_Char_220[] = { 10,  0,  0,  0,  0,  0,  0,126,  0,195,  0,195,  0,195,  0,195,  0,195,  0,195,  0,195,  0,195,  0,  0,  0, 54,  0, 54,  0};
static const GLubyte Sans12B_Char_221[] = { 12,  0,  0,  0,  0,  0,  0, 12,  0, 12,  0, 12,  0, 12,  0, 30,  0, 30,  0, 51,  0, 97,128,225,192,  0,  0, 24,  0, 12,  0};
static const GLubyte Sans12B_Char_222[] = { 10,  0,  0,  0,  0,  0,  0,192,  0,192,  0,254,  0,199,  0,195,  0,195,  0,199,  0,254,  0,192,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_223[] = { 10,  0,  0,  0,  0,  0,  0,222,  0,195,  0,199,  0,207,  0,220,  0,216,  0,216,  0,198,  0,198,  0,124,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_224[] = {  9,  0,  0,  0,  0,  0,  0,126,  0,198,  0,198,  0,126,  0,  6,  0, 70,  0, 60,  0,  0,  0, 24,  0, 48,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_225[] = {  9,  0,  0,  0,  0,  0,  0,126,  0,198,  0,198,  0,126,  0,  6,  0, 70,  0, 60,  0,  0,  0, 48,  0, 24,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_226[] = {  9,  0,  0,  0,  0,  0,  0,126,  0,198,  0,198,  0,126,  0,  6,  0, 70,  0, 60,  0,  0,  0,108,  0, 56,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_227[] = {  9,  0,  0,  0,  0,  0,  0,126,  0,198,  0,198,  0,126,  0,  6,  0, 70,  0, 60,  0,  0,  0, 88,  0,104,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_228[] = {  9,  0,  0,  0,  0,  0,  0,126,  0,198,  0,198,  0,126,  0,  6,  0, 70,  0, 60,  0,  0,  0,108,  0,108,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_229[] = {  9,  0,  0,  0,  0,  0,  0,126,  0,198,  0,198,  0,126,  0,  6,  0, 70,  0, 60,  0,  0,  0, 48,  0, 72,  0, 72,  0, 48,  0};
static const GLubyte Sans12B_Char_230[] = { 15,  0,  0,  0,  0,  0,  0,123,240,207,  8,198,  0,127,248,  6, 24, 71, 48, 61,224,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_231[] = {  8, 56,  8,  8, 56,100,192,192,192,100, 56,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_232[] = {  9,  0,  0,  0,  0,  0,  0, 60,  0, 98,  0,192,  0,254,  0,198,  0,100,  0, 60,  0,  0,  0, 24,  0, 48,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_233[] = {  9,  0,  0,  0,  0,  0,  0, 60,  0, 98,  0,192,  0,254,  0,198,  0,100,  0, 60,  0,  0,  0, 48,  0, 24,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_234[] = {  9,  0,  0,  0,  0,  0,  0, 60,  0, 98,  0,192,  0,254,  0,198,  0,100,  0, 60,  0,  0,  0,108,  0, 56,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_235[] = {  9,  0,  0,  0,  0,  0,  0, 60,  0, 98,  0,192,  0,254,  0,198,  0,100,  0, 60,  0,  0,  0,108,  0,108,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_236[] = {  5,  0,  0,  0,192,192,192,192,192,192,192,  0, 96,192,  0,  0};
static const GLubyte Sans12B_Char_237[] = {  5,  0,  0,  0,192,192,192,192,192,192,192,  0,192, 96,  0,  0};
static const GLubyte Sans12B_Char_238[] = {  7,  0,  0,  0, 96, 96, 96, 96, 96, 96, 96,  0,216,112,  0,  0};
static const GLubyte Sans12B_Char_239[] = {  7,  0,  0,  0, 96, 96, 96, 96, 96, 96, 96,  0,216,216,  0,  0};
static const GLubyte Sans12B_Char_240[] = { 10,  0,  0,  0,  0,  0,  0, 60,  0,102,  0,195,  0,195,  0,195,  0,227,  0, 62,  0,  6,  0, 28,  0, 62,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_241[] = {  9,  0,  0,  0,  0,  0,  0,198,  0,198,  0,198,  0,198,  0,198,  0,230,  0,220,  0,  0,  0, 44,  0, 52,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_242[] = {  9,  0,  0,  0,  0,  0,  0,124,  0,198,  0,198,  0,198,  0,198,  0,198,  0,124,  0,  0,  0, 24,  0, 48,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_243[] = {  9,  0,  0,  0,  0,  0,  0,124,  0,198,  0,198,  0,198,  0,198,  0,198,  0,124,  0,  0,  0, 48,  0, 24,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_244[] = {  9,  0,  0,  0,  0,  0,  0,124,  0,198,  0,198,  0,198,  0,198,  0,198,  0,124,  0,  0,  0,108,  0, 56,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_245[] = {  9,  0,  0,  0,  0,  0,  0,124,  0,198,  0,198,  0,198,  0,198,  0,198,  0,124,  0,  0,  0, 88,  0,104,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_246[] = {  9,  0,  0,  0,  0,  0,  0,124,  0,198,  0,198,  0,198,  0,198,  0,198,  0,124,  0,  0,  0,108,  0,108,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_247[] = { 10,  0,  0,  0,  0,  0,  0, 24,  0, 24,  0,  0,  0,255,  0,255,  0,  0,  0, 24,  0, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_248[] = {  9,  0,  0,  0,  0,  0,  0,184,  0, 68,  0,230,  0,214,  0,206,  0, 68,  0, 58,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_249[] = {  9,  0,  0,  0,  0,  0,  0,118,  0,206,  0,198,  0,198,  0,198,  0,198,  0,198,  0,  0,  0, 12,  0, 24,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_250[] = {  9,  0,  0,  0,  0,  0,  0,118,  0,206,  0,198,  0,198,  0,198,  0,198,  0,198,  0,  0,  0, 24,  0, 12,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_251[] = {  9,  0,  0,  0,  0,  0,  0,118,  0,206,  0,198,  0,198,  0,198,  0,198,  0,198,  0,  0,  0, 54,  0, 28,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_252[] = {  9,  0,  0,  0,  0,  0,  0,118,  0,206,  0,198,  0,198,  0,198,  0,198,  0,198,  0,  0,  0, 54,  0, 54,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_253[] = { 10,112,  0, 24,  0, 24,  0, 24,  0, 60,  0, 52,  0,102,  0,102,  0,195,  0,195,  0,  0,  0, 24,  0, 12,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_254[] = { 10,192,  0,192,  0,192,  0,220,  0,230,  0,195,  0,195,  0,195,  0,230,  0,220,  0,192,  0,192,  0,192,  0,  0,  0,  0,  0};
static const GLubyte Sans12B_Char_255[] = { 10,112,  0, 24,  0, 24,  0, 24,  0, 60,  0, 52,  0,102,  0,102,  0,195,  0,195,  0,  0,  0, 54,  0, 54,  0,  0,  0,  0,  0};

static const GLubyte *Sans12B_Char_Map[] = {
	Sans12B_Char_063, Sans12B_Char_063, Sans12B_Char_063, Sans12B_Char_063,
	Sans12B_Char_063, Sans12B_Char_063, Sans12B_Char_063, Sans12B_Char_063,
	Sans12B_Char_063, Sans12B_Char_063, Sans12B_Char_063, Sans12B_Char_063,
	Sans12B_Char_063, Sans12B_Char_063, Sans12B_Char_063, Sans12B_Char_063,
	Sans12B_Char_063, Sans12B_Char_063, Sans12B_Char_063, Sans12B_Char_063,
	Sans12B_Char_063, Sans12B_Char_063, Sans12B_Char_063, Sans12B_Char_063,
	Sans12B_Char_063, Sans12B_Char_063, Sans12B_Char_063, Sans12B_Char_063,
	Sans12B_Char_063, Sans12B_Char_063, Sans12B_Char_063, Sans12B_Char_032,
	Sans12B_Char_033, Sans12B_Char_034, Sans12B_Char_035, Sans12B_Char_036,
	Sans12B_Char_037, Sans12B_Char_038, Sans12B_Char_039, Sans12B_Char_040,
	Sans12B_Char_041, Sans12B_Char_042, Sans12B_Char_043, Sans12B_Char_044,
	Sans12B_Char_045, Sans12B_Char_046, Sans12B_Char_047, Sans12B_Char_048,
	Sans12B_Char_049, Sans12B_Char_050, Sans12B_Char_051, Sans12B_Char_052,
	Sans12B_Char_053, Sans12B_Char_054, Sans12B_Char_055, Sans12B_Char_056,
	Sans12B_Char_057, Sans12B_Char_058, Sans12B_Char_059, Sans12B_Char_060,
	Sans12B_Char_061, Sans12B_Char_062, Sans12B_Char_063, Sans12B_Char_064,
	Sans12B_Char_065, Sans12B_Char_066, Sans12B_Char_067, Sans12B_Char_068,
	Sans12B_Char_069, Sans12B_Char_070, Sans12B_Char_071, Sans12B_Char_072,
	Sans12B_Char_073, Sans12B_Char_074, Sans12B_Char_075, Sans12B_Char_076,
	Sans12B_Char_077, Sans12B_Char_078, Sans12B_Char_079, Sans12B_Char_080,
	Sans12B_Char_081, Sans12B_Char_082, Sans12B_Char_083, Sans12B_Char_084,
	Sans12B_Char_085, Sans12B_Char_086, Sans12B_Char_087, Sans12B_Char_088,
	Sans12B_Char_089, Sans12B_Char_090, Sans12B_Char_091, Sans12B_Char_092,
	Sans12B_Char_093, Sans12B_Char_094, Sans12B_Char_095, Sans12B_Char_096,
	Sans12B_Char_097, Sans12B_Char_098, Sans12B_Char_099, Sans12B_Char_100,
	Sans12B_Char_101, Sans12B_Char_102, Sans12B_Char_103, Sans12B_Char_104,
	Sans12B_Char_105, Sans12B_Char_106, Sans12B_Char_107, Sans12B_Char_108,
	Sans12B_Char_109, Sans12B_Char_110, Sans12B_Char_111, Sans12B_Char_112,
	Sans12B_Char_113, Sans12B_Char_114, Sans12B_Char_115, Sans12B_Char_116,
	Sans12B_Char_117, Sans12B_Char_118, Sans12B_Char_119, Sans12B_Char_120,
	Sans12B_Char_121, Sans12B_Char_122, Sans12B_Char_123, Sans12B_Char_124,
	Sans12B_Char_125, Sans12B_Char_126, Sans12B_Char_063, Sans12B_Char_128,
	Sans12B_Char_129, Sans12B_Char_130, Sans12B_Char_131, Sans12B_Char_132,
	Sans12B_Char_133, Sans12B_Char_134, Sans12B_Char_135, Sans12B_Char_136,
	Sans12B_Char_137, Sans12B_Char_138, Sans12B_Char_139, Sans12B_Char_140,
	Sans12B_Char_141, Sans12B_Char_142, Sans12B_Char_143, Sans12B_Char_144,
	Sans12B_Char_145, Sans12B_Char_146, Sans12B_Char_147, Sans12B_Char_148,
	Sans12B_Char_149, Sans12B_Char_150, Sans12B_Char_151, Sans12B_Char_152,
	Sans12B_Char_153, Sans12B_Char_154, Sans12B_Char_155, Sans12B_Char_156,
	Sans12B_Char_157, Sans12B_Char_158, Sans12B_Char_159, Sans12B_Char_160,
	Sans12B_Char_161, Sans12B_Char_162, Sans12B_Char_163, Sans12B_Char_164,
	Sans12B_Char_165, Sans12B_Char_166, Sans12B_Char_167, Sans12B_Char_168,
	Sans12B_Char_169, Sans12B_Char_170, Sans12B_Char_171, Sans12B_Char_172,
	Sans12B_Char_173, Sans12B_Char_174, Sans12B_Char_175, Sans12B_Char_176,
	Sans12B_Char_177, Sans12B_Char_178, Sans12B_Char_179, Sans12B_Char_180,
	Sans12B_Char_181, Sans12B_Char_182, Sans12B_Char_183, Sans12B_Char_184,
	Sans12B_Char_185, Sans12B_Char_186, Sans12B_Char_187, Sans12B_Char_188,
	Sans12B_Char_189, Sans12B_Char_190, Sans12B_Char_191, Sans12B_Char_192,
	Sans12B_Char_193, Sans12B_Char_194, Sans12B_Char_195, Sans12B_Char_196,
	Sans12B_Char_197, Sans12B_Char_198, Sans12B_Char_199, Sans12B_Char_200,
	Sans12B_Char_201, Sans12B_Char_202, Sans12B_Char_203, Sans12B_Char_204,
	Sans12B_Char_205, Sans12B_Char_206, Sans12B_Char_207, Sans12B_Char_208,
	Sans12B_Char_209, Sans12B_Char_210, Sans12B_Char_211, Sans12B_Char_212,
	Sans12B_Char_213, Sans12B_Char_214, Sans12B_Char_215, Sans12B_Char_216,
	Sans12B_Char_217, Sans12B_Char_218, Sans12B_Char_219, Sans12B_Char_220,
	Sans12B_Char_221, Sans12B_Char_222, Sans12B_Char_223, Sans12B_Char_224,
	Sans12B_Char_225, Sans12B_Char_226, Sans12B_Char_227, Sans12B_Char_228,
	Sans12B_Char_229, Sans12B_Char_230, Sans12B_Char_231, Sans12B_Char_232,
	Sans12B_Char_233, Sans12B_Char_234, Sans12B_Char_235, Sans12B_Char_236,
	Sans12B_Char_237, Sans12B_Char_238, Sans12B_Char_239, Sans12B_Char_240,
	Sans12B_Char_241, Sans12B_Char_242, Sans12B_Char_243, Sans12B_Char_244,
	Sans12B_Char_245, Sans12B_Char_246, Sans12B_Char_247, Sans12B_Char_248,
	Sans12B_Char_249, Sans12B_Char_250, Sans12B_Char_251, Sans12B_Char_252,
	Sans12B_Char_253, Sans12B_Char_254, Sans12B_Char_255, 0};

const SFG_Font fgFontSans12B = {"-*-bitstream vera sans-bold-r-*-*-*-120-75-75-*-*-iso8859-1", 223, 15, Sans12B_Char_Map, 0.0f, 0.0f};

static fntBitmapFont fntSans12B(fgFontSans12B.Characters, 1,
		fgFontSans12B.Height, fgFontSans12B.xorig, fgFontSans12B.yorig);


puFont FONT_HELVETICA_14(&fntHelvetica14, 14, 0);
puFont FONT_SANS_12B(&fntSans12B, 12, 0);

