/* $Header: /home/yav/catty/fkiss/RCS/color.c,v 1.8 2000/09/28 07:50:29 yav Exp $
 * fkiss color management
 * written by yav <yav@bigfoot.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <stdio.h>

#include "config.h"

#include "headers.h"
#include "fkiss.h"
#include "work.h"
#define PUBLIC_COLOR_C
#include "extern.h"


char id_color[] = "$Id: color.c,v 1.8 2000/09/28 07:50:29 yav Exp $";
static int loaded_colfcnt;	/* loaded color file count */

int read_color_file(fp, p)
     FILE *fp;
     COLOR *p;
{
  int i, n;
  int preload;
  KISSCOLOR *kc;
  unsigned char buf[1024];
  
  /* read color file */
  i = 4;			/* max(4, strlen(kiss_magic_number)) */
  if (!fread(buf, i, 1, fp))
    return 1;
  buf[i] = '\0';
  if (strcmp(buf, kiss_magic_number) == 0) {
    if (!fread(buf+i, PAL_HEADER_SIZE-i, 1, fp))
      return 1;
    if (buf[PAL_MARK] != 0x10)
      return 1;
    p->bpc = buf[PAL_BPC];
    p->cpg = GET_SHORT(buf+PAL_CPPG);
    p->pg = GET_SHORT(buf+PAL_PG);
    preload = 0;
  } else {
    p->bpc = 12;
    p->cpg = 16;
    p->pg = 10;
    preload = i;
  }
  debug_printf("%s :\n\tbits/color:%d, colors/palette:%d, pages:%2d, preload:%d,",
	       p->filename, p->bpc, p->cpg, p->pg, preload);
  if (!loaded_colfcnt)
    colindex = (short *)ks_malloc(sizeof(short));
  else
    colindex = (short *)ks_realloc(colindex, sizeof(short)*(loaded_colfcnt+1));
  *(colindex+loaded_colfcnt) = colcnt - !!colcnt;
  loaded_colfcnt++;

  for (i = 0; i < MAXPAL; i++) {
    kcol[i] = (KISSCOLOR *)ks_realloc(kcol[i],
				      sizeof(KISSCOLOR)*(colcnt + p->cpg - !!colcnt));
  }
  
  for (n = 0; n < p->pg; n++) {
    i = ((p->bpc+7)>>3) * p->cpg;	/* bytes per group */
    if (!fread(buf+preload, i-preload, 1, fp))
      break;
    preload = 0;
    kc = kcol[n]+colcnt;
    debug_printf("\npg%3d:", n);
    for (i = !!colcnt; i < p->cpg; i++) {
      if (p->bpc == 12) {
	kc->b = (buf[i*2] & 15) * 0x11;
	kc->r = (buf[i*2] >> 4) * 0x11;
	kc->g = (buf[i*2+1] & 15) * 0x11;
      } else {
	kc->r = buf[i*3+0];
	kc->g = buf[i*3+1];
	kc->b = buf[i*3+2];
      }
      if (debug_mode) {
	if ( i % 5 )
	  fprintf(stderr, "\t");
	else
	  fprintf(stderr, "\n\t");
        fprintf(stderr, "%3d:%02x,%02x,%02x;", i, kc->r, kc->g, kc->b);
      }
      kc++;
    }
  }
      if (debug_mode)
	if ( --i % 5 )
	  fprintf(stderr, "\n");
  /* correct real loaded palette group count */
  if (n < p->pg)
    p->pg = n;
  debug_printf("colcnt changed from %d to %d (%d + %d - %d) !\n",
	       colcnt, colcnt + p->cpg - !!colcnt, colcnt, p->cpg, !!colcnt);
  colcnt = colcnt + p->cpg - !!colcnt;
  
  if (palcnt < p->pg) {
    debug_printf("palcnt changed from %d to %d !\n", palcnt, p->pg);
    palcnt = p->pg;
  }
  return 0;
}

int read_colors()
{
  int i, j, r;
  COLOR *p;
  FILE *fp;
  
  for (i = 0; i < MAXPAL; i++) {
    kcol[i] = (KISSCOLOR *)ks_malloc(sizeof(KISSCOLOR));
  }
  
  loaded_colfcnt = 0;
  for (p = kcflist, i = 0; i < colorfilecnt; p++, i++) {
    fp = ks_fopen(p->filename, "rb");
    if (fp == NULL) {
      msg("E color file ``%s'' not found!\n", p->filename);
    } else {
      r = read_color_file(fp, p);
      if (r) {
	msg("E color file ``%s'' read error!\n", p->filename);
      }
      fclose(fp);
    }
  }
  /* fill remaining palette group with group 0 */
  p = kcflist;
  for (i = 0; i < colorfilecnt; i++) {
    for (j = p->pg; j < palcnt; j++) {
      bcopy((char *)(kcol[0]+*(colindex+i)),
	    (char *)(kcol[j]+*(colindex+i)), sizeof(*kcol)*p->cpg);
    }
    p++;
  }
  return 0;
}

int set_private_colorcells(n)
     int n;
{
  XStoreColors(dsp, cmap, xcol[n], colcnt);
  return 0;
}

int alloc_private_colorcells()
{
  int i, pal;
  XColor *p;
  unsigned long plane_masks[1];
  unsigned long *pixels;
  
  pixels = (unsigned long *)ks_malloc(sizeof(unsigned long)*colcnt);
  if (!XAllocColorCells(dsp, cmap, False, plane_masks, 0, pixels, colcnt)) {
    free(pixels);
    return 1;
  }
  debug_printf("get %d private colorcells\n", colcnt);
  for (pal = 0; pal < palcnt; pal++) {
    p = xcol[pal];
    for (i = 0; i < colcnt; p++, i++) {
      p->pixel = pixels[i];
      p->flags = DoRed|DoGreen|DoBlue;
    }
  }
  free(pixels);
  set_private_colorcells(0);
  return 0;
}

void free_alloced_colors(status, npal, ncol)
     char **status;
     int npal;
     int ncol;
{
  int i, j, pal;
  int pixelcount;
  unsigned long *pixels;
  XColor *xp;
  
  pixels = (unsigned long *)ks_malloc(sizeof(*pixels)*npal*ncol);
  pixelcount = 0;
  for (pal = 0; pal < npal; pal++) {
    xp = xcol[pal];
    for (i = 0; i < colcnt; i++) {
      if (*(status[pal]+i)) {
	for (j = 0; j < pixelcount; j++) {
	  if (xp->pixel == *(pixels+j))
	    break;
	}
	if (j == pixelcount) {
	  *(pixels+pixelcount) = xp->pixel;
	  pixelcount++;
	}
      }
      xp++;
    }
  }
  msg("M free all %d colors.\n", pixelcount);
  if (debug_mode)
    for (i = 0; i < pixelcount; i++)
      fprintf(stderr, "free pixel %d %ld\n", i, *(pixels+i));
  XFreeColors(dsp, cmap, pixels, pixelcount, 0);
  free(pixels);
}

#define BRIGHT_G 151	/* 0.59 * 256 */
#define BRIGHT_R  77	/* 0.30 * 256 */
#define BRIGHT_B  28	/* 0.11 * 256 */

/* Convert KISS 8bit RGB to X11 16bit RGB value
 * input: kcol
 * output: xcol
 */
void convert_xcolors()
{
  int i, pal;
  KISSCOLOR *kp;
  XColor *xp;
  
  for (pal = 0; pal < palcnt; pal++) {
    kp = kcol[pal];
    xp = xcol[pal];
    for (i = 0; i < colcnt; i++) {
      if (gray_mode) {
	xp->red = xp->green = xp->blue =
	  ((kp->r*BRIGHT_R + kp->g*BRIGHT_G + kp->b*BRIGHT_B) >> 8) * 0x101;
      } else {
	xp->red   = kp->r * 0x101; /* convert 8bit to 16bit */
	xp->green = kp->g * 0x101;
	xp->blue  = kp->b * 0x101;
      }
      kp++;
      xp++;
    }
  }
}

/* reduce color level R:16 G:16 B:8 */
void reduce_color_level()
{
  int i, pal;
  KISSCOLOR *kp;
  XColor *xp;
  
  for (pal = 0; pal < palcnt; pal++) {
    kp = kcol[pal];
    xp = xcol[pal];
    for (i = 0; i < colcnt; i++) {
      xp->red   = (kp->r / (255/16)) * (255/16) * 0x101;
      xp->green = (kp->g / (255/16)) * (255/16) * 0x101;
      xp->blue  = (kp->b / (255/8)) * (255/8) * 0x101;
      kp++;
      xp++;
    }
  }
}

int get_near_color(xp, xp0, cells)
     XColor *xp;		/* need color */
     XColor *xp0;		/* Colormap */
     int cells;			/* number of colorcells */
{
  int i;
  int near_color;
  double r0, g0, b0, r, g, b, d, d0;
  
  near_color = 0;
  d0 = 1.0e100;
  r0 = xp->red;
  g0 = xp->green;
  b0 = xp->blue;
  for (i = 0; i < cells; i++) {
    r = (xp0+i)->red - r0;
    g = (xp0+i)->green - g0;
    b = (xp0+i)->blue - b0;
    d = r*r + g*g + b*b;
    if (d < d0) {
      d0 = d;
      near_color = i;
    }
  }
  return near_color;
}

void very_poor_system_pixels(xp0, cells)
     XColor *xp0;
     int cells;
{
  int i, near_color;
  XColor col[SPX_MAX];
  
  XQueryColors(dsp, cmap, xp0, cells);
  parse_system_colors(col);
  for (i = 0; i < SPX_MAX; i++) {
    near_color = get_near_color(&col[i], xp0, cells);
    spx[i] = (xcol[0]+near_color)->pixel;
  }
  set_system_pixels();
}

int alloc_colors()
{
  int i, pal, phase;
  XColor *xp;
  XColor *xp0;
  int cells, missed_color, near_color;
  Bool syscol_free;
  char *status[MAXPAL];
  
  convert_xcolors();
  for (i = 0; i < MAXPAL; i++) {
    status[i] = ks_malloc(colcnt);
    bzero(status[i], colcnt);
  }
  cells = DisplayCells(dsp, scr);
  xp0 = NULL;
  syscol_free = 0;
  for (phase = 0; phase < 10; phase++) {
    missed_color = 0;
    if (private_color_mode) {
      if (alloc_private_colorcells())
	missed_color = colcnt;
    } else {
      for (pal = 0; pal < palcnt; pal++) {
	xp = xcol[pal];
	for (i = 0; i < colcnt; i++) {
	  if (!status[pal][i]) {
	    status[pal][i] = XAllocColor(dsp, cmap, xp);
	    if (!status[pal][i])
	      missed_color++;
	  }
	  xp++;
	}
      }
    }
    if (missed_color == 0)
      break;
    msg("W allocation missed %3d colors in phase %d.\n",
	missed_color, phase);
    if (phase == 0) {
      /* free system colors */
      msg("M free system colors.\n");
      poor_system_pixels();
      /* ready colormap read buffer */
      xp0 = (XColor *)ks_malloc(sizeof(XColor)*cells);
      for (i = 0; i < cells; i++)
	(xp0+i)->pixel = i;
      continue;
    } else if (phase == 1) {
      if (private_colormap_mode) {
	msg("M make a new colormap.\n");
	cmap = XCopyColormapAndFree(dsp, cmap);
	XSetWindowColormap(dsp, topwin, cmap);
      }
      continue;			/* Retry! */
    } else if (phase == 2) {
      if (private_color_mode) {
	free_system_colors();
	syscol_free = True;
      }
      continue;			/* Retry! */
    } else if (phase == 3) {
      if (private_color_mode) {
	poor_system_pixels();
	syscol_free = False;
	msg("M abandon to use private color cells.\n");
	private_color_mode = 0;
      }
      continue;			/* Retry! */
    } else if (phase == 4) {
      /* free all colors */
      free_alloced_colors(status, palcnt, colcnt);
      for (i = 0; i < MAXPAL; i++) {
	bzero(status[i], colcnt);
      }
      msg("W reduce color levels.\n");
      reduce_color_level();
      continue;			/* Retry more! */
    }
    /* change near color */
    XQueryColors(dsp, cmap, xp0, cells);
    for (pal = 0; pal < palcnt; pal++) {
      xp = xcol[pal];
      for (i = 0; i < colcnt; i++) {
	if (!status[pal][i]) {
	  near_color = get_near_color(xp, xp0, cells);
	  msgset("W pal %d color %3d %04x %04x %04x",
		 pal, i, xp->red, xp->green, xp->blue);
	  xp->red = (xp0+near_color)->red;
	  xp->green = (xp0+near_color)->green;
	  xp->blue = (xp0+near_color)->blue;
	  msg(" -> %04x %04x %04x.\n",
		  xp->red, xp->green, xp->blue);
	}
	xp++;
      }
    }
  }
  if (syscol_free)
    very_poor_system_pixels(xp0, cells);
  if (xp0 != NULL)
    free(xp0);
  if (missed_color)
    msg("W give up color allocation.\n");
  for (i = 0; i < MAXPAL; i++) {
    free(status[i]);
  }
  return 0;
}

/* End of file */
