/*******************************************************************************
*	fische - standalone sound visualisation for linux		       *
*	Copyright (C) 2006 Marcel Ebmer					       *
*									       *
*	This program is free software; you can redistribute it and/or	       *
*	modify it under the terms of the GNU General Public License	       *
*	as published by the Free Software Foundation; either version 2	       *
*	of the License, or (at your option) any later version.		       *
*									       *
*	This program is distributed in the hope that it will be useful,	       *
*	but WITHOUT ANY WARRANTY; without even the implied warranty of	       *
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       *
*	GNU General Public License for more details.			       *
*									       *
*	You should have received a copy of the GNU General Public License      *
*	along with this program; if not, write to the Free Software	       *
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 	       *
*	MA  02110-1301, USA.						       *
*******************************************************************************/
#include "fische.h"

int analyse ( char *data, int size ) {

	double average1 = 0.0;
	double average2 = 0.0;
	double average3 = 0.0;
	double energy;
	int retval = 0;
	int i;

	energy = intensity ( data, size );
	for ( i = 0; i < 5; i++ ) {
		average1 += analysis_data.history[i];
	}
	average1 = average1 / 5.0;

	if ( ( energy > average1 ) && ( analysis_data.history[0] < analysis_data.av_1 ) && ( energy > analysis_data.history[0] ) ) retval |= BEAT;

	for ( i = 0; i < 25; i++ ) {
		average2 += analysis_data.history[i];
	}
	average2 = average2 / 25.0;

	if ( ( average1 > average2 ) && ( analysis_data.av_1 < analysis_data.av_2 ) && ( average1 > analysis_data.av_1 ) ) retval |= LINE;

	for ( i = 0; i < 200; i++ ) {
		average3 += analysis_data.history[i];
	}
	average3 = average3 / 200.0;
	
	if ( ( average2 > average3 ) && ( analysis_data.av_2 < analysis_data.av_3 ) && ( average2 > analysis_data.av_2 ) ) retval |= PHASE;
	for ( i = 199; i > 0; i-- ) {
		analysis_data.history[i] = analysis_data.history[i-1];
	}
	analysis_data.history[0] = energy;
	analysis_data.av_1 = average1;
	analysis_data.av_2 = average2;
	analysis_data.av_3 = average3;
	return ( retval );
}

double intensity ( char *data, int size ) {

	int i;
	double value;
	double result = 0.0;
	
	for ( i = 0; i < size; i += 2 ) {
		value = (double)( *( data + i ) + *( data + i + 1 ) * 0x100 ) * 2.0 / 65535.0;
		result += pow ( value, 2 );
	}

	return ( result / size );
}
