<?

	/**
	 * Create the preview image for a theme.
	 */
	function createPreview($dir, $shareddir) {
		// create background from Firefox selection		
		$transbg =
			resizeImage(
				$shareddir.'itemSelected.png', 320, 200);
		$bg = makeOpaque($transbg, 320, 200);

		// add Ubuntu logo to the preview
		$logo = getCustomImage('logo-ubuntu');
		$bglogo = overlay($bg, $logo, 10, 26);
		
		// add theme name
		global $theme;
		$text = ucfirst($theme).' Theme';
		$bglogotext =
			writeText($bglogo, $text, 24, 103, 106);
		
		/**
		 * Add themed icons, start at Y = 126,
		 * variable "preview" will hold completed preview.
		 */
		$y = 126;

		$back = getPngFilenameFor(ACTIONS, 'back', 48);
		$preview = overlay($bglogotext, $back, 10, $y);
	
		$forward =
			getPngFilenameFor(ACTIONS, 'forward', 48);
		$preview = overlay($preview, $forward, 50, $y);

		$refresh =
			getPngFilenameFor(ACTIONS, 'view-refresh', 48);
		$preview = overlay($preview, $refresh, 96, $y);
		
		$home = getPngFilenameFor(ACTIONS, 'go-home', 48);
		$preview = overlay($preview, $home, 150, $y);
		
		$print =
			getPngFilenameFor(
				ACTIONS, 'document-print', 48);
		$preview = overlay($preview, $print, 206, $y);
		
		$folder = getPngFilenameFor(PLACES, 'folder', 48);
		$preview = overlay($preview, $folder, 262, $y);

		copy($preview, $dir.'preview.png');
	}

?>