#!/bin/sh
#
#	fhist - file history and comparison tools
#	Copyright (C) 2005 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the fmerge no identical conflict functionality
#

work=/tmp/$$
PAGER=cat
export PAGER
LINES=24
export LINES
COLS=80
export COLS

no_result()
{
	set +x
	echo 'NO RESULT test of the fmerge no identical conflict functionality' 1>&2
	cd $here
	rm -rf $work
	exit 2
}
fail()
{
	set +x
	echo 'FAILED test of the fmerge no identical conflict functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	echo PASSED 1>&2
	cd $here
	rm -rf $work
	exit 0
}
trap "fail" 1 2 3 15

#
# use the built-in error messages
#
FHIST_MESSAGE_LIBRARY=$work/no-such-dir
export FHIST_MESSAGE_LIBRARY
unset LANG
unset LANGUAGE

here=`pwd`
if test $? -ne 0 ; then exit 2; fi
mkdir $work
if test $? -ne 0 ; then exit 2; fi
cd $work
test $? -eq 0 || no_result

if [ "$1" != "" ]; then bin=$here/$1/bin; else bin=$here/bin; fi

#
# test the fmerge no identical conflict functionality
#
cat > fileO << 'fubar'
one
two
three
four
five
fubar
test $? -eq 0 || no_result

cat > fileA << 'fubar'
one
two
four
five
fubar
test $? -eq 0 || no_result

cat > fileB << 'fubar'
one
two
four
five
fubar
test $? -eq 0 || no_result

cat > test.ok << 'fubar'
one
two
four
five
fubar
test $? -eq 0 || no_result

$bin/fmerge --iic fileO fileA fileB > test.out
test $? -eq 0 || fail

diff test.ok test.out
test $? -eq 0 || fail

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
