// This code conforms with the UFC specification version 2.0.0
// and was automatically generated by FFC version 0.9.9.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: True
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      10
//   log_prefix:                     ''
//   optimize:                       False
//   output_dir:                     '.'
//   precision:                      '8'
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False

#ifndef __MASS_H
#define __MASS_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class mass_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  mass_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~mass_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 3)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 20;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    *values = 0.00000000;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.02886751, 0.01304101, 0.00752923, 0.00532397, 0.01829813, 0.01417367, 0.01157275, 0.00818317, 0.00668153, 0.00472456, -0.02834734, -0.02395787, -0.02074813, -0.01855769, -0.01607143, -0.01312227, -0.01071429, -0.00927884, -0.00757614, -0.00535714};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.02886751, -0.01304101, 0.00752923, 0.00532397, 0.01829813, -0.01417367, -0.01157275, 0.00818317, 0.00668153, 0.00472456, 0.02834734, -0.02395787, -0.02074813, 0.01855769, 0.01607143, 0.01312227, -0.01071429, -0.00927884, -0.00757614, -0.00535714};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.02886751, 0.00000000, -0.01505847, 0.00532397, 0.00000000, 0.00000000, 0.00000000, 0.02454951, -0.01336306, 0.00472456, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.04285714, -0.02783653, 0.01515229, -0.00535714};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.02886751, 0.00000000, 0.00000000, -0.01597191, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02834734, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.05357143};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, 0.00000000, 0.11293849, -0.06388766, 0.00000000, 0.00000000, 0.00000000, 0.07364854, 0.02672612, -0.02362278, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.06495191, -0.06060915, 0.02678571};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, 0.00000000, -0.02258770, 0.12777531, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.06681531, 0.04724556, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.07576144, -0.05357143};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, 0.09780760, -0.05646924, -0.06388766, 0.05489438, -0.04252100, 0.02314550, 0.02454951, -0.01336306, -0.02362278, 0.00000000, 0.00000000, 0.04841229, 0.00000000, -0.03750000, -0.05248907, 0.00000000, 0.02165064, 0.03030458, 0.02678571};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, -0.01956152, 0.01129385, 0.12777531, 0.00000000, 0.00000000, 0.05786376, 0.00000000, -0.03340766, 0.04724556, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.06561133, 0.00000000, 0.00000000, -0.03788072, -0.05357143};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, 0.09780760, -0.07905694, -0.03194383, 0.05489438, 0.01417367, -0.04629100, -0.02454951, 0.01336306, 0.02362278, 0.00000000, 0.04791574, -0.00691604, -0.06185896, -0.01607143, 0.00874818, 0.04285714, 0.01546474, 0.00000000, -0.00535714};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, -0.01956152, 0.12423234, -0.03194383, 0.00000000, 0.05669467, -0.01157275, 0.02454951, -0.04677072, 0.02362278, 0.00000000, 0.00000000, 0.00000000, 0.06185896, -0.02142857, 0.00437409, -0.06428571, 0.00927884, 0.00757614, -0.00535714};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, -0.09780760, -0.05646924, -0.06388766, 0.05489438, 0.04252100, -0.02314550, 0.02454951, -0.01336306, -0.02362278, 0.00000000, 0.00000000, 0.04841229, 0.00000000, 0.03750000, 0.05248907, 0.00000000, 0.02165064, 0.03030458, 0.02678571};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, 0.01956152, 0.01129385, 0.12777531, 0.00000000, 0.00000000, -0.05786376, 0.00000000, -0.03340766, 0.04724556, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.06561133, 0.00000000, 0.00000000, -0.03788072, -0.05357143};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, -0.09780760, -0.07905694, -0.03194383, 0.05489438, -0.01417367, 0.04629100, -0.02454951, 0.01336306, 0.02362278, 0.00000000, 0.04791574, -0.00691604, 0.06185896, 0.01607143, -0.00874818, 0.04285714, 0.01546474, 0.00000000, -0.00535714};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, 0.01956152, 0.12423234, -0.03194383, 0.00000000, -0.05669467, 0.01157275, 0.02454951, -0.04677072, 0.02362278, 0.00000000, 0.00000000, 0.00000000, -0.06185896, 0.02142857, -0.00437409, -0.06428571, 0.00927884, 0.00757614, -0.00535714};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, -0.11736912, -0.04517540, -0.03194383, -0.01829813, 0.04252100, 0.03471825, 0.04091585, 0.03340766, 0.02362278, 0.08504201, 0.02395787, 0.02074813, -0.00618590, -0.00535714, -0.00437409, -0.01071429, -0.00927884, -0.00757614, -0.00535714};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, 0.11736912, -0.04517540, -0.03194383, -0.01829813, -0.04252100, -0.03471825, 0.04091585, 0.03340766, 0.02362278, -0.08504201, 0.02395787, 0.02074813, 0.00618590, 0.00535714, 0.00437409, -0.01071429, -0.00927884, -0.00757614, -0.00535714};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.25980762, 0.11736912, 0.06776309, 0.04791574, 0.00000000, 0.08504201, 0.06943651, -0.07364854, 0.04008919, -0.09921567, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.07500000, -0.02624453, 0.00000000, -0.06495191, -0.01515229, 0.02678571};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.25980762, -0.11736912, 0.06776309, 0.04791574, 0.00000000, -0.08504201, -0.06943651, -0.07364854, 0.04008919, -0.09921567, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.07500000, 0.02624453, 0.00000000, -0.06495191, -0.01515229, 0.02678571};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.25980762, 0.00000000, -0.13552619, 0.04791574, -0.10978876, 0.00000000, 0.00000000, 0.02454951, -0.08017837, -0.09921567, 0.00000000, 0.00000000, -0.09682458, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02165064, 0.03030458, 0.02678571};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.25980762, 0.00000000, 0.00000000, -0.14374723, -0.10978876, 0.00000000, 0.00000000, -0.12274756, 0.00000000, 0.04252100, 0.00000000, -0.09583148, 0.01383208, 0.00000000, 0.00000000, 0.00000000, 0.04285714, 0.01546474, 0.00000000, -0.00535714};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.00000000;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 20; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.00000000;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.02886751, 0.01304101, 0.00752923, 0.00532397, 0.01829813, 0.01417367, 0.01157275, 0.00818317, 0.00668153, 0.00472456, -0.02834734, -0.02395787, -0.02074813, -0.01855769, -0.01607143, -0.01312227, -0.01071429, -0.00927884, -0.00757614, -0.00535714};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.02886751, -0.01304101, 0.00752923, 0.00532397, 0.01829813, -0.01417367, -0.01157275, 0.00818317, 0.00668153, 0.00472456, 0.02834734, -0.02395787, -0.02074813, 0.01855769, 0.01607143, 0.01312227, -0.01071429, -0.00927884, -0.00757614, -0.00535714};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.02886751, 0.00000000, -0.01505847, 0.00532397, 0.00000000, 0.00000000, 0.00000000, 0.02454951, -0.01336306, 0.00472456, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.04285714, -0.02783653, 0.01515229, -0.00535714};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.02886751, 0.00000000, 0.00000000, -0.01597191, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02834734, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.05357143};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, 0.00000000, 0.11293849, -0.06388766, 0.00000000, 0.00000000, 0.00000000, 0.07364854, 0.02672612, -0.02362278, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.06495191, -0.06060915, 0.02678571};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, 0.00000000, -0.02258770, 0.12777531, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.06681531, 0.04724556, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.07576144, -0.05357143};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, 0.09780760, -0.05646924, -0.06388766, 0.05489438, -0.04252100, 0.02314550, 0.02454951, -0.01336306, -0.02362278, 0.00000000, 0.00000000, 0.04841229, 0.00000000, -0.03750000, -0.05248907, 0.00000000, 0.02165064, 0.03030458, 0.02678571};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, -0.01956152, 0.01129385, 0.12777531, 0.00000000, 0.00000000, 0.05786376, 0.00000000, -0.03340766, 0.04724556, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.06561133, 0.00000000, 0.00000000, -0.03788072, -0.05357143};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, 0.09780760, -0.07905694, -0.03194383, 0.05489438, 0.01417367, -0.04629100, -0.02454951, 0.01336306, 0.02362278, 0.00000000, 0.04791574, -0.00691604, -0.06185896, -0.01607143, 0.00874818, 0.04285714, 0.01546474, 0.00000000, -0.00535714};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, -0.01956152, 0.12423234, -0.03194383, 0.00000000, 0.05669467, -0.01157275, 0.02454951, -0.04677072, 0.02362278, 0.00000000, 0.00000000, 0.00000000, 0.06185896, -0.02142857, 0.00437409, -0.06428571, 0.00927884, 0.00757614, -0.00535714};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, -0.09780760, -0.05646924, -0.06388766, 0.05489438, 0.04252100, -0.02314550, 0.02454951, -0.01336306, -0.02362278, 0.00000000, 0.00000000, 0.04841229, 0.00000000, 0.03750000, 0.05248907, 0.00000000, 0.02165064, 0.03030458, 0.02678571};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, 0.01956152, 0.01129385, 0.12777531, 0.00000000, 0.00000000, -0.05786376, 0.00000000, -0.03340766, 0.04724556, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.06561133, 0.00000000, 0.00000000, -0.03788072, -0.05357143};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, -0.09780760, -0.07905694, -0.03194383, 0.05489438, -0.01417367, 0.04629100, -0.02454951, 0.01336306, 0.02362278, 0.00000000, 0.04791574, -0.00691604, 0.06185896, 0.01607143, -0.00874818, 0.04285714, 0.01546474, 0.00000000, -0.00535714};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, 0.01956152, 0.12423234, -0.03194383, 0.00000000, -0.05669467, 0.01157275, 0.02454951, -0.04677072, 0.02362278, 0.00000000, 0.00000000, 0.00000000, -0.06185896, 0.02142857, -0.00437409, -0.06428571, 0.00927884, 0.00757614, -0.00535714};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, -0.11736912, -0.04517540, -0.03194383, -0.01829813, 0.04252100, 0.03471825, 0.04091585, 0.03340766, 0.02362278, 0.08504201, 0.02395787, 0.02074813, -0.00618590, -0.00535714, -0.00437409, -0.01071429, -0.00927884, -0.00757614, -0.00535714};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.00000000, 0.11736912, -0.04517540, -0.03194383, -0.01829813, -0.04252100, -0.03471825, 0.04091585, 0.03340766, 0.02362278, -0.08504201, 0.02395787, 0.02074813, 0.00618590, 0.00535714, 0.00437409, -0.01071429, -0.00927884, -0.00757614, -0.00535714};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.25980762, 0.11736912, 0.06776309, 0.04791574, 0.00000000, 0.08504201, 0.06943651, -0.07364854, 0.04008919, -0.09921567, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.07500000, -0.02624453, 0.00000000, -0.06495191, -0.01515229, 0.02678571};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.25980762, -0.11736912, 0.06776309, 0.04791574, 0.00000000, -0.08504201, -0.06943651, -0.07364854, 0.04008919, -0.09921567, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.07500000, 0.02624453, 0.00000000, -0.06495191, -0.01515229, 0.02678571};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.25980762, 0.00000000, -0.13552619, 0.04791574, -0.10978876, 0.00000000, 0.00000000, 0.02454951, -0.08017837, -0.09921567, 0.00000000, 0.00000000, -0.09682458, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02165064, 0.03030458, 0.02678571};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 3; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 1; s < 3 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 1; t < 3 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 0; t < 4 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.25980762, 0.00000000, 0.00000000, -0.14374723, -0.10978876, 0.00000000, 0.00000000, -0.12274756, 0.00000000, 0.04252100, 0.00000000, -0.09583148, 0.01383208, 0.00000000, 0.00000000, 0.00000000, 0.04285714, 0.01546474, 0.00000000, -0.00535714};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[20][20] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.00000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 20; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.66666667*x[2][0] + 0.33333333*x[3][0];
      y[1] = 0.66666667*x[2][1] + 0.33333333*x[3][1];
      y[2] = 0.66666667*x[2][2] + 0.33333333*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.33333333*x[2][0] + 0.66666667*x[3][0];
      y[1] = 0.33333333*x[2][1] + 0.66666667*x[3][1];
      y[2] = 0.33333333*x[2][2] + 0.66666667*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.66666667*x[1][0] + 0.33333333*x[3][0];
      y[1] = 0.66666667*x[1][1] + 0.33333333*x[3][1];
      y[2] = 0.66666667*x[1][2] + 0.33333333*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.33333333*x[1][0] + 0.66666667*x[3][0];
      y[1] = 0.33333333*x[1][1] + 0.66666667*x[3][1];
      y[2] = 0.33333333*x[1][2] + 0.66666667*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.66666667*x[1][0] + 0.33333333*x[2][0];
      y[1] = 0.66666667*x[1][1] + 0.33333333*x[2][1];
      y[2] = 0.66666667*x[1][2] + 0.33333333*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.33333333*x[1][0] + 0.66666667*x[2][0];
      y[1] = 0.33333333*x[1][1] + 0.66666667*x[2][1];
      y[2] = 0.33333333*x[1][2] + 0.66666667*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.66666667*x[0][0] + 0.33333333*x[3][0];
      y[1] = 0.66666667*x[0][1] + 0.33333333*x[3][1];
      y[2] = 0.66666667*x[0][2] + 0.33333333*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.33333333*x[0][0] + 0.66666667*x[3][0];
      y[1] = 0.33333333*x[0][1] + 0.66666667*x[3][1];
      y[2] = 0.33333333*x[0][2] + 0.66666667*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.66666667*x[0][0] + 0.33333333*x[2][0];
      y[1] = 0.66666667*x[0][1] + 0.33333333*x[2][1];
      y[2] = 0.66666667*x[0][2] + 0.33333333*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.33333333*x[0][0] + 0.66666667*x[2][0];
      y[1] = 0.33333333*x[0][1] + 0.66666667*x[2][1];
      y[2] = 0.33333333*x[0][2] + 0.66666667*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.66666667*x[0][0] + 0.33333333*x[1][0];
      y[1] = 0.66666667*x[0][1] + 0.33333333*x[1][1];
      y[2] = 0.66666667*x[0][2] + 0.33333333*x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 15:
      {
        y[0] = 0.33333333*x[0][0] + 0.66666667*x[1][0];
      y[1] = 0.33333333*x[0][1] + 0.66666667*x[1][1];
      y[2] = 0.33333333*x[0][2] + 0.66666667*x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 16:
      {
        y[0] = 0.33333333*x[1][0] + 0.33333333*x[2][0] + 0.33333333*x[3][0];
      y[1] = 0.33333333*x[1][1] + 0.33333333*x[2][1] + 0.33333333*x[3][1];
      y[2] = 0.33333333*x[1][2] + 0.33333333*x[2][2] + 0.33333333*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 17:
      {
        y[0] = 0.33333333*x[0][0] + 0.33333333*x[2][0] + 0.33333333*x[3][0];
      y[1] = 0.33333333*x[0][1] + 0.33333333*x[2][1] + 0.33333333*x[3][1];
      y[2] = 0.33333333*x[0][2] + 0.33333333*x[2][2] + 0.33333333*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 18:
      {
        y[0] = 0.33333333*x[0][0] + 0.33333333*x[1][0] + 0.33333333*x[3][0];
      y[1] = 0.33333333*x[0][1] + 0.33333333*x[1][1] + 0.33333333*x[3][1];
      y[2] = 0.33333333*x[0][2] + 0.33333333*x[1][2] + 0.33333333*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 19:
      {
        y[0] = 0.33333333*x[0][0] + 0.33333333*x[1][0] + 0.33333333*x[2][0];
      y[1] = 0.33333333*x[0][1] + 0.33333333*x[1][1] + 0.33333333*x[2][1];
      y[2] = 0.33333333*x[0][2] + 0.33333333*x[1][2] + 0.33333333*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.00000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.66666667*x[2][0] + 0.33333333*x[3][0];
    y[1] = 0.66666667*x[2][1] + 0.33333333*x[3][1];
    y[2] = 0.66666667*x[2][2] + 0.33333333*x[3][2];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.33333333*x[2][0] + 0.66666667*x[3][0];
    y[1] = 0.33333333*x[2][1] + 0.66666667*x[3][1];
    y[2] = 0.33333333*x[2][2] + 0.66666667*x[3][2];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.66666667*x[1][0] + 0.33333333*x[3][0];
    y[1] = 0.66666667*x[1][1] + 0.33333333*x[3][1];
    y[2] = 0.66666667*x[1][2] + 0.33333333*x[3][2];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.33333333*x[1][0] + 0.66666667*x[3][0];
    y[1] = 0.33333333*x[1][1] + 0.66666667*x[3][1];
    y[2] = 0.33333333*x[1][2] + 0.66666667*x[3][2];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.66666667*x[1][0] + 0.33333333*x[2][0];
    y[1] = 0.66666667*x[1][1] + 0.33333333*x[2][1];
    y[2] = 0.66666667*x[1][2] + 0.33333333*x[2][2];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.33333333*x[1][0] + 0.66666667*x[2][0];
    y[1] = 0.33333333*x[1][1] + 0.66666667*x[2][1];
    y[2] = 0.33333333*x[1][2] + 0.66666667*x[2][2];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.66666667*x[0][0] + 0.33333333*x[3][0];
    y[1] = 0.66666667*x[0][1] + 0.33333333*x[3][1];
    y[2] = 0.66666667*x[0][2] + 0.33333333*x[3][2];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.33333333*x[0][0] + 0.66666667*x[3][0];
    y[1] = 0.33333333*x[0][1] + 0.66666667*x[3][1];
    y[2] = 0.33333333*x[0][2] + 0.66666667*x[3][2];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.66666667*x[0][0] + 0.33333333*x[2][0];
    y[1] = 0.66666667*x[0][1] + 0.33333333*x[2][1];
    y[2] = 0.66666667*x[0][2] + 0.33333333*x[2][2];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.33333333*x[0][0] + 0.66666667*x[2][0];
    y[1] = 0.33333333*x[0][1] + 0.66666667*x[2][1];
    y[2] = 0.33333333*x[0][2] + 0.66666667*x[2][2];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.66666667*x[0][0] + 0.33333333*x[1][0];
    y[1] = 0.66666667*x[0][1] + 0.33333333*x[1][1];
    y[2] = 0.66666667*x[0][2] + 0.33333333*x[1][2];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
    y[0] = 0.33333333*x[0][0] + 0.66666667*x[1][0];
    y[1] = 0.33333333*x[0][1] + 0.66666667*x[1][1];
    y[2] = 0.33333333*x[0][2] + 0.66666667*x[1][2];
    f.evaluate(vals, y, c);
    values[15] = vals[0];
    y[0] = 0.33333333*x[1][0] + 0.33333333*x[2][0] + 0.33333333*x[3][0];
    y[1] = 0.33333333*x[1][1] + 0.33333333*x[2][1] + 0.33333333*x[3][1];
    y[2] = 0.33333333*x[1][2] + 0.33333333*x[2][2] + 0.33333333*x[3][2];
    f.evaluate(vals, y, c);
    values[16] = vals[0];
    y[0] = 0.33333333*x[0][0] + 0.33333333*x[2][0] + 0.33333333*x[3][0];
    y[1] = 0.33333333*x[0][1] + 0.33333333*x[2][1] + 0.33333333*x[3][1];
    y[2] = 0.33333333*x[0][2] + 0.33333333*x[2][2] + 0.33333333*x[3][2];
    f.evaluate(vals, y, c);
    values[17] = vals[0];
    y[0] = 0.33333333*x[0][0] + 0.33333333*x[1][0] + 0.33333333*x[3][0];
    y[1] = 0.33333333*x[0][1] + 0.33333333*x[1][1] + 0.33333333*x[3][1];
    y[2] = 0.33333333*x[0][2] + 0.33333333*x[1][2] + 0.33333333*x[3][2];
    f.evaluate(vals, y, c);
    values[18] = vals[0];
    y[0] = 0.33333333*x[0][0] + 0.33333333*x[1][0] + 0.33333333*x[2][0];
    y[1] = 0.33333333*x[0][1] + 0.33333333*x[1][1] + 0.33333333*x[2][1];
    y[2] = 0.33333333*x[0][2] + 0.33333333*x[1][2] + 0.33333333*x[2][2];
    f.evaluate(vals, y, c);
    values[19] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c)
  {
    std::cerr << "*** FFC warning: " << "map_from_reference_cell not yet implemented (introduced in UFC 2.0)." << std::endl;
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c)
  {
    std::cerr << "*** FFC warning: " << "map_to_reference_cell not yet implemented (introduced in UFC 2.0)." << std::endl;
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new mass_finite_element_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class mass_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  mass_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~mass_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 3)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 2.00000000*m.num_entities[1] + m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 20;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 20;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 10;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    dofs[3] = offset + c.entity_indices[0][3];
    offset += m.num_entities[0];
    dofs[4] = offset + 2*c.entity_indices[1][0];
    dofs[5] = offset + 2*c.entity_indices[1][0] + 1;
    dofs[6] = offset + 2*c.entity_indices[1][1];
    dofs[7] = offset + 2*c.entity_indices[1][1] + 1;
    dofs[8] = offset + 2*c.entity_indices[1][2];
    dofs[9] = offset + 2*c.entity_indices[1][2] + 1;
    dofs[10] = offset + 2*c.entity_indices[1][3];
    dofs[11] = offset + 2*c.entity_indices[1][3] + 1;
    dofs[12] = offset + 2*c.entity_indices[1][4];
    dofs[13] = offset + 2*c.entity_indices[1][4] + 1;
    dofs[14] = offset + 2*c.entity_indices[1][5];
    dofs[15] = offset + 2*c.entity_indices[1][5] + 1;
    offset += 2*m.num_entities[1];
    dofs[16] = offset + c.entity_indices[2][0];
    dofs[17] = offset + c.entity_indices[2][1];
    dofs[18] = offset + c.entity_indices[2][2];
    dofs[19] = offset + c.entity_indices[2][3];
    offset += m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 7;
      dofs[7] = 8;
      dofs[8] = 9;
      dofs[9] = 16;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 10;
      dofs[6] = 11;
      dofs[7] = 12;
      dofs[8] = 13;
      dofs[9] = 17;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 6;
      dofs[4] = 7;
      dofs[5] = 10;
      dofs[6] = 11;
      dofs[7] = 14;
      dofs[8] = 15;
      dofs[9] = 18;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 8;
      dofs[4] = 9;
      dofs[5] = 12;
      dofs[6] = 13;
      dofs[7] = 14;
      dofs[8] = 15;
      dofs[9] = 19;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 3)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (3)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (3)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (5)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 4;
        dofs[1] = 5;
          break;
        }
      case 1:
        {
          dofs[0] = 6;
        dofs[1] = 7;
          break;
        }
      case 2:
        {
          dofs[0] = 8;
        dofs[1] = 9;
          break;
        }
      case 3:
        {
          dofs[0] = 10;
        dofs[1] = 11;
          break;
        }
      case 4:
        {
          dofs[0] = 12;
        dofs[1] = 13;
          break;
        }
      case 5:
        {
          dofs[0] = 14;
        dofs[1] = 15;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 3)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (3)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 16;
          break;
        }
      case 1:
        {
          dofs[0] = 17;
          break;
        }
      case 2:
        {
          dofs[0] = 18;
          break;
        }
      case 3:
        {
          dofs[0] = 19;
          break;
        }
      }
      
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[0][2] = x[0][2];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[1][2] = x[1][2];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[2][2] = x[2][2];
    coordinates[3][0] = x[3][0];
    coordinates[3][1] = x[3][1];
    coordinates[3][2] = x[3][2];
    coordinates[4][0] = 0.66666667*x[2][0] + 0.33333333*x[3][0];
    coordinates[4][1] = 0.66666667*x[2][1] + 0.33333333*x[3][1];
    coordinates[4][2] = 0.66666667*x[2][2] + 0.33333333*x[3][2];
    coordinates[5][0] = 0.33333333*x[2][0] + 0.66666667*x[3][0];
    coordinates[5][1] = 0.33333333*x[2][1] + 0.66666667*x[3][1];
    coordinates[5][2] = 0.33333333*x[2][2] + 0.66666667*x[3][2];
    coordinates[6][0] = 0.66666667*x[1][0] + 0.33333333*x[3][0];
    coordinates[6][1] = 0.66666667*x[1][1] + 0.33333333*x[3][1];
    coordinates[6][2] = 0.66666667*x[1][2] + 0.33333333*x[3][2];
    coordinates[7][0] = 0.33333333*x[1][0] + 0.66666667*x[3][0];
    coordinates[7][1] = 0.33333333*x[1][1] + 0.66666667*x[3][1];
    coordinates[7][2] = 0.33333333*x[1][2] + 0.66666667*x[3][2];
    coordinates[8][0] = 0.66666667*x[1][0] + 0.33333333*x[2][0];
    coordinates[8][1] = 0.66666667*x[1][1] + 0.33333333*x[2][1];
    coordinates[8][2] = 0.66666667*x[1][2] + 0.33333333*x[2][2];
    coordinates[9][0] = 0.33333333*x[1][0] + 0.66666667*x[2][0];
    coordinates[9][1] = 0.33333333*x[1][1] + 0.66666667*x[2][1];
    coordinates[9][2] = 0.33333333*x[1][2] + 0.66666667*x[2][2];
    coordinates[10][0] = 0.66666667*x[0][0] + 0.33333333*x[3][0];
    coordinates[10][1] = 0.66666667*x[0][1] + 0.33333333*x[3][1];
    coordinates[10][2] = 0.66666667*x[0][2] + 0.33333333*x[3][2];
    coordinates[11][0] = 0.33333333*x[0][0] + 0.66666667*x[3][0];
    coordinates[11][1] = 0.33333333*x[0][1] + 0.66666667*x[3][1];
    coordinates[11][2] = 0.33333333*x[0][2] + 0.66666667*x[3][2];
    coordinates[12][0] = 0.66666667*x[0][0] + 0.33333333*x[2][0];
    coordinates[12][1] = 0.66666667*x[0][1] + 0.33333333*x[2][1];
    coordinates[12][2] = 0.66666667*x[0][2] + 0.33333333*x[2][2];
    coordinates[13][0] = 0.33333333*x[0][0] + 0.66666667*x[2][0];
    coordinates[13][1] = 0.33333333*x[0][1] + 0.66666667*x[2][1];
    coordinates[13][2] = 0.33333333*x[0][2] + 0.66666667*x[2][2];
    coordinates[14][0] = 0.66666667*x[0][0] + 0.33333333*x[1][0];
    coordinates[14][1] = 0.66666667*x[0][1] + 0.33333333*x[1][1];
    coordinates[14][2] = 0.66666667*x[0][2] + 0.33333333*x[1][2];
    coordinates[15][0] = 0.33333333*x[0][0] + 0.66666667*x[1][0];
    coordinates[15][1] = 0.33333333*x[0][1] + 0.66666667*x[1][1];
    coordinates[15][2] = 0.33333333*x[0][2] + 0.66666667*x[1][2];
    coordinates[16][0] = 0.33333333*x[1][0] + 0.33333333*x[2][0] + 0.33333333*x[3][0];
    coordinates[16][1] = 0.33333333*x[1][1] + 0.33333333*x[2][1] + 0.33333333*x[3][1];
    coordinates[16][2] = 0.33333333*x[1][2] + 0.33333333*x[2][2] + 0.33333333*x[3][2];
    coordinates[17][0] = 0.33333333*x[0][0] + 0.33333333*x[2][0] + 0.33333333*x[3][0];
    coordinates[17][1] = 0.33333333*x[0][1] + 0.33333333*x[2][1] + 0.33333333*x[3][1];
    coordinates[17][2] = 0.33333333*x[0][2] + 0.33333333*x[2][2] + 0.33333333*x[3][2];
    coordinates[18][0] = 0.33333333*x[0][0] + 0.33333333*x[1][0] + 0.33333333*x[3][0];
    coordinates[18][1] = 0.33333333*x[0][1] + 0.33333333*x[1][1] + 0.33333333*x[3][1];
    coordinates[18][2] = 0.33333333*x[0][2] + 0.33333333*x[1][2] + 0.33333333*x[3][2];
    coordinates[19][0] = 0.33333333*x[0][0] + 0.33333333*x[1][0] + 0.33333333*x[2][0];
    coordinates[19][1] = 0.33333333*x[0][1] + 0.33333333*x[1][1] + 0.33333333*x[2][1];
    coordinates[19][2] = 0.33333333*x[0][2] + 0.33333333*x[1][2] + 0.33333333*x[2][2];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new mass_dofmap_0();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class mass_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  mass_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~mass_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      18
    // Number of operations (multiply-add pairs) for geometry tensor:    0
    // Number of operations (multiply-add pairs) for tensor contraction: 140
    // Total number of operations (multiply-add pairs):                  158
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_20 = J_01*J_12 - J_02*J_11;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_ = det;
    
    // Compute element tensor
    A[0] = 0.00059524*G0_;
    A[1] = 0.00007440*G0_;
    A[2] = 0.00007440*G0_;
    A[3] = 0.00007440*G0_;
    A[4] = 0.00011161*G0_;
    A[5] = 0.00011161*G0_;
    A[6] = 0.00011161*G0_;
    A[7] = 0.00011161*G0_;
    A[8] = 0.00011161*G0_;
    A[9] = 0.00011161*G0_;
    A[10] = -0.00044643*G0_;
    A[11] = 0.00022321*G0_;
    A[12] = -0.00044643*G0_;
    A[13] = 0.00022321*G0_;
    A[14] = -0.00044643*G0_;
    A[15] = 0.00022321*G0_;
    A[16] = 0.00133929*G0_;
    A[17] = 0.00066964*G0_;
    A[18] = 0.00066964*G0_;
    A[19] = 0.00066964*G0_;
    A[20] = 0.00007440*G0_;
    A[21] = 0.00059524*G0_;
    A[22] = 0.00007440*G0_;
    A[23] = 0.00007440*G0_;
    A[24] = 0.00011161*G0_;
    A[25] = 0.00011161*G0_;
    A[26] = -0.00044643*G0_;
    A[27] = 0.00022321*G0_;
    A[28] = -0.00044643*G0_;
    A[29] = 0.00022321*G0_;
    A[30] = 0.00011161*G0_;
    A[31] = 0.00011161*G0_;
    A[32] = 0.00011161*G0_;
    A[33] = 0.00011161*G0_;
    A[34] = 0.00022321*G0_;
    A[35] = -0.00044643*G0_;
    A[36] = 0.00066964*G0_;
    A[37] = 0.00133929*G0_;
    A[38] = 0.00066964*G0_;
    A[39] = 0.00066964*G0_;
    A[40] = 0.00007440*G0_;
    A[41] = 0.00007440*G0_;
    A[42] = 0.00059524*G0_;
    A[43] = 0.00007440*G0_;
    A[44] = -0.00044643*G0_;
    A[45] = 0.00022321*G0_;
    A[46] = 0.00011161*G0_;
    A[47] = 0.00011161*G0_;
    A[48] = 0.00022321*G0_;
    A[49] = -0.00044643*G0_;
    A[50] = 0.00011161*G0_;
    A[51] = 0.00011161*G0_;
    A[52] = 0.00022321*G0_;
    A[53] = -0.00044643*G0_;
    A[54] = 0.00011161*G0_;
    A[55] = 0.00011161*G0_;
    A[56] = 0.00066964*G0_;
    A[57] = 0.00066964*G0_;
    A[58] = 0.00133929*G0_;
    A[59] = 0.00066964*G0_;
    A[60] = 0.00007440*G0_;
    A[61] = 0.00007440*G0_;
    A[62] = 0.00007440*G0_;
    A[63] = 0.00059524*G0_;
    A[64] = 0.00022321*G0_;
    A[65] = -0.00044643*G0_;
    A[66] = 0.00022321*G0_;
    A[67] = -0.00044643*G0_;
    A[68] = 0.00011161*G0_;
    A[69] = 0.00011161*G0_;
    A[70] = 0.00022321*G0_;
    A[71] = -0.00044643*G0_;
    A[72] = 0.00011161*G0_;
    A[73] = 0.00011161*G0_;
    A[74] = 0.00011161*G0_;
    A[75] = 0.00011161*G0_;
    A[76] = 0.00066964*G0_;
    A[77] = 0.00066964*G0_;
    A[78] = 0.00066964*G0_;
    A[79] = 0.00133929*G0_;
    A[80] = 0.00011161*G0_;
    A[81] = 0.00011161*G0_;
    A[82] = -0.00044643*G0_;
    A[83] = 0.00022321*G0_;
    A[84] = 0.00401786*G0_;
    A[85] = -0.00200893*G0_;
    A[86] = 0.00000000;
    A[87] = -0.00100446*G0_;
    A[88] = -0.00100446*G0_;
    A[89] = 0.00200893*G0_;
    A[90] = 0.00000000;
    A[91] = -0.00100446*G0_;
    A[92] = -0.00100446*G0_;
    A[93] = 0.00200893*G0_;
    A[94] = 0.00000000;
    A[95] = 0.00000000;
    A[96] = 0.00000000;
    A[97] = 0.00000000;
    A[98] = -0.00200893*G0_;
    A[99] = 0.00000000;
    A[100] = 0.00011161*G0_;
    A[101] = 0.00011161*G0_;
    A[102] = 0.00022321*G0_;
    A[103] = -0.00044643*G0_;
    A[104] = -0.00200893*G0_;
    A[105] = 0.00401786*G0_;
    A[106] = -0.00100446*G0_;
    A[107] = 0.00200893*G0_;
    A[108] = 0.00000000;
    A[109] = -0.00100446*G0_;
    A[110] = -0.00100446*G0_;
    A[111] = 0.00200893*G0_;
    A[112] = 0.00000000;
    A[113] = -0.00100446*G0_;
    A[114] = 0.00000000;
    A[115] = 0.00000000;
    A[116] = 0.00000000;
    A[117] = 0.00000000;
    A[118] = 0.00000000;
    A[119] = -0.00200893*G0_;
    A[120] = 0.00011161*G0_;
    A[121] = -0.00044643*G0_;
    A[122] = 0.00011161*G0_;
    A[123] = 0.00022321*G0_;
    A[124] = 0.00000000;
    A[125] = -0.00100446*G0_;
    A[126] = 0.00401786*G0_;
    A[127] = -0.00200893*G0_;
    A[128] = 0.00200893*G0_;
    A[129] = -0.00100446*G0_;
    A[130] = 0.00000000;
    A[131] = -0.00100446*G0_;
    A[132] = 0.00000000;
    A[133] = 0.00000000;
    A[134] = -0.00100446*G0_;
    A[135] = 0.00200893*G0_;
    A[136] = 0.00000000;
    A[137] = -0.00200893*G0_;
    A[138] = 0.00000000;
    A[139] = 0.00000000;
    A[140] = 0.00011161*G0_;
    A[141] = 0.00022321*G0_;
    A[142] = 0.00011161*G0_;
    A[143] = -0.00044643*G0_;
    A[144] = -0.00100446*G0_;
    A[145] = 0.00200893*G0_;
    A[146] = -0.00200893*G0_;
    A[147] = 0.00401786*G0_;
    A[148] = -0.00100446*G0_;
    A[149] = 0.00000000;
    A[150] = -0.00100446*G0_;
    A[151] = 0.00200893*G0_;
    A[152] = 0.00000000;
    A[153] = 0.00000000;
    A[154] = 0.00000000;
    A[155] = -0.00100446*G0_;
    A[156] = 0.00000000;
    A[157] = 0.00000000;
    A[158] = 0.00000000;
    A[159] = -0.00200893*G0_;
    A[160] = 0.00011161*G0_;
    A[161] = -0.00044643*G0_;
    A[162] = 0.00022321*G0_;
    A[163] = 0.00011161*G0_;
    A[164] = -0.00100446*G0_;
    A[165] = 0.00000000;
    A[166] = 0.00200893*G0_;
    A[167] = -0.00100446*G0_;
    A[168] = 0.00401786*G0_;
    A[169] = -0.00200893*G0_;
    A[170] = 0.00000000;
    A[171] = 0.00000000;
    A[172] = 0.00000000;
    A[173] = -0.00100446*G0_;
    A[174] = -0.00100446*G0_;
    A[175] = 0.00200893*G0_;
    A[176] = 0.00000000;
    A[177] = -0.00200893*G0_;
    A[178] = 0.00000000;
    A[179] = 0.00000000;
    A[180] = 0.00011161*G0_;
    A[181] = 0.00022321*G0_;
    A[182] = -0.00044643*G0_;
    A[183] = 0.00011161*G0_;
    A[184] = 0.00200893*G0_;
    A[185] = -0.00100446*G0_;
    A[186] = -0.00100446*G0_;
    A[187] = 0.00000000;
    A[188] = -0.00200893*G0_;
    A[189] = 0.00401786*G0_;
    A[190] = 0.00000000;
    A[191] = 0.00000000;
    A[192] = -0.00100446*G0_;
    A[193] = 0.00200893*G0_;
    A[194] = 0.00000000;
    A[195] = -0.00100446*G0_;
    A[196] = 0.00000000;
    A[197] = 0.00000000;
    A[198] = -0.00200893*G0_;
    A[199] = 0.00000000;
    A[200] = -0.00044643*G0_;
    A[201] = 0.00011161*G0_;
    A[202] = 0.00011161*G0_;
    A[203] = 0.00022321*G0_;
    A[204] = 0.00000000;
    A[205] = -0.00100446*G0_;
    A[206] = 0.00000000;
    A[207] = -0.00100446*G0_;
    A[208] = 0.00000000;
    A[209] = 0.00000000;
    A[210] = 0.00401786*G0_;
    A[211] = -0.00200893*G0_;
    A[212] = 0.00200893*G0_;
    A[213] = -0.00100446*G0_;
    A[214] = 0.00200893*G0_;
    A[215] = -0.00100446*G0_;
    A[216] = -0.00200893*G0_;
    A[217] = 0.00000000;
    A[218] = 0.00000000;
    A[219] = 0.00000000;
    A[220] = 0.00022321*G0_;
    A[221] = 0.00011161*G0_;
    A[222] = 0.00011161*G0_;
    A[223] = -0.00044643*G0_;
    A[224] = -0.00100446*G0_;
    A[225] = 0.00200893*G0_;
    A[226] = -0.00100446*G0_;
    A[227] = 0.00200893*G0_;
    A[228] = 0.00000000;
    A[229] = 0.00000000;
    A[230] = -0.00200893*G0_;
    A[231] = 0.00401786*G0_;
    A[232] = -0.00100446*G0_;
    A[233] = 0.00000000;
    A[234] = -0.00100446*G0_;
    A[235] = 0.00000000;
    A[236] = 0.00000000;
    A[237] = 0.00000000;
    A[238] = 0.00000000;
    A[239] = -0.00200893*G0_;
    A[240] = -0.00044643*G0_;
    A[241] = 0.00011161*G0_;
    A[242] = 0.00022321*G0_;
    A[243] = 0.00011161*G0_;
    A[244] = -0.00100446*G0_;
    A[245] = 0.00000000;
    A[246] = 0.00000000;
    A[247] = 0.00000000;
    A[248] = 0.00000000;
    A[249] = -0.00100446*G0_;
    A[250] = 0.00200893*G0_;
    A[251] = -0.00100446*G0_;
    A[252] = 0.00401786*G0_;
    A[253] = -0.00200893*G0_;
    A[254] = 0.00200893*G0_;
    A[255] = -0.00100446*G0_;
    A[256] = -0.00200893*G0_;
    A[257] = 0.00000000;
    A[258] = 0.00000000;
    A[259] = 0.00000000;
    A[260] = 0.00022321*G0_;
    A[261] = 0.00011161*G0_;
    A[262] = -0.00044643*G0_;
    A[263] = 0.00011161*G0_;
    A[264] = 0.00200893*G0_;
    A[265] = -0.00100446*G0_;
    A[266] = 0.00000000;
    A[267] = 0.00000000;
    A[268] = -0.00100446*G0_;
    A[269] = 0.00200893*G0_;
    A[270] = -0.00100446*G0_;
    A[271] = 0.00000000;
    A[272] = -0.00200893*G0_;
    A[273] = 0.00401786*G0_;
    A[274] = -0.00100446*G0_;
    A[275] = 0.00000000;
    A[276] = 0.00000000;
    A[277] = 0.00000000;
    A[278] = -0.00200893*G0_;
    A[279] = 0.00000000;
    A[280] = -0.00044643*G0_;
    A[281] = 0.00022321*G0_;
    A[282] = 0.00011161*G0_;
    A[283] = 0.00011161*G0_;
    A[284] = 0.00000000;
    A[285] = 0.00000000;
    A[286] = -0.00100446*G0_;
    A[287] = 0.00000000;
    A[288] = -0.00100446*G0_;
    A[289] = 0.00000000;
    A[290] = 0.00200893*G0_;
    A[291] = -0.00100446*G0_;
    A[292] = 0.00200893*G0_;
    A[293] = -0.00100446*G0_;
    A[294] = 0.00401786*G0_;
    A[295] = -0.00200893*G0_;
    A[296] = -0.00200893*G0_;
    A[297] = 0.00000000;
    A[298] = 0.00000000;
    A[299] = 0.00000000;
    A[300] = 0.00022321*G0_;
    A[301] = -0.00044643*G0_;
    A[302] = 0.00011161*G0_;
    A[303] = 0.00011161*G0_;
    A[304] = 0.00000000;
    A[305] = 0.00000000;
    A[306] = 0.00200893*G0_;
    A[307] = -0.00100446*G0_;
    A[308] = 0.00200893*G0_;
    A[309] = -0.00100446*G0_;
    A[310] = -0.00100446*G0_;
    A[311] = 0.00000000;
    A[312] = -0.00100446*G0_;
    A[313] = 0.00000000;
    A[314] = -0.00200893*G0_;
    A[315] = 0.00401786*G0_;
    A[316] = 0.00000000;
    A[317] = -0.00200893*G0_;
    A[318] = 0.00000000;
    A[319] = 0.00000000;
    A[320] = 0.00133929*G0_;
    A[321] = 0.00066964*G0_;
    A[322] = 0.00066964*G0_;
    A[323] = 0.00066964*G0_;
    A[324] = 0.00000000;
    A[325] = 0.00000000;
    A[326] = 0.00000000;
    A[327] = 0.00000000;
    A[328] = 0.00000000;
    A[329] = 0.00000000;
    A[330] = -0.00200893*G0_;
    A[331] = 0.00000000;
    A[332] = -0.00200893*G0_;
    A[333] = 0.00000000;
    A[334] = -0.00200893*G0_;
    A[335] = 0.00000000;
    A[336] = 0.01607143*G0_;
    A[337] = 0.00803571*G0_;
    A[338] = 0.00803571*G0_;
    A[339] = 0.00803571*G0_;
    A[340] = 0.00066964*G0_;
    A[341] = 0.00133929*G0_;
    A[342] = 0.00066964*G0_;
    A[343] = 0.00066964*G0_;
    A[344] = 0.00000000;
    A[345] = 0.00000000;
    A[346] = -0.00200893*G0_;
    A[347] = 0.00000000;
    A[348] = -0.00200893*G0_;
    A[349] = 0.00000000;
    A[350] = 0.00000000;
    A[351] = 0.00000000;
    A[352] = 0.00000000;
    A[353] = 0.00000000;
    A[354] = 0.00000000;
    A[355] = -0.00200893*G0_;
    A[356] = 0.00803571*G0_;
    A[357] = 0.01607143*G0_;
    A[358] = 0.00803571*G0_;
    A[359] = 0.00803571*G0_;
    A[360] = 0.00066964*G0_;
    A[361] = 0.00066964*G0_;
    A[362] = 0.00133929*G0_;
    A[363] = 0.00066964*G0_;
    A[364] = -0.00200893*G0_;
    A[365] = 0.00000000;
    A[366] = 0.00000000;
    A[367] = 0.00000000;
    A[368] = 0.00000000;
    A[369] = -0.00200893*G0_;
    A[370] = 0.00000000;
    A[371] = 0.00000000;
    A[372] = 0.00000000;
    A[373] = -0.00200893*G0_;
    A[374] = 0.00000000;
    A[375] = 0.00000000;
    A[376] = 0.00803571*G0_;
    A[377] = 0.00803571*G0_;
    A[378] = 0.01607143*G0_;
    A[379] = 0.00803571*G0_;
    A[380] = 0.00066964*G0_;
    A[381] = 0.00066964*G0_;
    A[382] = 0.00066964*G0_;
    A[383] = 0.00133929*G0_;
    A[384] = 0.00000000;
    A[385] = -0.00200893*G0_;
    A[386] = 0.00000000;
    A[387] = -0.00200893*G0_;
    A[388] = 0.00000000;
    A[389] = 0.00000000;
    A[390] = 0.00000000;
    A[391] = -0.00200893*G0_;
    A[392] = 0.00000000;
    A[393] = 0.00000000;
    A[394] = 0.00000000;
    A[395] = 0.00000000;
    A[396] = 0.00803571*G0_;
    A[397] = 0.00803571*G0_;
    A[398] = 0.00803571*G0_;
    A[399] = 0.01607143*G0_;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    std::cerr << "*** FFC warning: " << "Quadrature version of tabulate_tensor not available when using the FFC tensor representation." << std::endl;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class mass_form_0: public ufc::form
{
public:

  /// Constructor
  mass_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~mass_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Argument(FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 3), 0), Argument(FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 3), 1)), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new mass_finite_element_0();
        break;
      }
    case 1:
      {
        return new mass_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new mass_dofmap_0();
        break;
      }
    case 1:
      {
        return new mass_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new mass_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

#endif
