package fix;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Pattern;

import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.RepaintManager;

/**
 * This class sends the HTTP-MIME-messages necessary for the F*EX upload.
 * 
 * $Date: 2010-11-03 16:58:25 +0100 (Mi, 03. Nov 2010) $
 * $Revision: 33 $
 * $Author: roth $
 * 
 * @author Dominik
 * 
 * Copyright (C) 2008 Dominik Greibl
 * Copyright (C) 2009 Sebastian Roth
 * 
 * All Rights Reserved
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

public class Sender {

	private String rec = "";
	private String comm = "";
	private String server = "";
	private String user = "";
	private String id = "";
	private String akey = "";
	private String skey = "";
	public String boundary = "";
	public HttpClient hc = null;
	private BufferedReader fromServer = null;
	private String fileName = "";
	private File file = null;
	private FileInputStream is = null;
	private boolean debug = false;
	private long seek = -1;
	private ErrorWindow er = null;
	private boolean mime = false;
	private boolean isCanceled = false;

	/**
	 * The default constructor
	 * 
	 * @param reci
	 *            The recipient of the file.
	 * @param file
	 *            The file to be sent.
	 * @param comment
	 *            The optional comment (may be null or empty String).
	 * @param m
	 *            Flag to set MIME-Type to application/x-mime.
	 * @param server
	 *            The URL of the F*EX Server
	 * @param user
	 *            The user that sends the file.
	 * @param id
	 *            The auth-id of this user.
	 * @param akey
	 *            TODO.
	 * @param skey
	 *            TODO.
	 * @param err
	 *            The ErrorWindow used to display errors.
	 * @param d
	 *            Is debugging on or off.
	 */
	public Sender(String reci, String file, String comment, boolean m, String server,
			String user, String id, String akey, String skey, ErrorWindow err, boolean d) {
		rec = reci;
		this.file = new File(file);
		this.fileName = this.file.getName();
		comm = comment;
		this.server = server;
		this.user = user;
		this.id = id;
		this.akey = akey;
		this.skey = skey;
		er = err;
		mime = m;
		debug = d;
		isCanceled = false;
	}

	/**
	 * Sends the MIME-Messages used to prepare the upload and starts the upload.
	 */
	public boolean send(JProgressBar progressBar, JLabel statusLabel) {
		progressBar.setVisible(true);
		RepaintManager.currentManager(progressBar).paintDirtyRegions();
		/** Creates a new Instance of HttpClient and connects to the given url* */
		hc = new HttpClient(er, debug);
		hc.connect(server);
		/** Creates the BufferedReader for reading the server's response * */
		try {
			fromServer = new BufferedReader(new InputStreamReader(hc.getSocket()
					.getInputStream()));
		} catch (IOException e2) {
			er.setMess("Unable to read input stream. No connection established!", e2);
			return false;
		}
		
		/** Send auth-ID in HEAD request to get seek value * */
		if ((seek = checkFileLengthOnServer()) == -1) {
			return false;
		}
		
		boolean answer = false;
		/** Send HTTP POST headers before posting the file itself * */
		if ((answer = sendPostHeaders()) == false) {
			return false;
		}

		try {
			long maxLength = file.length();
			long reachedSoFar = 0;
			int read = 0;
			byte[] temp = new byte[16384];
			is = new FileInputStream(file);
			is.skip(seek);
			reachedSoFar = seek;
			while ((read = is.read(temp, 0, temp.length)) != -1) {
				if (isCanceled == true) {
					fromServer.close();
					is.close();
					hc.out.flush();
					hc.out.close();
					isCanceled = false;
					return false;
				}
				hc.send(temp, 0, read);
				reachedSoFar += read;
				progressBar.setValue((int) (reachedSoFar * 100. / maxLength) * 2);
				RepaintManager.currentManager(progressBar).paintDirtyRegions();
			}
		} catch (IOException e) {
			er.setMess("File could not be sent: " + e.getMessage(), e);
			return false;
		}
		hc.send("\r\n\r\n--" + boundary + "--" + "\r\n");

		statusLabel.setText("waiting for server confirmation");
		RepaintManager.currentManager(statusLabel).paintDirtyRegions();
		String sss = null;
		String result = "";
		sss = hc.receive(fromServer);
		if (sss.startsWith("HTTP")) {
			result = sss.split("\\r\\n")[0].split(" ")[2];
		} else if (sss == null) {
			result = "no response";
		}
		// TODO not sending the last \r\n the server responds with 'DIE TIMEOUT'
		// how to handle this?
		er.setMess("File uploaded successful! Server answered: " + result, "Done",  null);
		System.out.println("result: " + result);
				
		try {
			fromServer.close();
			is.close();
			hc.out.flush();
			hc.out.close();
		} catch (IOException e) {
			er.setMess("Streams could not be closed, please restart Client.", e);
			return false;
		}
		return true;
	}


	private long checkFileLengthOnServer() {
			String URLEncodedFileName = "";
			try {
				URLEncodedFileName = URLEncoder.encode(fileName, "UTF-8");
			} catch (UnsupportedEncodingException uee) {
				uee.printStackTrace();
				return -1;
			}
			if (hc.isConnected) {
				String message = "HEAD " + hc.getURLifProxified();
				hc.addRequestProperty("Host", hc.getHost() + ":" + hc.getPort());
				hc.addRequestProperty("User-Agent", "F*IX");
				hc.addRequestProperty("Connection", "keep-alive");
				message = message + "/fop/" + rec + "/" + user + "/" + URLEncodedFileName
					+ "??&ID=" + id + (!skey.equals("") ? "&SKEY=" + skey : "")
					+ " HTTP/1.1\r\n" + hc.getRequestProperties();
				hc.send(message + "\r\n");
			}
			else {
				er.setMess("Not connected. Cannot request file length.", null);
				return -1;
			}

			String resp = hc.receive(fromServer);
			String tmp = null;
			long seek = -1;
			long sizeOnServer = 0;
			try {
				if (Pattern.compile("^HTTP\\/[0-9]\\.[0-9]\\s*200\\s*OK").matcher(resp).find()) {
					if ((tmp = hc.getResponseProperty("CONTENT-LENGTH")) != null) {
						seek = Long.parseLong(tmp);
					}
					else {
						er.setMess("Unexpected response from server! 'Content-Length' header missing?", null);
						return -1;
					}
					if ((tmp = hc.getResponseProperty("X-SIZE")) != null) {
						sizeOnServer = Long.parseLong(tmp);
						if (file.length() != sizeOnServer) {
							seek = 0;
						}
					}
					return seek;
				}
				else {
					er.setMess("Unexpected response from server '" + resp + "'", null);
					return -1;
				}
			} catch (NumberFormatException nfe) {
				er.setMess("Unable to parse HTTP header. Expected a number.", nfe);
				return -1;
			}
	}
	
	
	public boolean sendPostHeaders() {
		/** Creates the boundary * */
		int arraySize = 40;
		byte[] bytes = new byte[arraySize];
		for (int i = 0; i < arraySize; i++) {
			bytes[i] += (byte) (int) (Math.random() * 256);
		}
		boundary = String.valueOf(Base64Coder.encode(bytes));

		/** Sets the MIME-Type depending on the view option (mime) * */
		String mimetype = "application/octet-stream";
		if (mime) {
			mimetype = "application/x-mime";
		}
		/** Variables often used * */
		final String contdisp = "Content-Disposition"; 
		final String formdata = "form-data; name=\"";
		long fullLength = 0;
		long fileLength = file.length() - seek;

		/** Prepare POST headers and POST data * */
		fullLength += hc.addRequestProperty(contdisp, formdata + "FROM\""
				+ "\r\n\r\n" + user + "\r\n--" + boundary);
		fullLength += hc.addRequestProperty(contdisp, formdata + "TO\""
				+ "\r\n\r\n" + rec + "\r\n--" + boundary);
		fullLength += hc.addRequestProperty(contdisp, formdata + "ID\""
				+ "\r\n\r\n" + id + "\r\n--" + boundary);
		if (akey != null && !akey.equals("")) {
			fullLength += hc.addRequestProperty(contdisp, formdata + "AKEY\""
					+ "\r\n\r\n" + akey + "\r\n--" + boundary);
		}
		if (skey != null && !skey.equals("")) {
			fullLength += hc.addRequestProperty(contdisp, formdata + "SKEY\""
					+ "\r\n\r\n" + skey + "\r\n--" + boundary);
		}
		if (comm != null && !comm.equals("")) {
			fullLength += hc.addRequestProperty(contdisp, formdata + "COMMENT\""
					+ "\r\n\r\n" + comm + "\r\n--" + boundary);
		}
		if (seek > 0) {
			fullLength += hc.addRequestProperty(contdisp, formdata + "SEEK\""
					+ "\r\n\r\n" + seek + "\r\n--" + boundary);
		}
		fullLength += hc.addRequestProperty(contdisp, formdata + "FILE\"; filename=\""
				+ fileName + "\"");
		fullLength += hc.addRequestProperty("Content-Type", mimetype);
		fullLength += hc.addRequestProperty("Content-Length", fileLength + "");
		// add 6 dashes, 3 carriage returns and 3 new lines
		fullLength += (boundary.length()*2) + 12 + fileLength;


		if (hc.isConnected) {
			String message = "POST " + hc.getURLifProxified();
			hc.prependRequestProperty("Content-Type", "multipart/form-data; boundary="
					+ boundary + "\r\n\r\n--" + boundary);
			hc.prependRequestProperty("Content-Length", fullLength + "");
			hc.prependRequestProperty("Connection", "close");
			hc.prependRequestProperty("User-Agent", "F*IX");
			hc.prependRequestProperty("Host", hc.getHost() + ":" + hc.getPort());

			message = message + "/fup HTTP/1.1\r\n" + hc.getRequestProperties();
			hc.send(message + "\r\n");
			return true;
		}
		else {
			er.setMess("Not connected. Cannot send POST headers.", null);
			return false;
		}
	}

	public void cancelSend() {
		isCanceled = true;
	}
	
}
