__author__ = "Robert C. Kirby (kirby@uchicago.edu)"
__date__ = "2005-04-01 -- 2006-04-01"
__copyright__ = "Copyright (C) 2006- Robert C. Kirby"
__license__  = "GNU LGPL Version 2"

import numpy

def round_sig( a , m ):
    if abs( a ) < 10**(-m):
        return 0.0
    else:
        m_str , e_str = ( "%.12e" % (a,) ).split( "e" )
        return round( float( m_str ) , m ) * 10**int(e_str)

def vec_round_sig( a , m ):
    return numpy.array( [ round_sig( x , m ) for x in a ] )

def tensor_round_sig( a , m ):
    asize = reduce( lambda a,b:a*b , a.shape )
    flat = numpy.reshape( a , (asize,1) )
    around = vec_round_sig( flat , m )
    return numpy.reshape( around , a.shape )

if __name__ == "__main__":
	a = 1.66666666666666666666
	print "%.16e" % (a,)
	print round_sig( a , 8 )