<?xml version='1.0' encoding='ISO-8859-1' standalone='yes' ?>
<tagfile>
  <compound kind="file">
    <name>backend.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>backend_8cpp</filename>
    <includes id="backend_8hpp" name="backend.hpp" local="no" imported="no">feel/feelalg/backend.hpp</includes>
    <includes id="backendpetsc_8hpp" name="backendpetsc.hpp" local="no" imported="no">feel/feelalg/backendpetsc.hpp</includes>
    <includes id="backendtrilinos_8hpp" name="backendtrilinos.hpp" local="no" imported="no">feel/feelalg/backendtrilinos.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>po::options_description</type>
      <name>backend_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a04ed4818b422d55de7aba6f00ca59e0e</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>backend.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>backend_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="environment_8hpp" name="environment.hpp" local="no" imported="no">feel/feelcore/environment.hpp</includes>
    <includes id="singleton_8hpp" name="singleton.hpp" local="no" imported="no">feel/feelcore/singleton.hpp</includes>
    <includes id="matrixsparse_8hpp" name="matrixsparse.hpp" local="no" imported="no">feel/feelalg/matrixsparse.hpp</includes>
    <includes id="matrixblock_8hpp" name="matrixblock.hpp" local="no" imported="no">feel/feelalg/matrixblock.hpp</includes>
    <includes id="solvernonlinear_8hpp" name="solvernonlinear.hpp" local="no" imported="no">feel/feelalg/solvernonlinear.hpp</includes>
    <includes id="preconditioner_8hpp" name="preconditioner.hpp" local="no" imported="no">feel/feelalg/preconditioner.hpp</includes>
    <class kind="class">Feel::Backend</class>
    <class kind="class">Feel::detail::BackendManagerImpl</class>
    <class kind="struct">Feel::detail::BackendManagerDeleterImpl</class>
    <namespace>Feel</namespace>
    <namespace>Feel::detail</namespace>
    <member kind="typedef">
      <type>Backend&lt; double &gt;</type>
      <name>backend_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a773ed955956f2a157dc605630ab3c262</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; backend_type &gt;</type>
      <name>backend_ptrtype</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ae906579f5f8c6d16bf66a2570518b249</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Feel::Singleton&lt; BackendManagerImpl &gt;</type>
      <name>BackendManager</name>
      <anchorfile>namespaceFeel_1_1detail.html</anchorfile>
      <anchor>a8ed66d7d80701cf737efd10bfcaeeb3b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Feel::Singleton&lt; BackendManagerDeleterImpl &gt;</type>
      <name>BackendManagerDeleter</name>
      <anchorfile>namespaceFeel_1_1detail.html</anchorfile>
      <anchor>a6ec0fd3c7813cc91711905f4e95ac4dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>po::options_description</type>
      <name>backend_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a04ed4818b422d55de7aba6f00ca59e0e</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a3e02a4b1f8acebb94176a692e6adf3c0</anchor>
      <arglist>((backend_ptrtype), backend, tag,(optional(vm,(po::variables_map), po::variables_map())(name,(std::string),&quot;&quot;)(kind,(BackendType), BACKEND_PETSC)(rebuild,(bool), false)))</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>backendgmm.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>backendgmm_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="backendgmm_8hpp" name="backendgmm.hpp" local="no" imported="no">feel/feelalg/backendgmm.hpp</includes>
    <includes id="matrixtriplet_8hpp" name="matrixtriplet.hpp" local="no" imported="no">feel/feelalg/matrixtriplet.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>po::options_description</type>
      <name>backendgmm_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a237fa6fbecc6b600939694f57887629a</anchor>
      <arglist>(std::string const &amp;prefix, BackendGmmDefaults defaults)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>backendgmm.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>backendgmm_8hpp</filename>
    <includes id="application_8hpp" name="application.hpp" local="no" imported="no">feel/feelcore/application.hpp</includes>
    <includes id="vectorublas_8hpp" name="vectorublas.hpp" local="no" imported="no">feel/feelalg/vectorublas.hpp</includes>
    <includes id="matrixgmm_8hpp" name="matrixgmm.hpp" local="no" imported="no">feel/feelalg/matrixgmm.hpp</includes>
    <includes id="matrixtriplet_8hpp" name="matrixtriplet.hpp" local="no" imported="no">feel/feelalg/matrixtriplet.hpp</includes>
    <includes id="solverumfpack_8hpp" name="solverumfpack.hpp" local="no" imported="no">feel/feelalg/solverumfpack.hpp</includes>
    <includes id="backend_8hpp" name="backend.hpp" local="no" imported="no">feel/feelalg/backend.hpp</includes>
    <class kind="struct">Feel::BackendGmmDefaults</class>
    <class kind="class">Feel::BackendGmm</class>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>po::options_description</type>
      <name>backendgmm_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a237fa6fbecc6b600939694f57887629a</anchor>
      <arglist>(std::string const &amp;prefix, BackendGmmDefaults defaults)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>backendpetsc.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>backendpetsc_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="backendpetsc_8hpp" name="backendpetsc.hpp" local="no" imported="no">feel/feelalg/backendpetsc.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>po::options_description</type>
      <name>backendpetsc_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a745fa7e1c7f6cfb0b31c08b44d7ee967</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>backendpetsc.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>backendpetsc_8hpp</filename>
    <includes id="matrixpetsc_8hpp" name="matrixpetsc.hpp" local="no" imported="no">feel/feelalg/matrixpetsc.hpp</includes>
    <includes id="vectorpetsc_8hpp" name="vectorpetsc.hpp" local="no" imported="no">feel/feelalg/vectorpetsc.hpp</includes>
    <includes id="solverlinearpetsc_8hpp" name="solverlinearpetsc.hpp" local="no" imported="no">feel/feelalg/solverlinearpetsc.hpp</includes>
    <includes id="solvernonlinearpetsc_8hpp" name="solvernonlinearpetsc.hpp" local="no" imported="no">feel/feelalg/solvernonlinearpetsc.hpp</includes>
    <includes id="backend_8hpp" name="backend.hpp" local="no" imported="no">feel/feelalg/backend.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>backendtrilinos.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>backendtrilinos_8hpp</filename>
  </compound>
  <compound kind="file">
    <name>bfgs.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>bfgs_8hpp</filename>
    <includes id="typetraits_8hpp" name="typetraits.hpp" local="no" imported="no">feel/feelcore/typetraits.hpp</includes>
    <class kind="struct">Feel::BFGSInvHessian</class>
    <namespace>Feel</namespace>
    <member kind="enumeration">
      <name>BFGSType</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9f782edf3ce1e077391aa88c4347526c</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bfgs</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4101e9b098204150bed0c9fe112ce997</anchor>
      <arglist>(FUNCTION f, DERIVATIVE grad, VECTOR &amp;x, int restart, IterationBFGS &amp;iter, BFGSType version=BFGS, float lambda_init=0.001, float=1.0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>dfp</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab5c73a46a30d5f12ad410cc8826e3b4a</anchor>
      <arglist>(FUNCTION f, DERIVATIVE grad, VECTOR &amp;x, int restart, IterationBFGS &amp;iter, BFGSType version=DFP)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>boundingbox.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>boundingbox_8hpp</filename>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <class kind="class">Feel::BoundingBox</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>cholesky.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>cholesky_8hpp</filename>
    <member kind="function">
      <type>size_t</type>
      <name>cholesky_decompose</name>
      <anchorfile>cholesky_8hpp.html</anchorfile>
      <anchor>ae66ea4c67986682ce4230c63b84b6b4b</anchor>
      <arglist>(const MATRIX &amp;A, TRIA &amp;L)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>datamap.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>datamap_8cpp</filename>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>dummy.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>dummy_8cpp</filename>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>functionspetsc.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>functionspetsc_8cpp</filename>
    <includes id="functionspetsc_8hpp" name="functionspetsc.hpp" local="no" imported="no">feel/feelalg/functionspetsc.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>void</type>
      <name>PetscPCFactorSetMatSolverPackage</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a451bcfd28bef94b065bb2f154357ef56</anchor>
      <arglist>(PC &amp;pc, MatSolverPackageType mspackt)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>functionspetsc.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>functionspetsc_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
  </compound>
  <compound kind="file">
    <name>glas.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>glas_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="debug_8hpp" name="debug.hpp" local="no" imported="no">feel/feelcore/debug.hpp</includes>
    <class kind="struct">Feel::norm_inf_adaptor</class>
    <class kind="struct">Feel::node</class>
    <class kind="struct">Feel::matrix_node</class>
    <namespace>Feel</namespace>
    <member kind="typedef">
      <type>ublas::symmetric_matrix&lt; double, ublas::lower, ublas::row_major, ublas::bounded_array&lt; double, 9 &gt; &gt;</type>
      <name>hessian_node_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a5726f6c555d1353dd27fcf1b8b770589</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ublas::matrix&lt; double, ublas::column_major, ublas::bounded_array&lt; double, 9 &gt; &gt;</type>
      <name>lapack_matrix_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ace999367f3dfa18cf549411375a759e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ublas::symmetric_adaptor&lt; lapack_matrix_type, ublas::lower &gt;</type>
      <name>symmetric_matrix_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9d10710f44ff3f93402ea5db1c29965c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>lapack_matrix_type</type>
      <name>transformation_matrix_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a64aa3a32f6112bf0c6d0c747477d9d92</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ublas::compressed_matrix&lt; double, ublas::row_major, 0, ublas::unbounded_array&lt; int &gt;, ublas::unbounded_array&lt; double &gt; &gt;</type>
      <name>csr_matrix_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af4227eac6019ef023fccc16e304b584e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ublas::compressed_matrix&lt; double, ublas::column_major, 0, ublas::unbounded_array&lt; int &gt;, ublas::unbounded_array&lt; double &gt; &gt;</type>
      <name>csc_matrix_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ac8757b2b4726472e379d4229e20b9039</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>Min</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a16fd333bec3f7b5f51d1fdb64648cf0f</anchor>
      <arglist>(const T &amp;a, const T &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>Max</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad4eb9aac4e62b94ab49613797074c820</anchor>
      <arglist>(const T &amp;a, const T &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>Abs</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aaee723d543692fbdffb43c626e4096d7</anchor>
      <arglist>(const T &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Exchange</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a1f50e41ce313458f43399b8290af5c20</anchor>
      <arglist>(T &amp;a, T &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>Max</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab6474c1090160d4fb52b10b61eba1fce</anchor>
      <arglist>(const T &amp;a, const T &amp;b, const T &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>Min</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab6f341c9dd7d51e10d8e7b22ebc48f19</anchor>
      <arglist>(const T &amp;a, const T &amp;b, const T &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a2f13f5b33eff15ecc9104390744f2d14</anchor>
      <arglist>(DebugStream &amp;__os, node&lt; real64_type &gt;::type const &amp;__n)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ae4e3da3c30ce2fe00b58df1927bdb756</anchor>
      <arglist>(NdebugStream &amp;os, node&lt; real64_type &gt;::type const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4dc438f11c911f0fb4abfb8dec206e3b</anchor>
      <arglist>(DebugStream &amp;__os, ublas::vector&lt; T &gt; const &amp;__n)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a5b68587fc7054610d8ed0601c784975e</anchor>
      <arglist>(NdebugStream &amp;__os, ublas::vector&lt; T &gt; const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a31f1fabd5c8b87d26cb04b7b9be12ecb</anchor>
      <arglist>(DebugStream &amp;__os, ublas::matrix&lt; T, Orient &gt; const &amp;__n)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a32fd9d1136c1ee4886db94ab09473bf5</anchor>
      <arglist>(NdebugStream &amp;__os, ublas::matrix&lt; T, Orient &gt; const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spy</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a57be0a3aed172426f0a7ea6c716d033d</anchor>
      <arglist>(MatrixType const &amp;__m, std::string const &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>ublas::matrix&lt; T, Orien &gt;</type>
      <name>average</name>
      <anchorfile>namespaceFeel_1_1glas.html</anchorfile>
      <anchor>a17edaf85b267efc769442176eef14f1a</anchor>
      <arglist>(ublas::matrix&lt; T, Orien &gt; const &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clean</name>
      <anchorfile>namespaceFeel_1_1glas.html</anchorfile>
      <anchor>ab014715346e37af190e15e0e52abf97f</anchor>
      <arglist>(T &amp;t, typename T::value_type const &amp;treshold=type_traits&lt; typename T::value_type &gt;::epsilon(), typename T::value_type const &amp;new_value=typename T::value_type(0.0))</arglist>
    </member>
    <member kind="function">
      <type>ublas::vector&lt; T &gt;</type>
      <name>linspace</name>
      <anchorfile>namespaceFeel_1_1glas.html</anchorfile>
      <anchor>a61fea0f800aed2463128c9ab8a7e7a08</anchor>
      <arglist>(T const &amp;__a, T const &amp;__b, size_type __N, int interior=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>randomize</name>
      <anchorfile>namespaceFeel_1_1glas.html</anchorfile>
      <anchor>a5ea85891d11c8cf19234c8a4cc4c58fd</anchor>
      <arglist>(T &amp;t)</arglist>
    </member>
    <member kind="variable">
      <type>const double</type>
      <name>Pi</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab6097da8bc17d065050751743fd5e76f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const double</type>
      <name>TGV</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a3f1a51d80d4ec7da77b8aa8054b005e2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>glastransposed.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>glastransposed_8hpp</filename>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>transposed_return&lt; L * &gt;::return_type</type>
      <name>transposed</name>
      <anchorfile>namespaceFeel_1_1glas.html</anchorfile>
      <anchor>af526263944039cc2e6b44ffd900fc267</anchor>
      <arglist>(Matrix &amp;m)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>graphcsr.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>graphcsr_8cpp</filename>
    <includes id="application_8hpp" name="application.hpp" local="no" imported="no">feel/feelcore/application.hpp</includes>
    <includes id="graphcsr_8hpp" name="graphcsr.hpp" local="no" imported="no">feel/feelalg/graphcsr.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>graphcsr.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>graphcsr_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="worldcomm_8hpp" name="worldcomm.hpp" local="no" imported="no">feel/feelcore/worldcomm.hpp</includes>
    <class kind="class">Feel::GraphCSR</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>iteration.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>iteration_8hpp</filename>
    <class kind="class">Feel::Iteration</class>
    <namespace>Feel</namespace>
    <member kind="typedef">
      <type>Iteration&lt; double &gt;</type>
      <name>iteration_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad70796961740ff5c8f2f091d50d3b88a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; iteration_type &gt;</type>
      <name>iteration_ptrtype</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a3714118185146aacf7689c486614becd</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>lu.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>lu_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <class kind="class">Feel::LU</class>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>Matrix::value_type</type>
      <name>det</name>
      <anchorfile>namespaceFeel_1_1details.html</anchorfile>
      <anchor>a4653efaeddc4ffec9441243a846a1443</anchor>
      <arglist>(Matrix const &amp;M, mpl::int_&lt; 1 &gt;)</arglist>
    </member>
    <member kind="function">
      <type>Matrix::value_type</type>
      <name>det</name>
      <anchorfile>namespaceFeel_1_1details.html</anchorfile>
      <anchor>a523156452963841daa0a9b0e99aa8458</anchor>
      <arglist>(Matrix const &amp;M, mpl::int_&lt; 2 &gt;)</arglist>
    </member>
    <member kind="function">
      <type>Matrix::value_type</type>
      <name>det</name>
      <anchorfile>namespaceFeel_1_1details.html</anchorfile>
      <anchor>a309667e58064c2c022136482a1e8eb08</anchor>
      <arglist>(Matrix const &amp;M, mpl::int_&lt; 3 &gt;)</arglist>
    </member>
    <member kind="function">
      <type>Matrix::value_type</type>
      <name>det</name>
      <anchorfile>namespaceFeel_1_1details.html</anchorfile>
      <anchor>a75471f9a291ef9e2abba23c07702934c</anchor>
      <arglist>(Matrix const &amp;M, mpl::int_&lt; 4 &gt;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>inverse</name>
      <anchorfile>namespaceFeel_1_1details.html</anchorfile>
      <anchor>a7d31d3f5550d86a4a8360fa1e7ee3cf8</anchor>
      <arglist>(Matrix const &amp;M, Matrix &amp;Minv, mpl::int_&lt; 1 &gt;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>inverse</name>
      <anchorfile>namespaceFeel_1_1details.html</anchorfile>
      <anchor>abd76c3eb26a9f9c84947168b80f86a0d</anchor>
      <arglist>(Matrix const &amp;M, Matrix &amp;Minv, mpl::int_&lt; 2 &gt;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>inverse</name>
      <anchorfile>namespaceFeel_1_1details.html</anchorfile>
      <anchor>af6e386175aa424c5a384a6864f02a90c</anchor>
      <arglist>(Matrix const &amp;M, Matrix &amp;Minv, mpl::int_&lt; 3 &gt;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>inverse</name>
      <anchorfile>namespaceFeel_1_1details.html</anchorfile>
      <anchor>ac5968b7f6f15cb3a151f09a5c5a94901</anchor>
      <arglist>(Matrix const &amp;__restrict__ M, Matrix &amp;__restrict__ Minv, typename Matrix::value_type const &amp;J, mpl::int_&lt; 1 &gt;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>inverse</name>
      <anchorfile>namespaceFeel_1_1details.html</anchorfile>
      <anchor>ae4851667c0576ecc0549264a979a564a</anchor>
      <arglist>(Matrix const &amp;__restrict__ M, Matrix &amp;__restrict__ Minv, typename Matrix::value_type const &amp;J, mpl::int_&lt; 2 &gt;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>inverse</name>
      <anchorfile>namespaceFeel_1_1details.html</anchorfile>
      <anchor>a0be1bd55666484d32d2c92290a6ccc22</anchor>
      <arglist>(Matrix const &amp;__restrict__ M, Matrix &amp;__restrict__ Minv, typename Matrix::value_type const &amp;J, mpl::int_&lt; 3 &gt;)</arglist>
    </member>
    <member kind="function">
      <type>Matrix::value_type</type>
      <name>det</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6e7f371b72232f1af939519095e5f888</anchor>
      <arglist>(Matrix const &amp;M)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>inverse</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af60e1492d6091108e7874985d297deab</anchor>
      <arglist>(Matrix const &amp;M, Matrix &amp;Minv)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>inverse</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a026bb88c7baecc1dd86c62634811c7a3</anchor>
      <arglist>(Matrix const &amp;__restrict__ M, Matrix &amp;__restrict__ Minv, typename Matrix::value_type const &amp;J)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>matrix.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>matrix_8hpp</filename>
  </compound>
  <compound kind="file">
    <name>matrixblock.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>matrixblock_8cpp</filename>
    <includes id="matrixblock_8hpp" name="matrixblock.hpp" local="no" imported="no">feel/feelalg/matrixblock.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>matrixblock.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>matrixblock_8hpp</filename>
    <includes id="matrixsparse_8hpp" name="matrixsparse.hpp" local="no" imported="no">feel/feelalg/matrixsparse.hpp</includes>
    <includes id="backend_8hpp" name="backend.hpp" local="no" imported="no">feel/feelalg/backend.hpp</includes>
    <class kind="class">Feel::BlocksBaseSparseMatrix</class>
    <class kind="class">Feel::BlocksSparseMatrix</class>
    <class kind="class">Feel::MatrixBlockBase</class>
    <class kind="class">Feel::MatrixBlock</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>matrixepetra.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>matrixepetra_8cpp</filename>
    <includes id="vectorepetra_8hpp" name="vectorepetra.hpp" local="no" imported="no">feel/feelalg/vectorepetra.hpp</includes>
    <includes id="matrixepetra_8hpp" name="matrixepetra.hpp" local="no" imported="no">feel/feelalg/matrixepetra.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>matrixepetra.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>matrixepetra_8hpp</filename>
    <includes id="application_8hpp" name="application.hpp" local="no" imported="no">feel/feelcore/application.hpp</includes>
    <includes id="matrixsparse_8hpp" name="matrixsparse.hpp" local="no" imported="no">feel/feelalg/matrixsparse.hpp</includes>
    <includes id="vectorepetra_8hpp" name="vectorepetra.hpp" local="no" imported="no">feel/feelalg/vectorepetra.hpp</includes>
  </compound>
  <compound kind="file">
    <name>matrixgmm.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>matrixgmm_8cpp</filename>
    <includes id="matrixgmm_8hpp" name="matrixgmm.hpp" local="no" imported="no">feel/feelalg/matrixgmm.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>matrixgmm.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>matrixgmm_8hpp</filename>
    <includes id="matrixsparse_8hpp" name="matrixsparse.hpp" local="no" imported="no">feel/feelalg/matrixsparse.hpp</includes>
    <includes id="vectorublas_8hpp" name="vectorublas.hpp" local="no" imported="no">feel/feelalg/vectorublas.hpp</includes>
    <class kind="class">Feel::MatrixGmm</class>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespacestd.html</anchorfile>
      <anchor>a259d83323a7b8e4eb83a3996e2df788d</anchor>
      <arglist>(std::ostream &amp;o, const boost::numeric::ublas::vector&lt; T &gt; &amp;m)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>matrixpetsc.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>matrixpetsc_8cpp</filename>
    <includes id="feelpetsc_8hpp" name="feelpetsc.hpp" local="no" imported="no">feel/feelcore/feelpetsc.hpp</includes>
    <includes id="vectorpetsc_8hpp" name="vectorpetsc.hpp" local="no" imported="no">feel/feelalg/vectorpetsc.hpp</includes>
    <includes id="matrixpetsc_8hpp" name="matrixpetsc.hpp" local="no" imported="no">feel/feelalg/matrixpetsc.hpp</includes>
  </compound>
  <compound kind="file">
    <name>matrixpetsc.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>matrixpetsc_8hpp</filename>
  </compound>
  <compound kind="file">
    <name>matrixshell.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>matrixshell_8hpp</filename>
    <class kind="class">Feel::MatrixShell</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>matrixshellsparse.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>matrixshellsparse_8cpp</filename>
    <includes id="matrixshellsparse_8hpp" name="matrixshellsparse.hpp" local="no" imported="no">feel/feelalg/matrixshellsparse.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>matrixshellsparse.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>matrixshellsparse_8hpp</filename>
    <includes id="matrixshell_8hpp" name="matrixshell.hpp" local="no" imported="no">feel/feelalg/matrixshell.hpp</includes>
    <includes id="matrixsparse_8hpp" name="matrixsparse.hpp" local="no" imported="no">feel/feelalg/matrixsparse.hpp</includes>
    <class kind="class">Feel::MatrixShellSparse</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>matrixsparse.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>matrixsparse_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="graphcsr_8hpp" name="graphcsr.hpp" local="no" imported="no">feel/feelalg/graphcsr.hpp</includes>
    <class kind="class">Feel::MatrixSparse</class>
    <namespace>Feel</namespace>
    <member kind="typedef">
      <type>MatrixSparse&lt; double &gt;</type>
      <name>d_sparse_matrix_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aef483a644266da4062004392d2c7f10c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; d_sparse_matrix_type &gt;</type>
      <name>d_sparse_matrix_ptrtype</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a0a86cf94eb8d6f91c3615f63e74624d9</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a85683418202ab99e52f81982f3571ae2</anchor>
      <arglist>(std::ostream &amp;os, const MatrixSparse&lt; T &gt; &amp;m)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>matrixtriplet.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>matrixtriplet_8hpp</filename>
    <class kind="class">Feel::MatrixTriplet</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>matrixublas.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>matrixublas_8hpp</filename>
    <class kind="class">Feel::MatrixUBlas</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>operatortrilinos.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>operatortrilinos_8hpp</filename>
    <includes id="matrixepetra_8hpp" name="matrixepetra.hpp" local="no" imported="no">feel/feelalg/matrixepetra.hpp</includes>
    <includes id="vectorepetra_8hpp" name="vectorepetra.hpp" local="no" imported="no">feel/feelalg/vectorepetra.hpp</includes>
    <includes id="solverlineartrilinos_8hpp" name="solverlineartrilinos.hpp" local="no" imported="no">feel/feelalg/solverlineartrilinos.hpp</includes>
  </compound>
  <compound kind="file">
    <name>preconditioner.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>preconditioner_8cpp</filename>
    <includes id="preconditioner_8hpp" name="preconditioner.hpp" local="no" imported="no">feel/feelalg/preconditioner.hpp</includes>
    <includes id="preconditionerpetsc_8hpp" name="preconditionerpetsc.hpp" local="no" imported="no">feel/feelalg/preconditionerpetsc.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>preconditioner.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>preconditioner_8hpp</filename>
    <includes id="matrixsparse_8hpp" name="matrixsparse.hpp" local="no" imported="no">feel/feelalg/matrixsparse.hpp</includes>
    <class kind="class">Feel::Preconditioner</class>
    <namespace>Feel</namespace>
    <member kind="typedef">
      <type>Preconditioner&lt; double &gt;</type>
      <name>preconditioner_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad6c0aa4c542104acbc3dd156bbf27ec3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; Preconditioner&lt; double &gt; &gt;</type>
      <name>preconditioner_ptrtype</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abb22c47bc02248d4061b13a37caee4b9</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_MEMBER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad8b9c610913b7d19b2e3d07c40615488</anchor>
      <arglist>((boost::shared_ptr&lt; Preconditioner&lt; double &gt; &gt;), preconditioner, tag,(required(pc,(PreconditionerType)))(optional(matrix,(d_sparse_matrix_ptrtype), d_sparse_matrix_ptrtype())(backend,(BackendType), BACKEND_PETSC)(pcfactormatsolverpackage,(MatSolverPackageType), MATSOLVER_PETSC)(worldcomm,*, WorldComm())))</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>preconditionerifpack.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>preconditionerifpack_8cpp</filename>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>preconditionerpetsc.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>preconditionerpetsc_8cpp</filename>
    <includes id="preconditionerpetsc_8hpp" name="preconditionerpetsc.hpp" local="no" imported="no">feel/feelalg/preconditionerpetsc.hpp</includes>
    <includes id="matrixpetsc_8hpp" name="matrixpetsc.hpp" local="no" imported="no">feel/feelalg/matrixpetsc.hpp</includes>
    <includes id="vectorpetsc_8hpp" name="vectorpetsc.hpp" local="no" imported="no">feel/feelalg/vectorpetsc.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>preconditionerpetsc.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>preconditionerpetsc_8hpp</filename>
    <includes id="feelpetsc_8hpp" name="feelpetsc.hpp" local="no" imported="no">feel/feelcore/feelpetsc.hpp</includes>
    <includes id="preconditioner_8hpp" name="preconditioner.hpp" local="no" imported="no">feel/feelalg/preconditioner.hpp</includes>
    <class kind="class">Feel::PreconditionerPetsc</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>solverbase.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>solverbase_8hpp</filename>
    <class kind="class">Feel::SolverBase</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>solvereigen.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>solvereigen_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="solvereigen_8hpp" name="solvereigen.hpp" local="no" imported="no">feel/feelalg/solvereigen.hpp</includes>
    <includes id="solvereigenslepc_8hpp" name="solvereigenslepc.hpp" local="no" imported="no">feel/feelalg/solvereigenslepc.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>po::options_description</type>
      <name>solvereigen_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab1352fb3297fdd0c417e899b59afa2f7</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>solvereigen.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>solvereigen_8hpp</filename>
    <includes id="matrixsparse_8hpp" name="matrixsparse.hpp" local="no" imported="no">feel/feelalg/matrixsparse.hpp</includes>
    <class kind="class">Feel::SolverEigen</class>
    <namespace>Feel</namespace>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_MEMBER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a2261a1386d3b588c8201251c378d7af7</anchor>
      <arglist>((typename SolverEigen&lt; double &gt;::eigenmodes_type), eigs, tag,(required(matrixA,(d_sparse_matrix_ptrtype))(matrixB,(d_sparse_matrix_ptrtype)))(optional(nev,(int), 1)(ncv,(int), 3)(backend,(BackendType), BACKEND_PETSC)(solver,(EigenSolverType), KRYLOVSCHUR)(problem,(EigenProblemType), GHEP)(transform,(SpectralTransformType), SHIFT)(spectrum,(PositionOfSpectrum), LARGEST_MAGNITUDE)(maxit,(size_type), 1000)(tolerance,(double), 1e-11)(verbose,(bool), false)))</arglist>
    </member>
    <member kind="function">
      <type>po::options_description</type>
      <name>solvereigen_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab1352fb3297fdd0c417e899b59afa2f7</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>solvereigenslepc.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>solvereigenslepc_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="feelslepc_8hpp" name="feelslepc.hpp" local="no" imported="no">feel/feelcore/feelslepc.hpp</includes>
    <includes id="solvereigenslepc_8hpp" name="solvereigenslepc.hpp" local="no" imported="no">feel/feelalg/solvereigenslepc.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>po::options_description</type>
      <name>solvereigenslepc_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a1ff9eb2d1e8570976034b26df27656ef</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>solvereigenslepc.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>solvereigenslepc_8hpp</filename>
    <includes id="solvereigen_8hpp" name="solvereigen.hpp" local="no" imported="no">feel/feelalg/solvereigen.hpp</includes>
    <includes id="vectorpetsc_8hpp" name="vectorpetsc.hpp" local="no" imported="no">feel/feelalg/vectorpetsc.hpp</includes>
    <includes id="matrixpetsc_8hpp" name="matrixpetsc.hpp" local="no" imported="no">feel/feelalg/matrixpetsc.hpp</includes>
  </compound>
  <compound kind="file">
    <name>solverlinearepetra.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>solverlinearepetra_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="matrixepetra_8hpp" name="matrixepetra.hpp" local="no" imported="no">feel/feelalg/matrixepetra.hpp</includes>
    <includes id="vectorepetra_8hpp" name="vectorepetra.hpp" local="no" imported="no">feel/feelalg/vectorepetra.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>boost::shared_ptr&lt; ML_Epetra::MultiLevelPreconditioner &gt;</type>
      <name>createMLPreconditioner</name>
      <anchorfile>namespaceFeel_1_1trilinos.html</anchorfile>
      <anchor>a540c5147e1cbaa13a516e117b8fb0251</anchor>
      <arglist>(Epetra_RowMatrix const &amp;mat, po::variables_map const &amp;vm)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>solverlinearpetsc.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>solverlinearpetsc_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
  </compound>
  <compound kind="file">
    <name>solverlinearpetsc.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>solverlinearpetsc_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="feelpetsc_8hpp" name="feelpetsc.hpp" local="no" imported="no">feel/feelcore/feelpetsc.hpp</includes>
    <includes id="matrixpetsc_8hpp" name="matrixpetsc.hpp" local="no" imported="no">feel/feelalg/matrixpetsc.hpp</includes>
    <includes id="vectorpetsc_8hpp" name="vectorpetsc.hpp" local="no" imported="no">feel/feelalg/vectorpetsc.hpp</includes>
  </compound>
  <compound kind="file">
    <name>solverlineartrilinos.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>solverlineartrilinos_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="solverlineartrilinos_8hpp" name="solverlineartrilinos.hpp" local="no" imported="no">feel/feelalg/solverlineartrilinos.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>solverlineartrilinos.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>solverlineartrilinos_8hpp</filename>
    <includes id="backendtrilinos_8hpp" name="backendtrilinos.hpp" local="no" imported="no">feel/feelalg/backendtrilinos.hpp</includes>
  </compound>
  <compound kind="file">
    <name>solvernonlinear.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>solvernonlinear_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="solvernonlinear_8hpp" name="solvernonlinear.hpp" local="no" imported="no">feel/feelalg/solvernonlinear.hpp</includes>
    <includes id="solvernonlinearpetsc_8hpp" name="solvernonlinearpetsc.hpp" local="no" imported="no">feel/feelalg/solvernonlinearpetsc.hpp</includes>
    <includes id="solvernonlineartrilinos_8hpp" name="solvernonlineartrilinos.hpp" local="no" imported="no">feel/feelalg/solvernonlineartrilinos.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>po::options_description</type>
      <name>nlsolver_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9310651aca14e583153bd22beeacc23f</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>solvernonlinear.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>solvernonlinear_8hpp</filename>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <includes id="preconditioner_8hpp" name="preconditioner.hpp" local="no" imported="no">feel/feelalg/preconditioner.hpp</includes>
    <class kind="class">Feel::SolverNonLinear</class>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>po::options_description</type>
      <name>nlsolver_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9310651aca14e583153bd22beeacc23f</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>solvernonlinearpetsc.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>solvernonlinearpetsc_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
  </compound>
  <compound kind="file">
    <name>solvernonlinearpetsc.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>solvernonlinearpetsc_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="solvernonlinear_8hpp" name="solvernonlinear.hpp" local="no" imported="no">feel/feelalg/solvernonlinear.hpp</includes>
    <includes id="matrixpetsc_8hpp" name="matrixpetsc.hpp" local="no" imported="no">feel/feelalg/matrixpetsc.hpp</includes>
    <includes id="vectorpetsc_8hpp" name="vectorpetsc.hpp" local="no" imported="no">feel/feelalg/vectorpetsc.hpp</includes>
  </compound>
  <compound kind="file">
    <name>solvernonlineartrilinos.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>solvernonlineartrilinos_8cpp</filename>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <includes id="solvernonlineartrilinos_8hpp" name="solvernonlineartrilinos.hpp" local="no" imported="no">feel/feelalg/solvernonlineartrilinos.hpp</includes>
  </compound>
  <compound kind="file">
    <name>solvernonlineartrilinos.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>solvernonlineartrilinos_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="solvernonlinear_8hpp" name="solvernonlinear.hpp" local="no" imported="no">feel/feelalg/solvernonlinear.hpp</includes>
    <includes id="matrixepetra_8hpp" name="matrixepetra.hpp" local="no" imported="no">feel/feelalg/matrixepetra.hpp</includes>
    <includes id="operatortrilinos_8hpp" name="operatortrilinos.hpp" local="no" imported="no">feel/feelalg/operatortrilinos.hpp</includes>
    <includes id="vectorepetra_8hpp" name="vectorepetra.hpp" local="no" imported="no">feel/feelalg/vectorepetra.hpp</includes>
  </compound>
  <compound kind="file">
    <name>solverumfpack.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>solverumfpack_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="solverumfpack_8hpp" name="solverumfpack.hpp" local="no" imported="no">feel/feelalg/solverumfpack.hpp</includes>
  </compound>
  <compound kind="file">
    <name>solverumfpack.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>solverumfpack_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <includes id="matrixtriplet_8hpp" name="matrixtriplet.hpp" local="no" imported="no">feel/feelalg/matrixtriplet.hpp</includes>
    <class kind="class">Feel::SolverUMFPACK</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>svd.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>svd_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <class kind="class">Feel::SVD</class>
    <class kind="class">Feel::SOrth</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>vector.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>vector_8cpp</filename>
    <includes id="matrixshell_8hpp" name="matrixshell.hpp" local="no" imported="no">feel/feelalg/matrixshell.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>vectorblock.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>vectorblock_8cpp</filename>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>vectorepetra.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>vectorepetra_8cpp</filename>
    <includes id="vectorepetra_8hpp" name="vectorepetra.hpp" local="no" imported="no">feel/feelalg/vectorepetra.hpp</includes>
    <includes id="matrixepetra_8hpp" name="matrixepetra.hpp" local="no" imported="no">feel/feelalg/matrixepetra.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>vectorepetra.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>vectorepetra_8hpp</filename>
    <includes id="matrixsparse_8hpp" name="matrixsparse.hpp" local="no" imported="no">feel/feelalg/matrixsparse.hpp</includes>
    <includes id="application_8hpp" name="application.hpp" local="no" imported="no">feel/feelcore/application.hpp</includes>
  </compound>
  <compound kind="file">
    <name>vectorpetsc.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>vectorpetsc_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="feelpetsc_8hpp" name="feelpetsc.hpp" local="no" imported="no">feel/feelcore/feelpetsc.hpp</includes>
    <includes id="vectorpetsc_8hpp" name="vectorpetsc.hpp" local="no" imported="no">feel/feelalg/vectorpetsc.hpp</includes>
    <includes id="matrixpetsc_8hpp" name="matrixpetsc.hpp" local="no" imported="no">feel/feelalg/matrixpetsc.hpp</includes>
  </compound>
  <compound kind="file">
    <name>vectorpetsc.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>vectorpetsc_8hpp</filename>
    <includes id="matrixsparse_8hpp" name="matrixsparse.hpp" local="no" imported="no">feel/feelalg/matrixsparse.hpp</includes>
  </compound>
  <compound kind="file">
    <name>vectorublas.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>vectorublas_8cpp</filename>
    <includes id="vectorublas_8hpp" name="vectorublas.hpp" local="no" imported="no">feel/feelalg/vectorublas.hpp</includes>
    <namespace>Feel</namespace>
    <namespace>Feel::detail</namespace>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_INSTANTIATE_VECTORUBLAS</name>
      <anchorfile>vectorublas_8cpp.html</anchorfile>
      <anchor>af6e5a27baa8d36e472c27f5d995f8983</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>vectorublas.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>vectorublas_8hpp</filename>
    <includes id="application_8hpp" name="application.hpp" local="no" imported="no">feel/feelcore/application.hpp</includes>
    <class kind="class">Feel::VectorUblas</class>
    <class kind="struct">Feel::VectorUblas::range</class>
    <class kind="struct">Feel::VectorUblas::slice</class>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>VectorUblas&lt; T &gt;</type>
      <name>element_product</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad82b78c47b3f9cd94a54c463643e79e0</anchor>
      <arglist>(VectorUblas&lt; T &gt; const &amp;v1, VectorUblas&lt; T &gt; const &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>VectorUblas&lt; T &gt;</type>
      <name>element_product</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad729b234ba3c004864dc5ead5203e59b</anchor>
      <arglist>(boost::shared_ptr&lt; VectorUblas&lt; T &gt; &gt; const &amp;v1, boost::shared_ptr&lt; VectorUblas&lt; T &gt; &gt; const &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>about.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>about_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="about_8hpp" name="about.hpp" local="no" imported="no">feel/feelcore/about.hpp</includes>
    <class kind="class">Feel::AboutDataPrivate</class>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9e126cb1abe01c7ef329b5d2bd285899</anchor>
      <arglist>(std::ostream &amp;os, AboutData const &amp;)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>about.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>about_8hpp</filename>
    <class kind="class">Feel::AboutPerson</class>
    <class kind="class">Feel::AboutData</class>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9e126cb1abe01c7ef329b5d2bd285899</anchor>
      <arglist>(std::ostream &amp;os, AboutData const &amp;)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>application.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>application_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="environment_8hpp" name="environment.hpp" local="no" imported="no">feel/feelcore/environment.hpp</includes>
    <includes id="application_8hpp" name="application.hpp" local="no" imported="no">feel/feelcore/application.hpp</includes>
    <includes id="feelpetsc_8hpp" name="feelpetsc.hpp" local="no" imported="no">feel/feelcore/feelpetsc.hpp</includes>
    <includes id="mpicompat_8hpp" name="mpicompat.hpp" local="no" imported="no">feel/feelcore/mpicompat.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>FEELPP_NO_EXPORT std::pair&lt; std::string, std::string &gt;</type>
      <name>at_option_parser</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a5f6ec689f1105d288427af8971bd5a42</anchor>
      <arglist>(std::string const &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>po::options_description</type>
      <name>benchmark_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a0269c708b09e8c351ed875ebb158032f</anchor>
      <arglist>(std::string const &amp;prefix=&quot;&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printErrors</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab96ae317757f5054b041640ba7ee3cda</anchor>
      <arglist>(std::ostream &amp;out, std::vector&lt; ptree::ptree &gt; const &amp;stats, std::string const &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printNumbers</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abbd50b946aadbc376f07cbf8a9280018</anchor>
      <arglist>(std::ostream &amp;out, std::vector&lt; ptree::ptree &gt; const &amp;stats, std::string const &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printData</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4b621f25ebd4aa710fa7d95cb1238001</anchor>
      <arglist>(std::ostream &amp;out, std::vector&lt; ptree::ptree &gt; const &amp;stats, std::string const &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printTime</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a21628a1468285f8c5c886317d3d8346c</anchor>
      <arglist>(std::ostream &amp;out, std::vector&lt; ptree::ptree &gt; const &amp;stats, std::string const &amp;key)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>application.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>application_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="environment_8hpp" name="environment.hpp" local="no" imported="no">feel/feelcore/environment.hpp</includes>
    <includes id="about_8hpp" name="about.hpp" local="no" imported="no">feel/feelcore/about.hpp</includes>
    <includes id="simget_8hpp" name="simget.hpp" local="no" imported="no">feel/feelcore/simget.hpp</includes>
    <class kind="class">Feel::Application</class>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>po::options_description</type>
      <name>benchmark_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a0269c708b09e8c351ed875ebb158032f</anchor>
      <arglist>(std::string const &amp;prefix=&quot;&quot;)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>applicationxml.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>applicationxml_8cpp</filename>
    <includes id="applicationxml_8hpp" name="applicationxml.hpp" local="no" imported="no">feel/feelcore/applicationxml.hpp</includes>
    <namespace>Feel</namespace>
    <namespace>Feel::detail</namespace>
    <member kind="function">
      <type>po::options_description</type>
      <name>makeOptions</name>
      <anchorfile>namespaceFeel_1_1detail.html</anchorfile>
      <anchor>a81c8a735ba70e0646779e641b4318259</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>applicationxml.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>applicationxml_8hpp</filename>
    <includes id="application_8hpp" name="application.hpp" local="no" imported="no">feel/feelcore/application.hpp</includes>
    <class kind="class">Feel::ApplicationXML</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>constants.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>constants_8hpp</filename>
    <class kind="class">Feel::math::Constant</class>
    <class kind="struct">Feel::math::pi_tag</class>
    <namespace>Feel</namespace>
    <namespace>Feel::math</namespace>
    <member kind="variable">
      <type>Constant&lt; pi_tag, float &gt; const</type>
      <name>pi</name>
      <anchorfile>namespaceFeel_1_1math_1_1float__constants.html</anchorfile>
      <anchor>a2226f85cd64532f6bdd8dd1c38a4afa7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Constant&lt; pi_tag, double &gt; const</type>
      <name>pi</name>
      <anchorfile>namespaceFeel_1_1math_1_1double__constants.html</anchorfile>
      <anchor>aa2be257d85e7245641ee3a13177c3d39</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Constant&lt; pi_tag, long double &gt; const</type>
      <name>pi</name>
      <anchorfile>namespaceFeel_1_1math_1_1long__double__constants.html</anchorfile>
      <anchor>a1ecfdb8e0c9c81125dd391f5774b4d76</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>debug.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>debug_8hpp</filename>
    <class kind="class">Feel::DebugStream</class>
    <class kind="class">Feel::NdebugStream</class>
    <namespace>Feel</namespace>
    <namespace>Feel::detail</namespace>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_FUNCINFO</name>
      <anchorfile>debug_8hpp.html</anchorfile>
      <anchor>a056d979961e269be4852338f5da56996</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_LINEINFO</name>
      <anchorfile>debug_8hpp.html</anchorfile>
      <anchor>aff1416101978c4351d18d90c07839d3d</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_DEBUG_FUNC_INFO</name>
      <anchorfile>debug_8hpp.html</anchorfile>
      <anchor>afdf4d6a134fdcb83145f36b63a128b40</anchor>
      <arglist>(area)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_DEBUG_BEGIN</name>
      <anchorfile>debug_8hpp.html</anchorfile>
      <anchor>a2765aa64d61f895c0d6a09aeffe3edb1</anchor>
      <arglist>(area)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_DEBUG_END</name>
      <anchorfile>debug_8hpp.html</anchorfile>
      <anchor>aa67a792efe6d941cca59959fe6295c5c</anchor>
      <arglist>(area)</arglist>
    </member>
    <member kind="typedef">
      <type>DebugStream &amp;(*</type>
      <name>LManipFunction</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a128065f601b01f3415a7acc5b0413cf5</anchor>
      <arglist>)(DebugStream &amp;)</arglist>
    </member>
    <member kind="typedef">
      <type>NdebugStream &amp;(*</type>
      <name>LNManipFunction</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>adbf1118e75d65702156bdab826c01682</anchor>
      <arglist>)(NdebugStream &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ae2f5cc9d4818d5183d32e0f46bd0bd81</anchor>
      <arglist>(DebugStream &amp;__s, T const *__t)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>backtrace</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9ddbf7cbdafe486102ea8e1595c8134c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>backtrace</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a96c2617b2514cbf6a8aaa6ea98893324</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>perror</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ae0a4372311e92acdb374a3b69f6ae60d</anchor>
      <arglist>(NdebugStream &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>endl</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab6955566da6efdd3349d1aabe8ab2f22</anchor>
      <arglist>(NdebugStream &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>flush</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4f2e149c86281ea44f4ce06aac161abe</anchor>
      <arglist>(NdebugStream &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Log</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aed8e06c4d5d01b3f4e5e2fb9b7d36953</anchor>
      <arglist>(int area, DebugStream::stprintf func)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Log</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af26c1400449d75d57e5c9f150de6e6ae</anchor>
      <arglist>(bool cond, int area, DebugStream::stprintf)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Debug</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a3f3055fe8659d182981035731bf6957f</anchor>
      <arglist>(int area, DebugStream::stprintf func)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Debug</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a92dd2ae2494873c601a01d7ee8f0ae3d</anchor>
      <arglist>(bool cond, int area, DebugStream::stprintf)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Warning</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a356deb1c43e40cf2d112e86ca0ce1280</anchor>
      <arglist>(int area)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Warning</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6d3b5091878d448a92cf2ad5078e7325</anchor>
      <arglist>(bool cond, int area)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Error</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a526247c8c47c857ce82809c7967ade5f</anchor>
      <arglist>(int area)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Error</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a26a26c520c7122d0a4ba38135308e288</anchor>
      <arglist>(bool cond, int area)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Fatal</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a062e9a1773c6b026e6d2f8070e852d25</anchor>
      <arglist>(int area)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Fatal</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ac37b7639cb589ac68598965162dd7977</anchor>
      <arglist>(bool cond, int area)</arglist>
    </member>
    <member kind="function">
      <type>Feel::DebugStream &amp;</type>
      <name>perror</name>
      <anchorfile>debug_8hpp.html</anchorfile>
      <anchor>a7af545ef77506aa3d86eb10be9397e05</anchor>
      <arglist>(Feel::DebugStream &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>Feel::DebugStream &amp;</type>
      <name>endl</name>
      <anchorfile>debug_8hpp.html</anchorfile>
      <anchor>aa0e3f696e510c1b71ec6aa5dc0ef5aa8</anchor>
      <arglist>(Feel::DebugStream &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>Feel::DebugStream &amp;</type>
      <name>flush</name>
      <anchorfile>debug_8hpp.html</anchorfile>
      <anchor>afc282405d209ca01cc006cf571961d18</anchor>
      <arglist>(Feel::DebugStream &amp;)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>environment.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>environment_8cpp</filename>
    <includes id="environment_8hpp" name="environment.hpp" local="no" imported="no">feel/feelcore/environment.hpp</includes>
    <includes id="feelpetsc_8hpp" name="feelpetsc.hpp" local="no" imported="no">feel/feelcore/feelpetsc.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>environment.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>environment_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <class kind="class">Feel::Environment</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>factory.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>factory_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <class kind="struct">Feel::FactoryDefaultError</class>
    <class kind="class">Feel::FactoryDefaultError::Exception</class>
    <class kind="class">Feel::Factory</class>
    <class kind="class">Feel::FactoryClone</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>feel.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>feel_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>std::string</type>
      <name>prefixvm</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>afdf3582bcb29eaf28321e1f5c48bfa36</anchor>
      <arglist>(std::string const &amp;prefix, std::string const &amp;opt, std::string const &amp;sep)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>feel.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>feel_8hpp</filename>
    <includes id="info_8hpp" name="info.hpp" local="no" imported="no">feel/feelcore/info.hpp</includes>
    <includes id="feelmacros_8hpp" name="feelmacros.hpp" local="no" imported="no">feel/feelcore/feelmacros.hpp</includes>
    <includes id="feelassert_8hpp" name="feelassert.hpp" local="no" imported="no">feel/feelcore/feelassert.hpp</includes>
    <includes id="flags_8hpp" name="flags.hpp" local="no" imported="no">feel/feelcore/flags.hpp</includes>
    <includes id="serialization_8hpp" name="serialization.hpp" local="no" imported="no">feel/feelcore/serialization.hpp</includes>
    <includes id="debug_8hpp" name="debug.hpp" local="no" imported="no">feel/feelcore/debug.hpp</includes>
    <class kind="class">Feel::detail::no_int</class>
    <class kind="struct">Feel::detail::integer</class>
    <class kind="struct">Feel::detail::real</class>
    <class kind="struct">Feel::detail::unsigned_integer</class>
    <class kind="struct">Feel::meta::remove_all</class>
    <namespace>Feel</namespace>
    <namespace>Feel::detail</namespace>
    <member kind="define">
      <type>#define</type>
      <name>OMP_SET_NUM_THREADS</name>
      <anchorfile>feel_8hpp.html</anchorfile>
      <anchor>aaa59626371a7e1cf9a2dad8657535023</anchor>
      <arglist>(num)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>OMP_GET_NUM_THREADS</name>
      <anchorfile>feel_8hpp.html</anchorfile>
      <anchor>a67918fd15a1cddd6dbc0c6b46edad8e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>OMP_SET_DYNAMIC</name>
      <anchorfile>feel_8hpp.html</anchorfile>
      <anchor>a0262a14a4a34032d0e99bbf440739ea5</anchor>
      <arglist>(num)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>OMP_SET_NESTED</name>
      <anchorfile>feel_8hpp.html</anchorfile>
      <anchor>aa6bccd5a68ff9621a72f4516c43b3f5f</anchor>
      <arglist>(num)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>OMP_GET_WTIME</name>
      <anchorfile>feel_8hpp.html</anchorfile>
      <anchor>a40f929660b98b96f92d79bb060e6ce63</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>OMP_GET_WTICK</name>
      <anchorfile>feel_8hpp.html</anchorfile>
      <anchor>adc8e7e4bbd5e6e060a0831c6e29bc434</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>Real</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aff8c989dddf67ff63dff34793ec0509f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>scalar_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ae93119144bffa7ed368079a659665469</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::complex&lt; double &gt;</type>
      <name>complex_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a400c8901e57a2fb179676de769c3f098</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::int8_t</type>
      <name>int8_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a422bdf5e2ca1e9311a1f3ce426dcfafb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::int16_t</type>
      <name>int16_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aa29cb17e9d0d5fb6e5269c078b4bc948</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::int32_t</type>
      <name>int32_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a73b5d18a1df0e94bb344ced592dc1df2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::int64_t</type>
      <name>int64_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a00aef995ca042fb6949bcf95c4c0aca9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>detail::real&lt; 32 &gt;::type</type>
      <name>real32_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a8f206c5d1c80e879bc590f00c5cc8dc5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>detail::real&lt; 64 &gt;::type</type>
      <name>real64_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a0e4929a45457fdc27e1055122bfff7a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::uint8_t</type>
      <name>uint8_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aed52446c0413dd3b45f6c009d0ad530b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::uint16_t</type>
      <name>uint16_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a7b535239159347f393440013431cb827</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::uint32_t</type>
      <name>uint32_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad0e34887a7aeab02ea0f36ae69d047a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::uint64_t</type>
      <name>uint64_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>acc4d2df760bc5f3bd17b5e255472fe64</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int64_type</type>
      <name>flag_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a5137d5a00a3a883290b5742501e7b5a8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>uint16_type</type>
      <name>dim_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a5155120d1dda406c1dde284a66a1b000</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>size_t</type>
      <name>size_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a285d572c85de361b3f3e2695b41a4ce0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ignore_unused_variable_warning</name>
      <anchorfile>namespaceFeel_1_1detail.html</anchorfile>
      <anchor>a7e353c428da9966c9111e435e4b4ab42</anchor>
      <arglist>(const T &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_STATIC_ASSERT</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6bf4800b7bf8abcb60ba91b2ce38d549</anchor>
      <arglist>((boost::is_same&lt; real32_type, float &gt;::value))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_STATIC_ASSERT</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a74f2222b08f5abee0821b9e6a8cc5a14</anchor>
      <arglist>((boost::is_same&lt; real64_type, double &gt;::value))</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>prefixvm</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>afdf3582bcb29eaf28321e1f5c48bfa36</anchor>
      <arglist>(std::string const &amp;prefix, std::string const &amp;opt, std::string const &amp;sep)</arglist>
    </member>
    <member kind="variable">
      <type>const int64_type</type>
      <name>invalid_flag_type_value</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a33cad1849779384dc3e64e2f3f8689bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const uint8_type</type>
      <name>invalid_uint8_type_value</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a79ed5b16106b4f440ed3e76a8cb12ad3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const uint16_type</type>
      <name>invalid_uint16_type_value</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a74681da1036cc5b236aabef05d8a8f87</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const uint32_type</type>
      <name>invalid_uint32_type_value</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a0b3f2923da6adec210a20cfc4d3cb72b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const uint64_type</type>
      <name>invalid_uint64_type_value</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4b975776624528b35464b71fd1a6603a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const dim_type</type>
      <name>invalid_dim_type_value</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a06fcd499069e30f5e897e6e1187c65d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const size_type</type>
      <name>invalid_size_type_value</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a0d4d77cd361adda45d27d72ff0357e55</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>feelassert.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>feelassert_8hpp</filename>
    <member kind="define">
      <type>#define</type>
      <name>ERROR_MSG</name>
      <anchorfile>feelassert_8hpp.html</anchorfile>
      <anchor>a7a8d745c29197388bfe267822afd8899</anchor>
      <arglist>(A)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ASSERT0</name>
      <anchorfile>feelassert_8hpp.html</anchorfile>
      <anchor>a21e4a421286bccf02a1289541b915b77</anchor>
      <arglist>(X, A)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ASSERT_PRE0</name>
      <anchorfile>feelassert_8hpp.html</anchorfile>
      <anchor>a5db5e8dbe5fa9a2bee2c4b9f6cdad29e</anchor>
      <arglist>(X, A)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ASSERT_POS0</name>
      <anchorfile>feelassert_8hpp.html</anchorfile>
      <anchor>a9c1ba0a70219fc02dca5476bdf72263c</anchor>
      <arglist>(X, A)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ASSERT_INV0</name>
      <anchorfile>feelassert_8hpp.html</anchorfile>
      <anchor>a9c72c644818c1e2e429a0913f416e2d7</anchor>
      <arglist>(X, A)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ASSERT_BD0</name>
      <anchorfile>feelassert_8hpp.html</anchorfile>
      <anchor>aa61031ccb6e070a94b477ead98bc3760</anchor>
      <arglist>(X)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>feelmacros.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>feelmacros_8hpp</filename>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_GNUC_AT_LEAST</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>acb81544b836953a9f31b4fdc345aa1cf</anchor>
      <arglist>(x, y)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_CLANG_AT_LEAST</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>ab7af794e85639a1ac6d42b19974ac544</anchor>
      <arglist>(x, y)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_CONSTRUCTOR_BEGIN</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>a168b9b9a2dfe95c8adab772e295875bf</anchor>
      <arglist>(Area, A)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_CONSTRUCTOR</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>ac6736ec397a74f9ff5af08be6ef6f349</anchor>
      <arglist>(Area, A)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>CONSTRUCTOR</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>ab2d9c3a2773605b72df85a7a0de8fb61</anchor>
      <arglist>(A)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_CONSTRUCTOR_END</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>a9bae6b8d0b7e2658efaaf8a074c1e3ff</anchor>
      <arglist>(Area, A)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_DESTRUCTOR_BEGIN</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>a3ca7d6cf3e94bc974ea4240e313a4ef4</anchor>
      <arglist>(Area, A)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_DESTRUCTOR</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>a80b9356fe234042538181fd60a4c3393</anchor>
      <arglist>(Area, A)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>DESTRUCTOR</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>aab535b0410d5986c86401e8f1bae02a4</anchor>
      <arglist>(A)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_DESTRUCTOR_END</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>af71bf62dbc99d576615b60c9a205f0cf</anchor>
      <arglist>(Area, A)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>INLINE</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>a2eb6f9e0395b47b8d5e3eeae4fe0c116</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_RESTRICT</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>a49e458af612db77d6a982699b783eab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_EXPORT</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>ab949cc7d41e83108ffd17dd9bfd5dd5b</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_NO_EXPORT</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>afd589deb669a64692fc8abc1e1a4c0d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_PACKED</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>a059b972cbc19169fca22f89ffabacdb9</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_DEPRECATED</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>a0b3a75b0b154ecf75a6a1c7878d942cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_ISLIKELY</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>a742a1074cdeaeb4ab486a264285fe5fe</anchor>
      <arglist>(x)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_ISUNLIKELY</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>a63649bd649ac40de4ad068605ebd6a23</anchor>
      <arglist>(x)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_PREFETCH</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>ad2ea97bee2da693149a3d23e77bb5bf7</anchor>
      <arglist>(x, rw, locality)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_IS_CONSTANT</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>abd925574d4c74d833d509f225782423f</anchor>
      <arglist>(n)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_DEBUG_VAR</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>ae1047b19c7799995bfe3f9ac78e05ddd</anchor>
      <arglist>(x)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_ALWAYS_INLINE_ATTRIB</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>a9e922b2f9ae779127f1a3776b7c0bc7a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_STRONG_INLINE</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>a886165e5daec0a9fd1443d09d36a24f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_DONT_INLINE</name>
      <anchorfile>feelmacros_8hpp.html</anchorfile>
      <anchor>a794a63cfeec554fdde254ea497f695c5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>feelpetsc.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>feelpetsc_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>PETSC_VERSION_LESS_THAN</name>
      <anchorfile>feelpetsc_8hpp.html</anchorfile>
      <anchor>a6ce00c673b9e3d185cef68b30357413f</anchor>
      <arglist>(major, minor, subminor)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PETSC_VERSION_GREATER_THAN</name>
      <anchorfile>feelpetsc_8hpp.html</anchorfile>
      <anchor>a3e07b1e43536a58c98166bd6950bdc29</anchor>
      <arglist>(major, minor, subminor)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>PETSC_VERSION_GREATER_OR_EQUAL_THAN</name>
      <anchorfile>feelpetsc_8hpp.html</anchorfile>
      <anchor>a3b21c024a18fe659cf408a9070acc563</anchor>
      <arglist>(major, minor, subminor)</arglist>
    </member>
    <member kind="typedef">
      <type>PetscTruth</type>
      <name>PetscBool</name>
      <anchorfile>feelpetsc_8hpp.html</anchorfile>
      <anchor>ae2ff00db32a1376e3b6dea97bc390076</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>FEELPP_STRONG_INLINE int</type>
      <name>VecDestroy</name>
      <anchorfile>namespaceFeel_1_1PETSc.html</anchorfile>
      <anchor>a70fd904fa32db7d33b09d980766b540f</anchor>
      <arglist>(Vec &amp;vec)</arglist>
    </member>
    <member kind="function">
      <type>FEELPP_STRONG_INLINE int</type>
      <name>VecScatterDestroy</name>
      <anchorfile>namespaceFeel_1_1PETSc.html</anchorfile>
      <anchor>accfdd63bced21c394b84373a0e500648</anchor>
      <arglist>(VecScatter &amp;scatter)</arglist>
    </member>
    <member kind="function">
      <type>FEELPP_STRONG_INLINE int</type>
      <name>MatDestroy</name>
      <anchorfile>namespaceFeel_1_1PETSc.html</anchorfile>
      <anchor>a7a9a93bd44027d6c62fff0ad88aa5841</anchor>
      <arglist>(Mat &amp;mat)</arglist>
    </member>
    <member kind="function">
      <type>FEELPP_STRONG_INLINE int</type>
      <name>ISDestroy</name>
      <anchorfile>namespaceFeel_1_1PETSc.html</anchorfile>
      <anchor>ad1fb8fc54aa0b5c485cd3e1436fa1ba8</anchor>
      <arglist>(IS &amp;is)</arglist>
    </member>
    <member kind="function">
      <type>FEELPP_STRONG_INLINE int</type>
      <name>KSPDestroy</name>
      <anchorfile>namespaceFeel_1_1PETSc.html</anchorfile>
      <anchor>a7e12d16675000737db9813d08c9f0e5d</anchor>
      <arglist>(KSP &amp;ksp)</arglist>
    </member>
    <member kind="function">
      <type>FEELPP_STRONG_INLINE int</type>
      <name>PCDestroy</name>
      <anchorfile>namespaceFeel_1_1PETSc.html</anchorfile>
      <anchor>a3a05a551beb37cb529d5a32d4054af25</anchor>
      <arglist>(PC &amp;pc)</arglist>
    </member>
    <member kind="function">
      <type>FEELPP_STRONG_INLINE int</type>
      <name>MatNullSpaceDestroy</name>
      <anchorfile>namespaceFeel_1_1PETSc.html</anchorfile>
      <anchor>a184e2e6f8747c4c73c52a36372f7d374</anchor>
      <arglist>(MatNullSpace &amp;nullsp)</arglist>
    </member>
    <member kind="function">
      <type>FEELPP_STRONG_INLINE int</type>
      <name>SNESDestroy</name>
      <anchorfile>namespaceFeel_1_1PETSc.html</anchorfile>
      <anchor>a77ea86e47570600cf30bafeb3b777031</anchor>
      <arglist>(SNES &amp;snes)</arglist>
    </member>
    <member kind="function">
      <type>FEELPP_STRONG_INLINE int</type>
      <name>PetscViewerDestroy</name>
      <anchorfile>namespaceFeel_1_1PETSc.html</anchorfile>
      <anchor>af483ceefd71f37fcd0715d7d87551c92</anchor>
      <arglist>(PetscViewer &amp;petsc_viewer)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>feelslepc.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>feelslepc_8hpp</filename>
    <includes id="feelpetsc_8hpp" name="feelpetsc.hpp" local="no" imported="no">feel/feelcore/feelpetsc.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>FEELPP_STRONG_INLINE int</type>
      <name>EPSDestroy</name>
      <anchorfile>namespaceFeel_1_1SLEPc.html</anchorfile>
      <anchor>af675d40e40cbbef446b3e2c2161d154b</anchor>
      <arglist>(EPS &amp;eps)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>flags.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>flags_8hpp</filename>
    <namespace>Feel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_DECLARE_FLAGS</name>
      <anchorfile>flags_8hpp.html</anchorfile>
      <anchor>ab18f18e4c36cf0cd852d4fcae441f035</anchor>
      <arglist>(Flags, Enum)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>info.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>info_8cpp</filename>
    <includes id="info_8hpp" name="info.hpp" local="no" imported="no">feel/feelcore/info.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>stringize2</name>
      <anchorfile>info_8cpp.html</anchorfile>
      <anchor>a474932e11b189ad0a43f1cb568584b84</anchor>
      <arglist>(x)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>stringize</name>
      <anchorfile>info_8cpp.html</anchorfile>
      <anchor>a5331f4fe608ac69e29116bfbf9e6134c</anchor>
      <arglist>(x)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>info.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>info_8hpp</filename>
    <class kind="class">Feel::Info</class>
    <namespace>Feel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_MAKE_VERSION</name>
      <anchorfile>info_8hpp.html</anchorfile>
      <anchor>a7d8c4e4403142ddbe31d9f7dd532bcc4</anchor>
      <arglist>(a, b, c)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_IS_VERSION</name>
      <anchorfile>info_8hpp.html</anchorfile>
      <anchor>a20f2474481cef6fab0532baf99e2d3b6</anchor>
      <arglist>(a, b, c)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>mpicompat.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>mpicompat_8hpp</filename>
  </compound>
  <compound kind="file">
    <name>serialization.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>serialization_8hpp</filename>
    <member kind="function">
      <type>void</type>
      <name>load</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>a4e88ee17cf26424d6c94f8a1681ae942</anchor>
      <arglist>(Archive &amp;ar, boost::multi_array&lt; double, 2 &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>a816986be03baba08700ca6cce36e4dae</anchor>
      <arglist>(Archive &amp;ar, const boost::multi_array&lt; double, 2 &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>serialize</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>a6c9210df08ad07168e3cb9f5fcaf6c33</anchor>
      <arglist>(Archive &amp;ar, boost::multi_array&lt; double, 2 &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>afb9c1ef21b05c2776573bf3002c9cc14</anchor>
      <arglist>(Archive &amp;ar, boost::multi_array&lt; double, 3 &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>ab7fd705e1709a7e29160384f3a557ce1</anchor>
      <arglist>(Archive &amp;ar, const boost::multi_array&lt; double, 3 &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>serialize</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>aee155e0cc28555c2769f3717e2474a1e</anchor>
      <arglist>(Archive &amp;ar, boost::multi_array&lt; double, 3 &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>a0a04bb84ab5280a67a3b8fa95c8a4d53</anchor>
      <arglist>(Archive &amp;ar, boost::multi_array&lt; double, 4 &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>ab9d079f70e9d7d814705b48efa4a36be</anchor>
      <arglist>(Archive &amp;ar, const boost::multi_array&lt; double, 4 &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>serialize</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>a33cb8ba25ce252fb5ae074829d84ca05</anchor>
      <arglist>(Archive &amp;ar, boost::multi_array&lt; double, 4 &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>af4fa92d83d451de141e5f04ef650e09e</anchor>
      <arglist>(Archive &amp;ar, Eigen::MatrixXd &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>a51e58da59f1c0cbb34fb90390ffd41ac</anchor>
      <arglist>(Archive &amp;ar, const Eigen::MatrixXd &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>serialize</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>a4b1acbb330a9452be2fba3c1dd9809a3</anchor>
      <arglist>(Archive &amp;ar, Eigen::MatrixXd &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>aa4d71c88bc7f42d813ab5ed5dd2a40d9</anchor>
      <arglist>(Archive &amp;ar, Eigen::VectorXd &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>ab63e8b7f809157090d30d24a34f790ed</anchor>
      <arglist>(Archive &amp;ar, const Eigen::VectorXd &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>serialize</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>a3bf0601471e0b4b546c4663680bb3a02</anchor>
      <arglist>(Archive &amp;ar, Eigen::VectorXd &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>abc766a2380dc00faef37f31f8465fc2d</anchor>
      <arglist>(Archive &amp;ar, Eigen::Matrix&lt; double, N, M &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>a7ce95f7a235d9ca96d9a3a973e9c1118</anchor>
      <arglist>(Archive &amp;ar, const Eigen::Matrix&lt; double, N, M &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>serialize</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>a46e6167aa938af42e3b75c78a6410ac8</anchor>
      <arglist>(Archive &amp;ar, Eigen::Matrix&lt; double, N, M &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>ae486cec1730ae68bca0f6c09d0ad04cf</anchor>
      <arglist>(Archive &amp;ar, boost::multi_array&lt; Eigen::MatrixXd, 2 &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>a813144a885a602231be8c6d8bca7c215</anchor>
      <arglist>(Archive &amp;ar, const boost::multi_array&lt; Eigen::MatrixXd, 2 &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>serialize</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>a5560557982ce001c12333d5fcb8c29a3</anchor>
      <arglist>(Archive &amp;ar, boost::multi_array&lt; Eigen::MatrixXd, 2 &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>a82bdc5834aa6d231b793082fcc8ee1a1</anchor>
      <arglist>(Archive &amp;ar, boost::multi_array&lt; Eigen::VectorXd, 2 &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>a80336c93e0eeba9fce0c33190ef93581</anchor>
      <arglist>(Archive &amp;ar, const boost::multi_array&lt; Eigen::VectorXd, 2 &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>serialize</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>a87e440b7946363147db8a55e5c125e21</anchor>
      <arglist>(Archive &amp;ar, boost::multi_array&lt; Eigen::VectorXd, 2 &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>a126caf52000d9f0fd5bf656c3665d81a</anchor>
      <arglist>(Archive &amp;ar, boost::tuple&lt; T1, T2 &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>a23416f85eb006edc1003164b455881b1</anchor>
      <arglist>(Archive &amp;ar, boost::tuple&lt; T1, T2 &gt; const &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>serialize</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>adb2ec27015eda1f5f61208c2813d790c</anchor>
      <arglist>(Archive &amp;ar, boost::tuple&lt; T1, T2 &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>a5f666f269aefcdc94f272360e75875bd</anchor>
      <arglist>(Archive &amp;ar, boost::tuple&lt; T1, T2, T3 &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>ab3c356d84b59df0c544615483a12969d</anchor>
      <arglist>(Archive &amp;ar, boost::tuple&lt; T1, T2, T3 &gt; const &amp;t, const unsigned int file_version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>serialize</name>
      <anchorfile>namespaceboost_1_1serialization.html</anchorfile>
      <anchor>a45b0a42c9daefc9df705174a70d2fc02</anchor>
      <arglist>(Archive &amp;ar, boost::tuple&lt; T1, T2, T3 &gt; &amp;t, const unsigned int file_version)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>simget.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>simget_8cpp</filename>
    <includes id="application_8hpp" name="application.hpp" local="no" imported="no">feel/feelcore/application.hpp</includes>
    <includes id="simget_8hpp" name="simget.hpp" local="no" imported="no">feel/feelcore/simget.hpp</includes>
    <includes id="environment_8hpp" name="environment.hpp" local="no" imported="no">feel/feelcore/environment.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>simget.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>simget_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="about_8hpp" name="about.hpp" local="no" imported="no">feel/feelcore/about.hpp</includes>
    <includes id="factory_8hpp" name="factory.hpp" local="no" imported="no">feel/feelcore/factory.hpp</includes>
    <includes id="singleton_8hpp" name="singleton.hpp" local="no" imported="no">feel/feelcore/singleton.hpp</includes>
    <class kind="class">Feel::Simget</class>
    <namespace>Feel</namespace>
    <member kind="typedef">
      <type>Singleton&lt; Factory&lt; Simget, std::string &gt; &gt;</type>
      <name>SimgetFactory</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ac9648381161062499cc054fa4b0de17e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>singleton.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>singleton_8hpp</filename>
    <class kind="class">Feel::Singleton</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>timermap.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>timermap_8hpp</filename>
    <class kind="struct">Feel::TimerPair</class>
    <class kind="class">Feel::TimerMap</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>traits.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelalg/</path>
    <filename>feelalg_2traits_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>typetraits.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>typetraits_8hpp</filename>
    <class kind="struct">Feel::type_traits</class>
    <namespace>Feel</namespace>
    <namespace>Feel::math</namespace>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_FUNC_NAME</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>ab0270ec79c8cd21221fd86b33f59908e</anchor>
      <arglist>(T)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_FUNC_CALL</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>ae42b822f179a742e5c9f2b5d978c762a</anchor>
      <arglist>(T)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_FUNC_NONS</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>afb237f9480406857323070030e0716cc</anchor>
      <arglist>(T)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_STD_FUNCS</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>aa368a9c4201b965e3fea36924ce83a81</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_STDCOMPLEX_FUNCS</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>abf819ec7086f5ca3e02125790fe7ed4d</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_STD_BINARY_FUNCS</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>a0614081743bf32742b328dd2204c6530</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_MP_FUNCS</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>a6405763c16250470b912134d0e109b92</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_MP_BINARY_FUNCS</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>adc7db60546f83dd00cebefb31adbd632</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_GLOBAL_FUNCS</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>a70b4c4b3907d5980ae447f14e65ec131</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_GLOBAL_BINARY_FUNCS</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>adcfb8a44d1765d72feae0a7ac8205723</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_TRAITS_FUNC_REAL</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>aeba850b69a25761cc477d1dddd47e740</anchor>
      <arglist>(T, t)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_TRAITS_FUNC_IMAG</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>a761a369f73a07ad1d92194e048bccd2b</anchor>
      <arglist>(T, t)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_TRAITS_FUNC_CONJ</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>a0e403e8da0b72f217d6af2fa3b4bd64c</anchor>
      <arglist>(T, t)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_TRAITS_TYPE</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>a90edb6262dcdff238a28fa0ab0b6c1ab</anchor>
      <arglist>(T)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_TRAITS_REAL_TYPE</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>a0d136a7f1af2c7c64d91b8104d845093</anchor>
      <arglist>(T)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_TRAITS_IS_FLOATING</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>ad26bc6e1bbc94150017c941ce12370bd</anchor>
      <arglist>(T)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_TRAITS_IS_COMPLEX</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>a49953c24f8ed54f266cd2d7128db6e1e</anchor>
      <arglist>(T)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_TRAITS_RANK</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>ae5b321a6268f3c7691a095059df81a1a</anchor>
      <arglist>(T)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_TRAITS_EPSILON</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>aa5c968a5e786951cde0132672b406428</anchor>
      <arglist>(T)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_TRAITS_FUNC_TYPE</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>a7cfa626b440a6e7862da90997c1ca83d</anchor>
      <arglist>(T)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>QD_NTYPES</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>ac5bdb67911f3ca889b53ec64ee364b87</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>QD_DD_TYPE</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>a61959551413d370bed39bc1908686acf</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>QD_QD_TYPE</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>abced04d0f1df4c95976cd3de6067e61a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>MPFR_NTYPES</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>a801570906b55d66ff0e44f649063b522</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>MPFR_MP_TYPE</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>aeb1e7ee65e859d820461ccb8fb29d815</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_NUMERICAL_NTYPES</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>aa3b6fbd67a720683ee06254ab99fed60</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_TRAITS_TYPES</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>a23c3ca9397b9b047bcf0c4d8f6dfdd8b</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_TRAITS_OP</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>a2b3fae9718e587ee99d7db45b8de5379</anchor>
      <arglist>(_, T)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_TRAITS_OP_CODE</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>ae7b219f0faf98971cd7ecbb2269767d5</anchor>
      <arglist>(T)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_PRED_FUNC</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>a7903c007e90af3bdac437daedbc682dd</anchor>
      <arglist>(d, data, elem)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_UNARY_FUNCS_OP</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>a07b2cdc63fdf48e9ff38d4bb772c1aed</anchor>
      <arglist>(_, TF)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_UNARY_FUNCS_OP_CODE</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>a98b195fe5a30af14c0fe862f7e2fef22</anchor>
      <arglist>(T, F)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_BINARY_FUNCS_OP</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>a3712b09a711779005cbe94444a3980a1</anchor>
      <arglist>(_, TF)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_BINARY_FUNCS_OP_CODE</name>
      <anchorfile>typetraits_8hpp.html</anchorfile>
      <anchor>afd932d8d495606b16ec980d74ff3846f</anchor>
      <arglist>(T, F)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PP_LIST_FOR_EACH_PRODUCT</name>
      <anchorfile>namespaceFeel_1_1math.html</anchorfile>
      <anchor>a82f8b5a81bd28ed2ab8c4f8a02562e8f</anchor>
      <arglist>(FEELPP_UNARY_FUNCS_OP, 2,(BOOST_PP_LIST_FILTER(FEELPP_PRED_FUNC, 0, FEELPP_TRAITS_TYPES), FEELPP_STD_FUNCS)) BOOST_PP_LIST_FOR_EACH_PRODUCT(FEELPP_UNARY_FUNCS_OP</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PP_LIST_FILTER</name>
      <anchorfile>namespaceFeel_1_1math.html</anchorfile>
      <anchor>a7568f0d83dfe7ef1df70e9ac3de1fdf7</anchor>
      <arglist>(FEELPP_PRED_FUNC, 1, FEELPP_TRAITS_TYPES)</arglist>
    </member>
    <member kind="function">
      <type>FEELPP_MP_FUNCS</type>
      <name>BOOST_PP_LIST_FOR_EACH_PRODUCT</name>
      <anchorfile>namespaceFeel_1_1math.html</anchorfile>
      <anchor>a1033249a447715de90e457783bfe891f</anchor>
      <arglist>(FEELPP_UNARY_FUNCS_OP, 2,(BOOST_PP_LIST_FILTER(FEELPP_PRED_FUNC, 2, FEELPP_TRAITS_TYPES), FEELPP_GLOBAL_FUNCS)) BOOST_PP_LIST_FOR_EACH_PRODUCT(FEELPP_UNARY_FUNCS_OP</arglist>
    </member>
    <member kind="function">
      <type>FEELPP_MP_FUNCS</type>
      <name>BOOST_PP_LIST_FILTER</name>
      <anchorfile>namespaceFeel_1_1math.html</anchorfile>
      <anchor>af7177804e5a409f545dc48c2e65e0e5b</anchor>
      <arglist>(FEELPP_PRED_FUNC, 3, FEELPP_TRAITS_TYPES)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PP_LIST_FOR_EACH_PRODUCT</name>
      <anchorfile>namespaceFeel_1_1math.html</anchorfile>
      <anchor>abecbc19dec1a35eaf3bfe19f0a6e781f</anchor>
      <arglist>(FEELPP_BINARY_FUNCS_OP, 2,(BOOST_PP_LIST_FILTER(FEELPP_PRED_FUNC, 0, FEELPP_TRAITS_TYPES), FEELPP_STD_BINARY_FUNCS)) BOOST_PP_LIST_FOR_EACH_PRODUCT(FEELPP_BINARY_FUNCS_OP</arglist>
    </member>
    <member kind="variable">
      <type>const double</type>
      <name>factor_from_eps</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a559102856463db18fe24e9d6241533ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const float</type>
      <name>factor_from_eps_fl</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a97f4cc26df35977a346e0c745f1e99e8</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>visitor.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>visitor_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <class kind="class">Feel::VisitorBase</class>
    <class kind="class">Feel::Visitor</class>
    <class kind="class">Feel::VisitorList</class>
    <class kind="class">Feel::VisitorBaseImpl&lt; mpl::list&lt; Head, Tail &gt;, R &gt;</class>
    <class kind="class">Feel::VisitorBaseImpl&lt; mpl::list&lt; Head &gt;, R &gt;</class>
    <class kind="class">Feel::VisitableCatchAllDefault</class>
    <class kind="class">Feel::VisitableBase</class>
    <class kind="class">Feel::VisitorCyclic</class>
    <namespace>Feel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP_DEFINE_VISITABLE</name>
      <anchorfile>visitor_8hpp.html</anchorfile>
      <anchor>aae1287894066922e0d7509a07bc489e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FEELPP__DEFINE_CYCLIC_VISITABLE</name>
      <anchorfile>visitor_8hpp.html</anchorfile>
      <anchor>ae9e7de2f662ec16763c946698e24656b</anchor>
      <arglist>(SomeVisitor)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>worldcomm.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>worldcomm_8cpp</filename>
    <includes id="worldcomm_8hpp" name="worldcomm.hpp" local="no" imported="no">feel/feelcore/worldcomm.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>worldcomm.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcore/</path>
    <filename>worldcomm_8hpp</filename>
    <class kind="class">Feel::WorldComm</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>crb.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcrb/</path>
    <filename>crb_8hpp</filename>
    <includes id="solvereigen_8hpp" name="solvereigen.hpp" local="no" imported="no">feel/feelalg/solvereigen.hpp</includes>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="environment_8hpp" name="environment.hpp" local="no" imported="no">feel/feelcore/environment.hpp</includes>
    <includes id="parameterspace_8hpp" name="parameterspace.hpp" local="no" imported="no">feel/feelcrb/parameterspace.hpp</includes>
    <includes id="crbdb_8hpp" name="crbdb.hpp" local="no" imported="no">feel/feelcrb/crbdb.hpp</includes>
    <includes id="serialization_8hpp" name="serialization.hpp" local="no" imported="no">feel/feelcore/serialization.hpp</includes>
    <includes id="pod_8hpp" name="pod.hpp" local="no" imported="no">feel/feelcrb/pod.hpp</includes>
    <class kind="class">Feel::CRB</class>
    <class kind="struct">boost::serialization::version&lt; Feel::CRB&lt; T &gt; &gt;</class>
    <namespace>Feel</namespace>
    <member kind="enumeration">
      <name>CRBErrorType</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a87e77631faf5262bc0eaca80b8e9190f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Feel::po::options_description</type>
      <name>crbOptions</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a8139a0d4de5dc8faed1e4adcadba7a85</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>crbdb.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcrb/</path>
    <filename>crbdb_8cpp</filename>
    <includes id="environment_8hpp" name="environment.hpp" local="no" imported="no">feel/feelcore/environment.hpp</includes>
    <includes id="crbdb_8hpp" name="crbdb.hpp" local="no" imported="no">feel/feelcrb/crbdb.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>crbdb.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcrb/</path>
    <filename>crbdb_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <class kind="class">Feel::CRBDB</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>crbmodel.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcrb/</path>
    <filename>crbmodel_8hpp</filename>
    <includes id="solvereigen_8hpp" name="solvereigen.hpp" local="no" imported="no">feel/feelalg/solvereigen.hpp</includes>
    <includes id="parameterspace_8hpp" name="parameterspace.hpp" local="no" imported="no">feel/feelcrb/parameterspace.hpp</includes>
    <class kind="class">Feel::CRBModel</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>crbmodel_wrapper.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcrb/</path>
    <filename>crbmodel__wrapper_8cpp</filename>
    <includes id="crbmodel_8hpp" name="crbmodel.hpp" local="no" imported="no">crbmodel.hpp</includes>
    <member kind="function">
      <type></type>
      <name>BOOST_PYTHON_MODULE</name>
      <anchorfile>crbmodel__wrapper_8cpp.html</anchorfile>
      <anchor>ac70b886368e413f721c3bab075e7ba20</anchor>
      <arglist>(heat1d)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>crbscm.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcrb/</path>
    <filename>crbscm_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="solvereigen_8hpp" name="solvereigen.hpp" local="no" imported="no">feel/feelalg/solvereigen.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>Feel::po::options_description</type>
      <name>crbSCMOptions</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a293e052585cf7b1afd0aa0f6a72aacef</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>crbwrapper.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcrb/</path>
    <filename>crbwrapper_8hpp</filename>
    <member kind="define">
      <type>#define</type>
      <name>CRB_FUNC_EXEC_BODY_IN_TEMPDIR</name>
      <anchorfile>crbwrapper_8hpp.html</anchorfile>
      <anchor>a40da87b7bc4614ccd781657fce8ebdf0</anchor>
      <arglist>(classname, dirname)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>eim.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcrb/</path>
    <filename>eim_8hpp</filename>
    <class kind="class">Feel::EIMBase</class>
    <class kind="class">Feel::EIM</class>
    <class kind="class">Feel::EIMFunctionBase</class>
    <class kind="class">Feel::EIMFunction</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>operatorlinearparametrized.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcrb/</path>
    <filename>operatorlinearparametrized_8hpp</filename>
    <includes id="parameterspace_8hpp" name="parameterspace.hpp" local="no" imported="no">feel/feelcrb/parameterspace.hpp</includes>
    <class kind="class">Feel::OperatorLinearParametrized</class>
    <class kind="struct">Feel::OperatorLinearParametrized::domain_element</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>opusapp.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcrb/</path>
    <filename>opusapp_8hpp</filename>
    <includes id="crb_8hpp" name="crb.hpp" local="no" imported="no">feel/feelcrb/crb.hpp</includes>
    <includes id="crbmodel_8hpp" name="crbmodel.hpp" local="no" imported="no">feel/feelcrb/crbmodel.hpp</includes>
    <class kind="class">Feel::OpusApp</class>
    <namespace>Feel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>prec</name>
      <anchorfile>opusapp_8hpp.html</anchorfile>
      <anchor>a4c01dcca324ecd28bf0f7dbd30b6c007</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>Pdim</name>
      <anchorfile>opusapp_8hpp.html</anchorfile>
      <anchor>a43f948d91ec11f0dccfee9f5897a9516</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>fill</name>
      <anchorfile>opusapp_8hpp.html</anchorfile>
      <anchor>a18e813e09a72bd739e1fb0dfad65cf94</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>dmanip</name>
      <anchorfile>opusapp_8hpp.html</anchorfile>
      <anchor>a83051eeafbe6e9d6ff067a54417e5fb7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>hdrmanip</name>
      <anchorfile>opusapp_8hpp.html</anchorfile>
      <anchor>a079e43c72065e3a5426d324126b483b7</anchor>
      <arglist>(N)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>tabmanip</name>
      <anchorfile>opusapp_8hpp.html</anchorfile>
      <anchor>adbd16ddacf1a2a87125abb52188fe6a3</anchor>
      <arglist>(N)</arglist>
    </member>
    <member kind="function">
      <type>po::options_description</type>
      <name>opusapp_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a599520e9ce1572efc7e71afaef20fd70</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>_o</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a2faecbdab41646e180ccdfd892c670f1</anchor>
      <arglist>(std::string const &amp;prefix, std::string const &amp;opt)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>parameterspace.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcrb/</path>
    <filename>parameterspace_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="kdtree_8hpp" name="kdtree.hpp" local="no" imported="no">feel/feelmesh/kdtree.hpp</includes>
    <class kind="class">Feel::ParameterSpace</class>
    <class kind="class">Feel::ParameterSpace::Element</class>
    <class kind="class">Feel::ParameterSpace::Sampling</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>pfemapp.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcrb/</path>
    <filename>pfemapp_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="application_8hpp" name="application.hpp" local="no" imported="no">feel/feelcore/application.hpp</includes>
    <includes id="crbmodel_8hpp" name="crbmodel.hpp" local="no" imported="no">feel/feelcrb/crbmodel.hpp</includes>
    <includes id="pfemapp_8hpp" name="pfemapp.hpp" local="no" imported="no">feel/feelcrb/pfemapp.hpp</includes>
    <class kind="class">Feel::PFemApp</class>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>po::options_description</type>
      <name>pfemapp_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad2b131cb1baf12462234f232706a3541</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>_o</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a2faecbdab41646e180ccdfd892c670f1</anchor>
      <arglist>(std::string const &amp;prefix, std::string const &amp;opt)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>pod.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcrb/</path>
    <filename>pod_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="solvereigen_8hpp" name="solvereigen.hpp" local="no" imported="no">feel/feelalg/solvereigen.hpp</includes>
    <includes id="pod_8hpp" name="pod.hpp" local="no" imported="no">feel/feelcrb/pod.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>Feel::po::options_description</type>
      <name>podOptions</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ac7f3f7b952c2f4fa4766b542e3bff904</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>pod.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelcrb/</path>
    <filename>pod_8hpp</filename>
    <includes id="solvereigen_8hpp" name="solvereigen.hpp" local="no" imported="no">feel/feelalg/solvereigen.hpp</includes>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="environment_8hpp" name="environment.hpp" local="no" imported="no">feel/feelcore/environment.hpp</includes>
    <includes id="parameterspace_8hpp" name="parameterspace.hpp" local="no" imported="no">feel/feelcrb/parameterspace.hpp</includes>
    <includes id="crbdb_8hpp" name="crbdb.hpp" local="no" imported="no">feel/feelcrb/crbdb.hpp</includes>
    <includes id="serialization_8hpp" name="serialization.hpp" local="no" imported="no">feel/feelcore/serialization.hpp</includes>
    <class kind="class">Feel::POD</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>exporter.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>exporter_8cpp</filename>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>po::options_description</type>
      <name>exporter_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a7cf67b8474fa1ad278fc2338cc21c157</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>exporterensight.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>exporterensight_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>exportergmsh.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>exportergmsh_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="gmsh_8hpp" name="gmsh.hpp" local="no" imported="no">feel/feelfilters/gmsh.hpp</includes>
    <includes id="gmshenums_8hpp" name="gmshenums.hpp" local="no" imported="no">feel/feelfilters/gmshenums.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>__EXPORTERGMSH_CPP</name>
      <anchorfile>exportergmsh_8cpp.html</anchorfile>
      <anchor>afda5c32aaeaad835a875ca15fd8a8573</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>exportergnuplot.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>exportergnuplot_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="exportergnuplot_8hpp" name="exportergnuplot.hpp" local="no" imported="no">feel/feelfilters/exportergnuplot.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>__EXPORTERGNUPLOT_CPP</name>
      <anchorfile>exportergnuplot_8cpp.html</anchorfile>
      <anchor>a2e06f9d41a49dbc6d37b36dd09541140</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>exportergnuplot.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>exportergnuplot_8hpp</filename>
    <includes id="debug_8hpp" name="debug.hpp" local="no" imported="no">feel/feelcore/debug.hpp</includes>
    <includes id="exportergnuplot_8cpp" name="exportergnuplot.cpp" local="no" imported="no">feel/feelfilters/exportergnuplot.cpp</includes>
    <class kind="class">Feel::ExporterGnuplot</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>exporterimpl.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>exporterimpl_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="factory_8hpp" name="factory.hpp" local="no" imported="no">feel/feelcore/factory.hpp</includes>
    <includes id="singleton_8hpp" name="singleton.hpp" local="no" imported="no">feel/feelcore/singleton.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>exporterquick.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>exporterquick_8hpp</filename>
    <class kind="class">Feel::ExporterQuick</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>filterfromvtk.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>filterfromvtk_8hpp</filename>
    <includes id="visitor_8hpp" name="visitor.hpp" local="no" imported="no">feel/feelcore/visitor.hpp</includes>
    <includes id="mesh2d_8hpp" name="mesh2d.hpp" local="no" imported="no">feel/feelmesh/mesh2d.hpp</includes>
    <includes id="mesh3d_8hpp" name="mesh3d.hpp" local="no" imported="no">feel/feelmesh/mesh3d.hpp</includes>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <class kind="class">Feel::FilterFromVtk</class>
    <class kind="class">Feel::FilterFromVtk3D</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>geotool.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>geotool_8cpp</filename>
    <includes id="geotool_8hpp" name="geotool.hpp" local="no" imported="no">feel/feelfilters/geotool.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_GENERATE_RUN</name>
      <anchorfile>geotool_8cpp.html</anchorfile>
      <anchor>a003768e5166001cad1583252d3dbed47</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a24aefc697839e976ae1858dd9b2c7f45</anchor>
      <arglist>(data_geo_ptrtype __dg)</arglist>
    </member>
    <member kind="function">
      <type>node_type</type>
      <name>param</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>afc4ad06c0cfdeacabf5cbc1448b51cc5</anchor>
      <arglist>(data_geo_ptrtype __dg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePoint</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a1e0183faa41db32bc67359fc386c1387</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, double __x1, double __x2, double __x3)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeLine</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a904a13a44a9e65abff4e7c9c77f07a8e</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, uint __n1, uint __n2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeCircle</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>ae26d4551661b0d2ad1acf64c1034d4c7</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, uint __n1, uint __n2, uint __n3)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeSpline</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>aa879c73e01a2647c2e331d63d21b7ae5</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, Loop __loop)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeBSpline</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a9e1326537b98949307f81d375a45e209</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, Loop __loop)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeLineLoop</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a52008ac974c70819b14536ee2bd527ae</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, Loop__loop)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePtInSurface</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a5bfd282b5501b8b65b1c2510ebfdefeb</anchor>
      <arglist>(data_geo_ptrtype __dg, uint __indLocPt, uint __indLocSurf)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePlaneSurface</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a3e87c8bd05e3c9adb874639f776c43e6</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, uint __ind)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeRuledSurface</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a89a56c0dc8e32b27732953b42492089f</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, uint __ind)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeExtrudeSurface</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a7a8e7fa3c16fa38f36753cb7be0b7def</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, uint __ind, Loop__loop)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeSurfaceLoop</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>ae43d2a70eac8952d8840419d5a0b785d</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, Loop__loop)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeVolume</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>ab15550b45403d6ce74aa5a25eeb9ff8f</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, uint __ind)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; Node, Node, Node &gt;</type>
      <name>computeBasisOrthogonal</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>acb2c1976a8c9f180a6f457ed2e1a38cb</anchor>
      <arglist>(node_type dir, node_type centre)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>runLine</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a15d829acbe55b207bb56d86014b9bc46</anchor>
      <arglist>(data_geo_ptrtype dg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>runTriangle</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>af8c8cdf79da0a9058463097616fa5c06</anchor>
      <arglist>(data_geo_ptrtype dg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>runRectangle</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>aec8f480048253594a30b63426ded9b49</anchor>
      <arglist>(data_geo_ptrtype dg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>runQuadrangle</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a9f9aa71611319b52ce2a84c9547cd3a7</anchor>
      <arglist>(data_geo_ptrtype dg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>runPentagon</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>affea6da1ed4836775b6889e34163d5be</anchor>
      <arglist>(data_geo_ptrtype dg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>runHexagon</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a4f25a99ff6f23a218a41fa1a4ff9d5e5</anchor>
      <arglist>(data_geo_ptrtype dg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>runCircle</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>ae51d8653c12f0da178f09c7964c42652</anchor>
      <arglist>(data_geo_ptrtype dg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>runPie</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a44b9121ef60b8715b72ff1ecb6981422</anchor>
      <arglist>(data_geo_ptrtype dg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>runSpecial_1a</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a70849c2bdae29b2d8e48647d47d6ff67</anchor>
      <arglist>(data_geo_ptrtype dg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>runSpecial_1b</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a5842775a8914fd0c9c48e470c934603e</anchor>
      <arglist>(data_geo_ptrtype dg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>runPeanut</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>ac84ae0f9137156af68287bb1adf43490</anchor>
      <arglist>(data_geo_ptrtype dg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>runHexaedre</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a4ebe2bca968d921f5c327906046a7d4e</anchor>
      <arglist>(data_geo_ptrtype dg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>runCube</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a54ead81810cabf375b1f156b9a2faf7a</anchor>
      <arglist>(data_geo_ptrtype dg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>runCylindre</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a971f30c2b7228a28d49fe3d7bed00bcb</anchor>
      <arglist>(data_geo_ptrtype dg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>runSphere</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>afe4aa357007c187ffb0ae993454da18d</anchor>
      <arglist>(data_geo_ptrtype dg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>runTube</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>aad46b4fb8368593c737cae54cc7f0378</anchor>
      <arglist>(data_geo_ptrtype dg)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>geotool.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>geotool_8hpp</filename>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <includes id="gmsh_8hpp" name="gmsh.hpp" local="no" imported="no">feel/feelfilters/gmsh.hpp</includes>
    <class kind="class">Feel::GeoTool::Node</class>
    <class kind="class">Feel::GeoTool::Loop</class>
    <class kind="class">Feel::GeoTool::GeoGMSHTool</class>
    <namespace>Feel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_SHAPE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>af97c45e53568a27de95df8b260c59a6a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_LINE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a2b441397ee2b9ff30b55a42316602b7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_LINE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a47c75bf5bd7ab0c3734703b8647f0629</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_TRIANGLE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a1d2e2de03f5c756d7b356705aceaa40c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_TRIANGLE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a2d686b69935f38b3ecb1feec11596a2c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_SURFACE_TRIANGLE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>ac9d7d6f96a0c31c370f1acfe8af69885</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_RECTANGLE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a15c15e9c00512fe4df05989b49e400f4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_RECTANGLE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a1e394e1bace56c87c616af3e2af8e823</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_SURFACE_RECTANGLE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a447947686d2f689809b24167b68146ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_QUADRANGLE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>af7003d2871d4ae237ee2c39ac57869af</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_QUADRANGLE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>ae38bbc1340add01626ab0d4c7818e17c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_SURFACE_QUADRANGLE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>ab1f3c02a90f51f222f78aa25465daf79</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_PENTAGON</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>ad3afa6f644cddee447e58381246f6238</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_PENTAGON</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>ad3d6994af61f6fddfbf348c1b2eec2cb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_SURFACE_PENTAGON</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a5740091c916f161d74992e73dd54d55c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_HEXAGON</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>ac2d5145eeebb691ff615ecb3acbe7d17</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_HEXAGON</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a83b45f8f4089a7b82b0b364b0b6d3d1e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_SURFACE_HEXAGON</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>ae8f73f87d64594b44354a7eccd243dc4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_CIRCLE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a56548ac389c189506577d999c4a346fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_CIRCLE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>ae01c14430c62a8e956719ee03a52a9ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_SURFACE_CIRCLE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a02c037c0fe735fdb6d7f96a0c2fc99d7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_PIE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a9f949c5fe2c5bfd68e57b257cacb82f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_PIE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a76b4860f63a51edc9f372b1d39a24abd</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_SURFACE_PIE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a25b59f2c6f7cdfc15d7ed214e15c3c52</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_SPECIAL_1A</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a1d72bf49f412bf2456c6b4053f3d9e95</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_SPECIAL_1A</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>add87975440099eb27fc3235fd8bd6ae4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_SURFACE_SPECIAL_1A</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a10f0e35fc5dd047a67b16b2e84a52e1c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_SPECIAL_1B</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a837d7cb01c53af02737e8a7af6a23f58</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_SPECIAL_1B</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a8c7354e9093c9d7eb9a69e668f7fafc7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_SURFACE_SPECIAL_1B</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>adafef8536e7f36e205658f1d560ebbec</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_PEANUT</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>adac25083897b4d067526bcd851244262</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_PEANUT</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>ad3f93635c7a9242f386c68eb0660379f</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_SURFACE_PEANUT</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>ae8546938111011cfe943618907ab1e23</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_CYLINDRE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a84a378d9fa639fee2839592200f01491</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_CYLINDRE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a2f175bc1a0026cdf950660d1d93268cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_SURFACE_CYLINDRE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a0dca122e344dbc4a22a594e6889efc6a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_VOLUME_CYLINDRE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>ab2ac8c39cd72770039156f5067e1bdd4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_TUBE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>abdd8f75f2c15b9c46c8ca68d552b9dfd</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_TUBE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a157dd72bd7ec2edde6f1cebf3f0d17c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_SURFACE_TUBE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>ad2e0f8cd5064f2370cb7b62edceb99a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_VOLUME_TUBE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a6c320496c2d7bf3181223d22a9feaa85</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_SPHERE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a62afbfc0b7b85872dc443485b4d04c50</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_SPHERE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a806a1c748dac84797fa34132cd8020a7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_SURFACE_SPHERE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>af06fb95636a0aad175b8308fbfd3ad64</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_VOLUME_SPHERE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a1d406f389849db1264cea07dd4723967</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_HEXAEDRE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a328c0c2721d2def773d89c60dc9ae4de</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_HEXAEDRE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a72b557c95a59dc072b5bb3e807295d43</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_SURFACE_HEXAEDRE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a333b0c92f29e4162170ad07469ce4352</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_VOLUME_HEXAEDRE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>ac9f1d94097878d45a89444c257fd7335</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_CUBE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a392c557f9ac36740cd9fb53d6aa7fdcc</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_CUBE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a95d0cff37b846c0eba5cb008bbec0319</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_SURFACE_CUBE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a80bb90f471ecab8a9711d0ae27a51da2</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_VOLUME_CUBE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a52c4ce074c9fb44fe0ac13b01f2159ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_SHAPE_NAME_CLASS</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a2b9e957504965a25eb81c3655a9ce545</anchor>
      <arglist>(i)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_SHAPE_DIM</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a1920c81249c7b875652ff278f4447596</anchor>
      <arglist>(i)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_SHAPE_NBSURFACE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a5a645822e5ad4de260df314e4c34cc3e</anchor>
      <arglist>(i)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_SHAPE_NBVOLUME</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>abd5f272313f33b1ab9f8ccb259b12655</anchor>
      <arglist>(i)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_SHAPE_NAME_STR</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a22ff66e899ff8a00ee31247018c095dd</anchor>
      <arglist>(i)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_SHAPE_NBPARAM</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a01c53b5a347c5e8b279510d4c898052d</anchor>
      <arglist>(i)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_SHAPE_NAME_MACRO</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>ad814766bbbb23cc3f5e79fb07d326b33</anchor>
      <arglist>(i)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_INDICE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a5bd36d3dbc8b62442389673cee455326</anchor>
      <arglist>(O)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_NBMARK</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>aca94ca01260e262a0647496a563b6fa2</anchor>
      <arglist>(F, i)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_ARRAYMARK</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a4f2e966d47dd666290984950d9e3842f</anchor>
      <arglist>(O)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_POINT_MARKVALUE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>aee6d734179b73ee11cad140a6e2a474c</anchor>
      <arglist>(F, i, j)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_INDICE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a3157196c2f33a0472f9661fcd42dff61</anchor>
      <arglist>(O)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_NBMARK</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>aea033caf61c2ae1f7227cac1f6ad5f03</anchor>
      <arglist>(F, i)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_ARRAYMARK</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>aedad4d33d08403bc74935ad88fe5b159</anchor>
      <arglist>(O)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_LINE_MARKVALUE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a126f4b66032b9376d22d5f03bc426cfb</anchor>
      <arglist>(F, i, j)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_SURFACE_INDICE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>ad2b70c1c4f74c6f711109172ad2b1051</anchor>
      <arglist>(O)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_SURFACE_NBMARK</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a3936a1b81e69f09ff4d3071fa895e382</anchor>
      <arglist>(F, i)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_SURFACE_ARRAYMARK</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>ae01d73f1538d5ff575914b9b7e23a78a</anchor>
      <arglist>(O)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_SURFACE_MARKVALUE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a83c5d33046638eaca912160553373a1c</anchor>
      <arglist>(F, i, j)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_VOLUME_INDICE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a22e91d806f8e3ccf99039476464ac67c</anchor>
      <arglist>(O)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_VOLUME_NBMARK</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a71cb15d211e798ead808c2abcf60a2d1</anchor>
      <arglist>(F, i)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_VOLUME_ARRAYMARK</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a5523625d0ac58a9f13f209095d80d071</anchor>
      <arglist>(O)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_MARKER_VOLUME_MARKVALUE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a85517d04d7ca749ae36001788c837d0b</anchor>
      <arglist>(F, i, j)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_INSTANTIATES_FOR_COMP</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>abb3d156c50dc0d540dcd189d51ebefa3</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_INSTANTIATES_FOR_INCR</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a69e06730252b506d40ecc785d8174183</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_INSTANTIATES_FOR</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>ab49a19b636ba072942d1233aeea02912</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_FOR_COMP2</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a90abb80ef86e02e3fd0d568e53774bde</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_FOR_INCR2</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a1695dc2b67a17c51751d6e501e8f37ca</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_FOR_MARKER_POINT_MACRO2</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a3cf95da54c2b8cd2b516ddb0aca0e6d5</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_FOR_MARKER_LINE_MACRO2</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a4547a853197f4a3a4856d86181189f70</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_FOR_MARKER_SURFACE_MACRO2</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>af4d66262109f3eb4d87267560cdf0a85</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_FOR_MARKER_VOLUME_MACRO2</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a0021db5e99224218776a8d79e879931f</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_FOR_MARKER_POINT_MACRO</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a58d0c23a3df62d997226f5977fb97d06</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_FOR_MARKER_LINE_MACRO</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a43fb9ee6a9e06f0bb41fa5159f0d4996</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_FOR_MARKER_SURFACE_MACRO</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a9ea86dd956def83468060dcdb068bd39</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_FOR_MARKER_VOLUME_MACRO</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a9676e4f8d8eaf7693f3cef8fee111569</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_FOR_COMP1</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>ae5a614a546c2938d2713d2c0724329ad</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_FOR_INCR1</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a97c417bda5b3344f9049e351b8ebbae7</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_FOR_COMP</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a8d9e22122be93db04cb11d705787ca2b</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_FOR_INCR</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a315676e873cda73e449b82c5c0b1ccc5</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_SHAPE_PARAM</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a065c6a1d3f267caf2f57e16d379f481b</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_SHAPE_FOR_PARAM_SIGNATURE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>ab91fb9c934a6130ee5fd6fb70758d88a</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_SHAPE_PARAM_SIGNATURE</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>a2f4f9a56d20f784d600b68ba16c573cd</anchor>
      <arglist>(state)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GEOTOOL_SHAPE_CLASS</name>
      <anchorfile>geotool_8hpp.html</anchorfile>
      <anchor>aedfd71b1f501868450d907a999f4c821</anchor>
      <arglist>(r, state)</arglist>
    </member>
    <member kind="typedef">
      <type>node&lt; double &gt;::type</type>
      <name>node_type</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>ab434868f16471f90fdaceb5b08ddc833</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; GeoGMSHTool &gt;</type>
      <name>GeoGMSHTool_ptrtype</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a88692d9fb9a10fe2ec92bc3de3da7c40</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::map&lt; uint, uint &gt;</type>
      <name>map_data_type</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>aaa15f0f238990432da8a128304b67b2a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; map_data_type &gt;</type>
      <name>vec_map_data_type</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a2ab1546f6f534feea92c10ef79f68a7a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; vec_map_data_type &gt;</type>
      <name>vec_map_data_ptrtype</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a56d21c32e41b8c8eb7eaa52bea1dcd09</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; std::map&lt; uint, bool &gt; &gt;</type>
      <name>vec_map_data_surf1_type</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>ad5508f561fdb3a6f742cb09f2c8469f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; vec_map_data_surf1_type &gt;</type>
      <name>vec_map_data_surf1_ptrtype</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a54f086cd14b8c4f27da7917c97cb7b6d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; std::map&lt; uint, std::string &gt; &gt;</type>
      <name>vec_map_data_surf2_type</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>aff55c0f6546f3707800a1ec349149fee</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; vec_map_data_surf2_type &gt;</type>
      <name>vec_map_data_surf2_ptrtype</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>aff11185645fcbad448610f6c111d011b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; std::map&lt; uint, std::list&lt; uint &gt; &gt; &gt;</type>
      <name>vec_map_data_ptsinsurf_type</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a574264f07a51519a01a735f1a87c1c3c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; vec_map_data_ptsinsurf_type &gt;</type>
      <name>vec_map_data_ptsinsurf_ptrtype</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>ac1f4e5376e921cd999795ecbf52301ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::map&lt; int, std::list&lt; int &gt; &gt;</type>
      <name>map_surfaceLoop_type</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a7537af544a15d6b20ad3ca71108ff0c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::tuple&lt; GeoGMSHTool_ptrtype, vec_map_data_ptrtype, std::string, std::string, vec_map_data_surf1_ptrtype, vec_map_data_surf2_ptrtype, vec_map_data_surf1_ptrtype, vec_map_data_ptsinsurf_ptrtype, map_surfaceLoop_type &gt;</type>
      <name>data_geo_type</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>ab210aee0f947150cf674b74b63cd4794</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; data_geo_type &gt;</type>
      <name>data_geo_ptrtype</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a4268ac56f0d15e375288f2880a0eba4e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a24aefc697839e976ae1858dd9b2c7f45</anchor>
      <arglist>(data_geo_ptrtype __dg)</arglist>
    </member>
    <member kind="function">
      <type>node_type</type>
      <name>param</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>afc4ad06c0cfdeacabf5cbc1448b51cc5</anchor>
      <arglist>(data_geo_ptrtype __dg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePoint</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a1e0183faa41db32bc67359fc386c1387</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, double __x1, double __x2, double __x3)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeLine</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a904a13a44a9e65abff4e7c9c77f07a8e</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, uint __n1, uint __n2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeCircle</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>ae26d4551661b0d2ad1acf64c1034d4c7</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, uint __n1, uint __n2, uint __n3)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeSpline</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>aa879c73e01a2647c2e331d63d21b7ae5</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, Loop __loop)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeBSpline</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a9e1326537b98949307f81d375a45e209</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, Loop __loop)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeLineLoop</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a52008ac974c70819b14536ee2bd527ae</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, Loop__loop)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePlaneSurface</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a3e87c8bd05e3c9adb874639f776c43e6</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, uint __ind)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeRuledSurface</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a89a56c0dc8e32b27732953b42492089f</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, uint __ind)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeExtrudeSurface</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a7a8e7fa3c16fa38f36753cb7be0b7def</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, uint __ind, Loop__loop)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePtInSurface</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a5bfd282b5501b8b65b1c2510ebfdefeb</anchor>
      <arglist>(data_geo_ptrtype __dg, uint __indLocPt, uint __indLocSurf)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeSurfaceLoop</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>ae43d2a70eac8952d8840419d5a0b785d</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, Loop__loop)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeVolume</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>ab15550b45403d6ce74aa5a25eeb9ff8f</anchor>
      <arglist>(uint __numLoc, data_geo_ptrtype __dg, uint __ind)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; Node, Node, Node &gt;</type>
      <name>computeBasisOrthogonal</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>acb2c1976a8c9f180a6f457ed2e1a38cb</anchor>
      <arglist>(node_type dir, node_type centre)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PP_FOR</name>
      <anchorfile>namespaceFeel_1_1GeoTool.html</anchorfile>
      <anchor>a5bf167bbb9b0ad41b52498d8605ee8da</anchor>
      <arglist>((0, BOOST_PP_SUB(BOOST_PP_ARRAY_SIZE(GEOTOOL_SHAPE), 1)), GEOTOOL_FOR_COMP, GEOTOOL_FOR_INCR, GEOTOOL_SHAPE_CLASS) template&lt; typename mesh_type &gt; boost</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>gmsh.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>gmsh_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="application_8hpp" name="application.hpp" local="no" imported="no">feel/feelcore/application.hpp</includes>
    <includes id="hypercube_8hpp" name="hypercube.hpp" local="no" imported="no">feel/feelmesh/hypercube.hpp</includes>
    <includes id="gmsh_8hpp" name="gmsh.hpp" local="no" imported="no">feel/feelfilters/gmsh.hpp</includes>
    <includes id="gmshsimplexdomain_8hpp" name="gmshsimplexdomain.hpp" local="no" imported="no">feel/feelfilters/gmshsimplexdomain.hpp</includes>
    <includes id="gmshhypercubedomain_8hpp" name="gmshhypercubedomain.hpp" local="no" imported="no">feel/feelfilters/gmshhypercubedomain.hpp</includes>
    <includes id="gmshellipsoiddomain_8hpp" name="gmshellipsoiddomain.hpp" local="no" imported="no">feel/feelfilters/gmshellipsoiddomain.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>gmsh.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>gmsh_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="environment_8hpp" name="environment.hpp" local="no" imported="no">feel/feelcore/environment.hpp</includes>
    <includes id="factory_8hpp" name="factory.hpp" local="no" imported="no">feel/feelcore/factory.hpp</includes>
    <includes id="singleton_8hpp" name="singleton.hpp" local="no" imported="no">feel/feelcore/singleton.hpp</includes>
    <includes id="worldcomm_8hpp" name="worldcomm.hpp" local="no" imported="no">feel/feelcore/worldcomm.hpp</includes>
    <includes id="gmshenums_8hpp" name="gmshenums.hpp" local="no" imported="no">feel/feelfilters/gmshenums.hpp</includes>
    <includes id="exporterquick_8hpp" name="exporterquick.hpp" local="no" imported="no">feel/feelfilters/exporterquick.hpp</includes>
    <includes id="importergmsh_8hpp" name="importergmsh.hpp" local="no" imported="no">feel/feelfilters/importergmsh.hpp</includes>
    <class kind="class">Feel::Gmsh</class>
    <class kind="struct">Feel::Gmsh::Factory</class>
    <namespace>Feel</namespace>
    <member kind="typedef">
      <type>Gmsh</type>
      <name>gmsh_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab3e9073ed2c20fc94d134060b4156d49</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; gmsh_type &gt;</type>
      <name>gmsh_ptrtype</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af278672c3f22f96e60323c2d0023bf52</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aa77c4f07552efe9fd54f86982f060fb8</anchor>
      <arglist>((typename detail::mesh&lt; Args &gt;::ptrtype), straightenMesh, tag,(required(mesh,*))(optional(refine,*(boost::is_integral&lt; mpl::_ &gt;), 0)(save,*(boost::is_integral&lt; mpl::_ &gt;), 0)(worldcomm,(WorldComm), WorldComm())))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4a675bb30ae99ba1d53a28cbf20868f6</anchor>
      <arglist>((typename detail::mesh&lt; Args &gt;::ptrtype), loadGMSHMesh, tag,(required(mesh,*)(filename,*))(optional(straighten,*(boost::is_integral&lt; mpl::_ &gt;), 1)(refine,*(boost::is_integral&lt; mpl::_ &gt;), 0)(update,*(boost::is_integral&lt; mpl::_ &gt;), 0)(physical_are_elementary_regions,*, false)))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af0342f73318c46b967d5426bbab03326</anchor>
      <arglist>((void), saveGMSHMesh, tag,(required(mesh,*)(filename,*))(optional(parametricnodes,*(boost::is_integral&lt; mpl::_ &gt;), 0)))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4d8482036f0f97a57582e3602dc5bb0e</anchor>
      <arglist>((typename detail::mesh&lt; Args &gt;::ptrtype), createGMSHMesh, tag,(required(mesh,*)(desc,*))(optional(h,*(boost::is_arithmetic&lt; mpl::_ &gt;), 0.1)(parametricnodes,*(boost::is_integral&lt; mpl::_ &gt;), 0)(straighten,*(boost::is_integral&lt; mpl::_ &gt;), 1)(refine,*(boost::is_integral&lt; mpl::_ &gt;), 0)(update,*(boost::is_integral&lt; mpl::_ &gt;), 0)(force_rebuild,*(boost::is_integral&lt; mpl::_ &gt;), 0)(physical_are_elementary_regions,*, false)(partitions,*(boost::is_integral&lt; mpl::_ &gt;), 1)(partition_file,*(boost::is_integral&lt; mpl::_ &gt;), 0)(partitioner,*(boost::is_integral&lt; mpl::_ &gt;), GMSH_PARTITIONER_CHACO)(worldcomm,*, WorldComm())))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af8da0dc7377b26a89fb935cf778a585d</anchor>
      <arglist>((gmsh_ptrtype), domain, tag,(required(name,*(boost::is_convertible&lt; mpl::_, std::string &gt;))(shape,*(boost::is_convertible&lt; mpl::_, std::string &gt;)))(optional(shear,*(boost::is_arithmetic&lt; mpl::_ &gt;), 0)(recombine,*(boost::is_integral&lt; mpl::_ &gt;), 0)(dim,*(boost::is_integral&lt; mpl::_ &gt;), 3)(order,*(boost::is_integral&lt; mpl::_ &gt;), 1)(h,*(boost::is_arithmetic&lt; mpl::_ &gt;), double(0.1))(convex,*(boost::is_convertible&lt; mpl::_, std::string &gt;),&quot;Simplex&quot;)(addmidpoint,*(boost::is_integral&lt; mpl::_ &gt;), true)(usenames,*(boost::is_integral&lt; mpl::_ &gt;), false)(xmin,*(boost::is_arithmetic&lt; mpl::_ &gt;), 0.)(xmax,*(boost::is_arithmetic&lt; mpl::_ &gt;), 1)(ymin,*(boost::is_arithmetic&lt; mpl::_ &gt;), 0.)(ymax,*(boost::is_arithmetic&lt; mpl::_ &gt;), 1)(zmin,*(boost::is_arithmetic&lt; mpl::_ &gt;), 0.)(zmax,*(boost::is_arithmetic&lt; mpl::_ &gt;), 1)))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aa75178b5ff5604cefd1c78e10103205b</anchor>
      <arglist>((gmsh_ptrtype), geo, tag,(required(filename,*(boost::is_convertible&lt; mpl::_, std::string &gt;)))(optional(h,*(boost::is_arithmetic&lt; mpl::_ &gt;), double(0.1))(dim,*(boost::is_integral&lt; mpl::_ &gt;), 3)(order,*(boost::is_integral&lt; mpl::_ &gt;), 1)(files_path,*(boost::is_convertible&lt; mpl::_, std::string &gt;), Environment::localGeoRepository())(depends,*(boost::is_convertible&lt; mpl::_, std::string &gt;), std::string(&quot;&quot;))))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a38c357a62020b9c7ce88ff305e3a5ff7</anchor>
      <arglist>((gmsh_ptrtype), mshconvert, tag,(required(filename,*(boost::is_convertible&lt; mpl::_, std::string &gt;)))(optional(dim,*(boost::is_integral&lt; mpl::_ &gt;), 3)(order,*(boost::is_integral&lt; mpl::_ &gt;), 1)))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a62346cec73fcc4c172c2a5ccefd41fdd</anchor>
      <arglist>((std::string), img2msh, tag,(required(filename,*(boost::is_convertible&lt; mpl::_, std::string &gt;)))(optional(prefix,*(boost::is_convertible&lt; mpl::_, std::string &gt;), fs::path(filename).stem())))</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>gmshellipsoiddomain.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>gmshellipsoiddomain_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="gmshellipsoiddomain_8hpp" name="gmshellipsoiddomain.hpp" local="no" imported="no">feel/feelfilters/gmshellipsoiddomain.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>gmshellipsoiddomain.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>gmshellipsoiddomain_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="gmsh_8hpp" name="gmsh.hpp" local="no" imported="no">feel/feelfilters/gmsh.hpp</includes>
    <class kind="class">Feel::GmshEllipsoidDomain</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>gmshenums.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>gmshenums_8hpp</filename>
    <class kind="class">Feel::GmshOrdering</class>
    <namespace>Feel</namespace>
    <member kind="enumeration">
      <name>GMSH_ENTITY</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_LINE</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1afea6a1908b3cd3a722e987cf6861eca8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TRIANGLE</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1aaed86b38abd76b1aeb06bf30e3d54062</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_QUADRANGLE</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a3ce5e16332068d450d959e1839ebde2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TETRAHEDRON</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a015bfe4b11badb184dc3fa9682070e85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_HEXAHEDRON</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a9d87b081654b66dd7ff5f0305ed9991e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_PRISM</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a669701d4d73da623345b399da9cf7a9a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_PYRAMID</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1aaacbbcfe57b839467ebfa617b6e60e7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_LINE_2</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1ac6c38ea3f936ef5022b62c88003137d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TRIANGLE_2</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a3b0a4272c4f1aa39c3ec4e036d9be611</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_QUADRANGLE_2</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1af01f3dae9d29212f81d374233e9f013d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TETRAHEDRON_2</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a80bee3e57b9bbb5318a90fb131c0ee30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_HEXAHEDRON_2</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1ab97b32b4f77eabc48d5e8a87ad1184ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_PRISM_2</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a70230ca4f5221918222e747248f2ecb0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_PYRAMID_2</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1ab1989d567f75cdcc17f8efe18027b531</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_POINT</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a7182ee8dc9bd88eefbe7877c769150e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TRIANGLE_INCOMPLETE_3</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a63420b8569315b97e759910a6e97fde8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TRIANGLE_3</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a79c9343bfd5996352dbc52d0085116e9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TRIANGLE_INCOMPLETE_4</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1aee8089c3adca2fcff0ae5961db2ca4ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TRIANGLE_4</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a88f4fbeaf4332ea44eb880a60057a99b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TRIANGLE_INCOMPLETE_5</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a18fe04ea4d20b4e08f2d53593b4eab80</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TRIANGLE_5</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a54f3f4b7a65f4d7a1b42d3aa045de648</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_LINE_3</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a0800058b7a8fc81417cbcbeb530dddff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_LINE_4</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1ac70e34fe9d12e0279e8dda2ee527e2e3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_LINE_5</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a1dd62f2520e365961f6c04c726fa7928</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TETRAHEDRON_3</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1afc8b8875fba239d65dbc5c4af24317aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TETRAHEDRON_4</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a8e73cfb6e8197635cb8f96f87983c7cc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TETRAHEDRON_5</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1ac6848bf8621a93b8ee38a4973b9b8292</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>gmshhypercubedomain.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>gmshhypercubedomain_8cpp</filename>
    <includes id="gmshhypercubedomain_8hpp" name="gmshhypercubedomain.hpp" local="no" imported="no">feel/feelfilters/gmshhypercubedomain.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="define">
      <type>#define</type>
      <name>__GMSHTENSORIZEDDOMAIN_HPP</name>
      <anchorfile>gmshhypercubedomain_8cpp.html</anchorfile>
      <anchor>a31640ecf45935d6de851c95a92493f96</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>gmshhypercubedomain.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>gmshhypercubedomain_8hpp</filename>
    <includes id="gmsh_8hpp" name="gmsh.hpp" local="no" imported="no">feel/feelfilters/gmsh.hpp</includes>
    <class kind="class">Feel::GmshHypercubeDomain</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>gmshsimplexdomain.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>gmshsimplexdomain_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="gmshsimplexdomain_8hpp" name="gmshsimplexdomain.hpp" local="no" imported="no">feel/feelfilters/gmshsimplexdomain.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>gmshsimplexdomain.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>gmshsimplexdomain_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="gmsh_8hpp" name="gmsh.hpp" local="no" imported="no">feel/feelfilters/gmsh.hpp</includes>
    <class kind="class">Feel::GmshSimplexDomain</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>importer.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>importer_8hpp</filename>
    <includes id="visitor_8hpp" name="visitor.hpp" local="no" imported="no">feel/feelcore/visitor.hpp</includes>
    <includes id="worldcomm_8hpp" name="worldcomm.hpp" local="no" imported="no">feel/feelcore/worldcomm.hpp</includes>
    <class kind="class">Feel::Importer</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>importergambit.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>importergambit_8hpp</filename>
    <includes id="importer_8hpp" name="importer.hpp" local="no" imported="no">feel/feelfilters/importer.hpp</includes>
    <class kind="class">Feel::ImporterGambit</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>importergmsh.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>importergmsh_8hpp</filename>
    <includes id="worldcomm_8hpp" name="worldcomm.hpp" local="no" imported="no">feel/feelcore/worldcomm.hpp</includes>
    <includes id="importer_8hpp" name="importer.hpp" local="no" imported="no">feel/feelfilters/importer.hpp</includes>
    <includes id="gmshenums_8hpp" name="gmshenums.hpp" local="no" imported="no">feel/feelfilters/gmshenums.hpp</includes>
    <class kind="class">Feel::ImporterGmsh</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>pointsettomesh.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelfilters/</path>
    <filename>pointsettomesh_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="pointset_8hpp" name="pointset.hpp" local="no" imported="no">feel/feelmesh/pointset.hpp</includes>
    <includes id="filterfromvtk_8hpp" name="filterfromvtk.hpp" local="no" imported="no">feel/feelfilters/filterfromvtk.hpp</includes>
    <class kind="class">Feel::PointSetToMesh</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>convex.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>convex_8hpp</filename>
    <class kind="class">Feel::ConvexBase</class>
    <class kind="class">Feel::Convex</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>edges.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>edges_8hpp</filename>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>elements.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>elements_8hpp</filename>
    <includes id="filters_8hpp" name="filters.hpp" local="no" imported="no">feel/feelmesh/filters.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>entities.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>entities_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>faces.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>faces_8hpp</filename>
    <includes id="filters_8hpp" name="filters.hpp" local="no" imported="no">feel/feelmesh/filters.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>filters.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>filters_8hpp</filename>
    <class kind="struct">Feel::meta::elements</class>
    <class kind="struct">Feel::meta::markedelements</class>
    <class kind="struct">Feel::meta::marked2elements</class>
    <class kind="struct">Feel::meta::marked3elements</class>
    <namespace>Feel</namespace>
    <member kind="enumeration">
      <name>ElementsType</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9e8a34e55922ab08cf593c8f9addd590</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESH_ELEMENTS</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9e8a34e55922ab08cf593c8f9addd590aba9f37f6ea35ac09cf969b638eac11d6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESH_FACES</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9e8a34e55922ab08cf593c8f9addd590a45f482eab6ccb2dd97a838fbbf7b287a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESH_INTERNAL_FACES</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9e8a34e55922ab08cf593c8f9addd590abe2186af856a1d6b589ed5de3506af65</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESH_EDGES</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9e8a34e55922ab08cf593c8f9addd590a822c39538709589ddc423825b9adf5ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESH_INTERNAL_EDGES</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9e8a34e55922ab08cf593c8f9addd590a9ed28d0d616b5ede99732a77e43fdab7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESH_POINTS</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9e8a34e55922ab08cf593c8f9addd590a9a4435f4374f50c44d57dbbcff2b0fd3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>meshrank</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a3a611a63287304f88a12e560dbd90629</anchor>
      <arglist>(MeshType const &amp;mesh, mpl::bool_&lt; true &gt;)</arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>meshrank</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a64466ee2bf012a7c13439e586a218892</anchor>
      <arglist>(MeshType const &amp;mesh, mpl::bool_&lt; false &gt;)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::element_const_iterator, typename MeshTraits&lt; MeshType &gt;::element_const_iterator &gt;</type>
      <name>allelements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a65bb54325ae1f537f4343871c75d43c4</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::element_const_iterator, typename MeshTraits&lt; MeshType &gt;::element_const_iterator &gt;</type>
      <name>elements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a39073cc1999197bf9963bd5bdc86454a</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::location_element_const_iterator, typename MeshTraits&lt; MeshType &gt;::location_element_const_iterator &gt;</type>
      <name>boundaryelements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a5598068f2b33128787bb978b585f8aa6</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::location_element_const_iterator, typename MeshTraits&lt; MeshType &gt;::location_element_const_iterator &gt;</type>
      <name>internalelements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9a80650ba21cfe9d2f4ababe410a0ed5</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::marker_element_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker_element_const_iterator &gt;</type>
      <name>markedelements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad2c61f47b61321c8af13daff27760d1d</anchor>
      <arglist>(MeshType const &amp;mesh, flag_type flag)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::marker_element_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker_element_const_iterator &gt;</type>
      <name>markedelements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a465219e2d295ecae099f623082001ec3</anchor>
      <arglist>(MeshType const &amp;mesh, std::string const &amp;flag)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::marker2_element_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker2_element_const_iterator &gt;</type>
      <name>marked2elements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af03a372bfd8ffdca749fbe87870382a3</anchor>
      <arglist>(MeshType const &amp;mesh, flag_type flag)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::marker2_element_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker2_element_const_iterator &gt;</type>
      <name>marked2elements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a5cbae5f71c8741bd7c7e54cf82821765</anchor>
      <arglist>(MeshType const &amp;mesh, std::string const &amp;flag)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::marker3_element_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker3_element_const_iterator &gt;</type>
      <name>marked3elements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9c1fbba3985e58d2d69f253bc9c39d55</anchor>
      <arglist>(MeshType const &amp;mesh, flag_type flag)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::marker3_element_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker3_element_const_iterator &gt;</type>
      <name>marked3elements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a020c9a00143c386a8152bfa721e381bc</anchor>
      <arglist>(MeshType const &amp;mesh, std::string const &amp;flag)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::element_const_iterator, typename MeshTraits&lt; MeshType &gt;::element_const_iterator &gt;</type>
      <name>idedelements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a417351aa13cd75a3329e5da9ebb090f1</anchor>
      <arglist>(MeshType const &amp;mesh, flag_type flag)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::pid_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::pid_face_const_iterator &gt;</type>
      <name>faces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a12d0226a5e73e64f3b97bf9c723ee239</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::face_const_iterator, typename MeshTraits&lt; MeshType &gt;::face_const_iterator &gt;</type>
      <name>idedfaces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a93fd163019ef944e6b726ab5a3da416b</anchor>
      <arglist>(MeshType const &amp;mesh, size_type id)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::marker_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker_face_const_iterator &gt;</type>
      <name>markedfaces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ac0d40e0852d5f0d447623caff773b1a5</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::marker_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker_face_const_iterator &gt;</type>
      <name>markedfaces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a8c269014fc03793bb2bb2f611095d72b</anchor>
      <arglist>(MeshType const &amp;mesh, flag_type __marker)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::marker2_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker2_face_const_iterator &gt;</type>
      <name>marked2faces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9281983c555223853306d4fff3c91380</anchor>
      <arglist>(MeshType const &amp;mesh, flag_type __marker)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::marker3_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker3_face_const_iterator &gt;</type>
      <name>marked3faces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a96959a401f694a83d90a41be1ff5373c</anchor>
      <arglist>(MeshType const &amp;mesh, flag_type __marker)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::marker_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker_face_const_iterator &gt;</type>
      <name>markedfaces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a77ead35707351cadff85f33d7c93e671</anchor>
      <arglist>(MeshType const &amp;mesh, std::string const &amp;__marker)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::marker2_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker2_face_const_iterator &gt;</type>
      <name>marked2faces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4a34e6e25d4d8daed18a1b24f8c552ce</anchor>
      <arglist>(MeshType const &amp;mesh, std::string const &amp;__marker)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::marker3_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker3_face_const_iterator &gt;</type>
      <name>marked3faces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a080907b8132cfd4609a9c565bb6e7422</anchor>
      <arglist>(MeshType const &amp;mesh, std::string const &amp;__marker)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::location_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::location_face_const_iterator &gt;</type>
      <name>boundaryfaces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6d4deea03257c3f53b0e9df514a7bf00</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::location_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::location_face_const_iterator &gt;</type>
      <name>internalfaces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6c53147b25bf664bdf6bec2b30b56af7</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::interprocess_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::interprocess_face_const_iterator &gt;</type>
      <name>interprocessfaces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abc95225dae92e77cc06508c91b1be972</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_EDGES &gt;, typename MeshTraits&lt; MeshType &gt;::pid_edge_const_iterator, typename MeshTraits&lt; MeshType &gt;::pid_edge_const_iterator &gt;</type>
      <name>edges</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>acc2d630cda517a95be1879ea38fb5069</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_EDGES &gt;, typename MeshTraits&lt; MeshType &gt;::marker_edge_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker_edge_const_iterator &gt;</type>
      <name>markededges</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4262e71423eb1c1337e7085749ed2f1b</anchor>
      <arglist>(MeshType const &amp;mesh, flag_type __marker)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_EDGES &gt;, typename MeshTraits&lt; MeshType &gt;::location_edge_const_iterator, typename MeshTraits&lt; MeshType &gt;::location_edge_const_iterator &gt;</type>
      <name>boundaryedges</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a0f6104229c3e1de89e4e9dc0669db8b8</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_EDGES &gt;, typename MeshTraits&lt; MeshType &gt;::location_edge_const_iterator, typename MeshTraits&lt; MeshType &gt;::location_edge_const_iterator &gt;</type>
      <name>internaledges</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9decd4d08511d44ea9e33cdb35758ec1</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_POINTS &gt;, typename MeshTraits&lt; MeshType &gt;::point_const_iterator, typename MeshTraits&lt; MeshType &gt;::point_const_iterator &gt;</type>
      <name>points</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a07ec0494dee4ca9a16b866e8c1f4d495</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_POINTS &gt;, typename MeshTraits&lt; MeshType &gt;::marked_point_const_iterator, typename MeshTraits&lt; MeshType &gt;::marked_point_const_iterator &gt;</type>
      <name>markedpoints</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a509ff6e6780bd8c6e68d7a04e5eb6dd8</anchor>
      <arglist>(MeshType const &amp;mesh, size_type flag)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_POINTS &gt;, typename MeshTraits&lt; MeshType &gt;::location_point_const_iterator, typename MeshTraits&lt; MeshType &gt;::location_point_const_iterator &gt;</type>
      <name>boundarypoints</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a0bbc5b859c51ad73faa39f6ab301b8b9</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_POINTS &gt;, typename MeshTraits&lt; MeshType &gt;::location_point_const_iterator, typename MeshTraits&lt; MeshType &gt;::location_point_const_iterator &gt;</type>
      <name>internalpoints</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a5c10346e263af6fbc0709fb6084fcf6f</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>nelements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab1ef5097f689b224b4f31e80dbd80ee0</anchor>
      <arglist>(boost::tuple&lt; MT, Iterator, Iterator &gt; const &amp;its)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename std::list&lt; ElementType &gt;::const_iterator, typename std::list&lt; ElementType &gt;::const_iterator &gt;</type>
      <name>element</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a8a7f9780881297546a84f30d6290b4ef</anchor>
      <arglist>(ElementType const &amp;elt)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>functors.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>functors_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="functors_8hpp" name="functors.hpp" local="no" imported="no">feel/feelmesh/functors.hpp</includes>
    <namespace>Feel</namespace>
    <namespace>Feel::detail</namespace>
  </compound>
  <compound kind="file">
    <name>functors.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>functors_8hpp</filename>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <includes id="meshbase_8hpp" name="meshbase.hpp" local="no" imported="no">feel/feelmesh/meshbase.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>geoentity.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>geoentity_8hpp</filename>
    <includes id="simplex_8hpp" name="simplex.hpp" local="no" imported="no">feel/feelmesh/simplex.hpp</includes>
    <includes id="hypercube_8hpp" name="hypercube.hpp" local="no" imported="no">feel/feelmesh/hypercube.hpp</includes>
    <includes id="refentity_8hpp" name="refentity.hpp" local="no" imported="no">feel/feelmesh/refentity.hpp</includes>
    <class kind="class">Feel::GeoEntity</class>
    <class kind="struct">Feel::GeoEntity::reference_convex</class>
    <namespace>Feel</namespace>
    <member kind="typedef">
      <type>GeoEntity&lt; Simplex&lt; 0, 1 &gt; &gt;</type>
      <name>GeoPoint</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a74db81de44a0fd14a2cff6dd560c79e9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Simplex&lt; 1, 1 &gt; &gt;</type>
      <name>LinearLine</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6d2c0e4400a583108eddd07924a7efbe</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Simplex&lt; 2, 1 &gt; &gt;</type>
      <name>LinearTriangle</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6d9f98083fe43591a3df3f1c66e0a503</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Simplex&lt; 3, 1 &gt; &gt;</type>
      <name>LinearTetra</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af6e7e6db1f514bc719d76d6fb70e7342</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Simplex&lt; 1, 2 &gt; &gt;</type>
      <name>QuadraticLine</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a67a04bf7ff4a9816a59d4b5249306482</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Simplex&lt; 2, 2 &gt; &gt;</type>
      <name>QuadraticTriangle</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a8b25ed1719bf35fde9411f4646a82f45</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Simplex&lt; 3, 2 &gt; &gt;</type>
      <name>QuadraticTetra</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aa2a9a66dec5148ee9da653dd463caa58</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Hypercube&lt; 2, 1 &gt; &gt;</type>
      <name>LinearQuad</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aa26ad57ffeacade434cfc9207ea68f24</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Hypercube&lt; 3, 1 &gt; &gt;</type>
      <name>LinearHexa</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af0f788f8baf007f1592a441757e5552a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Hypercube&lt; 2, 2 &gt; &gt;</type>
      <name>QuadraticQuad</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a3c49547f1af9e3f902f4d70d539482c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Hypercube&lt; 3, 2 &gt; &gt;</type>
      <name>QuadraticHexa</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a8bb5ccdd680d6db84f87a0eb3df01b16</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>geond.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>geond_8hpp</filename>
    <includes id="geoentity_8hpp" name="geoentity.hpp" local="no" imported="no">feel/feelmesh/geoentity.hpp</includes>
    <includes id="meshbase_8hpp" name="meshbase.hpp" local="no" imported="no">feel/feelmesh/meshbase.hpp</includes>
    <class kind="class">Feel::GeoND</class>
    <class kind="struct">Feel::GeoND::GetGm</class>
    <class kind="struct">Feel::GeoND::tt</class>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6e9efb8209b23996b939957a25b5a90b</anchor>
      <arglist>(DebugStream &amp;__os, GeoND&lt; Dim, GEOSHAPE, T, POINTTYPE &gt; const &amp;__n)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6129de96ce2707aa94eb22cb8e2a7321</anchor>
      <arglist>(NdebugStream &amp;__os, GeoND&lt; Dim, GEOSHAPE, T, POINTTYPE &gt; const &amp;__n)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>hypercube.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>hypercube_8cpp</filename>
    <includes id="hypercube_8hpp" name="hypercube.hpp" local="no" imported="no">feel/feelmesh/hypercube.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>hypercube.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>hypercube_8hpp</filename>
    <includes id="convex_8hpp" name="convex.hpp" local="no" imported="no">feel/feelmesh/convex.hpp</includes>
    <includes id="hypercubeordering_8hpp" name="hypercubeordering.hpp" local="no" imported="no">feel/feelmesh/hypercubeordering.hpp</includes>
    <class kind="class">Feel::Hypercube</class>
    <class kind="struct">Feel::Hypercube::faces_t</class>
    <class kind="struct">Feel::Hypercube::shape</class>
    <class kind="struct">Feel::Hypercube::PolyDims</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>hypercubeordering.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>hypercubeordering_8hpp</filename>
    <includes id="lineordering_8hpp" name="lineordering.hpp" local="no" imported="no">feel/feelmesh/lineordering.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>kdtree.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>kdtree_8cpp</filename>
    <includes id="kdtree_8hpp" name="kdtree.hpp" local="no" imported="no">feel/feelmesh/kdtree.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>kdtree.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>kdtree_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <class kind="class">Feel::KDTree</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>lineordering.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>lineordering_8hpp</filename>
  </compound>
  <compound kind="file">
    <name>mesh0d.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>mesh0d_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="visitor_8hpp" name="visitor.hpp" local="no" imported="no">feel/feelcore/visitor.hpp</includes>
    <includes id="meshbase_8hpp" name="meshbase.hpp" local="no" imported="no">feel/feelmesh/meshbase.hpp</includes>
    <includes id="elements_8hpp" name="elements.hpp" local="no" imported="no">feel/feelmesh/elements.hpp</includes>
    <includes id="points_8hpp" name="points.hpp" local="no" imported="no">feel/feelmesh/points.hpp</includes>
    <class kind="class">Feel::Mesh0D</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>mesh1d.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>mesh1d_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="visitor_8hpp" name="visitor.hpp" local="no" imported="no">feel/feelcore/visitor.hpp</includes>
    <includes id="meshbase_8hpp" name="meshbase.hpp" local="no" imported="no">feel/feelmesh/meshbase.hpp</includes>
    <includes id="elements_8hpp" name="elements.hpp" local="no" imported="no">feel/feelmesh/elements.hpp</includes>
    <includes id="faces_8hpp" name="faces.hpp" local="no" imported="no">feel/feelmesh/faces.hpp</includes>
    <includes id="points_8hpp" name="points.hpp" local="no" imported="no">feel/feelmesh/points.hpp</includes>
    <class kind="class">Feel::Mesh1D</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>mesh2d.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>mesh2d_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="visitor_8hpp" name="visitor.hpp" local="no" imported="no">feel/feelcore/visitor.hpp</includes>
    <includes id="meshbase_8hpp" name="meshbase.hpp" local="no" imported="no">feel/feelmesh/meshbase.hpp</includes>
    <includes id="elements_8hpp" name="elements.hpp" local="no" imported="no">feel/feelmesh/elements.hpp</includes>
    <includes id="faces_8hpp" name="faces.hpp" local="no" imported="no">feel/feelmesh/faces.hpp</includes>
    <includes id="points_8hpp" name="points.hpp" local="no" imported="no">feel/feelmesh/points.hpp</includes>
    <includes id="functors_8hpp" name="functors.hpp" local="no" imported="no">feel/feelmesh/functors.hpp</includes>
    <class kind="class">Feel::Mesh2D</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>mesh3d.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>mesh3d_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="visitor_8hpp" name="visitor.hpp" local="no" imported="no">feel/feelcore/visitor.hpp</includes>
    <includes id="meshbase_8hpp" name="meshbase.hpp" local="no" imported="no">feel/feelmesh/meshbase.hpp</includes>
    <includes id="elements_8hpp" name="elements.hpp" local="no" imported="no">feel/feelmesh/elements.hpp</includes>
    <includes id="faces_8hpp" name="faces.hpp" local="no" imported="no">feel/feelmesh/faces.hpp</includes>
    <includes id="edges_8hpp" name="edges.hpp" local="no" imported="no">feel/feelmesh/edges.hpp</includes>
    <includes id="points_8hpp" name="points.hpp" local="no" imported="no">feel/feelmesh/points.hpp</includes>
    <includes id="functors_8hpp" name="functors.hpp" local="no" imported="no">feel/feelmesh/functors.hpp</includes>
    <class kind="class">Feel::Mesh3D</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>meshadaptation.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>meshadaptation_8hpp</filename>
    <includes id="backend_8hpp" name="backend.hpp" local="no" imported="no">feel/feelalg/backend.hpp</includes>
    <includes id="gmsh_8hpp" name="gmsh.hpp" local="no" imported="no">feel/feelfilters/gmsh.hpp</includes>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <class kind="class">Feel::MeshAdaptation</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>meshbase.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>meshbase_8cpp</filename>
    <includes id="meshbase_8hpp" name="meshbase.hpp" local="no" imported="no">feel/feelmesh/meshbase.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>meshbase.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>meshbase_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="worldcomm_8hpp" name="worldcomm.hpp" local="no" imported="no">feel/feelcore/worldcomm.hpp</includes>
    <class kind="class">Feel::MeshBase</class>
    <namespace>Feel</namespace>
    <member kind="enumeration">
      <name>MeshComponents</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a82cf55da340f64b682d0bea678d6cdf4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const uint16_type</type>
      <name>MESH_ALL_COMPONENTS</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>adc5de8514aa86afe25c80845e67ed0ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const uint16_type</type>
      <name>MESH_COMPONENTS_DEFAULTS</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abb3d68ba0c883c2d7cbd75e7f37e4231</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>meshmover.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>meshmover_8cpp</filename>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>points.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>points_8hpp</filename>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>pointset.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>pointset_8hpp</filename>
    <includes id="refentity_8hpp" name="refentity.hpp" local="no" imported="no">feel/feelmesh/refentity.hpp</includes>
    <includes id="visitor_8hpp" name="visitor.hpp" local="no" imported="no">feel/feelcore/visitor.hpp</includes>
    <class kind="class">Feel::PointSet</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>refentity.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>refentity_8hpp</filename>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <includes id="lu_8hpp" name="lu.hpp" local="no" imported="no">feel/feelalg/lu.hpp</includes>
    <includes id="simplex_8hpp" name="simplex.hpp" local="no" imported="no">feel/feelmesh/simplex.hpp</includes>
    <includes id="hypercube_8hpp" name="hypercube.hpp" local="no" imported="no">feel/feelmesh/hypercube.hpp</includes>
    <includes id="refsimplex_8hpp" name="refsimplex.hpp" local="no" imported="no">feel/feelmesh/refsimplex.hpp</includes>
    <includes id="refhypercube_8hpp" name="refhypercube.hpp" local="no" imported="no">feel/feelmesh/refhypercube.hpp</includes>
    <class kind="class">Feel::Entity</class>
    <class kind="class">Feel::Reference</class>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a90c5c4c172c3b27d2de64682a02c6319</anchor>
      <arglist>(std::ostream &amp;os, Reference&lt; Geo, Dim, Order, RDim, T &gt; const &amp;ref)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>toPython</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab3cd6c0bc878c473c33e3b67057ca823</anchor>
      <arglist>(RefEntity const &amp;e, std::string str=&quot;simplex&quot;)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>refhypercube.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>refhypercube_8hpp</filename>
    <class kind="class">Feel::Reference&lt; Hypercube&lt; Dim, Order, RDim &gt;, Dim, Order, RDim, T &gt;</class>
    <class kind="struct">Feel::Reference&lt; Hypercube&lt; Dim, Order, RDim &gt;, Dim, Order, RDim, T &gt;::pt_to_edge</class>
    <class kind="struct">Feel::Reference&lt; Hypercube&lt; Dim, Order, RDim &gt;, Dim, Order, RDim, T &gt;::pt_to_face</class>
    <class kind="struct">Feel::Reference&lt; Hypercube&lt; Dim, Order, RDim &gt;, Dim, Order, RDim, T &gt;::pt_to_element</class>
    <class kind="struct">Feel::Reference&lt; Hypercube&lt; Dim, Order, RDim &gt;, Dim, Order, RDim, T &gt;::pt_to_entity</class>
    <class kind="class">Feel::Entity&lt; SHAPE_QUAD, T &gt;</class>
    <class kind="class">Feel::Entity&lt; SHAPE_HEXA, T &gt;</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>refsimplex.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>refsimplex_8hpp</filename>
    <class kind="class">Feel::Reference&lt; Simplex&lt; Dim, Order, RDim &gt;, Dim, Order, RDim, T &gt;</class>
    <class kind="struct">Feel::Reference&lt; Simplex&lt; Dim, Order, RDim &gt;, Dim, Order, RDim, T &gt;::pt_to_edge</class>
    <class kind="struct">Feel::Reference&lt; Simplex&lt; Dim, Order, RDim &gt;, Dim, Order, RDim, T &gt;::pt_to_face</class>
    <class kind="struct">Feel::Reference&lt; Simplex&lt; Dim, Order, RDim &gt;, Dim, Order, RDim, T &gt;::pt_to_element</class>
    <class kind="struct">Feel::Reference&lt; Simplex&lt; Dim, Order, RDim &gt;, Dim, Order, RDim, T &gt;::pt_to_entity</class>
    <class kind="class">Feel::Entity&lt; SHAPE_LINE, T &gt;</class>
    <class kind="class">Feel::Entity&lt; SHAPE_TRIANGLE, T &gt;</class>
    <class kind="class">Feel::Entity&lt; SHAPE_TETRA, T &gt;</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>simplex.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>simplex_8cpp</filename>
    <includes id="simplex_8hpp" name="simplex.hpp" local="no" imported="no">feel/feelmesh/simplex.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>simplex.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>simplex_8hpp</filename>
    <includes id="convex_8hpp" name="convex.hpp" local="no" imported="no">feel/feelmesh/convex.hpp</includes>
    <class kind="struct">Feel::details::points</class>
    <class kind="struct">Feel::details::points&lt; 0 &gt;</class>
    <class kind="class">Feel::Simplex</class>
    <class kind="struct">Feel::Simplex::faces_t</class>
    <class kind="struct">Feel::Simplex::shape</class>
    <class kind="struct">Feel::Line</class>
    <class kind="struct">Feel::Triangle</class>
    <class kind="struct">Feel::Tetrahedron</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>sphere.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>sphere_8hpp</filename>
    <includes id="surface_8hpp" name="surface.hpp" local="no" imported="no">feel/feelmesh/surface.hpp</includes>
    <class kind="class">Feel::Sphere</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>structuredgrid.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>structuredgrid_8hpp</filename>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <class kind="class">Feel::StructuredGrid</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>surface.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelmesh/</path>
    <filename>surface_8hpp</filename>
    <class kind="class">Feel::Surface</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>basis.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>basis_8hpp</filename>
    <class kind="class">Feel::Basis</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>boundadapted.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>boundadapted_8hpp</filename>
    <includes id="refentity_8hpp" name="refentity.hpp" local="no" imported="no">feel/feelmesh/refentity.hpp</includes>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <includes id="equispaced_8hpp" name="equispaced.hpp" local="no" imported="no">feel/feelpoly/equispaced.hpp</includes>
    <includes id="principal_8hpp" name="principal.hpp" local="no" imported="no">feel/feelpoly/principal.hpp</includes>
    <includes id="basis_8hpp" name="basis.hpp" local="no" imported="no">feel/feelpoly/basis.hpp</includes>
    <class kind="struct">Feel::BoundaryAdaptedTraits</class>
    <class kind="struct">Feel::BoundaryAdaptedTraits::Convex</class>
    <class kind="struct">Feel::BoundaryAdaptedTraits::ChangeValueType</class>
    <class kind="struct">Feel::BoundaryAdaptedTraits::ChangeOrder</class>
    <class kind="struct">Feel::BoundaryAdaptedTag</class>
    <class kind="class">Feel::BoundaryAdapted</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>boundaryadaptedpolynomialset.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>boundaryadaptedpolynomialset_8hpp</filename>
  </compound>
  <compound kind="file">
    <name>constrainedpolynomialset.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>constrainedpolynomialset_8hpp</filename>
    <class kind="class">Feel::ConstrainedPolynomialSet</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>continuity.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>continuity_8hpp</filename>
    <class kind="struct">Feel::detail::continuity_base</class>
    <class kind="class">Feel::Continuous</class>
    <class kind="class">Feel::Continuous::apply</class>
    <namespace>Feel</namespace>
    <namespace>Feel::detail</namespace>
  </compound>
  <compound kind="file">
    <name>crouzeixraviart.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>crouzeixraviart_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="lu_8hpp" name="lu.hpp" local="no" imported="no">feel/feelalg/lu.hpp</includes>
    <includes id="refentity_8hpp" name="refentity.hpp" local="no" imported="no">feel/feelmesh/refentity.hpp</includes>
    <includes id="pointset_8hpp" name="pointset.hpp" local="no" imported="no">feel/feelmesh/pointset.hpp</includes>
    <includes id="fe_8hpp" name="fe.hpp" local="no" imported="no">feel/feelpoly/fe.hpp</includes>
    <includes id="dualbasis_8hpp" name="dualbasis.hpp" local="no" imported="no">feel/feelpoly/dualbasis.hpp</includes>
    <includes id="polynomialset_8hpp" name="polynomialset.hpp" local="no" imported="no">feel/feelpoly/polynomialset.hpp</includes>
    <includes id="functionalset_8hpp" name="functionalset.hpp" local="no" imported="no">feel/feelpoly/functionalset.hpp</includes>
    <includes id="moment_8hpp" name="moment.hpp" local="no" imported="no">feel/feelpoly/moment.hpp</includes>
    <class kind="class">Feel::fem::detail::RannacherTurekPolynomialSet</class>
    <class kind="class">Feel::fem::detail::CrouzeixRaviartDual</class>
    <class kind="class">Feel::fem::CrouzeixRaviart</class>
    <class kind="class">Feel::CrouzeixRaviart</class>
    <class kind="struct">Feel::CrouzeixRaviart::apply</class>
    <class kind="struct">Feel::CrouzeixRaviart::ChangeTag</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>discontinuous.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>discontinuous_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="discontinuous_8hpp" name="discontinuous.hpp" local="no" imported="no">feel/feelpoly/discontinuous.hpp</includes>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>discontinuous.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>discontinuous_8hpp</filename>
    <includes id="continuity_8hpp" name="continuity.hpp" local="no" imported="no">feel/feelpoly/continuity.hpp</includes>
    <class kind="class">Feel::Discontinuous</class>
    <class kind="class">Feel::Discontinuous::apply</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>discontinuousinterfaces.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>discontinuousinterfaces_8hpp</filename>
    <includes id="continuity_8hpp" name="continuity.hpp" local="no" imported="no">feel/feelpoly/continuity.hpp</includes>
    <class kind="class">Feel::DiscontinuousInterfaces</class>
    <class kind="class">Feel::DiscontinuousInterfaces::apply</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>dualbasis.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>dualbasis_8hpp</filename>
    <class kind="class">Feel::DualBasis</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>dubiner.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>dubiner_8hpp</filename>
    <includes id="refentity_8hpp" name="refentity.hpp" local="no" imported="no">feel/feelmesh/refentity.hpp</includes>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <includes id="lu_8hpp" name="lu.hpp" local="no" imported="no">feel/feelalg/lu.hpp</includes>
    <includes id="expansions_8hpp" name="expansions.hpp" local="no" imported="no">feel/feelpoly/expansions.hpp</includes>
    <includes id="pointset_8hpp" name="pointset.hpp" local="no" imported="no">feel/feelmesh/pointset.hpp</includes>
    <includes id="equispaced_8hpp" name="equispaced.hpp" local="no" imported="no">feel/feelpoly/equispaced.hpp</includes>
    <includes id="warpblend_8hpp" name="warpblend.hpp" local="no" imported="no">feel/feelpoly/warpblend.hpp</includes>
    <includes id="expansiontypes_8hpp" name="expansiontypes.hpp" local="no" imported="no">feel/feelpoly/expansiontypes.hpp</includes>
    <class kind="struct">Feel::DubinerTraits</class>
    <class kind="struct">Feel::DubinerTraits::Convex</class>
    <class kind="struct">Feel::DubinerTraits::ChangeValueType</class>
    <class kind="struct">Feel::DubinerTraits::ChangeOrder</class>
    <class kind="struct">Feel::DubinerTag</class>
    <class kind="class">Feel::Dubiner</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>electrostatic.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>electrostatic_8hpp</filename>
    <includes id="warpblend_8hpp" name="warpblend.hpp" local="no" imported="no">feel/feelpoly/warpblend.hpp</includes>
    <class kind="class">Feel::PointSetElectrostatic</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>equispaced.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>equispaced_8hpp</filename>
    <includes id="refentity_8hpp" name="refentity.hpp" local="no" imported="no">feel/feelmesh/refentity.hpp</includes>
    <includes id="pointset_8hpp" name="pointset.hpp" local="no" imported="no">feel/feelmesh/pointset.hpp</includes>
    <includes id="simplex_8hpp" name="simplex.hpp" local="no" imported="no">feel/feelmesh/simplex.hpp</includes>
    <includes id="hypercube_8hpp" name="hypercube.hpp" local="no" imported="no">feel/feelmesh/hypercube.hpp</includes>
    <includes id="visitor_8hpp" name="visitor.hpp" local="no" imported="no">feel/feelcore/visitor.hpp</includes>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <class kind="class">Feel::PointSetEquiSpaced</class>
    <class kind="struct">Feel::PointSetEquiSpaced::pt_to_edge</class>
    <class kind="struct">Feel::PointSetEquiSpaced::pt_to_face_tetrahedron</class>
    <class kind="struct">Feel::PointSetEquiSpaced::pt_to_face_hexahedron</class>
    <class kind="struct">Feel::PointSetEquiSpaced::pt_to_element</class>
    <class kind="struct">Feel::PointSetEquiSpaced::pt_to_entity_tetrahedron</class>
    <class kind="struct">Feel::PointSetEquiSpaced::pt_to_entity_hexahedron</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>expansions.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>expansions_8hpp</filename>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <includes id="refentity_8hpp" name="refentity.hpp" local="no" imported="no">feel/feelmesh/refentity.hpp</includes>
    <includes id="jacobi_8hpp" name="jacobi.hpp" local="no" imported="no">feel/feelpoly/jacobi.hpp</includes>
    <class kind="struct">Feel::DimFromShape</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>expansiontypes.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>expansiontypes_8hpp</filename>
    <includes id="continuity_8hpp" name="continuity.hpp" local="no" imported="no">feel/feelpoly/continuity.hpp</includes>
    <includes id="discontinuous_8hpp" name="discontinuous.hpp" local="no" imported="no">feel/feelpoly/discontinuous.hpp</includes>
    <includes id="discontinuousinterfaces_8hpp" name="discontinuousinterfaces.hpp" local="no" imported="no">feel/feelpoly/discontinuousinterfaces.hpp</includes>
  </compound>
  <compound kind="file">
    <name>fe.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>fe_8hpp</filename>
    <includes id="polynomialset_8hpp" name="polynomialset.hpp" local="no" imported="no">feel/feelpoly/polynomialset.hpp</includes>
    <class kind="class">Feel::FiniteElement</class>
    <namespace>Feel</namespace>
    <namespace>Feel::detail</namespace>
  </compound>
  <compound kind="file">
    <name>fekete.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>fekete_8hpp</filename>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <includes id="pointsetinterpolation_8hpp" name="pointsetinterpolation.hpp" local="no" imported="no">feel/feelpoly/pointsetinterpolation.hpp</includes>
    <includes id="warpblend_8hpp" name="warpblend.hpp" local="no" imported="no">feel/feelpoly/warpblend.hpp</includes>
    <includes id="gausslobatto_8hpp" name="gausslobatto.hpp" local="no" imported="no">feel/feelpoly/gausslobatto.hpp</includes>
    <includes id="equispaced_8hpp" name="equispaced.hpp" local="no" imported="no">feel/feelpoly/equispaced.hpp</includes>
    <class kind="class">Feel::PointSetFeketeSimplex</class>
    <class kind="class">Feel::PointSetFekete</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>functional.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>functional_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <class kind="class">Feel::Functional</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>functionals.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>functionals_8hpp</filename>
    <includes id="functional_8hpp" name="functional.hpp" local="no" imported="no">feel/feelpoly/functional.hpp</includes>
    <class kind="class">Feel::functional::PointEvaluation</class>
    <class kind="class">Feel::functional::ComponentPointEvaluation</class>
    <class kind="class">Feel::functional::PointDerivative</class>
    <class kind="class">Feel::functional::PointsEvaluation</class>
    <class kind="class">Feel::functional::PointsDerivative</class>
    <class kind="class">Feel::functional::PointsGradient</class>
    <class kind="class">Feel::functional::ComponentsPointsEvaluation</class>
    <class kind="class">Feel::functional::DirectionalComponentPointEvaluation</class>
    <class kind="class">Feel::functional::DirectionalComponentPointsEvaluation</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>functionals2.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>functionals2_8hpp</filename>
    <includes id="functional_8hpp" name="functional.hpp" local="no" imported="no">feel/feelpoly/functional.hpp</includes>
    <includes id="im_8hpp" name="im.hpp" local="no" imported="no">feel/feelpoly/im.hpp</includes>
    <class kind="class">Feel::functional::IntegralMoment</class>
    <class kind="struct">Feel::functional::detail::prod</class>
    <class kind="class">Feel::functional::IntegralMomentOnFace</class>
    <class kind="class">Feel::functional::IntegralMomentsOnFace</class>
    <class kind="class">Feel::functional::IntegralMomentOfDerivative</class>
    <class kind="class">Feel::functional::IntegralMomentOfDivergence</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>functionalset.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>functionalset_8hpp</filename>
    <includes id="functional_8hpp" name="functional.hpp" local="no" imported="no">feel/feelpoly/functional.hpp</includes>
    <class kind="class">Feel::FunctionalSet</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>gauss.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>gauss_8hpp</filename>
    <class kind="class">Feel::Gauss</class>
    <class kind="class">Feel::Gauss&lt; Simplex&lt; 0, 1 &gt;, Integration_Degree, T &gt;</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>gausslobatto.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>gausslobatto_8hpp</filename>
    <includes id="refentity_8hpp" name="refentity.hpp" local="no" imported="no">feel/feelmesh/refentity.hpp</includes>
    <includes id="visitor_8hpp" name="visitor.hpp" local="no" imported="no">feel/feelcore/visitor.hpp</includes>
    <includes id="jacobi_8hpp" name="jacobi.hpp" local="no" imported="no">feel/feelpoly/jacobi.hpp</includes>
    <includes id="pointsetinterpolation_8hpp" name="pointsetinterpolation.hpp" local="no" imported="no">feel/feelpoly/pointsetinterpolation.hpp</includes>
    <includes id="hypercube_8hpp" name="hypercube.hpp" local="no" imported="no">feel/feelmesh/hypercube.hpp</includes>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <class kind="class">Feel::GaussLobatto</class>
    <class kind="class">Feel::PointSetGaussLobatto</class>
    <class kind="struct">Feel::PointSetGaussLobatto::pt_to_edge</class>
    <class kind="struct">Feel::PointSetGaussLobatto::pt_to_face_hexahedron</class>
    <class kind="struct">Feel::PointSetGaussLobatto::pt_to_element</class>
    <class kind="struct">Feel::PointSetGaussLobatto::pt_to_entity_hexahedron</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>geomapinv.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>geomapinv_8hpp</filename>
    <includes id="kdtree_8hpp" name="kdtree.hpp" local="no" imported="no">feel/feelmesh/kdtree.hpp</includes>
    <class kind="class">Feel::GeoMapInverse</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>hermite.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>hermite_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="lu_8hpp" name="lu.hpp" local="no" imported="no">feel/feelalg/lu.hpp</includes>
    <includes id="refentity_8hpp" name="refentity.hpp" local="no" imported="no">feel/feelmesh/refentity.hpp</includes>
    <includes id="pointset_8hpp" name="pointset.hpp" local="no" imported="no">feel/feelmesh/pointset.hpp</includes>
    <includes id="equispaced_8hpp" name="equispaced.hpp" local="no" imported="no">feel/feelpoly/equispaced.hpp</includes>
    <includes id="dualbasis_8hpp" name="dualbasis.hpp" local="no" imported="no">feel/feelpoly/dualbasis.hpp</includes>
    <includes id="polynomialset_8hpp" name="polynomialset.hpp" local="no" imported="no">feel/feelpoly/polynomialset.hpp</includes>
    <includes id="functionalset_8hpp" name="functionalset.hpp" local="no" imported="no">feel/feelpoly/functionalset.hpp</includes>
    <includes id="functionals_8hpp" name="functionals.hpp" local="no" imported="no">feel/feelpoly/functionals.hpp</includes>
    <includes id="fe_8hpp" name="fe.hpp" local="no" imported="no">feel/feelpoly/fe.hpp</includes>
    <class kind="class">Feel::fem::Hermite</class>
    <class kind="class">Feel::Hermite</class>
    <class kind="struct">Feel::Hermite::apply</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>im.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>im_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <includes id="gauss_8hpp" name="gauss.hpp" local="no" imported="no">feel/feelpoly/gauss.hpp</includes>
    <includes id="gausslobatto_8hpp" name="gausslobatto.hpp" local="no" imported="no">feel/feelpoly/gausslobatto.hpp</includes>
    <includes id="imsimplex_8hpp" name="imsimplex.hpp" local="no" imported="no">feel/feelpoly/imsimplex.hpp</includes>
    <includes id="imexact_8hpp" name="imexact.hpp" local="no" imported="no">feel/feelpoly/imexact.hpp</includes>
    <class kind="struct">Feel::JacobiDegree</class>
    <class kind="struct">Feel::IntegrationDegree</class>
    <class kind="class">Feel::IMGeneral</class>
    <class kind="class">Feel::IM</class>
    <class kind="struct">Feel::IM::apply</class>
    <class kind="struct">Feel::_Q</class>
    <class kind="struct">Feel::_Q::apply</class>
    <class kind="struct">Feel::_Q::applyContext</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>imexact.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>imexact_8hpp</filename>
    <class kind="class">Feel::IMExact</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>imsimplex.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>imsimplex_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="gauss_8hpp" name="gauss.hpp" local="no" imported="no">feel/feelpoly/gauss.hpp</includes>
  </compound>
  <compound kind="file">
    <name>jacobi.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>jacobi_8hpp</filename>
    <class kind="class">Feel::Jacobi</class>
    <class kind="class">Feel::dyna::Jacobi</class>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>ublas::matrix&lt; T &gt;</type>
      <name>JacobiBatchEvaluation</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a92e5d97033361931e9c040004731a4d2</anchor>
      <arglist>(T a, T b, ublas::vector&lt; T &gt; const &amp;__pts)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>JacobiBatchDerivation</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ae1a78bccb3df78ff41e2f93fa0153348</anchor>
      <arglist>(ublas::matrix&lt; T &gt; &amp;res, T a, T b, ublas::vector&lt; T &gt; const &amp;__pts, mpl::bool_&lt; true &gt;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>JacobiBatchDerivation</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a3e83087e6d0b147b0e4cef3a907241f2</anchor>
      <arglist>(ublas::matrix&lt; T &gt; &amp;, T, T, ublas::vector&lt; T &gt; const &amp;, mpl::bool_&lt; false &gt;)</arglist>
    </member>
    <member kind="function">
      <type>ublas::matrix&lt; T &gt;</type>
      <name>JacobiBatchDerivation</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a0b254a7aa3fb62a6bae02dae0f66284d</anchor>
      <arglist>(T a, T b, ublas::vector&lt; T &gt; const &amp;__pts)</arglist>
    </member>
    <member kind="function">
      <type>ublas::matrix&lt; T &gt;</type>
      <name>JacobiBatchEvaluation</name>
      <anchorfile>namespaceFeel_1_1dyna.html</anchorfile>
      <anchor>a176f1e5c7b6356fd9da2d47105362225</anchor>
      <arglist>(uint16_type N, T a, T b, ublas::vector&lt; T &gt; const &amp;__pts)</arglist>
    </member>
    <member kind="function">
      <type>ublas::matrix&lt; T &gt;</type>
      <name>JacobiBatchDerivation</name>
      <anchorfile>namespaceFeel_1_1dyna.html</anchorfile>
      <anchor>a05b414bd33f64ded7f872c8073dac243</anchor>
      <arglist>(uint16_type N, T a, T b, ublas::vector&lt; T &gt; const &amp;__pts)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>lagrange.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>lagrange_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="lu_8hpp" name="lu.hpp" local="no" imported="no">feel/feelalg/lu.hpp</includes>
    <includes id="refentity_8hpp" name="refentity.hpp" local="no" imported="no">feel/feelmesh/refentity.hpp</includes>
    <includes id="pointset_8hpp" name="pointset.hpp" local="no" imported="no">feel/feelmesh/pointset.hpp</includes>
    <includes id="equispaced_8hpp" name="equispaced.hpp" local="no" imported="no">feel/feelpoly/equispaced.hpp</includes>
    <includes id="dualbasis_8hpp" name="dualbasis.hpp" local="no" imported="no">feel/feelpoly/dualbasis.hpp</includes>
    <includes id="polynomialset_8hpp" name="polynomialset.hpp" local="no" imported="no">feel/feelpoly/polynomialset.hpp</includes>
    <includes id="functionalset_8hpp" name="functionalset.hpp" local="no" imported="no">feel/feelpoly/functionalset.hpp</includes>
    <includes id="functionals_8hpp" name="functionals.hpp" local="no" imported="no">feel/feelpoly/functionals.hpp</includes>
    <includes id="fe_8hpp" name="fe.hpp" local="no" imported="no">feel/feelpoly/fe.hpp</includes>
    <class kind="class">Feel::fem::Lagrange</class>
    <class kind="class">Feel::Lagrange</class>
    <class kind="struct">Feel::Lagrange::apply</class>
    <class kind="struct">Feel::Lagrange::ChangeTag</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>lebesgue.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>lebesgue_8hpp</filename>
    <includes id="equispaced_8hpp" name="equispaced.hpp" local="no" imported="no">feel/feelpoly/equispaced.hpp</includes>
    <includes id="lagrange_8hpp" name="lagrange.hpp" local="no" imported="no">feel/feelpoly/lagrange.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>value_type</type>
      <name>lebesgueConstant</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abe83662b21458912bee13bc5a4f46662</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>legendre.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>legendre_8hpp</filename>
    <includes id="refentity_8hpp" name="refentity.hpp" local="no" imported="no">feel/feelmesh/refentity.hpp</includes>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <includes id="lu_8hpp" name="lu.hpp" local="no" imported="no">feel/feelalg/lu.hpp</includes>
    <includes id="expansions_8hpp" name="expansions.hpp" local="no" imported="no">feel/feelpoly/expansions.hpp</includes>
    <includes id="gausslobatto_8hpp" name="gausslobatto.hpp" local="no" imported="no">feel/feelpoly/gausslobatto.hpp</includes>
    <includes id="equispaced_8hpp" name="equispaced.hpp" local="no" imported="no">feel/feelpoly/equispaced.hpp</includes>
    <includes id="expansiontypes_8hpp" name="expansiontypes.hpp" local="no" imported="no">feel/feelpoly/expansiontypes.hpp</includes>
    <class kind="struct">Feel::LegendreTraits</class>
    <class kind="struct">Feel::LegendreTraits::Convex</class>
    <class kind="struct">Feel::LegendreTraits::ChangeValueType</class>
    <class kind="struct">Feel::LegendreTraits::ChangeOrder</class>
    <class kind="struct">Feel::LegendreTag</class>
    <class kind="class">Feel::Legendre</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>mapped.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>mapped_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="visitor_8hpp" name="visitor.hpp" local="no" imported="no">feel/feelcore/visitor.hpp</includes>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <includes id="refentity_8hpp" name="refentity.hpp" local="no" imported="no">feel/feelmesh/refentity.hpp</includes>
    <includes id="equispaced_8hpp" name="equispaced.hpp" local="no" imported="no">feel/feelpoly/equispaced.hpp</includes>
    <class kind="class">Feel::PointSetMapped</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>moment.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>moment_8hpp</filename>
    <includes id="hypercube_8hpp" name="hypercube.hpp" local="no" imported="no">feel/feelmesh/hypercube.hpp</includes>
    <includes id="simplex_8hpp" name="simplex.hpp" local="no" imported="no">feel/feelmesh/simplex.hpp</includes>
    <includes id="refentity_8hpp" name="refentity.hpp" local="no" imported="no">feel/feelmesh/refentity.hpp</includes>
    <includes id="lu_8hpp" name="lu.hpp" local="no" imported="no">feel/feelalg/lu.hpp</includes>
    <includes id="expansions_8hpp" name="expansions.hpp" local="no" imported="no">feel/feelpoly/expansions.hpp</includes>
    <includes id="polynomialset_8hpp" name="polynomialset.hpp" local="no" imported="no">feel/feelpoly/polynomialset.hpp</includes>
    <includes id="continuity_8hpp" name="continuity.hpp" local="no" imported="no">feel/feelpoly/continuity.hpp</includes>
    <includes id="discontinuous_8hpp" name="discontinuous.hpp" local="no" imported="no">feel/feelpoly/discontinuous.hpp</includes>
  </compound>
  <compound kind="file">
    <name>nedelec.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>nedelec_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="lu_8hpp" name="lu.hpp" local="no" imported="no">feel/feelalg/lu.hpp</includes>
    <includes id="refentity_8hpp" name="refentity.hpp" local="no" imported="no">feel/feelmesh/refentity.hpp</includes>
    <includes id="pointset_8hpp" name="pointset.hpp" local="no" imported="no">feel/feelmesh/pointset.hpp</includes>
    <includes id="dualbasis_8hpp" name="dualbasis.hpp" local="no" imported="no">feel/feelpoly/dualbasis.hpp</includes>
    <includes id="polynomialset_8hpp" name="polynomialset.hpp" local="no" imported="no">feel/feelpoly/polynomialset.hpp</includes>
    <includes id="functionalset_8hpp" name="functionalset.hpp" local="no" imported="no">feel/feelpoly/functionalset.hpp</includes>
    <includes id="operations_8hpp" name="operations.hpp" local="no" imported="no">feel/feelpoly/operations.hpp</includes>
    <includes id="functionals_8hpp" name="functionals.hpp" local="no" imported="no">feel/feelpoly/functionals.hpp</includes>
    <includes id="functionals2_8hpp" name="functionals2.hpp" local="no" imported="no">feel/feelpoly/functionals2.hpp</includes>
    <includes id="fe_8hpp" name="fe.hpp" local="no" imported="no">feel/feelpoly/fe.hpp</includes>
    <class kind="struct">Feel::detail::times_rotx</class>
    <class kind="struct">Feel::detail::extract_all_poly_indices</class>
    <class kind="class">Feel::NedelecPolynomialSet</class>
    <class kind="class">Feel::fem::detail::NedelecDual</class>
    <class kind="class">Feel::fem::Nedelec</class>
    <class kind="class">Feel::Nedelec</class>
    <class kind="struct">Feel::Nedelec::apply</class>
    <class kind="struct">Feel::Nedelec::ChangeTag</class>
    <namespace>Feel</namespace>
    <namespace>Feel::detail</namespace>
  </compound>
  <compound kind="file">
    <name>operations.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>operations_8hpp</filename>
    <includes id="svd_8hpp" name="svd.hpp" local="no" imported="no">feel/feelalg/svd.hpp</includes>
    <includes id="im_8hpp" name="im.hpp" local="no" imported="no">feel/feelpoly/im.hpp</includes>
    <includes id="polynomialset_8hpp" name="polynomialset.hpp" local="no" imported="no">feel/feelpoly/polynomialset.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>Poly::value_type</type>
      <name>integrate</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4c300b4c137594540a9428af36363049</anchor>
      <arglist>(Polynomial&lt; Poly, PsetType &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Polynomial&lt; Poly, Type &gt;</type>
      <name>dx</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a03f3303c5b91e975155799efa3f30b25</anchor>
      <arglist>(Polynomial&lt; Poly, Type &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; Poly, Type &gt;</type>
      <name>dx</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9b0561a03e47fc0b47a793d158dc636f</anchor>
      <arglist>(PolynomialSet&lt; Poly, Type &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Polynomial&lt; Poly, Type &gt;</type>
      <name>dy</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd65f7117df9527c0c921c5ff3a5b922</anchor>
      <arglist>(Polynomial&lt; Poly, Type &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; Poly, Type &gt;</type>
      <name>dy</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a678cc45753409e5de39afc9d4fd91388</anchor>
      <arglist>(PolynomialSet&lt; Poly, Type &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Polynomial&lt; Poly, Type &gt;</type>
      <name>dz</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a44337dbc65effaa525948f8939733b22</anchor>
      <arglist>(Polynomial&lt; Poly, Type &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; Poly, Type &gt;</type>
      <name>dz</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a035d345518f6a629318edcd57ce3275d</anchor>
      <arglist>(PolynomialSet&lt; Poly, Type &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Polynomial&lt; Poly, Vectorial &gt;</type>
      <name>gradient</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a2afbcddff5e3a84e885a5c20363c4099</anchor>
      <arglist>(Polynomial&lt; Poly, Scalar &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Polynomial&lt; Poly, Tensor2 &gt;</type>
      <name>gradient</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a2585c1fb3a5f58b5557aefb63f446de0</anchor>
      <arglist>(Polynomial&lt; Poly, Vectorial &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; Poly, Vectorial &gt;</type>
      <name>gradient</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a100886326e76f552a3b3fc936981f480</anchor>
      <arglist>(PolynomialSet&lt; Poly, Scalar &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; Poly, Tensor2 &gt;</type>
      <name>gradient</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aa9183188ba9980e13b6fab78fd35dfe4</anchor>
      <arglist>(PolynomialSet&lt; Poly, Vectorial &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; Poly, Tensor2 &gt;</type>
      <name>hessian</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a8073bad0e88192d69a7b74083ffa640d</anchor>
      <arglist>(PolynomialSet&lt; Poly, Scalar &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Polynomial&lt; Poly, Scalar &gt;</type>
      <name>divergence</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a552129f28d2fad48c78b92a1baccbdb9</anchor>
      <arglist>(Polynomial&lt; Poly, Vectorial &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; Poly, Scalar &gt;</type>
      <name>divergence</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9f140d4902cd2b28cd758430f1af2f6e</anchor>
      <arglist>(PolynomialSet&lt; Poly, Vectorial &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Polynomial&lt; Poly, Vectorial &gt;</type>
      <name>curl</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af0e68f5f62e0b915cf3b9ac73b5c4080</anchor>
      <arglist>(Polynomial&lt; Poly, Vectorial &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; Poly, Vectorial &gt;</type>
      <name>curl</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a3788c225ebee3147f0bcd32c6d77478d</anchor>
      <arglist>(PolynomialSet&lt; Poly, Vectorial &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Polynomial&lt; Poly, Vectorial &gt;</type>
      <name>curlt</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a31844ce9bde57a55518ab057fd040744</anchor>
      <arglist>(Polynomial&lt; Poly, Vectorial &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; Poly, Vectorial &gt;</type>
      <name>curlt</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad711a250106c87c0df471a90881a2dfb</anchor>
      <arglist>(PolynomialSet&lt; Poly, Vectorial &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Polynomial&lt; Pset, Scalar &gt;</type>
      <name>project</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ae89776231eca6bd68ba734da512759b3</anchor>
      <arglist>(Pset const &amp;pset, Func const &amp;f, IM const &amp;im)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; P, Type &gt;</type>
      <name>unite</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ae64c75954df0318d6e9e1a5f848bb05c</anchor>
      <arglist>(Poly1&lt; P, Type &gt; const &amp;pset1, Poly2&lt; P, Type &gt; const &amp;pset2)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>orthogonalpolynomialset.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>orthogonalpolynomialset_8hpp</filename>
    <class kind="class">Feel::OrthogonalPolynomialSet</class>
    <class kind="class">Feel::OrthogonalPolynomialSet&lt; Dim, Order, PolySetType, T, Simplex &gt;</class>
    <class kind="class">Feel::OrthogonalPolynomialSet&lt; Dim, Order, PolySetType, T, Hypercube &gt;</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>orthonormalpolynomialset.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>orthonormalpolynomialset_8hpp</filename>
  </compound>
  <compound kind="file">
    <name>pointsetinterpolation.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>pointsetinterpolation_8hpp</filename>
    <includes id="pointset_8hpp" name="pointset.hpp" local="no" imported="no">feel/feelmesh/pointset.hpp</includes>
    <class kind="class">Feel::PointSetInterpolation</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>polynomial.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>polynomial_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
  </compound>
  <compound kind="file">
    <name>polynomialset.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>polynomialset_8hpp</filename>
    <includes id="svd_8hpp" name="svd.hpp" local="no" imported="no">feel/feelalg/svd.hpp</includes>
    <includes id="dubiner_8hpp" name="dubiner.hpp" local="no" imported="no">feel/feelpoly/dubiner.hpp</includes>
    <includes id="legendre_8hpp" name="legendre.hpp" local="no" imported="no">feel/feelpoly/legendre.hpp</includes>
    <includes id="boundadapted_8hpp" name="boundadapted.hpp" local="no" imported="no">feel/feelpoly/boundadapted.hpp</includes>
    <includes id="polynomial_8hpp" name="polynomial.hpp" local="no" imported="no">feel/feelpoly/polynomial.hpp</includes>
    <includes id="expansiontypes_8hpp" name="expansiontypes.hpp" local="no" imported="no">feel/feelpoly/expansiontypes.hpp</includes>
    <includes id="quadmapped_8hpp" name="quadmapped.hpp" local="no" imported="no">feel/feelpoly/quadmapped.hpp</includes>
    <includes id="orthonormalpolynomialset_8hpp" name="orthonormalpolynomialset.hpp" local="no" imported="no">feel/feelpoly/orthonormalpolynomialset.hpp</includes>
    <class kind="class">Feel::PolynomialSet</class>
    <class kind="class">Feel::PolynomialSet::PreCompute</class>
    <class kind="class">Feel::PolynomialSet::Context</class>
    <class kind="struct">Feel::PolynomialSet::Context::Index</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>principal.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>principal_8hpp</filename>
    <includes id="lu_8hpp" name="lu.hpp" local="no" imported="no">feel/feelalg/lu.hpp</includes>
    <includes id="expansions_8hpp" name="expansions.hpp" local="no" imported="no">feel/feelpoly/expansions.hpp</includes>
    <class kind="class">Feel::Principal</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>quadmapped.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>quadmapped_8hpp</filename>
    <includes id="refentity_8hpp" name="refentity.hpp" local="no" imported="no">feel/feelmesh/refentity.hpp</includes>
    <includes id="equispaced_8hpp" name="equispaced.hpp" local="no" imported="no">feel/feelpoly/equispaced.hpp</includes>
    <includes id="visitor_8hpp" name="visitor.hpp" local="no" imported="no">feel/feelcore/visitor.hpp</includes>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <includes id="im_8hpp" name="im.hpp" local="no" imported="no">feel/feelpoly/im.hpp</includes>
    <class kind="class">Feel::QuadMapped</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>raviartthomas.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>raviartthomas_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="lu_8hpp" name="lu.hpp" local="no" imported="no">feel/feelalg/lu.hpp</includes>
    <includes id="refentity_8hpp" name="refentity.hpp" local="no" imported="no">feel/feelmesh/refentity.hpp</includes>
    <includes id="pointset_8hpp" name="pointset.hpp" local="no" imported="no">feel/feelmesh/pointset.hpp</includes>
    <includes id="dualbasis_8hpp" name="dualbasis.hpp" local="no" imported="no">feel/feelpoly/dualbasis.hpp</includes>
    <includes id="polynomialset_8hpp" name="polynomialset.hpp" local="no" imported="no">feel/feelpoly/polynomialset.hpp</includes>
    <includes id="functionalset_8hpp" name="functionalset.hpp" local="no" imported="no">feel/feelpoly/functionalset.hpp</includes>
    <includes id="operations_8hpp" name="operations.hpp" local="no" imported="no">feel/feelpoly/operations.hpp</includes>
    <includes id="functionals_8hpp" name="functionals.hpp" local="no" imported="no">feel/feelpoly/functionals.hpp</includes>
    <includes id="functionals2_8hpp" name="functionals2.hpp" local="no" imported="no">feel/feelpoly/functionals2.hpp</includes>
    <includes id="fe_8hpp" name="fe.hpp" local="no" imported="no">feel/feelpoly/fe.hpp</includes>
    <class kind="struct">Feel::detail::times_x</class>
    <class kind="struct">Feel::detail::extract_all_poly_indices</class>
    <class kind="class">Feel::RaviartThomasPolynomialSet</class>
    <class kind="class">Feel::fem::detail::RaviartThomasDual</class>
    <class kind="class">Feel::fem::RaviartThomas</class>
    <class kind="class">Feel::RaviartThomas</class>
    <class kind="struct">Feel::RaviartThomas::apply</class>
    <class kind="struct">Feel::RaviartThomas::ChangeTag</class>
    <namespace>Feel</namespace>
    <namespace>Feel::detail</namespace>
  </compound>
  <compound kind="file">
    <name>test_equispaced.cpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>test__equispaced_8cpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <includes id="equispaced_8hpp" name="equispaced.hpp" local="no" imported="no">feel/feelpoly/equispaced.hpp</includes>
    <member kind="function">
      <type>int</type>
      <name>main</name>
      <anchorfile>test__equispaced_8cpp.html</anchorfile>
      <anchor>ae66f6b31b5ad750f1fe042a706a4e3d4</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>warpblend.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feelpoly/</path>
    <filename>warpblend_8hpp</filename>
    <includes id="glas_8hpp" name="glas.hpp" local="no" imported="no">feel/feelalg/glas.hpp</includes>
    <includes id="pointsetinterpolation_8hpp" name="pointsetinterpolation.hpp" local="no" imported="no">feel/feelpoly/pointsetinterpolation.hpp</includes>
    <includes id="jacobi_8hpp" name="jacobi.hpp" local="no" imported="no">feel/feelpoly/jacobi.hpp</includes>
    <includes id="geond_8hpp" name="geond.hpp" local="no" imported="no">feel/feelmesh/geond.hpp</includes>
    <includes id="gausslobatto_8hpp" name="gausslobatto.hpp" local="no" imported="no">feel/feelpoly/gausslobatto.hpp</includes>
    <includes id="equispaced_8hpp" name="equispaced.hpp" local="no" imported="no">feel/feelpoly/equispaced.hpp</includes>
    <class kind="class">Feel::PointSetWarpBlend</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="file">
    <name>now.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feeltiming/</path>
    <filename>now_8hpp</filename>
    <includes id="feel_8hpp" name="feel.hpp" local="no" imported="no">feel/feelcore/feel.hpp</includes>
    <namespace>Feel</namespace>
    <member kind="typedef">
      <type>Feel::uint64_type</type>
      <name>cycles_t</name>
      <anchorfile>namespaceFeel_1_1details.html</anchorfile>
      <anchor>ae9c23267b514086623b7070cecc07c19</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>now</name>
      <anchorfile>namespaceFeel_1_1details.html</anchorfile>
      <anchor>a3a3ebc8a45ef30062fd58ca4775ec9f5</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>tic.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feeltiming/</path>
    <filename>tic_8hpp</filename>
    <includes id="timer_8hpp" name="timer.hpp" local="no" imported="no">feel/feeltiming/timer.hpp</includes>
    <includes id="now_8hpp" name="now.hpp" local="no" imported="no">feel/feeltiming/now.hpp</includes>
    <class kind="struct">Feel::details::SecondBasedTimer</class>
    <namespace>Feel</namespace>
    <member kind="function">
      <type>void</type>
      <name>tic</name>
      <anchorfile>namespaceFeel_1_1time.html</anchorfile>
      <anchor>a7a282d757d33537fe2085c6c4f231b8c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>toc</name>
      <anchorfile>namespaceFeel_1_1time.html</anchorfile>
      <anchor>a3e9e0643491e082fa11cde9afade6309</anchor>
      <arglist>(bool display=true)</arglist>
    </member>
    <member kind="variable">
      <type>counter&lt; double, SecondBasedTimer &gt; const</type>
      <name>sec_timer</name>
      <anchorfile>namespaceFeel_1_1details.html</anchorfile>
      <anchor>a96787e7e39e2548d8ad3ff7585877c0b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>timer.hpp</name>
    <path>/home/prudhomm/sources/feelpp/feel/feeltiming/</path>
    <filename>timer_8hpp</filename>
    <class kind="class">Feel::details::counter</class>
    <namespace>Feel</namespace>
  </compound>
  <compound kind="page">
    <name>types_page</name>
    <title>Feel Types</title>
    <filename>types_page</filename>
    <docanchor file="types_page">types</docanchor>
    <docanchor file="types_page">ints</docanchor>
    <docanchor file="types_page">real</docanchor>
  </compound>
  <compound kind="page">
    <name>macros_page</name>
    <title>Feel Macros</title>
    <filename>macros_page</filename>
    <docanchor file="macros_page">hints</docanchor>
    <docanchor file="macros_page">macros</docanchor>
    <docanchor file="macros_page">attribute_macro</docanchor>
    <docanchor file="macros_page">assert_macros</docanchor>
    <docanchor file="macros_page">assertions</docanchor>
  </compound>
  <compound kind="page">
    <name>ProgEnv</name>
    <title>Getting started</title>
    <filename>ProgEnv</filename>
    <docanchor file="ProgEnv">CompilingWithCmake</docanchor>
    <docanchor file="ProgEnv">AboutDependencies</docanchor>
    <docanchor file="ProgEnv">GettingSourceViaArchive</docanchor>
    <docanchor file="ProgEnv">download-sources</docanchor>
    <docanchor file="ProgEnv">Libraries</docanchor>
    <docanchor file="ProgEnv">GettingSourceViaSubversion</docanchor>
    <docanchor file="ProgEnv">build</docanchor>
    <docanchor file="ProgEnv">CompilingTutorial</docanchor>
  </compound>
  <compound kind="page">
    <name>CreatingApplications</name>
    <title>Creating applications</title>
    <filename>CreatingApplications</filename>
    <docanchor file="CreatingApplications">PetscTrilinos</docanchor>
    <docanchor file="CreatingApplications">ApplicationLoggingArchiving</docanchor>
    <docanchor file="CreatingApplications">ParallelApplication</docanchor>
    <docanchor file="CreatingApplications">ApplicationOptions</docanchor>
  </compound>
  <compound kind="page">
    <name>ManipulatingMeshes</name>
    <title>Manipulating Meshes</title>
    <filename>ManipulatingMeshes</filename>
    <docanchor file="ManipulatingMeshes">MeshIterators</docanchor>
    <docanchor file="ManipulatingMeshes">MeshDefinitions</docanchor>
    <docanchor file="ManipulatingMeshes">ManipulatingMeshesExport</docanchor>
  </compound>
  <compound kind="page">
    <name>ComputingIntegrals</name>
    <title>Computing integrals</title>
    <filename>ComputingIntegrals</filename>
    <docanchor file="ComputingIntegrals">ComputingIntegralsNote</docanchor>
    <docanchor file="ComputingIntegrals">IntegralsOverHypercube</docanchor>
    <docanchor file="ComputingIntegrals">ComputingIntegralsCode</docanchor>
    <docanchor file="ComputingIntegrals">ComputingIntegralsRuntime</docanchor>
    <docanchor file="ComputingIntegrals">IntegralsOverSimplex</docanchor>
    <docanchor file="ComputingIntegrals">ComputingIntegralsProblem</docanchor>
  </compound>
  <compound kind="page">
    <name>ManipulatingFunctionSpaces</name>
    <title>Manipulating Function Spaces</title>
    <filename>ManipulatingFunctionSpaces</filename>
    <docanchor file="ManipulatingFunctionSpaces">FunctionSpaceUse</docanchor>
    <docanchor file="ManipulatingFunctionSpaces">FunctionSpaceDefinition</docanchor>
    <docanchor file="ManipulatingFunctionSpaces">Projection</docanchor>
    <docanchor file="ManipulatingFunctionSpaces">ManipulatingFunctionSpacesExecHypercube</docanchor>
    <docanchor file="ManipulatingFunctionSpaces">Saving</docanchor>
    <docanchor file="ManipulatingFunctionSpaces">ManipulatingFunctionSpacesExecSimplex</docanchor>
    <docanchor file="ManipulatingFunctionSpaces">ManipulatingFunctionSpacesExec</docanchor>
    <docanchor file="ManipulatingFunctionSpaces">FunctionSpaceNorm</docanchor>
    <docanchor file="ManipulatingFunctionSpaces">Interpolation</docanchor>
  </compound>
  <compound kind="page">
    <name>WritingVariationalFormulations</name>
    <title>Writing Variational Formulations</title>
    <filename>WritingVariationalFormulations</filename>
    <docanchor file="WritingVariationalFormulations">MathematicalFormulation</docanchor>
    <docanchor file="WritingVariationalFormulations">lapsystem</docanchor>
    <docanchor file="WritingVariationalFormulations">FeelFormulation</docanchor>
    <docanchor file="WritingVariationalFormulations">StandardFormulationLaplacian</docanchor>
    <docanchor file="WritingVariationalFormulations">MixedFormulationStokesCase</docanchor>
  </compound>
  <compound kind="page">
    <name>SolvingLinearAlgebra</name>
    <title>Solving Linear Algebra Problems</title>
    <filename>SolvingLinearAlgebra</filename>
    <docanchor file="SolvingLinearAlgebra">Solving</docanchor>
    <docanchor file="SolvingLinearAlgebra">MatrixVectors</docanchor>
    <docanchor file="SolvingLinearAlgebra">ChoosingBackend</docanchor>
  </compound>
  <compound kind="page">
    <name>SolvingNonlinearEquations</name>
    <title>Solving nonlinear equations</title>
    <filename>SolvingNonlinearEquations</filename>
    <docanchor file="SolvingNonlinearEquations">SimplifiedCombustionProblemBratu</docanchor>
    <docanchor file="SolvingNonlinearEquations">AFirstNonlinearProblem</docanchor>
  </compound>
  <compound kind="page">
    <name>Introduction</name>
    <title>Introduction</title>
    <filename>Introduction</filename>
    <docanchor file="Introduction">General</docanchor>
    <docanchor file="Introduction">contributors</docanchor>
  </compound>
  <compound kind="group">
    <name>BareItemsBuilder</name>
    <title>Global functions to build Bare Items.</title>
    <filename>group__BareItemsBuilder.html</filename>
    <member kind="function">
      <type>std::pair&lt; BareFace, bool &gt;</type>
      <name>makeBareFace</name>
      <anchorfile>group__BareItemsBuilder.html</anchorfile>
      <anchor>gaf5e3fd27bc0364dc4d1c5671adca807d</anchor>
      <arglist>(size_type const i, size_type const j, size_type const k)</arglist>
    </member>
    <member kind="function">
      <type>std::pair&lt; BareFace, bool &gt;</type>
      <name>makeBareFace</name>
      <anchorfile>group__BareItemsBuilder.html</anchorfile>
      <anchor>gab2770273d31d671d77dd772791b64444</anchor>
      <arglist>(size_type const i, size_type const j, size_type const k, size_type const l)</arglist>
    </member>
    <member kind="function">
      <type>std::pair&lt; BareEdge, bool &gt;</type>
      <name>makeBareEdge</name>
      <anchorfile>group__BareItemsBuilder.html</anchorfile>
      <anchor>ga87054b8a2a565d7ad927bacddcdb118b</anchor>
      <arglist>(size_type const i, size_type const j)</arglist>
    </member>
    <member kind="function">
      <type>BareEdge</type>
      <name>setBareEdge</name>
      <anchorfile>group__BareItemsBuilder.html</anchorfile>
      <anchor>ga52d8548d4bb34050badfef432535f0e4</anchor>
      <arglist>(size_type const i, size_type const j)</arglist>
    </member>
    <member kind="function">
      <type>BareEdge</type>
      <name>setBareEdgeNo</name>
      <anchorfile>group__BareItemsBuilder.html</anchorfile>
      <anchor>ga5232fc93ced0a4b9ae921269ed931416</anchor>
      <arglist>(size_type const i, size_type const j)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>comparison</name>
    <title>Comparison Operators</title>
    <filename>group__comparison.html</filename>
    <class kind="struct">Feel::cmpBareItem&lt; BarePoint &gt;</class>
    <class kind="struct">Feel::cmpBareItem&lt; BareFace &gt;</class>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>group__comparison.html</anchorfile>
      <anchor>gaf953dc59098fdbb7c6b1eeafd63836f5</anchor>
      <arglist>(const BareEdge &amp;p1, const BareEdge &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>group__comparison.html</anchorfile>
      <anchor>ga671bccf02473b3f273d6dd807fd882be</anchor>
      <arglist>(const BareEdge &amp;p1, const BareEdge &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>group__comparison.html</anchorfile>
      <anchor>ga836804dcdd75102047ecca37c1bffdb9</anchor>
      <arglist>(const BareEdge &amp;e1, const BareEdge &amp;e2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>group__comparison.html</anchorfile>
      <anchor>ga4e8e7dc5fd8d09cc0b5000b8238b9eb5</anchor>
      <arglist>(const BareEdge &amp;e1, const BareEdge &amp;e2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>group__comparison.html</anchorfile>
      <anchor>ga80e4fd4470b9d20f244d72378c4f9c76</anchor>
      <arglist>(const BareEdge &amp;e1, const BareEdge &amp;e2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>group__comparison.html</anchorfile>
      <anchor>gaec44708d6f919b2d2f7a7224e2d248c5</anchor>
      <arglist>(const BareEdge &amp;e1, const BareEdge &amp;e2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>group__comparison.html</anchorfile>
      <anchor>gaec2f656ea70505686355087470904b05</anchor>
      <arglist>(const BareFace &amp;p1, const BareFace &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>group__comparison.html</anchorfile>
      <anchor>ga7a46756b960122c12db4df2367ce4d10</anchor>
      <arglist>(const BareFace &amp;p1, const BareFace &amp;p2)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Helper</name>
    <title>Some helper functions</title>
    <filename>group__Helper.html</filename>
    <member kind="function">
      <type>size_type</type>
      <name>getId</name>
      <anchorfile>group__Helper.html</anchorfile>
      <anchor>ga94ebd5aca3f55c90213198cee1435566</anchor>
      <arglist>(std::pair&lt; BareItem, size_type &gt; const &amp;i)</arglist>
    </member>
    <member kind="function">
      <type>BareItem</type>
      <name>getItem</name>
      <anchorfile>group__Helper.html</anchorfile>
      <anchor>ga014f15b132f23cdbe4f8dc422e5d465d</anchor>
      <arglist>(std::pair&lt; BareItem, size_type &gt; const &amp;i)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>GeoEntites</name>
    <title>Basis Reference Shapes</title>
    <filename>group__GeoEntites.html</filename>
  </compound>
  <compound kind="group">
    <name>GeoXD</name>
    <title>Basis Geometrical Entities Geo0D and GeoND.</title>
    <filename>group__GeoXD.html</filename>
    <class kind="class">Feel::Geo0D</class>
    <member kind="typedef">
      <type>Geo0D&lt; Dim, T &gt;</type>
      <name>self_type</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga50a4e3ec456d5a3c78736d3c82a6ee8d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>T</type>
      <name>value_type</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaf8b2236775871cba4b723c3bcc4062a0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>matrix_node&lt; value_type &gt;::type</type>
      <name>matrix_node_type</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaee35df1da9c80a4bdd4ce39568fc1192</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super2</type>
      <name>node_type</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga59d363ab3c2b473b058c9c1161586783</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>node&lt; T, 2 &gt;::type</type>
      <name>parametric_node_type</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga9239f236dd0ee19a96d1300127e36992</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Geo0D&lt; 3 &gt;</type>
      <name>Point</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga3cd0c06ba366dbcbb30a02e98eb7667d</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geo0D</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga0ac43772934e65534b52a8a94c9ae695</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geo0D</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gac9ba26841cb3ead5c226b3473fc70da8</anchor>
      <arglist>(size_type id, bool boundary=false, bool is_vertex=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geo0D</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gadcdd3966188c80eaede4e6f00ebba85b</anchor>
      <arglist>(size_type id, value_type x, value_type y, value_type z, bool boundary=false, bool is_vertex=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geo0D</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaf66a13ff6828a837d1a2654fedef4f96</anchor>
      <arglist>(value_type x, value_type y, value_type z)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geo0D</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga4ff1345f68fec3523e611acbed709d17</anchor>
      <arglist>(size_type id, node_type const &amp;__x, bool boundary=false, bool is_vertex=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geo0D</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gabe8eb591c5b5c603c6912ced187e85db</anchor>
      <arglist>(node_type const &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geo0D</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga013a02132e097f041c4b987f27e0c91a</anchor>
      <arglist>(ublas::vector_expression&lt; AE &gt; const &amp;__expr)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geo0D</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gab9f07e903fbb90d5247c7cef3305fef7</anchor>
      <arglist>(Geo0D const &amp;G)</arglist>
    </member>
    <member kind="function">
      <type>Geo0D &amp;</type>
      <name>operator=</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga6522315b162bb7e6cc1ace6a633f96ba</anchor>
      <arglist>(Geo0D const &amp;G)</arglist>
    </member>
    <member kind="function">
      <type>Geo0D &amp;</type>
      <name>operator=</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaba4a81f1065352fbf0e72a0f4ff625da</anchor>
      <arglist>(ublas::vector_expression&lt; AE &gt; const &amp;expr)</arglist>
    </member>
    <member kind="function">
      <type>Geo0D &amp;</type>
      <name>operator+=</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga5c362729980c4b2afdbcc0ded6d70183</anchor>
      <arglist>(ublas::vector_expression&lt; AE &gt; const &amp;expr)</arglist>
    </member>
    <member kind="function">
      <type>value_type &amp;</type>
      <name>operator()</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gabcd5a9b3b606900d05545cc3066c235c</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>operator()</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gacd228b3af710fa1c377e6bc8d893747b</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isVertex</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga687c5a4ceb94411b600c1c15776b94a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAsVertex</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaabcbf4fca463322092f7d2b5f83bfb58</anchor>
      <arglist>(bool v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMesh</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga1030b5e6799a68514b0035c27121e1d2</anchor>
      <arglist>(MeshBase const *m)</arglist>
    </member>
    <member kind="function">
      <type>MeshBase const *</type>
      <name>mesh</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga9b8049387dd9fed597144ba2840128c6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Geo0D const &amp;</type>
      <name>node</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaf929e439be53c18fb5efebbcfcf530a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>matrix_node_type</type>
      <name>G</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga88ea9202a3eb375f41be8a1d545b6d59</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>matrix_node_type</type>
      <name>vertices</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga23ad7f1fba9bd38e68e81ab0b06617d3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>measure</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga2242876825ab4dca2451bfe1e5b2bb66</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isParametric</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaffeabdf04cb4703f697ffe69a1e0bdfa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>gDim</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaeeb759cdfffbdcb912bcf632a2027ea7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>gTag</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga87b6b0a77eb36ac8b8dbbee6ff1a0d98</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>parametric_node_type const &amp;</type>
      <name>parametricCoordinates</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga8355f52e182c4206c82e65687413dcd2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>u</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga34eb8201d0c8fdb61bd9e2718272e74e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>v</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga7b199d1ec35ab1bd392e19f660e35a0f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNode</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gad752da351c137b48fba9f051ea556ef7</anchor>
      <arglist>(node_type const &amp;__n)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gadde2f305ab7f56fa4ff9dc7488cf23e3</anchor>
      <arglist>(Geo0D const &amp;geo0d) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga9af5c49c7e028816e8f2554a079a7d1a</anchor>
      <arglist>(Geo0D const &amp;e) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga26c4331e0598ec8296b1e0c48ed2a0db</anchor>
      <arglist>(size_type __i) const </arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>showMe</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga8de5f4910a8bd6155ebf87f01003ffca</anchor>
      <arglist>(bool verbose=false, std::ostream &amp;c=std::cout) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPoint</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gae5a32ca499164e865992428944b202c9</anchor>
      <arglist>(uint16_type const , self_type const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>self_type &amp;</type>
      <name>translate</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga6fba0376b90af6b3e72b9e000c606b33</anchor>
      <arglist>(node_type const &amp;trans)</arglist>
    </member>
    <member kind="function">
      <type>Marker1 const &amp;</type>
      <name>marker</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga0d1c8fdfb805c7fdbfc59e08d93657e6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Marker1 &amp;</type>
      <name>marker</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gabd5d8b34994b96562ab0c93242283793</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMarker</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga9725111290f553f7418358343f1d60c3</anchor>
      <arglist>(flag_type v)</arglist>
    </member>
    <member kind="function">
      <type>Marker2 const &amp;</type>
      <name>marker2</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gadef3153f8eb4e0855b4bd11049d243c6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Marker2 &amp;</type>
      <name>marker2</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga4a3c8e381964a2fab4b27b6687539e5a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMarker2</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga51d4a358d099cac0164ec55b3b6c3589</anchor>
      <arglist>(flag_type v)</arglist>
    </member>
    <member kind="function">
      <type>Marker3 const &amp;</type>
      <name>marker3</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga8a289de52f1ddf10d9f26a3311447249</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Marker3 &amp;</type>
      <name>marker3</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gad7b07eee5cf6e403a288b5db1a96c2ea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMarker3</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga5d1619f7868940efff9d06c8dc785154</anchor>
      <arglist>(flag_type v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTags</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga0feb3581f0d0f4e241d15d4a65c3ee32</anchor>
      <arglist>(std::vector&lt; int &gt; const &amp;tags)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGDim</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga88ce00f6604987d9e1333f56c73c7f33</anchor>
      <arglist>(int gdim)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGTag</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga1978067d79c83df9e07d835a98c45e11</anchor>
      <arglist>(int gtag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setParametricCoordinates</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga1252fb573284e4e13d9e86b6b124b6ef</anchor>
      <arglist>(parametric_node_type const &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setParametricCoordinates</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gac3260898f43d35d1bb240599561d0e58</anchor>
      <arglist>(value_type u, value_type v)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaa20e875ec92140e3058b54382cd13fc4</anchor>
      <arglist>(DebugStream &amp;__os, Geo0D&lt; Dim, T &gt; const &amp;__n)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga992cd95cdc8e64666e6a95addc029cb0</anchor>
      <arglist>(NdebugStream &amp;__os, Geo0D&lt; Dim, T &gt; const &amp;__n)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>distance</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga4325f5fef1deb9c9a3e8b8dde02f1eb8</anchor>
      <arglist>(Geo0D&lt; 1, T &gt; const &amp;p1, Geo0D&lt; 1, T &gt; const &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>distance</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga792ee6795b4e216f19e62a29f72aeb17</anchor>
      <arglist>(Geo0D&lt; 2, T &gt; const &amp;p1, Geo0D&lt; 2, T &gt; const &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>distance</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaf283b6a618148fbc7cb15d9312758863</anchor>
      <arglist>(Geo0D&lt; 3, T &gt; const &amp;p1, Geo0D&lt; 3, T &gt; const &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>Geo0D&lt; 1, T &gt;</type>
      <name>middle</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga5c3828bcc6652da1332cce5141fe0752</anchor>
      <arglist>(Geo0D&lt; 1, T &gt; const &amp;p1, Geo0D&lt; 1, T &gt; const &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>Geo0D&lt; 2, T &gt;</type>
      <name>middle</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga66b9073d1562406dcc11a178b711a586</anchor>
      <arglist>(Geo0D&lt; 2, T &gt; const &amp;p1, Geo0D&lt; 2, T &gt; const &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>Geo0D&lt; 3, T &gt;</type>
      <name>middle</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gab2a8eaa91bbe1a38726d511b9117dbfe</anchor>
      <arglist>(Geo0D&lt; 3, T &gt; const &amp;p1, Geo0D&lt; 3, T &gt; const &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>ublas::vector&lt; double &gt;</type>
      <name>cross</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga703b094178a719a2acbe543b4fa03fdd</anchor>
      <arglist>(ublas::vector_expression&lt; E1 &gt; _p1, ublas::vector_expression&lt; E2 &gt; _p2)</arglist>
    </member>
    <member kind="function">
      <type>ublas::vector&lt; double &gt;</type>
      <name>cross</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga78d09bc6139f4dadcdff4afc2b6b745b</anchor>
      <arglist>(Geo0D&lt; 3, T &gt; p1, Geo0D&lt; 3, T &gt; p2)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>nDim</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gabde4d34df01c18a1f4ca3f815eb1e824</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>GeoEle</name>
    <title>Geometry Element classes</title>
    <filename>group__GeoEle.html</filename>
    <class kind="class">Feel::GeoElement0D</class>
    <class kind="class">Feel::GeoElement1D</class>
    <class kind="class">Feel::GeoElement2D</class>
    <class kind="class">Feel::GeoElement3D</class>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>numLocalVertices</name>
      <anchorfile>group__GeoEle.html</anchorfile>
      <anchor>ga66557b49da0ab6943299a282f4583ed5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>numLocalEdges</name>
      <anchorfile>group__GeoEle.html</anchorfile>
      <anchor>ga626a94933fc89b16a56e9c05716540a1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Core</name>
    <title>Core Module</title>
    <filename>group__Core.html</filename>
    <class kind="class">Feel::Application</class>
    <class kind="class">Feel::math::Constant</class>
    <class kind="class">Feel::Context</class>
    <class kind="class">Debug</class>
    <class kind="class">Feel::Factory</class>
    <class kind="class">Feel::FactoryClone</class>
    <class kind="class">Feel::Singleton</class>
    <class kind="class">Feel::AssertContext</class>
    <class kind="class">Feel::TypeInfo</class>
    <class kind="class">Feel::VisitorBase</class>
    <class kind="class">VisitorBaseImpl</class>
  </compound>
  <compound kind="class">
    <name>BareItemHandler</name>
    <filename>classBareItemHandler.html</filename>
  </compound>
  <compound kind="struct">
    <name>bases</name>
    <filename>structbases.html</filename>
    <member kind="variable">
      <type>double</type>
      <name>chars_per_bit_exactly</name>
      <anchorfile>structbases.html</anchorfile>
      <anchor>a23777cd1a808aaa4c3c8c12730b61891</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Debug</name>
    <filename>classDebug.html</filename>
  </compound>
  <compound kind="class">
    <name>boost::equality_comparable</name>
    <filename>classboost_1_1equality__comparable.html</filename>
  </compound>
  <compound kind="class">
    <name>Fekete</name>
    <filename>classFekete.html</filename>
  </compound>
  <compound kind="class">
    <name>GEOSHAPE</name>
    <filename>classGEOSHAPE.html</filename>
  </compound>
  <compound kind="class">
    <name>boost::less_than_comparable</name>
    <filename>classboost_1_1less__than__comparable.html</filename>
  </compound>
  <compound kind="class">
    <name>Mesh0d</name>
    <filename>classMesh0d.html</filename>
  </compound>
  <compound kind="struct">
    <name>mpfr_group_t</name>
    <filename>structmpfr__group__t.html</filename>
    <member kind="variable">
      <type>size_t</type>
      <name>alloc</name>
      <anchorfile>structmpfr__group__t.html</anchorfile>
      <anchor>a8c727700d4c2bb4d94a0ed748fd7abd2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>mp_limb_t *</type>
      <name>mant</name>
      <anchorfile>structmpfr__group__t.html</anchorfile>
      <anchor>a3bc243b308123282330b2f9b00125af7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>mp_limb_t</type>
      <name>tab</name>
      <anchorfile>structmpfr__group__t.html</anchorfile>
      <anchor>a6b3f84e23dfa2b971ad9ea100fb89d78</anchor>
      <arglist>[MPFR_GROUP_STATIC_SIZE]</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>mpfr_save_expo_t</name>
    <filename>structmpfr__save__expo__t.html</filename>
    <member kind="variable">
      <type>unsigned int</type>
      <name>saved_flags</name>
      <anchorfile>structmpfr__save__expo__t.html</anchorfile>
      <anchor>a8a8fadf79fe2c46dac5e896dcae2fae6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>mp_exp_t</type>
      <name>saved_emin</name>
      <anchorfile>structmpfr__save__expo__t.html</anchorfile>
      <anchor>a52fa3773c53a099dfc8a27ef8347a077</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>mp_exp_t</type>
      <name>saved_emax</name>
      <anchorfile>structmpfr__save__expo__t.html</anchorfile>
      <anchor>a401c0f424f3b6abe95f819ca00f95e42</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="union">
    <name>mpfr_size_limb_t</name>
    <filename>unionmpfr__size__limb__t.html</filename>
    <member kind="variable">
      <type>mp_size_t</type>
      <name>s</name>
      <anchorfile>unionmpfr__size__limb__t.html</anchorfile>
      <anchor>a1ce469735f8eddf7741e94e5d4b71da4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>mp_limb_t</type>
      <name>l</name>
      <anchorfile>unionmpfr__size__limb__t.html</anchorfile>
      <anchor>a329c6351f06549a2d13162ad4f8e1cb1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Ouput</name>
    <filename>classOuput.html</filename>
  </compound>
  <compound kind="class">
    <name>PsLogger</name>
    <filename>classPsLogger.html</filename>
    <member kind="function">
      <type></type>
      <name>PsLogger</name>
      <anchorfile>classPsLogger.html</anchorfile>
      <anchor>a14464ce82f1826570f9a1b0f8e835814</anchor>
      <arglist>(std::string fileName, std::string format=&quot;rss pcpu&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>log</name>
      <anchorfile>classPsLogger.html</anchorfile>
      <anchor>ac40b5e398513bd6db8ff41972e15b807</anchor>
      <arglist>(std::string logMessage)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>node::type</name>
    <filename>classnode_1_1type.html</filename>
  </compound>
  <compound kind="class">
    <name>boost::mpl::if_::type::type</name>
    <filename>classboost_1_1mpl_1_1if___1_1type_1_1type.html</filename>
  </compound>
  <compound kind="class">
    <name>VisitorBaseImpl</name>
    <filename>classVisitorBaseImpl.html</filename>
  </compound>
  <compound kind="struct">
    <name>boost::serialization::version&lt; Feel::CRB&lt; T &gt; &gt;</name>
    <filename>structboost_1_1serialization_1_1version_3_01Feel_1_1CRB_3_01T_01_4_01_4.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>mpl::int_&lt; 3 &gt;</type>
      <name>type</name>
      <anchorfile>structboost_1_1serialization_1_1version_3_01Feel_1_1CRB_3_01T_01_4_01_4.html</anchorfile>
      <anchor>a65eb54c71e9699b0c38c76cfb8e42096</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mpl::integral_c_tag</type>
      <name>tag</name>
      <anchorfile>structboost_1_1serialization_1_1version_3_01Feel_1_1CRB_3_01T_01_4_01_4.html</anchorfile>
      <anchor>ad5b875f9a7b1c73814bc6250f1a858ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const unsigned int</type>
      <name>value</name>
      <anchorfile>structboost_1_1serialization_1_1version_3_01Feel_1_1CRB_3_01T_01_4_01_4.html</anchorfile>
      <anchor>a219084918bd5a47ad17326c8a06be2d9</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>boost::serialization::version&lt; Feel::CRBSCM&lt; T &gt; &gt;</name>
    <filename>structboost_1_1serialization_1_1version_3_01Feel_1_1CRBSCM_3_01T_01_4_01_4.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>mpl::int_&lt; 0 &gt;</type>
      <name>type</name>
      <anchorfile>structboost_1_1serialization_1_1version_3_01Feel_1_1CRBSCM_3_01T_01_4_01_4.html</anchorfile>
      <anchor>ad917f0a296a880b9fc8ac922fc85014a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mpl::integral_c_tag</type>
      <name>tag</name>
      <anchorfile>structboost_1_1serialization_1_1version_3_01Feel_1_1CRBSCM_3_01T_01_4_01_4.html</anchorfile>
      <anchor>ac746756b295b416a79e7075e5425c8cf</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const unsigned int</type>
      <name>value</name>
      <anchorfile>structboost_1_1serialization_1_1version_3_01Feel_1_1CRBSCM_3_01T_01_4_01_4.html</anchorfile>
      <anchor>aa1859974cadf414a9c8848fef2a530c2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>Feel</name>
    <filename>namespaceFeel.html</filename>
    <namespace>Feel::detail</namespace>
    <namespace>Feel::math</namespace>
    <class kind="class">Feel::AboutDataPrivate</class>
    <class kind="class">Feel::AboutPerson</class>
    <class kind="class">Feel::AboutData</class>
    <class kind="class">Feel::Application</class>
    <class kind="class">Feel::ApplicationXML</class>
    <class kind="struct">Feel::has_value</class>
    <class kind="struct">Feel::set_value</class>
    <class kind="struct">Feel::clear_value</class>
    <class kind="class">Feel::Context</class>
    <class kind="class">Feel::DebugStream</class>
    <class kind="class">Feel::NdebugStream</class>
    <class kind="class">Feel::Environment</class>
    <class kind="struct">Feel::FactoryDefaultError</class>
    <class kind="class">Feel::Factory</class>
    <class kind="class">Feel::FactoryClone</class>
    <class kind="class">Feel::Info</class>
    <class kind="class">Feel::PolicyCreationUsingNew</class>
    <class kind="class">Feel::PolicyFeelTimeDefault</class>
    <class kind="class">Feel::Simget</class>
    <class kind="class">Feel::Singleton</class>
    <class kind="class">Feel::AssertContext</class>
    <class kind="struct">Feel::Assert</class>
    <class kind="struct">Feel::TimerPair</class>
    <class kind="class">Feel::TimerMap</class>
    <class kind="struct">Feel::strongest_numeric_type</class>
    <class kind="struct">Feel::strongest_numeric_type&lt; T1, std::complex&lt; T2 &gt; &gt;</class>
    <class kind="struct">Feel::strongest_numeric_type&lt; std::complex&lt; T1 &gt;, T2 &gt;</class>
    <class kind="struct">Feel::strongest_numeric_type&lt; std::complex&lt; T1 &gt;, std::complex&lt; T2 &gt; &gt;</class>
    <class kind="struct">Feel::is_shared_ptr</class>
    <class kind="struct">Feel::is_shared_ptr&lt; boost::shared_ptr&lt; T &gt; &gt;</class>
    <class kind="struct">Feel::remove_shared_ptr</class>
    <class kind="struct">Feel::remove_shared_ptr&lt; boost::shared_ptr&lt; T &gt; &gt;</class>
    <class kind="class">Feel::TypeInfo</class>
    <class kind="struct">Feel::type_traits</class>
    <class kind="class">Feel::VisitorBase</class>
    <class kind="class">Feel::Visitor</class>
    <class kind="class">Feel::VisitorList</class>
    <class kind="class">Feel::VisitorBaseImpl&lt; mpl::list&lt; Head, Tail &gt;, R &gt;</class>
    <class kind="class">Feel::VisitorBaseImpl&lt; mpl::list&lt; Head &gt;, R &gt;</class>
    <class kind="class">Feel::VisitableCatchAllDefault</class>
    <class kind="class">Feel::VisitableBase</class>
    <class kind="class">Feel::VisitorCyclic</class>
    <class kind="class">Feel::WorldComm</class>
    <class kind="class">Feel::Parameter_impl</class>
    <class kind="class">Feel::Parameter</class>
    <class kind="class">Feel::Output_impl</class>
    <class kind="class">Feel::Output</class>
    <class kind="class">Feel::xmlParser</class>
    <class kind="class">Feel::Aitken</class>
    <class kind="struct">Feel::compute_aitken_return</class>
    <class kind="class">Feel::Backend</class>
    <class kind="struct">Feel::BackendGmmDefaults</class>
    <class kind="class">Feel::BackendGmm</class>
    <class kind="struct">Feel::BFGSInvHessian</class>
    <class kind="class">Feel::BoundingBox</class>
    <class kind="class">Feel::DataMap</class>
    <class kind="struct">Feel::norm_inf_adaptor</class>
    <class kind="struct">Feel::node</class>
    <class kind="struct">Feel::matrix_node</class>
    <class kind="class">Feel::GraphCSR</class>
    <class kind="class">Feel::Iteration</class>
    <class kind="class">Feel::LU</class>
    <class kind="class">Feel::BlocksBaseSparseMatrix</class>
    <class kind="class">Feel::BlocksSparseMatrix</class>
    <class kind="class">Feel::MatrixBlockBase</class>
    <class kind="class">Feel::MatrixBlock</class>
    <class kind="class">Feel::MatrixGmm</class>
    <class kind="class">Feel::MatrixShell</class>
    <class kind="class">Feel::MatrixShellSparse</class>
    <class kind="class">Feel::MatrixSparse</class>
    <class kind="class">Feel::MatrixTriplet</class>
    <class kind="class">Feel::MatrixUBlas</class>
    <class kind="class">Feel::MatrixValue</class>
    <class kind="class">Feel::Preconditioner</class>
    <class kind="class">Feel::PreconditionerPetsc</class>
    <class kind="class">Feel::SolverBase</class>
    <class kind="class">Feel::SolverEigen</class>
    <class kind="class">Feel::SolverLinear</class>
    <class kind="class">Feel::SolverNonLinear</class>
    <class kind="class">Feel::SolverUMFPACK</class>
    <class kind="class">Feel::SVD</class>
    <class kind="class">Feel::SOrth</class>
    <class kind="class">Feel::Vector</class>
    <class kind="class">Feel::BlocksBaseVector</class>
    <class kind="class">Feel::BlocksVector</class>
    <class kind="class">Feel::VectorBlockBase</class>
    <class kind="class">Feel::VectorBlock</class>
    <class kind="class">Feel::VectorUblas</class>
    <class kind="class">Feel::VectorValue</class>
    <class kind="class">Feel::Exporter</class>
    <class kind="class">Feel::ExporterEnsight</class>
    <class kind="class">Feel::ExporterGmsh</class>
    <class kind="class">Feel::ExporterGnuplot</class>
    <class kind="class">Feel::ExporterQuick</class>
    <class kind="class">Feel::FilterFromVtk</class>
    <class kind="class">Feel::FilterFromVtk3D</class>
    <class kind="class">Feel::Gmsh</class>
    <class kind="class">Feel::GmshEllipsoidDomain</class>
    <class kind="class">Feel::GmshOrdering</class>
    <class kind="class">Feel::GmshHypercubeDomain</class>
    <class kind="class">Feel::GmshSimplexDomain</class>
    <class kind="class">Feel::Importer</class>
    <class kind="class">Feel::ImporterGambit</class>
    <class kind="class">Feel::ImporterGmsh</class>
    <class kind="class">Feel::PointSetToMesh</class>
    <class kind="class">Feel::BarePoint</class>
    <class kind="class">Feel::BareEdge</class>
    <class kind="class">Feel::BareFace</class>
    <class kind="struct">Feel::cmpBareItem&lt; BarePoint &gt;</class>
    <class kind="struct">Feel::cmpBareItem&lt; BareEdge &gt;</class>
    <class kind="struct">Feel::cmpBareItem&lt; BareFace &gt;</class>
    <class kind="class">Feel::BareItemsHandler</class>
    <class kind="class">Feel::ConvexBase</class>
    <class kind="class">Feel::Convex</class>
    <class kind="class">Feel::Geo0D</class>
    <class kind="class">Feel::SubFaceOfNone</class>
    <class kind="class">Feel::SubFaceOf</class>
    <class kind="class">Feel::GeoElement0D</class>
    <class kind="class">Feel::GeoElement1D</class>
    <class kind="class">Feel::GeoElement2D</class>
    <class kind="class">Feel::GeoElement3D</class>
    <class kind="class">Feel::GeoEntity</class>
    <class kind="class">Feel::GeoND</class>
    <class kind="class">Feel::Hypercube</class>
    <class kind="class">Feel::KDTree</class>
    <class kind="class">Feel::Mesh0D</class>
    <class kind="class">Feel::Mesh1D</class>
    <class kind="class">Feel::Mesh2D</class>
    <class kind="class">Feel::Mesh3D</class>
    <class kind="class">Feel::MeshAdaptation</class>
    <class kind="class">Feel::MeshBase</class>
    <class kind="class">Feel::MeshMover</class>
    <class kind="class">Feel::PointSet</class>
    <class kind="class">Feel::Entity</class>
    <class kind="class">Feel::Reference</class>
    <class kind="class">Feel::Reference&lt; Hypercube&lt; Dim, Order, RDim &gt;, Dim, Order, RDim, T &gt;</class>
    <class kind="class">Feel::Entity&lt; SHAPE_QUAD, T &gt;</class>
    <class kind="class">Feel::Entity&lt; SHAPE_HEXA, T &gt;</class>
    <class kind="class">Feel::Reference&lt; Simplex&lt; Dim, Order, RDim &gt;, Dim, Order, RDim, T &gt;</class>
    <class kind="class">Feel::Entity&lt; SHAPE_LINE, T &gt;</class>
    <class kind="class">Feel::Entity&lt; SHAPE_TRIANGLE, T &gt;</class>
    <class kind="class">Feel::Entity&lt; SHAPE_TETRA, T &gt;</class>
    <class kind="class">Feel::RegionTree</class>
    <class kind="class">Feel::Simplex</class>
    <class kind="struct">Feel::Line</class>
    <class kind="struct">Feel::Triangle</class>
    <class kind="struct">Feel::Tetrahedron</class>
    <class kind="class">Feel::Sphere</class>
    <class kind="class">Feel::StructuredGrid</class>
    <class kind="class">Feel::Surface</class>
    <class kind="class">Feel::MeshTraits</class>
    <class kind="class">Feel::Basis</class>
    <class kind="struct">Feel::BoundaryAdaptedTraits</class>
    <class kind="struct">Feel::BoundaryAdaptedTag</class>
    <class kind="class">Feel::BoundaryAdapted</class>
    <class kind="class">Feel::ConstrainedPolynomialSet</class>
    <class kind="class">Feel::Continuous</class>
    <class kind="class">Feel::CrouzeixRaviart</class>
    <class kind="class">Feel::Discontinuous</class>
    <class kind="class">Feel::DiscontinuousInterfaces</class>
    <class kind="class">Feel::DualBasis</class>
    <class kind="struct">Feel::DubinerTraits</class>
    <class kind="struct">Feel::DubinerTag</class>
    <class kind="class">Feel::Dubiner</class>
    <class kind="class">Feel::PointSetElectrostatic</class>
    <class kind="class">Feel::PointSetEquiSpaced</class>
    <class kind="struct">Feel::DimFromShape</class>
    <class kind="class">Feel::FiniteElement</class>
    <class kind="class">Feel::PointSetFeketeSimplex</class>
    <class kind="class">Feel::PointSetFekete</class>
    <class kind="class">Feel::Functional</class>
    <class kind="class">Feel::FunctionalSet</class>
    <class kind="class">Feel::Gauss</class>
    <class kind="class">Feel::Gauss&lt; Simplex&lt; 0, 1 &gt;, Integration_Degree, T &gt;</class>
    <class kind="class">Feel::GaussLobatto</class>
    <class kind="class">Feel::PointSetGaussLobatto</class>
    <class kind="struct">Feel::GeomapInverse</class>
    <class kind="class">Feel::GeoMap</class>
    <class kind="struct">Feel::GT_Lagrange</class>
    <class kind="struct">Feel::GT_QK</class>
    <class kind="class">Feel::RealToReference</class>
    <class kind="class">Feel::GeoMapInverse</class>
    <class kind="class">Feel::Hermite</class>
    <class kind="struct">Feel::JacobiDegree</class>
    <class kind="struct">Feel::IntegrationDegree</class>
    <class kind="class">Feel::IMGeneral</class>
    <class kind="class">Feel::IM</class>
    <class kind="struct">Feel::_Q</class>
    <class kind="class">Feel::IMExact</class>
    <class kind="class">Feel::Jacobi</class>
    <class kind="class">Feel::Lagrange</class>
    <class kind="struct">Feel::LegendreTraits</class>
    <class kind="struct">Feel::LegendreTag</class>
    <class kind="class">Feel::Legendre</class>
    <class kind="class">Feel::PointSetMapped</class>
    <class kind="class">Feel::NedelecPolynomialSet</class>
    <class kind="class">Feel::Nedelec</class>
    <class kind="class">Feel::OrthogonalPolynomialSet</class>
    <class kind="class">Feel::OrthogonalPolynomialSet&lt; Dim, Order, PolySetType, T, Simplex &gt;</class>
    <class kind="class">Feel::OrthogonalPolynomialSet&lt; Dim, Order, PolySetType, T, Hypercube &gt;</class>
    <class kind="class">Feel::PointSetInterpolation</class>
    <class kind="struct">Feel::Scalar</class>
    <class kind="struct">Feel::Vectorial</class>
    <class kind="struct">Feel::Field</class>
    <class kind="struct">Feel::Tensor2</class>
    <class kind="struct">Feel::Tensor3</class>
    <class kind="struct">Feel::ListReturnTypes</class>
    <class kind="struct">Feel::ReturnSelect</class>
    <class kind="struct">Feel::Component</class>
    <class kind="struct">Feel::RankUp</class>
    <class kind="struct">Feel::RankUp2</class>
    <class kind="struct">Feel::RankSame</class>
    <class kind="struct">Feel::RankDown</class>
    <class kind="struct">Feel::Normalized</class>
    <class kind="struct">Feel::StorageUBlas</class>
    <class kind="class">Feel::PolynomialSet</class>
    <class kind="class">Feel::Principal</class>
    <class kind="class">Feel::QuadMapped</class>
    <class kind="class">Feel::PointSetQuadrature</class>
    <class kind="class">Feel::RaviartThomasPolynomialSet</class>
    <class kind="class">Feel::RaviartThomas</class>
    <class kind="class">Feel::TensorisedBoundaryAdapted</class>
    <class kind="class">Feel::PointSetWarpBlend</class>
    <class kind="class">Feel::CRB</class>
    <class kind="class">Feel::CRBApp</class>
    <class kind="class">Feel::CRBDB</class>
    <class kind="class">Feel::CRBModel</class>
    <class kind="class">Feel::CRBSCM</class>
    <class kind="class">Feel::EIMBase</class>
    <class kind="class">Feel::EIM</class>
    <class kind="class">Feel::EIMFunctionBase</class>
    <class kind="class">Feel::EIMFunction</class>
    <class kind="class">Feel::OperatorLinearParametrized</class>
    <class kind="class">Feel::OpusApp</class>
    <class kind="class">Feel::OpusAppEigs</class>
    <class kind="class">Feel::ParameterSpace</class>
    <class kind="class">Feel::PFemApp</class>
    <class kind="class">Feel::POD</class>
    <member kind="typedef">
      <type>DebugStream &amp;(*</type>
      <name>LManipFunction</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a128065f601b01f3415a7acc5b0413cf5</anchor>
      <arglist>)(DebugStream &amp;)</arglist>
    </member>
    <member kind="typedef">
      <type>NdebugStream &amp;(*</type>
      <name>LNManipFunction</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>adbf1118e75d65702156bdab826c01682</anchor>
      <arglist>)(NdebugStream &amp;)</arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>Real</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aff8c989dddf67ff63dff34793ec0509f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>scalar_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ae93119144bffa7ed368079a659665469</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::complex&lt; double &gt;</type>
      <name>complex_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a400c8901e57a2fb179676de769c3f098</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::int8_t</type>
      <name>int8_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a422bdf5e2ca1e9311a1f3ce426dcfafb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::int16_t</type>
      <name>int16_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aa29cb17e9d0d5fb6e5269c078b4bc948</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::int32_t</type>
      <name>int32_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a73b5d18a1df0e94bb344ced592dc1df2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::int64_t</type>
      <name>int64_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a00aef995ca042fb6949bcf95c4c0aca9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>detail::real&lt; 32 &gt;::type</type>
      <name>real32_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a8f206c5d1c80e879bc590f00c5cc8dc5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>detail::real&lt; 64 &gt;::type</type>
      <name>real64_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a0e4929a45457fdc27e1055122bfff7a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::uint8_t</type>
      <name>uint8_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aed52446c0413dd3b45f6c009d0ad530b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::uint16_t</type>
      <name>uint16_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a7b535239159347f393440013431cb827</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::uint32_t</type>
      <name>uint32_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad0e34887a7aeab02ea0f36ae69d047a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::uint64_t</type>
      <name>uint64_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>acc4d2df760bc5f3bd17b5e255472fe64</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int64_type</type>
      <name>flag_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a5137d5a00a3a883290b5742501e7b5a8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>uint16_type</type>
      <name>dim_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a5155120d1dda406c1dde284a66a1b000</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>size_t</type>
      <name>size_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a285d572c85de361b3f3e2695b41a4ce0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Singleton&lt; Factory&lt; Simget, std::string &gt; &gt;</type>
      <name>SimgetFactory</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ac9648381161062499cc054fa4b0de17e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Backend&lt; double &gt;</type>
      <name>backend_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a773ed955956f2a157dc605630ab3c262</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; backend_type &gt;</type>
      <name>backend_ptrtype</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ae906579f5f8c6d16bf66a2570518b249</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ublas::symmetric_matrix&lt; double, ublas::lower, ublas::row_major, ublas::bounded_array&lt; double, 9 &gt; &gt;</type>
      <name>hessian_node_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a5726f6c555d1353dd27fcf1b8b770589</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ublas::matrix&lt; double, ublas::column_major, ublas::bounded_array&lt; double, 9 &gt; &gt;</type>
      <name>lapack_matrix_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ace999367f3dfa18cf549411375a759e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ublas::symmetric_adaptor&lt; lapack_matrix_type, ublas::lower &gt;</type>
      <name>symmetric_matrix_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9d10710f44ff3f93402ea5db1c29965c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>lapack_matrix_type</type>
      <name>transformation_matrix_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a64aa3a32f6112bf0c6d0c747477d9d92</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ublas::compressed_matrix&lt; double, ublas::row_major, 0, ublas::unbounded_array&lt; int &gt;, ublas::unbounded_array&lt; double &gt; &gt;</type>
      <name>csr_matrix_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af4227eac6019ef023fccc16e304b584e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ublas::compressed_matrix&lt; double, ublas::column_major, 0, ublas::unbounded_array&lt; int &gt;, ublas::unbounded_array&lt; double &gt; &gt;</type>
      <name>csc_matrix_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ac8757b2b4726472e379d4229e20b9039</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Iteration&lt; double &gt;</type>
      <name>iteration_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad70796961740ff5c8f2f091d50d3b88a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; iteration_type &gt;</type>
      <name>iteration_ptrtype</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a3714118185146aacf7689c486614becd</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>MatrixSparse&lt; double &gt;</type>
      <name>d_sparse_matrix_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aef483a644266da4062004392d2c7f10c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; d_sparse_matrix_type &gt;</type>
      <name>d_sparse_matrix_ptrtype</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a0a86cf94eb8d6f91c3615f63e74624d9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Preconditioner&lt; double &gt;</type>
      <name>preconditioner_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad6c0aa4c542104acbc3dd156bbf27ec3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; Preconditioner&lt; double &gt; &gt;</type>
      <name>preconditioner_ptrtype</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abb22c47bc02248d4061b13a37caee4b9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Gmsh</type>
      <name>gmsh_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab3e9073ed2c20fc94d134060b4156d49</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; gmsh_type &gt;</type>
      <name>gmsh_ptrtype</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af278672c3f22f96e60323c2d0023bf52</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Geo0D&lt; 3 &gt;</type>
      <name>Point</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga3cd0c06ba366dbcbb30a02e98eb7667d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Simplex&lt; 0, 1 &gt; &gt;</type>
      <name>GeoPoint</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a74db81de44a0fd14a2cff6dd560c79e9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Simplex&lt; 1, 1 &gt; &gt;</type>
      <name>LinearLine</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6d2c0e4400a583108eddd07924a7efbe</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Simplex&lt; 2, 1 &gt; &gt;</type>
      <name>LinearTriangle</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6d9f98083fe43591a3df3f1c66e0a503</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Simplex&lt; 3, 1 &gt; &gt;</type>
      <name>LinearTetra</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af6e7e6db1f514bc719d76d6fb70e7342</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Simplex&lt; 1, 2 &gt; &gt;</type>
      <name>QuadraticLine</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a67a04bf7ff4a9816a59d4b5249306482</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Simplex&lt; 2, 2 &gt; &gt;</type>
      <name>QuadraticTriangle</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a8b25ed1719bf35fde9411f4646a82f45</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Simplex&lt; 3, 2 &gt; &gt;</type>
      <name>QuadraticTetra</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aa2a9a66dec5148ee9da653dd463caa58</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Hypercube&lt; 2, 1 &gt; &gt;</type>
      <name>LinearQuad</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aa26ad57ffeacade434cfc9207ea68f24</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Hypercube&lt; 3, 1 &gt; &gt;</type>
      <name>LinearHexa</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af0f788f8baf007f1592a441757e5552a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Hypercube&lt; 2, 2 &gt; &gt;</type>
      <name>QuadraticQuad</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a3c49547f1af9e3f902f4d70d539482c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoEntity&lt; Hypercube&lt; 3, 2 &gt; &gt;</type>
      <name>QuadraticHexa</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a8bb5ccdd680d6db84f87a0eb3df01b16</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>node&lt; double &gt;::type</type>
      <name>node_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a1c83f636e0a3864d56b499054dfa7683</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>RegionTree</type>
      <name>region_tree_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a86a23775a5947ae5e22485981d4915c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; region_tree_type &gt;</type>
      <name>region_tree_ptrtype</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6c96b40bc8670bd23390271b6c3e8523</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>BFGSType</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9f782edf3ce1e077391aa88c4347526c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>on_context_type</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a22e3e6735fed56036283d38e6f0bd10a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ON_NONE</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a22e3e6735fed56036283d38e6f0bd10aaee23b75351d5814e1d0a468e6241e047</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ON_ELIMINATION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a22e3e6735fed56036283d38e6f0bd10aaf2c420d247276b43791a9554713f838c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ON_PENALISATION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a22e3e6735fed56036283d38e6f0bd10aa9fedbe2a76c0b49db59f5c26de372915</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ON_ELIMINATION_KEEP_DIAGONAL</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a22e3e6735fed56036283d38e6f0bd10aac885f100d1a310c35efd57a5fe100c8e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ON_ELIMINATION_SYMMETRIC</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a22e3e6735fed56036283d38e6f0bd10aae2a39c0d36d2e91cf3a53072f83dc6b8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MatrixProperties</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>afacc311419d607ce6ac26decbbd04917</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HERMITIAN</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>afacc311419d607ce6ac26decbbd04917a7b32254885d5d667b513bed40bfc949b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NON_HERMITIAN</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>afacc311419d607ce6ac26decbbd04917ab146fe1f68cf920d34534cebcb0c48ae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>BackendType</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4da28efa430cc4bd3a6a86cde30a9809</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SolverType</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a75d37378df29bc4c9a393504b87fdc51</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>PreconditionerType</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>affe8f1716191835c1f39a4f88c8f7299</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FieldSplitType</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a10f30e9f7975e23e837e5681c53ae064</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MatrixStructure</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a3d7a6c5948e669b187f2d4620499715a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>EigenSolverType</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aa6ba49d3d8578adfc5ae20cff2b89e65</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>EigenProblemType</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab9dd0a9c3b4ed8785c07c88ed8efafb3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>PositionOfSpectrum</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a7b06253b16577e9dede530ee4b24f863</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SpectralTransformType</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a969885acafaff68169ba5e22440655fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SolverPackage</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>afa8c843b79988c097aea0aedd833c24b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SolverNonLinearType</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a63d6d444a7e0d7bd77b307219a00ce2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>GMSH_ENTITY</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_LINE</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1afea6a1908b3cd3a722e987cf6861eca8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TRIANGLE</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1aaed86b38abd76b1aeb06bf30e3d54062</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_QUADRANGLE</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a3ce5e16332068d450d959e1839ebde2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TETRAHEDRON</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a015bfe4b11badb184dc3fa9682070e85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_HEXAHEDRON</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a9d87b081654b66dd7ff5f0305ed9991e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_PRISM</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a669701d4d73da623345b399da9cf7a9a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_PYRAMID</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1aaacbbcfe57b839467ebfa617b6e60e7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_LINE_2</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1ac6c38ea3f936ef5022b62c88003137d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TRIANGLE_2</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a3b0a4272c4f1aa39c3ec4e036d9be611</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_QUADRANGLE_2</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1af01f3dae9d29212f81d374233e9f013d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TETRAHEDRON_2</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a80bee3e57b9bbb5318a90fb131c0ee30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_HEXAHEDRON_2</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1ab97b32b4f77eabc48d5e8a87ad1184ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_PRISM_2</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a70230ca4f5221918222e747248f2ecb0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_PYRAMID_2</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1ab1989d567f75cdcc17f8efe18027b531</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_POINT</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a7182ee8dc9bd88eefbe7877c769150e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TRIANGLE_INCOMPLETE_3</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a63420b8569315b97e759910a6e97fde8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TRIANGLE_3</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a79c9343bfd5996352dbc52d0085116e9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TRIANGLE_INCOMPLETE_4</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1aee8089c3adca2fcff0ae5961db2ca4ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TRIANGLE_4</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a88f4fbeaf4332ea44eb880a60057a99b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TRIANGLE_INCOMPLETE_5</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a18fe04ea4d20b4e08f2d53593b4eab80</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TRIANGLE_5</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a54f3f4b7a65f4d7a1b42d3aa045de648</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_LINE_3</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a0800058b7a8fc81417cbcbeb530dddff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_LINE_4</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1ac70e34fe9d12e0279e8dda2ee527e2e3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_LINE_5</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a1dd62f2520e365961f6c04c726fa7928</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TETRAHEDRON_3</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1afc8b8875fba239d65dbc5c4af24317aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TETRAHEDRON_4</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1a8e73cfb6e8197635cb8f96f87983c7cc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GMSH_TETRAHEDRON_5</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd2154c710709e9de515c298d86dd8a1ac6848bf8621a93b8ee38a4973b9b8292</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>GeoEntityContext</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a5df59a8b1a63f40c3c1d5a65162254d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESH_ENTITY_INTERNAL</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ga5df59a8b1a63f40c3c1d5a65162254d5ab58df77c4224c0712d878f278a68ffb3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESH_ENTITY_BOUNDARY</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ga5df59a8b1a63f40c3c1d5a65162254d5a8cf391070355f4b58e4187176f4eccc2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ReferenceGeometry</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a8a2b0de2d64f5281612ba8d3077fbfd6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GEOMETRY_POINT</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ga8a2b0de2d64f5281612ba8d3077fbfd6af7c4e3a56f51e73b3ddb049c6a05ec66</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GEOMETRY_LINE</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ga8a2b0de2d64f5281612ba8d3077fbfd6afee0cbded33063db1eeff118272afa74</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GEOMETRY_SURFACE</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ga8a2b0de2d64f5281612ba8d3077fbfd6abaa799c22c419709b9a1c656e6993485</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GEOMETRY_VOLUME</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ga8a2b0de2d64f5281612ba8d3077fbfd6a4a5fafdedda4a8b1f802bddd58dc612a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GEOMETRY_4</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ga8a2b0de2d64f5281612ba8d3077fbfd6a54503d8991db83b0881690920230a997</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GEOMETRY_5</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ga8a2b0de2d64f5281612ba8d3077fbfd6ac4e0f60e28b63a4d720202b5bee0bea9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ElementsType</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9e8a34e55922ab08cf593c8f9addd590</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESH_ELEMENTS</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9e8a34e55922ab08cf593c8f9addd590aba9f37f6ea35ac09cf969b638eac11d6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESH_FACES</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9e8a34e55922ab08cf593c8f9addd590a45f482eab6ccb2dd97a838fbbf7b287a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESH_INTERNAL_FACES</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9e8a34e55922ab08cf593c8f9addd590abe2186af856a1d6b589ed5de3506af65</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESH_EDGES</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9e8a34e55922ab08cf593c8f9addd590a822c39538709589ddc423825b9adf5ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESH_INTERNAL_EDGES</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9e8a34e55922ab08cf593c8f9addd590a9ed28d0d616b5ede99732a77e43fdab7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESH_POINTS</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9e8a34e55922ab08cf593c8f9addd590a9a4435f4374f50c44d57dbbcff2b0fd3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MeshComponents</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a82cf55da340f64b682d0bea678d6cdf4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>CRBErrorType</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a87e77631faf5262bc0eaca80b8e9190f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9e126cb1abe01c7ef329b5d2bd285899</anchor>
      <arglist>(std::ostream &amp;os, AboutData const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>FEELPP_NO_EXPORT std::pair&lt; std::string, std::string &gt;</type>
      <name>at_option_parser</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a5f6ec689f1105d288427af8971bd5a42</anchor>
      <arglist>(std::string const &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>po::options_description</type>
      <name>benchmark_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a0269c708b09e8c351ed875ebb158032f</anchor>
      <arglist>(std::string const &amp;prefix=&quot;&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printErrors</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab96ae317757f5054b041640ba7ee3cda</anchor>
      <arglist>(std::ostream &amp;out, std::vector&lt; ptree::ptree &gt; const &amp;stats, std::string const &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printNumbers</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abbd50b946aadbc376f07cbf8a9280018</anchor>
      <arglist>(std::ostream &amp;out, std::vector&lt; ptree::ptree &gt; const &amp;stats, std::string const &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printData</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4b621f25ebd4aa710fa7d95cb1238001</anchor>
      <arglist>(std::ostream &amp;out, std::vector&lt; ptree::ptree &gt; const &amp;stats, std::string const &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printTime</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a21628a1468285f8c5c886317d3d8346c</anchor>
      <arglist>(std::ostream &amp;out, std::vector&lt; ptree::ptree &gt; const &amp;stats, std::string const &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>FEELPP_NO_EXPORT po::options_description</type>
      <name>mpiOptions</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a405e78fdc4af3f7aef549525ceb73a9d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>FEELPP_NO_EXPORT po::options_description</type>
      <name>serialOptions</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a7491528cad791a011c7585c0dbe747cc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Log</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aed8e06c4d5d01b3f4e5e2fb9b7d36953</anchor>
      <arglist>(int area, DebugStream::stprintf func)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Log</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af26c1400449d75d57e5c9f150de6e6ae</anchor>
      <arglist>(bool cond, int area, DebugStream::stprintf)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Debug</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a3f3055fe8659d182981035731bf6957f</anchor>
      <arglist>(int area, DebugStream::stprintf func)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Debug</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a92dd2ae2494873c601a01d7ee8f0ae3d</anchor>
      <arglist>(bool cond, int area, DebugStream::stprintf)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Warning</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a356deb1c43e40cf2d112e86ca0ce1280</anchor>
      <arglist>(int area)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Warning</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6d3b5091878d448a92cf2ad5078e7325</anchor>
      <arglist>(bool cond, int area)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Error</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a526247c8c47c857ce82809c7967ade5f</anchor>
      <arglist>(int area)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Error</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a26a26c520c7122d0a4ba38135308e288</anchor>
      <arglist>(bool cond, int area)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Fatal</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a062e9a1773c6b026e6d2f8070e852d25</anchor>
      <arglist>(int area)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream</type>
      <name>Fatal</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ac37b7639cb589ac68598965162dd7977</anchor>
      <arglist>(bool cond, int area)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>backtrace</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9ddbf7cbdafe486102ea8e1595c8134c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>backtrace</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a96c2617b2514cbf6a8aaa6ea98893324</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ae2f5cc9d4818d5183d32e0f46bd0bd81</anchor>
      <arglist>(DebugStream &amp;__s, T const *__t)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>perror</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ae0a4372311e92acdb374a3b69f6ae60d</anchor>
      <arglist>(NdebugStream &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>endl</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab6955566da6efdd3349d1aabe8ab2f22</anchor>
      <arglist>(NdebugStream &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>flush</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4f2e149c86281ea44f4ce06aac161abe</anchor>
      <arglist>(NdebugStream &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a792fc05ea8776c3cc84c7cc3057e12c6</anchor>
      <arglist>(DebugStream &amp;__os, Eigen::Matrix&lt; T, N1, N2 &gt; const &amp;__n)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a138bb364972e8631ce445857b56f0181</anchor>
      <arglist>(NdebugStream &amp;__os, Eigen::Matrix&lt; T, N1, N2 &gt; const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>prefixvm</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>afdf3582bcb29eaf28321e1f5c48bfa36</anchor>
      <arglist>(std::string const &amp;prefix, std::string const &amp;opt, std::string const &amp;sep)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_STATIC_ASSERT</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6bf4800b7bf8abcb60ba91b2ce38d549</anchor>
      <arglist>((boost::is_same&lt; real32_type, float &gt;::value))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_STATIC_ASSERT</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a74f2222b08f5abee0821b9e6a8cc5a14</anchor>
      <arglist>((boost::is_same&lt; real64_type, double &gt;::value))</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad3f3d90ce8c5d435099ca56677e67fd7</anchor>
      <arglist>(const TypeInfo &amp;lhs, const TypeInfo &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a797cb01027644ba296cd7d5aaa9bf630</anchor>
      <arglist>(const TypeInfo &amp;lhs, const TypeInfo &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a88ea5a3fdaa903eb8f31ca1494a4ad8b</anchor>
      <arglist>(const TypeInfo &amp;lhs, const TypeInfo &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a73a71f9477cfbde9f0a3e231330ffbf5</anchor>
      <arglist>(const TypeInfo &amp;lhs, const TypeInfo &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6bdff0cbd23bf1a0ae9b8d5f77e0e79e</anchor>
      <arglist>(const TypeInfo &amp;lhs, const TypeInfo &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af33413985cc17a496f777eebad9645b6</anchor>
      <arglist>(const TypeInfo &amp;lhs, const TypeInfo &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>operator++</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a2fd503a1b3c62f02a812731ed5b22384</anchor>
      <arglist>(boost::shared_ptr&lt; Aitken&lt; fs_type &gt; &gt; &amp;aitk)</arglist>
    </member>
    <member kind="function">
      <type>boost::shared_ptr&lt; Aitken&lt; SpaceType &gt; &gt;</type>
      <name>aitkenNew</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9291765685a78113af760ca02b975c5c</anchor>
      <arglist>(boost::shared_ptr&lt; SpaceType &gt; const &amp;_space, AitkenType _type, double _init_theta, double _tol)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a412b816e4fe9c576631c1b5efcdab9c1</anchor>
      <arglist>((typename compute_aitken_return&lt; Args &gt;::type), aitken, tag,(required(space,*(boost::is_convertible&lt; mpl::_, boost::shared_ptr&lt; FunctionSpaceBase &gt; &gt;)))(optional(type,(AitkenType), AITKEN_STANDARD)(initial_theta,*(boost::is_arithmetic&lt; mpl::_ &gt;), 1.0)(tolerance,*(boost::is_arithmetic&lt; mpl::_ &gt;), 1.0e-6)))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4fa819885a9a2899de628096b12ff39e</anchor>
      <arglist>((typename compute_aitken_return&lt; Args &gt;::ptrtype), aitkenPtr, tag,(required(space,*(boost::is_convertible&lt; mpl::_, boost::shared_ptr&lt; FunctionSpaceBase &gt; &gt;)))(optional(type,(AitkenType), AITKEN_STANDARD)(initial_theta,*(boost::is_arithmetic&lt; mpl::_ &gt;), 1.0)(tolerance,*(boost::is_arithmetic&lt; mpl::_ &gt;), 1.0e-6)))</arglist>
    </member>
    <member kind="function">
      <type>po::options_description</type>
      <name>backend_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a04ed4818b422d55de7aba6f00ca59e0e</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a3e02a4b1f8acebb94176a692e6adf3c0</anchor>
      <arglist>((backend_ptrtype), backend, tag,(optional(vm,(po::variables_map), po::variables_map())(name,(std::string),&quot;&quot;)(kind,(BackendType), BACKEND_PETSC)(rebuild,(bool), false)))</arglist>
    </member>
    <member kind="function">
      <type>po::options_description</type>
      <name>backendgmm_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a237fa6fbecc6b600939694f57887629a</anchor>
      <arglist>(std::string const &amp;prefix, BackendGmmDefaults defaults)</arglist>
    </member>
    <member kind="function">
      <type>po::options_description</type>
      <name>backendpetsc_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a745fa7e1c7f6cfb0b31c08b44d7ee967</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bfgs</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4101e9b098204150bed0c9fe112ce997</anchor>
      <arglist>(FUNCTION f, DERIVATIVE grad, VECTOR &amp;x, int restart, IterationBFGS &amp;iter, BFGSType version=BFGS, float lambda_init=0.001, float=1.0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>dfp</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab5c73a46a30d5f12ad410cc8826e3b4a</anchor>
      <arglist>(FUNCTION f, DERIVATIVE grad, VECTOR &amp;x, int restart, IterationBFGS &amp;iter, BFGSType version=DFP)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>PetscPCFactorSetMatSolverPackage</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a451bcfd28bef94b065bb2f154357ef56</anchor>
      <arglist>(PC &amp;pc, MatSolverPackageType mspackt)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>Min</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a16fd333bec3f7b5f51d1fdb64648cf0f</anchor>
      <arglist>(const T &amp;a, const T &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>Max</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad4eb9aac4e62b94ab49613797074c820</anchor>
      <arglist>(const T &amp;a, const T &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>Abs</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aaee723d543692fbdffb43c626e4096d7</anchor>
      <arglist>(const T &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>Exchange</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a1f50e41ce313458f43399b8290af5c20</anchor>
      <arglist>(T &amp;a, T &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>Max</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab6474c1090160d4fb52b10b61eba1fce</anchor>
      <arglist>(const T &amp;a, const T &amp;b, const T &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>Min</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab6f341c9dd7d51e10d8e7b22ebc48f19</anchor>
      <arglist>(const T &amp;a, const T &amp;b, const T &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a2f13f5b33eff15ecc9104390744f2d14</anchor>
      <arglist>(DebugStream &amp;__os, node&lt; real64_type &gt;::type const &amp;__n)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ae4e3da3c30ce2fe00b58df1927bdb756</anchor>
      <arglist>(NdebugStream &amp;os, node&lt; real64_type &gt;::type const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4dc438f11c911f0fb4abfb8dec206e3b</anchor>
      <arglist>(DebugStream &amp;__os, ublas::vector&lt; T &gt; const &amp;__n)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a5b68587fc7054610d8ed0601c784975e</anchor>
      <arglist>(NdebugStream &amp;__os, ublas::vector&lt; T &gt; const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a31f1fabd5c8b87d26cb04b7b9be12ecb</anchor>
      <arglist>(DebugStream &amp;__os, ublas::matrix&lt; T, Orient &gt; const &amp;__n)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a32fd9d1136c1ee4886db94ab09473bf5</anchor>
      <arglist>(NdebugStream &amp;__os, ublas::matrix&lt; T, Orient &gt; const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spy</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a57be0a3aed172426f0a7ea6c716d033d</anchor>
      <arglist>(MatrixType const &amp;__m, std::string const &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>Matrix::value_type</type>
      <name>det</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6e7f371b72232f1af939519095e5f888</anchor>
      <arglist>(Matrix const &amp;M)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>inverse</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af60e1492d6091108e7874985d297deab</anchor>
      <arglist>(Matrix const &amp;M, Matrix &amp;Minv)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>inverse</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a026bb88c7baecc1dd86c62634811c7a3</anchor>
      <arglist>(Matrix const &amp;__restrict__ M, Matrix &amp;__restrict__ Minv, typename Matrix::value_type const &amp;J)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a85683418202ab99e52f81982f3571ae2</anchor>
      <arglist>(std::ostream &amp;os, const MatrixSparse&lt; T &gt; &amp;m)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_MEMBER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad8b9c610913b7d19b2e3d07c40615488</anchor>
      <arglist>((boost::shared_ptr&lt; Preconditioner&lt; double &gt; &gt;), preconditioner, tag,(required(pc,(PreconditionerType)))(optional(matrix,(d_sparse_matrix_ptrtype), d_sparse_matrix_ptrtype())(backend,(BackendType), BACKEND_PETSC)(pcfactormatsolverpackage,(MatSolverPackageType), MATSOLVER_PETSC)(worldcomm,*, WorldComm())))</arglist>
    </member>
    <member kind="function">
      <type>po::options_description</type>
      <name>solvereigen_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab1352fb3297fdd0c417e899b59afa2f7</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_MEMBER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a2261a1386d3b588c8201251c378d7af7</anchor>
      <arglist>((typename SolverEigen&lt; double &gt;::eigenmodes_type), eigs, tag,(required(matrixA,(d_sparse_matrix_ptrtype))(matrixB,(d_sparse_matrix_ptrtype)))(optional(nev,(int), 1)(ncv,(int), 3)(backend,(BackendType), BACKEND_PETSC)(solver,(EigenSolverType), KRYLOVSCHUR)(problem,(EigenProblemType), GHEP)(transform,(SpectralTransformType), SHIFT)(spectrum,(PositionOfSpectrum), LARGEST_MAGNITUDE)(maxit,(size_type), 1000)(tolerance,(double), 1e-11)(verbose,(bool), false)))</arglist>
    </member>
    <member kind="function">
      <type>po::options_description</type>
      <name>solvereigenslepc_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a1ff9eb2d1e8570976034b26df27656ef</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>po::options_description</type>
      <name>nlsolver_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9310651aca14e583153bd22beeacc23f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>type_traits&lt; T &gt;::real_type</type>
      <name>inner_product</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a73707c3e6d405359ea9b4e1f21c9e530</anchor>
      <arglist>(Vector&lt; T &gt; const &amp;v1, Vector&lt; T &gt; const &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>type_traits&lt; T &gt;::real_type</type>
      <name>inner_product</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aae630433d7cade6d2278e84af1e0cb36</anchor>
      <arglist>(boost::shared_ptr&lt; Vector&lt; T &gt; &gt; const &amp;v1, boost::shared_ptr&lt; Vector&lt; T &gt; &gt; const &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>type_traits&lt; T &gt;::real_type</type>
      <name>dot</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9cf4a40a16c7f038b9ab0b057874e4be</anchor>
      <arglist>(boost::shared_ptr&lt; Vector&lt; T &gt; &gt; const &amp;v1, boost::shared_ptr&lt; Vector&lt; T &gt; &gt; const &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>type_traits&lt; T &gt;::real_type</type>
      <name>dot</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a3aa2d206354f3e6b0ffc2925dc326ab5</anchor>
      <arglist>(Vector&lt; T &gt; const &amp;v1, Vector&lt; T &gt; const &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>VectorUblas&lt; T &gt;</type>
      <name>element_product</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad82b78c47b3f9cd94a54c463643e79e0</anchor>
      <arglist>(VectorUblas&lt; T &gt; const &amp;v1, VectorUblas&lt; T &gt; const &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>VectorUblas&lt; T &gt;</type>
      <name>element_product</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad729b234ba3c004864dc5ead5203e59b</anchor>
      <arglist>(boost::shared_ptr&lt; VectorUblas&lt; T &gt; &gt; const &amp;v1, boost::shared_ptr&lt; VectorUblas&lt; T &gt; &gt; const &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>po::options_description</type>
      <name>exporter_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a7cf67b8474fa1ad278fc2338cc21c157</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aa77c4f07552efe9fd54f86982f060fb8</anchor>
      <arglist>((typename detail::mesh&lt; Args &gt;::ptrtype), straightenMesh, tag,(required(mesh,*))(optional(refine,*(boost::is_integral&lt; mpl::_ &gt;), 0)(save,*(boost::is_integral&lt; mpl::_ &gt;), 0)(worldcomm,(WorldComm), WorldComm())))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4a675bb30ae99ba1d53a28cbf20868f6</anchor>
      <arglist>((typename detail::mesh&lt; Args &gt;::ptrtype), loadGMSHMesh, tag,(required(mesh,*)(filename,*))(optional(straighten,*(boost::is_integral&lt; mpl::_ &gt;), 1)(refine,*(boost::is_integral&lt; mpl::_ &gt;), 0)(update,*(boost::is_integral&lt; mpl::_ &gt;), 0)(physical_are_elementary_regions,*, false)))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af0342f73318c46b967d5426bbab03326</anchor>
      <arglist>((void), saveGMSHMesh, tag,(required(mesh,*)(filename,*))(optional(parametricnodes,*(boost::is_integral&lt; mpl::_ &gt;), 0)))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4d8482036f0f97a57582e3602dc5bb0e</anchor>
      <arglist>((typename detail::mesh&lt; Args &gt;::ptrtype), createGMSHMesh, tag,(required(mesh,*)(desc,*))(optional(h,*(boost::is_arithmetic&lt; mpl::_ &gt;), 0.1)(parametricnodes,*(boost::is_integral&lt; mpl::_ &gt;), 0)(straighten,*(boost::is_integral&lt; mpl::_ &gt;), 1)(refine,*(boost::is_integral&lt; mpl::_ &gt;), 0)(update,*(boost::is_integral&lt; mpl::_ &gt;), 0)(force_rebuild,*(boost::is_integral&lt; mpl::_ &gt;), 0)(physical_are_elementary_regions,*, false)(partitions,*(boost::is_integral&lt; mpl::_ &gt;), 1)(partition_file,*(boost::is_integral&lt; mpl::_ &gt;), 0)(partitioner,*(boost::is_integral&lt; mpl::_ &gt;), GMSH_PARTITIONER_CHACO)(worldcomm,*, WorldComm())))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af8da0dc7377b26a89fb935cf778a585d</anchor>
      <arglist>((gmsh_ptrtype), domain, tag,(required(name,*(boost::is_convertible&lt; mpl::_, std::string &gt;))(shape,*(boost::is_convertible&lt; mpl::_, std::string &gt;)))(optional(shear,*(boost::is_arithmetic&lt; mpl::_ &gt;), 0)(recombine,*(boost::is_integral&lt; mpl::_ &gt;), 0)(dim,*(boost::is_integral&lt; mpl::_ &gt;), 3)(order,*(boost::is_integral&lt; mpl::_ &gt;), 1)(h,*(boost::is_arithmetic&lt; mpl::_ &gt;), double(0.1))(convex,*(boost::is_convertible&lt; mpl::_, std::string &gt;),&quot;Simplex&quot;)(addmidpoint,*(boost::is_integral&lt; mpl::_ &gt;), true)(usenames,*(boost::is_integral&lt; mpl::_ &gt;), false)(xmin,*(boost::is_arithmetic&lt; mpl::_ &gt;), 0.)(xmax,*(boost::is_arithmetic&lt; mpl::_ &gt;), 1)(ymin,*(boost::is_arithmetic&lt; mpl::_ &gt;), 0.)(ymax,*(boost::is_arithmetic&lt; mpl::_ &gt;), 1)(zmin,*(boost::is_arithmetic&lt; mpl::_ &gt;), 0.)(zmax,*(boost::is_arithmetic&lt; mpl::_ &gt;), 1)))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aa75178b5ff5604cefd1c78e10103205b</anchor>
      <arglist>((gmsh_ptrtype), geo, tag,(required(filename,*(boost::is_convertible&lt; mpl::_, std::string &gt;)))(optional(h,*(boost::is_arithmetic&lt; mpl::_ &gt;), double(0.1))(dim,*(boost::is_integral&lt; mpl::_ &gt;), 3)(order,*(boost::is_integral&lt; mpl::_ &gt;), 1)(files_path,*(boost::is_convertible&lt; mpl::_, std::string &gt;), Environment::localGeoRepository())(depends,*(boost::is_convertible&lt; mpl::_, std::string &gt;), std::string(&quot;&quot;))))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a38c357a62020b9c7ce88ff305e3a5ff7</anchor>
      <arglist>((gmsh_ptrtype), mshconvert, tag,(required(filename,*(boost::is_convertible&lt; mpl::_, std::string &gt;)))(optional(dim,*(boost::is_integral&lt; mpl::_ &gt;), 3)(order,*(boost::is_integral&lt; mpl::_ &gt;), 1)))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_FUNCTION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a62346cec73fcc4c172c2a5ccefd41fdd</anchor>
      <arglist>((std::string), img2msh, tag,(required(filename,*(boost::is_convertible&lt; mpl::_, std::string &gt;)))(optional(prefix,*(boost::is_convertible&lt; mpl::_, std::string &gt;), fs::path(filename).stem())))</arglist>
    </member>
    <member kind="function">
      <type>std::pair&lt; BareFace, bool &gt;</type>
      <name>makeBareFace</name>
      <anchorfile>group__BareItemsBuilder.html</anchorfile>
      <anchor>gaf5e3fd27bc0364dc4d1c5671adca807d</anchor>
      <arglist>(size_type const i, size_type const j, size_type const k)</arglist>
    </member>
    <member kind="function">
      <type>std::pair&lt; BareFace, bool &gt;</type>
      <name>makeBareFace</name>
      <anchorfile>group__BareItemsBuilder.html</anchorfile>
      <anchor>gab2770273d31d671d77dd772791b64444</anchor>
      <arglist>(size_type const i, size_type const j, size_type const k, size_type const l)</arglist>
    </member>
    <member kind="function">
      <type>std::pair&lt; BarePoint, bool &gt;</type>
      <name>makeBarePoint</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a83df9e4a047f5bbff50136b58cfee46f</anchor>
      <arglist>(size_type const i)</arglist>
    </member>
    <member kind="function">
      <type>std::pair&lt; BareEdge, bool &gt;</type>
      <name>makeBareEdge</name>
      <anchorfile>group__BareItemsBuilder.html</anchorfile>
      <anchor>ga87054b8a2a565d7ad927bacddcdb118b</anchor>
      <arglist>(size_type const i, size_type const j)</arglist>
    </member>
    <member kind="function">
      <type>std::pair&lt; BareEdge, bool &gt;</type>
      <name>makeBareItem</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab749e83b1b867a08200d3288429ff013</anchor>
      <arglist>(size_type i, size_type j)</arglist>
    </member>
    <member kind="function">
      <type>BareEdge</type>
      <name>setBareEdge</name>
      <anchorfile>group__BareItemsBuilder.html</anchorfile>
      <anchor>ga52d8548d4bb34050badfef432535f0e4</anchor>
      <arglist>(size_type const i, size_type const j)</arglist>
    </member>
    <member kind="function">
      <type>BareEdge</type>
      <name>setBareEdgeNo</name>
      <anchorfile>group__BareItemsBuilder.html</anchorfile>
      <anchor>ga5232fc93ced0a4b9ae921269ed931416</anchor>
      <arglist>(size_type const i, size_type const j)</arglist>
    </member>
    <member kind="function">
      <type>std::pair&lt; BareFace, bool &gt;</type>
      <name>makeBareItem</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a0a965fdf451556155f3e2141c59d22bd</anchor>
      <arglist>(size_type i, size_type j, size_type k)</arglist>
    </member>
    <member kind="function">
      <type>std::pair&lt; BareFace, bool &gt;</type>
      <name>makeBareItem</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a8aee7f5ad42fb55b242b92532d0ecf9d</anchor>
      <arglist>(size_type i, size_type j, size_type k, size_type l)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>group__comparison.html</anchorfile>
      <anchor>gaf953dc59098fdbb7c6b1eeafd63836f5</anchor>
      <arglist>(const BareEdge &amp;p1, const BareEdge &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>group__comparison.html</anchorfile>
      <anchor>ga671bccf02473b3f273d6dd807fd882be</anchor>
      <arglist>(const BareEdge &amp;p1, const BareEdge &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>group__comparison.html</anchorfile>
      <anchor>ga836804dcdd75102047ecca37c1bffdb9</anchor>
      <arglist>(const BareEdge &amp;e1, const BareEdge &amp;e2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>group__comparison.html</anchorfile>
      <anchor>ga4e8e7dc5fd8d09cc0b5000b8238b9eb5</anchor>
      <arglist>(const BareEdge &amp;e1, const BareEdge &amp;e2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>group__comparison.html</anchorfile>
      <anchor>ga80e4fd4470b9d20f244d72378c4f9c76</anchor>
      <arglist>(const BareEdge &amp;e1, const BareEdge &amp;e2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>group__comparison.html</anchorfile>
      <anchor>gaec44708d6f919b2d2f7a7224e2d248c5</anchor>
      <arglist>(const BareEdge &amp;e1, const BareEdge &amp;e2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>group__comparison.html</anchorfile>
      <anchor>gaec2f656ea70505686355087470904b05</anchor>
      <arglist>(const BareFace &amp;p1, const BareFace &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>group__comparison.html</anchorfile>
      <anchor>ga7a46756b960122c12db4df2367ce4d10</anchor>
      <arglist>(const BareFace &amp;p1, const BareFace &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>getId</name>
      <anchorfile>group__Helper.html</anchorfile>
      <anchor>ga94ebd5aca3f55c90213198cee1435566</anchor>
      <arglist>(std::pair&lt; BareItem, size_type &gt; const &amp;i)</arglist>
    </member>
    <member kind="function">
      <type>BareItem</type>
      <name>getItem</name>
      <anchorfile>group__Helper.html</anchorfile>
      <anchor>ga014f15b132f23cdbe4f8dc422e5d465d</anchor>
      <arglist>(std::pair&lt; BareItem, size_type &gt; const &amp;i)</arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>meshrank</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a3a611a63287304f88a12e560dbd90629</anchor>
      <arglist>(MeshType const &amp;mesh, mpl::bool_&lt; true &gt;)</arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>meshrank</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a64466ee2bf012a7c13439e586a218892</anchor>
      <arglist>(MeshType const &amp;mesh, mpl::bool_&lt; false &gt;)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::element_const_iterator, typename MeshTraits&lt; MeshType &gt;::element_const_iterator &gt;</type>
      <name>allelements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a65bb54325ae1f537f4343871c75d43c4</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::element_const_iterator, typename MeshTraits&lt; MeshType &gt;::element_const_iterator &gt;</type>
      <name>elements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a39073cc1999197bf9963bd5bdc86454a</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::location_element_const_iterator, typename MeshTraits&lt; MeshType &gt;::location_element_const_iterator &gt;</type>
      <name>boundaryelements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a5598068f2b33128787bb978b585f8aa6</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::location_element_const_iterator, typename MeshTraits&lt; MeshType &gt;::location_element_const_iterator &gt;</type>
      <name>internalelements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9a80650ba21cfe9d2f4ababe410a0ed5</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::marker_element_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker_element_const_iterator &gt;</type>
      <name>markedelements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad2c61f47b61321c8af13daff27760d1d</anchor>
      <arglist>(MeshType const &amp;mesh, flag_type flag)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::marker_element_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker_element_const_iterator &gt;</type>
      <name>markedelements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a465219e2d295ecae099f623082001ec3</anchor>
      <arglist>(MeshType const &amp;mesh, std::string const &amp;flag)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::marker2_element_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker2_element_const_iterator &gt;</type>
      <name>marked2elements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af03a372bfd8ffdca749fbe87870382a3</anchor>
      <arglist>(MeshType const &amp;mesh, flag_type flag)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::marker2_element_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker2_element_const_iterator &gt;</type>
      <name>marked2elements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a5cbae5f71c8741bd7c7e54cf82821765</anchor>
      <arglist>(MeshType const &amp;mesh, std::string const &amp;flag)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::marker3_element_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker3_element_const_iterator &gt;</type>
      <name>marked3elements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9c1fbba3985e58d2d69f253bc9c39d55</anchor>
      <arglist>(MeshType const &amp;mesh, flag_type flag)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::marker3_element_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker3_element_const_iterator &gt;</type>
      <name>marked3elements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a020c9a00143c386a8152bfa721e381bc</anchor>
      <arglist>(MeshType const &amp;mesh, std::string const &amp;flag)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename MeshTraits&lt; MeshType &gt;::element_const_iterator, typename MeshTraits&lt; MeshType &gt;::element_const_iterator &gt;</type>
      <name>idedelements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a417351aa13cd75a3329e5da9ebb090f1</anchor>
      <arglist>(MeshType const &amp;mesh, flag_type flag)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::pid_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::pid_face_const_iterator &gt;</type>
      <name>faces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a12d0226a5e73e64f3b97bf9c723ee239</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::face_const_iterator, typename MeshTraits&lt; MeshType &gt;::face_const_iterator &gt;</type>
      <name>idedfaces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a93fd163019ef944e6b726ab5a3da416b</anchor>
      <arglist>(MeshType const &amp;mesh, size_type id)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::marker_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker_face_const_iterator &gt;</type>
      <name>markedfaces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ac0d40e0852d5f0d447623caff773b1a5</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::marker_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker_face_const_iterator &gt;</type>
      <name>markedfaces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a8c269014fc03793bb2bb2f611095d72b</anchor>
      <arglist>(MeshType const &amp;mesh, flag_type __marker)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::marker2_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker2_face_const_iterator &gt;</type>
      <name>marked2faces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9281983c555223853306d4fff3c91380</anchor>
      <arglist>(MeshType const &amp;mesh, flag_type __marker)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::marker3_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker3_face_const_iterator &gt;</type>
      <name>marked3faces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a96959a401f694a83d90a41be1ff5373c</anchor>
      <arglist>(MeshType const &amp;mesh, flag_type __marker)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::marker_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker_face_const_iterator &gt;</type>
      <name>markedfaces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a77ead35707351cadff85f33d7c93e671</anchor>
      <arglist>(MeshType const &amp;mesh, std::string const &amp;__marker)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::marker2_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker2_face_const_iterator &gt;</type>
      <name>marked2faces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4a34e6e25d4d8daed18a1b24f8c552ce</anchor>
      <arglist>(MeshType const &amp;mesh, std::string const &amp;__marker)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::marker3_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker3_face_const_iterator &gt;</type>
      <name>marked3faces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a080907b8132cfd4609a9c565bb6e7422</anchor>
      <arglist>(MeshType const &amp;mesh, std::string const &amp;__marker)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::location_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::location_face_const_iterator &gt;</type>
      <name>boundaryfaces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6d4deea03257c3f53b0e9df514a7bf00</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::location_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::location_face_const_iterator &gt;</type>
      <name>internalfaces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6c53147b25bf664bdf6bec2b30b56af7</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_FACES &gt;, typename MeshTraits&lt; MeshType &gt;::interprocess_face_const_iterator, typename MeshTraits&lt; MeshType &gt;::interprocess_face_const_iterator &gt;</type>
      <name>interprocessfaces</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abc95225dae92e77cc06508c91b1be972</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_EDGES &gt;, typename MeshTraits&lt; MeshType &gt;::pid_edge_const_iterator, typename MeshTraits&lt; MeshType &gt;::pid_edge_const_iterator &gt;</type>
      <name>edges</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>acc2d630cda517a95be1879ea38fb5069</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_EDGES &gt;, typename MeshTraits&lt; MeshType &gt;::marker_edge_const_iterator, typename MeshTraits&lt; MeshType &gt;::marker_edge_const_iterator &gt;</type>
      <name>markededges</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4262e71423eb1c1337e7085749ed2f1b</anchor>
      <arglist>(MeshType const &amp;mesh, flag_type __marker)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_EDGES &gt;, typename MeshTraits&lt; MeshType &gt;::location_edge_const_iterator, typename MeshTraits&lt; MeshType &gt;::location_edge_const_iterator &gt;</type>
      <name>boundaryedges</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a0f6104229c3e1de89e4e9dc0669db8b8</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_EDGES &gt;, typename MeshTraits&lt; MeshType &gt;::location_edge_const_iterator, typename MeshTraits&lt; MeshType &gt;::location_edge_const_iterator &gt;</type>
      <name>internaledges</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9decd4d08511d44ea9e33cdb35758ec1</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_POINTS &gt;, typename MeshTraits&lt; MeshType &gt;::point_const_iterator, typename MeshTraits&lt; MeshType &gt;::point_const_iterator &gt;</type>
      <name>points</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a07ec0494dee4ca9a16b866e8c1f4d495</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_POINTS &gt;, typename MeshTraits&lt; MeshType &gt;::marked_point_const_iterator, typename MeshTraits&lt; MeshType &gt;::marked_point_const_iterator &gt;</type>
      <name>markedpoints</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a509ff6e6780bd8c6e68d7a04e5eb6dd8</anchor>
      <arglist>(MeshType const &amp;mesh, size_type flag)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_POINTS &gt;, typename MeshTraits&lt; MeshType &gt;::location_point_const_iterator, typename MeshTraits&lt; MeshType &gt;::location_point_const_iterator &gt;</type>
      <name>boundarypoints</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a0bbc5b859c51ad73faa39f6ab301b8b9</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_POINTS &gt;, typename MeshTraits&lt; MeshType &gt;::location_point_const_iterator, typename MeshTraits&lt; MeshType &gt;::location_point_const_iterator &gt;</type>
      <name>internalpoints</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a5c10346e263af6fbc0709fb6084fcf6f</anchor>
      <arglist>(MeshType const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>nelements</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab1ef5097f689b224b4f31e80dbd80ee0</anchor>
      <arglist>(boost::tuple&lt; MT, Iterator, Iterator &gt; const &amp;its)</arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; mpl::size_t&lt; MESH_ELEMENTS &gt;, typename std::list&lt; ElementType &gt;::const_iterator, typename std::list&lt; ElementType &gt;::const_iterator &gt;</type>
      <name>element</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a8a7f9780881297546a84f30d6290b4ef</anchor>
      <arglist>(ElementType const &amp;elt)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaa20e875ec92140e3058b54382cd13fc4</anchor>
      <arglist>(DebugStream &amp;__os, Geo0D&lt; Dim, T &gt; const &amp;__n)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga992cd95cdc8e64666e6a95addc029cb0</anchor>
      <arglist>(NdebugStream &amp;__os, Geo0D&lt; Dim, T &gt; const &amp;__n)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>distance</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga4325f5fef1deb9c9a3e8b8dde02f1eb8</anchor>
      <arglist>(Geo0D&lt; 1, T &gt; const &amp;p1, Geo0D&lt; 1, T &gt; const &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>distance</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga792ee6795b4e216f19e62a29f72aeb17</anchor>
      <arglist>(Geo0D&lt; 2, T &gt; const &amp;p1, Geo0D&lt; 2, T &gt; const &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>distance</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaf283b6a618148fbc7cb15d9312758863</anchor>
      <arglist>(Geo0D&lt; 3, T &gt; const &amp;p1, Geo0D&lt; 3, T &gt; const &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>Geo0D&lt; 1, T &gt;</type>
      <name>middle</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga5c3828bcc6652da1332cce5141fe0752</anchor>
      <arglist>(Geo0D&lt; 1, T &gt; const &amp;p1, Geo0D&lt; 1, T &gt; const &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>Geo0D&lt; 2, T &gt;</type>
      <name>middle</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga66b9073d1562406dcc11a178b711a586</anchor>
      <arglist>(Geo0D&lt; 2, T &gt; const &amp;p1, Geo0D&lt; 2, T &gt; const &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>Geo0D&lt; 3, T &gt;</type>
      <name>middle</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gab2a8eaa91bbe1a38726d511b9117dbfe</anchor>
      <arglist>(Geo0D&lt; 3, T &gt; const &amp;p1, Geo0D&lt; 3, T &gt; const &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>ublas::vector&lt; double &gt;</type>
      <name>cross</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga703b094178a719a2acbe543b4fa03fdd</anchor>
      <arglist>(ublas::vector_expression&lt; E1 &gt; _p1, ublas::vector_expression&lt; E2 &gt; _p2)</arglist>
    </member>
    <member kind="function">
      <type>ublas::vector&lt; double &gt;</type>
      <name>cross</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga78d09bc6139f4dadcdff4afc2b6b745b</anchor>
      <arglist>(Geo0D&lt; 3, T &gt; p1, Geo0D&lt; 3, T &gt; p2)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6e9efb8209b23996b939957a25b5a90b</anchor>
      <arglist>(DebugStream &amp;__os, GeoND&lt; Dim, GEOSHAPE, T, POINTTYPE &gt; const &amp;__n)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a6129de96ce2707aa94eb22cb8e2a7321</anchor>
      <arglist>(NdebugStream &amp;__os, GeoND&lt; Dim, GEOSHAPE, T, POINTTYPE &gt; const &amp;__n)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a90c5c4c172c3b27d2de64682a02c6319</anchor>
      <arglist>(std::ostream &amp;os, Reference&lt; Geo, Dim, Order, RDim, T &gt; const &amp;ref)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>toPython</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab3cd6c0bc878c473c33e3b67057ca823</anchor>
      <arglist>(RefEntity const &amp;e, std::string str=&quot;simplex&quot;)</arglist>
    </member>
    <member kind="function">
      <type>FEELPP_NO_EXPORT bool</type>
      <name>splitTest</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a82c3b2814b459ae5824c52def383245b</anchor>
      <arglist>(const RegionTree::pbox_container_type &amp;b, const node_type &amp;bmin, const node_type &amp;bmax, size_type dir, scalar_type &amp;split_v)</arglist>
    </member>
    <member kind="function">
      <type>FEELPP_NO_EXPORT RegionTree::element_base *</type>
      <name>build</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a0295d353f00b6182bed6806fa0d929d1</anchor>
      <arglist>(RegionTree::pbox_container_type &amp;b, const node_type &amp;bmin, const node_type &amp;bmax, size_type last_dir)</arglist>
    </member>
    <member kind="function">
      <type>FEELPP_NO_EXPORT void</type>
      <name>dump</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a648859452fcbc4987d83379a6ef1aae2</anchor>
      <arglist>(RegionTree::element_base *p, int level, size_type &amp;count)</arglist>
    </member>
    <member kind="function">
      <type>FEELPP_NO_EXPORT void</type>
      <name>destroy</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a83e6f1bd54b4671b12e2f18c513f44e7</anchor>
      <arglist>(RegionTree::element_base *n)</arglist>
    </member>
    <member kind="function">
      <type>ublas::matrix&lt; T &gt;</type>
      <name>JacobiBatchEvaluation</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a92e5d97033361931e9c040004731a4d2</anchor>
      <arglist>(T a, T b, ublas::vector&lt; T &gt; const &amp;__pts)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>JacobiBatchDerivation</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ae1a78bccb3df78ff41e2f93fa0153348</anchor>
      <arglist>(ublas::matrix&lt; T &gt; &amp;res, T a, T b, ublas::vector&lt; T &gt; const &amp;__pts, mpl::bool_&lt; true &gt;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>JacobiBatchDerivation</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a3e83087e6d0b147b0e4cef3a907241f2</anchor>
      <arglist>(ublas::matrix&lt; T &gt; &amp;, T, T, ublas::vector&lt; T &gt; const &amp;, mpl::bool_&lt; false &gt;)</arglist>
    </member>
    <member kind="function">
      <type>ublas::matrix&lt; T &gt;</type>
      <name>JacobiBatchDerivation</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a0b254a7aa3fb62a6bae02dae0f66284d</anchor>
      <arglist>(T a, T b, ublas::vector&lt; T &gt; const &amp;__pts)</arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>lebesgueConstant</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abe83662b21458912bee13bc5a4f46662</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Poly::value_type</type>
      <name>integrate</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4c300b4c137594540a9428af36363049</anchor>
      <arglist>(Polynomial&lt; Poly, PsetType &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Polynomial&lt; Poly, Type &gt;</type>
      <name>dx</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a03f3303c5b91e975155799efa3f30b25</anchor>
      <arglist>(Polynomial&lt; Poly, Type &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; Poly, Type &gt;</type>
      <name>dx</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9b0561a03e47fc0b47a793d158dc636f</anchor>
      <arglist>(PolynomialSet&lt; Poly, Type &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Polynomial&lt; Poly, Type &gt;</type>
      <name>dy</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abd65f7117df9527c0c921c5ff3a5b922</anchor>
      <arglist>(Polynomial&lt; Poly, Type &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; Poly, Type &gt;</type>
      <name>dy</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a678cc45753409e5de39afc9d4fd91388</anchor>
      <arglist>(PolynomialSet&lt; Poly, Type &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Polynomial&lt; Poly, Type &gt;</type>
      <name>dz</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a44337dbc65effaa525948f8939733b22</anchor>
      <arglist>(Polynomial&lt; Poly, Type &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; Poly, Type &gt;</type>
      <name>dz</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a035d345518f6a629318edcd57ce3275d</anchor>
      <arglist>(PolynomialSet&lt; Poly, Type &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Polynomial&lt; Poly, Vectorial &gt;</type>
      <name>gradient</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a2afbcddff5e3a84e885a5c20363c4099</anchor>
      <arglist>(Polynomial&lt; Poly, Scalar &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Polynomial&lt; Poly, Tensor2 &gt;</type>
      <name>gradient</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a2585c1fb3a5f58b5557aefb63f446de0</anchor>
      <arglist>(Polynomial&lt; Poly, Vectorial &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; Poly, Vectorial &gt;</type>
      <name>gradient</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a100886326e76f552a3b3fc936981f480</anchor>
      <arglist>(PolynomialSet&lt; Poly, Scalar &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; Poly, Tensor2 &gt;</type>
      <name>gradient</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aa9183188ba9980e13b6fab78fd35dfe4</anchor>
      <arglist>(PolynomialSet&lt; Poly, Vectorial &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; Poly, Tensor2 &gt;</type>
      <name>hessian</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a8073bad0e88192d69a7b74083ffa640d</anchor>
      <arglist>(PolynomialSet&lt; Poly, Scalar &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Polynomial&lt; Poly, Scalar &gt;</type>
      <name>divergence</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a552129f28d2fad48c78b92a1baccbdb9</anchor>
      <arglist>(Polynomial&lt; Poly, Vectorial &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; Poly, Scalar &gt;</type>
      <name>divergence</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a9f140d4902cd2b28cd758430f1af2f6e</anchor>
      <arglist>(PolynomialSet&lt; Poly, Vectorial &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Polynomial&lt; Poly, Vectorial &gt;</type>
      <name>curl</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af0e68f5f62e0b915cf3b9ac73b5c4080</anchor>
      <arglist>(Polynomial&lt; Poly, Vectorial &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; Poly, Vectorial &gt;</type>
      <name>curl</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a3788c225ebee3147f0bcd32c6d77478d</anchor>
      <arglist>(PolynomialSet&lt; Poly, Vectorial &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Polynomial&lt; Poly, Vectorial &gt;</type>
      <name>curlt</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a31844ce9bde57a55518ab057fd040744</anchor>
      <arglist>(Polynomial&lt; Poly, Vectorial &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; Poly, Vectorial &gt;</type>
      <name>curlt</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad711a250106c87c0df471a90881a2dfb</anchor>
      <arglist>(PolynomialSet&lt; Poly, Vectorial &gt; const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>Polynomial&lt; Pset, Scalar &gt;</type>
      <name>project</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ae89776231eca6bd68ba734da512759b3</anchor>
      <arglist>(Pset const &amp;pset, Func const &amp;f, IM const &amp;im)</arglist>
    </member>
    <member kind="function">
      <type>PolynomialSet&lt; P, Type &gt;</type>
      <name>unite</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ae64c75954df0318d6e9e1a5f848bb05c</anchor>
      <arglist>(Poly1&lt; P, Type &gt; const &amp;pset1, Poly2&lt; P, Type &gt; const &amp;pset2)</arglist>
    </member>
    <member kind="function">
      <type>Feel::po::options_description</type>
      <name>crbOptions</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a8139a0d4de5dc8faed1e4adcadba7a85</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>Feel::po::options_description</type>
      <name>crbSCMOptions</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a293e052585cf7b1afd0aa0f6a72aacef</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>po::options_description</type>
      <name>opusapp_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a599520e9ce1572efc7e71afaef20fd70</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>_o</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a2faecbdab41646e180ccdfd892c670f1</anchor>
      <arglist>(std::string const &amp;prefix, std::string const &amp;opt)</arglist>
    </member>
    <member kind="function">
      <type>AboutData</type>
      <name>makeAbout</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>af2287c0e54f971b2b302fb0fe0ce1259</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>po::options_description</type>
      <name>pfemapp_options</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad2b131cb1baf12462234f232706a3541</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>Feel::po::options_description</type>
      <name>podOptions</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ac7f3f7b952c2f4fa4766b542e3bff904</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static std::map&lt; unsigned int, std::string &gt; *</type>
      <name>DebugAreas</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a83343e9b486066f2f25e3d374e5e1c94</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static std::string *</type>
      <name>StringNull</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ac1a4e4ec547f28e1ea0b2f20b57ccf6c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static std::list&lt; int &gt; *</type>
      <name>AREAS</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abf184ab36fcf6293ef4f887dba0cd1e3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static std::string *</type>
      <name>DEBUG_AREA</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a2593380a8cbf6962ef13cdafe4144149</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const int64_type</type>
      <name>invalid_flag_type_value</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a33cad1849779384dc3e64e2f3f8689bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const double</type>
      <name>factor_from_eps</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a559102856463db18fe24e9d6241533ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const float</type>
      <name>factor_from_eps_fl</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a97f4cc26df35977a346e0c745f1e99e8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const double</type>
      <name>Pi</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ab6097da8bc17d065050751743fd5e76f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const double</type>
      <name>TGV</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a3f1a51d80d4ec7da77b8aa8054b005e2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const char *</type>
      <name>FEELPP_GMSH_FORMAT_VERSION</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a10d751f740be70fdbbf95abe2f9085e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const uint16_type</type>
      <name>MESH_ALL_COMPONENTS</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>adc5de8514aa86afe25c80845e67ed0ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const uint16_type</type>
      <name>MESH_COMPONENTS_DEFAULTS</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>abb3d68ba0c883c2d7cbd75e7f37e4231</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const mpl::int_&lt; GLOBAL_COMPONENT &gt;</type>
      <name>INDEX_GLOBAL_COMPONENT</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a33113db8751dc7996636d10050838623</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const mpl::int_&lt; COMPONENT_IN_COMPONENT &gt;</type>
      <name>INDEX_COMPONENT_IN_COMPONENT</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ad39b68362f4c0a84685aca90c325438f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const mpl::int_&lt; GLOBAL_FUNCTION_INDEX &gt;</type>
      <name>INDEX_GLOBAL_FUNCTION_INDEX</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a1541f90979c4298ed98a597e5312692d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const mpl::int_&lt; PER_COMPONENT_FUNCTION_INDEX &gt;</type>
      <name>INDEX_PER_COMPONENT_FUNCTION_INDEX</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>aa42b2f49680040df5280b1a82267ff91</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const mpl::int_&lt; COMPONENT_IN_COMPONENT_FUNCTION_INDEX &gt;</type>
      <name>INDEX_COMPONENT_IN_COMPONENT_FUNCTION_INDEX</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>ae825e8e90016f40bd88b7a6b56284980</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const mpl::int_&lt; FUNCTION_INDEX &gt;</type>
      <name>INDEX_FUNCTION_INDEX</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a51a92f1848fa6e93539836e4ac9943ae</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const uint8_type</type>
      <name>invalid_uint8_type_value</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a79ed5b16106b4f440ed3e76a8cb12ad3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const uint16_type</type>
      <name>invalid_uint16_type_value</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a74681da1036cc5b236aabef05d8a8f87</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const uint32_type</type>
      <name>invalid_uint32_type_value</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a0b3f2923da6adec210a20cfc4d3cb72b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const uint64_type</type>
      <name>invalid_uint64_type_value</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a4b975776624528b35464b71fd1a6603a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const dim_type</type>
      <name>invalid_dim_type_value</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a06fcd499069e30f5e897e6e1187c65d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const size_type</type>
      <name>invalid_size_type_value</name>
      <anchorfile>namespaceFeel.html</anchorfile>
      <anchor>a0d4d77cd361adda45d27d72ff0357e55</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::AboutDataPrivate</name>
    <filename>classFeel_1_1AboutDataPrivate.html</filename>
    <member kind="function">
      <type></type>
      <name>AboutDataPrivate</name>
      <anchorfile>classFeel_1_1AboutDataPrivate.html</anchorfile>
      <anchor>a986942231e057e7b2ec13015c8f62996</anchor>
      <arglist>(AboutDataPrivate const &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::AboutPerson</name>
    <filename>classFeel_1_1AboutPerson.html</filename>
    <member kind="function">
      <type></type>
      <name>AboutPerson</name>
      <anchorfile>classFeel_1_1AboutPerson.html</anchorfile>
      <anchor>a9340ef525ac4f0af07180f09837eb85f</anchor>
      <arglist>(std::string _name, std::string _task, std::string _emailAddress, std::string _webAddress)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AboutPerson</name>
      <anchorfile>classFeel_1_1AboutPerson.html</anchorfile>
      <anchor>aa1ec04c670c9471dc90194081cb2881f</anchor>
      <arglist>(AboutPerson const &amp;ap)</arglist>
    </member>
    <member kind="function">
      <type>AboutPerson &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1AboutPerson.html</anchorfile>
      <anchor>af783d6e4afc0386a2b6973aef26f85f5</anchor>
      <arglist>(AboutPerson const &amp;__ap)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>name</name>
      <anchorfile>classFeel_1_1AboutPerson.html</anchorfile>
      <anchor>a3e63b78b9c4ac13abc05dedb9c254b3f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>task</name>
      <anchorfile>classFeel_1_1AboutPerson.html</anchorfile>
      <anchor>acf2e4f16edf49149bb49ef03f3bef1b7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>emailAddress</name>
      <anchorfile>classFeel_1_1AboutPerson.html</anchorfile>
      <anchor>a8047efa3144d2a8c130b78d49c1e2b45</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>webAddress</name>
      <anchorfile>classFeel_1_1AboutPerson.html</anchorfile>
      <anchor>a6d776b1299f09c941b6bafb70c0b312f</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::AboutData</name>
    <filename>classFeel_1_1AboutData.html</filename>
    <member kind="enumeration">
      <name>LicenseKey</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a0a827cfc2cac83144e4595e19641ba3e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AboutData</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a6fde6fd5a520b403d7cada284bbd7dcb</anchor>
      <arglist>(const char *appName, const char *programName, const char *version, const char *shortDescription=&quot;&quot;, int licenseType=License_Unknown, const char *copyrightStatement=&quot;&quot;, const char *text=&quot;&quot;, const char *homePageAddress=&quot;&quot;, const char *bugsEmailAddress=&quot;feel-dev@webmail.polimi.it&quot;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AboutData</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a42056c8c7b5fbb65a5e2f18873add58a</anchor>
      <arglist>(AboutData const &amp;ad)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addAuthor</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a0a791e9093004aec3fc6c0beafe52391</anchor>
      <arglist>(std::string const &amp;name, std::string const &amp;task=0, std::string const &amp;emailAddress=0, std::string const &amp;webAddress=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addCredit</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>ab2040debd9804c5d0805e5c474967c53</anchor>
      <arglist>(std::string const &amp;name, std::string const &amp;task=0, std::string const &amp;emailAddress=0, std::string const &amp;webAddress=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLicenseText</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>ae232c15a9757fea1433471303e681369</anchor>
      <arglist>(std::string const &amp;license)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAppName</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a8b39a9a5927339bc0d9d09ae05ca50c8</anchor>
      <arglist>(std::string const &amp;appName)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProgramName</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a54d77288b38fa3f1711c7618c2798960</anchor>
      <arglist>(const char *programName)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVersion</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a6436cda76f37e780c3b6229baf2d88da</anchor>
      <arglist>(const char *version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShortDescription</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a33f3142fdaed169f684650323013c931</anchor>
      <arglist>(std::string const &amp;shortDescription)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLicense</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a11565a3e2e5ac2f6e418295401abca8e</anchor>
      <arglist>(LicenseKey licenseKey)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCopyrightStatement</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a41d48edc8d065f11155ff7321a01e465</anchor>
      <arglist>(std::string const &amp;copyrightStatement)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOtherText</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a2daf24d00a54716c493ab083edf9f1b6</anchor>
      <arglist>(std::string const &amp;otherText)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHomepage</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a3e6d562d3cc238c9f8425391c4aad981</anchor>
      <arglist>(std::string const &amp;homepage)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBugAddress</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>aebc7927a2b1e7fe7a501e4471a2bfca6</anchor>
      <arglist>(std::string const &amp;bugAddress)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProductName</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a3b7099fa456bccdfeaf853149e4559d8</anchor>
      <arglist>(std::string const &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>appName</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>aa0656098984fb7a34fe15bfda0a6e10e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>productName</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a2108904dc7f8770f5dfc5754fbe71241</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>programName</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>ac7becc92639e0e4500ac2fbefa2030c9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>version</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a93b05e598611f1d29e80942990c20f93</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>shortDescription</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>ae9d14da78987996411ab1bf9492c948a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>homepage</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a308275dfe323ec8896b41f511051cc7c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>bugAddress</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a8c1257c2e94d758c78f72f06663a355f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::vector&lt; AboutPerson &gt; &amp;</type>
      <name>authors</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a32d206aa794b8cc9b2b50dd0dee74e78</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::vector&lt; AboutPerson &gt; &amp;</type>
      <name>credits</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a750ab0bcd72636fca470b3f54ce59a93</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>otherText</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>ae7b5fbe549670955c664eee9be90fcb5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>license</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>a7b832a4a33f9ef8346b7a2b76b269177</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>copyrightStatement</name>
      <anchorfile>classFeel_1_1AboutData.html</anchorfile>
      <anchor>ae7bfc4fc37d728c6cb88a0524a3336b8</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::Application</name>
    <filename>classFeel_1_1Application.html</filename>
    <member kind="typedef">
      <type>boost::ptr_list&lt; Simget &gt;</type>
      <name>simgets_type</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>af693db51ca874953a72fee81cd13ed4e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>simgets_type::iterator</type>
      <name>simget_iterator</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>abf27535f4318a03d55a2607626981418</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Application</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a074224ccb2e3626252a7ff2885fcedfa</anchor>
      <arglist>(AboutData const &amp;ad)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Application</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a1112e920fd18b261ef08f30ae958cf23</anchor>
      <arglist>(AboutData const &amp;ad, po::options_description const &amp;od)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Application</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a7e72b49f60f7dcfafee4f38c67e79210</anchor>
      <arglist>(int argc, char **argv, AboutData const &amp;ad)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Application</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a8cafdbf60a11fa7ca6056dce78bc85a5</anchor>
      <arglist>(int argc, char **argv, AboutData const &amp;ad, po::options_description const &amp;od)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Application</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>abe9b41f50a635c26516123780444b149</anchor>
      <arglist>(Application const &amp;app)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Application</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>ae82c835db45b3081faa7375b5a1c7073</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Application</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a7e72b49f60f7dcfafee4f38c67e79210</anchor>
      <arglist>(int argc, char **argv, AboutData const &amp;ad)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Application</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a8cafdbf60a11fa7ca6056dce78bc85a5</anchor>
      <arglist>(int argc, char **argv, AboutData const &amp;ad, po::options_description const &amp;od)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Application</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>ae82c835db45b3081faa7375b5a1c7073</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Application</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a7e72b49f60f7dcfafee4f38c67e79210</anchor>
      <arglist>(int argc, char **argv, AboutData const &amp;ad)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Application</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a8cafdbf60a11fa7ca6056dce78bc85a5</anchor>
      <arglist>(int argc, char **argv, AboutData const &amp;ad, po::options_description const &amp;od)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Application</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>ad68eaba6100123510f493c55955959dc</anchor>
      <arglist>(Application const &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Application</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>ae82c835db45b3081faa7375b5a1c7073</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName1</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a42c078b1087ead5efe6ecc856baaeed6</anchor>
      <arglist>(std::string const &amp;name1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName2</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a44e588250fe74e9abf7e115f4f8efacf</anchor>
      <arglist>(std::string const &amp;name2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setH</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>af8c03a27ce71ffa69d3829405f5eb23b</anchor>
      <arglist>(double h, int precision=4)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDimension</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a1ddd780ce8d1a26de1b9ce9bbb58c36b</anchor>
      <arglist>(int dim)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static mpi::communicator const &amp;</type>
      <name>comm</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>ad56c97478b62d268a5c5756e3a490938</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>barrier</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a22adbcbe84221352650fca6d59f89634</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>doOptions</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>ae8a93b3a1b08b3369b849fbe887bb808</anchor>
      <arglist>(int argc, char **argv)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>processGenericOptions</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a9b46d7543cd79c739e9963998c695443</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>parseAndStoreOptions</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>ad530d56cd570aedab483aaacb102de22</anchor>
      <arglist>(po::command_line_parser parser, bool extra_parser=false)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setLogs</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a81301038996c1dbeb1ac86dbbbe608c3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>po::options_description const &amp;</type>
      <name>optionsDescription</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a7ea7f307aaafa0a0bd666c1c5d43410b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>po::variables_map const &amp;</type>
      <name>vm</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a6d636004b73027e9dc226d7ec9e9d89c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>AboutData const &amp;</type>
      <name>about</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>ac559fca482047d68e7382ba720592758</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>unknownArgc</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a79e745539709940f7d58a6fdb1837bb2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>char **</type>
      <name>unknownArgv</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a63fd0cdffe5299845a4bf01800d6de2e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>uint16_type</type>
      <name>nProcess</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a4957bea4609c105a10d8345691459a0e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>uint16_type</type>
      <name>processId</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a076eb8b201ef120a5edcc948a78b16c5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isMPIInitialized</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a31a8b2dd7a1a10d4b9f8aefb7a5bfe72</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>rootRepository</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a4347d782a896ea17473d88c3500ac138</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>simget_iterator</type>
      <name>begin</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>aec60ec2e94b8fb0ad0110a56dd306c74</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>simget_iterator</type>
      <name>end</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a27a15d96e978f33f8d73d3d29d97a4c3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>nSimgets</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a758b341daa04445ba856780f9a4ba517</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>verbose</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a6833c0e8633dbe599c841978eb207e3b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isMPIInitialized</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a31a8b2dd7a1a10d4b9f8aefb7a5bfe72</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>initialized</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a7b653098a7bc205f06bc7dab38b953f1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>finalized</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a557a482f6bd88fb483cb9e6377229da0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>processorName</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a3a0577ea01072fc70017d24ee443ca88</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>initialized</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a7b653098a7bc205f06bc7dab38b953f1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>finalized</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a557a482f6bd88fb483cb9e6377229da0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>processorName</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a3a0577ea01072fc70017d24ee443ca88</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Application &amp;</type>
      <name>changeRepository</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>aeeeb89c0d1a125390b09101b1c6206e2</anchor>
      <arglist>(boost::format)</arglist>
    </member>
    <member kind="function">
      <type>mpi::communicator &amp;</type>
      <name>comm</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a69f7b268e137a2310c4b746e794c361d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>mpi::communicator const &amp;</type>
      <name>comm</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a5562d5466f28a54f638b28978ada7ff7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>barrier</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a66069d9fcb67b26127ec12fb2b7d23ea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a3a665c340ba4df177090b4d78c1d9ded</anchor>
      <arglist>(Simget *simget)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>run</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a0642acdfe3fdb86f2e6b4558c60af1de</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>run</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a67506b6f4f427f4bca3b82cc0cc2e64d</anchor>
      <arglist>(const double *X, unsigned long P, double *Y, unsigned long N)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printStats</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>ad8b89fe3ec56adc5aaf80d7f4fcad971</anchor>
      <arglist>(std::ostream &amp;out, std::vector&lt; std::string &gt; const &amp;keys) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>Send</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a44aee1d0298e866c9f8428f19d3b63f2</anchor>
      <arglist>(const T &amp;obj, int proc, int tag)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>Broadcast</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>af4f70b8ccd837fa2bd68caa1abe853b9</anchor>
      <arglist>(T &amp;obj)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>Recv</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>af74d4efe3580e831870f74e8d4141a4f</anchor>
      <arglist>(T &amp;obj, int proc, int tag)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>Broadcast</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a780f49148dc1f66e3edb834f3add1673</anchor>
      <arglist>(T &amp;, int=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>barrier</name>
      <anchorfile>classFeel_1_1Application.html</anchorfile>
      <anchor>a22adbcbe84221352650fca6d59f89634</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::ApplicationXML</name>
    <filename>classFeel_1_1ApplicationXML.html</filename>
    <base>Feel::Application</base>
    <member kind="function">
      <type></type>
      <name>ApplicationXML</name>
      <anchorfile>classFeel_1_1ApplicationXML.html</anchorfile>
      <anchor>a5e5654b5d69094003a96ef78e2f7d109</anchor>
      <arglist>(int argc, char **argv, AboutData const &amp;ad, po::options_description const &amp;od)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ApplicationXML</name>
      <anchorfile>classFeel_1_1ApplicationXML.html</anchorfile>
      <anchor>a65da0589a7703eb06111001e5357b05b</anchor>
      <arglist>(ApplicationXML const &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~ApplicationXML</name>
      <anchorfile>classFeel_1_1ApplicationXML.html</anchorfile>
      <anchor>aa0bf06c8d8f5a9e49a6025586d45ced4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ApplicationXML &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1ApplicationXML.html</anchorfile>
      <anchor>a4e2b6d974bb542e8bd7b657daf784058</anchor>
      <arglist>(ApplicationXML const &amp;o)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationXML &amp;</type>
      <name>addOutput</name>
      <anchorfile>classFeel_1_1ApplicationXML.html</anchorfile>
      <anchor>a35b64469ec8d53d5b795c194bf8bc23a</anchor>
      <arglist>(Output const &amp;o)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationXML &amp;</type>
      <name>addParameter</name>
      <anchorfile>classFeel_1_1ApplicationXML.html</anchorfile>
      <anchor>aeaf22acd2d20d8e5758ee8f2412a49c8</anchor>
      <arglist>(Parameter const &amp;o)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationXML &amp;</type>
      <name>addOutputValue</name>
      <anchorfile>classFeel_1_1ApplicationXML.html</anchorfile>
      <anchor>a8cd4ea4e9fb1758ec2c37fe8bf5f9124</anchor>
      <arglist>(T const &amp;val)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationXML &amp;</type>
      <name>addParameterValue</name>
      <anchorfile>classFeel_1_1ApplicationXML.html</anchorfile>
      <anchor>a2e1ca80c5713c0445a2f816bd726d8de</anchor>
      <arglist>(T const &amp;val)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual RunStatus</type>
      <name>preProcessing</name>
      <anchorfile>classFeel_1_1ApplicationXML.html</anchorfile>
      <anchor>a73ab40b2a8183772b3ef61d30e379dba</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>postProcessing</name>
      <anchorfile>classFeel_1_1ApplicationXML.html</anchorfile>
      <anchor>af53fd73c2848fdb09cd6be678fed94d4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::vector&lt; Parameter &gt;</type>
      <name>M_params</name>
      <anchorfile>classFeel_1_1ApplicationXML.html</anchorfile>
      <anchor>a983b7bca6fa436fd000ef9abac6011ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::vector&lt; Output &gt;</type>
      <name>M_outputs</name>
      <anchorfile>classFeel_1_1ApplicationXML.html</anchorfile>
      <anchor>a6f6d67a73ad46fa079e5c364d91a0dd0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::vector&lt; std::string &gt;</type>
      <name>M_parameter_values</name>
      <anchorfile>classFeel_1_1ApplicationXML.html</anchorfile>
      <anchor>a761010147debbe6490651101b48d5c47</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::vector&lt; std::string &gt;</type>
      <name>M_output_values</name>
      <anchorfile>classFeel_1_1ApplicationXML.html</anchorfile>
      <anchor>ad5737ff4630b9a1c7f4df9d34a7c846f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::has_value</name>
    <filename>structFeel_1_1has__value.html</filename>
    <templarg>Contextv</templarg>
    <templarg>Value</templarg>
    <member kind="variable" static="yes">
      <type>static const bool</type>
      <name>value</name>
      <anchorfile>structFeel_1_1has__value.html</anchorfile>
      <anchor>ad09fc806c8f4478232fccf14a26d79c1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::set_value</name>
    <filename>structFeel_1_1set__value.html</filename>
    <templarg>Contextv</templarg>
    <templarg>Value</templarg>
    <member kind="variable" static="yes">
      <type>static const bool</type>
      <name>value</name>
      <anchorfile>structFeel_1_1set__value.html</anchorfile>
      <anchor>a8e9b53bdf866e3aa2fd4917cce88a50e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::clear_value</name>
    <filename>structFeel_1_1clear__value.html</filename>
    <templarg>Contextv</templarg>
    <templarg>Value</templarg>
    <member kind="variable" static="yes">
      <type>static const bool</type>
      <name>value</name>
      <anchorfile>structFeel_1_1clear__value.html</anchorfile>
      <anchor>afc4c1ba80bee91ed3ba657aedc84634f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::Context</name>
    <filename>classFeel_1_1Context.html</filename>
    <member kind="function">
      <type></type>
      <name>Context</name>
      <anchorfile>classFeel_1_1Context.html</anchorfile>
      <anchor>a7448d091bfc1b6348ed75d7fd85e91f1</anchor>
      <arglist>(size_type c)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Context</name>
      <anchorfile>classFeel_1_1Context.html</anchorfile>
      <anchor>abe78cf44b25cb7d5115602f2be2a2f7e</anchor>
      <arglist>(Context const &amp;c)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Context</name>
      <anchorfile>classFeel_1_1Context.html</anchorfile>
      <anchor>a5000554c34e7d10db1b49057dbda49df</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Context &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1Context.html</anchorfile>
      <anchor>aebd2641fbb5e2f295a70d8d312eef8c4</anchor>
      <arglist>(Context const &amp;__c)</arglist>
    </member>
    <member kind="function">
      <type>Context &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1Context.html</anchorfile>
      <anchor>a7e418b504fad5abab44414e73f637576</anchor>
      <arglist>(size_type __c)</arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>operator()</name>
      <anchorfile>classFeel_1_1Context.html</anchorfile>
      <anchor>a0f47b8e10ab4b3a845ce8586723e927f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>context</name>
      <anchorfile>classFeel_1_1Context.html</anchorfile>
      <anchor>a14b4ca539305db80520d844aa4333c32</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setContext</name>
      <anchorfile>classFeel_1_1Context.html</anchorfile>
      <anchor>af28313ecda636da435a7d9226166761d</anchor>
      <arglist>(size_type __v)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>test</name>
      <anchorfile>classFeel_1_1Context.html</anchorfile>
      <anchor>ae48b7df4acacfbed70a4e61e7ab85f73</anchor>
      <arglist>(size_type b) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>test</name>
      <anchorfile>classFeel_1_1Context.html</anchorfile>
      <anchor>aa9b6693f363df208973fd21e55407e6c</anchor>
      <arglist>(T b) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classFeel_1_1Context.html</anchorfile>
      <anchor>ae0df383b969f53c19ad9085d59eaf43d</anchor>
      <arglist>(size_type b)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classFeel_1_1Context.html</anchorfile>
      <anchor>a55e680d60c7c1cbaab5c15d2ebf73d36</anchor>
      <arglist>(size_type b, bool v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classFeel_1_1Context.html</anchorfile>
      <anchor>ab5252c118125f06c65ae790977236cc9</anchor>
      <arglist>(size_type b)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>classFeel_1_1Context.html</anchorfile>
      <anchor>aec38156fdb0391e3c0d61795c6a70e2c</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::DebugStream</name>
    <filename>classFeel_1_1DebugStream.html</filename>
    <class kind="struct">Feel::DebugStream::Private</class>
    <member kind="typedef">
      <type>int(*</type>
      <name>stprintf</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>ad38e9c28a0878add1803b86c63ebd4ac</anchor>
      <arglist>)(const char *format,...)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFlush</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>a64e3af8a56ac6658b00dc36f4620aa99</anchor>
      <arglist>(stprintf=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DebugStream</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>a57cd6cc507a405bd1e32350697903e35</anchor>
      <arglist>(int area=0, int level=1, bool print=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DebugStream</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>a9010b6bfb6e9c75333ab254b67a2fc17</anchor>
      <arglist>(const char *initialString, int area=0, int level=1, bool print=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DebugStream</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>a04848a5b28a8a168cf008569ae28e091</anchor>
      <arglist>(DebugStream const &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~DebugStream</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>ad0cc60ada33072cbd4363a21e8712084</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>doPrint</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>a94def5b9253f9a51e723f4cd767b564f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>a55ce9c5aab0ae71f694a543bf85175d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>aefe938de7f0a05acf6ed33c72ed884ee</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>a4961d88ccbf9e0efab258a809b7ae10f</anchor>
      <arglist>(int16_type)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>a909915fc63ad18d0d214c063921ddda7</anchor>
      <arglist>(int32_type)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>a5cc8199837b53a1bcc733cc73c726259</anchor>
      <arglist>(uint16_type)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>aaa460c79933c19dd040ee0a80e2ac1c3</anchor>
      <arglist>(uint32_type)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>a2bcbe58e3a651b97575c264827d6df79</anchor>
      <arglist>(int64_type)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>ad75cfb0025b46b5c3f36dc2928018653</anchor>
      <arglist>(uint64_type)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>abb90bc4fb1dadb4987e24fe208d8d1c0</anchor>
      <arglist>(double)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>abeb0d7603972362c4aed3a173594a79f</anchor>
      <arglist>(std::complex&lt; double &gt;)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>a5218e980e38b2b1347e8c91a504369f2</anchor>
      <arglist>(const char *)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>af863a3ab31888bde6fee3dfe20f27933</anchor>
      <arglist>(std::string const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>a67278e12b514868ed717f6ad2c17ad18</anchor>
      <arglist>(LManipFunction f)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>addDebugArea</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>aa136755d58127a3ab15bb7646ed6cb3e</anchor>
      <arglist>(uint16_type area, std::string const &amp;description)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>showDebugAreas</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>a946e800a3865c9bd09657352ff93c03d</anchor>
      <arglist>(std::string const &amp;areas)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>attach</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>a0ed553265c60eb68e0d9056d407f7db5</anchor>
      <arglist>(std::string const &amp;__logfile)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>attach</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>a79a25ba7faeb4850ddef652729a444ee</anchor>
      <arglist>(std::string const &amp;__logfile, int area)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>detach</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>aca5fc03d256f359a158b1e4c7ebe0367</anchor>
      <arglist>(std::string const &amp;__logfile, int area)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>detachAll</name>
      <anchorfile>classFeel_1_1DebugStream.html</anchorfile>
      <anchor>acfedfd686fdcffdaffd466d489b84a53</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::DebugStream::Private</name>
    <filename>structFeel_1_1DebugStream_1_1Private.html</filename>
    <member kind="variable">
      <type>bool</type>
      <name>debug</name>
      <anchorfile>structFeel_1_1DebugStream_1_1Private.html</anchorfile>
      <anchor>ab79f37dad2760ef8a5622855ddb9fed6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>std::ostringstream</type>
      <name>_M_output</name>
      <anchorfile>structFeel_1_1DebugStream_1_1Private.html</anchorfile>
      <anchor>ad72fddd273f88081c79298ee2a4b77bd</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stprintf</type>
      <name>__flush_function</name>
      <anchorfile>structFeel_1_1DebugStream_1_1Private.html</anchorfile>
      <anchor>a8fc84a1cce232804737be4606ce0b3e9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static bool</type>
      <name>_S_attached</name>
      <anchorfile>structFeel_1_1DebugStream_1_1Private.html</anchorfile>
      <anchor>ac2b3509d1b05ec506fc58eafd65b5327</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static std::ofstream</type>
      <name>_S_logfile</name>
      <anchorfile>structFeel_1_1DebugStream_1_1Private.html</anchorfile>
      <anchor>a71d858c76713323e9d5273b05860d324</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::NdebugStream</name>
    <filename>classFeel_1_1NdebugStream.html</filename>
    <member kind="typedef">
      <type>int(*</type>
      <name>stprintf</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>a78fb3ff3e83825b27c3b20460781abc4</anchor>
      <arglist>)(const char *format,...)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>NdebugStream</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>a69718d803bf6be928cae064ddbc89266</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~NdebugStream</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>ad43ddb113609714280b26af3dbefe0e3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>aa5eac87a772d802f8e5409ce4df514fe</anchor>
      <arglist>(stprintf=0)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>a9f7a1b9afc9f95f39e824a91a6a6a2fb</anchor>
      <arglist>(char const *)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>a8f194fbaa4586dfeb8ecbde5225e7592</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>a9ce266bd79958bbf29b27a5ee72058a5</anchor>
      <arglist>(int16_type)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>a9b3a1a957da7d7c3e06a0c1965e42254</anchor>
      <arglist>(int32_type)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>a5286eaac934b7a8c73068a5058b78291</anchor>
      <arglist>(uint16_type)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>a878376c2222f0b9c8931d246484d651c</anchor>
      <arglist>(uint32_type)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>a567e159eda17c9e10b0b14ed50f3ea32</anchor>
      <arglist>(uint64_type)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>a666fbe054bd44770e747e9727297b301</anchor>
      <arglist>(int64_type)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>a0dd64f3972e69f57d15aed4dfbd6b3f4</anchor>
      <arglist>(double)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>a94d82e5efc044478af0dd11e5001bb32</anchor>
      <arglist>(std::complex&lt; double &gt;)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>a5329ef6cdef0797523ce6446b74e835f</anchor>
      <arglist>(std::string const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>NdebugStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>a625179b46bbeb10be92818108a743118</anchor>
      <arglist>(LManipFunction)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>attach</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>ae7058567db4c6712e38581f4dae9ade2</anchor>
      <arglist>(std::string const &amp;)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>attach</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>a51eea82bc45483969d0a3ca03bd793d6</anchor>
      <arglist>(std::string const &amp;, int)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>detach</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>a1a0639160d633664920fec9d3dfd72be</anchor>
      <arglist>(std::string const &amp;, int)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>detachAll</name>
      <anchorfile>classFeel_1_1NdebugStream.html</anchorfile>
      <anchor>acfec0dda831358bf5ca458895fd414fc</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::Environment</name>
    <filename>classFeel_1_1Environment.html</filename>
    <member kind="function">
      <type></type>
      <name>Environment</name>
      <anchorfile>classFeel_1_1Environment.html</anchorfile>
      <anchor>a2f72ceaafeecd718e9089c5d16322cfd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Environment</name>
      <anchorfile>classFeel_1_1Environment.html</anchorfile>
      <anchor>a5dd435d3b4d3664600a9555c750cee22</anchor>
      <arglist>(int &amp;argc, char **&amp;argv)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Environment</name>
      <anchorfile>classFeel_1_1Environment.html</anchorfile>
      <anchor>a04e74754187e7b5c2d0f1a3f9ea8723e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>initialized</name>
      <anchorfile>classFeel_1_1Environment.html</anchorfile>
      <anchor>acbfe687c47835d900969edacd9cd7a51</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>finalized</name>
      <anchorfile>classFeel_1_1Environment.html</anchorfile>
      <anchor>afd3a4ef2925b1469ddee0bf77d94c64d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>rootRepository</name>
      <anchorfile>classFeel_1_1Environment.html</anchorfile>
      <anchor>a300665c410736d9f6981e9455c28ed70</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>localGeoRepository</name>
      <anchorfile>classFeel_1_1Environment.html</anchorfile>
      <anchor>a924747a128671827d402879455f226c0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static boost::tuple&lt; std::string, bool &gt;</type>
      <name>systemGeoRepository</name>
      <anchorfile>classFeel_1_1Environment.html</anchorfile>
      <anchor>a54dac2208cb7895c32383349706387db</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>localConfigRepository</name>
      <anchorfile>classFeel_1_1Environment.html</anchorfile>
      <anchor>a2e717aba852ebe1e4eefd461a5ff3cb3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static boost::tuple&lt; std::string, bool &gt;</type>
      <name>systemConfigRepository</name>
      <anchorfile>classFeel_1_1Environment.html</anchorfile>
      <anchor>a97ff5d3a4250d986c030157eb8d7e5be</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>changeRepository</name>
      <anchorfile>classFeel_1_1Environment.html</anchorfile>
      <anchor>aacd803dcbce03ef0644fcb7b259c71e5</anchor>
      <arglist>(boost::format fmt, std::string const &amp;=&quot;logfile&quot;)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static po::variables_map</type>
      <name>vm</name>
      <anchorfile>classFeel_1_1Environment.html</anchorfile>
      <anchor>a8fec322bdaa81eadcbfe0444f9e7cd69</anchor>
      <arglist>(po::options_description const &amp;desc)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>setLogs</name>
      <anchorfile>classFeel_1_1Environment.html</anchorfile>
      <anchor>a8466d0b1433677e624082f9f6d13d818</anchor>
      <arglist>(std::string const &amp;prefix)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>addDeleteObserver</name>
      <anchorfile>classFeel_1_1Environment.html</anchorfile>
      <anchor>a65c0f336d8f4a7c1e5a2205116a98d27</anchor>
      <arglist>(Observer const &amp;obs)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::FactoryDefaultError</name>
    <filename>structFeel_1_1FactoryDefaultError.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <class kind="class">Feel::FactoryDefaultError::Exception</class>
    <member kind="function" static="yes">
      <type>static AbstractProduct *</type>
      <name>onUnknownType</name>
      <anchorfile>structFeel_1_1FactoryDefaultError.html</anchorfile>
      <anchor>aa5eb19e297cc4ebd8fd04cb3f52512bf</anchor>
      <arglist>(IdentifierType id)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::FactoryDefaultError::Exception</name>
    <filename>classFeel_1_1FactoryDefaultError_1_1Exception.html</filename>
    <member kind="function">
      <type></type>
      <name>Exception</name>
      <anchorfile>classFeel_1_1FactoryDefaultError_1_1Exception.html</anchorfile>
      <anchor>ab920de6a045a868d8e70403081f0d810</anchor>
      <arglist>(IdentifierType id)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>what</name>
      <anchorfile>classFeel_1_1FactoryDefaultError_1_1Exception.html</anchorfile>
      <anchor>a2eee441f4817e6dfe5f9019062844e04</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>getEx</name>
      <anchorfile>classFeel_1_1FactoryDefaultError_1_1Exception.html</anchorfile>
      <anchor>af05d5766d76c3e57bf94dfe2306dbc1e</anchor>
      <arglist>(std::string const &amp;id)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>getEx</name>
      <anchorfile>classFeel_1_1FactoryDefaultError_1_1Exception.html</anchorfile>
      <anchor>a62ee1244bd2e3d55e4d2f6d1d5215438</anchor>
      <arglist>(T const &amp;id)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::Factory</name>
    <filename>classFeel_1_1Factory.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <templarg>FactoryErrorPolicy</templarg>
    <member kind="typedef">
      <type>IdentifierType</type>
      <name>identifier_type</name>
      <anchorfile>classFeel_1_1Factory.html</anchorfile>
      <anchor>a62bb8934ccca690b24966376968d6851</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>AbstractProduct</type>
      <name>product_type</name>
      <anchorfile>classFeel_1_1Factory.html</anchorfile>
      <anchor>a3b1da7a97c59a797ead8d354b740011d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ProductCreator</type>
      <name>creator_type</name>
      <anchorfile>classFeel_1_1Factory.html</anchorfile>
      <anchor>a6c46efa183a04c58766ca0dc1b3f8b45</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>FactoryErrorPolicy&lt; identifier_type, product_type &gt;</type>
      <name>super</name>
      <anchorfile>classFeel_1_1Factory.html</anchorfile>
      <anchor>aafc3babbcee83dff3b49b5a01c6be1ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>registerProduct</name>
      <anchorfile>classFeel_1_1Factory.html</anchorfile>
      <anchor>adf3e133a95311d2776f1c1c8a9d1119a</anchor>
      <arglist>(const identifier_type &amp;id, creator_type creator)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>unregisterProduct</name>
      <anchorfile>classFeel_1_1Factory.html</anchorfile>
      <anchor>aa19ab8b052114ca1d7e5dd74e7bda1da</anchor>
      <arglist>(const identifier_type &amp;id)</arglist>
    </member>
    <member kind="function">
      <type>product_type *</type>
      <name>createObject</name>
      <anchorfile>classFeel_1_1Factory.html</anchorfile>
      <anchor>ab17985f70668b188cd3b9e2f2c47dedc</anchor>
      <arglist>(const identifier_type &amp;id)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::FactoryClone</name>
    <filename>classFeel_1_1FactoryClone.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg>FactoryErrorPolicy</templarg>
    <member kind="typedef">
      <type>FactoryErrorPolicy&lt; TypeInfo, AbstractProduct &gt;</type>
      <name>super</name>
      <anchorfile>classFeel_1_1FactoryClone.html</anchorfile>
      <anchor>acd5e881f546652f4d82c379ad01c07d2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>registerProduct</name>
      <anchorfile>classFeel_1_1FactoryClone.html</anchorfile>
      <anchor>a0b5d69e055705d94f21a812e2c462d5d</anchor>
      <arglist>(const TypeInfo &amp;id, ProductCreator creator)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>unregisterProduct</name>
      <anchorfile>classFeel_1_1FactoryClone.html</anchorfile>
      <anchor>a14c51a6aa182b6fa1c27854ec79e56fc</anchor>
      <arglist>(const TypeInfo &amp;id)</arglist>
    </member>
    <member kind="function">
      <type>AbstractProduct *</type>
      <name>createObject</name>
      <anchorfile>classFeel_1_1FactoryClone.html</anchorfile>
      <anchor>a17ad719b0d3bbd2a1f070d780cf2de97</anchor>
      <arglist>(const AbstractProduct *model)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::Info</name>
    <filename>classFeel_1_1Info.html</filename>
    <member kind="function" static="yes">
      <type>static unsigned long long</type>
      <name>buildId</name>
      <anchorfile>classFeel_1_1Info.html</anchorfile>
      <anchor>a4f3af81144c54f620c60ec401c524684</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static unsigned long long</type>
      <name>revision</name>
      <anchorfile>classFeel_1_1Info.html</anchorfile>
      <anchor>aec4efc212c892af17d3bf98bfc81754e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static unsigned long long</type>
      <name>version</name>
      <anchorfile>classFeel_1_1Info.html</anchorfile>
      <anchor>a6832b110190ad53c75958c93955f1afa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static unsigned int</type>
      <name>versionMajor</name>
      <anchorfile>classFeel_1_1Info.html</anchorfile>
      <anchor>aeb0909ebb7f3687714d789fc9ca9e0c4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static unsigned int</type>
      <name>versionMinor</name>
      <anchorfile>classFeel_1_1Info.html</anchorfile>
      <anchor>a52fe772e71b6221c9e0c0a437530ca83</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static unsigned int</type>
      <name>versionMicro</name>
      <anchorfile>classFeel_1_1Info.html</anchorfile>
      <anchor>afb595918950a1f563c36c1a738254068</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static char const *</type>
      <name>versionString</name>
      <anchorfile>classFeel_1_1Info.html</anchorfile>
      <anchor>a9772bb266dc7b45f1bd0074dd4aad0c7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static char const *</type>
      <name>prefix</name>
      <anchorfile>classFeel_1_1Info.html</anchorfile>
      <anchor>ae0c3a22c420cbbc1da737becc3588277</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static char const *</type>
      <name>datadir</name>
      <anchorfile>classFeel_1_1Info.html</anchorfile>
      <anchor>ae6c178ec8060d1355167c157acccfec0</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::PolicyCreationUsingNew</name>
    <filename>structFeel_1_1PolicyCreationUsingNew.html</filename>
    <templarg></templarg>
    <member kind="function" static="yes">
      <type>static T *</type>
      <name>create</name>
      <anchorfile>structFeel_1_1PolicyCreationUsingNew.html</anchorfile>
      <anchor>af0dcef9f263a1939bc9c4f688b0b678e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>destroy</name>
      <anchorfile>structFeel_1_1PolicyCreationUsingNew.html</anchorfile>
      <anchor>a14dfe49c94895e58b838107b155d4771</anchor>
      <arglist>(T *p)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::PolicyFeelTimeDefault</name>
    <filename>structFeel_1_1PolicyFeelTimeDefault.html</filename>
    <templarg></templarg>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>scheduleDestruction</name>
      <anchorfile>structFeel_1_1PolicyFeelTimeDefault.html</anchorfile>
      <anchor>ad38fbf2ca3107091fec2f20d7c0b9cc1</anchor>
      <arglist>(T *, void(*pFun)())</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>onDeadReference</name>
      <anchorfile>structFeel_1_1PolicyFeelTimeDefault.html</anchorfile>
      <anchor>ab91b704c091b18d89bfbd20e94e3004b</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::Simget</name>
    <filename>classFeel_1_1Simget.html</filename>
    <member kind="function">
      <type></type>
      <name>Simget</name>
      <anchorfile>classFeel_1_1Simget.html</anchorfile>
      <anchor>a5e724b4a5ab88e9d2c931a7223d02cb2</anchor>
      <arglist>(po::variables_map const &amp;_vm)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Simget</name>
      <anchorfile>classFeel_1_1Simget.html</anchorfile>
      <anchor>a4f9e4a0c03ba7c890768bf7a68364c75</anchor>
      <arglist>(AboutData const &amp;_about)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Simget</name>
      <anchorfile>classFeel_1_1Simget.html</anchorfile>
      <anchor>a558426bfe9fe13fc23f2da8069c5b22d</anchor>
      <arglist>(po::variables_map const &amp;_vm, AboutData const &amp;_about)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Simget</name>
      <anchorfile>classFeel_1_1Simget.html</anchorfile>
      <anchor>a91bb6e6656eb7a3319bceab22380d60b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Simget &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1Simget.html</anchorfile>
      <anchor>a0ca236a46ce6f367fc2dd43dd8f28b1f</anchor>
      <arglist>(Simget const &amp;o)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual std::string</type>
      <name>name</name>
      <anchorfile>classFeel_1_1Simget.html</anchorfile>
      <anchor>af253c82f9e803fd38ee16d18a6ca6337</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>mpi::communicator</type>
      <name>comm</name>
      <anchorfile>classFeel_1_1Simget.html</anchorfile>
      <anchor>af0e7aa3d182d01b4330fa9fe439979af</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>po::variables_map const &amp;</type>
      <name>vm</name>
      <anchorfile>classFeel_1_1Simget.html</anchorfile>
      <anchor>a2778e828ee4c102e72a33e03b1ede4b1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>AboutData const &amp;</type>
      <name>about</name>
      <anchorfile>classFeel_1_1Simget.html</anchorfile>
      <anchor>a842d077007302c803e3b18897c42f8e6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>meshSize</name>
      <anchorfile>classFeel_1_1Simget.html</anchorfile>
      <anchor>a650dd47e8e42f51f68d87b29d0632a1d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ptree::ptree const &amp;</type>
      <name>stats</name>
      <anchorfile>classFeel_1_1Simget.html</anchorfile>
      <anchor>ad4fb02078725447e79db657f91f9fc51</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMeshSize</name>
      <anchorfile>classFeel_1_1Simget.html</anchorfile>
      <anchor>afb1305c58e7833292c6b3eb042afd1e9</anchor>
      <arglist>(double h)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>run</name>
      <anchorfile>classFeel_1_1Simget.html</anchorfile>
      <anchor>ae4cebdea070b7aadc9cb5ada1969e5a9</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>run</name>
      <anchorfile>classFeel_1_1Simget.html</anchorfile>
      <anchor>a03f9552a78bba60eba04abe8a6c04f6c</anchor>
      <arglist>(const double *X, unsigned long P, double *Y, unsigned long N)=0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classFeel_1_1Simget.html</anchorfile>
      <anchor>a1a6d21e08e62ec9908e5580fe6bf6a24</anchor>
      <arglist>(std::ostream &amp;out, std::vector&lt; ptree::ptree &gt; &amp;stats)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>Simget &amp;</type>
      <name>changeRepository</name>
      <anchorfile>classFeel_1_1Simget.html</anchorfile>
      <anchor>afcd4ac23a947d7238110967ee57f00dd</anchor>
      <arglist>(boost::format fmt)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>double</type>
      <name>M_meshSize</name>
      <anchorfile>classFeel_1_1Simget.html</anchorfile>
      <anchor>a68c2b10b130558044fa84bc1e8f69b8e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ptree::ptree</type>
      <name>M_stats</name>
      <anchorfile>classFeel_1_1Simget.html</anchorfile>
      <anchor>a12cc8834f5a9cf3d94bdb72bc98bab06</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Application</name>
      <anchorfile>classFeel_1_1Simget.html</anchorfile>
      <anchor>a23f25bcc02a0e94c2f5a4188496b04d0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::Singleton</name>
    <filename>classFeel_1_1Singleton.html</filename>
    <templarg>T</templarg>
    <member kind="typedef">
      <type>T</type>
      <name>singleton_type</name>
      <anchorfile>classFeel_1_1Singleton.html</anchorfile>
      <anchor>a7a70bea80a40a08861c4ac50192ea7cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PolicyFeelTimeDefault&lt; singleton_type &gt;</type>
      <name>feeltime_policy</name>
      <anchorfile>classFeel_1_1Singleton.html</anchorfile>
      <anchor>a8e3feacafb170b8688a46e433c0b4b4b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PolicyCreationUsingNew&lt; singleton_type &gt;</type>
      <name>creation_policy</name>
      <anchorfile>classFeel_1_1Singleton.html</anchorfile>
      <anchor>af6dcc14dfa0091a993ee69f03bdad118</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static singleton_type &amp;</type>
      <name>instance</name>
      <anchorfile>classFeel_1_1Singleton.html</anchorfile>
      <anchor>a1d3a68a11d8143582273ca02114a140b</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::AssertContext</name>
    <filename>classFeel_1_1AssertContext.html</filename>
    <member kind="typedef">
      <type>std::pair&lt; string, string &gt;</type>
      <name>val_and_str</name>
      <anchorfile>classFeel_1_1AssertContext.html</anchorfile>
      <anchor>a879b35a3e60649c8e11ede5beac78e6a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; val_and_str &gt;</type>
      <name>vals_array</name>
      <anchorfile>classFeel_1_1AssertContext.html</anchorfile>
      <anchor>afa76c7d8c8f5bf7561054165d78c53a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFileLine</name>
      <anchorfile>classFeel_1_1AssertContext.html</anchorfile>
      <anchor>aa619887bf2de59524cc73707d210cdcf</anchor>
      <arglist>(const char *file, int line)</arglist>
    </member>
    <member kind="function">
      <type>const string &amp;</type>
      <name>getContextFile</name>
      <anchorfile>classFeel_1_1AssertContext.html</anchorfile>
      <anchor>a60ebf94286174f185920f44b3c906f15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getContextLine</name>
      <anchorfile>classFeel_1_1AssertContext.html</anchorfile>
      <anchor>a4ea55e35a19fcf3f337aa67223ce0320</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setExpression</name>
      <anchorfile>classFeel_1_1AssertContext.html</anchorfile>
      <anchor>a8e0f8c8ff2f34cb380fb7483dedee2b4</anchor>
      <arglist>(const string &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>const string &amp;</type>
      <name>expression</name>
      <anchorfile>classFeel_1_1AssertContext.html</anchorfile>
      <anchor>a97e74fc6dcaa185fb43c819115896975</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const vals_array &amp;</type>
      <name>get_vals_array</name>
      <anchorfile>classFeel_1_1AssertContext.html</anchorfile>
      <anchor>a86620406416bb0c4e2c7547c22cdde34</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_val</name>
      <anchorfile>classFeel_1_1AssertContext.html</anchorfile>
      <anchor>ae709d9b60e7674be37a7c40ff653d8ae</anchor>
      <arglist>(const string &amp;val, const string &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLevel</name>
      <anchorfile>classFeel_1_1AssertContext.html</anchorfile>
      <anchor>ab1112d7ffec81e27f8f5db1f7d911fb1</anchor>
      <arglist>(int nLevel)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_level</name>
      <anchorfile>classFeel_1_1AssertContext.html</anchorfile>
      <anchor>af26c22df5e2b13fdc95d0b2fcb08570d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLevelMsg</name>
      <anchorfile>classFeel_1_1AssertContext.html</anchorfile>
      <anchor>a4789d10467d7f47f11d71a6dfa00f780</anchor>
      <arglist>(const char *strMsg)</arglist>
    </member>
    <member kind="function">
      <type>const string &amp;</type>
      <name>get_level_msg</name>
      <anchorfile>classFeel_1_1AssertContext.html</anchorfile>
      <anchor>a1d2c5ca741839e2921d7ef371270727b</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::Assert</name>
    <filename>structFeel_1_1Assert.html</filename>
    <member kind="typedef">
      <type>SmartAssert::assert_function_type</type>
      <name>assert_function_type</name>
      <anchorfile>structFeel_1_1Assert.html</anchorfile>
      <anchor>aaff9e146e9b55de7a4c43682e0564a35</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Assert</name>
      <anchorfile>structFeel_1_1Assert.html</anchorfile>
      <anchor>af5cbfd7f335aaa78276076e3c5e2b795</anchor>
      <arglist>(const char *expr)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Assert</name>
      <anchorfile>structFeel_1_1Assert.html</anchorfile>
      <anchor>a706945ef05e89110a090b061599b29af</anchor>
      <arglist>(const Assert &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Assert &amp;</type>
      <name>printCurrentValue</name>
      <anchorfile>structFeel_1_1Assert.html</anchorfile>
      <anchor>a369af714604010653f13587ff329f11d</anchor>
      <arglist>(const type &amp;val, const char *msg)</arglist>
    </member>
    <member kind="function">
      <type>Assert &amp;</type>
      <name>printContext</name>
      <anchorfile>structFeel_1_1Assert.html</anchorfile>
      <anchor>a804209987cd32f49d7f12f655de307f6</anchor>
      <arglist>(const char *file, int line)</arglist>
    </member>
    <member kind="function">
      <type>Assert &amp;</type>
      <name>msg</name>
      <anchorfile>structFeel_1_1Assert.html</anchorfile>
      <anchor>afcdbe2cf9809d7c98f79935aaad8335f</anchor>
      <arglist>(const char *strMsg)</arglist>
    </member>
    <member kind="function">
      <type>Assert &amp;</type>
      <name>level</name>
      <anchorfile>structFeel_1_1Assert.html</anchorfile>
      <anchor>a52ffb9da31d009fee848eb28f10b75a1</anchor>
      <arglist>(int nLevel, const char *strMsg=0)</arglist>
    </member>
    <member kind="function">
      <type>Assert &amp;</type>
      <name>warn</name>
      <anchorfile>structFeel_1_1Assert.html</anchorfile>
      <anchor>a913ad591a33fb8a50d491529b3356c21</anchor>
      <arglist>(const char *strMsg=0)</arglist>
    </member>
    <member kind="function">
      <type>Assert &amp;</type>
      <name>debug</name>
      <anchorfile>structFeel_1_1Assert.html</anchorfile>
      <anchor>afb7436ddcc96ea9e291dd0198eb61474</anchor>
      <arglist>(const char *strMsg=0)</arglist>
    </member>
    <member kind="function">
      <type>Assert &amp;</type>
      <name>error</name>
      <anchorfile>structFeel_1_1Assert.html</anchorfile>
      <anchor>a324c52120e772d84aceda12cb011e282</anchor>
      <arglist>(const char *strMsg=0)</arglist>
    </member>
    <member kind="function">
      <type>Assert &amp;</type>
      <name>fatal</name>
      <anchorfile>structFeel_1_1Assert.html</anchorfile>
      <anchor>afbb021dab8663d50f59be20f782943de</anchor>
      <arglist>(const char *strMsg=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>setLog</name>
      <anchorfile>structFeel_1_1Assert.html</anchorfile>
      <anchor>a7e7b6a3d9f45fb7a18e274bd47d3b114</anchor>
      <arglist>(const char *strFileName)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>setLog</name>
      <anchorfile>structFeel_1_1Assert.html</anchorfile>
      <anchor>a31aa195c6aeaed7abaf18c2f6c6fd462</anchor>
      <arglist>(std::ostream &amp;out)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>setLog</name>
      <anchorfile>structFeel_1_1Assert.html</anchorfile>
      <anchor>a6c644781131ee0174e4ada40a2c8cc6c</anchor>
      <arglist>(assert_function_type log)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>setHandler</name>
      <anchorfile>structFeel_1_1Assert.html</anchorfile>
      <anchor>aae3453296b44e4df165407980c069a74</anchor>
      <arglist>(int nLevel, assert_function_type handler)</arglist>
    </member>
    <member kind="variable">
      <type>Assert &amp;</type>
      <name>SMART_ASSERT_A</name>
      <anchorfile>structFeel_1_1Assert.html</anchorfile>
      <anchor>a4a2b67010f2b2b6fe6f8c052c213f248</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Assert &amp;</type>
      <name>SMART_ASSERT_B</name>
      <anchorfile>structFeel_1_1Assert.html</anchorfile>
      <anchor>a10a6fbe140a883b75fc8003e5de2ba1d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::TimerPair</name>
    <filename>structFeel_1_1TimerPair.html</filename>
    <member kind="function">
      <type>double</type>
      <name>elapsed</name>
      <anchorfile>structFeel_1_1TimerPair.html</anchorfile>
      <anchor>a7b43f33bd0b2d02406b609bae5396442</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>accumulate</name>
      <anchorfile>structFeel_1_1TimerPair.html</anchorfile>
      <anchor>a9e0ebb918a2fda1cf0cd72a1976feb61</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>restart</name>
      <anchorfile>structFeel_1_1TimerPair.html</anchorfile>
      <anchor>a585afc85e9c48c76a53cc43cd17a0b49</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>structFeel_1_1TimerPair.html</anchorfile>
      <anchor>a0fbe43d7ad98bd74d495b3f853313d2a</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::TimerMap</name>
    <filename>classFeel_1_1TimerMap.html</filename>
    <member kind="typedef">
      <type>super::iterator</type>
      <name>iterator</name>
      <anchorfile>classFeel_1_1TimerMap.html</anchorfile>
      <anchor>ab5e819946e9272fba4e02216d13cb6ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::const_iterator</type>
      <name>const_iterator</name>
      <anchorfile>classFeel_1_1TimerMap.html</anchorfile>
      <anchor>adf9807e2d6ff7034c6829b9369cf36a2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TimerMap</name>
      <anchorfile>classFeel_1_1TimerMap.html</anchorfile>
      <anchor>a00e90e2142903d9cb8c66a3ab4c9101a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TimerMap</name>
      <anchorfile>classFeel_1_1TimerMap.html</anchorfile>
      <anchor>a12ffccd43b333287a3ece66e39b06d53</anchor>
      <arglist>(TimerMap const &amp;tm)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~TimerMap</name>
      <anchorfile>classFeel_1_1TimerMap.html</anchorfile>
      <anchor>a8aaddd24ff48202d0bb54edcae006a1c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>report</name>
      <anchorfile>classFeel_1_1TimerMap.html</anchorfile>
      <anchor>a9b1a72cf1771310737c97ae8eb14fbbd</anchor>
      <arglist>(PrefixType const &amp;prefix)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::strongest_numeric_type</name>
    <filename>structFeel_1_1strongest__numeric__type.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>mpl::vector&lt; T1, T2, T3, T4, T5 &gt;</type>
      <name>types</name>
      <anchorfile>structFeel_1_1strongest__numeric__type.html</anchorfile>
      <anchor>ae1709c00a1c689d8e811cd9631c7c0a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mpl::max_element&lt; mpl::transform_view&lt; types, mpl::sizeof_&lt; mpl::_1 &gt; &gt; &gt;::type</type>
      <name>iter</name>
      <anchorfile>structFeel_1_1strongest__numeric__type.html</anchorfile>
      <anchor>a483c1ad380cb25a6310b0cab495adda1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mpl::deref&lt; typename iter::base &gt;::type</type>
      <name>type</name>
      <anchorfile>structFeel_1_1strongest__numeric__type.html</anchorfile>
      <anchor>a2ce36e5a91e7998804c69e30c028d314</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::strongest_numeric_type&lt; T1, std::complex&lt; T2 &gt; &gt;</name>
    <filename>structFeel_1_1strongest__numeric__type_3_01T1_00_01std_1_1complex_3_01T2_01_4_01_4.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>type_traits&lt; T1 &gt;::real_type</type>
      <name>R1</name>
      <anchorfile>structFeel_1_1strongest__numeric__type_3_01T1_00_01std_1_1complex_3_01T2_01_4_01_4.html</anchorfile>
      <anchor>a36d2f3d24e2af0d1d3f808909fbec786</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::complex&lt; typename strongest_numeric_type&lt; R1, T2 &gt;::type &gt;</type>
      <name>type</name>
      <anchorfile>structFeel_1_1strongest__numeric__type_3_01T1_00_01std_1_1complex_3_01T2_01_4_01_4.html</anchorfile>
      <anchor>aa1e09193502379eb7dd1fd3d24313c44</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::strongest_numeric_type&lt; std::complex&lt; T1 &gt;, T2 &gt;</name>
    <filename>structFeel_1_1strongest__numeric__type_3_01std_1_1complex_3_01T1_01_4_00_01T2_01_4.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>type_traits&lt; T2 &gt;::real_type</type>
      <name>R2</name>
      <anchorfile>structFeel_1_1strongest__numeric__type_3_01std_1_1complex_3_01T1_01_4_00_01T2_01_4.html</anchorfile>
      <anchor>a674d1a5d3485d7713e8a1ba1aa814113</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::complex&lt; typename strongest_numeric_type&lt; T1, R2 &gt;::type &gt;</type>
      <name>type</name>
      <anchorfile>structFeel_1_1strongest__numeric__type_3_01std_1_1complex_3_01T1_01_4_00_01T2_01_4.html</anchorfile>
      <anchor>ac0ed92f15fe8f90070dc3fc52060e31a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::strongest_numeric_type&lt; std::complex&lt; T1 &gt;, std::complex&lt; T2 &gt; &gt;</name>
    <filename>structFeel_1_1strongest__numeric__type_3_01std_1_1complex_3_01T1_01_4_00_01std_1_1complex_3_01T2_01_4_01_4.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>std::complex&lt; typename strongest_numeric_type&lt; T1, T2 &gt;::type &gt;</type>
      <name>type</name>
      <anchorfile>structFeel_1_1strongest__numeric__type_3_01std_1_1complex_3_01T1_01_4_00_01std_1_1complex_3_01T2_01_4_01_4.html</anchorfile>
      <anchor>afcb3de5b4771d92573ca0253e79a0351</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::is_shared_ptr</name>
    <filename>structFeel_1_1is__shared__ptr.html</filename>
    <templarg></templarg>
  </compound>
  <compound kind="struct">
    <name>Feel::is_shared_ptr&lt; boost::shared_ptr&lt; T &gt; &gt;</name>
    <filename>structFeel_1_1is__shared__ptr_3_01boost_1_1shared__ptr_3_01T_01_4_01_4.html</filename>
    <templarg></templarg>
  </compound>
  <compound kind="struct">
    <name>Feel::remove_shared_ptr</name>
    <filename>structFeel_1_1remove__shared__ptr.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>T</type>
      <name>type</name>
      <anchorfile>structFeel_1_1remove__shared__ptr.html</anchorfile>
      <anchor>a2c2bf8fa537fed7b8daf1396fc9a40ed</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::remove_shared_ptr&lt; boost::shared_ptr&lt; T &gt; &gt;</name>
    <filename>structFeel_1_1remove__shared__ptr_3_01boost_1_1shared__ptr_3_01T_01_4_01_4.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>T</type>
      <name>type</name>
      <anchorfile>structFeel_1_1remove__shared__ptr_3_01boost_1_1shared__ptr_3_01T_01_4_01_4.html</anchorfile>
      <anchor>abc570058f2d51fa293ad611c901f1ac0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::TypeInfo</name>
    <filename>classFeel_1_1TypeInfo.html</filename>
    <member kind="function">
      <type></type>
      <name>TypeInfo</name>
      <anchorfile>classFeel_1_1TypeInfo.html</anchorfile>
      <anchor>a819e3629b0df33fa4ef8ea5fa191c96d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TypeInfo</name>
      <anchorfile>classFeel_1_1TypeInfo.html</anchorfile>
      <anchor>a2cef14fc25031178878b0ff2779aca52</anchor>
      <arglist>(const std::type_info &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TypeInfo</name>
      <anchorfile>classFeel_1_1TypeInfo.html</anchorfile>
      <anchor>ab1ea3c451a01a462c8c2ffaa3caf7f99</anchor>
      <arglist>(TypeInfo const &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~TypeInfo</name>
      <anchorfile>classFeel_1_1TypeInfo.html</anchorfile>
      <anchor>aebea668264f4112ff3d0d49e84bddcd9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const std::type_info &amp;</type>
      <name>typeInfo</name>
      <anchorfile>classFeel_1_1TypeInfo.html</anchorfile>
      <anchor>aa97e4aeb3d0ea311834d598e63cc93c9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>name</name>
      <anchorfile>classFeel_1_1TypeInfo.html</anchorfile>
      <anchor>ad4fa83dca0bb3ba3cb72bedcefcbdf77</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>before</name>
      <anchorfile>classFeel_1_1TypeInfo.html</anchorfile>
      <anchor>abd3d09d3b35ef984805ef27509f59fba</anchor>
      <arglist>(const TypeInfo &amp;rhs) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::type_traits</name>
    <filename>structFeel_1_1type__traits.html</filename>
    <templarg></templarg>
  </compound>
  <compound kind="class">
    <name>Feel::VisitorBase</name>
    <filename>classFeel_1_1VisitorBase.html</filename>
  </compound>
  <compound kind="class">
    <name>Feel::Visitor</name>
    <filename>classFeel_1_1Visitor.html</filename>
    <templarg>T</templarg>
    <templarg>R</templarg>
    <member kind="typedef">
      <type>R</type>
      <name>return_type</name>
      <anchorfile>classFeel_1_1Visitor.html</anchorfile>
      <anchor>a36886df30ba0d193d8e72a7b87d058ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Visitor</name>
      <anchorfile>classFeel_1_1Visitor.html</anchorfile>
      <anchor>a34a1ad80d7c090348db52bbe3dabf7d2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual return_type</type>
      <name>visit</name>
      <anchorfile>classFeel_1_1Visitor.html</anchorfile>
      <anchor>a98acadae64f9daa013409b11fd6db989</anchor>
      <arglist>(T *)=0</arglist>
    </member>
    <member kind="function">
      <type>return_type</type>
      <name>visit</name>
      <anchorfile>classFeel_1_1Visitor.html</anchorfile>
      <anchor>ac9a87608ccb0c1179d81b8cf01a4866d</anchor>
      <arglist>(T &amp;__t)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::VisitorList</name>
    <filename>classFeel_1_1VisitorList.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <base>Visitor&lt; mpl::front&lt; TList &gt;::type, R &gt;</base>
    <base>boost::mpl::if_::type::type</base>
  </compound>
  <compound kind="class">
    <name>Feel::VisitorBaseImpl&lt; mpl::list&lt; Head, Tail &gt;, R &gt;</name>
    <filename>classFeel_1_1VisitorBaseImpl_3_01mpl_1_1list_3_01Head_00_01Tail_01_4_00_01R_01_4.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <base>Visitor&lt; Head, R &gt;</base>
    <base>VisitorBaseImpl&lt; Tail, R &gt;</base>
    <member kind="function" virtualness="virtual">
      <type>virtual R</type>
      <name>visit</name>
      <anchorfile>classFeel_1_1VisitorBaseImpl_3_01mpl_1_1list_3_01Head_00_01Tail_01_4_00_01R_01_4.html</anchorfile>
      <anchor>a5b987068575ecfb31007f9fc24e12afd</anchor>
      <arglist>(Head *)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::VisitorBaseImpl&lt; mpl::list&lt; Head &gt;, R &gt;</name>
    <filename>classFeel_1_1VisitorBaseImpl_3_01mpl_1_1list_3_01Head_01_4_00_01R_01_4.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <base>Visitor&lt; Head, R &gt;</base>
    <member kind="function" virtualness="virtual">
      <type>virtual R</type>
      <name>visit</name>
      <anchorfile>classFeel_1_1VisitorBaseImpl_3_01mpl_1_1list_3_01Head_01_4_00_01R_01_4.html</anchorfile>
      <anchor>a0102d0e416e4e1234a343d6e0f304e12</anchor>
      <arglist>(Head *)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::VisitableCatchAllDefault</name>
    <filename>structFeel_1_1VisitableCatchAllDefault.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="function" static="yes">
      <type>static R</type>
      <name>onUnknownVisitor</name>
      <anchorfile>structFeel_1_1VisitableCatchAllDefault.html</anchorfile>
      <anchor>aec6f0c14eebac3083c58bbf55e3f08b1</anchor>
      <arglist>(Visited &amp;, VisitorBase &amp;)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static R</type>
      <name>onUnknownVisitor</name>
      <anchorfile>structFeel_1_1VisitableCatchAllDefault.html</anchorfile>
      <anchor>abe053d3e25f39cc5dffcee7c6ce9e3ce</anchor>
      <arglist>(Visited *, VisitorBase *)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::VisitableBase</name>
    <filename>classFeel_1_1VisitableBase.html</filename>
    <templarg>R</templarg>
    <templarg>CatchAll</templarg>
    <member kind="typedef">
      <type>R</type>
      <name>return_type</name>
      <anchorfile>classFeel_1_1VisitableBase.html</anchorfile>
      <anchor>a9b0a20152288f8a548afbadb2e3331c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual return_type</type>
      <name>accept</name>
      <anchorfile>classFeel_1_1VisitableBase.html</anchorfile>
      <anchor>ac7b07f2867755cbada340cfc2043790b</anchor>
      <arglist>(VisitorBase &amp;)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual return_type</type>
      <name>accept</name>
      <anchorfile>classFeel_1_1VisitableBase.html</anchorfile>
      <anchor>ac52d2427c7efab2bcab31d7e5d63171e</anchor>
      <arglist>(VisitorBase *)=0</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static return_type</type>
      <name>acceptImpl</name>
      <anchorfile>classFeel_1_1VisitableBase.html</anchorfile>
      <anchor>a3c4ac7ee3fa9b1ef11cd1e075cb38e49</anchor>
      <arglist>(T *visited, VisitorBase *guest)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::VisitorCyclic</name>
    <filename>classFeel_1_1VisitorCyclic.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <base>Visitor&lt; TList, R &gt;</base>
    <member kind="typedef">
      <type>R</type>
      <name>return_type</name>
      <anchorfile>classFeel_1_1VisitorCyclic.html</anchorfile>
      <anchor>a762259e82251f5d18ef00b0089d0666d</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>return_type</type>
      <name>genericVisit</name>
      <anchorfile>classFeel_1_1VisitorCyclic.html</anchorfile>
      <anchor>ae0a0bb255dd3c91c3ec816ce07c7ad5c</anchor>
      <arglist>(Visited *host)</arglist>
    </member>
    <member kind="function">
      <type>return_type</type>
      <name>genericVisit</name>
      <anchorfile>classFeel_1_1VisitorCyclic.html</anchorfile>
      <anchor>ad5b37fe5b6bb809f57c333825f8ee229</anchor>
      <arglist>(Visited &amp;host)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::WorldComm</name>
    <filename>classFeel_1_1WorldComm.html</filename>
    <member kind="typedef">
      <type>WorldComm</type>
      <name>self_type</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>adb513020a43d11dfca57d8bcb4883956</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::mpi::communicator</type>
      <name>communicator_type</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>aa79784801c64f4733ffa9b219bcb2637</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>WorldComm</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>aee58710d8c993dd3d6797e60b28593cf</anchor>
      <arglist>(int _color)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>WorldComm</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a3d4df2d2d1098f8039f89c5688667b1b</anchor>
      <arglist>(std::vector&lt; int &gt; const &amp;_colorWorld)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>WorldComm</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a7536db34bb5414654e42434a226c939f</anchor>
      <arglist>(std::vector&lt; int &gt; const &amp;_colorWorld, int localRank, communicator_type const &amp;_globalComm=communicator_type(), communicator_type const &amp;_godComm=communicator_type())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>WorldComm</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>ac7e39ca4171192b0ada26c8728b3e111</anchor>
      <arglist>(WorldComm const &amp;_wc)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>WorldComm</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a857fdd1d4db4cdc6f88f5d8ed0a8fd80</anchor>
      <arglist>(communicator_type const &amp;_globalComm, int _color, bool _isActive)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>WorldComm</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a0ccc003f06bd63620d696d64075e6810</anchor>
      <arglist>(int _colorLocal, int localRank, int _colorGlobal, int globalRank, communicator_type const &amp;_godComm, bool _isActive, bool _doInitActiveMap=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>WorldComm</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>abc50c86e10760891901159b4c2af45a7</anchor>
      <arglist>(communicator_type const &amp;_globalComm, communicator_type const &amp;_godComm, int _localColor, int localRank, std::vector&lt; int &gt; const &amp;isActive)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>WorldComm</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a8bddafe293c666912be64e1df6d958bb</anchor>
      <arglist>(communicator_type const &amp;_globalComm, communicator_type const &amp;_localComm, communicator_type const &amp;_godComm, int _localColor, std::vector&lt; int &gt; const &amp;isActive)</arglist>
    </member>
    <member kind="function">
      <type>communicator_type const &amp;</type>
      <name>globalComm</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>aeb41c938616edf91a9de8797695a4e69</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>communicator_type const &amp;</type>
      <name>localComm</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a381c2052c2875a095b7aa7dfbf746af4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>communicator_type const &amp;</type>
      <name>godComm</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a00c98e19a6d8a367a4254248c960fab5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>communicator_type const &amp;</type>
      <name>comm</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a5840abdd0dbe32c8521fbfefdbd22b9a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>globalSize</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a04b49ec4766696a6b4b16a541b29d3b6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>localSize</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>aa01730263e6e9ab06037a2fdf1987111</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>godSize</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>afc37d00024a399e633c0c03b18e79375</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>globalRank</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a6783ca09b34aa615c539be2150325bb3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>localRank</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a708413b82e279ba4d6757acc43753f7a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>godRank</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a3e2743dd3534612b0d4ad6bc2f9348f5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; int &gt; const &amp;</type>
      <name>mapColorWorld</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>ac1d67d0b210ede96813fac1c4a4847f8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; int &gt; const &amp;</type>
      <name>mapLocalRankToGlobalRank</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>ad986bf0a79672758881938931bfd122c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; int &gt; const &amp;</type>
      <name>mapGlobalRankToGodRank</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>ad1064abc6773a341bd7a3523e9bd7460</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mapColorWorld</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a34d3d5121274645726161896813efe22</anchor>
      <arglist>(int k) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mapLocalRankToGlobalRank</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a9d030786e6b69b8ea8e89ad4b9fccdd0</anchor>
      <arglist>(int k) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mapGlobalRankToGodRank</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a85ef4118fb7a98f88c1a57dc64ca762d</anchor>
      <arglist>(int k) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>masterRank</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>abe4eedbd51e98c29d123f7e2fceeafdc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>WorldComm</type>
      <name>subWorldComm</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a4f896ffc4222e243fc8cdbeb127ee8c5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>WorldComm</type>
      <name>subWorldComm</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>ad9ce219d38f17b1aa0ad8f3752c899b9</anchor>
      <arglist>(int color) const </arglist>
    </member>
    <member kind="function">
      <type>WorldComm</type>
      <name>subWorldCommSeq</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a7eec4f2d4c501c461138f5c4f77c3b4f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isActive</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a5a50900859eced3793711a60dfda557a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; int &gt; const &amp;</type>
      <name>activityOnWorld</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a96faff3009736609ea43a291ccd53eed</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>localColorToGlobalRank</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a909fbfe2603fce7c4423b6b19c6cd368</anchor>
      <arglist>(int _color, int _localRank) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>showMe</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a9d227ffd18632c38e04a64e844e34e46</anchor>
      <arglist>(std::ostream &amp;__out=std::cout) const </arglist>
    </member>
    <member kind="function">
      <type>WorldComm</type>
      <name>operator+</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a9c4a2074edb3227fc8b25d3fb9bee687</anchor>
      <arglist>(WorldComm const &amp;_worldComm) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIsActive</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>aeb79cb8b688443562991c22ff4bf6cad</anchor>
      <arglist>(std::vector&lt; int &gt; const &amp;_isActive) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>upMasterRank</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a0b305b655fd87011b33af3820b620108</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>applyActivityOnlyOn</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a4f5eb428b86932f93bae0176521e4fa1</anchor>
      <arglist>(int _localColor) const </arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; bool, std::set&lt; int &gt; &gt;</type>
      <name>hasMultiLocalActivity</name>
      <anchorfile>classFeel_1_1WorldComm.html</anchorfile>
      <anchor>a906d61f639ef694a7d5613b3bc6b2772</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::Parameter_impl</name>
    <filename>classFeel_1_1Parameter__impl.html</filename>
    <member kind="function">
      <type></type>
      <name>Parameter_impl</name>
      <anchorfile>classFeel_1_1Parameter__impl.html</anchorfile>
      <anchor>a77e29154f4e150f03423d41183eea573</anchor>
      <arglist>(ArgumentPack const &amp;args)</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; std::string &gt;</type>
      <name>getAttrNames</name>
      <anchorfile>classFeel_1_1Parameter__impl.html</anchorfile>
      <anchor>a3d2a39b408ae259dfa66fd029376c7ac</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; std::string &gt;</type>
      <name>getAttrValues</name>
      <anchorfile>classFeel_1_1Parameter__impl.html</anchorfile>
      <anchor>a162fca27194d23d41cfdfd4841166ee8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>getValues</name>
      <anchorfile>classFeel_1_1Parameter__impl.html</anchorfile>
      <anchor>a20f618fc1db3a4fa8b6054ee5af1947f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>getName</name>
      <anchorfile>classFeel_1_1Parameter__impl.html</anchorfile>
      <anchor>ac9fae8b612389fe8777aac879ccd9229</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::Parameter</name>
    <filename>classFeel_1_1Parameter.html</filename>
    <base>Feel::Parameter_impl</base>
  </compound>
  <compound kind="class">
    <name>Feel::Output_impl</name>
    <filename>classFeel_1_1Output__impl.html</filename>
    <base>Feel::Parameter</base>
    <member kind="function">
      <type></type>
      <name>Output_impl</name>
      <anchorfile>classFeel_1_1Output__impl.html</anchorfile>
      <anchor>a52c19de75b0d6958feda8bdc7e5e05bd</anchor>
      <arglist>(ArgumentPack const &amp;args)</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Parameter &gt;</type>
      <name>getDependencies</name>
      <anchorfile>classFeel_1_1Output__impl.html</anchorfile>
      <anchor>ab8809d472135a916a872b11e0c089d7b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; std::string &gt;</type>
      <name>getFuncs</name>
      <anchorfile>classFeel_1_1Output__impl.html</anchorfile>
      <anchor>ad4a1d11aa45aeeb3df8e95192d7b074b</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::Output</name>
    <filename>classFeel_1_1Output.html</filename>
    <base>Feel::Output_impl</base>
  </compound>
  <compound kind="class">
    <name>Feel::xmlParser</name>
    <filename>classFeel_1_1xmlParser.html</filename>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>writeResponse</name>
      <anchorfile>classFeel_1_1xmlParser.html</anchorfile>
      <anchor>a256533b59ce362269152eebca56c67d3</anchor>
      <arglist>(std::string filename, std::string name, std::vector&lt; Parameter &gt; params, std::vector&lt; Output &gt; Outputs)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>writeResult</name>
      <anchorfile>classFeel_1_1xmlParser.html</anchorfile>
      <anchor>a44e5de26e98f8f90696bdb539a18f1a1</anchor>
      <arglist>(std::string filename, std::string name, std::vector&lt; Parameter &gt; params, std::vector&lt; Output &gt; Outputs, std::vector&lt; std::string &gt; paramValues, std::vector&lt; std::string &gt; OutputValues)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::Aitken</name>
    <filename>classFeel_1_1Aitken.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>Aitken&lt; fs_type &gt;</type>
      <name>self_type</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a9b9474a6c84c125593f66b56cedc4529</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>fs_type</type>
      <name>functionspace_type</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a9e3ec01d470b38e19b843ea8cdf23e3e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; functionspace_type &gt;</type>
      <name>functionspace_ptrtype</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a5fab3a6d4b9075fcef0b075f90f24ca1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>functionspace_type::element_type</type>
      <name>element_type</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a7b2146bd7485758d0f5751d7bcfb2447</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>functionspace_type::template Element&lt; typename functionspace_type::value_type, typename VectorUblas&lt; typename functionspace_type::value_type &gt;::range::type &gt;</type>
      <name>element_range_type</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a587fc713962bb5a95b72c227ac2255bb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::map&lt; std::string, double &gt;</type>
      <name>convergence_iteration_type</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>aa5b5ac816e44dd9317437741d2f50c42</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::map&lt; int, convergence_iteration_type &gt;</type>
      <name>convergence_type</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a92e28ea1c2be6db96c52f70d13ae5fdb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>fs_type</type>
      <name>functionspace_type</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a9e3ec01d470b38e19b843ea8cdf23e3e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; functionspace_type &gt;</type>
      <name>functionspace_ptrtype</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a5fab3a6d4b9075fcef0b075f90f24ca1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>functionspace_type::element_type</type>
      <name>element_type</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a7b2146bd7485758d0f5751d7bcfb2447</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>functionspace_type::template Element&lt; typename functionspace_type::value_type, typename VectorUblas&lt; typename functionspace_type::value_type &gt;::range::type &gt;</type>
      <name>element_range_type</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a587fc713962bb5a95b72c227ac2255bb</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Aitken</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a1862a7f1c947b023a06894062485af12</anchor>
      <arglist>(functionspace_ptrtype _Xh, AitkenType _aitkenType=AITKEN_STANDARD, double _failsafeParameter=1.0, double _tol=1.0e-6)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Aitken</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a6992f7dca5a9ff66f84c9b05e3a7064a</anchor>
      <arglist>(Aitken const &amp;tc)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Aitken</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>aaa91f0f4248c20876ea7f59e8bd44278</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_MEMBER_FUNCTION</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a0edf76465800bf7c83ce99f9600d4d2a</anchor>
      <arglist>((void), initialize, tag,(required(residual,*)(currentElt,*)))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_MEMBER_FUNCTION</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a4e61cbcc90722e2bf55581154f1dc40f</anchor>
      <arglist>((element_type), apply, tag,(required(residual,*)(currentElt,*))(optional(forceRelaxation,(bool), false)))</arglist>
    </member>
    <member kind="function">
      <type>element_type</type>
      <name>operator()</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>acf130b5aa15cfaa7432abc0dc403b66b</anchor>
      <arglist>(element_type const &amp;residual, eltType const &amp;elem, bool _forceRelax=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_MEMBER_FUNCTION</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a191cdefff2defc5357f78310e2778bed</anchor>
      <arglist>((void), apply2, tag,(required(newElt,*)(residual,*)(currentElt,*))(optional(forceRelaxation,(bool), false)))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setType</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a0f6a8e0e4ab531841e7cd68f43872f94</anchor>
      <arglist>(AitkenType t)</arglist>
    </member>
    <member kind="function">
      <type>AitkenType</type>
      <name>type</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a84ad6ae1e2e70e9919921e516c9f6d18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>shiftRight</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a8d392fbbf06af0a036a1afdf66a538b4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>self_type &amp;</type>
      <name>operator++</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a4247e0df981567edf0782ceb0947ce4b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>restart</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a172b8cee0afab9d4a56549ada12a7dc8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>theta</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a4b1e6c400b0fdb84aa298f3282632cff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>nIterations</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>aa725fb899f73d3c51325a72887a3e7e4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isFinished</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>aba8409aaf1f69d46f5ecdf28b4f6171f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>residualNorm</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>ac862827ba4589b91d0dec1dc414f36f9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printInfo</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a9300eec9dd3365ad2cfddcb6eb2406a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveConvergenceHistory</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a3aefe8066637121c99e318e1736d8fc7</anchor>
      <arglist>(std::string const &amp;fname) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>forceConvergence</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a46fdad29382843f64499885ac35d8fe6</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Aitken</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a8ae51bcb7c25fa0ab795acbec50f1305</anchor>
      <arglist>(functionspace_ptrtype _Xh, double _failsafeParameter=0.1)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Aitken</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a6992f7dca5a9ff66f84c9b05e3a7064a</anchor>
      <arglist>(Aitken const &amp;tc)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Aitken</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>aaa91f0f4248c20876ea7f59e8bd44278</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initialize</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a4d347e185e6ea977a6d3bbb629d55956</anchor>
      <arglist>(element_type const &amp;residual, element_type const &amp;elem)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initialize</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a461ea92f34b81540eb458cc7ba150a61</anchor>
      <arglist>(element_type const &amp;residual, element_range_type const &amp;elem)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setElement</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>ac259703077470120ddfb6e05910248a0</anchor>
      <arglist>(element_type const &amp;residual, element_type const &amp;elem)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setElement</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>ade99f9e5979912d060b261172acdae94</anchor>
      <arglist>(element_type const &amp;residual, element_range_type const &amp;elem)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>calculateParameter</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>af02fb755e151cab5c0b5b4cc3a4d1a3c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>relaxationStep</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a454f24e096a29346a28fdeb653fc9a38</anchor>
      <arglist>(element_type &amp;new_elem)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>shiftRight</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a8d392fbbf06af0a036a1afdf66a538b4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resetPreviousParameter</name>
      <anchorfile>classFeel_1_1Aitken.html</anchorfile>
      <anchor>a8de2e597335bbf236a9f72734b89fc4a</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::compute_aitken_return</name>
    <filename>structFeel_1_1compute__aitken__return.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>boost::remove_reference&lt; typename parameter::binding&lt; Args, tag::space &gt;::type &gt;::type::element_type</type>
      <name>space_type</name>
      <anchorfile>structFeel_1_1compute__aitken__return.html</anchorfile>
      <anchor>a5cb26b46b0cc251505619d9d3189d47a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Aitken&lt; space_type &gt;</type>
      <name>type</name>
      <anchorfile>structFeel_1_1compute__aitken__return.html</anchorfile>
      <anchor>a336a8187cdbfa5fcb329b3e4176a7c90</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; type &gt;</type>
      <name>ptrtype</name>
      <anchorfile>structFeel_1_1compute__aitken__return.html</anchorfile>
      <anchor>a47b2045f2882788ce287fe0e0495031e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::Backend</name>
    <filename>classFeel_1_1Backend.html</filename>
    <templarg>T</templarg>
    <member kind="typedef">
      <type>T</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a84d7e4e8815fef30dafaa3387ea9a9bd</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>type_traits&lt; T &gt;::real_type</type>
      <name>real_type</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a1aa3b619df8c92a171793bc80ebffe33</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Vector&lt; value_type &gt;</type>
      <name>vector_type</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>aa3289d97e3a68539e3637101ed97ee60</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; vector_type &gt;</type>
      <name>vector_ptrtype</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a83087101918536cbcd4f6c177c95c9b5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>MatrixSparse&lt; value_type &gt;</type>
      <name>sparse_matrix_type</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>adca9a1825c101bb4a279aba362b99ae6</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; sparse_matrix_type &gt;</type>
      <name>sparse_matrix_ptrtype</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a041a9169a3fa3814bb02225a4b5cbe9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sparse_matrix_type::graph_type</type>
      <name>graph_type</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a6351716be5de2ffc32a930c71758d631</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sparse_matrix_type::graph_ptrtype</type>
      <name>graph_ptrtype</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>aad60213fd9c0a20ca56119c9725d3d97</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Backend&lt; value_type &gt;</type>
      <name>backend_type</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a6a95f8c1849d4bd7f1db5e18f2389ab1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; backend_type &gt;</type>
      <name>backend_ptrtype</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a36f30d43d18f8e9607453c9219ad39c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SolverNonLinear&lt; value_type &gt;</type>
      <name>solvernonlinear_type</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>aca3c98937f8272ba02f70215952db8fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; solvernonlinear_type &gt;</type>
      <name>solvernonlinear_ptrtype</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a63ee7a7af504bb53e1ecf377c57c442e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::tuple&lt; bool, size_type, value_type &gt;</type>
      <name>solve_return_type</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>adc046b39286608cae208b47df4b99dd4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::tuple&lt; bool, size_type, value_type &gt;</type>
      <name>nl_solve_return_type</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>ac09a918cec2b174b1eec7ac35d92f730</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>kspType</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a027f82bf096be59cbd5c48f434367785</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>pcType</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a70e4a85538426252672cd27421fe28f8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasConstantNullSpace</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a9ad1f4d37cc5d51dda696d87c620f327</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>fieldsplitType</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>ae40599ecea7961fbad9dd267ce73753b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>PreconditionerType</type>
      <name>pcEnumType</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a578d05b7b18f4e296df32f094a081f12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SolverType</type>
      <name>kspEnumType</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>ad9dfc81ebf6cde79c7764ceffbf3d546</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FieldSplitType</type>
      <name>fieldSplitEnumType</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a6ee4d86f3b56912737fb9927ce872458</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>pcFactorMatSolverPackageType</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>ace6595a93fa9f80cb564b57cd15659d0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>MatSolverPackageType</type>
      <name>matSolverPackageEnumType</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a6647de58940f9532e23e5118d0cfd156</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>MatrixStructure</type>
      <name>precMatrixStructure</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a580834220331e6c9a43174189c5ec270</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>rTolerance</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>aa058f17538ffb5404e15908c47f18948</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>dTolerance</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>ae96c86a02db04d2b5977107acd79bf72</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>aTolerance</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a202996a34fde4501cd8dce1153720212</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>maxIterations</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a8fd53f677dd9379166c2287d9cc69abe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>converged</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a20a6e9f6e150caae30d2db15d8316850</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>nIterations</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a497f9f6fc49d46330fb9345e2341216d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>transpose</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a16eced4cb169375eecc11ccc76621a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>WorldComm const &amp;</type>
      <name>comm</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a084ba908a4171edac918e7aad7560d27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_MEMBER_FUNCTION</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a7f889bce160dd0f6cdbd9ba6fe45da4f</anchor>
      <arglist>((void), setTolerances, tag,(required(rtolerance,(double)))(optional(maxit,(size_type), 1000)(atolerance,(double), 1e-50)(dtolerance,(double), 1e5)))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_MEMBER_FUNCTION</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a7cec98c8054a977896c36b31e282cdf2</anchor>
      <arglist>((void), setSolverType, tag,(required(ksp,(std::string)))(optional(pc,(std::string),&quot;lu&quot;)(constant_null_space,(bool), false)(pcfactormatsolverpackage,(std::string),&quot;petsc&quot;)))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPrecMatrixStructure</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>ac561dc38e1f22c68f0395ee90e717709</anchor>
      <arglist>(MatrixStructure mstruct)</arglist>
    </member>
    <member kind="function">
      <type>solvernonlinear_ptrtype</type>
      <name>nlSolver</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a59d78ab6b116dbe065a6fd258a7c5de2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTranspose</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>acdea997fc311a0f039418b387efcdb1f</anchor>
      <arglist>(bool transpose)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual real_type</type>
      <name>dot</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>aaab49985927760d5cf50810d8d0c21c9</anchor>
      <arglist>(vector_type const &amp;x, vector_type const &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>real_type</type>
      <name>dot</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>ac6a784a0037db067e878f0d14d084ab4</anchor>
      <arglist>(vector_ptrtype const &amp;x, vector_ptrtype const &amp;y) const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>prod</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>aa3eff8e69436b9d28fb8cc39ba6c52ec</anchor>
      <arglist>(sparse_matrix_type const &amp;A, vector_type const &amp;x, vector_type &amp;y) const =0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prod</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a8e3f8adf98ddf60ff0adb0bbd621aa7e</anchor>
      <arglist>(sparse_matrix_ptrtype const &amp;A, vector_ptrtype const &amp;x, vector_ptrtype &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_MEMBER_FUNCTION</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>ac0a6125f510d34c9aee3c0f8f5c57ddb</anchor>
      <arglist>((solve_return_type), solve, tag,(required(matrix,(sparse_matrix_ptrtype))(in_out(solution),*)(rhs,(vector_ptrtype)))(optional(prec,(preconditioner_ptrtype), preconditioner(_matrix=matrix, _pc=LU_PRECOND, _backend=BACKEND_PETSC))(maxit,(size_type), M_maxit)(rtolerance,(double), M_rtolerance)(atolerance,(double), M_atolerance)(dtolerance,(double), M_dtolerance)(reuse_prec,(bool), M_reuse_prec)(transpose,(bool), false)(constant_null_space,(bool), false)(pc,(std::string), M_pc)(ksp,(std::string), M_ksp)(pcfactormatsolverpackage,(std::string), M_pcFactorMatSolverPackage)))</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual solve_return_type</type>
      <name>solve</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a22833dfc4ad0b592a753d48ae2946fd2</anchor>
      <arglist>(sparse_matrix_ptrtype const &amp;A, sparse_matrix_ptrtype const &amp;P, vector_ptrtype &amp;x, vector_ptrtype const &amp;b)=0</arglist>
    </member>
    <member kind="function">
      <type>solve_return_type</type>
      <name>solve</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>ad2157eec7ea621c3792797037277d9fa</anchor>
      <arglist>(sparse_matrix_ptrtype const &amp;A, sparse_matrix_ptrtype const &amp;P, vector_ptrtype &amp;x, vector_ptrtype const &amp;b, bool reuse_prec)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_MEMBER_FUNCTION</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>af17204bd1b917d5d3bc5f36e41f3ab8b</anchor>
      <arglist>((nl_solve_return_type), nlSolve, tag,(required(in_out(solution),*))(optional(jacobian,(sparse_matrix_ptrtype), sparse_matrix_ptrtype())(residual,(vector_ptrtype), vector_ptrtype())(prec,(preconditioner_ptrtype), preconditioner(_pc=LU_PRECOND, _backend=BACKEND_PETSC))(maxit,(size_type), M_maxit)(rtolerance,(double), M_rtolerance)(atolerance,(double), M_atolerance)(dtolerance,(double), M_dtolerance)(reuse_prec,(bool), M_reuse_prec)(reuse_jac,(bool), M_reuse_jac)(transpose,(bool), false)(pc,(std::string), M_pc)(ksp,(std::string), M_ksp)(pcfactormatsolverpackage,(std::string), M_pcFactorMatSolverPackage)))</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual nl_solve_return_type</type>
      <name>nlSolve</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>acc94a0aad6494257235aab11ec372324</anchor>
      <arglist>(sparse_matrix_ptrtype &amp;A, vector_ptrtype &amp;x, vector_ptrtype &amp;b, const double, const int)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual nl_solve_return_type</type>
      <name>nlSolve</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>aaabfbb2da0661b6e73deb704df212dca</anchor>
      <arglist>(sparse_matrix_ptrtype &amp;A, vector_ptrtype &amp;x, vector_ptrtype &amp;b, const double, const int, bool reusePC, bool reuseJAC)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>attachPreconditioner</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>aa7ce4ac2e7d7146834d56fb6afc2a318</anchor>
      <arglist>(preconditioner_ptrtype preconditioner)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>preconditioner_ptrtype</type>
      <name>M_preconditioner</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a924cadbd6ba07b048a5aa3f7b3d0eade</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Backend</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a377464d8e88ba433e5d53bd46a374659</anchor>
      <arglist>(WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Backend</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>ae06842dea65046e685a8fd936eac25e3</anchor>
      <arglist>(po::variables_map const &amp;vm, std::string const &amp;prefix=&quot;&quot;, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Backend</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>acc5ca22f72ad952dbed1e41fffe324cc</anchor>
      <arglist>(Backend const &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Backend</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>ac3117fd5cb06e4d5f65c1b67b0f4cb7a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual sparse_matrix_ptrtype</type>
      <name>newMatrix</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>ae9cc4a2666705823d5d435637b24483d</anchor>
      <arglist>(const size_type m, const size_type n, const size_type m_l, const size_type n_l, const size_type nnz=30, const size_type noz=10, size_type prop=NON_HERMITIAN)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual sparse_matrix_ptrtype</type>
      <name>newMatrix</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>ad60108577ae6d3e27ea67a335561cbd4</anchor>
      <arglist>(const size_type m, const size_type n, const size_type m_l, const size_type n_l, graph_ptrtype const &amp;graph, size_type matrix_properties=NON_HERMITIAN)=0</arglist>
    </member>
    <member kind="function">
      <type>sparse_matrix_ptrtype</type>
      <name>newMatrix</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a1768759023800a4136a6894c2bd7cf1f</anchor>
      <arglist>(const size_type m, const size_type n, const size_type m_l, const size_type n_l, graph_ptrtype const &amp;graph, std::vector&lt; std::vector&lt; int &gt; &gt; indexSplit, size_type matrix_properties=NON_HERMITIAN)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual sparse_matrix_ptrtype</type>
      <name>newMatrix</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a111bba751ca8abc86a5f44b965da66a5</anchor>
      <arglist>(DataMap const &amp;dm1, DataMap const &amp;dm2, size_type prop=NON_HERMITIAN, bool init=true)=0</arglist>
    </member>
    <member kind="function">
      <type>sparse_matrix_ptrtype</type>
      <name>newMatrix</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a08b60866e5aa72ab809b3906de62571a</anchor>
      <arglist>(DataMap const &amp;domainmap, DataMap const &amp;imagemap, graph_ptrtype const &amp;graph, size_type matrix_properties=NON_HERMITIAN, bool init=true)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual sparse_matrix_ptrtype</type>
      <name>newZeroMatrix</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>ad9d817212ebf3ddebf2a7b9f71232d10</anchor>
      <arglist>(const size_type m, const size_type n, const size_type m_l, const size_type n_l)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual sparse_matrix_ptrtype</type>
      <name>newZeroMatrix</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a16048207b66c731bdc6a9aae6baadb53</anchor>
      <arglist>(DataMap const &amp;dm1, DataMap const &amp;dm2)=0</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_MEMBER_FUNCTION</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a5317fce96a914e2eed25dc5fb91dd343</anchor>
      <arglist>((sparse_matrix_ptrtype), newMatrix, tag,(required(trial,*(boost::is_convertible&lt; mpl::_, boost::shared_ptr&lt; FunctionSpaceBase &gt; &gt;))(test,*(boost::is_convertible&lt; mpl::_, boost::shared_ptr&lt; FunctionSpaceBase &gt; &gt;)))(optional(pattern,(size_type), Pattern::COUPLED)(properties,(size_type), NON_HERMITIAN)(buildGraphWithTranspose,(bool), false)(pattern_block,*,(vf::Blocks&lt; 1, 1, size_type &gt;(size_type(Pattern::HAS_NO_BLOCK_PATTERN))))(diag_is_nonzero,*(boost::is_integral&lt; mpl::_ &gt;), true)(verbose,(int), 0)(collect_garbage,*(boost::is_integral&lt; mpl::_ &gt;), true)))</arglist>
    </member>
    <member kind="function">
      <type>sparse_matrix_ptrtype</type>
      <name>newMatrix</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a1b38302501043eb08a7a58f43312b966</anchor>
      <arglist>(DomainSpace const &amp;dm, ImageSpace const &amp;im, sparse_matrix_ptrtype const &amp;M, size_type prop=NON_HERMITIAN)</arglist>
    </member>
    <member kind="function">
      <type>sparse_matrix_ptrtype</type>
      <name>newBlockMatrixImpl</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a93777b44ce4884533c75df556c2070dc</anchor>
      <arglist>(vf::BlocksBase&lt; BlockType &gt; const &amp;b, bool copy_values=true, bool diag_is_nonzero=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_MEMBER_FUNCTION</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>abdf8bd8065b52d18c7f8a4b89fdd23b8</anchor>
      <arglist>((sparse_matrix_ptrtype), newBlockMatrix, tag,(required(block,*))(optional(copy_values,*(boost::is_integral&lt; mpl::_ &gt;), true)(diag_is_nonzero,*(boost::is_integral&lt; mpl::_ &gt;), true)))</arglist>
    </member>
    <member kind="function">
      <type>vector_ptrtype</type>
      <name>newBlockVectorImpl</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a339c85259745dbf2d883c9464b994a8c</anchor>
      <arglist>(vf::BlocksBase&lt; BlockType &gt; const &amp;b, bool copy_values=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_MEMBER_FUNCTION</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a54d1ef96d4709c1655a07490d2047fbe</anchor>
      <arglist>((vector_ptrtype), newBlockVector, tag,(required(block,*))(optional(copy_values,*(boost::is_integral&lt; mpl::_ &gt;), true)))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_MEMBER_FUNCTION</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>ab262d0d0784f2a53c40558e835dd3ea1</anchor>
      <arglist>((sparse_matrix_ptrtype), newZeroMatrix, tag,(required(test,*)(trial,*)))</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual vector_ptrtype</type>
      <name>newVector</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>af2490c7116ddd7218b6fc59cff3ff8cc</anchor>
      <arglist>(DataMap const &amp;dm)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual vector_ptrtype</type>
      <name>newVector</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>aa94fb4e059fa9ef32e77b22b9f6a6b1e</anchor>
      <arglist>(const size_type n, const size_type n_local)=0</arglist>
    </member>
    <member kind="function">
      <type>vector_ptrtype</type>
      <name>newVector</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>ae4268c3a3e792a44d417ddc21a3e63cb</anchor>
      <arglist>(DomainSpace const &amp;dm)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static backend_ptrtype</type>
      <name>build</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>ad4238dc5b325c76e762a2726182956ae</anchor>
      <arglist>(BackendType=BACKEND_GMM, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static backend_ptrtype</type>
      <name>build</name>
      <anchorfile>classFeel_1_1Backend.html</anchorfile>
      <anchor>a04038168e48b3c8ccd37e860981d648a</anchor>
      <arglist>(po::variables_map const &amp;vm, std::string const &amp;prefix=&quot;&quot;, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::BackendGmmDefaults</name>
    <filename>structFeel_1_1BackendGmmDefaults.html</filename>
    <member kind="variable">
      <type>std::string</type>
      <name>solver_type</name>
      <anchorfile>structFeel_1_1BackendGmmDefaults.html</anchorfile>
      <anchor>ab03595984b085f87fa25dd5b108b1bba</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>std::string</type>
      <name>pc_type</name>
      <anchorfile>structFeel_1_1BackendGmmDefaults.html</anchorfile>
      <anchor>abce6818cfe4ee493fe35bd5eff031ab2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>threshold</name>
      <anchorfile>structFeel_1_1BackendGmmDefaults.html</anchorfile>
      <anchor>add598bda9a0915108f13b42451d6247a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>fillin</name>
      <anchorfile>structFeel_1_1BackendGmmDefaults.html</anchorfile>
      <anchor>a9cfa2f5c0f808355a233267a00371854</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>restart</name>
      <anchorfile>structFeel_1_1BackendGmmDefaults.html</anchorfile>
      <anchor>adab123ed3c779a83a5d0d9e228a642ae</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>verbose</name>
      <anchorfile>structFeel_1_1BackendGmmDefaults.html</anchorfile>
      <anchor>aa0625b0f1f5498be6840f5f3b65a3e54</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>maxiter</name>
      <anchorfile>structFeel_1_1BackendGmmDefaults.html</anchorfile>
      <anchor>a3e06f9835aee2c24908fd650a05662fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>tolerance</name>
      <anchorfile>structFeel_1_1BackendGmmDefaults.html</anchorfile>
      <anchor>a103220dd95510b4ce94bbbbf8f486f9d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::BackendGmm</name>
    <filename>classFeel_1_1BackendGmm.html</filename>
    <templarg>T</templarg>
    <base>Feel::Backend</base>
    <member kind="typedef">
      <type>super::value_type</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a9a6e74452ed213702564c1e9d98bc5a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>BackendGmmDefaults</type>
      <name>defaults_type</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a598e590ad668ac7c04ebbfe8a01a56b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::sparse_matrix_type</type>
      <name>sparse_matrix_type</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>aa0a83f305886962361916c8d12b3a34e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::sparse_matrix_ptrtype</type>
      <name>sparse_matrix_ptrtype</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>abffb2fef4d7b1b492740dca3370f13b1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>MatrixGmm&lt; value_type, gmm::row_major &gt;</type>
      <name>gmm_sparse_matrix_type</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a3b114548c2b9e60288d32e65fab2cc92</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; gmm_sparse_matrix_type &gt;</type>
      <name>gmm_sparse_matrix_ptrtype</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>af0da038e950109bd69aa66852c7aec4c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sparse_matrix_type::graph_type</type>
      <name>graph_type</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a2035dd950e271e3f7e6150a6e21fc687</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sparse_matrix_type::graph_ptrtype</type>
      <name>graph_ptrtype</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>aa1f1d5b6388bcfc5946428361eacfd7e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::vector_type</type>
      <name>vector_type</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>ab212ec91a893a675789b2b27c845f5fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::vector_ptrtype</type>
      <name>vector_ptrtype</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>afc13da7a019acad1710f9aec1c407a47</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>VectorUblas&lt; value_type &gt;</type>
      <name>gmm_vector_type</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a58abe198c0d34639d0fbce5bc4fe830a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; vector_type &gt;</type>
      <name>gmm_vector_ptrtype</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a2934b9a6fb7049707313a9e96d283efa</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::solve_return_type</type>
      <name>solve_return_type</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>abe37400f81c884c1dda3e609ea0ace6f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::nl_solve_return_type</type>
      <name>nl_solve_return_type</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>adc0fe1f1228e4fa5e3beaee92e270a48</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BackendGmm</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a069730fa5d84b84f0378022fc07ea8a3</anchor>
      <arglist>(po::variables_map const &amp;vm, std::string const &amp;prefix=&quot;&quot;)</arglist>
    </member>
    <member kind="function">
      <type>sparse_matrix_ptrtype</type>
      <name>newMatrix</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a8ee578b46c54fdb56e2552b0ca788ced</anchor>
      <arglist>(const size_type m, const size_type n, const size_type m_l, const size_type n_l, const size_type nnz=30, const size_type noz=10, size_type matrix_properties=NON_HERMITIAN)</arglist>
    </member>
    <member kind="function">
      <type>sparse_matrix_ptrtype</type>
      <name>newMatrix</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a4f83be3ed24189d27c8d47ecd206155e</anchor>
      <arglist>(const size_type m, const size_type n, const size_type m_l, const size_type n_l, graph_ptrtype const &amp;graph, size_type matrix_properties=NON_HERMITIAN)</arglist>
    </member>
    <member kind="function">
      <type>sparse_matrix_ptrtype</type>
      <name>newMatrix</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>ab9e44b40d90765dfc86cd6ac4469bfc2</anchor>
      <arglist>(DataMap const &amp;d1, DataMap const &amp;d2, size_type matrix_properties=NON_HERMITIAN, bool init=true)</arglist>
    </member>
    <member kind="function">
      <type>sparse_matrix_ptrtype</type>
      <name>newZeroMatrix</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>abdfb9de9a46ddb81b3059c6def501c93</anchor>
      <arglist>(const size_type m, const size_type n, const size_type m_l, const size_type n_l)</arglist>
    </member>
    <member kind="function">
      <type>sparse_matrix_ptrtype</type>
      <name>newZeroMatrix</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a23b3079bb15bd2dd4863d7394885dc8e</anchor>
      <arglist>(DataMap const &amp;d1, DataMap const &amp;d2)</arglist>
    </member>
    <member kind="function">
      <type>vector_ptrtype</type>
      <name>newVector</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>aa007a7d82308513fc0179704e8aa7dab</anchor>
      <arglist>(DataMap const &amp;d)</arglist>
    </member>
    <member kind="function">
      <type>vector_ptrtype</type>
      <name>newVector</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>abf7c5589172ec52b958036e7279fdd52</anchor>
      <arglist>(const size_type n, const size_type n_local)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_noisy</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a3cdc65a00bc52b07efc1496b72d6ad77</anchor>
      <arglist>(int noisy)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_maxiter</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a8617b786e3c0f935c4977862a781cef4</anchor>
      <arglist>(int maxiter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_fillin</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a65e88d7970c44587e0b6030f27982226</anchor>
      <arglist>(int fillin)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_threshold</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a2853532a681fb98fbd7a9d5c6cdd6126</anchor>
      <arglist>(double threshold)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_tol</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a4866957e93b63f10495d9f5d29738609</anchor>
      <arglist>(double tol)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_symmetric</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a33361204d8ccd1a3c263ee8d0e4f53bb</anchor>
      <arglist>(bool isSymmetric)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_direct</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>ac40a7f5144997076f5a4fdf975aec38c</anchor>
      <arglist>(bool isDirect)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_solver_type</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>aaef47aefe93a52b47ca78a69eea03824</anchor>
      <arglist>(std::string const &amp;solver)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_preconditioner_type</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>ae7cbb00a1e9d576d8b7d6ba5d213a854</anchor>
      <arglist>(std::string const &amp;prec)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_restart</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a51cf211835617b073556ecfe8b932936</anchor>
      <arglist>(int restart)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prod</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a5ff4fcf2818cbddadc890f14ffd296ab</anchor>
      <arglist>(sparse_matrix_type const &amp;A, vector_type const &amp;x, vector_type &amp;b) const </arglist>
    </member>
    <member kind="function">
      <type>solve_return_type</type>
      <name>solve</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>aa5f857182a31b7389641cfa42d7e0127</anchor>
      <arglist>(sparse_matrix_type const &amp;A, vector_type &amp;x, const vector_type &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>solve_return_type</type>
      <name>solve</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a8b7ec172d10796a8bdfb8835a401330b</anchor>
      <arglist>(sparse_matrix_ptrtype const &amp;A, vector_ptrtype &amp;x, const vector_ptrtype &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>solve_return_type</type>
      <name>solve</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a23d46be393e8930b1b1249540d59eff9</anchor>
      <arglist>(sparse_matrix_ptrtype const &amp;A, sparse_matrix_ptrtype const &amp;P, vector_ptrtype &amp;x, const vector_ptrtype &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>dot</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a1b90ea111ce75c3f84f496ccde1d56ba</anchor>
      <arglist>(const gmm_vector_type &amp;f, const gmm_vector_type &amp;x) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>converged</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a4c378da910851d875f9a553866e69bec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>get_iteration</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>ad7c5ff5e14e348f6d485472daa95fd8c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>boost::shared_ptr&lt; MatrixTriplet&lt; T &gt; &gt;</type>
      <name>toTriplet</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>ac71e7e77d38e58c2d1ceab12d0cf026e</anchor>
      <arglist>(sparse_matrix_type const &amp;m)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static sparse_matrix_ptrtype</type>
      <name>newMatrix</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>ab83d0ed2a8d15fbdb5cd420aaa0be095</anchor>
      <arglist>(boost::shared_ptr&lt; DomainSpace &gt; const &amp;space1, boost::shared_ptr&lt; DualImageSpace &gt; const &amp;space2, size_type matrix_properties=NON_HERMITIAN)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static vector_ptrtype</type>
      <name>newVector</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>ac7cbe148dae2bcc0000b5677ff163901</anchor>
      <arglist>(boost::shared_ptr&lt; SpaceT &gt; const &amp;space)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static vector_ptrtype</type>
      <name>newVector</name>
      <anchorfile>classFeel_1_1BackendGmm.html</anchorfile>
      <anchor>a2c527e76b99025f3de0cb0541195c5cb</anchor>
      <arglist>(SpaceT const &amp;space)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::BFGSInvHessian</name>
    <filename>structFeel_1_1BFGSInvHessian.html</filename>
    <templarg>VECTOR</templarg>
    <member kind="typedef">
      <type>VECTOR</type>
      <name>vector_type</name>
      <anchorfile>structFeel_1_1BFGSInvHessian.html</anchorfile>
      <anchor>af799b317a77f6bae3536d421a0e8c400</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>vector_type::value_type</type>
      <name>T</name>
      <anchorfile>structFeel_1_1BFGSInvHessian.html</anchorfile>
      <anchor>ad61508ad46b6459b685e13e28f929b62</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>vector_type::value_type</type>
      <name>value_type</name>
      <anchorfile>structFeel_1_1BFGSInvHessian.html</anchorfile>
      <anchor>a32780425fd2eabcbaeca5e124577e8ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>value_type</type>
      <name>magnitude_type</name>
      <anchorfile>structFeel_1_1BFGSInvHessian.html</anchorfile>
      <anchor>aae99ef583faf5432c1ad93dcd112f3d6</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BFGSInvHessian</name>
      <anchorfile>structFeel_1_1BFGSInvHessian.html</anchorfile>
      <anchor>a82494ad6654577f9bdf6d53b0e79df60</anchor>
      <arglist>(BFGSType v=BFGS)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>hmult</name>
      <anchorfile>structFeel_1_1BFGSInvHessian.html</anchorfile>
      <anchor>aae2f3f994c51567df3034597c3ec0f56</anchor>
      <arglist>(const VEC1 &amp;X, VEC2 &amp;Y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>restart</name>
      <anchorfile>structFeel_1_1BFGSInvHessian.html</anchorfile>
      <anchor>a72a9c001bffe634ab241922356a38eb7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>update</name>
      <anchorfile>structFeel_1_1BFGSInvHessian.html</anchorfile>
      <anchor>add421af3ea0ac0896c71486128e62248</anchor>
      <arglist>(const VECT1 &amp;deltak, const VECT2 &amp;gammak)</arglist>
    </member>
    <member kind="variable">
      <type>std::vector&lt; vector_type &gt;</type>
      <name>delta</name>
      <anchorfile>structFeel_1_1BFGSInvHessian.html</anchorfile>
      <anchor>a8136a1ddc1ab1b95685bff9bee7858c5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>std::vector&lt; vector_type &gt;</type>
      <name>gamma</name>
      <anchorfile>structFeel_1_1BFGSInvHessian.html</anchorfile>
      <anchor>aefe0bfc61313f27bcdc00ed403782254</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>std::vector&lt; vector_type &gt;</type>
      <name>zeta</name>
      <anchorfile>structFeel_1_1BFGSInvHessian.html</anchorfile>
      <anchor>a0d5d4ce7e15779dd8a6e375f3820cbd0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>std::vector&lt; T &gt;</type>
      <name>tau</name>
      <anchorfile>structFeel_1_1BFGSInvHessian.html</anchorfile>
      <anchor>a81ef191fd80d4d4f4353a4ee5af076d8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>std::vector&lt; T &gt;</type>
      <name>rho</name>
      <anchorfile>structFeel_1_1BFGSInvHessian.html</anchorfile>
      <anchor>a86f71b754658e6470e91a89c4fee9eba</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>version</name>
      <anchorfile>structFeel_1_1BFGSInvHessian.html</anchorfile>
      <anchor>a0f3b22ef2dc359cf348c44a7805c634a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::BoundingBox</name>
    <filename>structFeel_1_1BoundingBox.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>T</type>
      <name>value_type</name>
      <anchorfile>structFeel_1_1BoundingBox.html</anchorfile>
      <anchor>ad79b724f28f24c2324fcd6a042ab132e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>node&lt; T &gt;::type</type>
      <name>node_type</name>
      <anchorfile>structFeel_1_1BoundingBox.html</anchorfile>
      <anchor>a7113555724a81130352efdb44ba0b1f3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>matrix_node&lt; T &gt;::type</type>
      <name>matrix_node_type</name>
      <anchorfile>structFeel_1_1BoundingBox.html</anchorfile>
      <anchor>a1e166c1f59d418d06dd65240e52b85bd</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BoundingBox</name>
      <anchorfile>structFeel_1_1BoundingBox.html</anchorfile>
      <anchor>aeff22a496a575bdd2255d82930ce9214</anchor>
      <arglist>(bool is_lin=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BoundingBox</name>
      <anchorfile>structFeel_1_1BoundingBox.html</anchorfile>
      <anchor>ace8132883dc982fb392dc561056858d1</anchor>
      <arglist>(BoundingBox const &amp;bb)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~BoundingBox</name>
      <anchorfile>structFeel_1_1BoundingBox.html</anchorfile>
      <anchor>ad42bb35c4e77c1c95f371f1185620c94</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>make</name>
      <anchorfile>structFeel_1_1BoundingBox.html</anchorfile>
      <anchor>ad8e22c0cf7fc18e158956dd18488aa9e</anchor>
      <arglist>(matrix_node_type const &amp;__ptab)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isLinear</name>
      <anchorfile>structFeel_1_1BoundingBox.html</anchorfile>
      <anchor>a5df701dfd7e2cf7cdaec9ba482d324f4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>node_type</type>
      <name>min</name>
      <anchorfile>structFeel_1_1BoundingBox.html</anchorfile>
      <anchor>a3a49c46cf64e6afaf4884a21faaf6488</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>node_type</type>
      <name>max</name>
      <anchorfile>structFeel_1_1BoundingBox.html</anchorfile>
      <anchor>affc3947554fd949d577b8f291f6a6991</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>is_linear</name>
      <anchorfile>structFeel_1_1BoundingBox.html</anchorfile>
      <anchor>aa24f11f53bdbfffdfe22be20e652965d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::DataMap</name>
    <filename>classFeel_1_1DataMap.html</filename>
    <member kind="function">
      <type></type>
      <name>DataMap</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a2e372c734dd8c99c6201cd39461b072c</anchor>
      <arglist>(WorldComm const &amp;_worldComm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DataMap</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ad153698b7f23eaa1cc61af48d58a4313</anchor>
      <arglist>(size_type n, size_type n_local, WorldComm const &amp;_worldComm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DataMap</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>afd5ef3baff10d03a41bacbb5b0b9c1b8</anchor>
      <arglist>(size_type n, std::vector&lt; int &gt; const &amp;firstdof, std::vector&lt; int &gt; const &amp;lastdof)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DataMap</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a2a80e5cbf3eb87b37a3abaf5fb8a7db9</anchor>
      <arglist>(DataMap const &amp;dm)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DataMap</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a0fc12e586bacad0d8da94dfbd8aa2af2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DataMap &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ab70490464eb77e2e3302fab7b770c428</anchor>
      <arglist>(DataMap const &amp;dm)</arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>nDof</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ae824d566b31908f88345c35f121fe382</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>nLocalDof</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ab3eebfa5817a6fbcb79e31f0caa4237f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>nLocalDofWithoutGhost</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>aa1d950e30f739d380bfdbfc37b697a68</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>nLocalDofWithGhost</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ab74e76b5d3fba69cdca3a11a6b8a55f3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>nMyDof</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a5bdd7e9877dec26ffd004f383f8420c9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>nDofOnProcessor</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ae967766557cd9a2a1a7ed475d340723e</anchor>
      <arglist>(const size_type proc) const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>nProcessors</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a8b33f1ae8055c9225cb641c4850f3624</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>firstDof</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a06a06ede045ba810b8258505b60f13b6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>firstDof</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a3dd7ca59c8123ccbab2a31cc32fd4388</anchor>
      <arglist>(const size_type proc) const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>firstDofGlobalCluster</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>aab48670f7aa84eee42a987470024ffbf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>firstDofGlobalCluster</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ad1cf9d19c6087f862f297502f0bf7176</anchor>
      <arglist>(uint16_type proc) const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>lastDof</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ac4be1d1253345a313f8be0a4687bdf78</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>lastDof</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>abf4d0054f85e7781ea6a4bd3410c25de</anchor>
      <arglist>(const unsigned int proc) const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>lastDofGlobalCluster</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a0079f6b697b0cb52e9399f6540752d0d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>lastDofGlobalCluster</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>aec25fed9526d3ba58be19ec5a229d92c</anchor>
      <arglist>(uint16_type proc) const </arglist>
    </member>
    <member kind="function">
      <type>uint16_type</type>
      <name>procOnGlobalCluster</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a1b9b5e3bf873e00f71454b6ab5190251</anchor>
      <arglist>(size_type globDof) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>dofGlobalClusterIsOnProc</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>aa03fb5d74d82d0327572368c09804e12</anchor>
      <arglist>(size_type globDof) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>dofGlobalClusterIsOnProc</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ac1f1f40ea7a079fabf0dd8438a1b5a5d</anchor>
      <arglist>(size_type globDof, int proc) const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>lid</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a0700603b97007239380aed3d5674af4b</anchor>
      <arglist>(size_type GID) const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>gid</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>aad8cf00cf50fae0f77b491f3ea74d6e6</anchor>
      <arglist>(size_type LID) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>myGID</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a7b4bb53538cca55711f2cbbfbff1a5ed</anchor>
      <arglist>(size_type GID) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>myLID</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ae2636e7ea59b7ebe6608082f7923b1aa</anchor>
      <arglist>(size_type LID) const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>minAllGID</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>acefa415e83277fcfd63f7e43625b47dc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>maxAllGID</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a6b51635dd8729021b2adb01e9f5e6b20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>minMyGID</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>af14f18936746e2941fa764149aedf969</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>maxMyGID</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>abe1b0d25d562becf450a71c33fd7a477</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>minLID</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a9491ee580ee0caa1ce90d8b1bdcf23e0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>maxLID</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ace22c7e11a19967409d331e6c669c5dd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>nGlobalElements</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a3b835f75624cb4d9fea1cf4ade3f0cfa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>nMyElements</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a9c51e708346f8f8e345ba0e8e8082eda</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; size_type &gt; const &amp;</type>
      <name>myGlobalElements</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>abd4cb64a5b7ce2bb7238e2d6375858c5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; size_type &gt; const &amp;</type>
      <name>mapGlobalProcessToGlobalCluster</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ad388169b5bd46ce64024d75ff2b5e39d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; size_type &gt; const &amp;</type>
      <name>mapGlobalClusterToGlobalProcess</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>abe0b64397247c54b16df929202b39656</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>mapGlobalProcessToGlobalCluster</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a6200797aa2a6454fdca71ada50b19149</anchor>
      <arglist>(size_type i) const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>mapGlobalClusterToGlobalProcess</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a1170005b4eefc80994c6ec899126f13a</anchor>
      <arglist>(size_type i) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNDof</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ad651dc219cfa254ecf12dfea4714e6bb</anchor>
      <arglist>(size_type ndof)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNLocalDofWithoutGhost</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a18762ef7ec6d880d04ffc514e63a4617</anchor>
      <arglist>(const size_type proc, const size_type n, bool inWorld=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNLocalDofWithGhost</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a5c0fb95f61ed753347cbd7dabffe135d</anchor>
      <arglist>(const size_type proc, const size_type n, bool inWorld=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFirstDof</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ac96a2fe73d08e0cc8ff017bcb0f78087</anchor>
      <arglist>(const size_type proc, const size_type df, bool inWorld=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLastDof</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a44762edc2fe1bb25f88f3eaed4bdc680</anchor>
      <arglist>(const size_type proc, const size_type df, bool inWorld=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFirstDofGlobalCluster</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>aa7654efa1e55907fc890fdd4accdd94f</anchor>
      <arglist>(const size_type proc, const size_type df, bool inWorld=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLastDofGlobalCluster</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a2eea74aefc266d037fc939e502dd1433</anchor>
      <arglist>(const size_type proc, const size_type df, bool inWorld=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMapGlobalProcessToGlobalCluster</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a4f5a8c33697ff4956a7ac995a966d729</anchor>
      <arglist>(std::vector&lt; size_type &gt; const &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMapGlobalClusterToGlobalProcess</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a2ff77edb8e56a8918619e51d76249acc</anchor>
      <arglist>(std::vector&lt; size_type &gt; const &amp;map)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMapGlobalProcessToGlobalCluster</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ab0b867bdc7d81f7c579dfb865700b105</anchor>
      <arglist>(size_type i, size_type j)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMapGlobalClusterToGlobalProcess</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ac181e9b8bcc000f5552ced7512e3b7bd</anchor>
      <arglist>(size_type i, size_type j)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resizeMapGlobalProcessToGlobalCluster</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ac02cd6adae035b9827e07fc78d687997</anchor>
      <arglist>(size_type n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resizeMapGlobalClusterToGlobalProcess</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>aa980e5ebd94c8e13ac284412e38dcea3</anchor>
      <arglist>(size_type n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateDataInWorld</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>aa34294e5bc6a7578536e81b00924a175</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>closed</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a82765b8ede78b8302d69ebf3a66b76e4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>showMeMapGlobalProcessToGlobalCluster</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>af7c1471f2f216a5aab5b6223407055f2</anchor>
      <arglist>(std::ostream &amp;__out=std::cout) const </arglist>
    </member>
    <member kind="function">
      <type>WorldComm const &amp;</type>
      <name>worldComm</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>aa07d4e34f54b37326adb0389c30687b1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>WorldComm const &amp;</type>
      <name>comm</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>aa275ee2c7198515af1cd44be12ef7095</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>adabd20dc959310d7bbade8785986aae9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>M_closed</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ad2e8906097e7b5c9ed90eacdb1741815</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>size_type</type>
      <name>_M_n_dofs</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a28332572f1180b641b06fcf85bba6fbe</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::vector&lt; size_type &gt;</type>
      <name>_M_n_localWithoutGhost_df</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>abf72cd2fd8a2d6302b816f5ff15d6f84</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::vector&lt; size_type &gt;</type>
      <name>_M_n_localWithGhost_df</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ac41b4c1bb2c71bd4771421fa83947f7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::vector&lt; size_type &gt;</type>
      <name>_M_first_df</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>abd1d034c904a5391b9eceb7fab6b41a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::vector&lt; size_type &gt;</type>
      <name>_M_last_df</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a7f7b69ea53256e1c2042104be211b4ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::vector&lt; size_type &gt;</type>
      <name>_M_first_df_globalcluster</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a243e2fd1627bf4a871446b591aa2d7e1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::vector&lt; size_type &gt;</type>
      <name>_M_last_df_globalcluster</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>aefdbcb0fd2c9a5e56746cdb76b83c7d9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::vector&lt; size_type &gt;</type>
      <name>M_myglobalelements</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>a469674ec8135b3fe66e8fea866941369</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::vector&lt; size_type &gt;</type>
      <name>M_mapGlobalProcessToGlobalCluster</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>adefa1c803646c359e1c8b946a4843f17</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::vector&lt; size_type &gt;</type>
      <name>M_mapGlobalClusterToGlobalProcess</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>ae47f135be738b55b56111cbd4b6fbf1e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>WorldComm</type>
      <name>M_worldComm</name>
      <anchorfile>classFeel_1_1DataMap.html</anchorfile>
      <anchor>aa7c5cb221fa4bb81426cfae5936c2083</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::norm_inf_adaptor</name>
    <filename>structFeel_1_1norm__inf__adaptor.html</filename>
    <member kind="function">
      <type>Real</type>
      <name>operator()</name>
      <anchorfile>structFeel_1_1norm__inf__adaptor.html</anchorfile>
      <anchor>aff6f391bbd758487ac6a9cd9515e1047</anchor>
      <arglist>(E const &amp;__v) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::node</name>
    <filename>structFeel_1_1node.html</filename>
    <templarg>T</templarg>
    <templarg>S</templarg>
    <member kind="typedef">
      <type>ublas::vector&lt; T &gt;</type>
      <name>type</name>
      <anchorfile>structFeel_1_1node.html</anchorfile>
      <anchor>a9d8b838eb2cb99fa87b8ae0869259975</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::matrix_node</name>
    <filename>structFeel_1_1matrix__node.html</filename>
    <templarg>T</templarg>
    <templarg>S</templarg>
    <member kind="typedef">
      <type>ublas::matrix&lt; T, ublas::column_major &gt;</type>
      <name>type</name>
      <anchorfile>structFeel_1_1matrix__node.html</anchorfile>
      <anchor>a8ad5b95a9f791ecb6001a765f934e345</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::GraphCSR</name>
    <filename>classFeel_1_1GraphCSR.html</filename>
    <member kind="typedef">
      <type>GraphCSR</type>
      <name>self_type</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a5e845b8aecf6da2207d1f2a4810e4521</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; self_type &gt;</type>
      <name>self_ptrtype</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a00ecd2de51ec84cfbfa6936f10b9b908</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; size_type &gt;</type>
      <name>nz_type</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a05d11462f6ec25cf321e40c2d8ae7551</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; nz_type &gt;</type>
      <name>nz_ptrtype</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a9cca56d4d7b4acad39c705faf6afb3f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::tuple&lt; size_type, size_type, std::set&lt; size_type &gt; &gt;</type>
      <name>row_type</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>adb5632a6d5691dc48790eec133c88490</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::map&lt; size_type, row_type &gt;</type>
      <name>storage_type</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a8502723502cd917a8896776068c38a0b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; storage_type &gt;</type>
      <name>storage_ptrtype</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a8035ef1a375383c2492a8a115fef0bac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>storage_type::iterator</type>
      <name>iterator</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a8854dacd52348f67fd7bac8c5043ad51</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>storage_type::const_iterator</type>
      <name>const_iterator</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a47d698d514501f74e045880bbbafbd73</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GraphCSR</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>aa5f17134ad2f2d8ed8b23e99a31a7a32</anchor>
      <arglist>(size_type n=0, size_type first_row_entry_on_proc=0, size_type last_row_entry_on_proc=0, size_type first_col_entry_on_proc=0, size_type last_col_entry_on_proc=0, WorldComm const &amp;worldcomm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GraphCSR</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a7ad9b4d2ae630a1ff8a5d9d60929b86a</anchor>
      <arglist>(GraphCSR const &amp;g)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~GraphCSR</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>aea7117105e67f6c2e6c80c823eb1c8b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GraphCSR &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>afcca6fa925777d9f0552544841c42372</anchor>
      <arglist>(GraphCSR const &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>nRows</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a5335adc1551456840535b9460e841f44</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>nCols</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a9ab7630160b8e129d2a5239039791037</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>firstRowEntryOnProc</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>ac70245ce87fcf2b76b1f409b4d6568c2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>lastRowEntryOnProc</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a7de7d5965ac32456da584ac21797c420</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>firstColEntryOnProc</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a48625895488cad635b94aa36f15213b0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>lastColEntryOnProc</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a3b8a5fec59a13899a4b595dbb55f838d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>size</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a4ac3e9dc523d43c570c62a32ff82d7b5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a3524bf1a441fc6306ac40662ddf6e31e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>iterator</type>
      <name>begin</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a6548a5741f94d66b0224e942ccf735d8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>iterator</type>
      <name>end</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a3d7d8fb33669168b9cf30e5516f87b0d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const_iterator</type>
      <name>begin</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>ac9f925aca2d09700be5cb5398fbd500b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const_iterator</type>
      <name>end</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>ace7b2c92c002713be3d5ab53b685749b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>row_type &amp;</type>
      <name>row</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a2c03f5026ab6ba6922eaf525fb55a8c3</anchor>
      <arglist>(size_type i)</arglist>
    </member>
    <member kind="function">
      <type>row_type const &amp;</type>
      <name>row</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a348d43fa242afafe286b6934fbcf26f0</anchor>
      <arglist>(size_type i) const </arglist>
    </member>
    <member kind="function">
      <type>storage_type const &amp;</type>
      <name>storage</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a57048d017a7f4ac8866cc912184442df</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>maxNnz</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>aacbf6f4c4b93dff99696578375954a40</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; size_type &gt; const &amp;</type>
      <name>nNz</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a8420a0e12eb4049a288c28897b3dc5a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; size_type &gt; const &amp;</type>
      <name>nNzOnProc</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>aed0c0a2a616ebd135db62412f8116298</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; size_type &gt; const &amp;</type>
      <name>nNzOffProc</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>ad7a47d2ee9a4f6c59bce7d5b3cee2674</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>WorldComm const &amp;</type>
      <name>worldComm</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>ae1f0c84d18dbbbc938c0fcef3b9d0079</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>nz_type const &amp;</type>
      <name>ia</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a04318b55c690fafa0b088800cd31fde1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>nz_type const &amp;</type>
      <name>ja</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a0278965cb2c171a7f25a09daa53830e3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; double &gt; const &amp;</type>
      <name>a</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a1d4ebd90fd7662b0c060502fce0615b7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; double &gt; &amp;</type>
      <name>a</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>ab385894e64197ca5481dd8b261fe8589</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFirstRowEntryOnProc</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>adf44ab86054a62ab9814d17a51cc68fa</anchor>
      <arglist>(size_type entry)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFirstColEntryOnProc</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a5188fa1ad8554998600eaf317e32c995</anchor>
      <arglist>(size_type entry)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLastRowEntryOnProc</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a5e257fe0f7691f7e6a8bb85d3d88df90</anchor>
      <arglist>(size_type entry)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLastColEntryOnProc</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a4439a8ff260c8582e49b44471f3cc6a9</anchor>
      <arglist>(size_type entry)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zero</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a4c3cb7a6f7039dd14e72c1652861cb54</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a370fb122f61eabfe315a258e93fe5726</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>self_ptrtype</type>
      <name>transpose</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a0d5ee3b41b278a7b1ea401c2a4df6394</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addMissingZeroEntriesDiagonal</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a3900c40c78685297cb5b427dc363d3c3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>showMe</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>a660f3e77197ad93ece6b3309d73c85fb</anchor>
      <arglist>(std::ostream &amp;__out=std::cout) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printPython</name>
      <anchorfile>classFeel_1_1GraphCSR.html</anchorfile>
      <anchor>ae47592f5e256c90b83542bf74c880472</anchor>
      <arglist>(std::string const &amp;nameFile) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::Iteration</name>
    <filename>classFeel_1_1Iteration.html</filename>
    <templarg>Real</templarg>
    <member kind="typedef">
      <type>Real</type>
      <name>NumericalType</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>aa2b19cdcf7dcb39156b0e4edb68e80e8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ublas::type_traits&lt; Real &gt;::value_type</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>a9fd8df165bb0db71d8017b7b5ccdad71</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ublas::type_traits&lt; Real &gt;::real_type</type>
      <name>real_type</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>aea8d39a00e67545530f60e90160f96af</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Iteration &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>ab1421a865a41c10e8d7958dd5308c2e1</anchor>
      <arglist>(Iteration&lt; NumericalType &gt; const &amp;iter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>operator++</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>a8f43323f16f7469a8e1f611958b7fc15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>numberOfIterations</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>a284b91870caf8026dba3dd92303482fb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>real_type</type>
      <name>residual</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>a73b8b37b5e79d8c3ae86fd0c15e28e61</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>real_type</type>
      <name>relativePrecision</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>ad7d647614d187c9a19a78013960b4c33</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>maximumNumberOfIterations</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>a33085e5d7c9ecaacc706523de89869f8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>NumericalType</type>
      <name>initialResidual</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>aa0a84fbcbc5609aa501f75221d799d13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>real_type</type>
      <name>relaxation</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>a07f77b11bf101827b1f065c45c07990d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>iteration</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>adf6c98229a9bd439ec8394beb093fea2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaximumNumberOfIterations</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>acb876bebd50b9f41ca7390d88fdf16ef</anchor>
      <arglist>(int m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRelativePrecision</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>ad17e2fc764d60e4768ccb5acc080d3ee</anchor>
      <arglist>(NumericalType p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setInitialResidual</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>a31bc098fd8e11c1a38c073fa7d9ba7a6</anchor>
      <arglist>(NumericalType ninit)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRelaxation</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>a72dadc7e315f6d619323177330415c60</anchor>
      <arglist>(real_type __w)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isFinished</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>a863927ce2f5952d9c309855aa29b235a</anchor>
      <arglist>(NumericalType r, bool verbose=false)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isFinished</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>a026b0c1ee443f75e17c8c896232fef3b</anchor>
      <arglist>(const VectorX &amp;r, bool verbose=false)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isConverged</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>a2d4b65d675241bc242613129d2d764cd</anchor>
      <arglist>(NumericalType r)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isConverged</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>ad22f9d8fe0060287dfe48eb20272d1f7</anchor>
      <arglist>(VectorX const &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isFirst</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>a4b3f875ef540e0addc22d27fc14bacb3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>a78070ee47d811afab4825c17f7014587</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Iteration</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>a99749bde486ab0272043bb19d9026f89</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>handleEvents</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>afeeedf7b20811dd52c3ce7264ed7a17a</anchor>
      <arglist>(bool __is_finished, bool verbose)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Iteration&lt; NumericalType &gt; *</type>
      <name>New</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>a68145b236686259b84f830a2630c72eb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Iteration</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>abfd1dc7c7a209bbf76c0a59768fb021b</anchor>
      <arglist>(Iteration const &amp;iter)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Iteration</name>
      <anchorfile>classFeel_1_1Iteration.html</anchorfile>
      <anchor>a08f8121f8663bf2884686c8582a96009</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::LU</name>
    <filename>classFeel_1_1LU.html</filename>
    <templarg>MatrixType</templarg>
    <member kind="typedef">
      <type>MatrixType::value_type</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1LU.html</anchorfile>
      <anchor>a39b5b2a42f8b153b8a0febf4e91d1e86</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>MatrixType</type>
      <name>matrix_type</name>
      <anchorfile>classFeel_1_1LU.html</anchorfile>
      <anchor>a8e41c4833412d232146c382defe840cf</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::numeric::ublas::vector&lt; value_type &gt;</type>
      <name>vector_type</name>
      <anchorfile>classFeel_1_1LU.html</anchorfile>
      <anchor>aa143616a166de895fea83acfc24cd7ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::numeric::ublas::vector&lt; uint &gt;</type>
      <name>vector_uint_type</name>
      <anchorfile>classFeel_1_1LU.html</anchorfile>
      <anchor>ab418b23a835609e39ba690c58e28760a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LU</name>
      <anchorfile>classFeel_1_1LU.html</anchorfile>
      <anchor>a3dff1dd8de836298409aafc6ace10513</anchor>
      <arglist>(const matrix_type &amp;A)</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>isNonsingular</name>
      <anchorfile>classFeel_1_1LU.html</anchorfile>
      <anchor>a792275010a8fc9954b4c7bbb6bcf5dad</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>matrix_type</type>
      <name>getL</name>
      <anchorfile>classFeel_1_1LU.html</anchorfile>
      <anchor>a91d9e6bf57024b3e69b5f2126aa29b47</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>matrix_type</type>
      <name>getU</name>
      <anchorfile>classFeel_1_1LU.html</anchorfile>
      <anchor>a5b28da2907dd05e3168d8b2fc68a16f3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>vector_uint_type</type>
      <name>getPivot</name>
      <anchorfile>classFeel_1_1LU.html</anchorfile>
      <anchor>a3fb3a499d274605f12cfbe2f12f41613</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>det</name>
      <anchorfile>classFeel_1_1LU.html</anchorfile>
      <anchor>a8e21b67e0eaa807aeddf80fa355fa1d0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>inverse</name>
      <anchorfile>classFeel_1_1LU.html</anchorfile>
      <anchor>a65caeb4b5734f1e01969c476d5e29f4e</anchor>
      <arglist>(matrix_type &amp;__inv)</arglist>
    </member>
    <member kind="function">
      <type>matrix_type</type>
      <name>solve</name>
      <anchorfile>classFeel_1_1LU.html</anchorfile>
      <anchor>ad57726585342fbd9c23657adf6e50869</anchor>
      <arglist>(const matrix_type &amp;B)</arglist>
    </member>
    <member kind="function">
      <type>vector_type</type>
      <name>solve</name>
      <anchorfile>classFeel_1_1LU.html</anchorfile>
      <anchor>a24265632f581b250995e155168eceef3</anchor>
      <arglist>(const vector_type &amp;b)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::BlocksBaseSparseMatrix</name>
    <filename>classFeel_1_1BlocksBaseSparseMatrix.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>vf::BlocksBase&lt; boost::shared_ptr&lt; MatrixSparse&lt; T &gt; &gt; &gt;</type>
      <name>super_type</name>
      <anchorfile>classFeel_1_1BlocksBaseSparseMatrix.html</anchorfile>
      <anchor>aaeb13698ba0ad1832fe5056c1cbe7533</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>BlocksBaseSparseMatrix&lt; T &gt;</type>
      <name>self_type</name>
      <anchorfile>classFeel_1_1BlocksBaseSparseMatrix.html</anchorfile>
      <anchor>a20500f91fd860350e7076e020431b4e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; MatrixSparse&lt; T &gt; &gt;</type>
      <name>matrix_sparse_ptrtype</name>
      <anchorfile>classFeel_1_1BlocksBaseSparseMatrix.html</anchorfile>
      <anchor>a9e859d17aeb9a6e6a2c396ad11cb828f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BlocksBaseSparseMatrix</name>
      <anchorfile>classFeel_1_1BlocksBaseSparseMatrix.html</anchorfile>
      <anchor>ac9ba791557daced2368630b58a610e32</anchor>
      <arglist>(uint16_type nr, uint16_type nc)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BlocksBaseSparseMatrix</name>
      <anchorfile>classFeel_1_1BlocksBaseSparseMatrix.html</anchorfile>
      <anchor>a25062df888b18257695f90dc4ac55cb6</anchor>
      <arglist>(super_type const &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>self_type</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1BlocksBaseSparseMatrix.html</anchorfile>
      <anchor>a0147e174920262a2ce88ddeba9db2078</anchor>
      <arglist>(matrix_sparse_ptrtype const &amp;m) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::BlocksSparseMatrix</name>
    <filename>classFeel_1_1BlocksSparseMatrix.html</filename>
    <templarg>NR</templarg>
    <templarg>NC</templarg>
    <templarg></templarg>
    <base>Feel::BlocksBaseSparseMatrix</base>
    <member kind="typedef">
      <type>BlocksBaseSparseMatrix&lt; T &gt;</type>
      <name>super_type</name>
      <anchorfile>classFeel_1_1BlocksSparseMatrix.html</anchorfile>
      <anchor>a8e12d995020e108662bf3d2d44011cd9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>NBLOCKROWS</name>
      <anchorfile>classFeel_1_1BlocksSparseMatrix.html</anchorfile>
      <anchor>a814fbf454c36045252c6668d8ecd6d6e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>NBLOCKCOLS</name>
      <anchorfile>classFeel_1_1BlocksSparseMatrix.html</anchorfile>
      <anchor>a1cd66ad6193c7638e88ecd6eff98742e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::MatrixBlockBase</name>
    <filename>classFeel_1_1MatrixBlockBase.html</filename>
    <templarg>T</templarg>
    <base>Feel::MatrixSparse</base>
    <member kind="typedef">
      <type>MatrixBlockBase&lt; T &gt;</type>
      <name>self_type</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>ad86d5e5468ba93a392090b618e2ac95b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::value_type</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a4b1c988b9386d9224b3f406ba480bc85</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::real_type</type>
      <name>real_type</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>ac1151da8948fc43753a070461217eb2a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Backend&lt; value_type &gt;</type>
      <name>backend_type</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a043f8b273cdab6e977bb074a0b89cd0b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; backend_type &gt;</type>
      <name>backend_ptrtype</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a50f07e2a29ced96c6e8b42652c4049b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super</type>
      <name>matrix_type</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>ae803260d465847ede81fbadc48b056b4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; matrix_type &gt;</type>
      <name>matrix_ptrtype</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a34fa74f2fb935688f541944a906c22c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; matrix_ptrtype &gt;</type>
      <name>vector_matrix_ptrtype</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a278cc9e4c0831da73328ba8c1303c501</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::graph_type</type>
      <name>graph_type</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>acdb06ec80b1966e1fcfb0720d136337a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::graph_ptrtype</type>
      <name>graph_ptrtype</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a834fbeed0673d0fb39d5f1370460c14a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MatrixBlockBase</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>acc9e6ed4c8a38c6f3701bc3ee3719cae</anchor>
      <arglist>(vf::BlocksBase&lt; matrix_ptrtype &gt; const &amp;blockSet, backend_type &amp;backend, bool copy_values=true, bool diag_is_nonzero=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mergeBlockGraph</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a791d3025877ebb5a7abbeb8f9727c614</anchor>
      <arglist>(graph_ptrtype &amp;globGraphb, matrix_ptrtype m, size_type start_i, size_type start_j)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MatrixBlockBase</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a43f8bc4e32ec10c7d57ce52886562251</anchor>
      <arglist>(MatrixBlockBase const &amp;mb)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~MatrixBlockBase</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>af2035642c595461ae1e74e1b6bea670c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>MatrixBlockBase</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a751432539ca21207d57ef4415a080faf</anchor>
      <arglist>(MatrixBlockBase const &amp;mb)</arglist>
    </member>
    <member kind="function">
      <type>matrix_ptrtype</type>
      <name>getSparseMatrix</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>ab52c626603c25c2c8f8b1fbeab75a4d5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a7eb2c8b17d13b36de7dfd86750a91ae9</anchor>
      <arglist>(const size_type m, const size_type n, const size_type m_l, const size_type n_l, const size_type nnz=30, const size_type noz=10)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>adaf3ef1a126987ee0d291b7cea5707cf</anchor>
      <arglist>(const size_type m, const size_type n, const size_type m_l, const size_type n_l, graph_ptrtype const &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>aa5514d5a312fcfddb9b7d2fb339ea555</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zero</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a91d6ac02dc4c07dee90d3e0a62a6df9f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zero</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a1fe43f8b51bee4fb581684dfe1d0bba0</anchor>
      <arglist>(size_type start1, size_type size1, size_type start2, size_type size2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>ae0177dd69028062b258de7c68e65a862</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>size1</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a534ab01773e0da316c981e8c9f2bded8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>size2</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a20d1cbb82a50d87a4e99878d6324e21c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>rowStart</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>addd681b9a3ac9f89b6e4edb6488ab244</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>rowStop</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a8bd9fcd227e227c47dad811c2e7eeb50</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a0ea4b9be6c1a5890cad8a78e724e9142</anchor>
      <arglist>(const size_type i, const size_type j, const value_type &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>af550fe214a3c11128ce37634085a1f96</anchor>
      <arglist>(const size_type i, const size_type j, const value_type &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addMatrix</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a240cf6d9a0f761be725e3eda8d1f3406</anchor>
      <arglist>(const ublas::matrix&lt; value_type &gt; &amp;dm, const std::vector&lt; size_type &gt; &amp;rows, const std::vector&lt; size_type &gt; &amp;cols)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addMatrix</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a963b538c70afccee50d2b99b61a76ff8</anchor>
      <arglist>(int *rows, int nrows, int *cols, int ncols, value_type *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addMatrix</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a9ee4ba046f56ffed9a4a13c8e4bac8c0</anchor>
      <arglist>(const ublas::matrix&lt; value_type &gt; &amp;dm, const std::vector&lt; size_type &gt; &amp;dof_indices)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addMatrix</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>abca008e7a94f80e63ba5ec3e9a78ad69</anchor>
      <arglist>(const value_type, MatrixSparse&lt; value_type &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scale</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a96593ef6ece0177bd5abfe43b0e0230d</anchor>
      <arglist>(const value_type)</arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>operator()</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>aaab63ede38f2a1a93889d0c692b22515</anchor>
      <arglist>(const size_type i, const size_type j) const </arglist>
    </member>
    <member kind="function">
      <type>self_type &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a69a31e60cf484425bc9bb25db17536be</anchor>
      <arglist>(MatrixSparse&lt; value_type &gt; const &amp;M)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>diagonal</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a118a09fb8a2d451ab9c1cd6460425065</anchor>
      <arglist>(Vector&lt; value_type &gt; &amp;out) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transpose</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>ae7580474c2b29c103fa5008a92e4355d</anchor>
      <arglist>(MatrixSparse&lt; value_type &gt; &amp;Mt) const </arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>energy</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a2570ad512eb22765063fc3f98966b4ff</anchor>
      <arglist>(Vector&lt; value_type &gt; const &amp;__v, Vector&lt; value_type &gt; const &amp;__u, bool transpose=false) const </arglist>
    </member>
    <member kind="function">
      <type>real_type</type>
      <name>l1Norm</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a6659ff904ea7207c060763889ecb9b3f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>real_type</type>
      <name>linftyNorm</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a533a85670fd7f27ed937ae0dbcfaf064</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>closed</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a50ca3e84ef0c3f2d109129d102ec19b3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>ae013412ffa3c4dfc6344492fcd05d940</anchor>
      <arglist>(std::ostream &amp;os=std::cout) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printPersonal</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a018ac96f9cc0be8b4e439ea3cfb5c666</anchor>
      <arglist>(std::ostream &amp;=std::cout) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printMatlab</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a6437ebfdd57d63ab5b75433b82efdc21</anchor>
      <arglist>(const std::string name=&quot;NULL&quot;) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>createSubmatrix</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a01db4c97e783e3668ba6e6018a7962f8</anchor>
      <arglist>(MatrixSparse&lt; value_type &gt; &amp;submatrix, const std::vector&lt; size_type &gt; &amp;rows, const std::vector&lt; size_type &gt; &amp;cols) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reinitSubmatrix</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>abad7262f68bec7daa546e663427c4e40</anchor>
      <arglist>(MatrixSparse&lt; value_type &gt; &amp;submatrix, const std::vector&lt; size_type &gt; &amp;rows, const std::vector&lt; size_type &gt; &amp;cols) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zeroRows</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>aca49dc68bc19cc98846ab84aef03bf6c</anchor>
      <arglist>(std::vector&lt; int &gt; const &amp;rows, std::vector&lt; value_type &gt; const &amp;values, Vector&lt; value_type &gt; &amp;rhs, Context const &amp;on_context)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateBlockMat</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>a4ff33b9346d05fac68c63cea8fc92cb4</anchor>
      <arglist>(boost::shared_ptr&lt; MatrixSparse&lt; value_type &gt; &gt; m, size_type start_i, size_type start_j)</arglist>
    </member>
    <member kind="friend">
      <type>friend std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1MatrixBlockBase.html</anchorfile>
      <anchor>af154a6d470908d4e78f71af90892b566</anchor>
      <arglist>(std::ostream &amp;os, const MatrixSparse&lt; U &gt; &amp;m)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::MatrixBlock</name>
    <filename>classFeel_1_1MatrixBlock.html</filename>
    <templarg>NR</templarg>
    <templarg>NC</templarg>
    <templarg></templarg>
    <base>Feel::MatrixBlockBase</base>
    <member kind="typedef">
      <type>super_type::value_type</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1MatrixBlock.html</anchorfile>
      <anchor>ae7fe011c9a2cca36a647a73ab7eb7305</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super_type::matrix_ptrtype</type>
      <name>matrix_ptrtype</name>
      <anchorfile>classFeel_1_1MatrixBlock.html</anchorfile>
      <anchor>a84e6960d37dc37967cfe6c557864cc79</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super_type::backend_type</type>
      <name>backend_type</name>
      <anchorfile>classFeel_1_1MatrixBlock.html</anchorfile>
      <anchor>a3e97138bc4e3a3578bb52daf68b6a9c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>vf::Blocks&lt; NBLOCKROWS, NBLOCKCOLS, matrix_ptrtype &gt;</type>
      <name>blocks_type</name>
      <anchorfile>classFeel_1_1MatrixBlock.html</anchorfile>
      <anchor>ac813b07f5009a5f80c7e3965e85f851c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>vf::BlocksBase&lt; matrix_ptrtype &gt;</type>
      <name>blocksbase_type</name>
      <anchorfile>classFeel_1_1MatrixBlock.html</anchorfile>
      <anchor>aab04f496f23660d4ee1f6d45d434352a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MatrixBlock</name>
      <anchorfile>classFeel_1_1MatrixBlock.html</anchorfile>
      <anchor>acebf610465198ed966ed26262c024ec2</anchor>
      <arglist>(blocksbase_type const &amp;blockSet, backend_type &amp;backend, bool copy_values=true, bool diag_is_nonzero=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MatrixBlock</name>
      <anchorfile>classFeel_1_1MatrixBlock.html</anchorfile>
      <anchor>af9c6e13c2e5ea290a10cd700951650af</anchor>
      <arglist>(MatrixBlock const &amp;mb)</arglist>
    </member>
    <member kind="function">
      <type>MatrixBlock</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1MatrixBlock.html</anchorfile>
      <anchor>acf30c973da84881469665549b6836939</anchor>
      <arglist>(MatrixBlock const &amp;mb)</arglist>
    </member>
    <member kind="function">
      <type>MatrixBlock &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1MatrixBlock.html</anchorfile>
      <anchor>a439f1675a0413f20fc3da7a5c7a63cb4</anchor>
      <arglist>(matrix_ptrtype const &amp;M)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>NBLOCKROWS</name>
      <anchorfile>classFeel_1_1MatrixBlock.html</anchorfile>
      <anchor>a8b1befb1f637ea20c8f79456eedeba7d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>NBLOCKCOLS</name>
      <anchorfile>classFeel_1_1MatrixBlock.html</anchorfile>
      <anchor>a2a5835cc1714f73e62eaaed98b6e15eb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>NBLOCKSIZE</name>
      <anchorfile>classFeel_1_1MatrixBlock.html</anchorfile>
      <anchor>ac68ba6864f21fb11585910b70d770a9b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::MatrixGmm</name>
    <filename>classFeel_1_1MatrixGmm.html</filename>
    <templarg>T</templarg>
    <templarg>LayoutType</templarg>
    <base>Feel::MatrixSparse</base>
    <member kind="function">
      <type></type>
      <name>MatrixGmm</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>afd8d43690b7a31e42e7b4bf4aae21227</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MatrixGmm</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a5dea99e2a30249160fb8fe63030312d8</anchor>
      <arglist>(size_type r, size_type c)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MatrixGmm</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>aefadf2566ab965f4ade3ef2f1ab0670b</anchor>
      <arglist>(MatrixGmm const &amp;m)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~MatrixGmm</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>aea12a8aab045b8674510cd2022ce6d82</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>MatrixGmm&lt; T, LayoutType &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a53ffc3e7cdaca74985f6dcb06ba3a10c</anchor>
      <arglist>(MatrixSparse&lt; value_type &gt; const &amp;M)</arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>operator()</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a6a6cdfac591f44924dc0e58dad9a73b2</anchor>
      <arglist>(size_type i, size_type j) const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>size1</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a9e6a053951acb281fafe8327c3b1f90a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>size2</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>aae38704f33f8994e2889756375d5f196</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>nnz</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a656d8ade72662db345fd5c17c108c7f7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>rowStart</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>ade2acadcaf9f18cfa030360ab7ca28f6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>rowStop</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a35bdc54365da5168299aa59e8502d6f3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isInitialized</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a4c6eb65cfa6ffecfa7a8b035085f2b97</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>aae09be2b4e43def36fe93e43293f971b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>closed</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>aea7cd9d78f128615bf72786d2a7b3d67</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>matrix_type const &amp;</type>
      <name>mat</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a9fe97f9d271e1c881913673223cc12b8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>matrix_type &amp;</type>
      <name>mat</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a530c3dda2076e8be155f6a7b1b9cec0a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>write_matrix_type const &amp;</type>
      <name>wmat</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>aa887c3b88cb5cb8764b45985677b42ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>write_matrix_type &amp;</type>
      <name>wmat</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>afa5bb8e62a10629def929b9053d194c9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a4375cdabc209ee175b937661a1a3bfdb</anchor>
      <arglist>(const size_type m, const size_type n, const size_type m_l, const size_type n_l, const size_type nnz=30, const size_type noz=10)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a673d9024f48ea1076ea0a84ff9f8aa5d</anchor>
      <arglist>(const size_type m, const size_type n, const size_type m_l, const size_type n_l, graph_ptrtype const &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a6157a799d843cf5c32b0a083b958dc84</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zero</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a2975884fcab057de51c934ab5b360d67</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zero</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a32b2d66d14cef2ae8cf696ee4acea5ea</anchor>
      <arglist>(size_type start1, size_type stop1, size_type start2, size_type stop2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a9f9a9a082cfd5da9082e5aa8b16fc379</anchor>
      <arglist>(const size_type i, const size_type j, const value_type &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>ac9c9f954c39f49c4e2d7d5c3d19202a6</anchor>
      <arglist>(const size_type i, const size_type j, const value_type &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printMatlab</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>aa45468d6f12c94aff0be4cdf70c14b41</anchor>
      <arglist>(const std::string name=&quot;NULL&quot;) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a00e8ba77de1a3bd0b85357c246e4d9fc</anchor>
      <arglist>(pattern_type const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a4a3f86d326213c954355222de56bb722</anchor>
      <arglist>(size_type nr, size_type nc, bool=false)</arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>energy</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>af5cf7468943025048fa17620e1ff7b0a</anchor>
      <arglist>(Vector&lt; value_type &gt; const &amp;__v, Vector&lt; value_type &gt; const &amp;__u, bool transpose=false) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zeroRows</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a8d8eb60bc422eabe934fd5f7ef255f94</anchor>
      <arglist>(std::vector&lt; int &gt; const &amp;rows, std::vector&lt; value_type &gt; const &amp;values, Vector&lt; value_type &gt; &amp;rhs, Context const &amp;on_context)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a36cb29d83e544d2adb680e7a80d22c6b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addMatrix</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a7e8b32885699ecad03279d39de647ebc</anchor>
      <arglist>(const ublas::matrix&lt; T, ublas::row_major &gt; &amp;, const std::vector&lt; size_type &gt; &amp;, const std::vector&lt; size_type &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addMatrix</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>ab3ef58fae79bbc8bd7ce6f844b5e2dfb</anchor>
      <arglist>(const boost::numeric::ublas::matrix&lt; T, ublas::row_major &gt; &amp;, const std::vector&lt; size_type &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addMatrix</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>af747121daece48b696839baf7492708a</anchor>
      <arglist>(value_type v, MatrixSparse&lt; value_type &gt; &amp;_m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addMatrix</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>acf2b88a9d9455fa2177eec1c5808fd58</anchor>
      <arglist>(int *rows, int nrows, int *cols, int ncols, value_type *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scale</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a0fca70dbcb7ca89b1a1b503e7c5752d5</anchor>
      <arglist>(const T a)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transpose</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a03b53075f992440470e97f52bdda38ab</anchor>
      <arglist>(MatrixSparse&lt; value_type &gt; &amp;Mt) const </arglist>
    </member>
    <member kind="function">
      <type>real_type</type>
      <name>l1Norm</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a21fb41905422153eb9852b8051b71f57</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>real_type</type>
      <name>linftyNorm</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a801fd663fc8dc7ce9fca68740c50ea06</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateBlockMat</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a3eb9a2669a9622dbcaeedbb82280c51f</anchor>
      <arglist>(boost::shared_ptr&lt; MatrixSparse&lt; value_type &gt; &gt; m, size_type start_i, size_type start_j)</arglist>
    </member>
    <member kind="typedef">
      <type>T</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>aaa5819eeada45ec5bd27d8b00f7c5edb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>type_traits&lt; value_type &gt;::real_type</type>
      <name>real_type</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a953e197bbdb9bb74fb635135dfaaf927</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mpl::if_&lt; boost::is_same&lt; LayoutType, gmm::row_major &gt;, mpl::identity&lt; gmm::csr_matrix&lt; value_type &gt; &gt;, typename mpl::if_&lt; boost::is_same&lt; LayoutType, gmm::col_major &gt;, mpl::identity&lt; gmm::csc_matrix&lt; value_type &gt; &gt;, mpl::identity&lt; boost::none_t &gt; &gt;::type &gt;::type::type</type>
      <name>matrix_type</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a90c330ff050b545b67efbafde90ee2f5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; std::set&lt; size_type &gt; &gt;</type>
      <name>pattern_type</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a269175d34b969e1996c3c126caabccae</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>gmm::row_matrix&lt; gmm::wsvector&lt; value_type &gt; &gt;</type>
      <name>write_matrix_type</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>ac10e90cb62dcf88b563d5fdd62198865</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::graph_type</type>
      <name>graph_type</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a822993968ffb21f8de9e825897aee426</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::graph_ptrtype</type>
      <name>graph_ptrtype</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>a526610a6f82c49870fe70fa5fdc5ad76</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const bool</type>
      <name>is_row_major</name>
      <anchorfile>classFeel_1_1MatrixGmm.html</anchorfile>
      <anchor>ab1300be1286c80b36837c1ae654fab54</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::MatrixShell</name>
    <filename>classFeel_1_1MatrixShell.html</filename>
    <templarg>T</templarg>
    <member kind="typedef">
      <type>T</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1MatrixShell.html</anchorfile>
      <anchor>ac9cd450105c3c17e4b92c64fc1f56f02</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>type_traits&lt; T &gt;::real_type</type>
      <name>real_type</name>
      <anchorfile>classFeel_1_1MatrixShell.html</anchorfile>
      <anchor>a844c5a0488ad386e468f5fd085697d19</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Vector&lt; T &gt;</type>
      <name>vector_type</name>
      <anchorfile>classFeel_1_1MatrixShell.html</anchorfile>
      <anchor>a138803aa06f9cac8a6a92445a019ca04</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; Vector&lt; T &gt; &gt;</type>
      <name>vector_ptrtype</name>
      <anchorfile>classFeel_1_1MatrixShell.html</anchorfile>
      <anchor>a76b5fec4c8bc4395040e55bfc7da6dec</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MatrixShell</name>
      <anchorfile>classFeel_1_1MatrixShell.html</anchorfile>
      <anchor>a035142c6a257e68f85ee54c6ea85e728</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MatrixShell</name>
      <anchorfile>classFeel_1_1MatrixShell.html</anchorfile>
      <anchor>a0cac404fefeea737b231f31231ad5157</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual size_type</type>
      <name>size1</name>
      <anchorfile>classFeel_1_1MatrixShell.html</anchorfile>
      <anchor>aecc5d1e15021128e822ce6709f4fc39a</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual size_type</type>
      <name>size2</name>
      <anchorfile>classFeel_1_1MatrixShell.html</anchorfile>
      <anchor>a8286e10770404cd36aa9341da78e3d18</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>diagonal</name>
      <anchorfile>classFeel_1_1MatrixShell.html</anchorfile>
      <anchor>a479afdacd3cae1a6ec91bd1ea0d43901</anchor>
      <arglist>(vector_type &amp;v) const =0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>diagonal</name>
      <anchorfile>classFeel_1_1MatrixShell.html</anchorfile>
      <anchor>a58358804c9503a21145d76c29ee4aa9d</anchor>
      <arglist>(boost::shared_ptr&lt; Vector&lt; T &gt; &gt; &amp;dest) const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>multVector</name>
      <anchorfile>classFeel_1_1MatrixShell.html</anchorfile>
      <anchor>a657548bd12840bd075adf6ed6523dbe9</anchor>
      <arglist>(vector_type const &amp;in, vector_type &amp;out) const =0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multVector</name>
      <anchorfile>classFeel_1_1MatrixShell.html</anchorfile>
      <anchor>a8ba5b110aa1ba87b7edaff12b4656cd7</anchor>
      <arglist>(const boost::shared_ptr&lt; Vector&lt; T &gt; &gt; &amp;arg, boost::shared_ptr&lt; Vector&lt; T &gt; &gt; &amp;dest) const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>multAddVector</name>
      <anchorfile>classFeel_1_1MatrixShell.html</anchorfile>
      <anchor>a1314bfaca7e46a62f5a3646bc9d8cfd6</anchor>
      <arglist>(vector_type const &amp;in, vector_type &amp;out) const =0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multAddVector</name>
      <anchorfile>classFeel_1_1MatrixShell.html</anchorfile>
      <anchor>a4f3318cd634c0022116d92cc9cb295f4</anchor>
      <arglist>(const boost::shared_ptr&lt; Vector&lt; T &gt; &gt; &amp;arg, boost::shared_ptr&lt; Vector&lt; T &gt; &gt; &amp;dest) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::MatrixShellSparse</name>
    <filename>classFeel_1_1MatrixShellSparse.html</filename>
    <templarg></templarg>
    <base>Feel::MatrixShell</base>
    <member kind="typedef">
      <type>super::value_type</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1MatrixShellSparse.html</anchorfile>
      <anchor>a05494777fd20123bf16e46b8c2db6f0a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::real_type</type>
      <name>real_type</name>
      <anchorfile>classFeel_1_1MatrixShellSparse.html</anchorfile>
      <anchor>a317e7e224879e78fca6a3853d5c78e3d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>MatrixSparse&lt; value_type &gt;</type>
      <name>sparse_matrix_type</name>
      <anchorfile>classFeel_1_1MatrixShellSparse.html</anchorfile>
      <anchor>aae8323df1109b3f765926a47e8b9b16f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; sparse_matrix_type &gt;</type>
      <name>sparse_matrix_ptrtype</name>
      <anchorfile>classFeel_1_1MatrixShellSparse.html</anchorfile>
      <anchor>afc28b35a5c71a3016695cbb2a0b90694</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::vector_type</type>
      <name>vector_type</name>
      <anchorfile>classFeel_1_1MatrixShellSparse.html</anchorfile>
      <anchor>a5d3927c1de5dac6798bc9627c8fab057</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::vector_ptrtype</type>
      <name>vector_ptrtype</name>
      <anchorfile>classFeel_1_1MatrixShellSparse.html</anchorfile>
      <anchor>a024b25cacb968f965586b95b3d2ce047</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MatrixShellSparse</name>
      <anchorfile>classFeel_1_1MatrixShellSparse.html</anchorfile>
      <anchor>ab72ed78c58774d761442e405ffe01168</anchor>
      <arglist>(sparse_matrix_ptrtype m)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~MatrixShellSparse</name>
      <anchorfile>classFeel_1_1MatrixShellSparse.html</anchorfile>
      <anchor>a3fd4a81891c3ebf4f1d3633525ea40cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual size_type</type>
      <name>size1</name>
      <anchorfile>classFeel_1_1MatrixShellSparse.html</anchorfile>
      <anchor>a3f2b4566f7658f51af1107c8a8edfb39</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual size_type</type>
      <name>size2</name>
      <anchorfile>classFeel_1_1MatrixShellSparse.html</anchorfile>
      <anchor>aecd6c3fa0ac26c118af4d355316c61b3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>diagonal</name>
      <anchorfile>classFeel_1_1MatrixShellSparse.html</anchorfile>
      <anchor>ab63e558380cb3c96ea408c1cb86b5b21</anchor>
      <arglist>(vector_type &amp;v) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multVector</name>
      <anchorfile>classFeel_1_1MatrixShellSparse.html</anchorfile>
      <anchor>a505e9da702a73590eb82e99c494b3832</anchor>
      <arglist>(vector_type const &amp;in, vector_type &amp;out) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multAddVector</name>
      <anchorfile>classFeel_1_1MatrixShellSparse.html</anchorfile>
      <anchor>afa522e98c337dcce567aa17435f1ba8b</anchor>
      <arglist>(vector_type const &amp;in, vector_type &amp;out) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::MatrixSparse</name>
    <filename>classFeel_1_1MatrixSparse.html</filename>
    <templarg>T</templarg>
    <member kind="typedef">
      <type>T</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>aad48603a9b89f11f28ac4e7d91aae5a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>type_traits&lt; T &gt;::real_type</type>
      <name>real_type</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a6b08cb0037519828ae2b3fca9d0ab64b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GraphCSR</type>
      <name>graph_type</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a4f0ecbc0fd205e0811590a1a2d5adedb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; graph_type &gt;</type>
      <name>graph_ptrtype</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a848f6bb588c1923cebcac47a4bc5f8ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Vector&lt; T &gt;</type>
      <name>vector_type</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a55ae9bbda7f145ab9b7a7db6e047af93</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; Vector&lt; T &gt; &gt;</type>
      <name>vector_ptrtype</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a16b4dad0e1848972efee54ad1c8d039e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MatrixSparse</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>ad1148862cd03b6386843944e3d5452bf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MatrixSparse</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a720364aa81d1f96e45df9e32eb9c8c4f</anchor>
      <arglist>(DataMap const &amp;dmRow, DataMap const &amp;dmCol, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MatrixSparse</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>acb37362d6cff7fc03e286eda7d2788ba</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DataMap const &amp;</type>
      <name>mapRow</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a4bcf7104d63d374a7c5bd4c1c244e4f8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DataMap const &amp;</type>
      <name>mapCol</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>aa1a44f177dd5905ba99d671f8973df1a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMapRow</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a1829a3c9be213e522909f8c52bcdc188</anchor>
      <arglist>(DataMap const &amp;d)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMapCol</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a5890a69b9948d1151d306e0abe96add0</anchor>
      <arglist>(DataMap const &amp;d)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isInitialized</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a461579bfbd52021b74079be657677162</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>updateSparsityPattern</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>add28dc9976b0a149d2816cc881cc4037</anchor>
      <arglist>(const std::vector&lt; std::vector&lt; size_type &gt; &gt; &amp;)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a912ef58fbd90fbad544f010b25310065</anchor>
      <arglist>(const size_type m, const size_type n, const size_type m_l, const size_type n_l, const size_type nnz=30, const size_type noz=10)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a8793f66e8e5daca00fd0daeb6ec0b8da</anchor>
      <arglist>(const size_type m, const size_type n, const size_type m_l, const size_type n_l, graph_ptrtype const &amp;graph)=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setIndexSplit</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a58cd69e3eedd8ef74f910dea12b77f9b</anchor>
      <arglist>(std::vector&lt; std::vector&lt; int &gt; &gt; const &amp;_indexSplit)</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; std::vector&lt; int &gt; &gt;</type>
      <name>indexSplit</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a5f5f5a21e553d97b1575d165093890dc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasGraph</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>ac84662d75dd20f2f4bcc41ae908f97b8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>graph_ptrtype const &amp;</type>
      <name>graph</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a0315c9ee1b093a1f89d6dacbfe56d245</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGraph</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>ae6f6ea8901e8df74735b6bf16f62ec38</anchor>
      <arglist>(graph_ptrtype const &amp;graph)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMatrixProperties</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a34202ecd63a380eb35a65944720de4f9</anchor>
      <arglist>(size_type p)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isHermitian</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a978809a6f1d66fb72785aed7f174a186</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNonHermitian</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>aa94df32a1d545ff47b83d11bc7b14ee5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isHermitianPositiveDefinite</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a8569b5ca72c200d49d809621deacb5b3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isSingular</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>ad86adae963002e54dbb852408b7286bb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isPositiveDefinite</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>af063975c7023be476717bd95d5a2764e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>haveConsistentProperties</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a78d06f28ea90fff25092d63db820deed</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>checkProperties</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a6732a796c995d4cb15671ca57cc30afe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>WorldComm const &amp;</type>
      <name>comm</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>afc5c209b88e9a14332ae395e2b8d9309</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>clear</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>ae05699de2637646583a3df40e5157609</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>zero</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a86b388887b1de2436fb1a870194b9094</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>zero</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a6127986ed9b1bcd2a5c61e9b3e5b716b</anchor>
      <arglist>(size_type start1, size_type size1, size_type start2, size_type size2)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>close</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a473eba28aae1b62ddd1e531768be2c56</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual size_type</type>
      <name>size1</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a45f5d30f75f23a6a9c39e2de2ffd4ff2</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual size_type</type>
      <name>size2</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a67d70a92c696bf3c398d8f1ba3515674</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual size_type</type>
      <name>rowStart</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a9d86cf00a8b2f300ea35343b435584fc</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual size_type</type>
      <name>rowStop</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>afecd0afd3539f36ffdb8b27390e62fed</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>set</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>ac0333712d390479a5935088518fe5496</anchor>
      <arglist>(const size_type i, const size_type j, const value_type &amp;value)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>add</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>ada6dc78edf86b4f893e6942c0c9cc5e8</anchor>
      <arglist>(const size_type i, const size_type j, const value_type &amp;value)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>addMatrix</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a2bf1685918b0346985a4647e3a40e3d8</anchor>
      <arglist>(const ublas::matrix&lt; value_type &gt; &amp;dm, const std::vector&lt; size_type &gt; &amp;rows, const std::vector&lt; size_type &gt; &amp;cols)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>addMatrix</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a33caeb6c75d28713b17a5c7cead5d475</anchor>
      <arglist>(int *rows, int nrows, int *cols, int ncols, value_type *data)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>addMatrix</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>aa4dca4dcd7b153818229139706d8d30c</anchor>
      <arglist>(const ublas::matrix&lt; value_type &gt; &amp;dm, const std::vector&lt; size_type &gt; &amp;dof_indices)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>addMatrix</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a96089b112fb4ba40acb3d293ad81fdca</anchor>
      <arglist>(const T, MatrixSparse&lt; T &gt; &amp;)=0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addMatrix</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a992715a69e0743b3361235a04ef94414</anchor>
      <arglist>(const T &amp;s, boost::shared_ptr&lt; MatrixSparse&lt; T &gt; &gt; &amp;m)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>scale</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a673a688afee4f06967f2cd9d7a001d7c</anchor>
      <arglist>(const T)=0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multVector</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>ad548593f82873423f64d35c0b46fc312</anchor>
      <arglist>(const Vector&lt; T &gt; &amp;arg, Vector&lt; T &gt; &amp;dest) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multVector</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>afb193ee2665ec9ab3fc06d71c41e5c19</anchor>
      <arglist>(const boost::shared_ptr&lt; Vector&lt; T &gt; &gt; &amp;arg, boost::shared_ptr&lt; Vector&lt; T &gt; &gt; &amp;dest) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multAddVector</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a1a83d87ef6d24ecc68494cc05cb6667a</anchor>
      <arglist>(const Vector&lt; T &gt; &amp;arg, Vector&lt; T &gt; &amp;dest) const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual T</type>
      <name>operator()</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a71f480700bcd3a918ed0925de10cd460</anchor>
      <arglist>(const size_type i, const size_type j) const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual MatrixSparse&lt; T &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a9b4ac4599b1a36309c741d27547bc660</anchor>
      <arglist>(MatrixSparse&lt; value_type &gt; const &amp;M)=0</arglist>
    </member>
    <member kind="function">
      <type>MatrixSparse&lt; T &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>aeb1718cc16429b8e3e31db31a9c6cdda</anchor>
      <arglist>(boost::shared_ptr&lt; MatrixSparse&lt; value_type &gt; &gt; const &amp;M)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>diagonal</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a0b125a43ee70bfe128ca4f174213959f</anchor>
      <arglist>(Vector&lt; T &gt; &amp;dest) const =0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>diagonal</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a8e94e17bd426ae3d89dc7bea160d2932</anchor>
      <arglist>(boost::shared_ptr&lt; Vector&lt; T &gt; &gt; &amp;dest) const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>transpose</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>aaeeddee7317e64c79c562a8703480aec</anchor>
      <arglist>(MatrixSparse&lt; value_type &gt; &amp;Mt) const =0</arglist>
    </member>
    <member kind="function">
      <type>boost::shared_ptr&lt; MatrixSparse&lt; T &gt; &gt;</type>
      <name>transpose</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a6f9427fc081c1099b3e8d3b4e7729bad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transpose</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>aa221b9a6afc9a2dedf12759cb5418aca</anchor>
      <arglist>(boost::shared_ptr&lt; MatrixSparse&lt; value_type &gt; &gt; &amp;Mt) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>symmetricPart</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a2e7a8e596eb717cd113c9c7362b346d8</anchor>
      <arglist>(MatrixSparse&lt; value_type &gt; &amp;Ms) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>symmetricPart</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a545fd13e66c29dc47bfafadffbfc761c</anchor>
      <arglist>(boost::shared_ptr&lt; MatrixSparse&lt; value_type &gt; &gt; &amp;Ms) const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual real_type</type>
      <name>energy</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>aec47bcf734704ed4305b0fd57b9c61bb</anchor>
      <arglist>(vector_type const &amp;v, vector_type const &amp;u, bool transpose=false) const =0</arglist>
    </member>
    <member kind="function">
      <type>real_type</type>
      <name>energy</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a69aecfabdde84488b0c1b5c18e2cc1ea</anchor>
      <arglist>(vector_ptrtype const &amp;v, vector_ptrtype const &amp;u, bool _transpose=false) const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual real_type</type>
      <name>l1Norm</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a82b896d0669d8ba227aaa189663c587a</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual real_type</type>
      <name>linftyNorm</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>ab1aeca146775f1151a3669e03c546538</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>closed</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a552f6d9bc40072a6edb0f9437694f81f</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a28925ec03e56784befc03c116aec0a5b</anchor>
      <arglist>(std::ostream &amp;os=std::cout) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>printPersonal</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>ada2af971c7b757c03b88a040e60f1cd0</anchor>
      <arglist>(std::ostream &amp;=std::cout) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>printMatlab</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>abae720bae046bbf121a385f7ce529a21</anchor>
      <arglist>(const std::string name=&quot;NULL&quot;) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>createSubmatrix</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>accf55be59f0670a31999a4d8be0e3537</anchor>
      <arglist>(MatrixSparse&lt; T &gt; &amp;submatrix, const std::vector&lt; size_type &gt; &amp;rows, const std::vector&lt; size_type &gt; &amp;cols) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>reinitSubmatrix</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a25079da341b885752c5d7d49534bb156</anchor>
      <arglist>(MatrixSparse&lt; T &gt; &amp;submatrix, const std::vector&lt; size_type &gt; &amp;rows, const std::vector&lt; size_type &gt; &amp;cols) const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>zeroRows</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a7c542237fbf43a9fd8779cf186c3af02</anchor>
      <arglist>(std::vector&lt; int &gt; const &amp;rows, std::vector&lt; value_type &gt; const &amp;values, Vector&lt; value_type &gt; &amp;rhs, Context const &amp;on_context)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>updateBlockMat</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a1ad143c3d85e11b5645ca3f12e983859</anchor>
      <arglist>(boost::shared_ptr&lt; MatrixSparse&lt; T &gt; &gt; m, size_type start_i, size_type start_j)=0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setInitialized</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a6ccc415831ff4c311bb3fb668cfa6716</anchor>
      <arglist>(bool _init)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>_get_submatrix</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a1f3f6634339063536e73d71edb0273e6</anchor>
      <arglist>(MatrixSparse&lt; T &gt; &amp;, const std::vector&lt; size_type &gt; &amp;, const std::vector&lt; size_type &gt; &amp;, const bool) const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>WorldComm</type>
      <name>M_worldComm</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a85d617c694de08548f8d3701e6ac1714</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>_M_is_initialized</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a83fd676ed777d81fc3191cfa880c62bd</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>graph_ptrtype</type>
      <name>_M_graph</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a4f6f21a85bc3294099bbf7f9cba85972</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Context</type>
      <name>M_mprop</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>ac131a85f13eaaa45da80a51fd2c75000</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::vector&lt; std::vector&lt; int &gt; &gt;</type>
      <name>M_IndexSplit</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a038caae56d565bb50dc0f641f7a1de1f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>DataMap</type>
      <name>M_mapRow</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a1c1b03e948b9944bcc42f787d266e134</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>DataMap</type>
      <name>M_mapCol</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>a08d73ff3f5e908aed8ed314213cda3e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1MatrixSparse.html</anchorfile>
      <anchor>af154a6d470908d4e78f71af90892b566</anchor>
      <arglist>(std::ostream &amp;os, const MatrixSparse&lt; U &gt; &amp;m)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::MatrixTriplet</name>
    <filename>classFeel_1_1MatrixTriplet.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>T</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1MatrixTriplet.html</anchorfile>
      <anchor>ab89eda9b09e3cfdc0ec9ec1999614f2a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MatrixTriplet</name>
      <anchorfile>classFeel_1_1MatrixTriplet.html</anchorfile>
      <anchor>aff76b78dd17f5e79e2642f99b88b36ca</anchor>
      <arglist>(int nr, int nc, std::vector&lt; int &gt; const &amp;_Ti, std::vector&lt; int &gt; const &amp;_Tj, std::vector&lt; double &gt; const &amp;_Tx)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MatrixTriplet</name>
      <anchorfile>classFeel_1_1MatrixTriplet.html</anchorfile>
      <anchor>aeda666e91f7edc359a8c2dd54c23aa40</anchor>
      <arglist>(MatrixTriplet const &amp;mt)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~MatrixTriplet</name>
      <anchorfile>classFeel_1_1MatrixTriplet.html</anchorfile>
      <anchor>a23bf99824e2e13f8f801230f9f81e7d8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>nrows</name>
      <anchorfile>classFeel_1_1MatrixTriplet.html</anchorfile>
      <anchor>a360d4984e3a9d63ed90fa843a4844b15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>ncols</name>
      <anchorfile>classFeel_1_1MatrixTriplet.html</anchorfile>
      <anchor>a738ba6dd5a04daf91ed9e1c129adee79</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>nz</name>
      <anchorfile>classFeel_1_1MatrixTriplet.html</anchorfile>
      <anchor>adb7b8c12f6e74f709d34bc1e28883c4a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int const *</type>
      <name>Ti</name>
      <anchorfile>classFeel_1_1MatrixTriplet.html</anchorfile>
      <anchor>a3761a010e5c5ec931619ff59c46f2f13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int const *</type>
      <name>Tj</name>
      <anchorfile>classFeel_1_1MatrixTriplet.html</anchorfile>
      <anchor>aa4c224902987533e11a41b687f44ed00</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>value_type const *</type>
      <name>Tx</name>
      <anchorfile>classFeel_1_1MatrixTriplet.html</anchorfile>
      <anchor>a50463bbf19994c89957fce4371f00416</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::MatrixUBlas</name>
    <filename>classFeel_1_1MatrixUBlas.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>MatrixUBlas</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>a16abd9dd0ecdc550d34545114a9fa8d9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MatrixUBlas</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>aaaca2b9e99973c44aca9b9cf58ffc2a9</anchor>
      <arglist>(MatrixUBlas const &amp;m)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~MatrixUBlas</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>a0cf2e4860e14e65141461138509e5024</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>value_type &amp;</type>
      <name>operator()</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>a22f4a02cdc6af6f7cea4c76122c4895e</anchor>
      <arglist>(size_type i, size_type j)</arglist>
    </member>
    <member kind="function">
      <type>value_type const &amp;</type>
      <name>operator()</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>ad5da990844228974bae64a636ce5f92e</anchor>
      <arglist>(size_type i, size_type j) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>size1</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>a4dec54812b500df4f0619851d1737df9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>size2</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>a3a5dc093f280a2c5ede7e41fce630a50</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>nnz</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>a075896b1b53dd1ba83676f738ae28c42</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>rowStart</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>ac5d4504f7b5f198d9235ce0328fec334</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>rowStop</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>a8e9ecbeb05cec47639f330ecfb7867d2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isInitialized</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>a5be30da9001d4408259732f6f4b43991</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>matrix_type const &amp;</type>
      <name>mat</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>a6969b264d89bac2871c74e45248e0693</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>matrix_type &amp;</type>
      <name>mat</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>ab0e9c921a861db47d0c5bdd07a4ca594</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>a9be4faa0c7d9bd81ca71365cc4d35c7e</anchor>
      <arglist>(const unsigned int m, const unsigned int n, const unsigned int m_l, const unsigned int n_l, const unsigned int nnz=30, const unsigned int noz=10)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>aedb4d01daa3e6053696be46f033ce8a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zero</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>ad5acbe1be16c2943c1a038f006f17ad0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zero</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>af94c3381cb61651eefcb058a1e8d2e3b</anchor>
      <arglist>(size_type start1, size_type stop1, size_type start2, size_type stop2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>a77315e357955c3708ed83b0e932d0321</anchor>
      <arglist>(const unsigned int i, const unsigned int j, const value_type value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>aa06cecb3a4ffba07d3bc8116c5b34c9a</anchor>
      <arglist>(const unsigned int i, const unsigned int j, const value_type value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printMatlab</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>a399fbddace654702ac181f6a6fc6b44a</anchor>
      <arglist>(const std::string name=&quot;NULL&quot;) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>a3ac8b56ef5b0ae589d1e5e5a6f6d2d9b</anchor>
      <arglist>(pattern_type const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>ab71820ea54082b03afcd57db003d6a07</anchor>
      <arglist>(size_type nr, size_type nc, bool preserve=false)</arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>energy</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>a8c9984a49dc4bfeaa25a710ba01200ba</anchor>
      <arglist>(ublas::vector_expression&lt; VE1 &gt; const &amp;__v, ublas::vector_expression&lt; VE2 &gt; const &amp;__u) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>diagonalize</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>a36971111c357b098c9805848585b5107</anchor>
      <arglist>(size_type)</arglist>
    </member>
    <member kind="typedef">
      <type>T</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>a94a8728f4a20595dcacce1901871b6c5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ublas::compressed_matrix&lt; value_type, LayoutType &gt;</type>
      <name>matrix_type</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>a06a2182be254cf17a92a81b9fa83eb48</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::numeric::bindings::traits::sparse_matrix_traits&lt; matrix_type &gt;::ordering_type</type>
      <name>ordering_type</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>a231c71b3b963cf7a649885d271e3204e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::numeric::bindings::traits::sparse_matrix_traits&lt; matrix_type &gt;::layout_type</type>
      <name>layout_type</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>af067219341af3ae585d9d199a3c73546</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; std::set&lt; size_type &gt; &gt;</type>
      <name>pattern_type</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>ab2a23eb2123cdff3e2f0a3aece424d51</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const bool</type>
      <name>is_row_major</name>
      <anchorfile>classFeel_1_1MatrixUBlas.html</anchorfile>
      <anchor>aa9ed770526001ce781afcc7969fcc676</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::MatrixValue</name>
    <filename>classFeel_1_1MatrixValue.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>MatrixValue</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a2fc2037fa5d0492eb0e3c9de7b6082e9</anchor>
      <arglist>(value_type acc=value_type(0))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MatrixValue</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a90f56ac608e5fcee0b74502bbebbcc79</anchor>
      <arglist>(MatrixValue const &amp;m)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~MatrixValue</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a683787f0d80c634449a46da938274efe</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>size1</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a3bf4cb7332c7c568db7bba77e1eac919</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>size2</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>ab4ba46263f33d36b3dd31a4f43e5fcae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>nnz</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a82b0784e8c2bd806af07edc34692d385</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>rowStart</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a445125c59b11f40424a9d34ca27ba26d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>rowStop</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a6560f3473f7f52fec736bec7bbcca7e3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isInitialized</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a6e090b1e34c9651c2fed0fb0d93fa3b1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>adc4e94f87cede00542e9d698ca605b9c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>closed</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>afe4c90974be2929f91f64a8b1bf123ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>matrix_type const &amp;</type>
      <name>mat</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a5a038205672d3ac2493e3ec4bc3bf485</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>matrix_type &amp;</type>
      <name>mat</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a1b79f13d6f0f0f0ecf0c93f1fa5fcb04</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>matrix_type const &amp;</type>
      <name>wmat</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a821b6aa5bc3ff02b0795853892339a8a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>matrix_type &amp;</type>
      <name>wmat</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a66cc004e0279f47d072c607b3543771c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>aa888362a660c662f48449e5ddde5138f</anchor>
      <arglist>(const unsigned int, const unsigned int, const unsigned int, const unsigned int, const unsigned int=30, const unsigned int=10)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a59cb8908a43ede44a349ee84c58fc366</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zero</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a7396215aac6a6d20c8d846dfff1fa696</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zero</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>ac84126653fec129fc17adf77899ca99d</anchor>
      <arglist>(size_type, size_type, size_type, size_type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>abd96330b62979d4bef882369231b7b6f</anchor>
      <arglist>(const unsigned int, const unsigned int, const value_type value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a3e4d06344d3d04397ce7d144d7f5c549</anchor>
      <arglist>(const unsigned int, const unsigned int, const value_type value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printMatlab</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a9735ea2ea92d278b17a11e9fc4e186ad</anchor>
      <arglist>(const std::string name=&quot;NULL&quot;) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a5c35de6c5f971bf9034013c383d87075</anchor>
      <arglist>(pattern_type const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a2cc49692b5193063dfa8c1888f55ed7c</anchor>
      <arglist>(size_type, size_type, bool=false)</arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>energy</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a568c40a9c6f9d719844d471b42655b0f</anchor>
      <arglist>(ublas::vector&lt; value_type &gt; const &amp;, ublas::vector&lt; value_type &gt; const &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>diagonalize</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>ab73fa949647284925ee1638ff5f72671</anchor>
      <arglist>(size_type)</arglist>
    </member>
    <member kind="typedef">
      <type>T</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a01081039c492458080bf8c34713a72e1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>value_type</type>
      <name>matrix_type</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>ac28dab9528c6c9bc66b70eb18cd0df3e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; std::set&lt; size_type &gt; &gt;</type>
      <name>pattern_type</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>a9774c460c6e43cd3e6b4d0458db2be54</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const bool</type>
      <name>is_row_major</name>
      <anchorfile>classFeel_1_1MatrixValue.html</anchorfile>
      <anchor>afda2538179b5cfe1ba22f025538731d3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::Preconditioner</name>
    <filename>classFeel_1_1Preconditioner.html</filename>
    <templarg>T</templarg>
    <member kind="typedef">
      <type>Preconditioner&lt; T &gt;</type>
      <name>preconditioner_type</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>af18e7b2c156c7740edfd83043bcde07e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; Preconditioner&lt; T &gt; &gt;</type>
      <name>preconditioner_ptrtype</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>ad9b441fa55f6b40ece5aa85a59f04227</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; MatrixSparse&lt; T &gt; &gt;</type>
      <name>sparse_matrix_ptrtype</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>a03bf19256beb8b9e2ecc44564e7aedf3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; Vector&lt; T &gt; &gt;</type>
      <name>vector_ptrtype</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>a5757ad85798f74586467bb3fc52884b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Preconditioner &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>a1d9412d0a1053967dcd45cc3a2e13037</anchor>
      <arglist>(Preconditioner const &amp;o)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>initialized</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>a94802ca4f63a7fec34b659e2d137433e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>WorldComm const &amp;</type>
      <name>worldComm</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>a4b2754f466957bb9ac9fabc42e1ca179</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>apply</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>a797ec630b280d5012a407012c303dd95</anchor>
      <arglist>(const Vector&lt; T &gt; &amp;x, Vector&lt; T &gt; &amp;y)=0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>apply</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>aa5f947d7b9252d2df0ccc070740ef5a8</anchor>
      <arglist>(vector_ptrtype const &amp;x, vector_ptrtype &amp;y)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clear</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>a0fdfac32d1804cb3b5d7b2938f2f4af4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>PreconditionerType</type>
      <name>type</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>a15a913582c0e115780a87839ea56a10f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMatrix</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>a2e383dfc9cc25aa90bc4f9f39d96e5a0</anchor>
      <arglist>(sparse_matrix_ptrtype mat)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setType</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>a6c7f627b4fead8be3e4077b815e4ce33</anchor>
      <arglist>(const PreconditionerType pct)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMatSolverPackageType</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>a92fa53d5db0405ca4ba8e6603778f2d0</anchor>
      <arglist>(const MatSolverPackageType mspt)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>WorldComm</type>
      <name>M_worldComm</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>a8f161a521809cf5d4325038d995a2f24</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>sparse_matrix_ptrtype</type>
      <name>M_matrix</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>ac99c9dd0c7ed7dce03c79b98dbffc7ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>PreconditionerType</type>
      <name>M_preconditioner_type</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>a23a7db331f0ba75462d7b8747fc214da</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>MatSolverPackageType</type>
      <name>M_matSolverPackage_type</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>afabfa4a2c0816962103c8280cb5a80eb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>M_is_initialized</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>a5065971a8bb9aa3702adf699f75987fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Preconditioner</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>a6e080bf9b2c5a2f110f0d6e52f3a8bff</anchor>
      <arglist>(WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Preconditioner</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>aef7545e5d254a486d6305af30357c6cf</anchor>
      <arglist>(Preconditioner const &amp;o)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Preconditioner</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>abc069203478f30db0bd3930cd9ab54ef</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>a76a877afa7a329c9d6a34ab8fff44aa3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static preconditioner_ptrtype</type>
      <name>build</name>
      <anchorfile>classFeel_1_1Preconditioner.html</anchorfile>
      <anchor>a1ff5f2fd792e5a624193aa7908185b62</anchor>
      <arglist>(BackendType=BACKEND_PETSC, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::PreconditionerPetsc</name>
    <filename>classFeel_1_1PreconditionerPetsc.html</filename>
    <templarg></templarg>
    <base>Feel::Preconditioner</base>
    <member kind="function">
      <type></type>
      <name>PreconditionerPetsc</name>
      <anchorfile>classFeel_1_1PreconditionerPetsc.html</anchorfile>
      <anchor>a9343a74020e0d3a785fe72ff60454071</anchor>
      <arglist>(WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PreconditionerPetsc</name>
      <anchorfile>classFeel_1_1PreconditionerPetsc.html</anchorfile>
      <anchor>a2a8defafeea9752f5e18cb13c0189a2e</anchor>
      <arglist>(PreconditionerPetsc const &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~PreconditionerPetsc</name>
      <anchorfile>classFeel_1_1PreconditionerPetsc.html</anchorfile>
      <anchor>a0e7b01b8edd36d0753b49c4ec58ffc8e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clear</name>
      <anchorfile>classFeel_1_1PreconditionerPetsc.html</anchorfile>
      <anchor>abea91af75a68d507341a541e725def8c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1PreconditionerPetsc.html</anchorfile>
      <anchor>a85d7c00b8a87f636ee417b05088325aa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>PreconditionerPetsc &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1PreconditionerPetsc.html</anchorfile>
      <anchor>afe933b4d3b5ee4c59cd606cb53c948c4</anchor>
      <arglist>(PreconditionerPetsc const &amp;o)</arglist>
    </member>
    <member kind="function">
      <type>PC</type>
      <name>pc</name>
      <anchorfile>classFeel_1_1PreconditionerPetsc.html</anchorfile>
      <anchor>af8eb28cc24617536b7826efd0b76ee6b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>apply</name>
      <anchorfile>classFeel_1_1PreconditionerPetsc.html</anchorfile>
      <anchor>a9ce793ac53cd2080f4e3e1ce7920d5b9</anchor>
      <arglist>(const Vector&lt; T &gt; &amp;x, Vector&lt; T &gt; &amp;y)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>setPetscSubpreconditionerType</name>
      <anchorfile>classFeel_1_1PreconditionerPetsc.html</anchorfile>
      <anchor>a79333ddeac68a50a4ff1c0974556d0d9</anchor>
      <arglist>(const PCType type, PC &amp;pc, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>setPetscFieldSplitPreconditionerType</name>
      <anchorfile>classFeel_1_1PreconditionerPetsc.html</anchorfile>
      <anchor>a246aa7bd9f3396f50a2edea4642f61cc</anchor>
      <arglist>(const PCCompositeType type, const KSPType *subksptypes, const PCType *subpctypes, PC &amp;pc, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>setPetscPreconditionerType</name>
      <anchorfile>classFeel_1_1PreconditionerPetsc.html</anchorfile>
      <anchor>a11a2a949cacfcd5aaa6b6233f5445012</anchor>
      <arglist>(const PreconditionerType &amp;preconditioner_type, const MatSolverPackageType &amp;matSolverPackage_type, PC &amp;pc, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="variable">
      <type>PC</type>
      <name>M_pc</name>
      <anchorfile>classFeel_1_1PreconditionerPetsc.html</anchorfile>
      <anchor>ade8254ba365f4d28e50fc5ae10e42cee</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Mat</type>
      <name>M_mat</name>
      <anchorfile>classFeel_1_1PreconditionerPetsc.html</anchorfile>
      <anchor>a29d07631013ba57bb6cf899ec6f2285c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::SolverBase</name>
    <filename>classFeel_1_1SolverBase.html</filename>
    <member kind="typedef">
      <type>double</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1SolverBase.html</anchorfile>
      <anchor>a07084dfc5416505d0b544fad96d1eaa4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SolverBase</type>
      <name>solver_type</name>
      <anchorfile>classFeel_1_1SolverBase.html</anchorfile>
      <anchor>a405d4badbb443a5e19315539aded9aa5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Vector</type>
      <name>array_type</name>
      <anchorfile>classFeel_1_1SolverBase.html</anchorfile>
      <anchor>a980d9511216a1f91bd7080a9f82c5ef8</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setOptionsFromGetPot</name>
      <anchorfile>classFeel_1_1SolverBase.html</anchorfile>
      <anchor>a6f075ecfa1eea8e773779d55af26ae0d</anchor>
      <arglist>(GetPot const &amp;dataFile, std::string section)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual double</type>
      <name>residualNorm</name>
      <anchorfile>classFeel_1_1SolverBase.html</anchorfile>
      <anchor>aa217195aba240bf8e24e67e8c9e3f366</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setMatrix</name>
      <anchorfile>classFeel_1_1SolverBase.html</anchorfile>
      <anchor>af600ede595225336cd76b08fd15d31ad</anchor>
      <arglist>(MatrixType const &amp;newMatrix)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setTolerance</name>
      <anchorfile>classFeel_1_1SolverBase.html</anchorfile>
      <anchor>a48a929ac854409913990d40fdb529816</anchor>
      <arglist>(double newTolerance)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>solve</name>
      <anchorfile>classFeel_1_1SolverBase.html</anchorfile>
      <anchor>a4a0ffd5f9d65e1e279fe88ad6a1e0e54</anchor>
      <arglist>(array_type &amp;x, array_type const &amp;b)=0</arglist>
    </member>
    <member kind="function" virtualness="pure" static="yes">
      <type>virtual static SolverBase *</type>
      <name>New</name>
      <anchorfile>classFeel_1_1SolverBase.html</anchorfile>
      <anchor>af9bd228e8bbdc39ab30667ba1ff0e298</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual</type>
      <name>~SolverBase</name>
      <anchorfile>classFeel_1_1SolverBase.html</anchorfile>
      <anchor>a13a83cc0ddebb7abb26bea6fb0e464ad</anchor>
      <arglist>()=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::SolverEigen</name>
    <filename>classFeel_1_1SolverEigen.html</filename>
    <templarg>T</templarg>
    <member kind="typedef">
      <type>T</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a7badbbab6a1d1a8d4e446af93943713e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>type_traits&lt; T &gt;::real_type</type>
      <name>real_type</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>aebcf789335675005f811185b697579e9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SolverEigen&lt; value_type &gt;</type>
      <name>solvereigen_type</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>aedac8f93c9e3ae290707db18de3620ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; solvereigen_type &gt;</type>
      <name>solvereigen_ptrtype</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>aa74ee362761b27eb62def033721ec839</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::tuple&lt; size_type, size_type, std::vector&lt; double &gt; &gt;</type>
      <name>solve_return_type</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a80feac30e2c105fe3564b5dc9cc8a039</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Vector&lt; value_type &gt;</type>
      <name>vector_type</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a33b2e3bed8a059a6cfcc108da4eb6190</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; vector_type &gt;</type>
      <name>vector_ptrtype</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a41e364233603b9b0b2e02868442c9a74</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>MatrixSparse&lt; value_type &gt;</type>
      <name>sparse_matrix_type</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a774cca6840bbe0ef38cb5cbae97c5073</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; sparse_matrix_type &gt;</type>
      <name>sparse_matrix_ptrtype</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a269aae248e683d60e6d3fcf0e7c20f0a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::tuple&lt; real_type, real_type, vector_ptrtype &gt;</type>
      <name>eigenpair_type</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>adc57f9d689a6eaff7b73e7de189f7feb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::map&lt; real_type, eigenpair_type &gt;</type>
      <name>eigenmodes_type</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>ae4802984b1823d8410c74142712f272e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>std::string const &amp;</type>
      <name>prefix</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a7700abcd5b1dc91deae8ab68f5bd721c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>EigenSolverType</type>
      <name>eigenSolverType</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>abac16f073c7206f605e1dc69b5b79764</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>EigenProblemType</type>
      <name>eigenProblemType</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a21181602fd3b68ffb0656b8bbf072e92</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>PositionOfSpectrum</type>
      <name>postitionOfSpectrum</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>aee7706ec32b62ee0e141aae631cd0863</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SpectralTransformType</type>
      <name>spectralTransform</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>ae037dbdfe8a6807ccce913bc25668e69</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>numberOfEigenvalues</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a25720fc0e1115b98aa71651a7decf0a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>numberOfEigenvaluesConverged</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>aed58097eff9d807b3b02ca27a54c9219</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>tolerance</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a3bffbfc17979de150e1c4dbebb359256</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>maxIterations</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a54a8c1921a6869d2c45b7950393165af</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEigenSolverType</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>af10d6ffb258294c7f5eed659731af3e6</anchor>
      <arglist>(const EigenSolverType est)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEigenProblemType</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a93f93a75689cc751ab3b198d29a22735</anchor>
      <arglist>(EigenProblemType ept)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPositionOfSpectrum</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>ad43af0b87be726010a14db1d90a4678e</anchor>
      <arglist>(PositionOfSpectrum pos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSpectralTransform</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a82486d1e016f1c722137436eaa9434e7</anchor>
      <arglist>(SpectralTransformType st)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTolerance</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a683e119180310289f32647f41a4c839a</anchor>
      <arglist>(value_type tol)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxIterations</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a5424ab9c0adf85bbd87f424d9f1a9b04</anchor>
      <arglist>(size_type maxiter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNumberOfEigenValues</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a2ad91d1db1086f105e41f4bdb3666bad</anchor>
      <arglist>(size_type nev)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNumberOfEigenValuesConverged</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>af575c3a3350aa029b887117b07a8f9f9</anchor>
      <arglist>(size_type ncv)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>initialized</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>aee3af76e50d62d058bcab610e652f944</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clear</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>af26f97e2dfc3a7ca1fcfbca651c1cf8e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>af5e07b3f630d217ce03ad39977464681</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_MEMBER_FUNCTION</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a5e198c2ffa9e9ef8968995b8f435f3f7</anchor>
      <arglist>((solve_return_type), solve, tag,(required(matrixA,(sparse_matrix_ptrtype))(matrixB,(sparse_matrix_ptrtype)))(optional(maxit,(size_type), 1000)(tolerance,(double), 1e-11)))</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual solve_return_type</type>
      <name>solve</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>aa09564a52db89534864de2a3e3a0eb43</anchor>
      <arglist>(MatrixSparse&lt; value_type &gt; &amp;matrix_A, int nev, int ncv, const double tol, const unsigned int m_its)=0</arglist>
    </member>
    <member kind="function">
      <type>solve_return_type</type>
      <name>solve</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a965ade84778665a5b0f3c4baf41d7d1a</anchor>
      <arglist>(boost::shared_ptr&lt; MatrixSparse&lt; value_type &gt; &gt; &amp;matrix_A, int nev, int ncv, const double tol, const unsigned int m_its)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual solve_return_type</type>
      <name>solve</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a52ef3bebed6fc6821c2e4da99832a499</anchor>
      <arglist>(MatrixSparse&lt; value_type &gt; &amp;matrix_A, MatrixSparse&lt; value_type &gt; &amp;matrix_B, int nev, int ncv, const double tol, const unsigned int m_its)=0</arglist>
    </member>
    <member kind="function">
      <type>solve_return_type</type>
      <name>solve</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a79fd5ce32eadf610ffa6671b9715cb38</anchor>
      <arglist>(boost::shared_ptr&lt; MatrixSparse&lt; value_type &gt; &gt; &amp;matrix_A, boost::shared_ptr&lt; MatrixSparse&lt; value_type &gt; &gt; &amp;matrix_B, int nev, int ncv, const double tol, const unsigned int m_its)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::string</type>
      <name>M_prefix</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>abfa743f92bc370ae269967664762e0bb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>EigenSolverType</type>
      <name>M_eigen_solver_type</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a84465f10c90303db255da4c88f801a5d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>EigenProblemType</type>
      <name>M_eigen_problem_type</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>ae74322654405f5b68779fd9b7dc0ed62</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>PositionOfSpectrum</type>
      <name>M_position_of_spectrum</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a7c22196e5a6737085689edec4d04df06</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SpectralTransformType</type>
      <name>M_spectral_transform</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>ad3b6e61f52ceb4bd7609d130ae2f100b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>M_is_initialized</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>ad1d3bbcdfea39e8fc9d5d025c758694b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>size_type</type>
      <name>M_nev</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a2906d7e18e029b25afdb816dfa8c2795</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>size_type</type>
      <name>M_ncv</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a70a38fa62c2afa43e966e08e7e35e129</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>size_type</type>
      <name>M_maxit</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>afcd6f8382b7c9076d89d42efc1e0a099</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>value_type</type>
      <name>M_tolerance</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a6f45896f0bbb3380c134318c61086b65</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SolverEigen</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a2e78ebdcb509e0d96c0c7997342af994</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SolverEigen</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>ad3631022c2f811bce11e87b785b06e27</anchor>
      <arglist>(po::variables_map const &amp;vm, std::string const &amp;prefix=&quot;&quot;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SolverEigen</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>acc609a6bf143480945e00794cea258ad</anchor>
      <arglist>(SolverEigen const &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SolverEigen</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>a07cd2315ac592905a17790f7cbdc2260</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual eigenpair_type</type>
      <name>eigenPair</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>ae607d5a42a4d9d6323409f0ebf8acc61</anchor>
      <arglist>(unsigned int i)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual eigenmodes_type</type>
      <name>eigenModes</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>abbcddfe826f68c4f35006833e8ea32c8</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static boost::shared_ptr&lt; SolverEigen&lt; value_type &gt; &gt;</type>
      <name>build</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>ae3cfe6866bcfcfdcdedfdb629ff4d30b</anchor>
      <arglist>(const SolverPackage solver_package=SOLVERS_SLEPC)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static boost::shared_ptr&lt; SolverEigen&lt; value_type &gt; &gt;</type>
      <name>build</name>
      <anchorfile>classFeel_1_1SolverEigen.html</anchorfile>
      <anchor>ac18b7766a14967ded56be9f67a75a8b4</anchor>
      <arglist>(po::variables_map const &amp;vm, std::string const &amp;prefix=std::string())</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::SolverLinear</name>
    <filename>classFeel_1_1SolverLinear.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>SolverLinear&lt; T &gt;</type>
      <name>self_type</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a0b0da3bd9731e3f63a93c121b587fb79</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; SolverLinear&lt; T &gt; &gt;</type>
      <name>self_ptrtype</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a38242d3943fd9b89ab783decda28902f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>T</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>ad72acaec554b1366950919a09a888606</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>type_traits&lt; T &gt;::real_type</type>
      <name>real_type</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a4abfb9e3f78412464794afe713add9a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; Preconditioner&lt; T &gt; &gt;</type>
      <name>preconditioner_ptrtype</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>af2ea5597c83929afeaa82159865d3197</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SolverLinear</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a3c6bc4a35a070b326d99d48132ac51d9</anchor>
      <arglist>(WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SolverLinear</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a07413f7c1eb9b315a221c636ed244494</anchor>
      <arglist>(po::variables_map const &amp;vm, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SolverLinear</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a00c678b88735046fc5cf51ca71f3f1ef</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>WorldComm const &amp;</type>
      <name>worldComm</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a66c5099798a200620d8df17ea9cc64c1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWorldComm</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>ac35211615a76dc2fc3959d5250579dbd</anchor>
      <arglist>(WorldComm const &amp;worldComm)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>initialized</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a1a59504e203ef4e9e12f8abea1bda193</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clear</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a56209a190f92bc9f2431833fc583fb5f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a4396c46a2f128312d5510f22b3de6f8a</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function">
      <type>po::variables_map</type>
      <name>vm</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>ad93d33f94e2fee2113dd4b4011c441c2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>rTolerance</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>aed6ee406c1dc258608a740bceab9c374</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>dTolerance</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a6c4115f31a8da7771ce9d5dfea9dd07e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>aTolerance</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a5357452ff316826e3fdee36bc96d25f5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SolverType</type>
      <name>solverType</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>aefa299f4d0c7f3d5555f69acfe009e4f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>maxIterations</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>af1a89b2e9c98ddadd32ce0689cd9c274</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_PARAMETER_MEMBER_FUNCTION</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a14b56d7dd4c978ab9804a8bc415bfaa5</anchor>
      <arglist>((void), setTolerances, tag,(required(rtolerance,(double)))(optional(maxit,(size_type), 1000)(atolerance,(double), 1e-50)(dtolerance,(double), 1e5)))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSolverType</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>ad672a8b9778ddf384ec7e5d1f75f4b32</anchor>
      <arglist>(const SolverType st)</arglist>
    </member>
    <member kind="function">
      <type>PreconditionerType</type>
      <name>preconditionerType</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>af1566de76ae3b40999b1b86673085c83</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPreconditionerType</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a5307a1782482c4ce74672244c9a6d7f1</anchor>
      <arglist>(const PreconditionerType pct)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>attachPreconditioner</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>aadbdb48a9e4587b02240be88cc36beca</anchor>
      <arglist>(preconditioner_ptrtype preconditioner)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFieldSplitType</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>ae1a14fe1d0837447f71c17c68e93637e</anchor>
      <arglist>(const FieldSplitType fst)</arglist>
    </member>
    <member kind="function">
      <type>FieldSplitType</type>
      <name>fieldSplitType</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>ac5153a0e3b5239a4ad456aed76d09959</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMatSolverPackageType</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>aa0cf40980960625a88df5be82a5801be</anchor>
      <arglist>(const MatSolverPackageType mspackt)</arglist>
    </member>
    <member kind="function">
      <type>MatSolverPackageType</type>
      <name>matSolverPackageType</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a2bfaa01e46047dcfc23a6606e09dd7b9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual MatrixStructure</type>
      <name>precMatrixStructure</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a704df9cbfb9746820544adeeb297ec2e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setPrecMatrixStructure</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>ac58e33bec821474570e0a40f7effb9e7</anchor>
      <arglist>(MatrixStructure mstruct)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual boost::tuple&lt; bool, unsigned int, real_type &gt;</type>
      <name>solve</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a9401ecc95fd4eeffa33417a360396f70</anchor>
      <arglist>(MatrixSparse&lt; T &gt; const &amp;mat, Vector&lt; T &gt; &amp;x, Vector&lt; T &gt; const &amp;b, const double tolerance, const unsigned int maxit, bool transpose)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual boost::tuple&lt; bool, unsigned int, real_type &gt;</type>
      <name>solve</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a433f370d52aca86ae775b76b7dded0dd</anchor>
      <arglist>(MatrixSparse&lt; T &gt; const &amp;mat, MatrixSparse&lt; T &gt; const &amp;prec, Vector&lt; T &gt; &amp;x, Vector&lt; T &gt; const &amp;b, const double tolerance, const unsigned int maxit, bool transpose)=0</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setInitialized</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a180cd436b526acd453af1ff794d41725</anchor>
      <arglist>(bool init)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>po::variables_map</type>
      <name>M_vm</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>abacc5f1d997d3c8fb22e955c38865240</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>double</type>
      <name>M_rtolerance</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a9daccd1b7947a1d3edb008d8909596ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>double</type>
      <name>M_dtolerance</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>ae0d2b15d321aa546cae230ff400fd6fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>double</type>
      <name>M_atolerance</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a0106b7b383e6f56664faa03da1319c6a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>size_type</type>
      <name>M_maxit</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a65f80c291989c1b906862fac2b25cc16</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SolverType</type>
      <name>_M_solver_type</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>adc85f31c1a19d1163645b6b30daef327</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>PreconditionerType</type>
      <name>_M_preconditioner_type</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a62bc40c09654d157a3b40bb78abd56f4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>preconditioner_ptrtype</type>
      <name>M_preconditioner</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a9c9f5fbaf60451bb4b14216e79a097c1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>FieldSplitType</type>
      <name>_M_fieldSplit_type</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a84d63725b20b68c7631b66e5b19918dc</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>MatSolverPackageType</type>
      <name>M_matSolverPackage_type</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a191b84d3fbcc0f52f179f555dedaf394</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>_M_is_initialized</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>a5ed132a1e0933fa7bc07525512cf4bb8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>MatrixStructure</type>
      <name>M_prec_matrix_structure</name>
      <anchorfile>classFeel_1_1SolverLinear.html</anchorfile>
      <anchor>aefbcd52dc805a5dc54113c0cce86d938</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::SolverNonLinear</name>
    <filename>classFeel_1_1SolverNonLinear.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>SolverNonLinear&lt; T &gt;</type>
      <name>self_type</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a6aa0396d59f277bafa8d5abc76780b64</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; SolverNonLinear&lt; T &gt; &gt;</type>
      <name>self_ptrtype</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a0d78640e5c566f529b07d5391f886344</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>self_type</type>
      <name>solvernonlinear_type</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>ae16d72e7d549dad7673028b3d03ee549</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; self_type &gt;</type>
      <name>solvernonlinear_ptrtype</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>aed4b321f2b94cac4b64ea86975fac9e0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>T</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a9f77e1740ca98027678c2350559e831c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>type_traits&lt; T &gt;::real_type</type>
      <name>real_type</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a1a5ef16d35939e7d89da6cbb867f49f2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; Preconditioner&lt; T &gt; &gt;</type>
      <name>preconditioner_ptrtype</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a32940cdb36011c4480fac535789fe378</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; Vector&lt; value_type &gt; &gt;</type>
      <name>vector_ptrtype</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>ae55734d4bbf988ceda175f75aa67fde7</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; MatrixSparse&lt; value_type &gt; &gt;</type>
      <name>sparse_matrix_ptrtype</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a865b4ea42a6956f83a1dd0eef8d37e9d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ublas::matrix&lt; value_type &gt;</type>
      <name>dense_matrix_type</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a5a781a24ecd5f4b1b1bbd4192ffe1563</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ublas::vector&lt; value_type &gt;</type>
      <name>dense_vector_type</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a911468c21a401549106d6da6c2d27449</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::function&lt; void(const vector_ptrtype &amp;X, vector_ptrtype &amp;R)&gt;</type>
      <name>residual_function_type</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>ab4dafc3d947c41522e681afb41da645e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::function&lt; void(const vector_ptrtype &amp;X, sparse_matrix_ptrtype &amp;J)&gt;</type>
      <name>jacobian_function_type</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>af2d3fe4ee552bfdf141965900149650b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::function&lt; void(const vector_ptrtype &amp;X, vector_ptrtype &amp;R, sparse_matrix_ptrtype &amp;J)&gt;</type>
      <name>matvec_function_type</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>ab34671337433c62df03b9eb39fda7045</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::function&lt; void(dense_vector_type const &amp;X, dense_vector_type &amp;R)&gt;</type>
      <name>dense_residual_function_type</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a0ae94fe1f00e47bb0b4118d05a7d2bd9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::function&lt; void(dense_vector_type const &amp;X, dense_matrix_type &amp;J)&gt;</type>
      <name>dense_jacobian_function_type</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>ac9f654182f485761a4055464afe11cb6</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::function&lt; void(dense_vector_type const &amp;X, dense_vector_type &amp;R, dense_matrix_type &amp;J)&gt;</type>
      <name>dense_matvec_function_type</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a029e8a637d1b18de3fcd55c2f8d9beb7</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>WorldComm const &amp;</type>
      <name>comm</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a18b9eeb268eefdfc42c49a1280b4fb6d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>WorldComm const &amp;</type>
      <name>worldComm</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>afb6cb009cc2735aa1ee74845a79468a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>initialized</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a380ac9caa5598ca1e0b3ba80f51a5246</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clear</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a4213c79a91facb14143cbb3d984300bb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual MatrixStructure</type>
      <name>precMatrixStructure</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>ab16a063b199eef5f42d2166962fc423a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SolverNonLinearType</type>
      <name>getType</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a8433cfcc5659e21bd7aa7ac0204c986d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getAbsoluteResidualTol</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>afc9eaeb33db17db36f9b928b711f7bbf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getRelativeResidualTol</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a357a72b0c2f09c5413b045a1d12b5c03</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getAbsoluteSolutionTol</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a6afaae348923d6b1bd4e5ed516165460</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>getNbItMax</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a23a1c0e1fd8e9a9638932a0d08c2b674</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>reuseJacobian</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a53ffa47fd77320801b1b232c4d781c82</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>reusePreconditioner</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a731163ae9bdec7b889ee9aa8ca576279</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setPrecMatrixStructure</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>ab2438fdc947ded15a1ce6a76829d33bb</anchor>
      <arglist>(MatrixStructure mstruct)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setType</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>ae54d24111faad1218b093c55df85cbfc</anchor>
      <arglist>(SolverNonLinearType snl_type)</arglist>
    </member>
    <member kind="function">
      <type>SolverNonLinearType</type>
      <name>nlSolverType</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a24e20d4d06065687e1980cc577c5a4fd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setKspSolverType</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a62a0decd2f57fe57f351bccef00cfe4e</anchor>
      <arglist>(const SolverType st)</arglist>
    </member>
    <member kind="function">
      <type>SolverType</type>
      <name>kspSolverType</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>adfcece73d85183f5d385773ab169016f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>PreconditionerType</type>
      <name>preconditionerType</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a43e2d8e1775fbb796721a606e071420b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPreconditionerType</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a8a4c45fc3038105f0049898884900444</anchor>
      <arglist>(const PreconditionerType pct)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>attachPreconditioner</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a01f70a123bc367f9f34bc39c231f540a</anchor>
      <arglist>(preconditioner_ptrtype preconditioner)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMatSolverPackageType</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a1882bebfa4b81e3d96cdcd3af91caa8e</anchor>
      <arglist>(const MatSolverPackageType mspackt)</arglist>
    </member>
    <member kind="function">
      <type>MatSolverPackageType</type>
      <name>matSolverPackageType</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a92ae3675b5fa59ead206fe9f51451994</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setReuse</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>aafb8e3c8ed8b74b6c577a5b8a27b9ea6</anchor>
      <arglist>(int jac=1, int prec=1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRelativeResidualTol</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>aafd1d3d40b5769456801a9a60d745d76</anchor>
      <arglist>(double tol)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAbsoluteResidualTol</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a45ad8350a05e4d028ea7c6c30f142507</anchor>
      <arglist>(double tol)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAbsoluteSolutionTol</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>acb73a22512b34ab0cbff5fa5ceec205f</anchor>
      <arglist>(double tol)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNbItMax</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>adf9cdaa03f04e63f3b4af49d4b9061ed</anchor>
      <arglist>(uint n)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>WorldComm</type>
      <name>M_worldComm</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>ac85f56ccaff5dcdcccb57cd4f26596ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>M_is_initialized</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a8ee58c12ff06fe1086944c25ec50640b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>MatrixStructure</type>
      <name>M_prec_matrix_structure</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a2b8a2e9621fab4b5e0951fedfce0956e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SolverNonLinearType</type>
      <name>M_snl_type</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>ae8402c5a51b0dec4b59e8b240f6cce0a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SolverType</type>
      <name>M_kspSolver_type</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>ab0961b309cb3633721616eaecf840e90</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>PreconditionerType</type>
      <name>M_preconditioner_type</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>aecfb0c0ab7f6662a2f7e9f6d0dbcf91f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>preconditioner_ptrtype</type>
      <name>M_preconditioner</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>adcde8c1c73e5adc4fcdf15e964fb7072</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>MatSolverPackageType</type>
      <name>M_matSolverPackage_type</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a043b59ccac2ca8ef918bda2b697cf045</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>double</type>
      <name>M_relativeResidualTol</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a4670ac30011f9874d2c03afcc2650392</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>double</type>
      <name>M_absoluteResidualTol</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a2e9cc8f037487a98611e5826ed1ed307</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>double</type>
      <name>M_absoluteSolutionTol</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a3ecb956a49bfc73cd11feae676f957fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>uint</type>
      <name>M_nbItMax</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>ab53d2853b7825d9ed335df2f5cb51829</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>M_reuse_jac</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a7f69f36a7851b5f78dd1c18a76e58035</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>M_reuse_prec</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>aa65aa08fd8aadad6d4cc668528a9ec48</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SolverNonLinear</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a48ec8d31534d916482f6d50cd8574355</anchor>
      <arglist>(WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SolverNonLinear</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>ae02b25b0dfd2de2effc7c37c9ac7589a</anchor>
      <arglist>(SolverNonLinear const &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SolverNonLinear</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a71cba7696250ccc67224712fa91226c7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>aedb19152beceb0b5902f5b2ea1f068f7</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static solvernonlinear_ptrtype</type>
      <name>build</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>aff13b421c60975dc9f063890344946eb</anchor>
      <arglist>(po::variables_map const &amp;vm, std::string const &amp;prefix=&quot;&quot;, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static solvernonlinear_ptrtype</type>
      <name>build</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a2e1f67acb0f3cc6ca4b5d1d91fbfe666</anchor>
      <arglist>(SolverPackage solver_package, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="variable">
      <type>residual_function_type</type>
      <name>residual</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a1e3c100f15203768c7f9a7bde30f4345</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>jacobian_function_type</type>
      <name>jacobian</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a9026428561a9764c611d9ba47c7937e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>matvec_function_type</type>
      <name>matvec</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>ac5cc43ea14d8e3273684f4e34277d0d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>dense_residual_function_type</type>
      <name>dense_residual</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a80715a2d934df5519cdb5b402bcb0e8c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>dense_jacobian_function_type</type>
      <name>dense_jacobian</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>aced49ed51526b2edf8e387ccc4e4de27</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>dense_matvec_function_type</type>
      <name>dense_matvec</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>adc8db7d8c987d42bfc85b0d93adcfa2f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual std::pair&lt; int, real_type &gt;</type>
      <name>solve</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>aa02b71975bc5c88e83f6e21d7a0b9d9a</anchor>
      <arglist>(sparse_matrix_ptrtype &amp;, vector_ptrtype &amp;, vector_ptrtype &amp;, const double, const unsigned int)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual std::pair&lt; unsigned int, real_type &gt;</type>
      <name>solve</name>
      <anchorfile>classFeel_1_1SolverNonLinear.html</anchorfile>
      <anchor>a691ccf196b127e54c55fa41cf0c3b5c5</anchor>
      <arglist>(dense_matrix_type &amp;, dense_vector_type &amp;, dense_vector_type &amp;, const double, const unsigned int)=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::SolverUMFPACK</name>
    <filename>classFeel_1_1SolverUMFPACK.html</filename>
    <member kind="typedef">
      <type>double</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1SolverUMFPACK.html</anchorfile>
      <anchor>af415fb655a09b3f7b38d7bef79919a87</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>MatrixTriplet&lt; double &gt;</type>
      <name>matrix_type</name>
      <anchorfile>classFeel_1_1SolverUMFPACK.html</anchorfile>
      <anchor>aa6cbea013dae08b10a9310defcb3c474</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ublas::vector&lt; value_type &gt;</type>
      <name>array_type</name>
      <anchorfile>classFeel_1_1SolverUMFPACK.html</anchorfile>
      <anchor>a8bd69795e45e0a17a8cf8e8c6e3bf4e9</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SolverUMFPACK</name>
      <anchorfile>classFeel_1_1SolverUMFPACK.html</anchorfile>
      <anchor>a333e3d93739b0cda6ceaf5feb9d785d0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SolverUMFPACK</name>
      <anchorfile>classFeel_1_1SolverUMFPACK.html</anchorfile>
      <anchor>a9f459125f8f8787bc76175d7b9d67cab</anchor>
      <arglist>(SolverUMFPACK const &amp;umfpackSolver)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SolverUMFPACK</name>
      <anchorfile>classFeel_1_1SolverUMFPACK.html</anchorfile>
      <anchor>af48655932331f04d7b43857188065a5d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMatrix</name>
      <anchorfile>classFeel_1_1SolverUMFPACK.html</anchorfile>
      <anchor>a87f1535d03d6bb53d20ee0d10247dfc2</anchor>
      <arglist>(matrix_type const &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStrategy</name>
      <anchorfile>classFeel_1_1SolverUMFPACK.html</anchorfile>
      <anchor>aa0ac2a171c69ab2233859aa1fed59999</anchor>
      <arglist>(int strategy)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>solve</name>
      <anchorfile>classFeel_1_1SolverUMFPACK.html</anchorfile>
      <anchor>a00f3b963c095a0463387390a39e680fa</anchor>
      <arglist>(array_type &amp;__X, array_type const &amp;__B)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reportInfo</name>
      <anchorfile>classFeel_1_1SolverUMFPACK.html</anchorfile>
      <anchor>a92b70c9974585f6c99c90a119e4c7815</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reportStatus</name>
      <anchorfile>classFeel_1_1SolverUMFPACK.html</anchorfile>
      <anchor>aaaf80ac595d99c341ccdec2b96373cf4</anchor>
      <arglist>(int status)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::SVD</name>
    <filename>classFeel_1_1SVD.html</filename>
    <templarg>MatrixA</templarg>
    <member kind="typedef">
      <type>MatrixA::value_type</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1SVD.html</anchorfile>
      <anchor>a0cf22ebadb881d28733b9dfe242d1762</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>MatrixA</type>
      <name>matrix_type</name>
      <anchorfile>classFeel_1_1SVD.html</anchorfile>
      <anchor>a4376eeedb0fd37b823a2b71b5464ec1b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::numeric::ublas::vector&lt; value_type &gt;</type>
      <name>vector_type</name>
      <anchorfile>classFeel_1_1SVD.html</anchorfile>
      <anchor>afa648141d2b77be3ac5a2ccd1a28cc57</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SVD</name>
      <anchorfile>classFeel_1_1SVD.html</anchorfile>
      <anchor>ae915c6cc6eb0b53b5e94251c0777cee6</anchor>
      <arglist>(matrix_type const &amp;__A)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SVD</name>
      <anchorfile>classFeel_1_1SVD.html</anchorfile>
      <anchor>a09462c4f9f073af64a3bd5242e6a631d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>matrix_type const &amp;</type>
      <name>U</name>
      <anchorfile>classFeel_1_1SVD.html</anchorfile>
      <anchor>a9a8e75cf72a20bda520e843d2dbf1b2a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>matrix_type const &amp;</type>
      <name>V</name>
      <anchorfile>classFeel_1_1SVD.html</anchorfile>
      <anchor>a0ad3ae3a620e3b401e9e85af1a5fac62</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>vector_type const &amp;</type>
      <name>S</name>
      <anchorfile>classFeel_1_1SVD.html</anchorfile>
      <anchor>a9818aafc31c7964d079efb51b9bc323b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>conditionNumber</name>
      <anchorfile>classFeel_1_1SVD.html</anchorfile>
      <anchor>a21d7676130613751e459b83801ee1443</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>conditionNumber</name>
      <anchorfile>classFeel_1_1SVD.html</anchorfile>
      <anchor>ae5832a07980cd1efc6bacfcd53cb5f33</anchor>
      <arglist>(value_type &amp;__max, value_type &amp;__min) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::SOrth</name>
    <filename>classFeel_1_1SOrth.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>MatrixA::value_type</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1SOrth.html</anchorfile>
      <anchor>a06202ddccb85900b414b1ecf4e8d6b10</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>MatrixA</type>
      <name>matrix_type</name>
      <anchorfile>classFeel_1_1SOrth.html</anchorfile>
      <anchor>a89328e17bf554dfb91f1932823abd4f2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::numeric::ublas::vector&lt; value_type &gt;</type>
      <name>vector_type</name>
      <anchorfile>classFeel_1_1SOrth.html</anchorfile>
      <anchor>a168f8e51907c155af9d46992031e2578</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SOrth</name>
      <anchorfile>classFeel_1_1SOrth.html</anchorfile>
      <anchor>ac6784c88bf78ef0b5ee69086cc45d379</anchor>
      <arglist>(matrix_type const &amp;__A)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SOrth</name>
      <anchorfile>classFeel_1_1SOrth.html</anchorfile>
      <anchor>a396e2587bbd07b98e111645c47c56810</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>matrix_type const &amp;</type>
      <name>Q</name>
      <anchorfile>classFeel_1_1SOrth.html</anchorfile>
      <anchor>a21aba711e2efc6e75039ac793a354bab</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::Vector</name>
    <filename>classFeel_1_1Vector.html</filename>
    <templarg>T</templarg>
    <member kind="typedef">
      <type>T</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>af8431cb232027e05ea646005790d7670</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>type_traits&lt; T &gt;::real_type</type>
      <name>real_type</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a17759a986f195ee336edf9a5c4323647</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Vector&lt; T &gt;</type>
      <name>self_type</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a55b89613939a338c42e16d8018af8725</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; Vector&lt; T &gt; &gt;</type>
      <name>self_ptrtype</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a98dacdd5252b7045fb6cc4e9f1f39052</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; Vector&lt; T &gt; &gt;</type>
      <name>clone_ptrtype</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a0b8b2025b99c4e88939719873afe6a6a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Vector</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>aeae03d306c99af6cb09412e2d8a5ccd9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Vector</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a72bf00a6658308c9dba0d6676d03d388</anchor>
      <arglist>(DataMap const &amp;n)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Vector</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>ad0f246b3e97c9103ffee87e1699d2389</anchor>
      <arglist>(const size_type n, WorldComm const &amp;_worldComm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Vector</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a77b1b62bba87b26d727fb0c435b1036f</anchor>
      <arglist>(const size_type n, const size_type n_local, WorldComm const &amp;_worldComm=WorldComm())</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Vector</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a65c96e11807cb8e4f7b837c965f018fa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DataMap const &amp;</type>
      <name>map</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a1b1a9d9ef02cb82e73987fd62ccf3b9e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMap</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a2ecd0e6965ad23d5cac7aab440b34750</anchor>
      <arglist>(DataMap const &amp;d)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isInitialized</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>ae1ee49886089100aa010b367a2fe96ec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>closed</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a1fb6d5cae0d8f08a0eb259fb059f8912</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>close</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a8197cdcbc7e3e42a120dd4cb92142bc9</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clear</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a6500b1f90a393c40fd72750fad934dd8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>zero</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a1d48400772fdd642d38d13de166c6a96</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>zero</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>ad6f146857ee304d460be51f4580b2035</anchor>
      <arglist>(size_type, size_type)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setConstant</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a802efdc1a50b73df1263540b0febd23b</anchor>
      <arglist>(value_type v)=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setZero</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a9700d04dc71e1005a6566b0473791285</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setOnes</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>ac8ff1990d9058f9d574a6921a52d8f89</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual clone_ptrtype</type>
      <name>clone</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a250ab7ae797133a4a5991ceacd84a808</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a64b0a6a0ffe1520e31ef41e7596fc045</anchor>
      <arglist>(const size_type, const size_type, const bool=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>ac2d59083e4edb99fd1c175dbf9927b98</anchor>
      <arglist>(const size_type, const bool=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a9dfcb635386d463a56114d1b37dfbf33</anchor>
      <arglist>(DataMap const &amp;dm)</arglist>
    </member>
    <member kind="function">
      <type>Vector&lt; T &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a8e4f96dfe19926e203a12f7b5162fa38</anchor>
      <arglist>(const T s)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Vector&lt; T &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a9054e7862bfa7a0ac623cf0b2cfac377</anchor>
      <arglist>(const Vector&lt; T &gt; &amp;V)</arglist>
    </member>
    <member kind="function">
      <type>Vector&lt; T &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a64fa57e0d589dded83d114f703571777</anchor>
      <arglist>(const std::vector&lt; T &gt; &amp;v)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual value_type</type>
      <name>sum</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a8c29938c211c42f3e7b877aeec492f85</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual real_type</type>
      <name>min</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a55e62b337ab4780c73ad9a11cc80df1f</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual real_type</type>
      <name>max</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a4ff083f28a01c228e59849ec8d6e3ba8</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual real_type</type>
      <name>l1Norm</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a83d41ddedb49b1b0d66990ad6176305e</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual real_type</type>
      <name>l2Norm</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>ab02f4bb16b05492b3999d00d4732d31a</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual real_type</type>
      <name>linftyNorm</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>ae57fc81ba2159bf778c1627c8cbedce2</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual size_type</type>
      <name>size</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>aa72e2b2dd8e668a5770d637d6cc5df48</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual size_type</type>
      <name>localSize</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>ab2206523b4a31eca0f22681f09fd5ccf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual size_type</type>
      <name>firstLocalIndex</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>afe3818fde80c29bc2e20da7cbf667e16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual size_type</type>
      <name>lastLocalIndex</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a3b92cc08dd59a1c9046c30daf7b1db00</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>WorldComm const &amp;</type>
      <name>comm</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a06319f6056ae5cc9796c271493dfb5e0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual T</type>
      <name>operator()</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a31d079a0cdfe1d2ae885346ccdbfefb2</anchor>
      <arglist>(const size_type i) const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual Vector&lt; T &gt; &amp;</type>
      <name>operator+=</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a757f412ef87b76396f1846843673a5f5</anchor>
      <arglist>(const Vector&lt; value_type &gt; &amp;V)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual Vector&lt; T &gt; &amp;</type>
      <name>operator-=</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>af20c8af9dfa6db7c81fad2f6192c927c</anchor>
      <arglist>(const Vector&lt; value_type &gt; &amp;V)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>set</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>aa98adb864bb90b44c083922cd091cb7d</anchor>
      <arglist>(const size_type i, const value_type &amp;value)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>add</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>acb5ba1c3b8d338d51f06495ac57d05ff</anchor>
      <arglist>(const size_type i, const value_type &amp;value)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>addVector</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a79c3b935262d520b1e466540fa65c8ab</anchor>
      <arglist>(int *i, int n, value_type *v)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>add</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>aec185fd73755d8c1c065599d1ce68038</anchor>
      <arglist>(const value_type &amp;s)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>add</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a9c22bb4a391bab51ed5b218a5bef0329</anchor>
      <arglist>(const Vector&lt; value_type &gt; &amp;V)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>add</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a5f3d1a5aba396527fbd56259ac55c590</anchor>
      <arglist>(const value_type &amp;a, const Vector&lt; value_type &gt; &amp;v)=0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>ae02bcb9890e6c7e9311d2c69973c126e</anchor>
      <arglist>(const value_type &amp;a, const boost::shared_ptr&lt; Vector&lt; value_type &gt; &gt; &amp;v)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>addVector</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a03ef1746d4704135b5c0728560012684</anchor>
      <arglist>(const std::vector&lt; T &gt; &amp;v, const std::vector&lt; size_type &gt; &amp;dof_indices)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>addVector</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>abb13179d6f38335ee919c34d97c31bf9</anchor>
      <arglist>(const Vector&lt; T &gt; &amp;V, const std::vector&lt; size_type &gt; &amp;dof_indices)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>addVector</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a1cf06dfe2553ca4e91935128421f55ad</anchor>
      <arglist>(const Vector&lt; T &gt; &amp;V_in, const MatrixSparse&lt; T &gt; &amp;A_in)=0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addVector</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a526ad3a552b7ca3bd9f03df2f44bcdef</anchor>
      <arglist>(const boost::shared_ptr&lt; Vector&lt; T &gt; &gt; &amp;V_in, const boost::shared_ptr&lt; MatrixSparse&lt; T &gt; &gt; &amp;A_in)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addVector</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a60faec7ed24680b9786593024034bb55</anchor>
      <arglist>(const Vector&lt; T &gt; &amp;V_in, const MatrixShell&lt; T &gt; &amp;A_in)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addVector</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a73b984840b24214932cc94b3defc8c90</anchor>
      <arglist>(const boost::shared_ptr&lt; Vector&lt; T &gt; &gt; &amp;V_in, const boost::shared_ptr&lt; MatrixShell&lt; T &gt; &gt; &amp;A_in)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>insert</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a978783b69e9d5a2dc406f1914b2b419f</anchor>
      <arglist>(const std::vector&lt; T &gt; &amp;v, const std::vector&lt; size_type &gt; &amp;dof_indices)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>insert</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>ade8b49e2047830bd1e5a0f1c5ee722dc</anchor>
      <arglist>(const Vector&lt; T &gt; &amp;V, const std::vector&lt; size_type &gt; &amp;dof_indices)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>insert</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a74bc99bddfb6b773d595da8006948b18</anchor>
      <arglist>(const ublas::vector&lt; T &gt; &amp;V, const std::vector&lt; size_type &gt; &amp;dof_indices)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>scale</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a185036c930b27392da10f52f3f349b79</anchor>
      <arglist>(const T factor)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>localize</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>ae9e3c1d2406370cd28d6556c25f4a96b</anchor>
      <arglist>(std::vector&lt; T &gt; &amp;v_local) const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>localize</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>ad9a4b8eeca3a349b7becc2875fcc8da5</anchor>
      <arglist>(Vector&lt; T &gt; &amp;v_local) const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>localize</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a9b5d880c4827a7d33c835bd09fa245c3</anchor>
      <arglist>(Vector&lt; T &gt; &amp;v_local, const std::vector&lt; size_type &gt; &amp;send_list) const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>localize</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a689fe1f4b83dd36690bfa52fb3b4a8bd</anchor>
      <arglist>(const size_type first_local_idx, const size_type last_local_idx, const std::vector&lt; size_type &gt; &amp;send_list)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>localizeToOneProcessor</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>ab2fc26e2058990afc4a0261813c9a574</anchor>
      <arglist>(std::vector&lt; T &gt; &amp;v_local, const size_type proc_id=0) const =0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>compare</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a884d738439c93bc2b7a57d8ecb6c5427</anchor>
      <arglist>(const Vector&lt; T &gt; &amp;other_vector, const real_type threshold=1e-10) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>print</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>ac6e0c2d5b7a43518a689ad438d93c637</anchor>
      <arglist>(std::ostream &amp;os=std::cout) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>printMatlab</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a66895d368add5a6d4fd6bfa8b215c2d3</anchor>
      <arglist>(const std::string name=&quot;NULL&quot;) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>createSubvector</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>adbbb9ae5297919cc8f87f3b8b107805e</anchor>
      <arglist>(Vector&lt; T &gt; &amp;, const std::vector&lt; size_type &gt; &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>compare</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>aaa1bd5c2b9a4e8c7a4688accfbdbe9b2</anchor>
      <arglist>(const Vector&lt; float &gt; &amp;other_vector, const real_type threshold) const</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>compare</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a1044cae6a5d95ec8814f9b1933118cfe</anchor>
      <arglist>(const Vector&lt; double &gt; &amp;other_vector, const real_type threshold) const</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>M_is_closed</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a8bb58529298dbdfa71aed1eaffb84872</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>M_is_initialized</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a680e5401f8aa711ecd49fe3b6b7c409d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>DataMap</type>
      <name>M_map</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>a804b8da8d3d7077a1795fdb0f9adfa1f</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1Vector.html</anchorfile>
      <anchor>ab79b8b7e3451f8163c16ba303815ed54</anchor>
      <arglist>(std::ostream &amp;os, const Vector&lt; T &gt; &amp;v)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::BlocksBaseVector</name>
    <filename>classFeel_1_1BlocksBaseVector.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>vf::BlocksBase&lt; boost::shared_ptr&lt; Vector&lt; T &gt; &gt; &gt;</type>
      <name>super_type</name>
      <anchorfile>classFeel_1_1BlocksBaseVector.html</anchorfile>
      <anchor>afe3632c7a2fee31799a0192f132ff1b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>BlocksBaseVector&lt; T &gt;</type>
      <name>self_type</name>
      <anchorfile>classFeel_1_1BlocksBaseVector.html</anchorfile>
      <anchor>abb705c44a95f21009fc4262bee24bcaf</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Vector&lt; T &gt;</type>
      <name>vector_type</name>
      <anchorfile>classFeel_1_1BlocksBaseVector.html</anchorfile>
      <anchor>a75d507d160db1ab700caa8c61eb9b255</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; vector_type &gt;</type>
      <name>vector_ptrtype</name>
      <anchorfile>classFeel_1_1BlocksBaseVector.html</anchorfile>
      <anchor>a152e1ac3832547dc3d2760a5034ddc78</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BlocksBaseVector</name>
      <anchorfile>classFeel_1_1BlocksBaseVector.html</anchorfile>
      <anchor>a803a6d0b6dc35c07fbfac1b433b18877</anchor>
      <arglist>(uint16_type nr)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BlocksBaseVector</name>
      <anchorfile>classFeel_1_1BlocksBaseVector.html</anchorfile>
      <anchor>add3444b647baed585b51500e505418f4</anchor>
      <arglist>(super_type const &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>self_type</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classFeel_1_1BlocksBaseVector.html</anchorfile>
      <anchor>a507321fc5d478d721e9d8d43f67829d0</anchor>
      <arglist>(vector_ptrtype const &amp;m) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>localize</name>
      <anchorfile>classFeel_1_1BlocksBaseVector.html</anchorfile>
      <anchor>aeceef920be6c3191a4bd6e2124e559ef</anchor>
      <arglist>(vector_ptrtype const &amp;vb)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::BlocksVector</name>
    <filename>classFeel_1_1BlocksVector.html</filename>
    <templarg>NR</templarg>
    <templarg></templarg>
    <base>Feel::BlocksBaseVector</base>
    <member kind="typedef">
      <type>BlocksBaseVector&lt; T &gt;</type>
      <name>super_type</name>
      <anchorfile>classFeel_1_1BlocksVector.html</anchorfile>
      <anchor>a1a20d8ea78addb20557cd9d58c99529b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>NBLOCKROWS</name>
      <anchorfile>classFeel_1_1BlocksVector.html</anchorfile>
      <anchor>aecf97228a2fd6d8b0961ffd0df0de15d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>NBLOCKCOLS</name>
      <anchorfile>classFeel_1_1BlocksVector.html</anchorfile>
      <anchor>aca819da86f264dbe5d0a0bd64f50e683</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::VectorBlockBase</name>
    <filename>classFeel_1_1VectorBlockBase.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>VectorBlockBase&lt; T &gt;</type>
      <name>self_type</name>
      <anchorfile>classFeel_1_1VectorBlockBase.html</anchorfile>
      <anchor>ab0ec6d1b814682c72999476cd7d906dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>T</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1VectorBlockBase.html</anchorfile>
      <anchor>a9f8642f6c97d66a986d346c6644858b1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Backend&lt; value_type &gt;</type>
      <name>backend_type</name>
      <anchorfile>classFeel_1_1VectorBlockBase.html</anchorfile>
      <anchor>a91703ed72a9b223d0f6e9759d977ebcb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; backend_type &gt;</type>
      <name>backend_ptrtype</name>
      <anchorfile>classFeel_1_1VectorBlockBase.html</anchorfile>
      <anchor>a9a6f07db145d5f09bcb7f5fcab69b5c1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Vector&lt; T &gt;</type>
      <name>vector_type</name>
      <anchorfile>classFeel_1_1VectorBlockBase.html</anchorfile>
      <anchor>acc521d6d54cee14763406b45e9baf947</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; vector_type &gt;</type>
      <name>vector_ptrtype</name>
      <anchorfile>classFeel_1_1VectorBlockBase.html</anchorfile>
      <anchor>a3206fdb5ca6e78b1bbb96667a2bd73ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>VectorBlockBase</name>
      <anchorfile>classFeel_1_1VectorBlockBase.html</anchorfile>
      <anchor>a8506d584d18f034c1c610996a235cad2</anchor>
      <arglist>(vf::BlocksBase&lt; vector_ptrtype &gt; const &amp;blockVec, backend_type &amp;backend, bool copy_values=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>VectorBlockBase</name>
      <anchorfile>classFeel_1_1VectorBlockBase.html</anchorfile>
      <anchor>a39289bcd49015f6ef4ff5b2aee0ad375</anchor>
      <arglist>(VectorBlockBase const &amp;vb)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~VectorBlockBase</name>
      <anchorfile>classFeel_1_1VectorBlockBase.html</anchorfile>
      <anchor>a5cdc59a780a6f97548113c9682bc10cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>VectorBlockBase</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1VectorBlockBase.html</anchorfile>
      <anchor>a68cb568a9aed6a151320472d545e55d1</anchor>
      <arglist>(VectorBlockBase const &amp;vb)</arglist>
    </member>
    <member kind="function">
      <type>vector_ptrtype</type>
      <name>getVector</name>
      <anchorfile>classFeel_1_1VectorBlockBase.html</anchorfile>
      <anchor>a83a669d087af49572366c63d6b49c603</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateBlockVec</name>
      <anchorfile>classFeel_1_1VectorBlockBase.html</anchorfile>
      <anchor>afbc432ce00e70066dd37babc4bdc2cb1</anchor>
      <arglist>(vector_ptrtype const &amp;m, size_type start_i)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::VectorBlock</name>
    <filename>classFeel_1_1VectorBlock.html</filename>
    <templarg>NR</templarg>
    <templarg></templarg>
    <base>Feel::VectorBlockBase</base>
    <member kind="typedef">
      <type>super_type::value_type</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1VectorBlock.html</anchorfile>
      <anchor>a9ddb0d33f70dcf8b936323ecd49627a8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super_type::vector_ptrtype</type>
      <name>vector_ptrtype</name>
      <anchorfile>classFeel_1_1VectorBlock.html</anchorfile>
      <anchor>a9c84cfe5ba6084cb4fb580758277e80a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super_type::backend_type</type>
      <name>backend_type</name>
      <anchorfile>classFeel_1_1VectorBlock.html</anchorfile>
      <anchor>aa7a9472d425630345f9c5e0863d9d31e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>vf::Blocks&lt; NBLOCKROWS, 1, vector_ptrtype &gt;</type>
      <name>blocks_type</name>
      <anchorfile>classFeel_1_1VectorBlock.html</anchorfile>
      <anchor>a15d003a74cb25f88ee37edcb9e8ee739</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>vf::BlocksBase&lt; vector_ptrtype &gt;</type>
      <name>blocksbase_type</name>
      <anchorfile>classFeel_1_1VectorBlock.html</anchorfile>
      <anchor>a3f620322ad4d7e643a368e2438fece32</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>VectorBlock</name>
      <anchorfile>classFeel_1_1VectorBlock.html</anchorfile>
      <anchor>ac93c8edf319520be98093383147e0f42</anchor>
      <arglist>(blocksbase_type const &amp;blockVec, backend_type &amp;backend, bool copy_values=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>VectorBlock</name>
      <anchorfile>classFeel_1_1VectorBlock.html</anchorfile>
      <anchor>ab99a570a38939ae0d3badb240b4657b5</anchor>
      <arglist>(VectorBlock const &amp;vb)</arglist>
    </member>
    <member kind="function">
      <type>VectorBlock</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1VectorBlock.html</anchorfile>
      <anchor>a2acc5d7403533a700eb70aaf147ee701</anchor>
      <arglist>(VectorBlock const &amp;vb)</arglist>
    </member>
    <member kind="function">
      <type>VectorBlock &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1VectorBlock.html</anchorfile>
      <anchor>a67bd66b7621d0790119ecdaef12df997</anchor>
      <arglist>(vector_ptrtype const &amp;F)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>NBLOCKROWS</name>
      <anchorfile>classFeel_1_1VectorBlock.html</anchorfile>
      <anchor>a4137ef4b08536eb14b94dce90d4ccc25</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::VectorUblas</name>
    <filename>classFeel_1_1VectorUblas.html</filename>
    <templarg>T</templarg>
    <templarg>Storage</templarg>
    <base>Feel::Vector</base>
    <class kind="struct">Feel::VectorUblas::range</class>
    <class kind="struct">Feel::VectorUblas::slice</class>
    <member kind="typedef">
      <type>T</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a48281d3ef617107a29fba58cee7a023c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>type_traits&lt; value_type &gt;::real_type</type>
      <name>real_type</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a814881b4d84aa3acb000ba6f69076b8d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Storage</type>
      <name>vector_type</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>ac1f8f0141743e4b77bd24d79de1d2e48</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>vector_type::difference_type</type>
      <name>difference_type</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>aefb11c0a7dbcfd0840e839cb61677306</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ublas::basic_range&lt; size_type, difference_type &gt;</type>
      <name>range_type</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a3f4f3af1714b00d1492d4d80ec9dfe8b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ublas::basic_slice&lt; size_type, difference_type &gt;</type>
      <name>slice_type</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a0c93e607fab57021acca48bfa5a499cf</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Vector&lt; value_type &gt;</type>
      <name>clone_type</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>abdf6006890692ee0b4176f0ba141530d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; clone_type &gt;</type>
      <name>clone_ptrtype</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a2a0f840b5c7bac408f737e2c72f59aa9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>VectorUblas&lt; value_type, Storage &gt;</type>
      <name>this_type</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>af92b7784e5076f26323f267ba90d6ecf</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>vector_type::iterator</type>
      <name>iterator</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a1f4aa186e7a6e28802ae868a1204fab2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>vector_type::const_iterator</type>
      <name>const_iterator</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a60a3addb6436e0143940701bc35e4008</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>VectorUblas</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>aed76f0169870469061d2e54be6b07fac</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>VectorUblas</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>adad7ad6faefc9c87abe9a52025c9a76f</anchor>
      <arglist>(size_type __s)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>VectorUblas</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>aca1fb99e59a5f86b0a3fda07c5ba20f3</anchor>
      <arglist>(DataMap const &amp;dm)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>VectorUblas</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>acb1ccc0a2c777ce4d7674325cfb7797a</anchor>
      <arglist>(size_type __s, size_type __n_local)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>VectorUblas</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a517d80356f3e87dcba1fd17ff5513c53</anchor>
      <arglist>(VectorUblas const &amp;m)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>VectorUblas</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a3db2f5771d16c33d6d553da5e184c0e1</anchor>
      <arglist>(VectorUblas&lt; value_type &gt; &amp;m, range_type const &amp;range, DataMap const &amp;dm)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>VectorUblas</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a2bbb138015effbd7e289d47ebf501a10</anchor>
      <arglist>(ublas::vector&lt; value_type &gt; &amp;m, range_type const &amp;range)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>VectorUblas</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a7365970981d0ded5b7e43f15d522c842</anchor>
      <arglist>(VectorUblas&lt; value_type &gt; &amp;m, slice_type const &amp;slice)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>VectorUblas</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a3dc298af18f5475136084f71d27fa4e4</anchor>
      <arglist>(ublas::vector&lt; value_type &gt; &amp;m, slice_type const &amp;slice)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~VectorUblas</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a18ab48a52b0597995fbb069aa1ecab3b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a0a7d185a2a530d5c764352b7dbc19d62</anchor>
      <arglist>(const size_type N, const size_type n_local, const bool fast=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a47b686ab43d4652641db32a33eea0a71</anchor>
      <arglist>(const size_type n, const bool fast=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>ad4ee119a6988226686da02ad2a093120</anchor>
      <arglist>(DataMap const &amp;dm)</arglist>
    </member>
    <member kind="function">
      <type>clone_ptrtype</type>
      <name>clone</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a049a80f70c7c87fe1375dc22304dc2c3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Vector&lt; value_type &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a82836f9f5aa1c5406579fc352d1e9c4b</anchor>
      <arglist>(const Vector&lt; value_type &gt; &amp;V)</arglist>
    </member>
    <member kind="function">
      <type>VectorUblas&lt; value_type, Storage &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a2b848a8d6932304f9171a0501e0aca81</anchor>
      <arglist>(ublas::vector_expression&lt; AE &gt; const &amp;e)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>operator()</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a1c54a62ba99f733d381094d91dc6ceb0</anchor>
      <arglist>(size_type i) const </arglist>
    </member>
    <member kind="function">
      <type>T &amp;</type>
      <name>operator()</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a5ead153858cf508f83c3ed56203e46cf</anchor>
      <arglist>(size_type i)</arglist>
    </member>
    <member kind="function">
      <type>T</type>
      <name>operator[]</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a8590b8f0ee6f060c9e98382bd337fe81</anchor>
      <arglist>(size_type i) const </arglist>
    </member>
    <member kind="function">
      <type>T &amp;</type>
      <name>operator[]</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>ad27d342053e6f08b9f510cf4d51c599e</anchor>
      <arglist>(size_type i)</arglist>
    </member>
    <member kind="function">
      <type>Vector&lt; T &gt; &amp;</type>
      <name>operator+=</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a1a301ac6bac8bd17c10ecf07b14bb52d</anchor>
      <arglist>(const Vector&lt; T &gt; &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>Vector&lt; T &gt; &amp;</type>
      <name>operator-=</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a3f1f5c034a688feb17e2340cc0e625da</anchor>
      <arglist>(const Vector&lt; T &gt; &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>iterator</type>
      <name>begin</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a55cb245763c8d8cc1afb7870e8ae4e24</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const_iterator</type>
      <name>begin</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>aaec8a14619ad1bd62cc4a930f1325bb4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>iterator</type>
      <name>end</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a704d3609ac856c6b5fa161fa89d79186</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const_iterator</type>
      <name>end</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>ac1acdeaef9f44ab7ed5eb809c512e611</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>start</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>afb6c5f8ea8b5a06adb515f17e562f749</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>rowStart</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>aa454d6ab3ab2cf9dbf5e44c07ae868ba</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>rowStop</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>aa7319aa003d5da4f4304b11665817d55</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isInitialized</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>ab834159f723647a136588491d87ee6a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>ac021eca36c5c83b82197b851c9bb69c0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>closed</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a374a548ff6577f309ef2a7b0a909a269</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>vector_type const &amp;</type>
      <name>vec</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a4938bfc05b0ef99a6613667fffbc7171</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>vector_type &amp;</type>
      <name>vec</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>aea1ca1eb67e2c81982774517f3016c56</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>areGlobalValuesUpdated</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a50866b9e782d229b69bcc980fd3771ea</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateGlobalValues</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a34b5fec8f1d3f7946a7a674eea875df4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>globalValue</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a2886e83bc8e842f8fc9d31710a6e375a</anchor>
      <arglist>(size_type i) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>outdateGlobalValues</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>ab9aabfa9febab4b575cd720fc3121246</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGlobalValue</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a9af62babdb52dbc89f65ec992234baf6</anchor>
      <arglist>(size_type i, value_type v) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setConstant</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a52288c4b56d1663a01173f0d198da5af</anchor>
      <arglist>(value_type v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a9e9bb222b26cd37835eb715e5c693ade</anchor>
      <arglist>(size_type n, bool preserve=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a44fa9d6467b03bff5b0389866bcdf0e7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zero</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a61ff5dc9f577ef65613749ae30233076</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zero</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a0ba3706ea76b995f9e79dd7eb3843fa0</anchor>
      <arglist>(size_type, size_type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>af03c3e19845fdc2ac864de55a228d0c7</anchor>
      <arglist>(const size_type i, const value_type &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addVector</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a4d3e60ea257bc0d97dbebab93f4f8da3</anchor>
      <arglist>(int *i, int n, value_type *v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a5913513666fee0e439ef951e7baafe60</anchor>
      <arglist>(size_type i, const value_type &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addVector</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>aba73202f14c7c6f46ee64d430a3e86d7</anchor>
      <arglist>(const std::vector&lt; value_type &gt; &amp;v, const std::vector&lt; size_type &gt; &amp;dof_indices)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addVector</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a0bb472ef8413288bccd49ee34f2184bf</anchor>
      <arglist>(const Vector&lt; value_type &gt; &amp;V, const std::vector&lt; size_type &gt; &amp;dof_indices)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addVector</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>ae6ca57abf8db1080ba24da909e2cf870</anchor>
      <arglist>(const Vector&lt; value_type &gt; &amp;, const MatrixSparse&lt; value_type &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addVector</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a605914a21b98e2a7e652cf22e1c672ac</anchor>
      <arglist>(const ublas::vector&lt; value_type &gt; &amp;V, const std::vector&lt; size_type &gt; &amp;dof_indices)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>abdf32b9f7498837eda9b7d897758c806</anchor>
      <arglist>(const std::vector&lt; T &gt; &amp;, const std::vector&lt; size_type &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>ad6461b9ddeddc696e4b426ad58325088</anchor>
      <arglist>(const Vector&lt; T &gt; &amp;, const std::vector&lt; size_type &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>aad1691e44432e1e146011a52e947d346</anchor>
      <arglist>(const ublas::vector&lt; T &gt; &amp;, const std::vector&lt; size_type &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scale</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a05d4a17feacf9bb1e10b032904e54d3f</anchor>
      <arglist>(const T factor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printMatlab</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>ac1f72ed654aaa9b8febb81a061119aa0</anchor>
      <arglist>(const std::string name=&quot;NULL&quot;) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a87f92de2d1f70480fffcdb5a82431552</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>real_type</type>
      <name>min</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>aa9fbfb66c4724f91f2e62d68754c59f4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>real_type</type>
      <name>max</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a7e6ce6b8c945b1f8cac267949640d5bd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>real_type</type>
      <name>l1Norm</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>aec63f0c370ed848fc8ed66833f0cd5fa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>real_type</type>
      <name>l2Norm</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>aec81e78a04ed883284a5f7ae570da014</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>real_type</type>
      <name>linftyNorm</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>afa47c304c8438ec8ce1100b9564c5433</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>sum</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a0d1c90b1ad52e41a73cf55bb87351edb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FEELPP_DONT_INLINE this_type</type>
      <name>sqrt</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>abc4f11075aeff3604dae088559574cd0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>this_type</type>
      <name>pow</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a9ce5c618f5244843282f2d0e768f3d46</anchor>
      <arglist>(int n) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>ae63f74f3279d858d3b8ce845a38cf749</anchor>
      <arglist>(const T &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a08239a5208ea5f44c393389bc1977e39</anchor>
      <arglist>(const Vector&lt; T &gt; &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a8021eb188057836a361762c72be1bb66</anchor>
      <arglist>(const T &amp;a, const Vector&lt; T &gt; &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>localize</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>aaa5188e4198942f4db7bb145801ae620</anchor>
      <arglist>(std::vector&lt; value_type &gt; &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>localize</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a5da61737c23d189ab89dc0342d2feac9</anchor>
      <arglist>(ublas::vector&lt; value_type &gt; &amp;v_local) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>localize</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a5e85d9c3eb15f1f64824ab45d1f73e05</anchor>
      <arglist>(ublas::vector_range&lt; ublas::vector&lt; value_type &gt; &gt; &amp;v_local) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>localize</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>ae541216b48cb6224008a353650a6a955</anchor>
      <arglist>(ublas::vector_slice&lt; ublas::vector&lt; value_type &gt; &gt; &amp;v_local) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>localize</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>acb4eabd8e0ede682a48939948b13eb96</anchor>
      <arglist>(Vector&lt; T &gt; &amp;v_local) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>localize</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>afadf6615b5f9a0866ecba821ec159fbb</anchor>
      <arglist>(Vector&lt; T &gt; &amp;v_local, const std::vector&lt; size_type &gt; &amp;send_list) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>localize</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a80adc6e35f49d249ccae2d199667e441</anchor>
      <arglist>(const size_type first_local_idx, const size_type last_local_idx, const std::vector&lt; size_type &gt; &amp;send_list)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>localizeToOneProcessor</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a7afcd0c77d64ae782cce25c0214e1dc6</anchor>
      <arglist>(ublas::vector&lt; T &gt; &amp;v_local, const size_type proc_id=0) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>localizeToOneProcessor</name>
      <anchorfile>classFeel_1_1VectorUblas.html</anchorfile>
      <anchor>a9ce6132874dd90a1b9d5eb8fc8d46540</anchor>
      <arglist>(std::vector&lt; T &gt; &amp;v_local, const size_type proc_id=0) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::VectorUblas::range</name>
    <filename>structFeel_1_1VectorUblas_1_1range.html</filename>
    <member kind="typedef">
      <type>ublas::vector_range&lt; ublas::vector&lt; value_type &gt; &gt;</type>
      <name>subtype</name>
      <anchorfile>structFeel_1_1VectorUblas_1_1range.html</anchorfile>
      <anchor>ab77819fbb5a18a6b518f1c4722cae1ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>VectorUblas&lt; value_type, subtype &gt;</type>
      <name>type</name>
      <anchorfile>structFeel_1_1VectorUblas_1_1range.html</anchorfile>
      <anchor>aa37404b4364dd14a81a6b091806876f1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::VectorUblas::slice</name>
    <filename>structFeel_1_1VectorUblas_1_1slice.html</filename>
    <member kind="typedef">
      <type>ublas::vector_slice&lt; ublas::vector&lt; value_type &gt; &gt;</type>
      <name>subtype</name>
      <anchorfile>structFeel_1_1VectorUblas_1_1slice.html</anchorfile>
      <anchor>aed00881880aa5be41c2d3e9292d9b024</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>VectorUblas&lt; value_type, subtype &gt;</type>
      <name>type</name>
      <anchorfile>structFeel_1_1VectorUblas_1_1slice.html</anchorfile>
      <anchor>aeea386c3118dd5b6e31b84375d81f4f8</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::VectorValue</name>
    <filename>classFeel_1_1VectorValue.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>T</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>a262afda924e4c286b8a50bd51b94a972</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>value_type</type>
      <name>vector_type</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>a053a0d734b773356ec3e4cc54066cfb4</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>VectorValue</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>addbf68e1c02cfb810c240a51a62367c8</anchor>
      <arglist>(value_type acc=value_type(0))</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>VectorValue</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>a52cf2885c80fcd15c4d51a2bddbdc808</anchor>
      <arglist>(VectorValue const &amp;m)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~VectorValue</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>a59b6fdf96197e473b97ef8454c29b9ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>value_type &amp;</type>
      <name>operator()</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>ae02e26004472f24fd68b81941a7c9cf0</anchor>
      <arglist>(size_type)</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>size</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>a88ac42d47cc9f36f399a19bde96b4baf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>rowStart</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>a369855b021a6c4af42aecaa7cf54f634</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>rowStop</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>a9817e5ef088a2dc5790f067e8284b803</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isInitialized</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>a8b69c1e3b858e38a65bba69af34a7aaa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>a3a09f7d8927ee589f6b78400204b88b7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>closed</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>ab6d8efd6c9141e63746cbea5795656b8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>vector_type const &amp;</type>
      <name>vec</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>a96cd34dbe90674ba7f2388eacc49a00c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>vector_type &amp;</type>
      <name>vec</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>a65e2bcae22de6a274a0c0c8d9ddef700</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>aaa4628f1fa637858075e2f3a4470f34e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zero</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>a2da77b394eb338ea36c59f530abe9060</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zero</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>aaa4f2fe3659f2f6b3d913ad0623faa60</anchor>
      <arglist>(size_type, size_type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>adfa6d2c783f8f22f92746e7c8416571a</anchor>
      <arglist>(const unsigned int, const value_type value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>a772e811d28ae58fb1f0707d172919386</anchor>
      <arglist>(const unsigned int, const value_type value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printMatlab</name>
      <anchorfile>classFeel_1_1VectorValue.html</anchorfile>
      <anchor>a62168276f8515fe3e984d9e1a87e0dfc</anchor>
      <arglist>(const std::string name=&quot;NULL&quot;) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::Exporter</name>
    <filename>classFeel_1_1Exporter.html</filename>
    <templarg>MeshType</templarg>
    <templarg>N</templarg>
    <base>Feel::VisitorBase</base>
    <base>Visitor&lt; MeshType &gt;</base>
    <class kind="struct">Feel::Exporter::Factory</class>
    <member kind="typedef">
      <type>VisitorBase</type>
      <name>super1</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>ac5e6ced39e80fd336fa2fbae77f8d064</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Visitor&lt; MeshType &gt;</type>
      <name>super2</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>aaf42960868220531e9041e402793ac7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>TimeSet&lt; MeshType, N &gt;</type>
      <name>timeset_type</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>afbfe9c419c6b0c333033dff1a132f838</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; timeset_type &gt;</type>
      <name>timeset_ptrtype</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a3d4c1a833dc8cfbda20ca2173ab95014</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; timeset_ptrtype &gt;</type>
      <name>timeset_set_type</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a0ff53217257df86af93cb03c8a530048</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>timeset_set_type::iterator</type>
      <name>timeset_iterator</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a884eae5e5296f97ff50d608142526c75</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>timeset_set_type::const_iterator</type>
      <name>timeset_const_iterator</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a393e0dfaafedea1878fce37675a37e87</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>timeset_type::step_type</type>
      <name>step_type</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a15b578790cdcfd92fb63a18867286102</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>timeset_type::step_ptrtype</type>
      <name>step_ptrtype</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>acac146eecfc6d48a576c13815053fca9</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>doExport</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a051ae133781cdee4795df46f2fb850f9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string const &amp;</type>
      <name>type</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a05214764672a228e2b93f4199833283c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string const &amp;</type>
      <name>prefix</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a945b57c273068cfe1e592b2b262dde32</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>freq</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a1b857c462efb43399f378a2ab8daca31</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cptOfSave</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>aeb82f802a761712a6c4fcd9f25f25720</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>file_type</type>
      <name>fileType</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a388352373374f0c8b6875d3543335919</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>path</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a5d95df5f9870598eee0c0e74f56171d5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDoExport</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a8ca8c17b7fd84e1e6744aa925b490aca</anchor>
      <arglist>(bool do_export)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Exporter&lt; MeshType, N &gt; *</type>
      <name>setOptions</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a4b12be16cee912a1fda658e24562fc7d</anchor>
      <arglist>(po::variables_map const &amp;vm, std::string const &amp;exp_prefix=&quot;&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Exporter&lt; MeshType, N &gt; *</type>
      <name>setType</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a39545fa33171ab565d74be13b0595cf1</anchor>
      <arglist>(std::string const &amp;__type)</arglist>
    </member>
    <member kind="function">
      <type>Exporter&lt; MeshType, N &gt; *</type>
      <name>addPath</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a2d3b2127a4d49196277b734b7a0a2ccd</anchor>
      <arglist>(boost::format fmt)</arglist>
    </member>
    <member kind="function">
      <type>Exporter&lt; MeshType, N &gt; *</type>
      <name>setPrefix</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>ae3bba0a66e5982b327b2592a4d92100f</anchor>
      <arglist>(std::string const &amp;__prefix)</arglist>
    </member>
    <member kind="function">
      <type>Exporter&lt; MeshType, N &gt; *</type>
      <name>setFreq</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>aafb99b3d9e9a36b33c3b7fe50ad351ac</anchor>
      <arglist>(int __freq)</arglist>
    </member>
    <member kind="function">
      <type>Exporter&lt; MeshType, N &gt; *</type>
      <name>setFileType</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a6b4c4d2695f35936abacd89592d72031</anchor>
      <arglist>(file_type __ft)</arglist>
    </member>
    <member kind="function">
      <type>timeset_iterator</type>
      <name>beginTimeSet</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a8c522f9f87cc243086b489280261f68c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>timeset_iterator</type>
      <name>endTimeSet</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a57df809b4aef23ae0dc72a890c0a6fb4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>timeset_const_iterator</type>
      <name>beginTimeSet</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a79f77c62bf5e1db7ff3961d194f4cf10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>timeset_const_iterator</type>
      <name>endTimeSet</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a18b3ccd9683eeadf7f92df892c1c7524</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>timeset_ptrtype</type>
      <name>defaultTimeSet</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>afd22ad271724cfe4245905090daaf53d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>timeset_ptrtype</type>
      <name>timeSet</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>af42d7238ad782f13095692885b1c90c3</anchor>
      <arglist>(int ts)</arglist>
    </member>
    <member kind="function">
      <type>step_ptrtype</type>
      <name>step</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>aba84ef870214b28200ba3e7d97b2f71e</anchor>
      <arglist>(double time)</arglist>
    </member>
    <member kind="function">
      <type>step_ptrtype</type>
      <name>step</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a86598ee5198f0d1e674e617b79d02859</anchor>
      <arglist>(double time, int s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addTimeSet</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>ae0cbadd9f3e483d8edb7b4664b3a67e5</anchor>
      <arglist>(timeset_ptrtype const &amp;__ts)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>save</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>ab14aab6a193acef6384113f63182689d</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveTimeSet</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>aa21e55341295c3d0c59a537fc8d13a7a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>restart</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a514d3cc3225e12502dc61780b54eecd8</anchor>
      <arglist>(double __time)</arglist>
    </member>
    <member kind="function">
      <type>WorldComm const &amp;</type>
      <name>worldComm</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>ac85a2765501450d78bcdf853e5cba6c5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>WorldComm</type>
      <name>M_worldComm</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a7f312c1e89f4727daa9d8fcde5d4de16</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>M_do_export</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>accd0ce956edf10823833c56687b0c845</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::string</type>
      <name>M_type</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a48951e826e924cd6ffffeff181eaa0dc</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::string</type>
      <name>M_prefix</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>ae05cd1241e4556be718248a5da12bf96</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>M_freq</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a45495972bc1e3da0346f51758f684e1e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>M_cptOfSave</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a36cebfcf4a10c8143e848a532810ba7d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>file_type</type>
      <name>M_ft</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a22342b6d8673281b3e6fd825e16ad657</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::string</type>
      <name>M_path</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>ab1a641e1a1a0c93bbeb9b4d54d39e7ed</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>timeset_set_type</type>
      <name>M_ts_set</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a3489fb2b439ff03a03a1504053ed1846</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Exporter</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a0b5ad5256a261dbce3cdea0aa1dd642d</anchor>
      <arglist>(std::string const &amp;type, std::string const &amp;prefix=&quot;&quot;, int freq=1, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Exporter</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a0da78c688391754ab54d30fcb2def65e</anchor>
      <arglist>(po::variables_map const &amp;vm, std::string const &amp;exporter_prefix=&quot;&quot;, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Exporter</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a16c359085e9d1b5cd4f8af750174a77d</anchor>
      <arglist>(Exporter const &amp;exporter)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Exporter</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>a78163db59b573510f143641b795838f2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Exporter&lt; MeshType, N &gt; *</type>
      <name>New</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>aee61e30f7d88108e020566a592e44a4b</anchor>
      <arglist>(std::string const &amp;exportername, std::string prefix=&quot;export&quot;, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Exporter&lt; MeshType, N &gt; *</type>
      <name>New</name>
      <anchorfile>classFeel_1_1Exporter.html</anchorfile>
      <anchor>aab1dcba7a67b42aa1471d961dd7f2180</anchor>
      <arglist>(po::variables_map const &amp;vm, std::string prefix=&quot;export&quot;, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::Exporter::Factory</name>
    <filename>structFeel_1_1Exporter_1_1Factory.html</filename>
    <member kind="typedef">
      <type>Feel::Singleton&lt; Feel::Factory&lt; Exporter&lt; MeshType, N &gt;, std::string &gt; &gt;</type>
      <name>type</name>
      <anchorfile>structFeel_1_1Exporter_1_1Factory.html</anchorfile>
      <anchor>adea04a9384d0afa679fc2e2e9bb9a4b0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::ExporterEnsight</name>
    <filename>classFeel_1_1ExporterEnsight.html</filename>
    <templarg>MeshType</templarg>
    <templarg>N</templarg>
    <base>Feel::Exporter</base>
    <member kind="typedef">
      <type>MeshType</type>
      <name>mesh_type</name>
      <anchorfile>classFeel_1_1ExporterEnsight.html</anchorfile>
      <anchor>a4df836c0a4291e96d9e1c04572cbdd17</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::timeset_type</type>
      <name>timeset_type</name>
      <anchorfile>classFeel_1_1ExporterEnsight.html</anchorfile>
      <anchor>ae28b4c6e627b786d68d2067fe1aee16b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::timeset_ptrtype</type>
      <name>timeset_ptrtype</name>
      <anchorfile>classFeel_1_1ExporterEnsight.html</anchorfile>
      <anchor>a0825cdd96161307cc291368abe8f995a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::timeset_iterator</type>
      <name>timeset_iterator</name>
      <anchorfile>classFeel_1_1ExporterEnsight.html</anchorfile>
      <anchor>a4bdad1955d00e9eae1abab06f14e98b4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::timeset_const_iterator</type>
      <name>timeset_const_iterator</name>
      <anchorfile>classFeel_1_1ExporterEnsight.html</anchorfile>
      <anchor>a1b9b57acdf4a2aad069eca37ae692b7a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ExporterEnsight</name>
      <anchorfile>classFeel_1_1ExporterEnsight.html</anchorfile>
      <anchor>a405d082b408059b7546a0df7082a8547</anchor>
      <arglist>(std::string const &amp;__p=&quot;default&quot;, int freq=1, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ExporterEnsight</name>
      <anchorfile>classFeel_1_1ExporterEnsight.html</anchorfile>
      <anchor>af8e6db580067da99ff67fcbfe0c39fb9</anchor>
      <arglist>(po::variables_map const &amp;vm, std::string const &amp;exp_prefix=&quot;&quot;, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ExporterEnsight</name>
      <anchorfile>classFeel_1_1ExporterEnsight.html</anchorfile>
      <anchor>a671eff629872231ba2c9c5ad4ef84601</anchor>
      <arglist>(ExporterEnsight const &amp;__ex)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~ExporterEnsight</name>
      <anchorfile>classFeel_1_1ExporterEnsight.html</anchorfile>
      <anchor>aa4c80c29480305549753b4f29b98ab03</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string const &amp;</type>
      <name>elementType</name>
      <anchorfile>classFeel_1_1ExporterEnsight.html</anchorfile>
      <anchor>a4900f5027a1e339d3be9ed83396a214d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Exporter&lt; MeshType, N &gt; *</type>
      <name>setOptions</name>
      <anchorfile>classFeel_1_1ExporterEnsight.html</anchorfile>
      <anchor>a116931ba0e64975747c5c95e56938a42</anchor>
      <arglist>(po::variables_map const &amp;vm, std::string const &amp;exp_prefix=&quot;&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>classFeel_1_1ExporterEnsight.html</anchorfile>
      <anchor>a45b24f971a04cf4488d0d3eb25686ec0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>visit</name>
      <anchorfile>classFeel_1_1ExporterEnsight.html</anchorfile>
      <anchor>a2f8116950391281d38d190c8f92d8303</anchor>
      <arglist>(mesh_type *mesh)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::ExporterGmsh</name>
    <filename>classFeel_1_1ExporterGmsh.html</filename>
    <templarg>MeshType</templarg>
    <templarg>N</templarg>
    <base>Feel::Exporter</base>
    <member kind="typedef">
      <type>MeshType</type>
      <name>mesh_type</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a1ef21d389fae4885639620adfeccff35</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; mesh_type &gt;</type>
      <name>mesh_ptrtype</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a8962a764047e84e0ebc9eb16e0c98fcb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::point_const_iterator</type>
      <name>point_const_iterator</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>ad3e7ae5f424f7530dd8cc63f468ed1cb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Exporter&lt; MeshType, N &gt;</type>
      <name>super</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a58a8021a7e76c4f70fbf79786ff818a4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::value_type</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>aed49e47766412d27a7caedcd03a0b8b9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::timeset_type</type>
      <name>timeset_type</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a5773f889e7e33b07f3f66f1c92a5c6d2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::timeset_ptrtype</type>
      <name>timeset_ptrtype</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a794aacc8e48a7ccb7508e6dc2c5d8e94</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::timeset_iterator</type>
      <name>timeset_iterator</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a8c70462658aa19a751b9874929c13520</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::timeset_const_iterator</type>
      <name>timeset_const_iterator</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a3bcc928aeb75370c68aefb7ffcd24753</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>timeset_type::step_type</type>
      <name>step_type</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a1f2a4379667daa1c56fff3539e3eff66</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>timeset_type::step_ptrtype</type>
      <name>step_ptrtype</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a975e9359b7843b9c9ca22ae7dbb476fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>timeset_type::step_const_iterator</type>
      <name>step_const_iterator</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>ace77534f32a38e11d8db392c36c6e9ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>matrix_node&lt; value_type &gt;::type</type>
      <name>matrix_node_type</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a301c103f0e9c0557161a80ad544fb244</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ExporterGmsh</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>ae2dcbe82c30cd701184542ab1120d3df</anchor>
      <arglist>(std::string const &amp;__p=&quot;default&quot;, int freq=1, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ExporterGmsh</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a7db72f00e67e0dc16d5f44d373ec8bd5</anchor>
      <arglist>(po::variables_map const &amp;vm, std::string const &amp;exp_prefix=&quot;&quot;, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ExporterGmsh</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a2f7752b90ce5e481c185219afac692e1</anchor>
      <arglist>(ExporterGmsh const &amp;__ex)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~ExporterGmsh</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a876e565ad16750be68b69836c48a46d2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Exporter&lt; MeshType, N &gt; *</type>
      <name>setOptions</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a178b55c4a72a35f632fa6dcaa8bc449b</anchor>
      <arglist>(po::variables_map const &amp;vm, std::string const &amp;exp_prefix=&quot;&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a928c5e0eb52fd4b39886d53dac112b3e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>visit</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a4cb79e71b2da6bafb70664b7593733b9</anchor>
      <arglist>(mesh_type *mesh)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveMesh</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>af8d45a8bc3f56a7ca06a7ff3db48f8db</anchor>
      <arglist>(std::string const &amp;filename, mesh_ptrtype mesh, bool parametric=false) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gmshSaveAscii</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>abd015e6c8591843f075054ccd1c3ae58</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gmshSaveFormat</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>ae5903a1c8573feba5ab2a03cffb97e57</anchor>
      <arglist>(std::ostream &amp;out, std::string const &amp;version=FEELPP_GMSH_FORMAT_VERSION) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gmshSavePhysicalNames</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a5745a3d44624b9f5659682680b049d40</anchor>
      <arglist>(std::ostream &amp;out, mesh_ptrtype mesh) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gmshSaveNodesStart</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a7ef811abb268044f67b0ea54ffe279a4</anchor>
      <arglist>(std::ostream &amp;out, mesh_ptrtype mesh, size_type nGlobPt, bool parametric=false) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gmshSaveNodes</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>af38e5cd3e4466b50e3ac808cf6e37a5b</anchor>
      <arglist>(std::ostream &amp;out, mesh_ptrtype mesh, size_type indexPtStart, bool parametric=false) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gmshSaveNodesEnd</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a081310eee935b16536ef0266316c9e71</anchor>
      <arglist>(std::ostream &amp;out, mesh_ptrtype mesh, bool parametric=false) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gmshSaveElementsStart</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a29f818cb761cbf7b289e5f4b9a12d15b</anchor>
      <arglist>(std::ostream &amp;out, size_type nGlobElt) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gmshSaveElements</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>ae527edfcc67a4bcf238e71ac6b82059e</anchor>
      <arglist>(std::ostream &amp;out, mesh_ptrtype __mesh, size_type indexEltStart, size_type indexPtStart) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gmshSaveElementsEnd</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a996c5e3cdab430137945b1a9744d1292</anchor>
      <arglist>(std::ostream &amp;out) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gmshSaveNodeData</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>a2e2758b2a3dd3be3a86fec9c599af6b8</anchor>
      <arglist>(std::ostream &amp;out, step_ptrtype __step) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gmshSaveElementNodeData</name>
      <anchorfile>classFeel_1_1ExporterGmsh.html</anchorfile>
      <anchor>ab16825e9f22c3d8866fdcfb1daac40fc</anchor>
      <arglist>(std::ostream &amp;out, step_ptrtype __step) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::ExporterGnuplot</name>
    <filename>classFeel_1_1ExporterGnuplot.html</filename>
    <templarg></templarg>
    <base>Exporter&lt; MeshType &gt;</base>
    <member kind="enumeration">
      <name>PlottingProperties</name>
      <anchorfile>classFeel_1_1ExporterGnuplot.html</anchorfile>
      <anchor>a5c3132ff5e3f49c42169ac996516b28b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>MeshType</type>
      <name>mesh_type</name>
      <anchorfile>classFeel_1_1ExporterGnuplot.html</anchorfile>
      <anchor>a57142d2315eca4f9e1803bb5f239f210</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Exporter&lt; MeshType &gt;</type>
      <name>super</name>
      <anchorfile>classFeel_1_1ExporterGnuplot.html</anchorfile>
      <anchor>a29ccbbeb2251432ccae27f709d9e22a3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::value_type</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1ExporterGnuplot.html</anchorfile>
      <anchor>a147e4c6db931c2c1c8269e3adb4cf577</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::timeset_type</type>
      <name>timeset_type</name>
      <anchorfile>classFeel_1_1ExporterGnuplot.html</anchorfile>
      <anchor>a6b9e4f918cda6fc97548738fa85e2200</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::timeset_ptrtype</type>
      <name>timeset_ptrtype</name>
      <anchorfile>classFeel_1_1ExporterGnuplot.html</anchorfile>
      <anchor>a19b01e0081bbe066db1045e017c2ae79</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::timeset_iterator</type>
      <name>timeset_iterator</name>
      <anchorfile>classFeel_1_1ExporterGnuplot.html</anchorfile>
      <anchor>ad2cf4680c76eb24adacc9d8539a1b79d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::timeset_const_iterator</type>
      <name>timeset_const_iterator</name>
      <anchorfile>classFeel_1_1ExporterGnuplot.html</anchorfile>
      <anchor>aca0036b62affdec688c065a940b979a7</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>matrix_node&lt; value_type &gt;::type</type>
      <name>matrix_node_type</name>
      <anchorfile>classFeel_1_1ExporterGnuplot.html</anchorfile>
      <anchor>ab0a39294bfbde409896d4c50942c12a0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ExporterGnuplot</name>
      <anchorfile>classFeel_1_1ExporterGnuplot.html</anchorfile>
      <anchor>a384cdc9dead2391044dd2eecd5963352</anchor>
      <arglist>(std::string const &amp;__p=&quot;default&quot;, int freq=1, int properties=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ExporterGnuplot</name>
      <anchorfile>classFeel_1_1ExporterGnuplot.html</anchorfile>
      <anchor>a93315995158d7bc76de11c96eb552149</anchor>
      <arglist>(po::variables_map const &amp;vm, std::string const &amp;exp_prefix=&quot;&quot;, int properties=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ExporterGnuplot</name>
      <anchorfile>classFeel_1_1ExporterGnuplot.html</anchorfile>
      <anchor>a62262dadb82c209c07d4a3201c77cea9</anchor>
      <arglist>(ExporterGnuplot const &amp;__ex)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~ExporterGnuplot</name>
      <anchorfile>classFeel_1_1ExporterGnuplot.html</anchorfile>
      <anchor>a080f8a9416993e063fa06a7310948468</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTitle</name>
      <anchorfile>classFeel_1_1ExporterGnuplot.html</anchorfile>
      <anchor>a58082e2070d1429e1e03213917f910a1</anchor>
      <arglist>(std::string const &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>useGrid</name>
      <anchorfile>classFeel_1_1ExporterGnuplot.html</anchorfile>
      <anchor>af649deb355e2e4ab5fd213a3bf5422c7</anchor>
      <arglist>(bool grid)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPngOutput</name>
      <anchorfile>classFeel_1_1ExporterGnuplot.html</anchorfile>
      <anchor>a15c8665acb6221b4a366f57ca26f76e9</anchor>
      <arglist>(bool png_output)</arglist>
    </member>
    <member kind="function">
      <type>Exporter&lt; MeshType &gt; *</type>
      <name>setOptions</name>
      <anchorfile>classFeel_1_1ExporterGnuplot.html</anchorfile>
      <anchor>acf1f7eb11bb1cb9fd4e01bc0a72cba2e</anchor>
      <arglist>(po::variables_map const &amp;vm, std::string const &amp;exp_prefix=&quot;&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>classFeel_1_1ExporterGnuplot.html</anchorfile>
      <anchor>ade1d55d71feed03ef6692cbf8ed7df0f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>visit</name>
      <anchorfile>classFeel_1_1ExporterGnuplot.html</anchorfile>
      <anchor>ac7dfc69d57af3cb5bad58555c41c308d</anchor>
      <arglist>(mesh_type *mesh)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::ExporterQuick</name>
    <filename>classFeel_1_1ExporterQuick.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>MeshType</type>
      <name>mesh_type</name>
      <anchorfile>classFeel_1_1ExporterQuick.html</anchorfile>
      <anchor>a2d80a788bb5b2a7d62015fc08848e8db</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; mesh_type &gt;</type>
      <name>mesh_ptrtype</name>
      <anchorfile>classFeel_1_1ExporterQuick.html</anchorfile>
      <anchor>a3d4233e58d2c1081ebfc51736aee7e99</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Exporter&lt; mesh_type, 1 &gt;</type>
      <name>export_type</name>
      <anchorfile>classFeel_1_1ExporterQuick.html</anchorfile>
      <anchor>a11b89227a988ca2f0a30abf79ee2d81f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; export_type &gt;</type>
      <name>export_ptrtype</name>
      <anchorfile>classFeel_1_1ExporterQuick.html</anchorfile>
      <anchor>afaca9d149ac096f153216a775847b404</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>export_type::timeset_type</type>
      <name>timeset_type</name>
      <anchorfile>classFeel_1_1ExporterQuick.html</anchorfile>
      <anchor>a563de2343f163ec798bad6851754e9f5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>export_type::timeset_ptrtype</type>
      <name>timeset_ptrtype</name>
      <anchorfile>classFeel_1_1ExporterQuick.html</anchorfile>
      <anchor>a614fb06234305dc3776fa6ba26483a0e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ExporterQuick</name>
      <anchorfile>classFeel_1_1ExporterQuick.html</anchorfile>
      <anchor>aef183793c961910c16c5a9d83ce5d2de</anchor>
      <arglist>(std::string const &amp;name, po::variables_map &amp;vm)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ExporterQuick</name>
      <anchorfile>classFeel_1_1ExporterQuick.html</anchorfile>
      <anchor>a520ac9f6fac93ed263d262622037e016</anchor>
      <arglist>(std::string const &amp;name, std::string const &amp;exp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>classFeel_1_1ExporterQuick.html</anchorfile>
      <anchor>ad15158aafcf88f62e7a3e0abb9756cbd</anchor>
      <arglist>(mesh_ptrtype const &amp;mesh)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>classFeel_1_1ExporterQuick.html</anchorfile>
      <anchor>a20fce48486b5899f13d91f0e3b6b9be4</anchor>
      <arglist>(double time, F1 const &amp;f1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>classFeel_1_1ExporterQuick.html</anchorfile>
      <anchor>aee3e5991a0005a01746f68c8c0bc3788</anchor>
      <arglist>(double time, F1 const &amp;f1, F2 const &amp;f2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>classFeel_1_1ExporterQuick.html</anchorfile>
      <anchor>a553505ebf14fa1ad92ef7767fd7b6c94</anchor>
      <arglist>(double time, F1 const &amp;f1, F2 const &amp;f2, F3 const &amp;f3)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::FilterFromVtk</name>
    <filename>classFeel_1_1FilterFromVtk.html</filename>
    <templarg></templarg>
    <base>Feel::VisitorBase</base>
    <base>Visitor&lt; MeshType &gt;</base>
    <member kind="typedef">
      <type>MeshType</type>
      <name>mesh_type</name>
      <anchorfile>classFeel_1_1FilterFromVtk.html</anchorfile>
      <anchor>ab9fd93e5097145e50a3f74ce6792e87a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::point_type</type>
      <name>point_type</name>
      <anchorfile>classFeel_1_1FilterFromVtk.html</anchorfile>
      <anchor>a936cf4b1a3f08792801ce88d673cdfad</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>point_type::node_type</type>
      <name>node_type</name>
      <anchorfile>classFeel_1_1FilterFromVtk.html</anchorfile>
      <anchor>a0db777c0ff2039d30d9d39914f1ad720</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::edge_type</type>
      <name>edge_type</name>
      <anchorfile>classFeel_1_1FilterFromVtk.html</anchorfile>
      <anchor>a882709a7dd31dcffd95dbaa44ad09aa6</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::face_type</type>
      <name>face_type</name>
      <anchorfile>classFeel_1_1FilterFromVtk.html</anchorfile>
      <anchor>adf9279a156c55eb48e5b068e22659bdb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::element_type</type>
      <name>element_type</name>
      <anchorfile>classFeel_1_1FilterFromVtk.html</anchorfile>
      <anchor>a99a72989929564e817ff2b4a59e6cba1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_STATIC_ASSERT</name>
      <anchorfile>classFeel_1_1FilterFromVtk.html</anchorfile>
      <anchor>a5743c166430c3d3fda9d0763429c7c3d</anchor>
      <arglist>(nDim==2||nDim==3)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FilterFromVtk</name>
      <anchorfile>classFeel_1_1FilterFromVtk.html</anchorfile>
      <anchor>aa21a6a21b294c4a570302778e2e9f54a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~FilterFromVtk</name>
      <anchorfile>classFeel_1_1FilterFromVtk.html</anchorfile>
      <anchor>a32abb2f99f0e84e13bd123817ab7c495</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>visit</name>
      <anchorfile>classFeel_1_1FilterFromVtk.html</anchorfile>
      <anchor>aebeacc4de84f38ffb45cdbc2557f3eaa</anchor>
      <arglist>(mesh_type *mesh)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>nDim</name>
      <anchorfile>classFeel_1_1FilterFromVtk.html</anchorfile>
      <anchor>ad1b9ddb580184847bdf9715f1b8379ab</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::FilterFromVtk3D</name>
    <filename>classFeel_1_1FilterFromVtk3D.html</filename>
    <templarg></templarg>
    <base>Feel::VisitorBase</base>
    <base>Visitor&lt; MeshType &gt;</base>
    <member kind="typedef">
      <type>MeshType</type>
      <name>mesh_type</name>
      <anchorfile>classFeel_1_1FilterFromVtk3D.html</anchorfile>
      <anchor>a26bb63c9039b0185e4bbeed346c082a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::point_type</type>
      <name>point_type</name>
      <anchorfile>classFeel_1_1FilterFromVtk3D.html</anchorfile>
      <anchor>a316d8af45a66e4ce9893a010e56dbdcc</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>point_type::node_type</type>
      <name>node_type</name>
      <anchorfile>classFeel_1_1FilterFromVtk3D.html</anchorfile>
      <anchor>a3d7fdf1574beecca6ed11a25fedfa1a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::edge_type</type>
      <name>edge_type</name>
      <anchorfile>classFeel_1_1FilterFromVtk3D.html</anchorfile>
      <anchor>a42f6298a1a5b0f5171b496c0225fa8cf</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::face_type</type>
      <name>face_type</name>
      <anchorfile>classFeel_1_1FilterFromVtk3D.html</anchorfile>
      <anchor>a9012ed390d80c790c8936273598e2ed8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::element_type</type>
      <name>element_type</name>
      <anchorfile>classFeel_1_1FilterFromVtk3D.html</anchorfile>
      <anchor>a9689310bd716ddc85d5dd4c8558a0b6f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BOOST_STATIC_ASSERT</name>
      <anchorfile>classFeel_1_1FilterFromVtk3D.html</anchorfile>
      <anchor>a09ad110c35feb0197f9fc38e42e44734</anchor>
      <arglist>(nDim==2||nDim==3)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FilterFromVtk3D</name>
      <anchorfile>classFeel_1_1FilterFromVtk3D.html</anchorfile>
      <anchor>a4c09d0ec815361e95480a8af7665db2a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~FilterFromVtk3D</name>
      <anchorfile>classFeel_1_1FilterFromVtk3D.html</anchorfile>
      <anchor>a6e5d244abece64b6918ed225396b28cd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>visit</name>
      <anchorfile>classFeel_1_1FilterFromVtk3D.html</anchorfile>
      <anchor>a3c3926c6173618b382fee8e55b6b54a0</anchor>
      <arglist>(mesh_type *mesh)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>nDim</name>
      <anchorfile>classFeel_1_1FilterFromVtk3D.html</anchorfile>
      <anchor>a50ca953eb584901aaf701f70176bdce5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::Gmsh</name>
    <filename>classFeel_1_1Gmsh.html</filename>
    <class kind="struct">Feel::Gmsh::Factory</class>
    <member kind="function">
      <type></type>
      <name>Gmsh</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a2dd8915292f6e53e523b308a69db450d</anchor>
      <arglist>(int nDim=1, int nOrder=GMSH_ORDER_ONE, WorldComm const &amp;worldComm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Gmsh</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>abd7c309c65888d1580f6ec4896e2414a</anchor>
      <arglist>(Gmsh const &amp;__g)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Gmsh</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a58df714a3b79cdaf7d3a86adadcaf0df</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dimension</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>ab5f77f8dbc19304e6973710a5891730d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMSH_ORDER</type>
      <name>order</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a988f7731c0fe999eb32023a40f0bdc15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>version</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a945a36b11a3978071438bfd7b763e588</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>prefix</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>af5c39f61ca85ece34cb7bdc6cdd5fe1c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; std::pair&lt; double, double &gt; &gt; const &amp;</type>
      <name>boundingBox</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>ae18c55744553e441b9b7957d75b99fb0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>xmin</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a49bca478c7a1a2d5990530c82c711782</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>xmax</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a36383d88501625e20dd5345f3d8cf244</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>ymin</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a53455650907e785136733ce93d5cc90e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>ymax</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a37ec766db24388bbd8cdc4b49834f594</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>zmin</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a88fa465d2b9bb4a4e981b5a7b78c3a42</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>zmax</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a5875ea3e255ef0155c09a284ad81649c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double const &amp;</type>
      <name>h</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>aae9d4a2398e4f50e4a1ba60343c24538</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>description</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>ab9b1c891cef401ac3254b060f784256f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>addMidPoint</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a9469c7d5fa6e694915e59ff3a2d0f4ec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>usePhysicalNames</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>af122953d40b58afc67a1956b252da4b4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>WorldComm const &amp;</type>
      <name>worldComm</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a7cae62fb16983d79a498454678884d56</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>numberOfPartitions</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a1322e596ec2e515a23241565a3cb2e11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>mshFileByPartition</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a8cc60b34354ffa3be9d81227ddc38d02</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMSH_PARTITIONER</type>
      <name>partitioner</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a4f6858c7b0c16a95179335c90722d90b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>shear</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a7896c9f06fb42caab094136aa8a9e788</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>recombine</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a2a711e7c9e11aece030e3b62b63231aa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Gmsh &amp;</type>
      <name>setDimension</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>ad7c614864ca44d347e9c9493f4836e65</anchor>
      <arglist>(int dim)</arglist>
    </member>
    <member kind="function">
      <type>Gmsh &amp;</type>
      <name>ref</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a90c2491e127360a4eb86636c9babcba8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Gmsh &amp;</type>
      <name>h</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a9f58806b4350c47918fba1126e938a8b</anchor>
      <arglist>(double _h)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOrder</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>aa5cd4b0cc6c293e581f634e281134829</anchor>
      <arglist>(int o)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVersion</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a43e4dc4774b12a4f254f9ac407f4cf1d</anchor>
      <arglist>(std::string version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDescription</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a36afd824733433c9931a41b2cacc8367</anchor>
      <arglist>(std::string const &amp;desc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPrefix</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a4ca69649cde4532da1343b6df7b89c54</anchor>
      <arglist>(std::string const &amp;name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setX</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a810076cafd89464cff69973b098820d4</anchor>
      <arglist>(std::pair&lt; double, double &gt; const &amp;x)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setY</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a37168d62c50988957bc788f08baf1e61</anchor>
      <arglist>(std::pair&lt; double, double &gt; const &amp;y)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setZ</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a268ad1730542ab0a71426e34ff194d7f</anchor>
      <arglist>(std::pair&lt; double, double &gt; const &amp;z)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setReferenceDomain</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>aa7cde7899c69514d0471258259a76b22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setCharacteristicLength</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>aac2ef4eaa0bcb7c0e17aa347a327ff81</anchor>
      <arglist>(double _h)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAddMidPoint</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a3e96ed54b49f44dcdf6e2435a238885e</anchor>
      <arglist>(bool add)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>usePhysicalNames</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a7c55a0b34eab8b960c597c22a95cf454</anchor>
      <arglist>(bool option)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWorldComm</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a1500e210db9a3df0b716e439c2a115c8</anchor>
      <arglist>(WorldComm const &amp;_worldcomm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNumberOfPartitions</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>aea8c57166d4e61226b6f627985042816</anchor>
      <arglist>(int n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMshFileByPartition</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>aeb1fcccccf00427a0ffb5c7b2c19bb9b</anchor>
      <arglist>(bool p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPartitioner</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>ac3988aee134015edafb0e0e177ec4add</anchor>
      <arglist>(GMSH_PARTITIONER const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShear</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a403c53d2eed2a84e8ea9115103b3f507</anchor>
      <arglist>(double _shear)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRecombine</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a3ef03fb0bd391f3ef36b8b15870289e7</anchor>
      <arglist>(bool _recombine)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>generate</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a97a595e04bbdfa9a8a333999dac711c5</anchor>
      <arglist>(std::string const &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>generate</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a012daadecc4fa3d5c074b48b017efe37</anchor>
      <arglist>(std::string const &amp;name, std::string const &amp;geo, bool const forceRebuild=false, bool const parametric=false, bool const modifGeo=true) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>refine</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>af8ccac207591aa29a8040abe50228b71</anchor>
      <arglist>(std::string const &amp;name, int level=1, bool const parametric=false) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>preamble</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>aa62e32c40c675aa2a2891cdef45c1406</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>getDescriptionFromFile</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>abd5389576f769da14fc39f66bf78d3af</anchor>
      <arglist>(std::string const &amp;file) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual std::string</type>
      <name>getDescription</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a5fcdb513547d28f6518cdad892e7fcd5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>bool</type>
      <name>generateGeo</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a4cec3a3aa6081c46f03fa46961825cf7</anchor>
      <arglist>(std::string const &amp;name, std::string const &amp;geo, bool const modifGeo=true) const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>WorldComm</type>
      <name>M_worldComm</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a7f488443251749d91ab9c53a7808a79e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>M_dimension</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>abeb9d16e5374b22060732831a0794de7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>M_order</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a2175e8c010303f6a64be84802ad6986e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::string</type>
      <name>M_version</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>af8a403cbad11385cd44a85b847d90ca8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::string</type>
      <name>M_name</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a6795cdd2d4c4e1e8a284c3c3542dca53</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::string</type>
      <name>M_desc</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a0fbcde4843735c7528bb23e3cd57c3c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::vector&lt; std::pair&lt; double, double &gt; &gt;</type>
      <name>M_I</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>ab4f8ad793cd4ea2b040a6d8412a244bb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>double</type>
      <name>M_h</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>ab6f5abd5ef6028a51511f1aae8b1be5a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>M_addmidpoint</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>ade641c4a5ea4f14efb54c41d7637f8c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>M_usePhysicalNames</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>afb750c08567fcc101515cde0f9d88978</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>GMSH_PARTITIONER</type>
      <name>M_partitioner</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a28c5d988593cff5861c15a9e8f34a954</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>M_partitions</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>acaea5228f199cc7cd1f2895d895d9031</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>M_partition_file</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a9d0647f04e674373d4de2b9b85df49b9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>double</type>
      <name>M_shear</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>ab1f8392622bb13be1caa9b85be65ff65</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>M_recombine</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a3066ede9cbaa42c21d5c6e376aaef35d</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Gmsh &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>a86e9284033bbaa0a64e94bd97e4b4cd8</anchor>
      <arglist>(Gmsh const &amp;__g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static boost::shared_ptr&lt; Gmsh &gt;</type>
      <name>New</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>ae9e5e667f022dc36ee5b38a81daa1a3f</anchor>
      <arglist>(po::variables_map const &amp;vm)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static boost::shared_ptr&lt; Gmsh &gt;</type>
      <name>New</name>
      <anchorfile>classFeel_1_1Gmsh.html</anchorfile>
      <anchor>ab29793b57b74bbf1af1e7e7431f86ff1</anchor>
      <arglist>(std::string const &amp;shape, uint16_type d=2, uint16_type o=1, std::string const &amp;ct=&quot;simplex&quot;)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::Gmsh::Factory</name>
    <filename>structFeel_1_1Gmsh_1_1Factory.html</filename>
    <member kind="typedef">
      <type>Feel::Singleton&lt; Feel::Factory&lt; Gmsh, std::string &gt; &gt;</type>
      <name>type</name>
      <anchorfile>structFeel_1_1Gmsh_1_1Factory.html</anchorfile>
      <anchor>ae6a3be36e23c43cd30a000ff93b62418</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::GmshEllipsoidDomain</name>
    <filename>classFeel_1_1GmshEllipsoidDomain.html</filename>
    <base>Feel::Gmsh</base>
    <member kind="function">
      <type></type>
      <name>GmshEllipsoidDomain</name>
      <anchorfile>classFeel_1_1GmshEllipsoidDomain.html</anchorfile>
      <anchor>a55ad8080f4cbd962d59d565982c5d7bb</anchor>
      <arglist>(int Dim, int Order=GMSH_ORDER_ONE, DomainType dt=GMSH_REAL_DOMAIN)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~GmshEllipsoidDomain</name>
      <anchorfile>classFeel_1_1GmshEllipsoidDomain.html</anchorfile>
      <anchor>a6367dd86ac9277572e6326a94f2af10f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>std::string</type>
      <name>getDescription</name>
      <anchorfile>classFeel_1_1GmshEllipsoidDomain.html</anchorfile>
      <anchor>a98b0777c23996492b5539699c0ed5738</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::GmshOrdering</name>
    <filename>classFeel_1_1GmshOrdering.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>boost::bimap&lt; int, int &gt;</type>
      <name>id_type</name>
      <anchorfile>classFeel_1_1GmshOrdering.html</anchorfile>
      <anchor>a43c6c3c4782de256c62fb5f299629cea</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>type</name>
      <anchorfile>classFeel_1_1GmshOrdering.html</anchorfile>
      <anchor>a0dde2c8364dba6d9d740fb80a60fa3e4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>size</name>
      <anchorfile>classFeel_1_1GmshOrdering.html</anchorfile>
      <anchor>ab019de7c4856af528f34a9e83d5de218</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>fromGmshId</name>
      <anchorfile>classFeel_1_1GmshOrdering.html</anchorfile>
      <anchor>aaafaceaf10e70312e95805e192c9059f</anchor>
      <arglist>(int p) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>toGmshId</name>
      <anchorfile>classFeel_1_1GmshOrdering.html</anchorfile>
      <anchor>abe8d162e41b448e14aa99571c73f81bf</anchor>
      <arglist>(int p) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>id</name>
      <anchorfile>classFeel_1_1GmshOrdering.html</anchorfile>
      <anchor>a44bff60e8ecf1fbba1aa13e2f62caa2e</anchor>
      <arglist>(int p) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::GmshHypercubeDomain</name>
    <filename>classFeel_1_1GmshHypercubeDomain.html</filename>
    <base>Feel::Gmsh</base>
    <member kind="function">
      <type></type>
      <name>GmshHypercubeDomain</name>
      <anchorfile>classFeel_1_1GmshHypercubeDomain.html</anchorfile>
      <anchor>a0f5143162bf79ef6f4de7f1b79f8fe65</anchor>
      <arglist>(int dim, int order)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GmshHypercubeDomain</name>
      <anchorfile>classFeel_1_1GmshHypercubeDomain.html</anchorfile>
      <anchor>a35763ce5ba186169ce505ab9131dd606</anchor>
      <arglist>(int dim, int order, int rdim, bool use_hypercube)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GmshHypercubeDomain</name>
      <anchorfile>classFeel_1_1GmshHypercubeDomain.html</anchorfile>
      <anchor>a2a584d5b26da50605511a1e4fcd2f10f</anchor>
      <arglist>(GmshHypercubeDomain const &amp;td)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~GmshHypercubeDomain</name>
      <anchorfile>classFeel_1_1GmshHypercubeDomain.html</anchorfile>
      <anchor>a90e39f125cb898dcf4b4d188275efd7c</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::GmshSimplexDomain</name>
    <filename>classFeel_1_1GmshSimplexDomain.html</filename>
    <base>Feel::Gmsh</base>
    <member kind="function">
      <type></type>
      <name>GmshSimplexDomain</name>
      <anchorfile>classFeel_1_1GmshSimplexDomain.html</anchorfile>
      <anchor>aa56b3827ba5d0a3120e44e6aa86771ec</anchor>
      <arglist>(int dim, int order, DomainType dt=GMSH_REAL_DOMAIN)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GmshSimplexDomain</name>
      <anchorfile>classFeel_1_1GmshSimplexDomain.html</anchorfile>
      <anchor>aab4d94327201d29cc996791113494893</anchor>
      <arglist>(GmshSimplexDomain const &amp;td)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~GmshSimplexDomain</name>
      <anchorfile>classFeel_1_1GmshSimplexDomain.html</anchorfile>
      <anchor>a7a8c1a44eb62cf57f18221587fc7157c</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::Importer</name>
    <filename>classFeel_1_1Importer.html</filename>
    <templarg></templarg>
    <base>Feel::VisitorBase</base>
    <base>Visitor&lt; MeshType &gt;</base>
    <member kind="typedef">
      <type>MeshType</type>
      <name>mesh_type</name>
      <anchorfile>classFeel_1_1Importer.html</anchorfile>
      <anchor>ae5162b5a8c26b47fea93cf0d1c7da5f5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::point_type</type>
      <name>point_type</name>
      <anchorfile>classFeel_1_1Importer.html</anchorfile>
      <anchor>a5e98366c43bb83c6f62e0c1a6f544881</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>point_type::node_type</type>
      <name>node_type</name>
      <anchorfile>classFeel_1_1Importer.html</anchorfile>
      <anchor>a15cf27ec1193e91616e1ffec9c3f1ee6</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::edge_type</type>
      <name>edge_type</name>
      <anchorfile>classFeel_1_1Importer.html</anchorfile>
      <anchor>a0fd295e08e7c3f509d39450883abbff0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::face_type</type>
      <name>face_type</name>
      <anchorfile>classFeel_1_1Importer.html</anchorfile>
      <anchor>acd51c9b96d84bb42265d1a37a026498c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::element_type</type>
      <name>element_type</name>
      <anchorfile>classFeel_1_1Importer.html</anchorfile>
      <anchor>a29b7dbd7e051db77b63596de3ab178be</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Importer</name>
      <anchorfile>classFeel_1_1Importer.html</anchorfile>
      <anchor>ae7c669beabf68b13f2eab2f13d3effe9</anchor>
      <arglist>(MeshFormat const &amp;_format=GMSH, WorldComm const &amp;_worldcomm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Importer</name>
      <anchorfile>classFeel_1_1Importer.html</anchorfile>
      <anchor>ac2ebf12713c9e1fba91402ea95f74aa7</anchor>
      <arglist>(std::string const &amp;_filename, MeshFormat const &amp;_format=GMSH, WorldComm const &amp;_worldcomm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFilename</name>
      <anchorfile>classFeel_1_1Importer.html</anchorfile>
      <anchor>afa663d8b752f7fb1efb5269af62d44ab</anchor>
      <arglist>(std::string const &amp;__filename)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFormat</name>
      <anchorfile>classFeel_1_1Importer.html</anchorfile>
      <anchor>a22a2c58378308ee789e12664cccd7566</anchor>
      <arglist>(MeshFormat const &amp;__format)</arglist>
    </member>
    <member kind="function">
      <type>std::string const &amp;</type>
      <name>filename</name>
      <anchorfile>classFeel_1_1Importer.html</anchorfile>
      <anchor>ae6b3b93adfe3f27d33b56fde98d5d1a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>MeshFormat</type>
      <name>format</name>
      <anchorfile>classFeel_1_1Importer.html</anchorfile>
      <anchor>ae597fef05ad19d2fbddfbd5cf5127ba6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>WorldComm const &amp;</type>
      <name>worldComm</name>
      <anchorfile>classFeel_1_1Importer.html</anchorfile>
      <anchor>a00f2e3f3b36d99a9106fa62bb866c1b0</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::ImporterGambit</name>
    <filename>classFeel_1_1ImporterGambit.html</filename>
    <templarg></templarg>
    <base>Feel::Importer</base>
    <member kind="typedef">
      <type>super::mesh_type</type>
      <name>mesh_type</name>
      <anchorfile>classFeel_1_1ImporterGambit.html</anchorfile>
      <anchor>ae05c9404fd10bfc0767a9e3ca527c514</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::point_type</type>
      <name>point_type</name>
      <anchorfile>classFeel_1_1ImporterGambit.html</anchorfile>
      <anchor>a9fe18ca42dccbd17d95f7c6a66696939</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::node_type</type>
      <name>node_type</name>
      <anchorfile>classFeel_1_1ImporterGambit.html</anchorfile>
      <anchor>a4d2fe23789cadd9c6714d6b48214ef25</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::edge_type</type>
      <name>edge_type</name>
      <anchorfile>classFeel_1_1ImporterGambit.html</anchorfile>
      <anchor>ac0d4be526af6ae625f1d5f8d221b0e23</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::face_type</type>
      <name>face_type</name>
      <anchorfile>classFeel_1_1ImporterGambit.html</anchorfile>
      <anchor>a7c60df2928550862595b38bd83035e33</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::element_type</type>
      <name>element_type</name>
      <anchorfile>classFeel_1_1ImporterGambit.html</anchorfile>
      <anchor>a9ebdc047c956930fa12b269963cbbb17</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ImporterGambit</name>
      <anchorfile>classFeel_1_1ImporterGambit.html</anchorfile>
      <anchor>a23f651681b6e3322d54fdc480dca05fe</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ImporterGambit</name>
      <anchorfile>classFeel_1_1ImporterGambit.html</anchorfile>
      <anchor>a7bef6f6a7740f9c206c1512e14f901a1</anchor>
      <arglist>(std::string const &amp;fname)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ImporterGambit</name>
      <anchorfile>classFeel_1_1ImporterGambit.html</anchorfile>
      <anchor>aec807e54d994192e5f4e69535918813d</anchor>
      <arglist>(ImporterGambit const &amp;i)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~ImporterGambit</name>
      <anchorfile>classFeel_1_1ImporterGambit.html</anchorfile>
      <anchor>a2f221159de9b13c17674531225d2c98b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>visit</name>
      <anchorfile>classFeel_1_1ImporterGambit.html</anchorfile>
      <anchor>a915ad8e871f80125143fe0fa9768a878</anchor>
      <arglist>(mesh_type *mesh)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::ImporterGmsh</name>
    <filename>classFeel_1_1ImporterGmsh.html</filename>
    <templarg>MeshType</templarg>
    <base>Feel::Importer</base>
    <member kind="typedef">
      <type>super::mesh_type</type>
      <name>mesh_type</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>a11f4246f1c16492d4312a71c42083f37</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::point_type</type>
      <name>point_type</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>a4971358534fcac710bff6062cdbbfec7</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::node_type</type>
      <name>node_type</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>abbb3a0ea53fa8e62190faae59454fa27</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::edge_type</type>
      <name>edge_type</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>a32b5fb558c5c083e81e4d47354dd43d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::face_type</type>
      <name>face_type</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>af9616ef1d57950d75f3ddf2266a92654</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super::element_type</type>
      <name>element_type</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>a1a8f16f2993ac3f15c289563fadc5b7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::face_iterator</type>
      <name>face_iterator</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>a0b113d754bda5ed14902d95d7046338e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setElementRegionAsPhysicalRegion</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>a83648e8c4eee6487acf28ac217354c1c</anchor>
      <arglist>(const bool param)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ImporterGmsh</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>aac01bc26f635fda101e090b8be1d39ce</anchor>
      <arglist>(WorldComm const &amp;_worldcomm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ImporterGmsh</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>a5295837595650909240a6051ee32bf4f</anchor>
      <arglist>(std::string const &amp;_fname, std::string _version=FEELPP_GMSH_FORMAT_VERSION, WorldComm const &amp;_worldcomm=WorldComm())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ImporterGmsh</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>aedb06002160c19026c5eac19f5d98aab</anchor>
      <arglist>(ImporterGmsh const &amp;i)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~ImporterGmsh</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>a23641c28abbf60dc26cb75e202c492de</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>version</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>a2f605f0fb7d5a1d767bcb49c394b33fa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>boost::tuple&lt; bool, boost::tuple&lt; bool, int &gt; &gt;</type>
      <name>isElementOnProcessor</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>a0d3d5af2f0c6099deadcf8ad0685100a</anchor>
      <arglist>(std::vector&lt; int &gt; const &amp;tags) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVersion</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>a8a84be5f2458c87692b02a65e9b3648a</anchor>
      <arglist>(std::string const &amp;version)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIgnorePhysicalGroup</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>af39c0147e6367881e5e1c85dee1b12b2</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIgnorePhysicalName</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>af8489c2a97acab8517f5c5e436a56f2e</anchor>
      <arglist>(std::string s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>visit</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>a3af15c3fb4a73372cb150bb9c2c8aa0b</anchor>
      <arglist>(mesh_type *mesh)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>showMe</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>a1f2f1c2f8e2759f25684831a76ebc8d8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>npoints_per_edge</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>a43ef5235f7af47cb41370497c11166f5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>npoints_per_face</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>ae728b7a693b39ed8a3bbb70f4f8f6fb5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>npoints_per_element</name>
      <anchorfile>classFeel_1_1ImporterGmsh.html</anchorfile>
      <anchor>a59b792a1b0d98380d7a77d08f035a9b6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::PointSetToMesh</name>
    <filename>classFeel_1_1PointSetToMesh.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <base>Feel::VisitorBase</base>
    <base>Visitor&lt; PointSet&lt; Convex, T &gt; &gt;</base>
    <member kind="typedef">
      <type>T</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1PointSetToMesh.html</anchorfile>
      <anchor>ad426d451440c87a32bad84e2826f01f6</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Convex</type>
      <name>convex_type</name>
      <anchorfile>classFeel_1_1PointSetToMesh.html</anchorfile>
      <anchor>abdcdb3cd90b64ef9dad0e2fedca107b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>convex_type::template shape&lt; convex_type::nDim, 1, convex_type::nDim &gt;::type</type>
      <name>mesh_convex_type</name>
      <anchorfile>classFeel_1_1PointSetToMesh.html</anchorfile>
      <anchor>ae152706e3afab54f57d26d21a99e24ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PointSet&lt; convex_type, value_type &gt;</type>
      <name>pointset_type</name>
      <anchorfile>classFeel_1_1PointSetToMesh.html</anchorfile>
      <anchor>abef40f04c0ab26a1ed4278a1c25bd68e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Mesh&lt; mesh_convex_type &gt;</type>
      <name>mesh_type</name>
      <anchorfile>classFeel_1_1PointSetToMesh.html</anchorfile>
      <anchor>af9a7b07cb078a93e22488ae55f49bcd9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::shared_ptr&lt; mesh_type &gt;</type>
      <name>mesh_ptrtype</name>
      <anchorfile>classFeel_1_1PointSetToMesh.html</anchorfile>
      <anchor>a1543fcd407f2d1fabc12f19dd6bf1872</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>matrix_node&lt; value_type &gt;::type</type>
      <name>points_type</name>
      <anchorfile>classFeel_1_1PointSetToMesh.html</anchorfile>
      <anchor>a0092cc21f5dbc0c65bdf3cc0498d98e1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::point_type</type>
      <name>point_type</name>
      <anchorfile>classFeel_1_1PointSetToMesh.html</anchorfile>
      <anchor>a57d0a56f00441344d585d1e07e4d2bd8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>point_type::node_type</type>
      <name>node_type</name>
      <anchorfile>classFeel_1_1PointSetToMesh.html</anchorfile>
      <anchor>a43af6e1cbf711810d33c204b03b2ce8d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::edge_type</type>
      <name>edge_type</name>
      <anchorfile>classFeel_1_1PointSetToMesh.html</anchorfile>
      <anchor>a910701ee164b49b999c596b285d7fc6d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::face_type</type>
      <name>face_type</name>
      <anchorfile>classFeel_1_1PointSetToMesh.html</anchorfile>
      <anchor>a3deda0793fa8870b72c3f8b1d838c4d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mesh_type::element_type</type>
      <name>element_type</name>
      <anchorfile>classFeel_1_1PointSetToMesh.html</anchorfile>
      <anchor>aa0355a05a1beae16c8d5d936206b3d87</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PointSetToMesh</name>
      <anchorfile>classFeel_1_1PointSetToMesh.html</anchorfile>
      <anchor>ae8040be006c8e700547bb451a94de98f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PointSetToMesh</name>
      <anchorfile>classFeel_1_1PointSetToMesh.html</anchorfile>
      <anchor>a6256749a433bc6b3744e773d0d0a7c7c</anchor>
      <arglist>(PointSetToMesh const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~PointSetToMesh</name>
      <anchorfile>classFeel_1_1PointSetToMesh.html</anchorfile>
      <anchor>abc2513c759abfaf1e51bf87669233071</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>mesh_ptrtype</type>
      <name>mesh</name>
      <anchorfile>classFeel_1_1PointSetToMesh.html</anchorfile>
      <anchor>a11ea86df96f368d42ccd2ba0c601cab9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addBoundaryPoints</name>
      <anchorfile>classFeel_1_1PointSetToMesh.html</anchorfile>
      <anchor>ac58ef47c929a35e8241ea261ec8ebb49</anchor>
      <arglist>(points_type const &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>visit</name>
      <anchorfile>classFeel_1_1PointSetToMesh.html</anchorfile>
      <anchor>ac540fae4a23b988ace4700749271197e</anchor>
      <arglist>(pointset_type *pset)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>nDim</name>
      <anchorfile>classFeel_1_1PointSetToMesh.html</anchorfile>
      <anchor>a04e76381f5038c85febe23fcb0487027</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::BarePoint</name>
    <filename>structFeel_1_1BarePoint.html</filename>
    <member kind="function">
      <type></type>
      <name>BarePoint</name>
      <anchorfile>structFeel_1_1BarePoint.html</anchorfile>
      <anchor>a612260fa96fed55dc1cf431179da0420</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BarePoint</name>
      <anchorfile>structFeel_1_1BarePoint.html</anchorfile>
      <anchor>adc73306f74677e68ce30cf2eb469f693</anchor>
      <arglist>(size_type i)</arglist>
    </member>
    <member kind="variable">
      <type>size_type</type>
      <name>first</name>
      <anchorfile>structFeel_1_1BarePoint.html</anchorfile>
      <anchor>adebe6cdf4aafa72621e1b7d4d97b6890</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::BareEdge</name>
    <filename>structFeel_1_1BareEdge.html</filename>
    <member kind="function">
      <type></type>
      <name>BareEdge</name>
      <anchorfile>structFeel_1_1BareEdge.html</anchorfile>
      <anchor>a6818a3b8669e9733930a8dfb782ddc90</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BareEdge</name>
      <anchorfile>structFeel_1_1BareEdge.html</anchorfile>
      <anchor>accde13381487caf9ea8458e09adddb5d</anchor>
      <arglist>(size_type i, size_type j)</arglist>
    </member>
    <member kind="variable">
      <type>size_type</type>
      <name>first</name>
      <anchorfile>structFeel_1_1BareEdge.html</anchorfile>
      <anchor>a304c019a2d74d5f1ceed86bab4973d78</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>size_type</type>
      <name>second</name>
      <anchorfile>structFeel_1_1BareEdge.html</anchorfile>
      <anchor>abde024a4e7ad597d6a83e44d51b8ce8c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::BareFace</name>
    <filename>structFeel_1_1BareFace.html</filename>
    <member kind="function">
      <type></type>
      <name>BareFace</name>
      <anchorfile>structFeel_1_1BareFace.html</anchorfile>
      <anchor>a7df66d2dc95e65c5cb8e41775c0364a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BareFace</name>
      <anchorfile>structFeel_1_1BareFace.html</anchorfile>
      <anchor>a989f6221740c8e96c43cdb0f20e57f82</anchor>
      <arglist>(size_type i, size_type j, size_type k)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BareFace</name>
      <anchorfile>structFeel_1_1BareFace.html</anchorfile>
      <anchor>afdc8c02f3b110f82b4bfb70b8a3efb7a</anchor>
      <arglist>(size_type i, const BareEdge &amp;e)</arglist>
    </member>
    <member kind="variable">
      <type>size_type</type>
      <name>first</name>
      <anchorfile>structFeel_1_1BareFace.html</anchorfile>
      <anchor>aadb55c2e6517586dd24a3ad1b46d77d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>size_type</type>
      <name>second</name>
      <anchorfile>structFeel_1_1BareFace.html</anchorfile>
      <anchor>a1b2987500ffe80fff52fa2c7611fa45d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>size_type</type>
      <name>third</name>
      <anchorfile>structFeel_1_1BareFace.html</anchorfile>
      <anchor>a7159508f7b9d122a921593d8cd2959b3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::cmpBareItem&lt; BarePoint &gt;</name>
    <filename>structFeel_1_1cmpBareItem_3_01BarePoint_01_4.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>operator()</name>
      <anchorfile>structFeel_1_1cmpBareItem_3_01BarePoint_01_4.html</anchorfile>
      <anchor>a5d12ef657c04900ce6a877a3312a51c1</anchor>
      <arglist>(const BarePoint &amp;e1, const BarePoint &amp;e2) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::cmpBareItem&lt; BareEdge &gt;</name>
    <filename>structFeel_1_1cmpBareItem_3_01BareEdge_01_4.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>operator()</name>
      <anchorfile>structFeel_1_1cmpBareItem_3_01BareEdge_01_4.html</anchorfile>
      <anchor>a6063be955cf43a540f547cf1088f4a70</anchor>
      <arglist>(const BareEdge &amp;e1, const BareEdge &amp;e2) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::cmpBareItem&lt; BareFace &gt;</name>
    <filename>structFeel_1_1cmpBareItem_3_01BareFace_01_4.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>operator()</name>
      <anchorfile>structFeel_1_1cmpBareItem_3_01BareFace_01_4.html</anchorfile>
      <anchor>a47d2ed4ad10f636b1c32c2271bcf8ebe</anchor>
      <arglist>(const BareFace &amp;e1, const BareFace &amp;e2) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::BareItemsHandler</name>
    <filename>classFeel_1_1BareItemsHandler.html</filename>
    <templarg>BareItem</templarg>
    <member kind="typedef">
      <type>std::map&lt; BareItem, Feel::size_type, cmpBareItem&lt; BareItem &gt; &gt;</type>
      <name>container</name>
      <anchorfile>classFeel_1_1BareItemsHandler.html</anchorfile>
      <anchor>a5d344caa2ec458109520615b1d117fe2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>container::size_type</type>
      <name>size_type</name>
      <anchorfile>classFeel_1_1BareItemsHandler.html</anchorfile>
      <anchor>a187b0656dea07fe4f05e0b939d9d3241</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>container::iterator</type>
      <name>iterator</name>
      <anchorfile>classFeel_1_1BareItemsHandler.html</anchorfile>
      <anchor>a75e6af662aaf21d8eaa6b0b23ee55745</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>container::const_iterator</type>
      <name>const_iterator</name>
      <anchorfile>classFeel_1_1BareItemsHandler.html</anchorfile>
      <anchor>a4eeb8268330e37136fe307526496dfbd</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::pair&lt; const BareItem, size_type &gt;</type>
      <name>value_type</name>
      <anchorfile>classFeel_1_1BareItemsHandler.html</anchorfile>
      <anchor>a5c4cb658e257fadb03fd86388a81e3ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BareItemsHandler</name>
      <anchorfile>classFeel_1_1BareItemsHandler.html</anchorfile>
      <anchor>aceb995c6a43799c4a29f3c723a58957d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isThere</name>
      <anchorfile>classFeel_1_1BareItemsHandler.html</anchorfile>
      <anchor>a525aaef29225d83fd828e3a0c92f8923</anchor>
      <arglist>(BareItem const &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>id</name>
      <anchorfile>classFeel_1_1BareItemsHandler.html</anchorfile>
      <anchor>ae3942b42600b86454b2aaa2223f4861a</anchor>
      <arglist>(BareItem const &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setId</name>
      <anchorfile>classFeel_1_1BareItemsHandler.html</anchorfile>
      <anchor>a5f357fd7cfccd45cc06ecdaf78bfbcf4</anchor>
      <arglist>(BareItem const &amp;item, size_type const i)</arglist>
    </member>
    <member kind="function">
      <type>std::pair&lt; size_type, bool &gt;</type>
      <name>addIfNotThere</name>
      <anchorfile>classFeel_1_1BareItemsHandler.html</anchorfile>
      <anchor>a810c581e82668e93ef0c609c1fc6768b</anchor>
      <arglist>(BareItem const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>std::pair&lt; size_type, bool &gt;</type>
      <name>addIfNotThere</name>
      <anchorfile>classFeel_1_1BareItemsHandler.html</anchorfile>
      <anchor>a85596e356418f6f0a1881743d67560bc</anchor>
      <arglist>(BareItem const &amp;, const size_type id)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isThereDel</name>
      <anchorfile>classFeel_1_1BareItemsHandler.html</anchorfile>
      <anchor>ae567424b07b1d0ab215eaaba70a44f01</anchor>
      <arglist>(BareItem const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>howMany</name>
      <anchorfile>classFeel_1_1BareItemsHandler.html</anchorfile>
      <anchor>ae1e8777a3464b9c2e5c9b533d2df9b73</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>maxId</name>
      <anchorfile>classFeel_1_1BareItemsHandler.html</anchorfile>
      <anchor>a9fc712dae6d828b1ec63568f0f4b4665</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>showMe</name>
      <anchorfile>classFeel_1_1BareItemsHandler.html</anchorfile>
      <anchor>a7a7a383f3144857265f135065061e93d</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::ConvexBase</name>
    <filename>classFeel_1_1ConvexBase.html</filename>
  </compound>
  <compound kind="class">
    <name>Feel::Convex</name>
    <filename>classFeel_1_1Convex.html</filename>
    <templarg>Dim</templarg>
    <templarg>Order</templarg>
    <templarg>RDim</templarg>
    <base>Feel::ConvexBase</base>
    <member kind="function">
      <type></type>
      <name>Convex</name>
      <anchorfile>classFeel_1_1Convex.html</anchorfile>
      <anchor>a72ae3d43db8c20bd98291a103675cd96</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Convex</name>
      <anchorfile>classFeel_1_1Convex.html</anchorfile>
      <anchor>af259e4f211ce0123f08ee87767e8b3e7</anchor>
      <arglist>(Convex const &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Convex</name>
      <anchorfile>classFeel_1_1Convex.html</anchorfile>
      <anchor>a1e12a82a25e337703849a44b35a78f46</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Convex &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1Convex.html</anchorfile>
      <anchor>a39b86ac8338873bdc834a5ba88c8aeaf</anchor>
      <arglist>(Convex const &amp;o)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>nDim</name>
      <anchorfile>classFeel_1_1Convex.html</anchorfile>
      <anchor>a5df6ca6a6a5d425ff2c304eb1b5fbbbf</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>nOrder</name>
      <anchorfile>classFeel_1_1Convex.html</anchorfile>
      <anchor>a6d10547ebf7ea8c3f060c66dcd50115f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>nRealDim</name>
      <anchorfile>classFeel_1_1Convex.html</anchorfile>
      <anchor>a89d45b3c2674d8eeb7771198e1aaebd7</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::Geo0D</name>
    <filename>classFeel_1_1Geo0D.html</filename>
    <templarg>Dim</templarg>
    <templarg>T</templarg>
    <base>boost::equality_comparable</base>
    <base>boost::less_than_comparable</base>
    <base>boost::less_than_comparable</base>
    <base>GeoEntity&lt; Simplex&lt; 0, 1, Dim &gt; &gt;</base>
    <base>node::type</base>
    <member kind="typedef">
      <type>Geo0D&lt; Dim, T &gt;</type>
      <name>self_type</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga50a4e3ec456d5a3c78736d3c82a6ee8d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>T</type>
      <name>value_type</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaf8b2236775871cba4b723c3bcc4062a0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>matrix_node&lt; value_type &gt;::type</type>
      <name>matrix_node_type</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaee35df1da9c80a4bdd4ce39568fc1192</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>super2</type>
      <name>node_type</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga59d363ab3c2b473b058c9c1161586783</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>node&lt; T, 2 &gt;::type</type>
      <name>parametric_node_type</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga9239f236dd0ee19a96d1300127e36992</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geo0D</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga0ac43772934e65534b52a8a94c9ae695</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geo0D</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gac9ba26841cb3ead5c226b3473fc70da8</anchor>
      <arglist>(size_type id, bool boundary=false, bool is_vertex=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geo0D</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gadcdd3966188c80eaede4e6f00ebba85b</anchor>
      <arglist>(size_type id, value_type x, value_type y, value_type z, bool boundary=false, bool is_vertex=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geo0D</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaf66a13ff6828a837d1a2654fedef4f96</anchor>
      <arglist>(value_type x, value_type y, value_type z)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geo0D</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga4ff1345f68fec3523e611acbed709d17</anchor>
      <arglist>(size_type id, node_type const &amp;__x, bool boundary=false, bool is_vertex=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geo0D</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gabe8eb591c5b5c603c6912ced187e85db</anchor>
      <arglist>(node_type const &amp;__x)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geo0D</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga013a02132e097f041c4b987f27e0c91a</anchor>
      <arglist>(ublas::vector_expression&lt; AE &gt; const &amp;__expr)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geo0D</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gab9f07e903fbb90d5247c7cef3305fef7</anchor>
      <arglist>(Geo0D const &amp;G)</arglist>
    </member>
    <member kind="function">
      <type>Geo0D &amp;</type>
      <name>operator=</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga6522315b162bb7e6cc1ace6a633f96ba</anchor>
      <arglist>(Geo0D const &amp;G)</arglist>
    </member>
    <member kind="function">
      <type>Geo0D &amp;</type>
      <name>operator=</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaba4a81f1065352fbf0e72a0f4ff625da</anchor>
      <arglist>(ublas::vector_expression&lt; AE &gt; const &amp;expr)</arglist>
    </member>
    <member kind="function">
      <type>Geo0D &amp;</type>
      <name>operator+=</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga5c362729980c4b2afdbcc0ded6d70183</anchor>
      <arglist>(ublas::vector_expression&lt; AE &gt; const &amp;expr)</arglist>
    </member>
    <member kind="function">
      <type>value_type &amp;</type>
      <name>operator()</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gabcd5a9b3b606900d05545cc3066c235c</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>operator()</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gacd228b3af710fa1c377e6bc8d893747b</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isVertex</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga687c5a4ceb94411b600c1c15776b94a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAsVertex</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaabcbf4fca463322092f7d2b5f83bfb58</anchor>
      <arglist>(bool v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMesh</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga1030b5e6799a68514b0035c27121e1d2</anchor>
      <arglist>(MeshBase const *m)</arglist>
    </member>
    <member kind="function">
      <type>MeshBase const *</type>
      <name>mesh</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga9b8049387dd9fed597144ba2840128c6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Geo0D const &amp;</type>
      <name>node</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaf929e439be53c18fb5efebbcfcf530a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>matrix_node_type</type>
      <name>G</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga88ea9202a3eb375f41be8a1d545b6d59</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>matrix_node_type</type>
      <name>vertices</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga23ad7f1fba9bd38e68e81ab0b06617d3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>measure</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga2242876825ab4dca2451bfe1e5b2bb66</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isParametric</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaffeabdf04cb4703f697ffe69a1e0bdfa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>gDim</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gaeeb759cdfffbdcb912bcf632a2027ea7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>gTag</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga87b6b0a77eb36ac8b8dbbee6ff1a0d98</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>parametric_node_type const &amp;</type>
      <name>parametricCoordinates</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga8355f52e182c4206c82e65687413dcd2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>u</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga34eb8201d0c8fdb61bd9e2718272e74e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>value_type</type>
      <name>v</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga7b199d1ec35ab1bd392e19f660e35a0f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNode</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gad752da351c137b48fba9f051ea556ef7</anchor>
      <arglist>(node_type const &amp;__n)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gadde2f305ab7f56fa4ff9dc7488cf23e3</anchor>
      <arglist>(Geo0D const &amp;geo0d) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga9af5c49c7e028816e8f2554a079a7d1a</anchor>
      <arglist>(Geo0D const &amp;e) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga26c4331e0598ec8296b1e0c48ed2a0db</anchor>
      <arglist>(size_type __i) const </arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>showMe</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga8de5f4910a8bd6155ebf87f01003ffca</anchor>
      <arglist>(bool verbose=false, std::ostream &amp;c=std::cout) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPoint</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gae5a32ca499164e865992428944b202c9</anchor>
      <arglist>(uint16_type const , self_type const &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>self_type &amp;</type>
      <name>translate</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga6fba0376b90af6b3e72b9e000c606b33</anchor>
      <arglist>(node_type const &amp;trans)</arglist>
    </member>
    <member kind="function">
      <type>Marker1 const &amp;</type>
      <name>marker</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga0d1c8fdfb805c7fdbfc59e08d93657e6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Marker1 &amp;</type>
      <name>marker</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gabd5d8b34994b96562ab0c93242283793</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMarker</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga9725111290f553f7418358343f1d60c3</anchor>
      <arglist>(flag_type v)</arglist>
    </member>
    <member kind="function">
      <type>Marker2 const &amp;</type>
      <name>marker2</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gadef3153f8eb4e0855b4bd11049d243c6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Marker2 &amp;</type>
      <name>marker2</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga4a3c8e381964a2fab4b27b6687539e5a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMarker2</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga51d4a358d099cac0164ec55b3b6c3589</anchor>
      <arglist>(flag_type v)</arglist>
    </member>
    <member kind="function">
      <type>Marker3 const &amp;</type>
      <name>marker3</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga8a289de52f1ddf10d9f26a3311447249</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Marker3 &amp;</type>
      <name>marker3</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gad7b07eee5cf6e403a288b5db1a96c2ea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMarker3</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga5d1619f7868940efff9d06c8dc785154</anchor>
      <arglist>(flag_type v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTags</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga0feb3581f0d0f4e241d15d4a65c3ee32</anchor>
      <arglist>(std::vector&lt; int &gt; const &amp;tags)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGDim</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga88ce00f6604987d9e1333f56c73c7f33</anchor>
      <arglist>(int gdim)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGTag</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga1978067d79c83df9e07d835a98c45e11</anchor>
      <arglist>(int gtag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setParametricCoordinates</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>ga1252fb573284e4e13d9e86b6b124b6ef</anchor>
      <arglist>(parametric_node_type const &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setParametricCoordinates</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gac3260898f43d35d1bb240599561d0e58</anchor>
      <arglist>(value_type u, value_type v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geo0D</name>
      <anchorfile>classFeel_1_1Geo0D.html</anchorfile>
      <anchor>aa7aa600fd13eaf01bb0b42d14435ef38</anchor>
      <arglist>(uint16_type id, bool boundary)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geo0D</name>
      <anchorfile>classFeel_1_1Geo0D.html</anchorfile>
      <anchor>a86f7aae017cec344b461a98f36c506eb</anchor>
      <arglist>(uint16_type id, Real x, Real y, Real z, bool boundary)</arglist>
    </member>
    <member kind="function">
      <type>Geo0D&lt; Dim &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1Geo0D.html</anchorfile>
      <anchor>a53b29c9e0512e103330e1e26d0801e4b</anchor>
      <arglist>(Geo0D&lt; Dim &gt; const &amp;G)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>nDim</name>
      <anchorfile>group__GeoXD.html</anchorfile>
      <anchor>gabde4d34df01c18a1f4ca3f815eb1e824</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::SubFaceOfNone</name>
    <filename>classFeel_1_1SubFaceOfNone.html</filename>
    <class kind="struct">Feel::SubFaceOfNone::Element</class>
    <member kind="typedef">
      <type>boost::tuple&lt; size_type, size_type, uint16_type &gt;</type>
      <name>element_connectivity_type</name>
      <anchorfile>classFeel_1_1SubFaceOfNone.html</anchorfile>
      <anchor>a3df1b117ef77bea86f192bffecd2f68b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>boost::none_t</type>
      <name>element</name>
      <anchorfile>classFeel_1_1SubFaceOfNone.html</anchorfile>
      <anchor>ad36b3dfccee0207fb772fd63d35091d2</anchor>
      <arglist>(uint16_type) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SubFaceOfNone</name>
      <anchorfile>classFeel_1_1SubFaceOfNone.html</anchorfile>
      <anchor>aa7be190335d2a431186c87c6c411c2a4</anchor>
      <arglist>(SubFaceOfNone const &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SubFaceOfNone</name>
      <anchorfile>classFeel_1_1SubFaceOfNone.html</anchorfile>
      <anchor>a6d0e95172323fd38e919a4c5b9cd873e</anchor>
      <arglist>(SFO const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isInterProcessDomain</name>
      <anchorfile>classFeel_1_1SubFaceOfNone.html</anchorfile>
      <anchor>ac72d9d27bcca753572af718cb4a42cec</anchor>
      <arglist>(size_type) const </arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>nDim</name>
      <anchorfile>classFeel_1_1SubFaceOfNone.html</anchorfile>
      <anchor>ac1044fd4303eb6aa2bacd7090982a81d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::SubFaceOfNone::Element</name>
    <filename>structFeel_1_1SubFaceOfNone_1_1Element.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>ET</type>
      <name>type</name>
      <anchorfile>structFeel_1_1SubFaceOfNone_1_1Element.html</anchorfile>
      <anchor>a70c6835b7e92a97da8a0457a1dd66528</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::SubFaceOf</name>
    <filename>classFeel_1_1SubFaceOf.html</filename>
    <templarg></templarg>
    <class kind="struct">Feel::SubFaceOf::Element</class>
    <member kind="typedef">
      <type>ElementType</type>
      <name>entity_type</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>a5f0089ddb0b01b78d3d895e85e9205c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>boost::tuple&lt; ElementType const *, size_type, uint16_type, size_type &gt;</type>
      <name>element_connectivity_type</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>a08494ed2d0f2845a9ee8a7131e4d3713</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SubFaceOf</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>a8bd1535e495c4009af4fcaeb2582f642</anchor>
      <arglist>(element_connectivity_type const &amp;connect0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SubFaceOf</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>ae0a256542930607bc66ec6b25ef4afed</anchor>
      <arglist>(element_connectivity_type const &amp;connect0, element_connectivity_type const &amp;connect1)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SubFaceOf</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>adee90844eb1bd251332a25a810eeb2e0</anchor>
      <arglist>(SubFaceOf const &amp;sf)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SubFaceOf</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>a23f02f4609c9761051b25d14310da23e</anchor>
      <arglist>(SubFaceOfNone const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>SubFaceOf &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>a6e29152bfb57ee7b30293637228307bd</anchor>
      <arglist>(SubFaceOf const &amp;sf)</arglist>
    </member>
    <member kind="function">
      <type>SubFaceOf &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>ad0d0c3c47fc4cadb012deb36c0c8ab62</anchor>
      <arglist>(SubFaceOfNone const &amp;)</arglist>
    </member>
    <member kind="function">
      <type>entity_type const &amp;</type>
      <name>element</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>a6abdf727f9d57348366b41f48aaa6732</anchor>
      <arglist>(uint16_type e) const </arglist>
    </member>
    <member kind="function">
      <type>entity_type const &amp;</type>
      <name>element0</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>a5197aed4f921c14377586352bad4714b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>entity_type const &amp;</type>
      <name>element1</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>abf3674fc9558b047365b4e9520272720</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>ad_first</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>a29dbd468c2a5888f3e0e168f6a704a66</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>uint16_type</type>
      <name>pos_first</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>ab9a372d9b38fa9daa3fa473aaaa923d7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>proc_first</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>a73930d9f1786f1ad15ebdd886757f593</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>ad_second</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>aa1634bfc7b6d5ffe910be7ebcd059b2c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>uint16_type</type>
      <name>pos_second</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>ad8b2a1669a205e3d3e9dafa7acd2cc51</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>proc_second</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>acd13e97809a78950e03e3b0d90af5843</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>element_connectivity_type const &amp;</type>
      <name>connection0</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>a9f536d058944770b77cdb5f901265dfa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>element_connectivity_type const &amp;</type>
      <name>connection1</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>ad106743b27b31e362816426d37c69aaf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setConnection</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>a3b4214d7e12e525e98331643437aedd1</anchor>
      <arglist>(uint16_type f, element_connectivity_type const &amp;connect)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setConnection0</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>ae9203bec129b108191ec76afeb560382</anchor>
      <arglist>(element_connectivity_type const &amp;connect)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setConnection1</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>a6ac9a2f57e5907f2ff7ebe5f8497a9cd</anchor>
      <arglist>(element_connectivity_type const &amp;connect)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isConnectedTo0</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>a72a07f8dc1de0ec52e93f9de1b0b88e3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isConnectedTo1</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>a7b40590164cc122a42b414f1ef08086a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isInterProcessDomain</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>aa8f23e788c1a9638a2cad504cf216208</anchor>
      <arglist>(size_type p) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isIntraProcessDomain</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>a19e58f599e12c72db1a6af8adce99456</anchor>
      <arglist>(size_type p) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>disconnect</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>a5772029713b23c5714a1e59e68102e0d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>nDim</name>
      <anchorfile>classFeel_1_1SubFaceOf.html</anchorfile>
      <anchor>a2c294d0743d2511ce292ee66a4be03ff</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Feel::SubFaceOf::Element</name>
    <filename>structFeel_1_1SubFaceOf_1_1Element.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>ElementType</type>
      <name>type</name>
      <anchorfile>structFeel_1_1SubFaceOf_1_1Element.html</anchorfile>
      <anchor>a663d086638d494f46bcd166c19aa0164</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::GeoElement0D</name>
    <filename>classFeel_1_1GeoElement0D.html</filename>
    <templarg>Dim</templarg>
    <templarg>SubFace</templarg>
    <templarg>T</templarg>
    <base>Feel::Geo0D</base>
    <member kind="typedef">
      <type>Geo0D&lt; Dim, T &gt;</type>
      <name>geo0d_type</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a4939f42f39394433cfca14dfc088c6f5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>geo0d_type::node_type</type>
      <name>node_type</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a54161ee7679fc0620ec6f7b76ff9cef3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>geo0d_type</type>
      <name>super</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>aa9da83deef931a2f37161f7f223ddcef</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SubFace</type>
      <name>super2</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>aa8345b7f66644792bc1799ac9db5b647</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoElement0D&lt; Dim, SubFace, T &gt;</type>
      <name>self_type</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a9c1eccf4d055c09f63d69812f9fb4854</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mpl::if_&lt; mpl::equal_to&lt; mpl::int_&lt; SubFace::nDim &gt;, mpl::int_&lt; 0 &gt; &gt;, mpl::identity&lt; self_type &gt;, mpl::identity&lt; typename SubFace::template Element&lt; self_type &gt;::type &gt; &gt;::type::type</type>
      <name>element_type</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a6a50f84763fa324cb407c01de2ea4013</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>self_type</type>
      <name>point_type</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a4ecb78b1ab1c058863cef957d8662ae1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GeoElement0D</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a86d0fd01e47daca985ee2f3cba5b521a</anchor>
      <arglist>(size_type id, bool boundary=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GeoElement0D</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a2b947f0a0b8b2cedf5990127807c7a14</anchor>
      <arglist>(size_type id, node_type const &amp;n, bool boundary=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GeoElement0D</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>aabb74428da1d6c4de4f143318cfea448</anchor>
      <arglist>(size_type id, Real x, Real y, Real z, bool boundary=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>GeoElement0D</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a65d76c65b027e1a86f9ea63d55a9e84b</anchor>
      <arglist>(GeoElement0D&lt; Dim, SF, T &gt; const &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>GeoElement0D &amp;</type>
      <name>operator=</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a9722e511183dd822c62e7c28e3369807</anchor>
      <arglist>(GeoElement0D&lt; Dim, SF, T &gt; const &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>MeshBase const *</type>
      <name>mesh</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a25d042b441abea43714d16b7774e2189</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>id</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>af96d9f4c88a1a698308573425d4534bf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>uint16_type</type>
      <name>processId</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>abaefa603db5713974d54c26f65f9a6ff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isInterProcessDomain</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a8ae318855f7b7d6afc1bd043a7d1f16a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isOnBoundary</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a3d8df5dbf78a8264557678332dc85429</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isGhostCell</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a791259c273ef2140c18f8d797573479d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>geo0d_type const &amp;</type>
      <name>point</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a86362b572ca7f08cb9614a7881abaead</anchor>
      <arglist>(uint16_type) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPoint</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a620a55ce0d329a44e5abf145646729de</anchor>
      <arglist>(uint16_type, geo0d_type const &amp;e)</arglist>
    </member>
    <member kind="function">
      <type>Marker1 const &amp;</type>
      <name>marker</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a15f48dc2cd2bf9ff5edf9aa278cb58c0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Marker1 &amp;</type>
      <name>marker</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a7527e980c534151022b33f3807e29f4d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Marker2 const &amp;</type>
      <name>marker2</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a8fc251add20160bf0d3649014d53231c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Marker2 &amp;</type>
      <name>marker2</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>ad4c7526c06b2e30344c9fe66d51be6f8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Marker3 const &amp;</type>
      <name>marker3</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a65b5a89ecb07b899277a2ade5e8e0fe2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Marker3 &amp;</type>
      <name>marker3</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a62df026310fe4b0facfb979ec679461a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>nDim</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a6fac206aa935d355abddd6bd0a99dc99</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const uint16_type</type>
      <name>nRealDim</name>
      <anchorfile>classFeel_1_1GeoElement0D.html</anchorfile>
      <anchor>a5a9e5eb472fe01d5ce780f1ae6bd951b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Feel::GeoElement1D</name>
    <filename>classFeel_1_1GeoElement1D.html</filename>
    <templarg>Dim</templarg>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <base>GeoND&lt; Dim, GEOSHAPE, T, GeoElement0D&lt; Dim, SubFaceOfNone, T &gt; &gt;</base>
    <member kind="typedef">
      <type>GeoND&lt; Dim, GEOSHAPE, T, GeoElement0D&lt; Dim, SubFaceOfNone, T &gt; &gt;</type>
      <name>super</name>
      <anchorfile>classFeel_1_1GeoElement1D.html</anchorfile>
      <anchor>ab7f5d884a964c8fc80d6fdea48a8b2da</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>SubFace</type>
      <name>super2</name>
      <anchorfile>classFeel_1_1GeoElement1D.html</anchorfile>
      <anchor>a8106bdc1080dacf15bb805d7b2ad2dbc</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GEOSHAPE</type>
      <name>GeoShape</name>
      <anchorfile>classFeel_1_1GeoElement1D.html</anchorfile>
      <anchor>a03828082419aadd765753ada12ac2596</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GeoElement1D&lt; Dim, GEOSHAPE, SubFace, T &gt;</type>
      <name>self_type</name>
      <anchorfile>classFeel_1_1GeoElement1D.html</anchorfile>
      <anchor>a85fec3a1d6f4afeaf78a6e17c250bfcd</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>self_type</type>
      <name>element_type</name>
      <anchorfile>classFeel_1_1GeoElement1D.html</anchorfile>
      <anchor>a9b9e0cf920ef8eea804f01112fe470d6</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>mpl::if_&lt; mpl::equal_to&lt; mpl::int_&lt; nDim &gt;, mpl::int_&lt; 1 &gt; &gt;, mpl::identity&lt; GeoElement0D&lt; Dim, SubFaceOf&lt; self_type &gt;, T &gt; &gt;, mpl::identity&lt; GeoElement0D&lt; Dim, SubFaceOfNone, T &gt; &gt; &gt;::type::type</type>
      <name>point_type</name>
      <anchorfile>classFeel_1_1GeoElement1D.html</anchorfile>
      <anchor>a8b4559d9117c09b38eaf915babc13965</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>point_type</type>
      <name>GeoBElement</name>
      <anchorfile>classFeel_1_1GeoElement1D.html</anchorfile>
      <anchor>a7d94e21af6dcf7046e555ac3d3c1ce9f</anchor>
      <arglist></a