/*
  fblogo.h

  Generate linux_logo.h header file for use with the framebuffer boot logo

  Daniel Vedy <daniel@kongsberg.online.no> 1999
  Gordon Fraser <gordon@freakzone.net> 2001/2002/2003

  This software comes with ABSOLUTELY NO WARRANTY
  This software is free software, and you are welcome to redistribute it
  under certain conditions
  See the COPYING file for details.
*/

#ifndef __fblogo_h__
#define __fblogo_h__

/*--------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <string.h>
#include <unistd.h>
#include <getopt.h>


#include "png.h"
#include "low_color.h"

#define PROGRAM_VERSION       "0.5.1"
#define LINUX_24      0 
#define LINUX_22      1
#define PNG_SIG_BYTES 8


#define ERR_NOPNG     1
#define ERR_PNGPTR    2
#define ERR_PNGINFO   3
#define ERR_COLNUM    4
#define SUCCESS 0
#define ERROR   1

#define MAX_ARGUMENTS 5

#define FALSE 0
#define TRUE  1


/*--------------------------------------------------------------------*/
void displayUsage(char*);
void displayVersion(void);
void displayNotice(void);

int  parseArguments(int, char**, char**, char**);
void getFileNames(int, int, char**, char*, char*);

int  openFiles(char*, char*);
int  readInputFile();
void writeOutputFile();
void writeOutputFileHeader();

void cleanup();


int pngCheck();
int pngInit(png_structp*, png_infop*);
int pngGetPalette(png_structp, png_infop, int, int);
int pngReadImage(png_structp png_ptr,  png_infop info_ptr);


/*--------------------------------------------------------------------*/
png_uint_32 width_;
png_uint_32 height_;

unsigned   num_palette_;
png_colorp palette_;
png_bytep  image_data_;

char verbose_;
char version_;

FILE* input_file_  = NULL;
FILE* output_file_ = NULL;

#endif /* __fblogo_h__ */
