/*
 * $Id: chip_st_M27C256B.c,v 1.13 2009-08-03 06:49:41 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#define SZ_BIOS_ROM	(32 * 1024) /* ROM size */

#include <assert.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "fixme.h"
#include "glue-main.h"
#include "glue-shm.h"
#include "umutil.h"

#include "chip_st_M27C256B.h"

#define CHIP_(x) chip_st_M27C256B_ ## x
#define CHIP	"chip_st_M27C256B"

struct cpssp {
	unsigned int state_power;
	uint32_t *haddr;
};

static void *
CHIP_(access)(struct cpssp *cpssp, unsigned long pa)
{
	assert(/* 0 <= pa && */ pa < SZ_BIOS_ROM);

	pa &= 0xfffff000;

	return (unsigned char *) cpssp->haddr + pa;
}

static int
CHIP_(readb)(void *_css, uint8_t *valp, unsigned long addr)
{
	struct cpssp *cpssp = (struct cpssp *) _css;
	uint8_t *va;

	addr &= SZ_BIOS_ROM - 1;

	assert(/* 0 <= pa && */ addr < SZ_BIOS_ROM);

	/*
	 * Read Contents
	 */
	va = CHIP_(access)(cpssp, addr & 0xfffff000);
	*valp = *(va + (addr & 0x00000fff));

	return 0;
}

static int
CHIP_(writeb)(void *_css, uint8_t val, unsigned long addr)
{
	// struct cpssp *cpssp = (struct cpssp *) _css;

	return 0;
}

static int
CHIP_(map)(
	void *_css,
	unsigned long addr,
	char **haddr_mr_p,
	char **haddr_mw_p
)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	addr &= SZ_BIOS_ROM - 1;

	assert(/* 0 <= addr && */ addr < SZ_BIOS_ROM);

	*haddr_mr_p =
	*haddr_mw_p = (char *) cpssp->haddr + addr;

	return 0;
}

static void
CHIP_(power_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	cpssp->state_power = val;
	/* FIXME */
}

void *
CHIP_(create)(
	const char *name,
	const char *img,
	struct sig_manage *port_manage,
	struct sig_boolean *port_power,
	struct sig_cs *port_cs,
	struct sig_isa_bus_main *port_bus
)
{
	static const struct sig_boolean_funcs power_funcs = {
		.set = CHIP_(power_set),
	};
	static const struct sig_cs_funcs cs_funcs = {
		.readb = CHIP_(readb),
		.writeb = CHIP_(writeb),
		.map = CHIP_(map),
	};
	struct cpssp *cpssp;
	const char *path;
	int fd;
	int ret;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);
	cpssp->haddr = shm_alloc(SZ_BIOS_ROM, SHM_PAGE_ALIGNED);
	assert(cpssp->haddr);

	path = buildpath(ROMDIR, img);
	fd = open(path, O_RDONLY);
	assert(0 <= fd);

	ret = read(fd, cpssp->haddr, SZ_BIOS_ROM);
	if (ret < SZ_BIOS_ROM) {
		fprintf(stderr, "WARNING: %s: %s: too small.\n",
				CHIP, img);
	} else {
		char c;

		ret = read(fd, &c, 1);
		if (0 < ret) {
			fprintf(stderr, "WARNING: %s: %s: too big.\n",
					CHIP, img);
		}
	}

	ret = close(fd);
	assert(0 <= ret);

	/* Out */
	/* Call */
	sig_cs_connect(port_cs, cpssp, &cs_funcs);

	/* In */
	cpssp->state_power = 0;
	sig_boolean_connect_in(port_power, cpssp, &power_funcs);

	return cpssp;
}

void
CHIP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp->haddr, SZ_BIOS_ROM);
	free(cpssp);
}
