/*
 * $Id: sig_gen_bus.h,v 1.4 2011-01-11 16:19:06 vrsieh Exp $
 *
 * Copyright (C) 2010 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <inttypes.h>

#include "sig_boolean.h"
#include "sig_boolean_or.h"
#include "sig_gen.h"

#define BUS_HASH_SIZE	(1 << 10)

enum bus_(main_cycle) {
        /* Must be the same as in sig_host_bus.h! */
        BUS_(C0R) = 0,
        BUS_(C0W),
        BUS_(C1R),
        BUS_(C1W),
        BUS_(IOR),
        BUS_(IOW),
        BUS_(MR),
        BUS_(MW),
        BUS_(INTA),
};

struct bus_(main_funcs) {
        int (*type_addr)(void *s, unsigned int type, bus_addr_t addr);
        int (*read_data)(void *s, unsigned int bs, bus_data_t *valp);
        int (*write_data)(void *s, unsigned int bs, bus_data_t val);

        int (*c0r)(void *s, bus_addr_t addr, unsigned int bs, bus_data_t *valp);
        int (*c0w)(void *s, bus_addr_t addr, unsigned int bs, bus_data_t val);

        int (*c1r)(void *s, bus_addr_t addr, unsigned int bs, bus_data_t *valp);
        int (*c1w)(void *s, bus_addr_t addr, unsigned int bs, bus_data_t val);

        int (*ior)(void *s, bus_addr_t port, unsigned int bs, bus_data_t *valp);
        int (*iow)(void *s, bus_addr_t port, unsigned int bs, bus_data_t val);

        int (*ior_info)(void *s, bus_addr_t port, unsigned int bs,
                        int (**cfp)(void *, bus_addr_t, unsigned int, bus_data_t *),
                        void **csp);
        int (*iow_info)(void *s, bus_addr_t port, unsigned int bs,
                        int (**cfp)(void *, bus_addr_t, unsigned int, bus_data_t),
                        void **csp);

        void (*ior_info_flush)(void *s, bus_addr_t port, unsigned int bs);
        void (*iow_info_flush)(void *s, bus_addr_t port, unsigned int bs);

        int (*mr)(void *s, bus_addr_t addr, unsigned int bs, bus_data_t *valp);
        int (*mw)(void *s, bus_addr_t addr, unsigned int bs, bus_data_t val);

        int (*map_r_check)(void *s, bus_addr_t pa);
        int (*map_r)(void *s, bus_addr_t pa, char **haddr_p);
        int (*map_w_check)(void *s, bus_addr_t pa);
        int (*map_w)(void *s, bus_addr_t pa, char **haddr_p);

        void (*unmap)(void *s, bus_addr_t pa, bus_addr_t len);

        int (*inta_addr)(void *s);
        int (*inta_data)(void *s, uint8_t *valp);
};

struct bus_(main) {
        enum sig_gen_type type;
        struct {
                void *s;
                const struct bus_(main_funcs) *f;
        } member[32];
        unsigned int member_count;

        struct bus_(main_io) {
                struct bus_(main_io) *lru_prev;
                struct bus_(main_io) *lru_next;

                struct bus_(main_io) *hash_prev;
                struct bus_(main_io) *hash_next;

                enum {
                        BUS_(TYPE_IOR),
                        BUS_(TYPE_IOW),
                } type;

                bus_addr_t port;
                unsigned int bs;
                int (*ior)(void *s,
			bus_addr_t port, unsigned int bs, bus_data_t *valp);
                int (*iow)(void *s,
			bus_addr_t port, unsigned int bs, bus_data_t val);
                void *s;
        } io[256 + 256];
        struct bus_(main_io) *io_lru_first;
        struct bus_(main_io) *io_lru_last;
        struct bus_(main_io) *io_hash_first[BUS_HASH_SIZE];
        struct bus_(main_io) *io_hash_last[BUS_HASH_SIZE];

        struct bus_(main_map) {
                struct bus_(main_map) *lru_prev;
                struct bus_(main_map) *lru_next;

                struct bus_(main_map) *hash_prev;
                struct bus_(main_map) *hash_next;

                enum {
                        BUS_(TYPE_MR),
                        BUS_(TYPE_MW),
                } type;

                bus_addr_t addr;
                const bus_data_t *mr;
                bus_data_t *mw;
        } map[256 + 256];
        struct bus_(main_map) *map_lru_first;
        struct bus_(main_map) *map_lru_last;
        struct bus_(main_map) *map_hash_first[BUS_HASH_SIZE];
        struct bus_(main_map) *map_hash_last[BUS_HASH_SIZE];
};

struct bus_(main_merge) {
        struct bus_(main) *s0;
        struct bus_(main) *s1;
};

extern int
bus_(main_type_addr)(struct bus_(main) *b, void *s,
                unsigned int type, bus_addr_t addr);
extern int
bus_(main_read_data)(struct bus_(main) *b, void *s,
                unsigned int bs, bus_data_t *valp);
extern int
bus_(main_write_data)(struct bus_(main) *b, void *s,
                unsigned int bs, bus_data_t val);

extern int
bus_(main_c0r)(struct bus_(main) *b, void *s,
                bus_addr_t addr, unsigned int bs, bus_data_t *valp);
extern int
bus_(main_c0w)(struct bus_(main) *b, void *s,
                bus_addr_t addr, unsigned int bs, bus_data_t val);

extern int
bus_(c1r)(struct bus_(main) *b, void *s,
                bus_addr_t addr, unsigned int bs, bus_data_t *valp);
extern int
bus_(c1w)(struct bus_(main) *b, void *s,
                bus_addr_t addr, unsigned int bs, bus_data_t val);

extern int
bus_(ior)(struct bus_(main) *b, void *s,
                bus_addr_t port, unsigned int bs, bus_data_t *valp);
extern int
bus_(iow)(struct bus_(main) *b, void *s,
                bus_addr_t port, unsigned int bs, bus_data_t val);

extern int
bus_(ior_info)(struct bus_(main) *b, void *s,
                bus_addr_t port, unsigned int bs,
                int (**cf)(void *, bus_addr_t, unsigned int, bus_data_t *),
                void **cs);
extern int
bus_(iow_info)(struct bus_(main) *b, void *s,
                bus_addr_t port, unsigned int bs,
                int (**cf)(void *, bus_addr_t, unsigned int, bus_data_t),
                void **cs);

extern void
bus_(ior_info_flush)(struct bus_(main) *b, void *s,
                bus_addr_t port, unsigned int bs);
extern void
bus_(iow_info_flush)(struct bus_(main) *b, void *s,
                bus_addr_t port, unsigned int bs);

extern int
bus_(mr)(struct bus_(main) *b, void *s,
                bus_addr_t addr, unsigned int bs, bus_data_t *valp);
extern int
bus_(mw)(struct bus_(main) *b, void *s,
                bus_addr_t addr, unsigned int bs, bus_data_t val);
extern int
bus_(map_r_check)(struct bus_(main) *b, void *s, bus_addr_t pa);
extern int
bus_(map_r)(struct bus_(main) *b, void *s, bus_addr_t pa, char **haddr_p);
extern int
bus_(map_w_check)(struct bus_(main) *b, void *s, bus_addr_t pa);
extern int
bus_(map_w)(struct bus_(main) *b, void *s, bus_addr_t pa, char **haddr_p);

extern void
bus_(unmap)(struct bus_(main) *b,
                void *s, bus_addr_t pa, bus_addr_t len);

extern int
bus_(inta_addr)(struct bus_(main) *b, void *s);
extern int
bus_(inta_data)(struct bus_(main) *b, void *s,
                unsigned char *valp);

extern void
bus_(main_connect)(struct bus_(main) *b,
                void *s, const struct bus_(main_funcs) *f);

extern struct bus_(main_merge) *
bus_(main_merge)(
        struct bus_(main) *s0,
        struct bus_(main) *s1
);
extern void
bus_(main_split)(struct bus_(main_merge) *m);

extern struct bus_(main) *
bus_(main_create)(const char *name);
extern void
bus_(main_destroy)(struct bus_(main) *sig);

struct bus_(idsel_funcs) {
        int (*c0r)(void *s, bus_addr_t addr, unsigned int bs, bus_data_t *valp);
        int (*c0w)(void *s, bus_addr_t addr, unsigned int bs, bus_data_t val);
};

struct bus_(idsel) {
        enum sig_gen_type type;
        struct {
                void *s;
                const struct bus_(idsel_funcs) *f;
        } member[10];
        unsigned int member_count;
};

struct bus_(idsel_merge) {
        struct bus_(idsel) *s0;
        struct bus_(idsel) *s1;
};

extern int
bus_(idsel_c0r)(struct bus_(idsel) *b, void *s,
                bus_addr_t addr, unsigned int bs, bus_data_t *valp);
extern int
bus_(idsel_c0w)(struct bus_(idsel) *b, void *s,
                bus_addr_t addr, unsigned int bs, bus_data_t val);

extern void
bus_(idsel_connect)(struct bus_(idsel) *b,
                void *s, const struct bus_(idsel_funcs) *f);

extern struct bus_(idsel_merge) *
bus_(idsel_merge)(
        struct bus_(idsel) *s0,
        struct bus_(idsel) *s1
);
extern void
bus_(idsel_split)(struct bus_(idsel_merge) *m);

extern struct bus_(idsel) *
bus_(idsel_create)(const char *name);
extern void
bus_(idsel_destroy)(struct bus_(idsel) *sig);

struct bus {
        enum sig_gen_type type;
        struct sig_boolean *p5V;
        struct sig_boolean *p12V;
        struct sig_boolean *m12V;
        struct sig_boolean *n_reset;
        struct bus_(idsel) *idsel;
        struct bus_(main) *main;
        struct sig_boolean_or *intA;
        struct sig_boolean_or *intB;
        struct sig_boolean_or *intC;
        struct sig_boolean_or *intD;
};

struct bus *
bus_(create)(const char *name);
extern void
bus_(destroy)(struct bus *sig);
