/* $Id: cim_boolean.c,v 1.9 2009-01-27 17:06:39 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "cim_boolean.h"

static void
cim_boolean_set(void *_css, unsigned int val)
{
	struct cim_boolean *css = (struct cim_boolean *) _css;

	cim_send(&css->bridge, &val, sizeof(val));
}

static void
cim_boolean_receive(void *_css, void *_val, unsigned int bufsize)
{
	struct cim_boolean *css = (struct cim_boolean *) _css;
	unsigned int val = *(unsigned int *) _val;

	sig_boolean_set(css->sig_boolean, css, val);
}

void
cim_boolean_init(struct cim_boolean *css, struct sig_boolean *sig_boolean)
{
	static const struct sig_boolean_funcs funcs = {
		.set = cim_boolean_set,
	};

	cim_connect(&css->bridge, cim_boolean_receive, css);

	css->sig_boolean = sig_boolean;
	sig_boolean_connect_out(sig_boolean, css, 0);
	sig_boolean_connect_in(sig_boolean, css, &funcs);
}

void
cim_boolean_create(struct cim_boolean *css)
{
	cim_create(&css->bridge);
}

void
cim_boolean_destroy(struct cim_boolean *css)
{
	cim_destroy(&css->bridge);
}
