/* $Id: chip_intel_80686_klamath_cpuid.c,v 1.13 2009-01-28 12:59:18 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define FAST

#include <assert.h>
#include <stdio.h>

#include "chip_intel_80686_klamath_def.h"

#include "exec.h"
#include "arch_gen_cpu_x86_sim_fast.h"

void
chip_intel_80686_klamath_helper_cpuid(void)
{
	uint32_t index_;

	index_ = (uint32_t) EAX;

	if (2 < index_) {
		index_ = 0;
	}

	switch (index_) {
	case 0:
		EAX = 2;
		EBX = 0x756e6547; /* "GenuineIntel" */
		ECX = 0x6c65746e;
		EDX = 0x49656e69;
		break;
	case 1:
		EAX = 0x00000634; /* CPU Version */
		EBX = 0x00000000;
		ECX = 0x00000000;
		EDX = CONFIG_CPU_FPU_SUPPORT << 0
			| CONFIG_CPU_VME_SUPPORT << 1
			| CONFIG_CPU_DE_SUPPORT << 2
			| CONFIG_CPU_PSE_SUPPORT << 3
			| CONFIG_CPU_TSC_SUPPORT << 4
			| CONFIG_CPU_MSR_SUPPORT << 5
			| CONFIG_CPU_PAE_SUPPORT << 6
			| CONFIG_CPU_MCE_SUPPORT << 7
			| CONFIG_CPU_CX8_SUPPORT << 8
			| CONFIG_CPU_APIC_SUPPORT << 9
			| CONFIG_CPU_SEP_SUPPORT << 11 
			| CONFIG_CPU_MTRR_SUPPORT << 12
			| CONFIG_CPU_PGE_SUPPORT << 13
			| CONFIG_CPU_MCA_SUPPORT << 14
			| CONFIG_CPU_CMOV_SUPPORT << 15
			| CONFIG_CPU_PAT_SUPPORT << 16
			| CONFIG_CPU_PSE36_SUPPORT << 17
			| CONFIG_CPU_PSN_SUPPORT << 18
			| CONFIG_CPU_CFLSH_SUPPORT << 19
			| CONFIG_CPU_DS_SUPPORT << 21
			| CONFIG_CPU_ACPI_SUPPORT << 22
			| CONFIG_CPU_MMX_SUPPORT << 23
			| CONFIG_CPU_FXSR_SUPPORT << 24
			| CONFIG_CPU_SSE_SUPPORT << 25
			| CONFIG_CPU_SSE2_SUPPORT << 26
			| CONFIG_CPU_SS_SUPPORT << 27
			| CONFIG_CPU_HTT_SUPPORT << 28
			| CONFIG_CPU_TM_SUPPORT << 29
			| CONFIG_CPU_PBE_SUPPORT << 31;

		EDX &= ~CPUID_APIC;	/* 9: Advanced PIC - FIXME */

		env->update_signature = 0;
		break;
	case 2:
		EAX = 0x03020101;
		EBX = 0x00000000;
		ECX = 0x00000000;
		EDX = 0x0c040843;
		break;
	default:
		assert(0); /* Cannot happen. */
	}
}
