/* $Id: WaitConditions.hpp 4323 2009-01-27 13:48:12Z potyra $
 *
 * Wait conditions: Checks sensitivity lists and wait statements, and
 *                  transforms sensitivity lists into wait statements.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __WAIT_CONDITIONS_HPP_INCLUDED
#define __WAIT_CONDITIONS_HPP_INCLUDED

#include <list>
#include "frontend/visitor/TopDownVisitor.hpp"

namespace ast {

//! Check/generate wait conditions from sensitivity lists.
/** dependencies: 
 * 	- ResolveTypes (overload resolution must have happened)
 */
class WaitConditions : public TopDownVisitor {
public:
	//! c'tor.
	WaitConditions();

	/** Visit a Process node.
	 *  @param node Process node that get's visited.
	 */
	virtual void visit(Process &node);

	/** Visit a WaitStat
	 *  @param node WaitStat node that get's visited.
	 */
	virtual void visit(WaitStat &node);

	/** Visit a ProcCallStat
	 *
	 *  @param node ReturnStat node that get's visited.
	 */
	virtual void visit(ProcCallStat &node);

	/** Visit a ProcedureDeclaration node.
	 *  @param node ProcedureDeclaration node that get's visited.
	 */
	virtual void visit(ProcedureDeclaration &node);

private:
	//! sensitivity list of currently examined process (or NULL)
	std::list<Name*> *sensList;

	//! wait statement found in the process?
	bool waitSeen;
};

}; /* namespace ast */

#endif /* __WAIT_CONDITIONS_HPP_INCLUDED */
