/*
	FATSort, utility for sorting FAT directory structures
	Copyright (C) 2004 Boris Leidner <fatsort(at)formenos.de>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
	This file contains/describes functions that parse command line options.
*/

#include "options.h"

#include <getopt.h>
#include "errors.h"
#include "FAT_fs.h"

u_int32_t OPT_VERSION, OPT_HELP, OPT_INFO, OPT_QUIET, OPT_IGNORE_CASE, OPT_ORDER, OPT_LIST, OPT_REVERSE, OPT_FORCE, OPT_NATURAL_SORT, OPT_RECURSIVE;
char OPT_DIRECTORY[MAX_PATH_LEN+1];

int32_t parse_options(int argc, char *argv[]) {
/*
	parses command line options
*/

	int8_t c;

	/* Default (1) is normal order, use -1 for reverse order. */	
	OPT_REVERSE = 1;

	// natural sort
	OPT_NATURAL_SORT = 0;

	opterr=0;
	while ((c=getopt(argc, argv, "ivhqcfo:lrnd:D:")) != -1) {
		switch(c) {
			case 'c' : OPT_IGNORE_CASE = 1; break;
			case 'f' : OPT_FORCE = 1; break;
			case 'h' : OPT_HELP = 1; break;
			case 'i' : OPT_INFO = 1; break;
			case 'l' : OPT_LIST = 1; break;
			case 'o' :
				switch(optarg[0]) {
					case 'd': OPT_ORDER=0; break;
					case 'f': OPT_ORDER=1; break;
					case 'a': OPT_ORDER=2; break;
					default:
						myerror("Unknown flag '%c' for option 'o'.", optarg[0]);
						myerror("Use -h for more help.");
						return -1;
				}
				break;
			case 'd' :
				strncpy(OPT_DIRECTORY, optarg, MAX_PATH_LEN);
				OPT_DIRECTORY[MAX_PATH_LEN]='\0';
				break;
			case 'D' :
				strncpy(OPT_DIRECTORY, optarg, MAX_PATH_LEN);
				OPT_DIRECTORY[MAX_PATH_LEN]='\0';
				OPT_RECURSIVE=1;
				break;			      
			case 'n' : OPT_NATURAL_SORT = 1; break;
			case 'q' : OPT_QUIET = 1; break;
			case 'r' : OPT_REVERSE = -1; break;
			case 'v' : OPT_VERSION = 1; break;
			default :
				myerror("Unknown option '%c'.", optopt);
				myerror("Use -h for more help.");
				return -1;
		}
	}

	return 0;
}
