/*
FatRat download manager
http://fatrat.dolezel.info

Copyright (C) 2006-2008 Lubos Dolezel <lubos a dolezel.info>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2 as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef _CZSHAREUPLOAD_H
#define	_CZSHAREUPLOAD_H
#include <fatrat/Transfer.h>
#include <fatrat/engines/CurlUser.h>
#include <curl/curl.h>
#include <QUuid>
#include <QBuffer>
#include <QFile>

class QHttp;

class CzshareUpload : public Transfer, public CurlUser
{
Q_OBJECT
public:
	CzshareUpload();
	~CzshareUpload();
	
	static Transfer* createInstance() { return new CzshareUpload; }
	
	virtual void init(QString source, QString target);
	virtual QString myClass() const { return "CzshareUpload"; }
	virtual QString name() const;
	virtual Mode primaryMode() const { return Upload; }
	virtual QString object() const { return m_strSource; }
	virtual void setObject(QString obj);
	virtual void setSpeedLimits(int, int up);
	virtual void speeds(int&, int& up) const;
	virtual QString message() const { return m_strMessage; }
	
	virtual void load(const QDomNode& map);
	virtual void save(QDomDocument& doc, QDomNode& map) const;
	virtual void changeActive(bool bActive);
	
	virtual qulonglong total() const;
	virtual qulonglong done() const;
protected:
	void saveLink(QString filename, QString link);
	static int seek_function(QFile* file, curl_off_t offset, int origin);
	
	virtual CURL* curlHandle();
	virtual void transferDone(CURLcode result);
	virtual size_t readData(char* buffer, size_t maxData);
	virtual bool writeData(const char* buffer, size_t bytes);
protected slots:
	void probeDone(bool error);
private:
	CURL* m_curl;
	QHttp* m_probe;
	QBuffer m_buffer;
	QFile m_file;
	curl_httppost* m_postData;
	long m_nPartnerID;
	QUuid m_proxy;
	QString m_strSource, m_strName;
	QString m_strMessage;
	char m_errorBuffer[CURL_ERROR_SIZE];
};


#endif	/* _CZSHAREUPLOAD_H */

