/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-folder-common-types.h,v 1.7 2003/12/15 16:08:53 hoa Exp $
 */

#ifndef ETPAN_FOLDER_COMMON_TYPES_H

#define ETPAN_FOLDER_COMMON_TYPES_H

#include <libetpan/libetpan.h>

#define ETPAN_FOLDER_COMMON_SHOW_STAT            1
#define ETPAN_FOLDER_COMMON_SHOW_SPECIAL_FOLDERS 2

struct etpan_folder_common_app_state {
  /* root folder */
  struct mailfolder * root;
  
  /* colors */
  int main_attr;
  int selection_attr;
  int status_attr;

  /* cursor & selection */
  unsigned int chosen;
  unsigned int first;
  unsigned int selected;

  /* display optimization */
  unsigned int window_size;
  unsigned int * selected_window_backward;
  unsigned int selected_window_backward_count;
  unsigned int * selected_window_forward;
  unsigned int selected_window_forward_count;
  chash * prefix_hash;
  
  /* folder list */
  carray * folder_tab;
  struct etpan_folder_params * params;
  
  int flags;
  
  struct etpan_subapp * app;
  char * search_str;
};

#endif
