/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////


#include "tml/message/packed_message_interface.h"

//----
// partial specialisations of the pack/unpack functions
// for simple data types.

//--- int ---
template<>
void TML_PackedMessageInterface::pack<int>(const int& i)
{
  append(i);
}

template<>
void TML_PackedMessageInterface::unpack<int>(int& i)
{
  i=pop_int();
}

//--- double ----
template<>
void TML_PackedMessageInterface::pack<double>(const double& d)
{
  append(d);
}

template<>
void TML_PackedMessageInterface::unpack<double>(double& d)
{
  d=pop_double();
}
