#############################################################
##                                                         ##
## Copyright (c) 2003-2011 by The University of Queensland ##
## Earth Systems Science Computational Centre (ESSCC)      ##
## http://www.uq.edu.au/esscc                              ##
##                                                         ##
## Primary Business: Brisbane, Queensland, Australia       ##
## Licensed under the Open Software License version 3.0    ##
## http://www.opensource.org/licenses/osl-3.0.php          ##
##                                                         ##
#############################################################

import vtk as kwvtk
from esys.lsm.vis import core

class PointExtractor(core.PointExtractor):
    def __init__(
        self,
        pointMap = lambda dataRecord: dataRecord.getPoint()
    ):
        core.PointExtractor.__init__(self, pointMap)

    def getVtkPoints(self, data):
        vtkPoints = kwvtk.vtkPoints()
        for dataRecord in data:
            vtkPoints.InsertNextPoint(self.getPoint(dataRecord))
        return vtkPoints
