/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#define MPI_NO_CPPBIND
#include <mpi.h>
#include <boost/shared_ptr.hpp>

//--project includes--
#include "Foundation/console.h"
#include "Parallel/SubLatticeControler.h"

//--- IO includes ---
#include <iostream>
#include <fstream>
using std::cout;
using std::endl;
using std::flush;


typedef boost::shared_ptr<std::ofstream> OFStreamPtr;

int main(int argc, char **argv) {
  int status = MPI_Init(&argc,&argv);
  if (status != MPI_SUCCESS) {
    std::cerr << argv[0] << ": MPI_Init failed! Exiting ..." << std::endl;
    return status;
  }

  console.SetQuiet(true) ;
  console.SetVerbose(Con::silent);
  console.SetTiming(false) ;

  try
  {
    OFStreamPtr ofstreamPtr;
    if (argc > 1)
    {
      if (std::string(argv[1]) == std::string("-v"))
      {
        //ofstreamPtr = OFStreamPtr(new std::ofstream("log.txt"));
        //console.SetOStream(ofstreamPtr.get());
        console.SetQuiet(false);
        console.SetVerbose(Con::all);
      }
    }

    console.Debug() << "slave start\n";

    CSubLatticeControler SLC;

    SLC.initMPI();
    SLC.run();
  }
  catch (std::runtime_error &e)
  {
    console.Error() << "EXCEPTION: " << e.what() << "\n";
    std::cerr << "EXCEPTION: " << e.what() << std::endl;
    throw;
  }
  catch (char *e)
  {
    console.Error() << "EXCEPTION: " << e << "\n";
    std::cerr << "EXCEPTION: " << e << std::endl;
    throw;
  }
  catch (...)
  {
    console.Error() << "EXCEPTION: UNKNOWN." << "\n";
    std::cerr << "EXCEPTION: UNKNOWN." << std::endl;
    throw;
  }
  MPI_Finalize();
  return 0;
}
